#**********************************************
#	This file was automatically generated 2015:07:24T11:36:00
#	
#	DO NOT EDIT THIS FILE -- Use Dialog Builder Tools to edit this file.
#***********************************************
#import pydevd; pydevd.settrace(suspend=False)
import vs

# control IDs
kOK                   = 1
kCancel               = 2
kTitle                = 3
kIDLabelText          = 4
kIDLabel              = 5
kWidthText            = 6
kWidth                = 7
kHeightText           = 8
kHeight               = 9
kElevationInWallText  = 10
kElevationInWall      = 11
kOpenTheWindow        = 12
kOpeningAngleText     = 13
kOpeningAngle         = 14
kLeafText             = 15
kLeaf                 = 16
kHasCurtains          = 17
kLedgeTypeText        = 18
kLedgeType            = 19
kLedgeMaterialText    = 20
kLedgeMaterial        = 21
kDrawTheCurts         = 22
kCurtsColorText       = 23
kCurtsColor           = 24
kPiecesText           = 25
kPieces               = 26
kOpacityText          = 27
kOpacitySlider        = 28

kPluginName           = 'Window with Curtains'

kMaxWidthOfPiece      = 4 #In inches

kEditRealNum          = 1
kEditRealAng          = 2
kEditRealDim          = 3

kDialogInitEvent      = 12255

class Constants:
    dialogId              = 0
    h                     = 0

def CreateDialog():
    # Alignment constants
    kRight                = 1
    kBottom               = 2
    kLeft                 = 3
    kColumn               = 4
    kResize               = 0
    kShift                = 1

    # dialog resource ID
    kTextStrTableID       = 3000

    def GetStr(ndx):
        result = vs.GetPluginString( kTextStrTableID + ndx - 1 )
        return result

    def GetHelpStr(ndx):
        result = vs.GetPluginString( kTextStrTableID + ndx + 27 )
        return result

    dialog = vs.CreateLayout( GetStr(kTitle), True, GetStr(kOK), GetStr(kCancel) )

    # create controls
    vs.CreateStaticText( dialog, kIDLabelText, GetStr(kIDLabelText), -1 )
    vs.CreateEditInteger( dialog, kIDLabel, 1, 26 )
    vs.CreateStaticText( dialog, kWidthText, GetStr(kWidthText), -1 )
    vs.CreateEditReal( dialog, kWidth, 3, 2.5, 26 )
    vs.CreateStaticText( dialog, kHeightText, GetStr(kHeightText), -1 )
    vs.CreateEditReal( dialog, kHeight, 3, 2.0, 26 )
    vs.CreateStaticText( dialog, kElevationInWallText, GetStr(kElevationInWallText), -1 )
    vs.CreateEditReal( dialog, kElevationInWall, 3, 1.2, 26 )
    vs.CreateCheckBox( dialog, kOpenTheWindow, GetStr(kOpenTheWindow) )
    vs.CreateStaticText( dialog, kOpeningAngleText, GetStr(kOpeningAngleText), -1 )
    vs.CreateEditReal( dialog, kOpeningAngle, 2, 45, 26 )
    vs.CreateStaticText( dialog, kLeafText, GetStr(kLeafText), -1 )
    vs.CreatePullDownMenu( dialog, kLeaf, 26 )
    vs.CreateCheckBox( dialog, kHasCurtains, GetStr(kHasCurtains) )
    vs.CreateStaticText( dialog, kLedgeTypeText, GetStr(kLedgeTypeText), -1 )
    vs.CreatePullDownMenu( dialog, kLedgeType, 16 )
    vs.CreateStaticText( dialog, kLedgeMaterialText, GetStr(kLedgeMaterialText), -1 )
    vs.CreatePullDownMenu( dialog, kLedgeMaterial, 26 )
    vs.CreateCheckBox( dialog, kDrawTheCurts, GetStr(kDrawTheCurts) )
    vs.CreateStaticText( dialog, kCurtsColorText, GetStr(kCurtsColorText), -1 )
    vs.CreateColorPopup( dialog, kCurtsColor, 16 )
    vs.CreateStaticText( dialog, kPiecesText, GetStr(kPiecesText), -1 )
    vs.CreateEditInteger( dialog, kPieces, 2, 16 )
    vs.CreateStaticText( dialog, kOpacityText, GetStr(kOpacityText), -1 )
    vs.CreateControl( dialog, kOpacitySlider, 3, '', 100)

    # set relations
    vs.SetFirstLayoutItem( dialog, kIDLabelText )
    vs.SetRightItem( dialog, kIDLabelText, kIDLabel, 2, 0 )
    vs.SetBelowItem( dialog, kIDLabelText, kWidthText, 0, 0 )
    vs.SetRightItem( dialog, kWidthText, kWidth, 2, 0 )
    vs.SetBelowItem( dialog, kWidthText, kHeightText, 0, 0 )
    vs.SetRightItem( dialog, kHeightText, kHeight, 2, 0 )
    vs.SetBelowItem( dialog, kHeightText, kElevationInWallText, 0, 0 )
    vs.SetRightItem( dialog, kElevationInWallText, kElevationInWall, 2, 0 )
    vs.SetBelowItem( dialog, kElevationInWallText, kOpenTheWindow, 0, 0 )
    vs.SetBelowItem( dialog, kOpenTheWindow, kOpeningAngleText, 2, 0 )
    vs.SetRightItem( dialog, kOpeningAngleText, kOpeningAngle, 2, 0 )
    vs.SetBelowItem( dialog, kOpeningAngleText, kLeafText, -2, 0 )
    vs.SetRightItem( dialog, kLeafText, kLeaf, 2, 0 )
    vs.SetBelowItem( dialog, kLeafText, kHasCurtains, 0, 0 )
    vs.SetBelowItem( dialog, kHasCurtains, kLedgeTypeText, 2, 0 )
    vs.SetRightItem( dialog, kLedgeTypeText, kLedgeType, 2, 0 )
    vs.SetBelowItem( dialog, kLedgeTypeText, kLedgeMaterialText, 0, 0 )
    vs.SetRightItem( dialog, kLedgeMaterialText, kLedgeMaterial, 2, 0 )
    vs.SetBelowItem( dialog, kLedgeMaterialText, kDrawTheCurts, -2, 0 )
    vs.SetBelowItem( dialog, kDrawTheCurts, kCurtsColorText, 2, 0 )
    vs.SetRightItem( dialog, kCurtsColorText, kCurtsColor, 2, 0 )
    vs.SetBelowItem( dialog, kCurtsColorText, kPiecesText, 0, 0 )
    vs.SetRightItem( dialog, kPiecesText, kPieces, 2, 0 )
    vs.SetBelowItem( dialog, kPiecesText, kOpacityText, 0, 0 )
    vs.SetBelowItem( dialog, kOpacityText, kOpacitySlider, 0, 0 )

    # set alignments
    vs.AlignItemEdge( dialog, kIDLabel, kColumn, 5, kShift );
    vs.AlignItemEdge( dialog, kWidth, kColumn, 5, kShift );
    vs.AlignItemEdge( dialog, kHeight, kColumn, 5, kShift );
    vs.AlignItemEdge( dialog, kElevationInWall, kColumn, 5, kShift );
    vs.AlignItemEdge( dialog, kOpeningAngle, kColumn, 5, kShift );
    vs.AlignItemEdge( dialog, kLeaf, kColumn, 5, kShift );
    vs.AlignItemEdge( dialog, kLedgeType, kColumn, 5, kShift );
    vs.AlignItemEdge( dialog, kLedgeMaterial, kColumn, 5, kShift );
    vs.AlignItemEdge( dialog, kCurtsColor, kColumn, 5, kShift );
    vs.AlignItemEdge( dialog, kPieces, kColumn, 5, kShift );
    vs.AlignItemEdge( dialog, kOpacitySlider, kColumn, 5, kResize );

    # set help strings
    vs.SetHelpText(dialog,kOK,GetStr(kOK))
    vs.SetHelpText(dialog,kCancel,GetStr(kCancel))
    
    cnt = 4
    while ( cnt <= 28 ):
        vs.SetHelpText( dialog, cnt, GetHelpStr(cnt) )
        cnt += 1

    return dialog

#-------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------
def Dialog(handle):
    Constants.h = handle;
    Constants.dialogId = CreateDialog()
    vs.RunLayoutDialog(Constants.dialogId,DialogHandler)
    
def DialogHandler(item, data):
    if item == kDialogInitEvent:
        SetupDialog()
        
    elif item == kWidth or item == kHeight or item == kElevationInWall or item == kOpeningAngle:
        CheckData()
        
    elif item == kOpenTheWindow or item == kHasCurtains or item == kDrawTheCurts or item == kLeaf:    
        index = vs.GetSelectedChoiceIndex(Constants.dialogId, kLeaf, 0)
        hasLeaf = not(index == 0)
        
        EnableItems(hasLeaf, vs.GetBooleanItem(Constants.dialogId,kOpenTheWindow),vs.GetBooleanItem(Constants.dialogId,kHasCurtains),vs.GetBooleanItem(Constants.dialogId,kDrawTheCurts))
        
    elif item == kOpacitySlider:
        text = vs.GetPluginString(3054)
        text += ' ('
        text += str(data)
        text +='%): '
        
        vs.SetItemText(Constants.dialogId,kOpacityText,text)
        
    elif item == kOK:
        #The ok button of the dialog has been clicked
        OnOK()
        
#-------------------------------------------------------------------------------------
def SetupDialog():
    for i in range(1,6):
        vs.AddChoice(Constants.dialogId,kLeaf,vs.GetPluginString(4000+i),i-1)
        
    vs.AddChoice(Constants.dialogId,kLedgeType,vs.GetPluginString(4006),0)
    vs.AddChoice(Constants.dialogId,kLedgeType,vs.GetPluginString(4007),1)
    
    vs.AddChoice(Constants.dialogId,kLedgeMaterial,vs.GetPluginString(4008),0)
    vs.AddChoice(Constants.dialogId,kLedgeMaterial,vs.GetPluginString(4009),1)
    vs.AddChoice(Constants.dialogId,kLedgeMaterial,vs.GetPluginString(4010),2)
    
    fraction, display, format, upi, name, squareName = vs.GetUnits()
    
    #######################################################
    value = vs.GetRField(Constants.h,kPluginName,'IDLabel')
    vs.SetEditInteger(Constants.dialogId, kIDLabel, vs.Str2Num(value))
    #######################################################    
    value = vs.GetRField(Constants.h,kPluginName,'Width')
    
    inches = 0
    if(format == 2 or format == 3):
         
        index = value.find("'")
        if index > -1:
            splitVal = value.split("'")
            inches += vs.Str2Num(splitVal[0])*12.0
             
            str = splitVal[1]
            index = str.find(name)
            if index > -1:
                str = str.replace(name, "")
                value = vs.Str2Num(str)
                inches += value
         
        else:
            index = value.find(name)
            if index > -1:
                value = value.replace(name,"")
                value = vs.Str2Num(value)
                inches += value
    else:
        index = value.find(name)
        if index > -1:
            value = value.replace(name, "")
            
        inches = vs.Str2Num(value)
    
    vs.SetEditReal(Constants.dialogId,kWidth,kEditRealDim,inches)
    #######################################################    
    value = vs.GetRField(Constants.h,kPluginName,'Height')
    
    inches = 0
    if(format == 2 or format == 3):
         
        index = value.find("'")
        if index > -1:
            splitVal = value.split("'")
            inches += vs.Str2Num(splitVal[0])*12.0
             
            str = splitVal[1]
            index = str.find(name)
            if index > -1:
                str = str.replace(name, "")
                value = vs.Str2Num(str)
                inches += value
         
        else:
            index = value.find(name)
            if index > -1:
                value = value.replace(name,"")
                value = vs.Str2Num(value)
                inches += value
    else:
        index = value.find(name)
        if index > -1:
            value = value.replace(name, "")
            
        inches = vs.Str2Num(value)
    
    vs.SetEditReal(Constants.dialogId,kHeight,kEditRealDim,inches)
    #######################################################    
    value = vs.GetRField(Constants.h,kPluginName,'ElvInWall')
    
    inches = 0
    if(format == 2 or format == 3):
         
        index = value.find("'")
        if index > -1:
            splitVal = value.split("'")
            inches += vs.Str2Num(splitVal[0])*12.0
             
            str = splitVal[1]
            index = str.find(name)
            if index > -1:
                str = str.replace(name, "")
                value = vs.Str2Num(str)
                inches += value
         
        else:
            index = value.find(name)
            if index > -1:
                value = value.replace(name,"")
                value = vs.Str2Num(value)
                inches += value
    else:
        index = value.find(name)
        if index > -1:
            value = value.replace(name, "")
            
        inches = vs.Str2Num(value)
    
    vs.SetEditReal(Constants.dialogId,kElevationInWall,kEditRealDim,inches)
    #######################################################    
    value = vs.GetRField(Constants.h, kPluginName, 'OpenTheWindow')
    vs.SetBooleanItem(Constants.dialogId, kOpenTheWindow   ,value =='True')
    #######################################################    
    value = vs.GetRField(Constants.h,kPluginName,'OpeningAngle')
    newNumber = vs.Str2Num(value)
    vs.SetEditReal(Constants.dialogId, kOpeningAngle, kEditRealAng,newNumber)  
    #######################################################    
    leafType = vs.GetRField(Constants.h,kPluginName,'Leaf')
    if leafType == 'None':
        vs.SelectChoice(Constants.dialogId, kLeaf, 0, True)
    elif leafType == '1(no glass)':
        vs.SelectChoice(Constants.dialogId, kLeaf, 1, True)
    elif leafType == '1(glass)':
        vs.SelectChoice(Constants.dialogId, kLeaf, 2, True)
    elif leafType == '2(no glass)':
        vs.SelectChoice(Constants.dialogId, kLeaf, 3, True)
    else:
        vs.SelectChoice(Constants.dialogId, kLeaf, 4, True)
    #######################################################        
    value = vs.GetRField(Constants.h,kPluginName,'HasCurts')
    vs.SetBooleanItem(Constants.dialogId, kHasCurtains, value =='True')
    #######################################################    
    ledgeType = vs.GetRField(Constants.h,kPluginName,'LedgeType')
    if ledgeType == 'Attach to wall':
        vs.SelectChoice(Constants.dialogId,kLedgeType,0,True)
    else:
        vs.SelectChoice(Constants.dialogId,kLedgeType,1,True)
    #######################################################              
    ledgeMaterial = vs.GetRField(Constants.h,kPluginName,'LedgeMaterial')
    if ledgeMaterial == 'Wood':
        vs.SelectChoice(Constants.dialogId,kLedgeMaterial,0,True)
    elif ledgeMaterial == 'Plastic':
        vs.SelectChoice(Constants.dialogId,kLedgeMaterial,1,True)
    else:
        vs.SelectChoice(Constants.dialogId,kLedgeMaterial,2,True)
    #######################################################        
    value = vs.GetRField(Constants.h,kPluginName,'DrawTheCurts')
    vs.SetBooleanItem(Constants.dialogId,kDrawTheCurts,value == 'True')
    #######################################################    
    colorIndex = vs.GetRField(Constants.h, kPluginName, '__CustomColor')
    vs.SetColorChoice(Constants.dialogId,kCurtsColor,vs.Str2Num(colorIndex))
    #######################################################    
    value = vs.GetRField(Constants.h,kPluginName,'Pieces')
    newNumber = vs.Str2Num(value)
    vs.SetEditInteger(Constants.dialogId, kPieces, newNumber)
    #######################################################    
    opacityText = vs.GetRField(Constants.h,kPluginName,'Opacity')
    vs.SetControlData(Constants.dialogId,kOpacitySlider,vs.Str2Num(opacityText))
    #######################################################    
    text = vs.GetPluginString(3054)
    text += ' ('
    text += opacityText
    text +='%): '
        
    vs.SetItemText(Constants.dialogId,kOpacityText,text)
    
    #######################################################
    hasCurtain = vs.GetBooleanItem(Constants.dialogId,kHasCurtains)
    drawTheCurtain = vs.GetBooleanItem(Constants.dialogId,kDrawTheCurts)
    
    index = vs.GetSelectedChoiceIndex(Constants.dialogId, kLeaf, 0)
    hasLeaf = not(index == 0)
    
    EnableItems(hasLeaf, vs.GetBooleanItem(Constants.dialogId,kOpenTheWindow), hasCurtain, drawTheCurtain)
    vs.SetSliderLiveUpdate(Constants.dialogId, kOpacitySlider, True)
    

#-------------------------------------------------------------------------------------
def EnableItems(hasLeaf,isToBeOpened,hasCurts,CurtsToBeDrawn):
     #For the opening angle edit box
    vs.EnableItem(Constants.dialogId,kOpenTheWindow,hasLeaf)
    vs.EnableItem(Constants.dialogId,kOpeningAngle,isToBeOpened and hasLeaf)
    
    #for the curtains settings
    vs.EnableItem(Constants.dialogId,kLedgeType,hasCurts)
    vs.EnableItem(Constants.dialogId,kLedgeMaterial,hasCurts)
    vs.EnableItem(Constants.dialogId,kDrawTheCurts,hasCurts)
    
    vs.EnableItem(Constants.dialogId,kCurtsColor,hasCurts and CurtsToBeDrawn)
    vs.EnableItem(Constants.dialogId,kPieces,hasCurts and CurtsToBeDrawn)
    vs.EnableItem(Constants.dialogId,kOpacitySlider,hasCurts and CurtsToBeDrawn)
    
#-------------------------------------------------------------------------------------
def CheckData():
    global windowWidth
    fraction, display, format, upi, name, squareName = vs.GetUnits()
    
    ok, val = vs.GetEditInteger(Constants.dialogId,kIDLabel)
    if val < 0:
        vs.SetEditInteger(Constants.dialogId, kIDLabel, 1)
        
    ok, val = ok,val= vs.GetEditReal(Constants.dialogId, kWidth, kEditRealDim)
    if val <= 0:
        vs.SetEditReal(Constants.dialogId, kWidth, kEditRealDim, 1)
        
    ok, val = vs.GetEditReal(Constants.dialogId,kHeight,kEditRealDim)
    if val < 0:
        vs.SetEditReal(Constants.dialogId, kHeight, kEditRealDim, 1)

    ok, val = vs.GetEditReal(Constants.dialogId, kElevationInWall, kEditRealDim)
    if val < 0:
        vs.SetEditReal(Constants.dialogId, kElevationInWall, kEditRealDim, 1)
        
    ok, val = vs.GetEditReal(Constants.dialogId, kOpeningAngle, kEditRealAng)
    if val < 0:
        vs.SetEditReal(Constants.dialogId, kOpeningAngle, kEditRealAng, 0)
    elif val > 90:
        vs.SetEditReal(Constants.dialogId, kOpeningAngle, kEditRealAng, 90)
        
def OnOK():
    ##Must check!!!
    global windowWidth
    fraction, display, format, upi, name, squareName = vs.GetUnits()
    #######################################################    
    ok,val = vs.GetEditInteger(Constants.dialogId,kIDLabel)
    vs.SetRField(Constants.h, kPluginName, 'IDLabel', val.__str__())
    #######################################################
    ok,val= vs.GetEditReal(Constants.dialogId, kWidth, kEditRealDim)
    windowWidth = val
    vs.SetRField(Constants.h,kPluginName, 'Width', val.__str__())
    #######################################################    
    ok,val = vs.GetEditReal(Constants.dialogId,kHeight,kEditRealDim)
    vs.SetRField(Constants.h,kPluginName, 'Height', val.__str__())
    #######################################################    
    ok,val = vs.GetEditReal(Constants.dialogId,kElevationInWall,kEditRealDim)
    vs.SetRField(Constants.h,kPluginName, 'ElvInWall', val.__str__())
    #######################################################    
    val = vs.GetBooleanItem(Constants.dialogId, kOpenTheWindow)
    vs.SetRField(Constants.h,kPluginName, 'OpenTheWindow', val.__str__())
    #######################################################   
    ok,val = vs.GetEditReal(Constants.dialogId,kOpeningAngle,kEditRealAng)
    vs.SetRField(Constants.h,kPluginName, 'OpeningAngle', val.__str__())
    #######################################################    
    index = vs.GetSelectedChoiceIndex(Constants.dialogId, kLeaf, 0)
    if(index == 0):
        vs.SetRField(Constants.h,kPluginName,'Leaf','None')
    elif(index == 1):
        vs.SetRField(Constants.h,kPluginName,'Leaf','1(no glass)')
    elif(index == 2):
        vs.SetRField(Constants.h,kPluginName,'Leaf','1(glass)')
    elif(index == 3):
        vs.SetRField(Constants.h,kPluginName,'Leaf','2(no glass)')
    else:
        vs.SetRField(Constants.h,kPluginName,'Leaf','2(glass)')
    #######################################################    
    val = vs.GetBooleanItem(Constants.dialogId,kHasCurtains)
    vs.SetRField(Constants.h,kPluginName,'HasCurts',val.__str__())
    #######################################################    
    index = vs.GetSelectedChoiceIndex(Constants.dialogId,kLedgeType,0)
    if(index == 0):
        vs.SetRField(Constants.h,kPluginName,'LedgeType','Attach to wall')
    else:
        vs.SetRField(Constants.h,kPluginName,'LedgeType','Attach to ceiling')
    #######################################################        
    index = vs.GetSelectedChoiceIndex(Constants.dialogId,kLedgeMaterial,0)
    if(index == 0):
        vs.SetRField(Constants.h,kPluginName,'LedgeMaterial','Wood')
    elif(index == 1):
        vs.SetRField(Constants.h,kPluginName,'LedgeMaterial','Plastic')
    else:
        vs.SetRField(Constants.h,kPluginName,'LedgeMaterial','Metal')
    #######################################################    
    val = vs.GetBooleanItem(Constants.dialogId,kDrawTheCurts)
    vs.SetRField(Constants.h,kPluginName,'DrawTheCurts',val.__str__())
    #######################################################
    colorIndex = vs.GetColorChoice(Constants.dialogId, kCurtsColor)
    colorText = str(colorIndex)
    vs.SetRField(Constants.h,kPluginName,'__CustomColor',colorIndex)
    vs.SetRField(Constants.h,kPluginName,'__PrevCustomColor',colorIndex)
    
    #######################################################
    if colorIndex == 256:
        vs.SetRField(Constants.h,kPluginName,'CurtsColor','White')
    elif colorIndex == 257:
        vs.SetRField(Constants.h,kPluginName,'CurtsColor','Black')
    else:
        vs.SetRField(Constants.h,kPluginName,'CurtsColor','Custom Color')
    ##########################
    
    ok,val = vs.GetEditInteger(Constants.dialogId,kPieces)
    ########### Check for correct set value of the pieces: min 4" 
    #inches per unit = 1/upi
    #max width of one piece of curtain = 4 inhes
    inchesPerUnit = 1/upi
    windowWidth = windowWidth*inchesPerUnit
    maxPieces = windowWidth // kMaxWidthOfPiece 
    
    if val > maxPieces:
        val = maxPieces
    vs.SetRField(Constants.h,kPluginName,'Pieces',val.__str__())
    #######################################################    
    val = vs.GetControlData(Constants.dialogId,kOpacitySlider)
    vs.SetRField(Constants.h,kPluginName,'Opacity',val.__str__())
    
