#   Copyright (c) Nemetschek North America, Inc. 2014.
#   All Rights Reserved.

#  **********************************************
# 	This file was automatically generated
# 	
# 	DO NOT EDIT THIS FILE -- edit the source database and re-generate this file.
# ***********************************************/


# This file contains definitions for functions inside vs module
# Here all the functions are empty because this file is used just to provide help
# All the functions are implemented inside vectorworks
#
# This file must be used as help tool from the IDE so it can report information about the functions


def Abs(
		v  # REAL - Real number.
		):
	'''
		Python: REAL = vs.Abs(v)
		VectorScript: FUNCTION Abs(v:REAL) : REAL;
		
		Category: Math - General
		Function Abs returns the absolute value of the specified value.
	'''
	pass
	return 'REAL' # 


def Absolute():
	'''
		Python: vs.Absolute()
		VectorScript: PROCEDURE Absolute;
		
		Category: Command
		Sets the point designation method for VectorScript procedure calls. When this mode is active, all points specified in procedure calls are assumed to be coordinate locations within the document.
	'''
	pass


def AcquireExportPDFSettingsAndLocation(
		inbSeparateDocuments  # BOOLEAN -  
		):
	'''
		Python: BOOLEAN = vs.AcquireExportPDFSettingsAndLocation(inbSeparateDocuments)
		VectorScript: FUNCTION AcquireExportPDFSettingsAndLocation(inbSeparateDocuments:BOOLEAN) : BOOLEAN;
		
		Category: Command
		Asks the user for the Export PDF settings and the PDF file name (or folder name if the parameter is true).  This is intended to support Batch PDF Export.
	'''
	pass
	return 'BOOLEAN' # 


def ActiveClass():
	'''
		Python: STRING = vs.ActiveClass()
		VectorScript: FUNCTION ActiveClass : STRING;
		
		Category: Classes
		Returns the name of the active class of the document.
	'''
	pass
	return 'STRING' # 


def ActLayer():
	'''
		Python: HANDLE = vs.ActLayer()
		VectorScript: FUNCTION ActLayer : HANDLE;
		
		Category: Layers
		Function ActLayer returns a handle to the currently active layer in a document.
	'''
	pass
	return 'HANDLE' # 


def ActSSheet():
	'''
		Python: HANDLE = vs.ActSSheet()
		VectorScript: FUNCTION ActSSheet : HANDLE;
		
		Category: Worksheets
		Function ActSSheet returns the handle to the currently active worksheet.
	'''
	pass
	return 'HANDLE' # 


def ActSymDef():
	'''
		Python: HANDLE = vs.ActSymDef()
		VectorScript: FUNCTION ActSymDef : HANDLE;
		
		Category: Objects - Symbols
		Function ActSymDef returns a handle to the currently active symbol.
	'''
	pass
	return 'HANDLE' # 


def Add2DVertex(
		p         , # POINT             - The vertex to add to a polyline.                   
		vertexType, # INTEGER           - The type of the vertex it could be 0, 1, 2, 3 or 4.
		arcRadius   # REAL (Coordinate) - The arc radius if the vertex type is 3 or 4.       
		):
	'''
		Python: vs.Add2DVertex(p, vertexType, arcRadius)
		VectorScript: PROCEDURE Add2DVertex(pX, pY:REAL; vertexType:INTEGER; arcRadius:REAL (Coordinate));
		
		Category: Objects - Polys
		This procedure will add to a polyline a vertex defined by its position, its type(0 to 4) and the radius if type is 3 or 4. A vertex of type 4 should be followed and preceded by corner vertices. If the type is equal to 4, the point will be a middle point of an arc. In this case if the radius is not given (0) it will be computed.
	'''
	pass


def Add3DPt(
		p  # POINT3D - Location of 3D vertex.
		):
	'''
		Python: vs.Add3DPt(p)
		VectorScript: PROCEDURE Add3DPt(pX, pY, pZ:REAL);
		
		Category: Objects - 3D
		Procedure Add3DPt adds a vertex into a newly created 3D polygon.
		Calls to Add3DPt should be made between calls to BeginPoly3D, which initiates polygon creation, and EndPoly3D, which terminates polygon creation. A minimum of two vertices must be created to define a valid 3D polygon object, and calculations may be performed within the BeginPoly3D-EndPoly3D structure, providing additional options for vertex generation.
	'''
	pass


def AddAssociation(
		ioOwnerObj , # HANDLE  -  
		inKind     , # INTEGER -  
		ioTargetObj  # HANDLE  -  
		):
	'''
		Python: BOOLEAN = vs.AddAssociation(ioOwnerObj, inKind, ioTargetObj)
		VectorScript: FUNCTION AddAssociation(ioOwnerObj:HANDLE; inKind:INTEGER; ioTargetObj:HANDLE) : BOOLEAN;
		
		Category: Object Events
	'''
	pass
	return 'BOOLEAN' # 


def AddButtonMode(
		imageSpecifier  # DYNARRAY[] of CHAR - The string identifier for the image. It should be of the form "ResourceFileNameWithoutExtension/PathOfImageFile".
		):
	'''
		Python: vs.AddButtonMode(imageSpecifier)
		VectorScript: PROCEDURE AddButtonMode(imageSpecifier:DYNARRAY of CHAR);
		
		Category: Dialogs - Modern
		Adds an image button to the mode bar for a tool. Replaces vstAddButtonMode.
	'''
	pass


def AddCavity(
		pair            , # BOOLEAN           - Double line display mode.              
		leftOffDistance , # REAL (Coordinate) - Left edge offset from wall centerline. 
		rightOffDistance, # REAL (Coordinate) - Right edge offset from wall centerline.
		pairFill          # LONGINT           - Fill index for filled cavities.        
		):
	'''
		Python: vs.AddCavity(pair, leftOffDistance, rightOffDistance, pairFill)
		VectorScript: PROCEDURE AddCavity(pair:BOOLEAN; leftOffDistance:REAL (Coordinate); rightOffDistance:REAL (Coordinate); pairFill:LONGINT);
		
		Category: Objects - Walls
		Procedure AddCavity creates a wall cavity in a new wall object. The newly defined cavity becomes the default for all subsequently defined walls.
		To apply a bitmap fill pattern, use positive value corresponding to the index  of the bitmap pattern.  To apply a vector fill pattern, use the negative of the vector fill index (index * -1).
	'''
	pass


def AddChoice(
		dialogID   , # LONGINT - the dialog identifier given by CreateLayout or CreateResizableLayout
		componentID, # LONGINT - The identifier for the component that contains the choices.         
		choiceText , # STRING  - The text for the item that is about to be added.                    
		itemIndex    # INTEGER - The index after which the new item is to be added.                  
		):
	'''
		Python: vs.AddChoice(dialogID, componentID, choiceText, itemIndex)
		VectorScript: PROCEDURE AddChoice(dialogID:LONGINT; componentID:LONGINT; choiceText:STRING; itemIndex:INTEGER);
		
		Category: Dialogs - Modern
		Adds an item to the component's choices.
	'''
	pass


def AddCustomTexPart(
		obj     , # HANDLE  - The object to add a custom texture part to.                                       
		partID  , # LONGINT - The texture part ID.  Start at 100 to avoid conflicts with existing texture parts.
		partName  # STRING  - The texture part name, which will be shown in the texturing UI.                   
		):
	'''
		Python: vs.AddCustomTexPart(obj, partID, partName)
		VectorScript: PROCEDURE AddCustomTexPart(obj:HANDLE; partID:LONGINT; partName:STRING);
		
		Category: Textures
		This procedure adds a custom texture part with the specified ID and name to the object.  Use partID starting at 100 to avoid conflicts with existing texture parts.
	'''
	pass


def AddHole(
		objectToGetHole, # in/out HANDLE - A 2D object to be cut by [[p:2]].        
		holeTemplate     # HANDLE        - A 2D object to cut a hole out of [[p:1]].
		):
	'''
		Python: (BOOLEAN, objectToGetHole) = vs.AddHole(objectToGetHole, holeTemplate)
		VectorScript: FUNCTION AddHole(VAR objectToGetHole:HANDLE; holeTemplate:HANDLE) : BOOLEAN;
		
		Category: Objects - 2D
		AddHole uses a holeTemplate to create a hole inside objectToGetHole.  Upon success, objectToGetHole is converted to polyline.   holeTemplate is unchanged.
	'''
	pass
	return ( False  , # 
	         0       )


def AdditionalDefRecords():
	'''
		Python: vs.AdditionalDefRecords()
		VectorScript: PROCEDURE AdditionalDefRecords;
		
		Category: Spotlight
		Shows the Additional Default Records dialog.
	'''
	pass


def AddLBImage(
		dialogID    , # LONGINT - id of the dialog that contains the list browser
		componentID , # LONGINT - id of the list browser control                 
		resourceType, # INTEGER - type of image resource to be added             
		resourceID    # INTEGER - the resource ID of image to add                
		):
	'''
		Python: INTEGER = vs.AddLBImage(dialogID, componentID, resourceType, resourceID)
		VectorScript: FUNCTION AddLBImage(dialogID:LONGINT; componentID:LONGINT; resourceType:INTEGER; resourceID:INTEGER) : INTEGER;
		
		Category: Dialogs - Modern - Browser
		Adds specified image resource to image list.
		Currently only one resource type is supported: the 'ics8' resource.  This is a 16x16 color icon.  Pass a value of 1 for the resourceType argument to indicate this type.  Call SetVSResourceFile to specify a resource file that contains the icons.
	'''
	pass
	return 'INTEGER' # 


def AddLBOriginalName(
		dialogID    , # LONGINT - The id of the dialog.                                             
		componentID , # LONGINT - The id of the list browser.                                       
		originalName  # STRING  - The original name of the new item being added to the list browser.
		):
	'''
		Python: vs.AddLBOriginalName(dialogID, componentID, originalName)
		VectorScript: PROCEDURE AddLBOriginalName(dialogID:LONGINT; componentID:LONGINT; originalName:STRING);
		
		Category: Dialogs - Modern - Browser
		This function is called when hierarchical display is on and a new item is added to the list browser.
	'''
	pass


def AddLevelFromTemplate(
		storyHandle, # HANDLE  - The handle of the Story to add the new Story Level to.                     
		index        # INTEGER - The index of the Story Level Template to use when creating the Story Level.
		):
	'''
		Python: BOOLEAN = vs.AddLevelFromTemplate(storyHandle, index)
		VectorScript: FUNCTION AddLevelFromTemplate(storyHandle:HANDLE; index:INTEGER) : BOOLEAN;
		
		Category: Layers
		Adds a new Story Layer to the Story pointed to by 'storyHandle', using the Story Level Template at 'index' as a template.  The story must not already contain a Story Level with the same level type or elevation as the template.  If the template has a layer name set, a new layer will be created and associated with the new Story Level.
	'''
	pass
	return 'BOOLEAN' # Whether the Story Level was successfully created.


def AddListBoxTabStop(
		dialogID, # LONGINT - ID of the dialog           
		itemID  , # LONGINT - ID of the list box         
		tabStop   # INTEGER - The tab stop, in characters
		):
	'''
		Python: vs.AddListBoxTabStop(dialogID, itemID, tabStop)
		VectorScript: PROCEDURE AddListBoxTabStop(dialogID:LONGINT; itemID:LONGINT; tabStop:INTEGER);
		
		Category: Dialogs - Modern
		Adds a tab stop to a Layout Manager list box.  The last parameter is the tab stop, in characters.  This function should be called in the dialog handler, as opposed to the dialog definition procedure.  This function will clear all data in the list control.
	'''
	pass


def AddListBrowserImage(
		dialogID      , # LONGINT            - The dialog identifier given by the command to create the dialog.                                                 
		controlID     , # LONGINT            - The identifier of the control to be updated.                                                                     
		imageSpecifier  # DYNARRAY[] of CHAR - The string identifier for the image. It should be of the form "ResourceFileNameWithoutExtension/PathOfImageFile".
		):
	'''
		Python: INTEGER = vs.AddListBrowserImage(dialogID, controlID, imageSpecifier)
		VectorScript: FUNCTION AddListBrowserImage(dialogID:LONGINT; controlID:LONGINT; imageSpecifier:DYNARRAY of CHAR) : INTEGER;
		
		Category: Dialogs - Modern - Browser
		Adds an image to a list browser. Replaces AddLBImage.
	'''
	pass
	return 'INTEGER' # 


def AddObjectTo2DComp(
		objectHandle  , # HANDLE  - Symbol definition or plug-in object.             
		objToAddHandle, # HANDLE  - New object to be added to the 2D component group.
		component       # INTEGER - 2D component                                     
		):
	'''
		Python: BOOLEAN = vs.AddObjectTo2DComp(objectHandle, objToAddHandle, component)
		VectorScript: FUNCTION AddObjectTo2DComp(objectHandle:HANDLE; objToAddHandle:HANDLE; component:INTEGER) : BOOLEAN;
		
		Category: Objects - Custom
		Adds an object to the specified 2D component group of a symbol definition or plug-in object. Use Top/Plan if you want to add the the object into the main container of the symbol definition or plug-in object.
		Table - 2D components
		2D component		Constant
		Not Set			0
		Top			1
		Bottom			2
		Top and Bottom Cut	                3
		Front			4
		Back			5
		Front and Back Cut	                6
		Left			7
		Right			8
		Left and Right Cut	                9
		Top/Plan		               10
	'''
	pass
	return 'BOOLEAN' # Returns TRUE if the operation was successful. 


def AddPoint(
		p  # POINT - Coordinates of vertex.
		):
	'''
		Python: vs.AddPoint(p)
		VectorScript: PROCEDURE AddPoint(pX, pY:REAL);
		
		Category: Objects - Polys
		Procedure AddPoint adds a vertex point to a newly created polygon. AddPoint is designed to be used with BeginPoly and EndPoly to define new polygon objects via VectorScript.
	'''
	pass


def AddRadioMode(
		initialSetting , # INTEGER            -                                                                                                                  
		buttonCount    , # INTEGER            -                                                                                                                  
		imageSpecifier1, # DYNARRAY[] of CHAR - The string identifier for the image. It should be of the form "ResourceFileNameWithoutExtension/PathOfImageFile".
		imageSpecifier2, # DYNARRAY[] of CHAR - The string identifier for the image. It should be of the form "ResourceFileNameWithoutExtension/PathOfImageFile".
		imageSpecifier3, # DYNARRAY[] of CHAR - The string identifier for the image. It should be of the form "ResourceFileNameWithoutExtension/PathOfImageFile".
		imageSpecifier4, # DYNARRAY[] of CHAR - The string identifier for the image. It should be of the form "ResourceFileNameWithoutExtension/PathOfImageFile".
		imageSpecifier5, # DYNARRAY[] of CHAR - The string identifier for the image. It should be of the form "ResourceFileNameWithoutExtension/PathOfImageFile".
		imageSpecifier   # DYNARRAY[] of CHAR - The string identifier for the image. It should be of the form "ResourceFileNameWithoutExtension/PathOfImageFile".
		):
	'''
		Python: vs.AddRadioMode(initialSetting, buttonCount, imageSpecifier1, imageSpecifier2, imageSpecifier3, imageSpecifier4, imageSpecifier5, imageSpecifier)
		VectorScript: PROCEDURE AddRadioMode(initialSetting:INTEGER; buttonCount:INTEGER; imageSpecifier1:DYNARRAY of CHAR; imageSpecifier2:DYNARRAY of CHAR; imageSpecifier3:DYNARRAY of CHAR; imageSpecifier4:DYNARRAY of CHAR; imageSpecifier5:DYNARRAY of CHAR; imageSpecifier:DYNARRAY of CHAR);
		
		Category: Dialogs - Modern
		Adds a group of buttons with an image to the mode bar for a tool. Replaces vstAddRadioMode
	'''
	pass


def AddResourceToList(
		listID  , # LONGINT - an ID for a resource list created by the BuildResourceList command.
		resource  # HANDLE  - a resource to add to the resource list.                            
		):
	'''
		Python: LONGINT = vs.AddResourceToList(listID, resource)
		VectorScript: FUNCTION AddResourceToList(listID:LONGINT; resource:HANDLE) : LONGINT;
		
		Category: Document List Handling
		Adds the indicated resource to the specified resource list, if it is of the same type as the items already in the list.  Returns the index of the resource in the list or 0.
	'''
	pass
	return 'LONGINT' # 


def AddSolid(
		obj1, # HANDLE - Handle to source object for add operation.
		obj2  # HANDLE - Handle to source object for add operation.
		):
	'''
		Python: (INTEGER, newSolid) = vs.AddSolid(obj1, obj2)
		VectorScript: FUNCTION AddSolid(obj1:HANDLE; obj2:HANDLE; VAR newSolid:HANDLE) : INTEGER;
		
		Category: Objects - Solids
		Function AddSolid creates a new solid addition object from the referenced source objects. If the operation succeeds, the source objects will then be contained within the newSolid object, as the primitives which define the CSG.
	'''
	pass
	return ( 0      , # 
	         0       )


def AddStoryLevel(
		storyHandle, # HANDLE - The handle of the story that the new level should be added to.                 
		levelType  , # STRING - The level type of the new Story Level.  This cannot be blank.                  
		elevation  , # REAL   - The elevation of the new Story Level in the story.                             
		layerName    # STRING - The name of the layer to associate with the new Story Level.  This is optional.
		):
	'''
		Python: BOOLEAN = vs.AddStoryLevel(storyHandle, levelType, elevation, layerName)
		VectorScript: FUNCTION AddStoryLevel(storyHandle:HANDLE; levelType:STRING; elevation:REAL; layerName:STRING) : BOOLEAN;
		
		Category: Layers
		Adds a new Story Layer to the Story pointed to by 'storyHandle'.  There must not be another story level in this story that matches 'levelType' or 'elevation', or the function will fail.  If the layer 'layerName' already exists, it will be associated with the new Story Level.
	'''
	pass
	return 'BOOLEAN' # Whether the new Story Level was created and added.


def AddSurface(
		s1, # HANDLE - Handle to object.
		s2  # HANDLE - Handle to object.
		):
	'''
		Python: HANDLE = vs.AddSurface(s1, s2)
		VectorScript: FUNCTION AddSurface(s1:HANDLE; s2:HANDLE) : HANDLE;
		
		Category: Objects - 2D
		Creates a new surface object by combining the two referenced surface objects. If the combination is successful (if the objects overlap), it deletes the original surface objects and returns the handle of the resultant object.
	'''
	pass
	return 'HANDLE' # Returns a HANDLE to a new surface object.


def AddSymToWall(
		wallHd        , # HANDLE            - Handle to wall.                  
		offDistance   , # REAL (Coordinate) - Offset distance from wall start. 
		heightDistance, # REAL (Coordinate) - Elevation of symbol.             
		flip          , # BOOLEAN           - Flipped status of symbol.        
		right         , # BOOLEAN           - Left-right orientation of symbol.
		symbolName      # STRING            - Name of symbol to insert in wall.
		):
	'''
		Python: vs.AddSymToWall(wallHd, offDistance, heightDistance, flip, right, symbolName)
		VectorScript: PROCEDURE AddSymToWall(wallHd:HANDLE; offDistance:REAL (Coordinate); heightDistance:REAL (Coordinate); flip:BOOLEAN; right:BOOLEAN; symbolName:STRING);
		
		Category: Objects - Walls
		Procedure AddSymToWall inserts a specified symbol into the referenced wall.
	'''
	pass


def AddSymToWallEdge(
		h             , # HANDLE            - Handle to wall.                                    
		alongDistance , # REAL (Coordinate) - Offset distance from wall start of insertion point.
		heightDistance, # REAL (Coordinate) - Elevation of symbol.                               
		flip          , # BOOLEAN           - Flip orientation of symbol.                        
		right         , # BOOLEAN           - Left-right orientation of symbol.                  
		symbolName    , # STRING            - Name of symbol to be inserted.                     
		insertMode      # INTEGER           - Edge insertion mode.                               
		):
	'''
		Python: vs.AddSymToWallEdge(h, alongDistance, heightDistance, flip, right, symbolName, insertMode)
		VectorScript: PROCEDURE AddSymToWallEdge(h:HANDLE; alongDistance:REAL (Coordinate); heightDistance:REAL (Coordinate); flip:BOOLEAN; right:BOOLEAN; symbolName:STRING; insertMode:INTEGER);
		
		Category: Objects - Walls
		Procedure AddSymToWallEdge inserts a symbol in the referenced wall using the specified parameters to define placement.
	'''
	pass


def AddTileGeometryObject(
		tileHandle  , # HANDLE - The handle to the tile resource.
		objectHandle  # HANDLE - The handle to the object to add.
		):
	'''
		Python: BOOLEAN = vs.AddTileGeometryObject(tileHandle, objectHandle)
		VectorScript: FUNCTION AddTileGeometryObject(tileHandle:HANDLE; objectHandle:HANDLE) : BOOLEAN;
		
		Category: Document Attributes
		Adds the specified object to the specified tile resource.
	'''
	pass
	return 'BOOLEAN' # TRUE if a valid object was successfully added; FALSE otherwise.


def AddToPIOStyleEdit(
		hObj       , # HANDLE  - Handle to a plug-in object or plug-in object style                                                    
		keyName    , # STRING  - Universal name of parameter or iother item to add to the edit style map list                          
		editType   , # INTEGER - 1 - Add to edit list 2 - Remove from edit list                                                        
		displayName  # STRING  - The display name to use in the style map dialog. If an empy string is passed the keyName will be used.
		):
	'''
		Python: BOOLEAN = vs.AddToPIOStyleEdit(hObj, keyName, editType, displayName)
		VectorScript: FUNCTION AddToPIOStyleEdit(hObj:HANDLE; keyName:STRING; editType:INTEGER; displayName:STRING) : BOOLEAN;
		
		Category: Objects - Custom
		Adds an item to a plug-in style's default edit list. This is only used by objects that use the default edit style dialog.
		By default, only those parameters shown in the object info palette will be listed in the edit style mapping dialg. Pass the following values to add or remove an item this list.
		Values:
		1 - Add to the edit style map dialog.
		2 - Remove from the edit stkyle map dialog.
		To remove an entry from this list use RemovePIOStyleEdit.
	'''
	pass
	return 'BOOLEAN' # TRUE if key is added to the list.[[BR]][[BR]]FALSE if hObj is NULL; if hObj is not a styled plug-in object or plug-in style[[BR]]FALSE if item already appear in list. Use RemoveFromPluginStyleEditList first.


def AddToPluginStyle(
		hSymDef  , # HANDLE  - Handle to a symbol definition containing a plug-in style.                           
		itemName , # STRING  - Name of new item to add.                                                            
		styleType  # INTEGER - Style type for new item. 0 sets the item to By Instance 1 sets the item to By style.
		):
	'''
		Python: BOOLEAN = vs.AddToPluginStyle(hSymDef, itemName, styleType)
		VectorScript: FUNCTION AddToPluginStyle(hSymDef:HANDLE; itemName:STRING; styleType:INTEGER) : BOOLEAN;
		
		Category: Objects - Symbols
		Adds a new item to a plug-in style map.
	'''
	pass
	return 'BOOLEAN' # TRUE if the item was added to the plug-in style.[[BR]]FALSE if the symbol definition does not contain a plug-in style or the style alread contrains an item by the given name.


def AddVectorFillLayer(
		xStart    , # REAL    - X coordinate of fill origin.                                
		yStart    , # REAL    - Y coordinate of fill origin.                                
		xRepeat   , # REAL    - X coordinate of fill repeat origin.                         
		yRepeat   , # REAL    - Y coordinate of fill repeat origin.                         
		xOffset   , # REAL    - X coordinate of fill offset origin.                         
		yOffset   , # REAL    - Y coordinate of fill offset origin.                         
		dashFactor, # REAL    - Dash factor of layer(percentage of fill line that is solid).
		lineWeight, # INTEGER - Line weight of layer, in mils.                              
		colorIndex  # INTEGER - Pen color of layer.                                         
		):
	'''
		Python: vs.AddVectorFillLayer(xStart, yStart, xRepeat, yRepeat, xOffset, yOffset, dashFactor, lineWeight, colorIndex)
		VectorScript: PROCEDURE AddVectorFillLayer(xStart:REAL; yStart:REAL; xRepeat:REAL; yRepeat:REAL; xOffset:REAL; yOffset:REAL; dashFactor:REAL; lineWeight:INTEGER; colorIndex:INTEGER);
		
		Category: Hatches / Vector Fills
		Procedure AddVectorFillLayer is used to add layers to a vector fill definition. This procedure call should follow a call to BeginVectorFillN.
		The input parameters for a vector fill layer match the inputs from the right side of the Vectorworks hatch editor dialog.
	'''
	pass


def AddVertex3D(
		objectHd, # HANDLE  - Handle to object.           
		p         # POINT3D - Location of 3D vertex point.
		):
	'''
		Python: vs.AddVertex3D(objectHd, p)
		VectorScript: PROCEDURE AddVertex3D(objectHd:HANDLE; pX, pY, pZ:REAL);
		
		Category: Objects - 3D
		Procedure AddVertex3D adds a 3D vertex to the referenced 3D polygon object.
	'''
	pass


def AddVPAnnotationObject(
		viewportHandle  , # HANDLE -  
		annotationHandle  # HANDLE -  
		):
	'''
		Python: BOOLEAN = vs.AddVPAnnotationObject(viewportHandle, annotationHandle)
		VectorScript: FUNCTION AddVPAnnotationObject(viewportHandle:HANDLE; annotationHandle:HANDLE) : BOOLEAN;
		
		Category: Objects - Groups
		Adds the specified annotation object to the specified viewport.
	'''
	pass
	return 'BOOLEAN' # 


def AddWallBottomPeak(
		wallHd        , # HANDLE            - Handle to wall.                         
		offDistance   , # REAL (Coordinate) - Offset distance of peak from wall start.
		heightDistance  # REAL (Coordinate) - Height of peak.                         
		):
	'''
		Python: vs.AddWallBottomPeak(wallHd, offDistance, heightDistance)
		VectorScript: PROCEDURE AddWallBottomPeak(wallHd:HANDLE; offDistance:REAL (Coordinate); heightDistance:REAL (Coordinate));
		
		Category: Objects - Walls
		Adds a peak to the bottom of the referenced wall.
	'''
	pass


def AddWallPeak(
		wallHd        , # HANDLE            - Handle to wall.                 
		offDistance   , # REAL (Coordinate) - Offset distance from wall start.
		heightDistance  # REAL (Coordinate) - Elevation of wall peak.         
		):
	'''
		Python: vs.AddWallPeak(wallHd, offDistance, heightDistance)
		VectorScript: PROCEDURE AddWallPeak(wallHd:HANDLE; offDistance:REAL (Coordinate); heightDistance:REAL (Coordinate));
		
		Category: Objects - Walls
		Procedure AddWallPeak creates a wall peak in the referenced wall object.
	'''
	pass


def AddWSColumnOperator(
		worksheet   , # HANDLE  - Handle to worksheet.       
		databaseRow , # INTEGER - Database row to be queried.
		column      , # INTEGER - Column to be queried.      
		operatorType  # INTEGER - Operator type.             
		):
	'''
		Python: vs.AddWSColumnOperator(worksheet, databaseRow, column, operatorType)
		VectorScript: PROCEDURE AddWSColumnOperator(worksheet:HANDLE; databaseRow:INTEGER; column:INTEGER; operatorType:INTEGER);
		
		Category: Worksheets
		Adds database column operator to specified column.
	'''
	pass


def AdjustComponentPixelPos(
		nDialogID        , # LONGINT -  
		nComponentID     , # LONGINT -  
		nHorizontalPixels, # INTEGER -  
		nVerticalPixels    # INTEGER -  
		):
	'''
		Python: BOOLEAN = vs.AdjustComponentPixelPos(nDialogID, nComponentID, nHorizontalPixels, nVerticalPixels)
		VectorScript: FUNCTION AdjustComponentPixelPos(nDialogID:LONGINT; nComponentID:LONGINT; nHorizontalPixels:INTEGER; nVerticalPixels:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern
		Adjust the pixel width and height of the specified Layout Manager component.
	'''
	pass
	return 'BOOLEAN' # 


def AlertCritical(
		text  , # DYNARRAY[] of CHAR - The information to be displayed.                                         
		advice  # DYNARRAY[] of CHAR - The text to be added in a smaller font under the main information message
		):
	'''
		Python: vs.AlertCritical(text, advice)
		VectorScript: PROCEDURE AlertCritical(text:DYNARRAY of CHAR; advice:DYNARRAY of CHAR);
		
		Category: Dialogs - Predefined
		Informs the user of a serious problem that requires intervention or correction before work can continue.
	'''
	pass


def AlertInform(
		text      , # DYNARRAY[] of CHAR - The information to be displayed.                                          
		advice    , # DYNARRAY[] of CHAR - The text to be added in a smaller font under the main information message.
		minorAlert  # BOOLEAN            - The severity of the alert: minor(true) or major(false).                   
		):
	'''
		Python: vs.AlertInform(text, advice, minorAlert)
		VectorScript: PROCEDURE AlertInform(text:DYNARRAY of CHAR; advice:DYNARRAY of CHAR; minorAlert:BOOLEAN);
		
		Category: Dialogs - Predefined
		Displays an alert dialog which provides the user an information about the result of a command.  It offers no user choices.
	'''
	pass


def AlertInformDontShowAgain(
		text      , # DYNARRAY[] of CHAR - The information to be displayed.                                                                                                                                                                                                                    
		advice    , # DYNARRAY[] of CHAR - The text to be added in a smaller font under the main information message.                                                                                                                                                                          
		minorAlert, # BOOLEAN            - The severity of the alert: minor(true) or major(false).                                                                                                                                                                                             
		arrOptions  # ARRAY              - ARRAY [1..3] OF STRING; arrOpt[1] - Saved setting category to save checkbox value arrOpt[2] - Saved setting item to save checkbox value  arrOpt[3] - Specify a string to use in overriding the default 'Dont show this dialog again' checkbox string
		):
	'''
		Python: vs.AlertInformDontShowAgain(text, advice, minorAlert, arrOptions)
		VectorScript: PROCEDURE AlertInformDontShowAgain(text:DYNARRAY of CHAR; advice:DYNARRAY of CHAR; minorAlert:BOOLEAN; arrOptions:ARRAY);
		
		Category: Dialogs - Predefined
		Displays an alert dialog which provides the user an information about the result of a command with an option to not show the dialog again.  It offers no user choices.
		The parameter 'arrOptions' is of type ARRAY [1..3] OF STRING;
		arrOpt[1] - Saved setting category to save checkbox value
		arrOpt[2] - Saved setting item to save checkbox value
		arrOpt[3] - Specify the string to use in overriding the default 'Dont show this dialog again' checkbox string
	'''
	pass


def AlertQuestion(
		question          , # DYNARRAY[] of CHAR - The question to display                                                                                                                                                                                               
		advice            , # DYNARRAY[] of CHAR - The text to be added in a smaller font under the main information/message                                                                                                                                             
		defaultButton     , # INTEGER            - Specifies which button is to be made the default[[BR]]0:	the negative button is the default[[BR]]1:	the positive button is the default[[BR]]2:	custom button A is the default [[BR]]3:	custom button B is the default 
		OKOverrideText    , # DYNARRAY[] of CHAR - Specifies a string to use in overriding the 'OK' string                                                                                                                                                               
		CancelOverrideText, # DYNARRAY[] of CHAR - Specifies a string to use in overriding the 'Cancel' string                                                                                                                                                           
		customButtonAText , # DYNARRAY[] of CHAR - Specifies a string to use for an optional custom button A                                                                                                                                                             
		customButtonBText   # DYNARRAY[] of CHAR - Specifies a string to use for a second optional custom button B                                                                                                                                                       
		):
	'''
		Python: INTEGER = vs.AlertQuestion(question, advice, defaultButton, OKOverrideText, CancelOverrideText, customButtonAText, customButtonBText)
		VectorScript: FUNCTION AlertQuestion(question:DYNARRAY of CHAR; advice:DYNARRAY of CHAR; defaultButton:INTEGER; OKOverrideText:DYNARRAY of CHAR; CancelOverrideText:DYNARRAY of CHAR; customButtonAText:DYNARRAY of CHAR; customButtonBText:DYNARRAY of CHAR) : INTEGER;
		
		Category: Dialogs - Predefined
		Displays an alert dialog which alerts the user to a condition or situation that requires the user's decision and input before preceding; such as an impending action with potentially destructive or irreversible consequences. The message should be in the form of a question.
	'''
	pass
	return 'INTEGER' # Return Values[[BR]]0:  the negative button was hit[[BR]]1:  the positive button was hit[[BR]]2:  custom button A was hit[[BR]]3:  custom button B was hit


def AlertQuestionDontShowAgain(
		question          , # DYNARRAY[] of CHAR - The question to display                                                                                                                                                                                                                                         
		advice            , # DYNARRAY[] of CHAR - The text to be added in a smaller font under the main information/message                                                                                                                                                                                       
		defaultButton     , # INTEGER            - Specifies which button is to be made the default[[BR]]0:	the negative button is the default[[BR]]1:	the positive button is the default[[BR]]2:	custom button A is the default [[BR]]3:	custom button B is the default                                           
		OKOverrideText    , # DYNARRAY[] of CHAR - Specifies a string to use in overriding the 'OK' string                                                                                                                                                                                                         
		CancelOverrideText, # DYNARRAY[] of CHAR - Specifies a string to use in overriding the 'Cancel' string                                                                                                                                                                                                     
		customButtonAText , # DYNARRAY[] of CHAR - Specifies a string to use for an optional custom button A                                                                                                                                                                                                       
		customButtonBText , # DYNARRAY[] of CHAR - Specifies a string to use for a second optional custom button B                                                                                                                                                                                                 
		arrOptions          # ARRAY              - ARRAY [1..3] OF STRING;    arrOpt[1] - Saved setting category to save checkbox value    arrOpt[2] - Saved setting item to save checkbox value     arrOpt[3] - Specify a string to use in overriding the default 'Always do the selection action' checkbox string
		):
	'''
		Python: INTEGER = vs.AlertQuestionDontShowAgain(question, advice, defaultButton, OKOverrideText, CancelOverrideText, customButtonAText, customButtonBText, arrOptions)
		VectorScript: FUNCTION AlertQuestionDontShowAgain(question:DYNARRAY of CHAR; advice:DYNARRAY of CHAR; defaultButton:INTEGER; OKOverrideText:DYNARRAY of CHAR; CancelOverrideText:DYNARRAY of CHAR; customButtonAText:DYNARRAY of CHAR; customButtonBText:DYNARRAY of CHAR; arrOptions:ARRAY) : INTEGER;
		
		Category: Dialogs - Predefined
		Displays an alert dialog which alerts the user to a condition or situation that requires the user's decision and input before preceding; such as an impending action with potentially destructive or irreversible consequences with the option to always do the selected action and not show the dialog again. The message should be in the form of a question.
		The parameter 'arrOptions' is of type ARRAY [1..3] OF STRING;
		arrOpt[1] - Saved setting category to save checkbox value
		arrOpt[2] - Saved setting item to save checkbox value
		arrOpt[3] - Specify a string to use in overriding the default 'Always do the selection action' checkbox string
	'''
	pass
	return 'INTEGER' # Return Values[[BR]]0:  the negative button was hit[[BR]]1:  the positive button was hit[[BR]]2:  custom button A was hit[[BR]]3:  custom button B was hit


def AlertSetAlwaysDoVal(
		category, # DYNARRAY[] of CHAR - category name of the value.                                                                           
		item    , # DYNARRAY[] of CHAR - item name in the category.                                                                            
		value     # INTEGER            - new value for the default. Pass in -1 for the entry to be cleared out and the dialog to show up again.
		):
	'''
		Python: vs.AlertSetAlwaysDoVal(category, item, value)
		VectorScript: PROCEDURE AlertSetAlwaysDoVal(category:DYNARRAY of CHAR; item:DYNARRAY of CHAR; value:INTEGER);
		
		Category: Dialogs - Predefined
		Set the 'always do' value for the AlertQuestionDontShowAgain and AlertInformDontShowAgain standard dialogs.
	'''
	pass


def AlignDistribute2D(
		MenuAction      , # LONGINT -  
		AlignDist2DParms  # LONGINT -  
		):
	'''
		Python: vs.AlignDistribute2D(MenuAction, AlignDist2DParms)
		VectorScript: PROCEDURE AlignDistribute2D(MenuAction:LONGINT; AlignDist2DParms:LONGINT);
		
		Category: General Edit
		2D Object Alignment/Distribution
	'''
	pass


def AlignDistribute3D(
		MenuAction      , # LONGINT -  
		AlignDist3DParms  # LONGINT -  
		):
	'''
		Python: vs.AlignDistribute3D(MenuAction, AlignDist3DParms)
		VectorScript: PROCEDURE AlignDistribute3D(MenuAction:LONGINT; AlignDist3DParms:LONGINT);
		
		Category: General Edit
		3D Object Alignment/Distribution
	'''
	pass


def AlignItemEdge(
		dialogID , # LONGINT - The index of the dialog layout being defined.                         
		itemID   , # LONGINT - The index of the control item to be aligned.                          
		whichEdge, # LONGINT - The control edge to be aligned.                                       
		alignID  , # INTEGER - An arbitrary number used to identify the items to be aligned together.
		alignMode  # INTEGER - Alignment mode of the operation                                       
		):
	'''
		Python: vs.AlignItemEdge(dialogID, itemID, whichEdge, alignID, alignMode)
		VectorScript: PROCEDURE AlignItemEdge(dialogID:LONGINT; itemID:LONGINT; whichEdge:LONGINT; alignID:INTEGER; alignMode:INTEGER);
		
		Category: Dialogs - Modern
		Aligns the specified control item with other items having the same edge and alignment id values. To align several control items, call this function once for each item to be aligned using a common alignment id value.
		Right alignment of objects will use the object with the minimum pixel value as the alignment baseline. Bottom and left alignment of objects will use the object with the  maximum pixel value as the alignment baseline.
	'''
	pass


def AlrtDialog(
		message  # DYNARRAY[] of CHAR - The alert message to be displayed.
		):
	'''
		Python: vs.AlrtDialog(message)
		VectorScript: PROCEDURE AlrtDialog(message:DYNARRAY of CHAR);
		
		Category: Dialogs - Predefined
		Procedure AlrtDialog displays an alert dialog to the user.
	'''
	pass


def Ang2Vec(
		angleR, # REAL - The angle of the vector (in degrees).
		Length  # REAL - The length of the vector.            
		):
	'''
		Python: VECTOR = vs.Ang2Vec(angleR, Length)
		VectorScript: FUNCTION Ang2Vec(angleR:REAL; Length:REAL) : VECTOR;
		
		Category: Math - Vectors
		Returns a 2-dimensional vector that is defined by the specified polar angle and length values.
	'''
	pass
	return 'VECTOR' # Returns a 2-dimensional vector.


def AngBVec(
		v1, # VECTOR - First vector to be compared. 
		v2  # VECTOR - Second vector to be compared.
		):
	'''
		Python: REAL = vs.AngBVec(v1, v2)
		VectorScript: FUNCTION AngBVec(v1:VECTOR; v2:VECTOR) : REAL;
		
		Category: Math - Vectors
		Returns the positive angle between the two specified vectors, in the range of 0 180 degrees.
		When used with 3D vectors, the angle returned will be in a plane defined by the two vectors.
	'''
	pass
	return 'REAL' # Returns a REAL value which is the angle (in degrees) between the two vectors.


def AngDialog(
		request, # DYNARRAY[] of CHAR - Dialog user prompt string.    
		default  # DYNARRAY[] of CHAR - Default value for input field.
		):
	'''
		Python: REAL = vs.AngDialog(request, default)
		VectorScript: FUNCTION AngDialog(request:DYNARRAY of CHAR; default:DYNARRAY of CHAR) : REAL;
		
		Category: Dialogs - Predefined
		Function AngDialog displays a dialog box which requests the user to enter an angle value. The dialog automatically screens for valid numeric input, and will accept supported angle formats.
	'''
	pass
	return 'REAL' # 


def AngDialog3D(
		displayStr, # DYNARRAY[] of CHAR - Dialog user prompt string.    
		xStr      , # DYNARRAY[] of CHAR - Default value for input field.
		yStr      , # DYNARRAY[] of CHAR - Default value for input field.
		zStr        # DYNARRAY[] of CHAR - Default value for input field.
		):
	'''
		Python: (xAngleResult, yAngleResult, zAngleResult) = vs.AngDialog3D(displayStr, xStr, yStr, zStr)
		VectorScript: PROCEDURE AngDialog3D(displayStr:DYNARRAY of CHAR; xStr:DYNARRAY of CHAR; yStr:DYNARRAY of CHAR; zStr:DYNARRAY of CHAR; VAR xAngleResult:REAL; VAR yAngleResult:REAL; VAR zAngleResult:REAL);
		
		Category: Dialogs - Predefined
		Function AngDialog3D displays a dialog box which requests the user to enter three angle values. AngDialog3D will accept angle values in any supported angle format.
	'''
	pass
	return ( 0.0, 
	         0.0, 
	         0.0 )


def Angle(
		c  # CRITERIA - Search criteria.
		):
	'''
		Python: REAL = vs.Angle(c)
		VectorScript: FUNCTION Angle(c:CRITERIA) : REAL;
		
		Category: Criteria
		Returns the angle value of a line segment or an arc. If more than one line segment or arc matches the search criteria, the function will return the sum of the matching objects' angle values.
	'''
	pass
	return 'REAL' # If an object matches the search criteria but is not a line segment or an arc, the value 0(zero) is returned.


def Angle2Str(
		value  # REAL - The angle value.
		):
	'''
		Python: STRING = vs.Angle2Str(value)
		VectorScript: FUNCTION Angle2Str(value:REAL) : STRING;
		
		Category: Strings
		Convert an angle value from a real number to a string using the current document formatting.
	'''
	pass
	return 'STRING' # 


def AngularDim(
		startPt           , # POINT             - X-Y coordinates of dimension start point.                                             
		endPt             , # POINT             - X-Y coordinates of dimension end point                                                
		vert1             , # POINT             - X-Y coordinates of dimension arc center.                                              
		textOffsetDistance, # REAL (Coordinate) - Offset from dimension arc center (radius of the dimension arc).                       
		arrow             , # INTEGER           - Dimension arrowhead style flag.                                                       
		textFlag          , # INTEGER           - Dimension text style flag.                                                            
		posAngle            # REAL              - Position angle of dimension text(from start). Auto position text overrides this value.
		):
	'''
		Python: vs.AngularDim(startPt, endPt, vert1, textOffsetDistance, arrow, textFlag, posAngle)
		VectorScript: PROCEDURE AngularDim(startPtX, startPtY:REAL; endPtX, endPtY:REAL; vert1X, vert1Y:REAL; textOffsetDistance:REAL (Coordinate); arrow:INTEGER; textFlag:INTEGER; posAngle:REAL);
		
		Category: Dimensions
		Procedure AngularDim creates an angular dimension in the document.
		<I>Angular Dimension</I><P>
	'''
	pass


def Append(
		fileName  # DYNARRAY[] of CHAR - Name of file to open for writing.
		):
	'''
		Python: vs.Append(fileName)
		VectorScript: PROCEDURE Append(fileName:DYNARRAY of CHAR);
		
		Category: File I/O
		Procedure Append opens the specified file for writing and appends the data to the end of the file. Existing data in the file is NOT overwritten.
	'''
	pass


def AppendRoofEdge(
		theRoof           , # HANDLE            - Handle to roof.               
		edgePt            , # POINT             - Definition point of roof edge.
		slopeAngle        , # REAL              - Slope of roof edge.           
		projectionDistance, # REAL (Coordinate) - Eave overhang.                
		eaveHeightDistance  # REAL (Coordinate) - Eave height.                  
		):
	'''
		Python: vs.AppendRoofEdge(theRoof, edgePt, slopeAngle, projectionDistance, eaveHeightDistance)
		VectorScript: PROCEDURE AppendRoofEdge(theRoof:HANDLE; edgePtX, edgePtY:REAL; slopeAngle:REAL; projectionDistance:REAL (Coordinate); eaveHeightDistance:REAL (Coordinate));
		
		Category: Objects - Roofs
		Function AppendRoofEdge creates a new edge in the referenced roof object.
	'''
	pass


def ApplyCustomTexPart(
		srcObj , # HANDLE  - The source object from which to get the texture assignment and mapping.                                                     
		destObj, # HANDLE  - The dest object to apply the texture and mapping to.  The texture and mapping are applied to destObj_s Overall texture part.
		partID   # LONGINT - The custom texture part ID to apply from the src to the dest object.                                                        
		):
	'''
		Python: vs.ApplyCustomTexPart(srcObj, destObj, partID)
		VectorScript: PROCEDURE ApplyCustomTexPart(srcObj:HANDLE; destObj:HANDLE; partID:LONGINT);
		
		Category: Textures
		Applies the src object_s custom texture part partID to dest Overall part.  For example apply PIO texture partID 100 to extrude_s Overall part.  If the dest object does not support the src map type then a default mapping is used.
	'''
	pass


def ApplyLightInfoRecord(
		hSymboL, # HANDLE -  
		hObject  # HANDLE -  
		):
	'''
		Python: vs.ApplyLightInfoRecord(hSymboL, hObject)
		VectorScript: PROCEDURE ApplyLightInfoRecord(hSymboL:HANDLE; hObject:HANDLE);
		
		Category: Spotlight
		Apply Light Info Record from a symbol to an object.
	'''
	pass


def Arc(
		p1        , # POINT - Top left coordinate of bounding box of oval defining the arc.    
		p2        , # POINT - Bottom right coordinate of bounding box of oval defining the arc.
		StartAngle, # REAL  - Start angle of drawn arc.                                        
		ArcAngle    # REAL  - Sweep angle of drawn arc.                                        
		):
	'''
		Python: vs.Arc(p1, p2, StartAngle, ArcAngle)
		VectorScript: PROCEDURE Arc(p1X, p1Y:REAL; p2X, p2Y:REAL; StartAngle:REAL; ArcAngle:REAL);
		
		Category: Objects - 2D
		Procedure Arc creates an arc object, or a polyline object, in the active document. If p1 and p2 define a perfect square, an arc will be created, with its center point at the center of the square. If p1 and p2 define a rectangle, a polyline will be created which will represent the oval segment defined by the rectangle.
	'''
	pass


def ArcByCenter(
		x         , # REAL - X-coordinate of the center point
		y         , # REAL - Y-coordinate of the center point
		radius    , # REAL - Radius of the arc               
		startAngl , # REAL - Starting angle of the arc       
		sweepAngle  # REAL - Sweep angle of the arc          
		):
	'''
		Python: vs.ArcByCenter(x, y, radius, startAngl, sweepAngle)
		VectorScript: PROCEDURE ArcByCenter(x:REAL; y:REAL; radius:REAL; startAngl:REAL; sweepAngle:REAL);
		
		Category: Objects - 2D
		Creates an arc using a center point, the radius, a start angle, and a sweep.
	'''
	pass


def ArcCos(
		v  # REAL - Numeric value for which to find the cosine.
		):
	'''
		Python: REAL = vs.ArcCos(v)
		VectorScript: FUNCTION ArcCos(v:REAL) : REAL;
		
		Category: Math - General
		Function ArcCos returns the arccosine (in radians) of the specified value.
	'''
	pass
	return 'REAL' # 


def ArcSin(
		v  # REAL - Numeric value for which to find the sine.
		):
	'''
		Python: REAL = vs.ArcSin(v)
		VectorScript: FUNCTION ArcSin(v:REAL) : REAL;
		
		Category: Math - General
		Function ArcSin returns the arc sine (in radians) of the specified value.
	'''
	pass
	return 'REAL' # 


def ArcTan(
		v  # REAL - Numeric value for which to find the tangent.
		):
	'''
		Python: REAL = vs.ArcTan(v)
		VectorScript: FUNCTION ArcTan(v:REAL) : REAL;
		
		Category: Math - General
		Function ArcTan returns the arc tangent (in radians) of the specified value.
	'''
	pass
	return 'REAL' # 


def ArcTo(
		p             , # POINT             - Coordinates of vertex.
		radiusDistance  # REAL (Coordinate) - Radius of vertex arc. 
		):
	'''
		Python: vs.ArcTo(p, radiusDistance)
		VectorScript: PROCEDURE ArcTo(pX, pY:REAL; radiusDistance:REAL (Coordinate));
		
		Category: Objects - Polys
		Procedure ArcTo creates an arc vertex with a point of intersection at the specified coordinate point.
		The endpoints of the arc are tangent to the control segments which intersect at p. If a radius of 0 is passed as the parameter, the arc endpoints will be at the vertices preceding and following the arc spline vertex.
	'''
	pass


def Area(
		c  # CRITERIA - Search criteria.
		):
	'''
		Python: REAL = vs.Area(c)
		VectorScript: FUNCTION Area(c:CRITERIA) : REAL;
		
		Category: Criteria
		Returns the area of an object. If more than one object matches the search criteria, the function will return the sum of all the matching object areas.
	'''
	pass
	return 'REAL' # 


def Area2Str(
		value  # REAL - The area value.
		):
	'''
		Python: STRING = vs.Area2Str(value)
		VectorScript: FUNCTION Area2Str(value:REAL) : STRING;
		
		Category: Strings
		Convert an area value from a real number to a string using the current document formatting.
	'''
	pass
	return 'STRING' # 


def AreaN(
		c  # CRITERIA - Search criteria.
		):
	'''
		Python: REAL = vs.AreaN(c)
		VectorScript: FUNCTION AreaN(c:CRITERIA) : REAL;
		
		Category: Criteria
		Returns the area of an object. If more than one object matches the search criteria, the function will return the sum of all the matching object areas.
	'''
	pass
	return 'REAL' # 


def AreLBColumnLinesEnabled(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID  # LONGINT - id of the list browser control                 
		):
	'''
		Python: BOOLEAN = vs.AreLBColumnLinesEnabled(dialogID, componentID)
		VectorScript: FUNCTION AreLBColumnLinesEnabled(dialogID:LONGINT; componentID:LONGINT) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Determines if column lines are drawn.
	'''
	pass
	return 'BOOLEAN' # 


def AreLBRadioColumnLinesEnabled(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID, # LONGINT - id of the list browser control                 
		columnIndex  # INTEGER - the index of the column                        
		):
	'''
		Python: BOOLEAN = vs.AreLBRadioColumnLinesEnabled(dialogID, componentID, columnIndex)
		VectorScript: FUNCTION AreLBRadioColumnLinesEnabled(dialogID:LONGINT; componentID:LONGINT; columnIndex:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Determines if "column" lines are drawn between radio control items.
	'''
	pass
	return 'BOOLEAN' # 


def AreWorksheetGridLinesVisible(
		h  # HANDLE - Handle to worksheet.
		):
	'''
		Python: BOOLEAN = vs.AreWorksheetGridLinesVisible(h)
		VectorScript: FUNCTION AreWorksheetGridLinesVisible(h:HANDLE) : BOOLEAN;
		
		Category: Worksheets
		Returns true if the grid lines are enabled for the specified worksheet.
	'''
	pass
	return 'BOOLEAN' # 


def AssociateLayerWithStory(
		layer, # HANDLE - The Layer to associate.
		story  # HANDLE - The Story to associate.
		):
	'''
		Python: BOOLEAN = vs.AssociateLayerWithStory(layer, story)
		VectorScript: FUNCTION AssociateLayerWithStory(layer:HANDLE; story:HANDLE) : BOOLEAN;
		
		Category: Layers
		Associates a Layer with a Story. When a Layer is associated with a Story, the Layer's elevation is displayed relative to the Story elevation. If the elevation of the associated Story is changed, the elevation of the Layer changes with it.
	'''
	pass
	return 'BOOLEAN' # Whether the Layer was successfully associated with the Story. This will fail if there is already another Layer associated with the Story that has the same Layer Level Type as the Layer passed in.


def AssociateLinearDimension(
		h                  , # HANDLE  -  
		selectedObjectsMode  # BOOLEAN -  
		):
	'''
		Python: vs.AssociateLinearDimension(h, selectedObjectsMode)
		VectorScript: PROCEDURE AssociateLinearDimension(h:HANDLE; selectedObjectsMode:BOOLEAN);
		
		Category: Dimensions
		Associates a linear dimension with an object when the dimension's endpoints are coincident with objects in the drawing.  When selectedObjectsMode is true, only selected objects will be checked to see if they should be associated with the linear dimension.
	'''
	pass


def AttachDefaultTextureSpace(
		obj   , # HANDLE  - Handle to object.                           
		partID  # INTEGER - Part ID (pass 1 for non-supporting objects).
		):
	'''
		Python: vs.AttachDefaultTextureSpace(obj, partID)
		VectorScript: PROCEDURE AttachDefaultTextureSpace(obj:HANDLE; partID:INTEGER);
		
		Category: Textures
		Procedure AttachDefaultTextureSpace deletes any pre-existing space attached to the referenced object and creates a new one with the default object texture.
	'''
	pass


def AutoFitWSRowHeights(
		worksheet, # HANDLE  - Handle to worksheet    
		fromRow  , # INTEGER - Top row of row range   
		toRow      # INTEGER - Bottom row of row range
		):
	'''
		Python: vs.AutoFitWSRowHeights(worksheet, fromRow, toRow)
		VectorScript: PROCEDURE AutoFitWSRowHeights(worksheet:HANDLE; fromRow:INTEGER; toRow:INTEGER);
		
		Category: Worksheets
		Auto fit the height of rows to the content of the cells in the referenced worksheet.
		AutoFitWSRowHeights allows height for a range of rows to be auto fitted to the contents of cells. To auto fit the height of a single worksheet row, specify identical values for the top/bottom row range boundaries.
	'''
	pass


def AutoKey(
		):
	'''
		Python: (BOOLEAN, asciiCode) = vs.AutoKey()
		VectorScript: FUNCTION AutoKey(VAR asciiCode:LONGINT) : BOOLEAN;
		
		Category: User Interactive
		Function AutoKey returns TRUE if a non-modifier keyboard character has been continually depressed for longer than the system defined key repeat rate. If a keyboard character has been continually depressed, then ASCII code of the character is returned in parameter asciiCode.
	'''
	pass
	return ( False  , # 
	         0       )


def Backward():
	'''
		Python: vs.Backward()
		VectorScript: PROCEDURE Backward;
		
		Category: General Edit
		Procedure Backward moves the selected objects down one level in the onscreen object stacking order.
	'''
	pass


def BeginColumn(
		columnDistance  # REAL (Coordinate) - Height of column.
		):
	'''
		Python: vs.BeginColumn(columnDistance)
		VectorScript: PROCEDURE BeginColumn(columnDistance:REAL (Coordinate));
		
		Category: Objects - Architectural
		Procedure BeginColumn creates a column object in a Vectorworks document using 2D object creation procedure calls to define the "template" for the column object.
		After specifying object procedure calls to define the column, you should call EndGroup to complete the column definition and create the actual object.
	'''
	pass


def BeginContext():
	'''
		Python: vs.BeginContext()
		VectorScript: PROCEDURE BeginContext;
		
		Category: Utility
		Use this function in conjuction with EndContext to starts logging changes that are  made until the EndContext is reached.
	'''
	pass


def BeginFloor(
		thicknessDistance  # REAL (Coordinate) - Floor thickness.
		):
	'''
		Python: vs.BeginFloor(thicknessDistance)
		VectorScript: PROCEDURE BeginFloor(thicknessDistance:REAL (Coordinate));
		
		Category: Objects - Architectural
		Procedure BeginFloor creates a new floor object in a Vectorworks document. BeginFloor uses 2D object creation procedure calls to define the "template" for the object.
		After specifying object procedure calls to define the floor object, you should call EndGroup to complete the column definition and create the actual object.
	'''
	pass


def BeginFolder():
	'''
		Python: vs.BeginFolder()
		VectorScript: PROCEDURE BeginFolder;
		
		Category: Document List Handling
		Procedure BeginFolder creates a new symbol folder in a Vectorworks document. Any symbols or symbol folders created after the current call to BeginFolder will be nested inside the new symbol folder. A call to EndFolder will complete the creation of the symbol folder, which is then generated in the Vectorworks document.
		To name the new symbol folder, precede BeginFolder with a call to NameObject.
	'''
	pass


def BeginFolderN(
		type  # INTEGER - the type of resource the folder will contain
		):
	'''
		Python: vs.BeginFolderN(type)
		VectorScript: PROCEDURE BeginFolderN(type:INTEGER);
		
		Category: Document List Handling
		Procedure BeginFolderN creates a new resource folder of the indicated type in a Vectorworks document. Any resource or folder of that type created after the current call to BeginFolderN will be nested inside the new folder. A call to EndFolder will complete the creation of the folder, which is then generated in the Vectorworks document.
		To name the new folder, precede BeginFolderN with a call to NameObject.
	'''
	pass


def BeginGroup():
	'''
		Python: vs.BeginGroup()
		VectorScript: PROCEDURE BeginGroup;
		
		Category: Objects - Groups
		Procedure BeginGroup creates a new group object in a Vectorworks document. Procedure calls subsequent to BeginGroup and before EndGroup will be included in the new group object. BeginGroup may be called repeatedly to created nested groups of objects.
	'''
	pass


def BeginGroupN(
		groupHandle  # in/out HANDLE - The group handle to be used; if handle is initialized to nil a new group is created.
		):
	'''
		Python: groupHandle = vs.BeginGroupN(groupHandle)
		VectorScript: PROCEDURE BeginGroupN(VAR groupHandle:HANDLE);
		
		Category: Objects - Groups
		May be used to create objects in an existing group by passing a group handle; if a handle initialized to nil is passed a new group is created.
	'''
	pass
	return ( 0 )


def BeginMesh():
	'''
		Python: vs.BeginMesh()
		VectorScript: PROCEDURE BeginMesh;
		
		Category: Objects - 3D
		Procedure BeginMesh begins the efinition of a 3D mesh object in Vectorworks. Any 3D point or planar object call after BeginMesh will be included in the mesh object.
		A mesh object allows the user to select and manipulate each vertex within its wire-frame model.
	'''
	pass


def BeginModeButtonsText():
	'''
		Python: vs.BeginModeButtonsText()
		VectorScript: PROCEDURE BeginModeButtonsText;
		
		Category: User Interactive
		Creates a mode bar buttons help text.
	'''
	pass


def BeginMultDashConvert():
	'''
		Python: vs.BeginMultDashConvert()
		VectorScript: PROCEDURE BeginMultDashConvert;
		
		Category: Utility
		Used when a number of pseudo index to dash style conversion operations (or vice versa) are going to be performed.
		Use EndMultDashConvert when the conversions are complete.
	'''
	pass


def BeginMultipleDuplicate():
	'''
		Python: vs.BeginMultipleDuplicate()
		VectorScript: PROCEDURE BeginMultipleDuplicate;
		
		Category: Object Editing
		Use this function in conjunction with EndMultipleDuplicate to preserve constraints on multiple duplicated objects.
	'''
	pass


def BeginMXtrd(
		startDistance, # REAL (Coordinate) - Start distance from document ground plane.
		endDistance    # REAL (Coordinate) - End distance from document ground plane.  
		):
	'''
		Python: vs.BeginMXtrd(startDistance, endDistance)
		VectorScript: PROCEDURE BeginMXtrd(startDistance:REAL (Coordinate); endDistance:REAL (Coordinate));
		
		Category: Objects - 3D
		Procedure BeginMXtrd creates a multiple extrude object in a Vectorworks document. BeginMXtrd uses 2D object creation procedure calls to define the "template" for the object.
		You should call EndMXtrd after the object creation procedures to complete the definition and generate the object in the document.
		A multiple extrude object is a 3D object created from three or more 2D objects, which are used as defining shapes for the extruded object.
	'''
	pass


def BeginPoly():
	'''
		Python: vs.BeginPoly()
		VectorScript: PROCEDURE BeginPoly;
		
		Category: Objects - Polys
		Procedures BeginPoly creates a new polygon or polyline object in a Vectorworks document. When used with vertex creation procedure calls, BeginPoly and EndPoly() define the polygon object on a vertex by vertex basis.
		A minimum of two vertices must be created, and calculations may be performed within the creation structure between vertex calls, thus allowing additional flexibility in object generation.Hidden edges may be created by using use MoveTo() or Move() between vertex calls.
	'''
	pass


def BeginPoly3D():
	'''
		Python: vs.BeginPoly3D()
		VectorScript: PROCEDURE BeginPoly3D;
		
		Category: Objects - 3D
		Procedure BeginPoly3D creates a 3D polygon in the Vectorworks document. This procedure is used with Add3DPt and EndPoly3D to create 3D polygons. Any calls to the Add3DPt procedure after BeginPoly3D will be included in the 3D polygon.
	'''
	pass


def BeginRoof(
		p1          , # POINT             - Coordinates of roof axis start point.              
		p2          , # POINT             - Coordinates of roof axis end point.                
		upslope     , # POINT             - Coordinates of upslope definition point.           
		riseDistance, # REAL (Coordinate) - Rise distance.                                     
		runDistance , # REAL (Coordinate) - Run distance.                                      
		miter       , # INTEGER           - Edge miter style of roof.                          
		vertPart      # REAL              - Dimension of vertical miter for double miter style.
		):
	'''
		Python: vs.BeginRoof(p1, p2, upslope, riseDistance, runDistance, miter, vertPart)
		VectorScript: PROCEDURE BeginRoof(p1X, p1Y:REAL; p2X, p2Y:REAL; upslopeX, upslopeY:REAL; riseDistance:REAL (Coordinate); runDistance:REAL (Coordinate); miter:INTEGER; vertPart:REAL);
		
		Category: Objects - Roofs
		Procedure BeginRoof creates a simple roof object in a Vectorworks document.
		<I>3-D View of Roof</I><P>
	'''
	pass


def BeginSweep(
		startAngle   , # REAL              - Starting angle of the sweep.          
		arcAngle     , # REAL              - Angle of sweep.                       
		incAngle     , # REAL              - Increment of sweep.                   
		PitchDistance  # REAL (Coordinate) - Pitch (translation distance) of sweep.
		):
	'''
		Python: vs.BeginSweep(startAngle, arcAngle, incAngle, PitchDistance)
		VectorScript: PROCEDURE BeginSweep(startAngle:REAL; arcAngle:REAL; incAngle:REAL; PitchDistance:REAL (Coordinate));
		
		Category: Objects - 3D
		Procedure BeginSweep creates a three-dimensional sweep object in the Vectorworks document. A sweep object is a two-dimensional template object which has been rotated about a specified point to create a 3D object. For example, a circle of radius 1" that is swept about a point 2" to the right of the circles center wil create a sweep object resembling a donut, also known as a torus.
		The sweep increment may also be thought of as the spacing between the duplication of radial sweep mesh lines. The "pitch", or vertical distance, is the distance that the sweep object will travel for every 360  of rotation.  In sweep objects, the 2D template object may also be translated as it rotates, resulting in a "corkscrew" effect. The vertical movement is determined by the following equation: vertical movement = pitch * ArcAngle/360.
	'''
	pass


def BeginSym(
		symbolName  # STRING - Name of the new symbol.
		):
	'''
		Python: vs.BeginSym(symbolName)
		VectorScript: PROCEDURE BeginSym(symbolName:STRING);
		
		Category: Objects - Symbols
		Procedure BeginSym creates a new symbol definition ina Vectorworks document.
		Any objects created after a call to BeginSym will be included in the symbol definition. A call to EndSym will complete the creation of the symbol, which is then generated in the Vectorworks document.
	'''
	pass


def BeginVectorFillN(
		vectorFillName, # in/out STRING - Name of new vector fill pattern.           
		pageSpace     , # BOOLEAN       - Sets page or world space for vector fill.  
		rotateInWall  , # BOOLEAN       - Sets rotate in wall option for vector fill.
		colorIndex      # INTEGER       - Background color of vector fill.           
		):
	'''
		Python: vectorFillName = vs.BeginVectorFillN(vectorFillName, pageSpace, rotateInWall, colorIndex)
		VectorScript: PROCEDURE BeginVectorFillN(VAR vectorFillName:STRING; pageSpace:BOOLEAN; rotateInWall:BOOLEAN; colorIndex:INTEGER);
		
		Category: Hatches / Vector Fills
		Procedure BeginVectorFillN creates a new vector fill definition in a Vectorworks document. The value of vectorFillName will change only if the hatch name already exists.
	'''
	pass
	return ( 'string' )


def BeginXtrd(
		startDistance, # REAL (Coordinate) - Start distance from document ground plane.
		endDistance    # REAL (Coordinate) - End distance from document ground plane.  
		):
	'''
		Python: vs.BeginXtrd(startDistance, endDistance)
		VectorScript: PROCEDURE BeginXtrd(startDistance:REAL (Coordinate); endDistance:REAL (Coordinate));
		
		Category: Objects - 3D
		Procedure BeginXtrd creates a 3D extrude object in a Vectorworks document. BeginXtrd uses 2D object creation procedure calls to define the "template" for the object.
		You should call EndXtrd after the object creation procedures to complete the definition and generate the extrude object in the document.
	'''
	pass


def BotBound(
		c  # CRITERIA - Search criteria.
		):
	'''
		Python: REAL = vs.BotBound(c)
		VectorScript: FUNCTION BotBound(c:CRITERIA) : REAL;
		
		Category: Criteria
		Returns the y-coordinate of the bounding box (bottom right corner) of an object matching the search criteria. If more than one object matches the search criteria, the function will return the bottom value of the last matching object found.
	'''
	pass
	return 'REAL' # 


def BotBoundN(
		c  # CRITERIA - Search criteria.
		):
	'''
		Python: REAL = vs.BotBoundN(c)
		VectorScript: FUNCTION BotBoundN(c:CRITERIA) : REAL;
		
		Category: Criteria
		Returns the y-coordinate of the bounding box (bottom right corner) of an object matching the search criteria. If more than one object matches the search criteria, the function will return the value of the coordinate of the bottommost matching object found.
	'''
	pass
	return 'REAL' # 


def BreakWall(
		offsetDistance    , # REAL (Coordinate) - Offset distance from wall start.
		breakWidthDistance, # REAL (Coordinate) - Width of wall break.            
		right               # BOOLEAN           - Left-right edge status of break.
		):
	'''
		Python: vs.BreakWall(offsetDistance, breakWidthDistance, right)
		VectorScript: PROCEDURE BreakWall(offsetDistance:REAL (Coordinate); breakWidthDistance:REAL (Coordinate); right:BOOLEAN);
		
		Category: Objects - Walls
		Procedure BreakWall creates a break in a wall object on the left or the right at a specified offset location.
	'''
	pass


def BuildConstraintModelForObject(
		h                 , # HANDLE  - Handle to object                           
		traverseContainers  # BOOLEAN - Whether to traverse containers-like objects
		):
	'''
		Python: vs.BuildConstraintModelForObject(h, traverseContainers)
		VectorScript: PROCEDURE BuildConstraintModelForObject(h:HANDLE; traverseContainers:BOOLEAN);
		
		Category: Parametric Constraints
		Create a constraint model for the specified object in the constraint manager. If 'traverseContainers' is true and the specified object is a symbol definition, a group or another container-like objects, it will go deep inside that container.
		This function should typically be called for constrained objects that have been duplicated and newly inserted into the drawing.
	'''
	pass


def BuildResourceList(
		type         , # INTEGER            - the type of resource to put in the list                                                                                                                                                     
		folderIndex  , # INTEGER            - the index of a VW folder.                                                                                                                                                                   
		subFolderName  # DYNARRAY[] of CHAR - the name of a subfolder inside the folder specified by folderIndex. This can also be a partial path.  Use an empty string to request the resources from all files in the folderIndex folder.
		):
	'''
		Python: (LONGINT, numItems) = vs.BuildResourceList(type, folderIndex, subFolderName)
		VectorScript: FUNCTION BuildResourceList(type:INTEGER; folderIndex:INTEGER; subFolderName:DYNARRAY of CHAR; VAR numItems:LONGINT) : LONGINT;
		
		Category: Document List Handling
		Creates an implicit list of  resources of a specified type, and returns an ID for the list. Values in the list can be retrieved using GetNameFromResourceList.
		If the Display Default Content preference (#130) is on and folderIndex is not  0, it will also include all the resources of the specified type in all the files in the selected folder.
		If folderIndex is positive, the list will include all the resources of that type from the current document, as well as from the specified folder. If folderIndex is 0, only the resources in the current document will be in the list. If folderIndex is negative, only the resources in the specified folder will be in the list.
	'''
	pass
	return ( 0      , # 
	         0       )


def BuildResourceList2(
		type             , # INTEGER            - the type of resource to put in the list                                                                                                                                                    
		folderIndex      , # INTEGER            - the index of a VW folder.                                                                                                                                                                  
		subFolderName    , # DYNARRAY[] of CHAR - the name of a subfolder inside the folder specified by folderIndex. This can also be a partial path. Use an empty string to request the resources from all files in the folderIndex folder.
		useDefaultContent  # BOOLEAN            - determine if the list should contain default content                                                                                                                                       
		):
	'''
		Python: (LONGINT, numItems) = vs.BuildResourceList2(type, folderIndex, subFolderName, useDefaultContent)
		VectorScript: FUNCTION BuildResourceList2(type:INTEGER; folderIndex:INTEGER; subFolderName:DYNARRAY of CHAR; VAR numItems:LONGINT; useDefaultContent:BOOLEAN) : LONGINT;
		
		Category: Document List Handling
		Creates an implicit list of resources of a specified type, and returns an ID for the list. Values in the list can be retrieved using GetNameFromResourceList.
		If the Display Default Content preference (#130) is on and folderIndex is not 0, it will also include all the resources of the specified type in all the files in the selected folder.
		If folderIndex is positive, the list will include all the resources of that type from the current document, as well as from the specified folder. If folderIndex is 0, only the resources in the current document will be in the list. If folderIndex is negative, only the resources in the specified folder will be in the list.
	'''
	pass
	return ( 0      , # 
	         0       )


def BuildResourceListN(
		type    , # INTEGER            - the type of resource to put in the list          
		fullPath  # DYNARRAY[] of CHAR - The path to the file that provides the resources.
		):
	'''
		Python: (LONGINT, numItems) = vs.BuildResourceListN(type, fullPath)
		VectorScript: FUNCTION BuildResourceListN(type:INTEGER; fullPath:DYNARRAY of CHAR; VAR numItems:LONGINT) : LONGINT;
		
		Category: Document List Handling
		Build a resource list from the specified file.
	'''
	pass
	return ( 0      , # 
	         0       )


def BuildResourceListN2(
		type             , # INTEGER            - the type of resource to put in the list             
		fullPath         , # DYNARRAY[] of CHAR - The path to the file that provides the resources.   
		useDefaultContent  # BOOLEAN            - determine if the list should contain default content
		):
	'''
		Python: (LONGINT, numItems) = vs.BuildResourceListN2(type, fullPath, useDefaultContent)
		VectorScript: FUNCTION BuildResourceListN2(type:INTEGER; fullPath:DYNARRAY of CHAR; VAR numItems:LONGINT; useDefaultContent:BOOLEAN) : LONGINT;
		
		Category: Document List Handling
		Build a resource list from the specified file.
	'''
	pass
	return ( 0      , # 
	         0       )


def CalcPolySegLen(
		hPoly, # HANDLE  -  
		i1   , # INTEGER -  
		i2     # INTEGER -  
		):
	'''
		Python: REAL = vs.CalcPolySegLen(hPoly, i1, i2)
		VectorScript: FUNCTION CalcPolySegLen(hPoly:HANDLE; i1:INTEGER; i2:INTEGER) : REAL;
		
		Category: Graphic Calculation
		Calculate the length between two segments of a polygon or polyline
	'''
	pass
	return 'REAL' # 


def CalcSurfaceArea(
		solidObject  # HANDLE - Handle to solids object.
		):
	'''
		Python: REAL = vs.CalcSurfaceArea(solidObject)
		VectorScript: FUNCTION CalcSurfaceArea(solidObject:HANDLE) : REAL;
		
		Category: Objects - Solids
		Function CalcSurfaceArea calculates the surface area of the referenced solid object. The function supports only valid solids objects.
	'''
	pass
	return 'REAL' # 


def CalcVolume(
		solidObject  # HANDLE - Handle to solids object.
		):
	'''
		Python: REAL = vs.CalcVolume(solidObject)
		VectorScript: FUNCTION CalcVolume(solidObject:HANDLE) : REAL;
		
		Category: Objects - Solids
		Function CalcVolume calculates the volume of the referenced solid object. The function supports only valid solids objects.
	'''
	pass
	return 'REAL' # 


def CallTool(
		toolID  # INTEGER - Vectorworks tool constant.
		):
	'''
		Python: vs.CallTool(toolID)
		VectorScript: PROCEDURE CallTool(toolID:INTEGER);
		
		Category: User Interactive
		Activates the specified Vectorworks tool for a single use. After the tool has been used Vectorworks will revert back to the previously active tool.
		Note:
	'''
	pass


def CallToolByIndex(
		toolIndex  # INTEGER -  
		):
	'''
		Python: BOOLEAN = vs.CallToolByIndex(toolIndex)
		VectorScript: FUNCTION CallToolByIndex(toolIndex:INTEGER) : BOOLEAN;
		
		Category: Utility
		Similar to CallTool. Takes the internal ID of a tool.
	'''
	pass
	return 'BOOLEAN' # 


def CallToolByName(
		toolName  # STRING -  
		):
	'''
		Python: BOOLEAN = vs.CallToolByName(toolName)
		VectorScript: FUNCTION CallToolByName(toolName:STRING) : BOOLEAN;
		
		Category: Utility
		Similar to CallTool, but takes name rather than ID. Supports plug-in tools (but not yet internal tools).
	'''
	pass
	return 'BOOLEAN' # 


def CallToolWithMode(
		toolIndex , # INTEGER - Vectorworks tool constant.       
		modeGroup , # LONGINT - Index of the mode group          
		modeButton  # LONGINT - Index of the button in the group.
		):
	'''
		Python: vs.CallToolWithMode(toolIndex, modeGroup, modeButton)
		VectorScript: PROCEDURE CallToolWithMode(toolIndex:INTEGER; modeGroup:LONGINT; modeButton:LONGINT);
		
		Category: Utility
		Activates the specified Vectorworks tool for a single use with the specified tool mode. After the tool has been used Vectorworks will revert back to the previously active tool.
	'''
	pass


def CapsLock():
	'''
		Python: BOOLEAN = vs.CapsLock()
		VectorScript: FUNCTION CapsLock : BOOLEAN;
		
		Category: User Interactive
		CapsLock returns TRUE if the Caps Lock was depressed during the last user event. This function operates with the MouseDown, KeyDown, AutoKey, GetPt, GetPtL, GetLine, and GetRect calls.
	'''
	pass
	return 'BOOLEAN' # 


def CellHasNum(
		h  , # HANDLE  - Handle to worksheet.   
		row, # INTEGER - Worksheet row index.   
		col  # INTEGER - Worksheet column index.
		):
	'''
		Python: BOOLEAN = vs.CellHasNum(h, row, col)
		VectorScript: FUNCTION CellHasNum(h:HANDLE; row:INTEGER; col:INTEGER) : BOOLEAN;
		
		Category: Worksheets
		Function CellHasNum returns TRUE if the specified cell of a referenced worksheet contains a value or an equation which returns a numeric value.
	'''
	pass
	return 'BOOLEAN' # 


def CellHasStr(
		h  , # HANDLE  - Handle to worksheet.   
		row, # INTEGER - Worksheet row index.   
		col  # INTEGER - Worksheet column index.
		):
	'''
		Python: BOOLEAN = vs.CellHasStr(h, row, col)
		VectorScript: FUNCTION CellHasStr(h:HANDLE; row:INTEGER; col:INTEGER) : BOOLEAN;
		
		Category: Worksheets
		Function CellHasStr returns TRUE if the specified cell of a referenced worksheet contains a value or an equation which returns a numeric value.
	'''
	pass
	return 'BOOLEAN' # 


def CellString(
		row   , # INTEGER - Worksheet row index.   
		column  # INTEGER - Worksheet column index.
		):
	'''
		Python: STRING = vs.CellString(row, column)
		VectorScript: FUNCTION CellString(row:INTEGER; column:INTEGER) : STRING;
		
		Category: Worksheets
		Function CellString returns the string of a specified cell in the active worksheet
	'''
	pass
	return 'STRING' # 


def CellValue(
		row   , # INTEGER - Worksheet row index.   
		column  # INTEGER - Worksheet column index.
		):
	'''
		Python: REAL = vs.CellValue(row, column)
		VectorScript: FUNCTION CellValue(row:INTEGER; column:INTEGER) : REAL;
		
		Category: Worksheets
		Function CellValue returns the numeric value of a specified cell in the active worksheet. If the specified cell is not a numeric type, then this function returns 0.
	'''
	pass
	return 'REAL' # 


def Centroid(
		h  # HANDLE -  
		):
	'''
		Python: (BOOLEAN, x, y) = vs.Centroid(h)
		VectorScript: FUNCTION Centroid(h:HANDLE; VAR x:REAL; VAR y:REAL) : BOOLEAN;
		
		Category: Graphic Calculation
		Returns the centroid of the object. Returns false if an unsupported object type is supplied.
	'''
	pass
	return ( False  , # 
	         0.0    , 
	         0.0     )


def Centroid3D(
		object  # HANDLE - The objectt from whci to calculate the center of gravity
		):
	'''
		Python: (BOOLEAN, xCG, yCG, zCG) = vs.Centroid3D(object)
		VectorScript: FUNCTION Centroid3D(object:HANDLE; VAR xCG:REAL; VAR yCG:REAL; VAR zCG:REAL) : BOOLEAN;
		
		Category: Objects - 3D
		Returns the center of gravity of a 3D object. The function returns TRUE if the values were found.
	'''
	pass
	return ( False  , # Returns true if the function succeeds.
	         0.0    , 
	         0.0    , 
	         0.0     )


def CheckoutObj(
		c  # CRITERIA - Search criteria
		):
	'''
		Python: vs.CheckoutObj(c)
		VectorScript: PROCEDURE CheckoutObj(c:CRITERIA);
		
		Category: Criteria
		Checkouts all objects which match the search criteria.
	'''
	pass


def Chr(
		v  # INTEGER - ASCII numeric identifier code.
		):
	'''
		Python: CHAR = vs.Chr(v)
		VectorScript: FUNCTION Chr(v:INTEGER) : CHAR;
		
		Category: Strings
		Function Chr returns the ASCII character corresponding to the specified numeric code. The ASCII code value must be between 1 and 255.
	'''
	pass
	return 'CHAR' # 


def CircleCircleInters(
		cenPt1 , # VECTOR -  
		cenPt2 , # VECTOR -  
		radius1, # REAL   -  
		radius2  # REAL   -  
		):
	'''
		Python: (BOOLEAN, pt1, pt2) = vs.CircleCircleInters(cenPt1, cenPt2, radius1, radius2)
		VectorScript: FUNCTION CircleCircleInters(cenPt1:VECTOR; cenPt2:VECTOR; radius1:REAL; radius2:REAL; VAR pt1:VECTOR; VAR pt2:VECTOR) : BOOLEAN;
		
		Category: Graphic Calculation
		Finds the intersection of two circles.
	'''
	pass
	return ( False  , # 
	         0,0,0  , 
	         0,0,0   )


def CircularDim(
		startPt           , # POINT             - X-Y coordinates of dimension start point.                          
		endPt             , # POINT             - X-Y coordinates of dimension end point.                            
		box1              , # POINT             - X-Y coordinates of top left corner of object bounding box          
		box2              , # POINT             - X-Y coordinates of bottom right corner of object bounding box      
		textOffsetDistance, # REAL (Coordinate) - Offset distance of text from dimension line(witness leader length).
		dimType           , # INTEGER           - Dimension type flag.                                               
		arrow             , # INTEGER           - Arrow style flag.                                                  
		textFlag          , # INTEGER           - Text style flag.                                                   
		shoulder            # REAL              - Shoulder extension line length.                                    
		):
	'''
		Python: vs.CircularDim(startPt, endPt, box1, box2, textOffsetDistance, dimType, arrow, textFlag, shoulder)
		VectorScript: PROCEDURE CircularDim(startPtX, startPtY:REAL; endPtX, endPtY:REAL; box1X, box1Y:REAL; box2X, box2Y:REAL; textOffsetDistance:REAL (Coordinate); dimType:INTEGER; arrow:INTEGER; textFlag:INTEGER; shoulder:REAL);
		
		Category: Dimensions
		Procedure CircularDim creates a diameter or radial dimension in a Vectorworks document.
		<I>Circular Dimension</I><P>
	'''
	pass


def ClassList(
		index  # LONGINT - Index of class in class list (range of 1- n).
		):
	'''
		Python: STRING = vs.ClassList(index)
		VectorScript: FUNCTION ClassList(index:LONGINT) : STRING;
		
		Category: Classes
		Returns the name of the specified class in the document class list. For example,  ClassList(4) will return the name of the fourth class in the list.
	'''
	pass
	return 'STRING' # 


def ClassNum():
	'''
		Python: LONGINT = vs.ClassNum()
		VectorScript: FUNCTION ClassNum : LONGINT;
		
		Category: Classes
		Returns the total number of classes in the active document.
	'''
	pass
	return 'LONGINT' # 


def CLDropShadowEnabled(
		clasName   # STRING -  
		):
	'''
		Python: BOOLEAN = vs.CLDropShadowEnabled(className)
		VectorScript: FUNCTION CLDropShadowEnabled(className:STRING) : BOOLEAN;
		
		Category: Classes
	'''
	pass
	return 'BOOLEAN' # 


def ClearCavities():
	'''
		Python: vs.ClearCavities()
		VectorScript: PROCEDURE ClearCavities;
		
		Category: Objects - Walls
		Procedure ClearCavities resets the default cavity style of wall objects to no cavities.
	'''
	pass


def ClearGradientSliderSegments(
		dialogID   , # LONGINT - Index to the dialog layout that contains the gradient slider component.
		componentID  # LONGINT - Index to a specific gradient slider component.                         
		):
	'''
		Python: vs.ClearGradientSliderSegments(dialogID, componentID)
		VectorScript: PROCEDURE ClearGradientSliderSegments(dialogID:LONGINT; componentID:LONGINT);
		
		Category: Dialogs - Modern
		Removes all segments (except for 2) from the gradient slider.
		Note: a gradient slider must always have at least 2 segments.
	'''
	pass


def ClearWallPeaks(
		h  # HANDLE - Handle to wall.
		):
	'''
		Python: vs.ClearWallPeaks(h)
		VectorScript: PROCEDURE ClearWallPeaks(h:HANDLE);
		
		Category: Objects - Walls
		Removes all wall peaks from the referenced wall.
	'''
	pass


def ClearWSCell(
		worksheet  , # HANDLE  - Handle to worksheet.           
		topRow     , # INTEGER - Top row of cell range.         
		leftColumn , # INTEGER - Leftmost column of cell range. 
		bottomRow  , # INTEGER - Bottom row of cell range.      
		rightColumn  # INTEGER - Rightmost column of cell range.
		):
	'''
		Python: vs.ClearWSCell(worksheet, topRow, leftColumn, bottomRow, rightColumn)
		VectorScript: PROCEDURE ClearWSCell(worksheet:HANDLE; topRow:INTEGER; leftColumn:INTEGER; bottomRow:INTEGER; rightColumn:INTEGER);
		
		Category: Worksheets
		Clears content and resets attributes of a cell in the referenced worksheet.
		ClearWSCell allows a rectangular range of cells to be reset. To reset a single cell, specify identical values for the top/bottom and left/right range boundaries.
	'''
	pass


def ClipPolygon(
		hPolygon, # HANDLE -  
		hClipper, # HANDLE -  
		dFuzz     # REAL   -  
		):
	'''
		Python: HANDLE = vs.ClipPolygon(hPolygon, hClipper, dFuzz)
		VectorScript: FUNCTION ClipPolygon(hPolygon:HANDLE; hClipper:HANDLE; dFuzz:REAL) : HANDLE;
		
		Category: Graphic Calculation
		Same as IntersectSurface, but improves performance by first checking to see if hClipper is within the bounding box of hPolygon before calling IntersectSurface.
	'''
	pass
	return 'HANDLE' # 


def ClipSurface(
		s1, # HANDLE - Handle to object.
		s2  # HANDLE - Handle to object.
		):
	'''
		Python: vs.ClipSurface(s1, s2)
		VectorScript: PROCEDURE ClipSurface(s1:HANDLE; s2:HANDLE);
		
		Category: Objects - 2D
		Creates a new surface object by subtracting the intersection of surfaces s1 and s2 from s1.
	'''
	pass


def ClipSurfaceN(
		s1, # HANDLE - Surface to be subtracted from
		s2  # HANDLE - Surface to subtract from s1  
		):
	'''
		Python: HANDLE = vs.ClipSurfaceN(s1, s2)
		VectorScript: FUNCTION ClipSurfaceN(s1:HANDLE; s2:HANDLE) : HANDLE;
		
		Category: Objects - 2D
		Creates a new surface object by subtracting the intersection of surfaces s1 and s2 from s1.
	'''
	pass
	return 'HANDLE' # 


def Close(
		fileName  # DYNARRAY[] of CHAR - Name of file to close.
		):
	'''
		Python: vs.Close(fileName)
		VectorScript: PROCEDURE Close(fileName:DYNARRAY of CHAR);
		
		Category: File I/O
		Procedure Close closes the specified text file.
	'''
	pass


def ClosePDFDocument():
	'''
		Python: vs.ClosePDFDocument()
		VectorScript: PROCEDURE ClosePDFDocument;
		
		Category: Command
		This will finish creating the PDF document that you started with OpenPDFDocument.  This is intended to support Batch Export to PDF.
	'''
	pass


def ClosePoly():
	'''
		Python: vs.ClosePoly()
		VectorScript: PROCEDURE ClosePoly;
		
		Category: Objects - Polys
		Procedures ClosePoly set the polygon creation mode for polygon objects created in VectorScript to closed. To turn this mode off, use Procedure OpenPoly; the two modes used in conjunction will act as a toggle for the feature.
	'''
	pass


def CloseSS(
		h  # HANDLE - Handle to worksheet.
		):
	'''
		Python: vs.CloseSS(h)
		VectorScript: PROCEDURE CloseSS(h:HANDLE);
		
		Category: Worksheets
		Procedure CloseSS closes the referenced worksheet.
	'''
	pass


def ClosestPoints(
		h1, # HANDLE -  
		h2  # HANDLE -  
		):
	'''
		Python: (pt1, pt2, touching) = vs.ClosestPoints(h1, h2)
		VectorScript: PROCEDURE ClosestPoints(h1:HANDLE; h2:HANDLE; VAR pt1:VECTOR; VAR pt2:VECTOR; VAR touching:BOOLEAN);
		
		Category: Graphic Calculation
		Returns the points on two objects where the shortest distance between those objects occurs. Should support all VW primitives, including polylines and NURBS. Would be nice if it supported groups, symbols, and PIOs. Would also be nice if it supported 3D.
	'''
	pass
	return ( 0,0,0, 
	         0,0,0, 
	         False )


def Cloud(
		h                  , # HANDLE  -  
		rMin               , # REAL    -  
		rMax               , # REAL    -  
		hFactor            , # REAL    -  
		convex             , # BOOLEAN -  
		removeIntersections  # BOOLEAN -  
		):
	'''
		Python: HANDLE = vs.Cloud(h, rMin, rMax, hFactor, convex, removeIntersections)
		VectorScript: FUNCTION Cloud(h:HANDLE; rMin:REAL; rMax:REAL; hFactor:REAL; convex:BOOLEAN; removeIntersections:BOOLEAN) : HANDLE;
		
		Category: Graphic Calculation
		Draws a cloud. Varies the billows of the clouds randomly between rMin and rMax. The hFactor is the height of each individual arc in the cloud.
	'''
	pass
	return 'HANDLE' # 


def ClrMessage():
	'''
		Python: vs.ClrMessage()
		VectorScript: PROCEDURE ClrMessage;
		
		Category: Utility
		Procedure ClrMessage closes the message palette.
	'''
	pass


def CnvrtToGenericSolid(
		solid  # HANDLE - object to convert
		):
	'''
		Python: HANDLE = vs.CnvrtToGenericSolid(solid)
		VectorScript: FUNCTION CnvrtToGenericSolid(solid:HANDLE) : HANDLE;
		
		Category: Objects - Solids
		Converts Solid objects to generic solids. Removes solid history saving memory.
	'''
	pass
	return 'HANDLE' # 


def CollapseAllLBItems(
		dialogID   , # LONGINT - The id of the dialog.      
		componentID  # LONGINT - The id of the list browser.
		):
	'''
		Python: vs.CollapseAllLBItems(dialogID, componentID)
		VectorScript: PROCEDURE CollapseAllLBItems(dialogID:LONGINT; componentID:LONGINT);
		
		Category: Dialogs - Modern - Browser
		This function is called when a list browser is in hierarchical display mode, and it removes all items that are not at the top level and closes all container items.
	'''
	pass


def ColorIndexToRGB(
		color  # INTEGER - Color index.
		):
	'''
		Python: (red, green, blue) = vs.ColorIndexToRGB(color)
		VectorScript: PROCEDURE ColorIndexToRGB(color:INTEGER; VAR red:LONGINT; VAR green:LONGINT; VAR blue:LONGINT);
		
		Category: Utility
		Procedure ColorIndexToRGB converts the Vectorworks palette colors from the colors' palette position index to its red, green, and blue component values. RGB values are in the range of 0 65535.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def ColorIndexToRGBN(
		color                , # INTEGER - Color index                                       
		ignoreBlackBackground  # BOOLEAN - Ignore black background preference setting or not.
		):
	'''
		Python: (red, green, blue) = vs.ColorIndexToRGBN(color, ignoreBlackBackground)
		VectorScript: PROCEDURE ColorIndexToRGBN(color:INTEGER; VAR red:LONGINT; VAR green:LONGINT; VAR blue:LONGINT; ignoreBlackBackground:BOOLEAN);
		
		Category: Utility
		Procedure ColorIndexToRGBN converts the Vectorworks palette colors from the colors' palette position index to its red, green, and blue component values. RGB values are in the range of 0 65535.Parameter ignoreBlackBackground specifies whether the black background preference should be ignored. If set to TRUE, black and white indexes will not be inverted in black background.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def CombineIntoSurface(
		pt  # POINT - A point within the bounded selection.
		):
	'''
		Python: HANDLE = vs.CombineIntoSurface(pt)
		VectorScript: FUNCTION CombineIntoSurface(ptX, ptY:REAL) : HANDLE;
		
		Category: Objects - 2D
		Creates a polyline from the bounded selection surrounding the inIncludedPoint.
	'''
	pass
	return 'HANDLE' # 


def CombinePolygons(
		hPolygonA, # HANDLE -  
		hPolygonB, # HANDLE -  
		dFuzz      # REAL   -  
		):
	'''
		Python: HANDLE = vs.CombinePolygons(hPolygonA, hPolygonB, dFuzz)
		VectorScript: FUNCTION CombinePolygons(hPolygonA:HANDLE; hPolygonB:HANDLE; dFuzz:REAL) : HANDLE;
		
		Category: Graphic Calculation
		Combines two polygons.
	'''
	pass
	return 'HANDLE' # 


def Command():
	'''
		Python: BOOLEAN = vs.Command()
		VectorScript: FUNCTION Command : BOOLEAN;
		
		Category: User Interactive
		Command returns TRUE if the Command key (Mac) or Control key (Windows) was depressed during the last user event. This function operates with the MouseDown, KeyDown, AutoKey, GetPt, GetPtL, GetLine, and GetRect calls.
	'''
	pass
	return 'BOOLEAN' # 


def Comp(
		v1, # VECTOR        - Comparison vector 1.                         
		v2, # VECTOR        - Comparison vector 2                          
		v3, # in/out VECTOR - Component of vector 1 along vector 2         
		v4  # in/out VECTOR - Component of vector 1 orthogonal to vector 2.
		):
	'''
		Python: (v3, v4) = vs.Comp(v1, v2, v3, v4)
		VectorScript: PROCEDURE Comp(v1:VECTOR; v2:VECTOR; VAR v3:VECTOR; VAR v4:VECTOR);
		
		Category: Math - Vectors
		Returns the components of a comparison of two vectors.
		The vector component of v1 along v2 in v3, and the vector component of v1 orthogonal to v2 in v4.
	'''
	pass
	return ( 0,0,0, 
	         0,0,0 )


def ComponentArea(
		c    , # CRITERIA - The search criteria string 
		index  # INTEGER  - The index of the component.
		):
	'''
		Python: REAL = vs.ComponentArea(c, index)
		VectorScript: FUNCTION ComponentArea(c:CRITERIA; index:INTEGER) : REAL;
		
		Category: Criteria
		Returns the area of one side the specified component, minus any holes in the 3D object.
	'''
	pass
	return 'REAL' # 


def ComponentVolume(
		c    , # CRITERIA - The search criteria string.
		index  # INTEGER  - The index of the component.
		):
	'''
		Python: REAL = vs.ComponentVolume(c, index)
		VectorScript: FUNCTION ComponentVolume(c:CRITERIA; index:INTEGER) : REAL;
		
		Category: Criteria
		Returns the 3D volume of the specified component, minus any holes in the 3D object.
	'''
	pass
	return 'REAL' # 


def ConsolidatePlanar(
		obj1, # HANDLE - Handle to the first object. 
		obj2  # HANDLE - Handle to the second object.
		):
	'''
		Python: BOOLEAN = vs.ConsolidatePlanar(obj1, obj2)
		VectorScript: FUNCTION ConsolidatePlanar(obj1:HANDLE; obj2:HANDLE) : BOOLEAN;
		
		Category: Object Info
		Modifies the plane of the second planar object so it is on the plane of the first object. Also moves the object so plane change doesn't affect it's position.
	'''
	pass
	return 'BOOLEAN' # 


def ContainsLight(
		containerObject  # HANDLE - Handle to object.
		):
	'''
		Python: BOOLEAN = vs.ContainsLight(containerObject)
		VectorScript: FUNCTION ContainsLight(containerObject:HANDLE) : BOOLEAN;
		
		Category: Objects - Lights
		Function ContainsLight returns TRUE if the referenced object contains a light.  This function works with container objects such as groups, symbols, layers, etc.
	'''
	pass
	return 'BOOLEAN' # 


def ConvertHSF2PosixPath(
		HSFPath  # DYNARRAY[] of CHAR - The HSF path that is to be converted.
		):
	'''
		Python: (BOOLEAN, outPosixPath) = vs.ConvertHSF2PosixPath(HSFPath)
		VectorScript: FUNCTION ConvertHSF2PosixPath(HSFPath:DYNARRAY of CHAR; VAR outPosixPath:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: File I/O
		Machintosh only!
		Converts HSF (using ':' as delimiter) file path to Posix (using '/' as delimiter) file path.
	'''
	pass
	return ( False   , # Returns true if the conversion succeeds. False if it fails.[[BR]]The resulted Posix path will be the same as the passed HSF path if the function fails.
	         'string' )


def ConvertPosix2HSFPath(
		PosixPath  # DYNARRAY[] of CHAR - The Posix path that is to be converted.
		):
	'''
		Python: (BOOLEAN, outHSFPath) = vs.ConvertPosix2HSFPath(PosixPath)
		VectorScript: FUNCTION ConvertPosix2HSFPath(PosixPath:DYNARRAY of CHAR; VAR outHSFPath:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: File I/O
		Machintosh only!
		Converts Posix (using '/' as delimiter) file path to HSF (using ':' as delimiter) file path.
	'''
	pass
	return ( False   , # Returns true if the conversion succeeds. False if it fails.[[BR]]The resulted Posix path will be the same as the passed Posix path if the function fails.
	         'string' )


def ConvertTo3DPolys(
		original  # HANDLE - Handle to the original object.
		):
	'''
		Python: HANDLE = vs.ConvertTo3DPolys(original)
		VectorScript: FUNCTION ConvertTo3DPolys(original:HANDLE) : HANDLE;
		
		Category: Objects - 3D
		Converts an object to 3D polygons. This function successfully converts rectangles, circles, arcs, polylines, polygons, ovals, lines, straight walls, curved walls, and roofs.
	'''
	pass
	return 'HANDLE' # 


def ConvertToArcPolyline(
		hPolygon, # HANDLE -  
		dFuzz     # REAL   -  
		):
	'''
		Python: HANDLE = vs.ConvertToArcPolyline(hPolygon, dFuzz)
		VectorScript: FUNCTION ConvertToArcPolyline(hPolygon:HANDLE; dFuzz:REAL) : HANDLE;
		
		Category: Graphic Calculation
		Convert, within a tolerance, the input polyline into an polyline that uses arcs for the curves
	'''
	pass
	return 'HANDLE' # 


def ConvertToNURBS(
		h       , # HANDLE  - Handle of original object.               
		keepOrig  # BOOLEAN - Leave the original object in the drawing.
		):
	'''
		Python: HANDLE = vs.ConvertToNURBS(h, keepOrig)
		VectorScript: FUNCTION ConvertToNURBS(h:HANDLE; keepOrig:BOOLEAN) : HANDLE;
		
		Category: Objects - NURBS
		This function converts the input object into a new NURBS object or a group of NURBS objects in the document.
	'''
	pass
	return 'HANDLE' # 


def ConvertToPolygon(
		h         , # HANDLE  -  
		resolution  # INTEGER -  
		):
	'''
		Python: HANDLE = vs.ConvertToPolygon(h, resolution)
		VectorScript: FUNCTION ConvertToPolygon(h:HANDLE; resolution:INTEGER) : HANDLE;
		
		Category: Graphic Calculation
		Converts object to polygon.
	'''
	pass
	return 'HANDLE' # 


def ConvertToPolyline(
		h  # HANDLE -  
		):
	'''
		Python: HANDLE = vs.ConvertToPolyline(h)
		VectorScript: FUNCTION ConvertToPolyline(h:HANDLE) : HANDLE;
		
		Category: Graphic Calculation
		Converts any enclosed shape (circle, rectangle, ellipse, etc.) into a polygon or polyline. Does not polygonalize.
	'''
	pass
	return 'HANDLE' # 


def ConvertToUnstyledSlab(
		slab  # HANDLE - The slab.
		):
	'''
		Python: vs.ConvertToUnstyledSlab(slab)
		VectorScript: PROCEDURE ConvertToUnstyledSlab(slab:HANDLE);
		
		Category: Objects - Architectural
		Sets a slab to be unstyled.
	'''
	pass


def ConvertToUnstyledWall(
		h  # HANDLE -  
		):
	'''
		Python: BOOLEAN = vs.ConvertToUnstyledWall(h)
		VectorScript: FUNCTION ConvertToUnstyledWall(h:HANDLE) : BOOLEAN;
		
		Category: Objects - Walls
		Sets a wall to be unstyled.
	'''
	pass
	return 'BOOLEAN' # 


def ConvToUnstyledRoof(
		roof  # HANDLE - The roof.
		):
	'''
		Python: vs.ConvToUnstyledRoof(roof)
		VectorScript: PROCEDURE ConvToUnstyledRoof(roof:HANDLE);
		
		Category: Objects - Roofs
		Sets a roof to be unstyled.
	'''
	pass


def Copy(
		source, # DYNARRAY[] of CHAR - Source string.                
		index , # INTEGER            - Start position in text string.
		count   # INTEGER            - Length of substring.          
		):
	'''
		Python: DYNARRAY of CHAR = vs.Copy(source, index, count)
		VectorScript: FUNCTION Copy(source:DYNARRAY of CHAR; index:INTEGER; count:INTEGER) : DYNARRAY of CHAR;
		
		Category: Strings
		Function Copy returns a substring from a specified source string.
	'''
	pass
	return 'DYNARRAY[] of CHAR' # 


def CopyMode(
		mode  # INTEGER - Mode index value.
		):
	'''
		Python: vs.CopyMode(mode)
		VectorScript: PROCEDURE CopyMode(mode:INTEGER);
		
		Category: Layers
		Procedure CopyMode sets the transfer mode for the active design layer.  If a sheet layer is active, the procedure has no effect.
		The design layer will only be imaged with the transfer mode on systems which support it, like Windows.  Setting the transfer mode to a mode other than Copy (i.e. 8, Paint mode), when the current layer transparency percentage is 0, will also automatically change the layer transparency percentage to 50.  Similarly, setting the transfer mode to Copy, when the current layer transparency percentage is greater than 0, will also automatically change the layer transparency percentage to 0.  This is to approximately preserve the appearance of the layer on systems that don't support transfer modes, like Quartz on the Mac.
	'''
	pass


def CopySymbol(
		filePath, # STRING - File path to document, relative to the application folder.
		symbol    # STRING - Name of symbol to import.                                 
		):
	'''
		Python: BOOLEAN = vs.CopySymbol(filePath, symbol)
		VectorScript: FUNCTION CopySymbol(filePath:STRING; symbol:STRING) : BOOLEAN;
		
		Category: Objects - Symbols
		Procedure CopySymbol will copy a symbol into the active document from a user specified source document.
	'''
	pass
	return 'BOOLEAN' # Returns a BOOLEAN value indicating the success or failure of the import operation.


def Cos(
		v  # REAL - The angle for which to find the cosine.
		):
	'''
		Python: REAL = vs.Cos(v)
		VectorScript: FUNCTION Cos(v:REAL) : REAL;
		
		Category: Math - General
		Function Cos returns the cosine of the specified value. The base value is assumed to represent an angle in radians.
	'''
	pass
	return 'REAL' # 


def Count(
		c  # CRITERIA - Search criteria.
		):
	'''
		Python: LONGINT = vs.Count(c)
		VectorScript: FUNCTION Count(c:CRITERIA) : LONGINT;
		
		Category: Criteria
		Counts all of the objects which match the search criteria.
	'''
	pass
	return 'LONGINT' # 


def CountFillSpaces(
		h  # HANDLE - Handle to the object containing the fill spaces to be counted.
		):
	'''
		Python: INTEGER = vs.CountFillSpaces(h)
		VectorScript: FUNCTION CountFillSpaces(h:HANDLE) : INTEGER;
		
		Category: Object Attributes
		Returns the number of fill spaces currently attached to a specified object.
	'''
	pass
	return 'INTEGER' # The number of fill spaces attached to the object h.


def Create2DObjShadow(
		h        , # HANDLE - Handle to a 2D object.      
		offsetVec  # POINT  - Shadow direction and length.
		):
	'''
		Python: HANDLE = vs.Create2DObjShadow(h, offsetVec)
		VectorScript: FUNCTION Create2DObjShadow(h:HANDLE; offsetVecX, offsetVecY:REAL) : HANDLE;
		
		Category: Objects - 2D
		Create a shadow representation of the given 2D object at the specified offset vector.
	'''
	pass
	return 'HANDLE' # 


def CreateBatDormer(
		roofObject  # HANDLE - Handle to roof.
		):
	'''
		Python: INTEGER = vs.CreateBatDormer(roofObject)
		VectorScript: FUNCTION CreateBatDormer(roofObject:HANDLE) : INTEGER;
		
		Category: Objects - Roofs
		Function CreateBatDormer creates a bat dormer in the referenced roof object.
	'''
	pass
	return 'INTEGER' # 


def CreateCenteredStaticText(
		dialogID      , # LONGINT -                                                                                       
		controlID     , # LONGINT -                                                                                       
		text          , # STRING  -                                                                                       
		widthInStdChar  # INTEGER - The width of the displayed text in standard character count. See GetDlgCtrlWidthStdCh.
		):
	'''
		Python: vs.CreateCenteredStaticText(dialogID, controlID, text, widthInStdChar)
		VectorScript: PROCEDURE CreateCenteredStaticText(dialogID:LONGINT; controlID:LONGINT; text:STRING; widthInStdChar:INTEGER);
		
		Category: Dialogs - Modern
		Similar to CreateStaticText, but creates static text that is centered in its control field on the dialog.
	'''
	pass


def CreateChainDimension(
		h1, # HANDLE -  
		h2  # HANDLE -  
		):
	'''
		Python: HANDLE = vs.CreateChainDimension(h1, h2)
		VectorScript: FUNCTION CreateChainDimension(h1:HANDLE; h2:HANDLE) : HANDLE;
		
		Category: Dimensions
		Creates and returns a single chain dimension object when the two dimensions or chains that are passed in meet the requirements for being in a single chain dimension object.
	'''
	pass
	return 'HANDLE' # 


def CreateCheckBox(
		dialogID, # LONGINT - The index of the dialog layout containing the control.
		itemID  , # LONGINT - The index that will identify the control item.        
		text      # STRING  - The display text for the control.                     
		):
	'''
		Python: vs.CreateCheckBox(dialogID, itemID, text)
		VectorScript: PROCEDURE CreateCheckBox(dialogID:LONGINT; itemID:LONGINT; text:STRING);
		
		Category: Dialogs - Modern
		Creates a check box control in a dialog layout.
	'''
	pass


def CreateCheckBoxGroupBox(
		dialogID, # LONGINT - ID of the dialog                                            
		itemID  , # LONGINT - ID of the checkbox group box                                
		name    , # STRING  - Title that appears in the checkbox group box                
		hasFrame  # BOOLEAN - True if the group box has a frame around it; false otherwise
		):
	'''
		Python: vs.CreateCheckBoxGroupBox(dialogID, itemID, name, hasFrame)
		VectorScript: PROCEDURE CreateCheckBoxGroupBox(dialogID:LONGINT; itemID:LONGINT; name:STRING; hasFrame:BOOLEAN);
		
		Category: Dialogs - Modern
		Creates a checkbox group box.  The checkbox will have name as its label.  If hasFrame is true, the group will have a box drawn around it like a regular group box.
	'''
	pass


def CreateClassPullDownMenu(
		nDialogID     , # LONGINT -                                                                                       
		nComponentID  , # LONGINT -                                                                                       
		widthInStdChar  # INTEGER - The width of the displayed text in standard character count. See GetDlgCtrlWidthStdCh.
		):
	'''
		Python: vs.CreateClassPullDownMenu(nDialogID, nComponentID, widthInStdChar)
		VectorScript: PROCEDURE CreateClassPullDownMenu(nDialogID:LONGINT; nComponentID:LONGINT; widthInStdChar:INTEGER);
		
		Category: Dialogs - Modern
		Creates a Layout Manager class pull down menu control.
	'''
	pass


def CreateColorPopup(
		dialogID      , # LONGINT -                                                                                       
		itemID        , # LONGINT -                                                                                       
		widthInStdChar  # LONGINT - The width of the displayed text in standard character count. See GetDlgCtrlWidthStdCh.
		):
	'''
		Python: vs.CreateColorPopup(dialogID, itemID, widthInStdChar)
		VectorScript: PROCEDURE CreateColorPopup(dialogID:LONGINT; itemID:LONGINT; widthInStdChar:LONGINT);
		
		Category: Dialogs - Modern
		Create a color popup dialog control that displays the 256 color palette associated with the active document.
		The widthInStdChar argument specifies the width of the control.  Pass -1 to request the default size, which will be consistent with other attribute controls (currently defaults to 14).  This argument allows for special circumstances like a small popup for the Fore and Back color associated with the Pattern attribute control.
	'''
	pass


def CreateCone(
		center        , # POINT3D           - Center point of cone.
		tip           , # POINT3D           - Tip point of cone.   
		radiusDistance  # REAL (Coordinate) - Radius of cone base. 
		):
	'''
		Python: HANDLE = vs.CreateCone(center, tip, radiusDistance)
		VectorScript: FUNCTION CreateCone(centerX, centerY, centerZ:REAL; tipX, tipY, tipZ:REAL; radiusDistance:REAL (Coordinate)) : HANDLE;
		
		Category: Objects - Solids
		Creates a 3D cone object in a Vectorworks document.
	'''
	pass
	return 'HANDLE' # The function returns a handle to the new cone object.


def CreateContourCurves(
		inSourceObject, # HANDLE  - Handle to a solid object              
		delta         , # REAL    - Distance between contours             
		ptOnPlane     , # POINT3D - Point on plane used to define contours
		normal          # POINT3D - Plane's normal vector                 
		):
	'''
		Python: HANDLE = vs.CreateContourCurves(inSourceObject, delta, ptOnPlane, normal)
		VectorScript: FUNCTION CreateContourCurves(inSourceObject:HANDLE; delta:REAL; ptOnPlaneX, ptOnPlaneY, ptOnPlaneZ:REAL; normalX, normalY, normalZ:REAL) : HANDLE;
		
		Category: Objects - 3D
		Creates contour curves for  a solid object given the delta, point on plane and plane normal.  If delta is 0, only 1 curve is created, where the specified plane intersects the selected solid.
	'''
	pass
	return 'HANDLE' # Returns a HANDLE to a group containing NURBS curves representing the contours.


def CreateControl(
		dialogID   , # LONGINT - The index of the dialog layout containing the control.
		itemID     , # LONGINT - The index that will identify the control item.        
		controlKind, # LONGINT - The type of control item.                             
		name       , # STRING  - The display text of the control item.                 
		data         # LONGINT - Initial data for the control item.                    
		):
	'''
		Python: vs.CreateControl(dialogID, itemID, controlKind, name, data)
		VectorScript: PROCEDURE CreateControl(dialogID:LONGINT; itemID:LONGINT; controlKind:LONGINT; name:STRING; data:LONGINT);
		
		Category: Dialogs - Modern
		Creates a new extended dialog control item. Supported extended dialog controls include image, system color palette, and slider controls.
	'''
	pass


def CreateCustomControl(
		dialogID      , # LONGINT -  
		componentID   , # LONGINT -  
		widthInPixels , # INTEGER -  
		heightInPixels  # INTEGER -  
		):
	'''
		Python: vs.CreateCustomControl(dialogID, componentID, widthInPixels, heightInPixels)
		VectorScript: PROCEDURE CreateCustomControl(dialogID:LONGINT; componentID:LONGINT; widthInPixels:INTEGER; heightInPixels:INTEGER);
		
		Category: Dialogs - Modern
		Creates a layout manager control in a VectorScript to be used in conjuction with GS_OverrideControl in an external dialog handler.
	'''
	pass


def CreateCustomObject(
		objectName   , # STRING - Name of object.                                
		p            , # POINT  - Insertion point of object instance.            
		rotationAngle  # REAL   - Rotation angle (in degrees) of object instance.
		):
	'''
		Python: HANDLE = vs.CreateCustomObject(objectName, p, rotationAngle)
		VectorScript: FUNCTION CreateCustomObject(objectName:STRING; pX, pY:REAL; rotationAngle:REAL) : HANDLE;
		
		Category: Objects - Custom
		Creates a custom object instance at the specified location and angle of rotation. For the objectName, use the "internal" plug-in name (the one assigned in the plug-in editor), as opposed to the filename (which can be different).
	'''
	pass
	return 'HANDLE' # Returns a HANDLE to the new object.


def CreateCustomObjectN(
		objectName   , # STRING  - Name of object.                                 
		p            , # POINT   - Insertion point of object instance.             
		rotationAngle, # REAL    - Rotation angle (in degrees) of object instance. 
		showPref       # BOOLEAN - Show the Object Properties dialog.              
		):
	'''
		Python: HANDLE = vs.CreateCustomObjectN(objectName, p, rotationAngle, showPref)
		VectorScript: FUNCTION CreateCustomObjectN(objectName:STRING; pX, pY:REAL; rotationAngle:REAL; showPref:BOOLEAN) : HANDLE;
		
		Category: Objects - Custom
		Creates a custom object instance at specified location and angle of rotation.  The calling function can also set whether the pref dialog should appear.
	'''
	pass
	return 'HANDLE' # 


def CreateCustomObjectPath(
		objectName  , # STRING - Name of object.                    
		path        , # HANDLE - Handle to new object path polygon. 
		profileGroup  # HANDLE - Handle to new profile group object.
		):
	'''
		Python: HANDLE = vs.CreateCustomObjectPath(objectName, path, profileGroup)
		VectorScript: FUNCTION CreateCustomObjectPath(objectName:STRING; path:HANDLE; profileGroup:HANDLE) : HANDLE;
		
		Category: Objects - Custom
		Creates an instance of the path custom object specified by the name argument.  The vertices of the path are translated in such a way that the first vertex will be placed at the origin of the plug-in's coordinate space.
	'''
	pass
	return 'HANDLE' # Returns a HANDLE to the new path object.


def CreateCustThumbPopup(
		dialogID , # LONGINT - The dialog identifier given by the command to create the dialog.
		controlID, # LONGINT - The identifier that should be assigned to the control.          
		sizeType   # INTEGER - The size type of the control                                    
		):
	'''
		Python: vs.CreateCustThumbPopup(dialogID, controlID, sizeType)
		VectorScript: PROCEDURE CreateCustThumbPopup(dialogID:LONGINT; controlID:LONGINT; sizeType:INTEGER);
		
		Category: Dialogs - Modern
		Creates a custom thumbnail popup that can be populated with previews of objects in Vectorworks.
	'''
	pass


def CreateDesignLayerPullDownMenu(
		nDialogID     , # LONGINT -                                                                                       
		nComponentID  , # LONGINT -                                                                                       
		widthInStdChar  # INTEGER - The width of the displayed text in standard character count. See GetDlgCtrlWidthStdCh.
		):
	'''
		Python: vs.CreateDesignLayerPullDownMenu(nDialogID, nComponentID, widthInStdChar)
		VectorScript: PROCEDURE CreateDesignLayerPullDownMenu(nDialogID:LONGINT; nComponentID:LONGINT; widthInStdChar:INTEGER);
		
		Category: Dialogs - Modern
		Creates a Layout Manager design layer pull down menu control.
	'''
	pass


def CreateDuplicateObject(
		objectToDuplicate, # HANDLE - The object to be duplicated                 
		containerHandle    # HANDLE - The container to the newly duplicated object
		):
	'''
		Python: HANDLE = vs.CreateDuplicateObject(objectToDuplicate, containerHandle)
		VectorScript: FUNCTION CreateDuplicateObject(objectToDuplicate:HANDLE; containerHandle:HANDLE) : HANDLE;
		
		Category: Object Editing
		Duplicates the specified object and inserts the new  object into the container.  If container is nil, the new object will be inserted in the active container.
	'''
	pass
	return 'HANDLE' # 


def CreateEditInteger(
		dialogID      , # LONGINT - The index of the dialog layout containing the control.                                
		itemID        , # LONGINT - The index that will identify the control item.                                        
		defaultValue  , # LONGINT - Default value for the field.                                                          
		widthInStdChar  # LONGINT - The width of the displayed text in standard character count. See GetDlgCtrlWidthStdCh.
		):
	'''
		Python: vs.CreateEditInteger(dialogID, itemID, defaultValue, widthInStdChar)
		VectorScript: PROCEDURE CreateEditInteger(dialogID:LONGINT; itemID:LONGINT; defaultValue:LONGINT; widthInStdChar:LONGINT);
		
		Category: Dialogs - Modern
		Creates an editable text field control for INTEGER and LONGINT values.
		CreateEditInteger is intended specifically for entry of numeric values; the control returns values in a numeric format, and supports calculations within the control field.
	'''
	pass


def CreateEditPassword(
		dialogID      , # LONGINT - The index of the dialog layout containing the control.                                
		itemID        , # LONGINT - The index that will identify the control item.                                        
		widthInStdChar  # LONGINT - The width of the displayed text in standard character count. See GetDlgCtrlWidthStdCh.
		):
	'''
		Python: vs.CreateEditPassword(dialogID, itemID, widthInStdChar)
		VectorScript: PROCEDURE CreateEditPassword(dialogID:LONGINT; itemID:LONGINT; widthInStdChar:LONGINT);
		
		Category: Dialogs - Modern
		Creates an password text field control in a dialog layout.
	'''
	pass


def CreateEditReal(
		dialogID      , # LONGINT - The index of the dialog layout containing the control.                                
		itemID        , # LONGINT - The index that will identify the control item.                                        
		editRealType  , # LONGINT - The type of REAL value being accepted.                                                
		defaultValue  , # REAL    - Default value for the field.                                                          
		widthInStdChar  # LONGINT - The width of the displayed text in standard character count. See GetDlgCtrlWidthStdCh.
		):
	'''
		Python: vs.CreateEditReal(dialogID, itemID, editRealType, defaultValue, widthInStdChar)
		VectorScript: PROCEDURE CreateEditReal(dialogID:LONGINT; itemID:LONGINT; editRealType:LONGINT; defaultValue:REAL; widthInStdChar:LONGINT);
		
		Category: Dialogs - Modern
		Creates an editable text field control for REAL values.
		CreateEditReal is intended specifically for entry of numeric values; the control returns values in a numeric format, and supports calculations within the control field.
	'''
	pass


def CreateEditText(
		dialogID      , # LONGINT - The index of the dialog layout containing the control.                                
		itemID        , # LONGINT - The index that will identify the control item.                                        
		defaultText   , # STRING  - The default display text for the control.                                             
		widthInStdChar  # LONGINT - The width of the displayed text in standard character count. See GetDlgCtrlWidthStdCh.
		):
	'''
		Python: vs.CreateEditText(dialogID, itemID, defaultText, widthInStdChar)
		VectorScript: PROCEDURE CreateEditText(dialogID:LONGINT; itemID:LONGINT; defaultText:STRING; widthInStdChar:LONGINT);
		
		Category: Dialogs - Modern
		Creates an editable text field control in a dialog layout.
	'''
	pass


def CreateEditTextBox(
		dialogID      , # LONGINT - The id of the dialog                                                                  
		itemID        , # LONGINT - The id of the text box control.                                                       
		defaultText   , # STRING  - The initial text.                                                                     
		widthInStdChar, # LONGINT - The width of the displayed text in standard character count. See GetDlgCtrlWidthStdCh.
		heightInLines   # LONGINT - Height of the control in lines.                                                       
		):
	'''
		Python: vs.CreateEditTextBox(dialogID, itemID, defaultText, widthInStdChar, heightInLines)
		VectorScript: PROCEDURE CreateEditTextBox(dialogID:LONGINT; itemID:LONGINT; defaultText:STRING; widthInStdChar:LONGINT; heightInLines:LONGINT);
		
		Category: Dialogs - Modern
		Creates a scrolling multiline editable text field in a dialog layout.
	'''
	pass


def CreateEnhancedPullDownMenu(
		dialogID             , # LONGINT -                                                                                       
		componentID          , # LONGINT -                                                                                       
		widthInStdChar       , # INTEGER - The width of the displayed text in standard character count. See GetDlgCtrlWidthStdCh.
		bShowIconInMainWindow  # BOOLEAN -                                                                                       
		):
	'''
		Python: vs.CreateEnhancedPullDownMenu(dialogID, componentID, widthInStdChar, bShowIconInMainWindow)
		VectorScript: PROCEDURE CreateEnhancedPullDownMenu(dialogID:LONGINT; componentID:LONGINT; widthInStdChar:INTEGER; bShowIconInMainWindow:BOOLEAN);
		
		Category: Dialogs - Modern
		Creates a Layout Manager enhanced pull down menu control.
	'''
	pass


def CreateExtrudeAlongPath(
		pathHandle   , # HANDLE - Handle to the path object.   
		profileHandle  # HANDLE - Handle to the profile object.
		):
	'''
		Python: HANDLE = vs.CreateExtrudeAlongPath(pathHandle, profileHandle)
		VectorScript: FUNCTION CreateExtrudeAlongPath(pathHandle:HANDLE; profileHandle:HANDLE) : HANDLE;
		
		Category: Objects - 3D
		Creates a new path extrude object in the document.  The profile defines the shape of the cross-section, and is extruded along the path to generate the resulting object.
		The path argument must be a handle to a NURBS Curve object (type 111).  The profile argument must be a handle to an object of one of the following types: NURBS Curve, Polygon, Polyline, Arc, Rectangle, Rounded Rectangle, Line, Oval.
	'''
	pass
	return 'HANDLE' # Returns a HANDLE to the new path extrude if successful, otherwise returns NIL.


def CreateFillSpace(
		owner  # HANDLE - Handle to the object in whose aux list the fill space will be created.
		):
	'''
		Python: HANDLE = vs.CreateFillSpace(owner)
		VectorScript: FUNCTION CreateFillSpace(owner:HANDLE) : HANDLE;
		
		Category: Object Attributes
		Creates a new fillspace object and attaches it to the end of the aux list of the specified object.
	'''
	pass
	return 'HANDLE' # Handle to the newly created fill space object.


def CreateFolder(
		path  # DYNARRAY[] of CHAR -  
		):
	'''
		Python: BOOLEAN = vs.CreateFolder(path)
		VectorScript: FUNCTION CreateFolder(path:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: File I/O
		Creates a folder on the hard drive.
	'''
	pass
	return 'BOOLEAN' # 


def CreateGableDormer(
		roofObject  # HANDLE - Handle to roof.
		):
	'''
		Python: INTEGER = vs.CreateGableDormer(roofObject)
		VectorScript: FUNCTION CreateGableDormer(roofObject:HANDLE) : INTEGER;
		
		Category: Objects - Roofs
		Function CreateGableDormer creates a gable dormer in the referenced roof object.
	'''
	pass
	return 'INTEGER' # 


def CreateGradient(
		name  # STRING - A user-specified name by which the newly created gradient will be identified.
		):
	'''
		Python: HANDLE = vs.CreateGradient(name)
		VectorScript: FUNCTION CreateGradient(name:STRING) : HANDLE;
		
		Category: Dialogs - Modern
		Creates a new gradient resource.
	'''
	pass
	return 'HANDLE' # Returns a handle to a new gradient resource if successful, otherwise the function returns nil.


def CreateGroupBox(
		dialogID, # LONGINT - The index of the dialog layout containing the control.
		itemID  , # LONGINT - The index that will identify the control item.        
		text    , # STRING  - The display text for the control.                     
		hasFrame  # BOOLEAN - Displays a border for the group box.                  
		):
	'''
		Python: vs.CreateGroupBox(dialogID, itemID, text, hasFrame)
		VectorScript: PROCEDURE CreateGroupBox(dialogID:LONGINT; itemID:LONGINT; text:STRING; hasFrame:BOOLEAN);
		
		Category: Dialogs - Modern
		Creates a new group box control in a dialog layout.
		The width of a group box is determined by the width of the longest control enclosed by the group box. The height of the group box is determined by the combined height of the enclosed controls.
		While used primarily to contain and highlight related control items, group box controls can also be used to group controls for easier positioning. When used in this fashion, pass a blank string for the display text and set the frame display to FALSE.
	'''
	pass


def CreateGroupOutline(
		objectName  # HANDLE -  
		):
	'''
		Python: HANDLE = vs.CreateGroupOutline(objectName)
		VectorScript: FUNCTION CreateGroupOutline(objectName:HANDLE) : HANDLE;
		
		Category: Objects - Custom
		Returns a handle to the polygon which is the outline of a group.
	'''
	pass
	return 'HANDLE' # 


def CreateHemisphere(
		center, # POINT3D - Center point of hemisphere.
		top     # POINT3D - Top point of hemisphere.   
		):
	'''
		Python: HANDLE = vs.CreateHemisphere(center, top)
		VectorScript: FUNCTION CreateHemisphere(centerX, centerY, centerZ:REAL; topX, topY, topZ:REAL) : HANDLE;
		
		Category: Objects - Solids
		Function CreateHemisphere creates a new hemisphere object in a Vectorworks document.
	'''
	pass
	return 'HANDLE' # The function returns a handle to the new hemisphere object.


def CreateHipDormer(
		roofObject  # HANDLE - Handle to roof.
		):
	'''
		Python: INTEGER = vs.CreateHipDormer(roofObject)
		VectorScript: FUNCTION CreateHipDormer(roofObject:HANDLE) : INTEGER;
		
		Category: Objects - Roofs
		Function CreateHipDormer creates a hip dormer in the referenced roof object.
	'''
	pass
	return 'INTEGER' # 


def CreateHLHandle(
		):
	'''
		Python: HLOptionsHandle = vs.CreateHLHandle()
		VectorScript: PROCEDURE CreateHLHandle(VAR HLOptionsHandle:HANDLE);
		
		Category: View / Zoom
		Create a new Hidden Line Rendering options handle.
	'''
	pass
	return ( 0 )


def CreateIconPushButton(
		nDialogID     , # LONGINT -                                                                                       
		nComponentID  , # LONGINT -                                                                                       
		nIconID       , # INTEGER - the index of the ICN# resource in the currently open rsrc file (or qtr on Windows)    
		widthInStdChar  # INTEGER - The width of the displayed text in standard character count. See GetDlgCtrlWidthStdCh.
		):
	'''
		Python: vs.CreateIconPushButton(nDialogID, nComponentID, nIconID, widthInStdChar)
		VectorScript: PROCEDURE CreateIconPushButton(nDialogID:LONGINT; nComponentID:LONGINT; nIconID:INTEGER; widthInStdChar:INTEGER);
		
		Category: Dialogs - Modern
		Creates an icon push button with the specified icon ID and width in characters.
	'''
	pass


def CreateImageControl(
		dialogID     , # LONGINT -  
		componentID  , # LONGINT -  
		iWidthPixels , # INTEGER -  
		iHeightPixels, # INTEGER -  
		hImage         # HANDLE  -  
		):
	'''
		Python: vs.CreateImageControl(dialogID, componentID, iWidthPixels, iHeightPixels, hImage)
		VectorScript: PROCEDURE CreateImageControl(dialogID:LONGINT; componentID:LONGINT; iWidthPixels:INTEGER; iHeightPixels:INTEGER; hImage:HANDLE);
		
		Category: Dialogs - Modern
		Creates a Layout Manager image control.
	'''
	pass


def CreateImageControl2(
		dialogID      , # LONGINT            - The dialog identifier given by the command to create the dialog.                                                 
		controlID     , # LONGINT            - The identifier that should be assigned to the control.                                                           
		widthInPixels , # INTEGER            - The width of the control. Use zero to let the image dictate the dimension                                        
		heightInPixels, # INTEGER            - The height of the control. Use zero to let the image dictate the dimension                                       
		imageSpecifier  # DYNARRAY[] of CHAR - The string identifier for the image. It should be of the form "ResourceFileNameWithoutExtension/PathOfImageFile".
		):
	'''
		Python: vs.CreateImageControl2(dialogID, controlID, widthInPixels, heightInPixels, imageSpecifier)
		VectorScript: PROCEDURE CreateImageControl2(dialogID:LONGINT; controlID:LONGINT; widthInPixels:INTEGER; heightInPixels:INTEGER; imageSpecifier:DYNARRAY of CHAR);
		
		Category: Dialogs - Modern
	'''
	pass


def CreateImageFromPaint(
		paint    , # HANDLE - Handle to the paint node to be used to create the image resource.           
		imageName  # STRING - User-specified name to be used to identify the newly created image resource.
		):
	'''
		Python: HANDLE = vs.CreateImageFromPaint(paint, imageName)
		VectorScript: FUNCTION CreateImageFromPaint(paint:HANDLE; imageName:STRING) : HANDLE;
		
		Category: Document Attributes
		Creates an image resource from a paint node.
	'''
	pass
	return 'HANDLE' # Returns the handle to the newly create image resource if successful; nil otherwise.


def CreateImageProp(
		propName               , # STRING  -  
		textureRef             , # LONGINT -  
		height                 , # REAL    -  
		width                  , # REAL    -  
		enforceImageAspectRatio, # BOOLEAN -  
		crossedPlanes          , # BOOLEAN -  
		createPlugin           , # BOOLEAN -  
		autoRotate             , # BOOLEAN -  
		createSymbol             # BOOLEAN -  
		):
	'''
		Python: HANDLE = vs.CreateImageProp(propName, textureRef, height, width, enforceImageAspectRatio, crossedPlanes, createPlugin, autoRotate, createSymbol)
		VectorScript: FUNCTION CreateImageProp(propName:STRING; textureRef:LONGINT; height:REAL; width:REAL; enforceImageAspectRatio:BOOLEAN; crossedPlanes:BOOLEAN; createPlugin:BOOLEAN; autoRotate:BOOLEAN; createSymbol:BOOLEAN) : HANDLE;
		
		Category: Objects - 3D
		Create an image prop from the options specified.
		The texture resource and optional symbol created will use names derived from the propName parameter.  If those names are being used then unique names will be assigned.  If enforceImageAspectRatio is true, depending on deriveWidthFromHeight the prop width/height will be derived from the prop height/width and the texture's image aspect ratio. Otherwise the height and width can be set independently of the texture's image aspect ratio.
	'''
	pass
	return 'HANDLE' # 


def CreateImagePushButton(
		dialogID      , # LONGINT            - The dialog identifier given by the command to create the dialog.                                                 
		controlID     , # LONGINT            - The identifier that should be assigned to the control.                                                           
		widthInStdChar, # INTEGER            - The width of the displayed text in standard character count. See GetDlgCtrlWidthStdCh.                           
		imageSpecifier  # DYNARRAY[] of CHAR - The string identifier for the image. It should be of the form "ResourceFileNameWithoutExtension/PathOfImageFile".
		):
	'''
		Python: vs.CreateImagePushButton(dialogID, controlID, widthInStdChar, imageSpecifier)
		VectorScript: PROCEDURE CreateImagePushButton(dialogID:LONGINT; controlID:LONGINT; widthInStdChar:INTEGER; imageSpecifier:DYNARRAY of CHAR);
		
		Category: Dialogs - Modern
		Creates an image push button. Replaces CreateIconPushButton
	'''
	pass


def CreateImgFromSymbol(
		symbolName  , # STRING  - The name of the symbol to display.               
		symbolHeight, # INTEGER - The height of the symbol to display.             
		symbolWidth , # INTEGER - The width of the symbol to display.              
		symbolMargin, # INTEGER - The margin of the symbol to display.             
		renderMode  , # INTEGER - The render mode in which to display the symbol.  
		view          # INTEGER - The standard view in which to display the symbol.
		):
	'''
		Python: HANDLE = vs.CreateImgFromSymbol(symbolName, symbolHeight, symbolWidth, symbolMargin, renderMode, view)
		VectorScript: FUNCTION CreateImgFromSymbol(symbolName:STRING; symbolHeight:INTEGER; symbolWidth:INTEGER; symbolMargin:INTEGER; renderMode:INTEGER; view:INTEGER) : HANDLE;
		
		Category: Document Attributes
	'''
	pass
	return 'HANDLE' # Returns the handle to the newly create image resource if successful; nil otherwise.


def CreateImgFromSymbolN(
		symbolName, # STRING  - The name of the symbol to display.               
		width     , # INTEGER - The width of the symbol to display.              
		height    , # INTEGER - The height of the symbol to display.             
		margin    , # INTEGER - The margin of the symbol to display.             
		renderMode, # INTEGER - The render mode in which to display the symbol.  
		view      , # INTEGER - The standard view in which to display the symbol.
		component   # INTEGER - Image component to use.                          
		):
	'''
		Python: HANDLE = vs.CreateImgFromSymbolN(symbolName, width, height, margin, renderMode, view, component)
		VectorScript: FUNCTION CreateImgFromSymbolN(symbolName:STRING; width:INTEGER; height:INTEGER; margin:INTEGER; renderMode:INTEGER; view:INTEGER; component:INTEGER) : HANDLE;
		
		Category: Document Attributes
		Creates an image  from the specified symbol in the specified rendering mode and view, and uses the specified component of the image.       Table - Render Modes
		Render Mode                  Constant
		Wireframe 			0
		Unshaded Polygon 		2
		Shaded Polygon 			3
		Shaded Polygon No Lines 	4
		Final Shaded Polygon 		5
		Hidden Line 			6
		Dashed Hidden Line 		7
		OpenGL 				11
		Fast RenderWorks 		12
		Fast RenderWorks with Shadows 	13
		Final Quality RenderWorks 	14
		Custom RenderWorks 		15
		Artistic RenderWorks 		17
		Sketch 				18
		Table - Views
		View 				Constant
		Top/Plan 			2
		Front 				3
		Back 				4
		Left 				5
		Right 				6
		Top 				7
		Bottom 				8
		Right Isometric 		9
		Left Isometric 			10
		Right Rear Isometric 		11
		Left Rear Isometric 		12
		Bottom Right Isometric 		13
		Bottom Left Isometric 		14
		Bottom Right Rear Isometric 	15
		Bottom Left Rear Isometric 	16
		Table - Components
		Component			Constant
		"3D" 				0
		"2D"				1
		"2D Cut"			2
		"Not set"			4
	'''
	pass
	return 'HANDLE' # Returns the handle to the newly create image resource if successful; NULL otherwise. 


def CreateInterpolatedSurface(
		surfaceHandle, # HANDLE  - Handle to a NURBS surface to approximate                                                    
		numUPts      , # LONGINT - Number of interpolation points in the U parametric direction.  Must be greater than uDegree.
		numVPts      , # LONGINT - Number of interpolation points in the V parametric direction.  Must be greater than vDegree.
		uDegree      , # INTEGER - Degree of the surface in the u parametric direction                                         
		vDegree        # INTEGER - Degree of the surface in the v parametric direction                                         
		):
	'''
		Python: HANDLE = vs.CreateInterpolatedSurface(surfaceHandle, numUPts, numVPts, uDegree, vDegree)
		VectorScript: FUNCTION CreateInterpolatedSurface(surfaceHandle:HANDLE; numUPts:LONGINT; numVPts:LONGINT; uDegree:INTEGER; vDegree:INTEGER) : HANDLE;
		
		Category: Objects - NURBS
		Creates an interpolated surface with the specified degrees and number of points.  The resulting surface passes through each of the interpoliation points.  If a handle to a NURBS surface is provided, the interpolated surface will approximate that surface.  If the handle is NULL, it creates a rectangular surface.
	'''
	pass
	return 'HANDLE' # Handle to the new interpolated surface object. 


def CreateLayer(
		layerName, # STRING  -  
		layerType  # INTEGER -  
		):
	'''
		Python: HANDLE = vs.CreateLayer(layerName, layerType)
		VectorScript: FUNCTION CreateLayer(layerName:STRING; layerType:INTEGER) : HANDLE;
		
		Category: Layers
		Creates a layer of the specified type.
		layerType values:
		Design = 1
		Presentation	= 2
	'''
	pass
	return 'HANDLE' # 


def CreateLayerLevelType(
		name  # STRING - The name of the Layer Level Type to create.
		):
	'''
		Python: BOOLEAN = vs.CreateLayerLevelType(name)
		VectorScript: FUNCTION CreateLayerLevelType(name:STRING) : BOOLEAN;
		
		Category: Layers
		Creates a Layer Level Type.  A Layer can be assigned a Layer Level Type, which defines its location within a Story.
	'''
	pass
	return 'BOOLEAN' # Whether a Layer Level Type was successfully created.


def CreateLayout(
		dialogTitle      , # STRING  - Title of the dialog.                               
		hasHelp          , # BOOLEAN - Enables help text for the dialog.                  
		defaultButtonName, # STRING  - Text displayed in the default button of the dialog.
		cancelButtonName   # STRING  - Text displayed in the cancel button of the dialog. 
		):
	'''
		Python: LONGINT = vs.CreateLayout(dialogTitle, hasHelp, defaultButtonName, cancelButtonName)
		VectorScript: FUNCTION CreateLayout(dialogTitle:STRING; hasHelp:BOOLEAN; defaultButtonName:STRING; cancelButtonName:STRING) : LONGINT;
		
		Category: Dialogs - Modern
		Creates a new custom dialog layout. After the layout is created, control items for the dialog can be added to the layout.
	'''
	pass
	return 'LONGINT' # Returns an index number identifying the new dialog layout.


def CreateLB(
		dialogID      , # LONGINT - id of the dialog that contains the list browser                                       
		componentID   , # LONGINT - id of the list browser control                                                        
		widthInStdChar, # INTEGER - The width of the displayed text in standard character count. See GetDlgCtrlWidthStdCh.
		heightInLines   # INTEGER - the height of the control in characters                                               
		):
	'''
		Python: vs.CreateLB(dialogID, componentID, widthInStdChar, heightInLines)
		VectorScript: PROCEDURE CreateLB(dialogID:LONGINT; componentID:LONGINT; widthInStdChar:INTEGER; heightInLines:INTEGER);
		
		Category: Dialogs - Modern - Browser
		Creates a layout manager list browser control.
	'''
	pass


def CreateLevelTemplate(
		layerName  , # STRING - The layer name for the new Story Level Template.  This can be blank, meaning that layers will not be created for instances of the new Story Level Template.       
		scaleFactor, # REAL   - The scale factor for the (optional) layer associated with this Story Level Template.                                                                              
		levelType  , # STRING - The level type for the new Story Level Template.  There may be multiple Story Level Templates with the same level type, as long as they have different elevations.
		elevation  , # REAL   - The elevation of the Story Level Template, relative to the height of the story in which the level is used.                                                        
		wallHeight   # REAL   - The wall height for (optional) layers created when using this Story Level Template in a Story.  If the layer name is empty, this parameter is unused.             
		):
	'''
		Python: (BOOLEAN, index) = vs.CreateLevelTemplate(layerName, scaleFactor, levelType, elevation, wallHeight)
		VectorScript: FUNCTION CreateLevelTemplate(layerName:STRING; scaleFactor:REAL; levelType:STRING; elevation:REAL; wallHeight:REAL; VAR index:INTEGER) : BOOLEAN;
		
		Category: Layers
		Creates a Story Level Template in the current file. Sets the index parameter to the index of the new template in the list of templates. Story Levels contain a level type, elevation, and optional layer to be used to bound objects on stories; Story Level Templates define a generic level that can be added to multiple stories.
	'''
	pass
	return ( False  , # Whether the Story Level Template was successfully created.
	         0       )


def CreateLight(
		pXR       , # REAL    - X coordinate of new light.               
		pYR       , # REAL    - Y coordinate of new light.               
		pZR       , # REAL    - Z coordinate of new light.               
		lightType , # INTEGER - Light type.                              
		isOn      , # BOOLEAN - On-off status of light.                  
		castShadow  # BOOLEAN - Specifies whether light will cast shadow.
		):
	'''
		Python: HANDLE = vs.CreateLight(pXR, pYR, pZR, lightType, isOn, castShadow)
		VectorScript: FUNCTION CreateLight(pXR:REAL; pYR:REAL; pZR:REAL; lightType:INTEGER; isOn:BOOLEAN; castShadow:BOOLEAN) : HANDLE;
		
		Category: Objects - Lights
		CreateLight creates a new light object in the active VectorScript document.
		A new light objects' color is defaulted to white, and brightness is defaulted to 75%.
	'''
	pass
	return 'HANDLE' # 


def CreateLineAttributePopup(
		dialogID, # LONGINT -  
		itemID    # LONGINT -  
		):
	'''
		Python: vs.CreateLineAttributePopup(dialogID, itemID)
		VectorScript: PROCEDURE CreateLineAttributePopup(dialogID:LONGINT; itemID:LONGINT);
		
		Category: Dialogs - Modern
		Create a dialog control that displays both line style and line weight choices available in the current document.
	'''
	pass


def CreateLineStylePopup(
		dialogID, # LONGINT -  
		itemID    # LONGINT -  
		):
	'''
		Python: vs.CreateLineStylePopup(dialogID, itemID)
		VectorScript: PROCEDURE CreateLineStylePopup(dialogID:LONGINT; itemID:LONGINT);
		
		Category: Dialogs - Modern
		Create a dialog control that displays the line style choices available in the active document.
	'''
	pass


def CreateLineWeightPopup(
		dialogID, # LONGINT -  
		itemID    # LONGINT -  
		):
	'''
		Python: vs.CreateLineWeightPopup(dialogID, itemID)
		VectorScript: PROCEDURE CreateLineWeightPopup(dialogID:LONGINT; itemID:LONGINT);
		
		Category: Dialogs - Modern
		Create a line weight popup dialog control to display list of line weights available in current document.
	'''
	pass


def CreateListBox(
		dialogID      , # LONGINT - The index of the dialog layout containing the control.                                
		itemID        , # LONGINT - The index that will identify the control item.                                        
		widthInStdChar, # LONGINT - The width of the displayed text in standard character count. See GetDlgCtrlWidthStdCh.
		heightInLines   # LONGINT - The height of the control in characters.                                              
		):
	'''
		Python: vs.CreateListBox(dialogID, itemID, widthInStdChar, heightInLines)
		VectorScript: PROCEDURE CreateListBox(dialogID:LONGINT; itemID:LONGINT; widthInStdChar:LONGINT; heightInLines:LONGINT);
		
		Category: Dialogs - Modern
		Creates a new list box control in a dialog layout.
	'''
	pass


def CreateListBoxN(
		dialogID        , # LONGINT - The index of the dialog layout containing the control.                                
		itemID          , # LONGINT - The index that will identify the control item.                                        
		widthInStdChar  , # LONGINT - The width of the displayed text in standard character count. See GetDlgCtrlWidthStdCh.
		heightInLines   , # LONGINT - The height of the control in characters.                                              
		isMultipleSelect  # BOOLEAN - Does the list support multiple selection                                              
		):
	'''
		Python: vs.CreateListBoxN(dialogID, itemID, widthInStdChar, heightInLines, isMultipleSelect)
		VectorScript: PROCEDURE CreateListBoxN(dialogID:LONGINT; itemID:LONGINT; widthInStdChar:LONGINT; heightInLines:LONGINT; isMultipleSelect:BOOLEAN);
		
		Category: Dialogs - Modern
		Creates a new list box control in a dialog layout. With isMultipleSelect true, the list supports multiple selection.
	'''
	pass


def CreateLoftSurfaces(
		groupCurvesHd, # HANDLE  -  
		bRule        , # BOOLEAN -  
		bClose       , # BOOLEAN -  
		bSolid         # BOOLEAN -  
		):
	'''
		Python: HANDLE = vs.CreateLoftSurfaces(groupCurvesHd, bRule, bClose, bSolid)
		VectorScript: FUNCTION CreateLoftSurfaces(groupCurvesHd:HANDLE; bRule:BOOLEAN; bClose:BOOLEAN; bSolid:BOOLEAN) : HANDLE;
		
		Category: Objects - NURBS
		Creates NURBS surfaces by interpolating a group of cross-section curves.  The nurbs curves are lofted in the order in which they were added to the group.
	'''
	pass
	return 'HANDLE' # 


def CreateMarkerPopup(
		dialogID   , # LONGINT - Id of the dialog       
		componentID  # LONGINT - Id of the popup control
		):
	'''
		Python: vs.CreateMarkerPopup(dialogID, componentID)
		VectorScript: PROCEDURE CreateMarkerPopup(dialogID:LONGINT; componentID:LONGINT);
		
		Category: Dialogs - Modern
		Creates a popup control that displays the various marker styles available in Vectorworks and allows the user to choose one.  Markers are the adornments at the endpoints of line objects and consist of styles like arrow, circle, cross, etc.
	'''
	pass


def CreateNewXMLDocument(
		XMLHandle      , # LONGINT            -  
		rootElementName  # DYNARRAY[] of CHAR -  
		):
	'''
		Python: INTEGER = vs.CreateNewXMLDocument(XMLHandle, rootElementName)
		VectorScript: FUNCTION CreateNewXMLDocument(XMLHandle:LONGINT; rootElementName:DYNARRAY of CHAR) : INTEGER;
		
		Category: XML
		Creates a new XML document.
	'''
	pass
	return 'INTEGER' # 


def CreateNurbsCurve(
		first    , # POINT3D - Coordinates of the first point in the curve definiton.
		byCtrlPts, # BOOLEAN - Create curve by control points (not interpolation).   
		degree     # INTEGER - The degree of the NURBS curve.                        
		):
	'''
		Python: HANDLE = vs.CreateNurbsCurve(first, byCtrlPts, degree)
		VectorScript: FUNCTION CreateNurbsCurve(firstX, firstY, firstZ:REAL; byCtrlPts:BOOLEAN; degree:INTEGER) : HANDLE;
		
		Category: Objects - NURBS
		Creates a new NURBS curve in the document.
	'''
	pass
	return 'HANDLE' # Returns a HANDLE to the new NURBS curve if successful, otherwise returns NIL.


def CreateNurbsSurface(
		numUPts, # LONGINT - The number of definition points along the u-axis of the surface.
		numVPts, # LONGINT - The number of definition points along the v-axis of the surface.
		uDegree, # INTEGER - Degree of the NURBS curve in the u direction.                   
		vDegree  # INTEGER - Degree of the NURBS curve in the v direction.                   
		):
	'''
		Python: HANDLE = vs.CreateNurbsSurface(numUPts, numVPts, uDegree, vDegree)
		VectorScript: FUNCTION CreateNurbsSurface(numUPts:LONGINT; numVPts:LONGINT; uDegree:INTEGER; vDegree:INTEGER) : HANDLE;
		
		Category: Objects - NURBS
		Creates a new NURBS surface in the document. The surface has two directions, denoted u and v. The surface acts like a set of NURBS curves in each direction, with the number of control points and the degree specified in the parameter list. (Note that the degree parameters have to be lower than the numPts parameters.)
		After creating the surface, you must set the location of each of the control points with NurbsSetPt3D, and when you are done call ResetBBox to make sure the bounding box is correct.
	'''
	pass
	return 'HANDLE' # Returns a HANDLE to the newly created NURBS surface object if successful, otherwise returns NIL.


def CreateOffsetNurbsObjectHandle(
		h             , # HANDLE            - Handle to object.                          
		offsetDistance  # REAL (Coordinate) - Offset distance. Positive offsets outwards.
		):
	'''
		Python: HANDLE = vs.CreateOffsetNurbsObjectHandle(h, offsetDistance)
		VectorScript: FUNCTION CreateOffsetNurbsObjectHandle(h:HANDLE; offsetDistance:REAL (Coordinate)) : HANDLE;
		
		Category: Objects - NURBS
		Returns a handle to a NURBS object that is offset from the given NURBS object h by the offset distance.
	'''
	pass
	return 'HANDLE' # 


def CreateOpenGLHandle(
		):
	'''
		Python: GLHandle = vs.CreateOpenGLHandle()
		VectorScript: PROCEDURE CreateOpenGLHandle(VAR GLHandle:HANDLE);
		
		Category: View / Zoom
		Return a new OpenGL options handle.
	'''
	pass
	return ( 0 )


def CreatePaintFromImage(
		image  # HANDLE - Handle to the image resource from which a paint node is to be created.
		):
	'''
		Python: HANDLE = vs.CreatePaintFromImage(image)
		VectorScript: FUNCTION CreatePaintFromImage(image:HANDLE) : HANDLE;
		
		Category: Textures
		Creates a paint node from an image resource.
	'''
	pass
	return 'HANDLE' # Returns the handle to the newly created paint node.


def CreatePaintFromImgN(
		image , # HANDLE - Handle to the image resource from which a paint node is to be created.
		locPt , # POINT  - Location of the new paint nodet.                                      
		rotDeg  # REAL   - Rotation of the paint node in degrees.                                
		):
	'''
		Python: HANDLE = vs.CreatePaintFromImgN(image, locPt, rotDeg)
		VectorScript: FUNCTION CreatePaintFromImgN(image:HANDLE; locPtX, locPtY:REAL; rotDeg:REAL) : HANDLE;
		
		Category: Textures
		Creates a paint node from an image resource on the specified location and rotation.
	'''
	pass
	return 'HANDLE' # 


def CreatePatternPopup(
		dialogID, # LONGINT -  
		itemID    # LONGINT -  
		):
	'''
		Python: vs.CreatePatternPopup(dialogID, itemID)
		VectorScript: PROCEDURE CreatePatternPopup(dialogID:LONGINT; itemID:LONGINT);
		
		Category: Dialogs - Modern
		Create a pattern popup dialog control that displays all fill patterns available in current document.
	'''
	pass


def CreatePullDownMenu(
		dialogID      , # LONGINT - The index of the dialog layout containing the control.                                
		itemID        , # LONGINT - The index that will identify the control item.                                        
		widthInStdChar  # LONGINT - The width of the displayed text in standard character count. See GetDlgCtrlWidthStdCh.
		):
	'''
		Python: vs.CreatePullDownMenu(dialogID, itemID, widthInStdChar)
		VectorScript: PROCEDURE CreatePullDownMenu(dialogID:LONGINT; itemID:LONGINT; widthInStdChar:LONGINT);
		
		Category: Dialogs - Modern
		Creates a new pulldown menu control in a dialog layout.
	'''
	pass


def CreatePullDownMenuGroupBox(
		liDialogID    , # LONGINT -                                                                                       
		liComponentID , # LONGINT -                                                                                       
		widthInStdChar, # INTEGER - The width of the displayed text in standard character count. See GetDlgCtrlWidthStdCh.
		strLabel      , # STRING  -                                                                                       
		bHasFrame       # BOOLEAN -                                                                                       
		):
	'''
		Python: vs.CreatePullDownMenuGroupBox(liDialogID, liComponentID, widthInStdChar, strLabel, bHasFrame)
		VectorScript: PROCEDURE CreatePullDownMenuGroupBox(liDialogID:LONGINT; liComponentID:LONGINT; widthInStdChar:INTEGER; strLabel:STRING; bHasFrame:BOOLEAN);
		
		Category: Dialogs - Modern
		Creates a Layout Manager pull down menu group box.
	'''
	pass


def CreatePushButton(
		dialogID, # LONGINT - The index of the dialog layout containing the control.
		itemID  , # LONGINT - The index that will identify the control item.        
		text      # STRING  - The display text for the control.                     
		):
	'''
		Python: vs.CreatePushButton(dialogID, itemID, text)
		VectorScript: PROCEDURE CreatePushButton(dialogID:LONGINT; itemID:LONGINT; text:STRING);
		
		Category: Dialogs - Modern
		Creates a new push button control in a dialog layout.
	'''
	pass


def CreateRadioButton(
		dialogID, # LONGINT - The index of the dialog layout containing the control.
		itemID  , # LONGINT - The index that will identify the control item.        
		text      # STRING  - The display text for the control.                     
		):
	'''
		Python: vs.CreateRadioButton(dialogID, itemID, text)
		VectorScript: PROCEDURE CreateRadioButton(dialogID:LONGINT; itemID:LONGINT; text:STRING);
		
		Category: Dialogs - Modern
		Creates a new radio button control in a dialog layout.
		Radio button groups can be created by defining two or more radio buttons with consecutive index values. When defined as a button group, VectorScript will handle selection-deselection of controls within the group.
	'''
	pass


def CreateRadioButtonGroupBox(
		dialogID, # LONGINT - ID of the dialog                                   
		itemID  , # LONGINT - ID of the radio button group box                   
		name    , # STRING  - Title that appears in the radio button group box   
		hasFrame  # BOOLEAN - True whether the group has a frame; false otherwise
		):
	'''
		Python: vs.CreateRadioButtonGroupBox(dialogID, itemID, name, hasFrame)
		VectorScript: PROCEDURE CreateRadioButtonGroupBox(dialogID:LONGINT; itemID:LONGINT; name:STRING; hasFrame:BOOLEAN);
		
		Category: Dialogs - Modern
		Creates a radio button group box.  The radio button will have name as its label.  If hasFrame is true, the group will have a box drawn around it like a regular group box.
	'''
	pass


def CreateRenderBkg(
		Background  # INTEGER - Background is the type of background the function should rerturn.
		):
	'''
		Python: HANDLE = vs.CreateRenderBkg(Background)
		VectorScript: FUNCTION CreateRenderBkg(Background:INTEGER) : HANDLE;
		
		Category: Objects - 2D
	'''
	pass
	return 'HANDLE' # 


def CreateRenderworksStyle():
	'''
		Python: HANDLE = vs.CreateRenderworksStyle()
		VectorScript: FUNCTION CreateRenderworksStyle : HANDLE;
		
		Category: View / Zoom
	'''
	pass
	return 'HANDLE' # 


def CreateResizableLayout(
		dialogTitle      , # STRING  -  
		hasHelp          , # BOOLEAN -  
		defaultButtonName, # STRING  -  
		cancelButtonName , # STRING  -  
		widthResizable   , # BOOLEAN -  
		heightResizable    # BOOLEAN -  
		):
	'''
		Python: LONGINT = vs.CreateResizableLayout(dialogTitle, hasHelp, defaultButtonName, cancelButtonName, widthResizable, heightResizable)
		VectorScript: FUNCTION CreateResizableLayout(dialogTitle:STRING; hasHelp:BOOLEAN; defaultButtonName:STRING; cancelButtonName:STRING; widthResizable:BOOLEAN; heightResizable:BOOLEAN) : LONGINT;
		
		Category: Dialogs - Modern
		Creates a new resizable Layout Manager dialog.
		Resizable dialogs raise the ResizeDialogC event when resized.
	'''
	pass
	return 'LONGINT' # 


def CreateRightStaticText(
		dialogID      , # LONGINT -                                                                                       
		itemID        , # LONGINT -                                                                                       
		text          , # STRING  -                                                                                       
		widthInStdChar  # INTEGER - The width of the displayed text in standard character count. See GetDlgCtrlWidthStdCh.
		):
	'''
		Python: vs.CreateRightStaticText(dialogID, itemID, text, widthInStdChar)
		VectorScript: PROCEDURE CreateRightStaticText(dialogID:LONGINT; itemID:LONGINT; text:STRING; widthInStdChar:INTEGER);
		
		Category: Dialogs - Modern
		Similar to CreateStaticText, but creates static text that is right-justified in its control field on the dialog.
	'''
	pass


def CreateRoof(
		genGableWall        , # BOOLEAN           - Specifies gable roof generation.         
		bearingInsetDistance, # REAL (Coordinate) - Bearing inset distance of wall into roof.
		roofThickDistance   , # REAL (Coordinate) - Roof thickness.                          
		miterType           , # INTEGER           - Miter style of roof.                     
		vertMiterDistance     # REAL (Coordinate) - Vertical component for double miters.    
		):
	'''
		Python: HANDLE = vs.CreateRoof(genGableWall, bearingInsetDistance, roofThickDistance, miterType, vertMiterDistance)
		VectorScript: FUNCTION CreateRoof(genGableWall:BOOLEAN; bearingInsetDistance:REAL (Coordinate); roofThickDistance:REAL (Coordinate); miterType:INTEGER; vertMiterDistance:REAL (Coordinate)) : HANDLE;
		
		Category: Objects - Roofs
		Function CreateRoof creates a new roof object in a Vectorworks document, returning a handle to the object. To define the roof object template, use AppendRoofEdge.
	'''
	pass
	return 'HANDLE' # 


def CreateRoofStyle(
		roofStyleName  # STRING - The name of the new Roof Style.  If the name is already in use, the next available name will be used.
		):
	'''
		Python: HANDLE = vs.CreateRoofStyle(roofStyleName)
		VectorScript: FUNCTION CreateRoofStyle(roofStyleName:STRING) : HANDLE;
		
		Category: Objects - Architectural
		Creates a new Roof Style of the given name. If the name is already in use, the next available name will be used.
	'''
	pass
	return 'HANDLE' # The new Roof Style.


def CreateRWBackground(
		imageResource  # HANDLE -  
		):
	'''
		Python: HANDLE = vs.CreateRWBackground(imageResource)
		VectorScript: FUNCTION CreateRWBackground(imageResource:HANDLE) : HANDLE;
		
		Category: Objects - 2D
		Creates a Renderworks Background resource using the image from an existing Image resource. Width and height are set to default sizes relative to the page size.
	'''
	pass
	return 'HANDLE' # 


def CreateRWHandle(
		):
	'''
		Python: RWHandle = vs.CreateRWHandle()
		VectorScript: PROCEDURE CreateRWHandle(VAR RWHandle:HANDLE);
		
		Category: View / Zoom
		Create a new RenderWorks options handle.
	'''
	pass
	return ( 0 )


def CreateScriptResource(
		scriptName , # STRING             - A unique name for the new document script.                                                                                                             
		paletteName, # STRING             - A name of the script palette that will contain the new script. If the script palette doesn't exist, it will be created.                                
		paletteOpen, # BOOLEAN            - Pass in TRUE if the script palette should be opened when created, and FALSE if it should be closed. If the palette exist, this parameter has no effect.
		script     , # DYNARRAY[] of CHAR - The script text.                                                                                                                                       
		python       # BOOLEAN            - Pass TRUE if the script text contains python script. Otherwise it will be considered VectorScript.                                                     
		):
	'''
		Python: BOOLEAN = vs.CreateScriptResource(scriptName, paletteName, paletteOpen, script, python)
		VectorScript: FUNCTION CreateScriptResource(scriptName:STRING; paletteName:STRING; paletteOpen:BOOLEAN; script:DYNARRAY of CHAR; python:BOOLEAN) : BOOLEAN;
		
		Category: General Edit
		Create a document script resource.
	'''
	pass
	return 'BOOLEAN' # Return TRUE if the creation was successful. The routine will fail if script with the specified name already exist.


def CreateSearchEditBox(
		dialogID      , # LONGINT - The index of the dialog layout containing the control.                                
		itemID        , # LONGINT - The index that will identify the control item.                                        
		promptText    , # STRING  - The default prompt text for the search control.                                       
		widthInStdChar  # LONGINT - The width of the displayed text in standard character count. See GetDlgCtrlWidthStdCh.
		):
	'''
		Python: vs.CreateSearchEditBox(dialogID, itemID, promptText, widthInStdChar)
		VectorScript: PROCEDURE CreateSearchEditBox(dialogID:LONGINT; itemID:LONGINT; promptText:STRING; widthInStdChar:LONGINT);
		
		Category: Dialogs - Modern
		Creates a search field control in a dialog layout.
	'''
	pass


def CreateSeparator(
		dialogID     , # LONGINT -  
		componentID  , # LONGINT -  
		widthInPixels  # INTEGER -  
		):
	'''
		Python: vs.CreateSeparator(dialogID, componentID, widthInPixels)
		VectorScript: PROCEDURE CreateSeparator(dialogID:LONGINT; componentID:LONGINT; widthInPixels:INTEGER);
		
		Category: Dialogs - Modern
		Creates a Layout Manager image separator.
	'''
	pass


def CreateShaderRecord(
		texture  , # HANDLE  - The shader record will be attached to this texture.                                   
		family   , # LONGINT - The kind of shader to create (1 = color, 2 = reflectivity, 3 = transparency, 4 = bump)
		prototype  # LONGINT - The specific shader within the family (constants depend on the family value).         
		):
	'''
		Python: HANDLE = vs.CreateShaderRecord(texture, family, prototype)
		VectorScript: FUNCTION CreateShaderRecord(texture:HANDLE; family:LONGINT; prototype:LONGINT) : HANDLE;
		
		Category: Textures
		Creates a shader record of the desired family (1 = color, 2 = reflectivity, 3 = transparency, 4 = bump) and prototype (constants depend on family value).
	'''
	pass
	return 'HANDLE' # 


def CreateShedDormer(
		roofObject  # HANDLE - Handle to roof.
		):
	'''
		Python: INTEGER = vs.CreateShedDormer(roofObject)
		VectorScript: FUNCTION CreateShedDormer(roofObject:HANDLE) : INTEGER;
		
		Category: Objects - Roofs
		Function CreateShedDormer creates a shed dormer in the referenced roof object.
	'''
	pass
	return 'INTEGER' # 


def CreateSheetLayerPullDownMenu(
		nDialogID     , # LONGINT -                                                                                       
		nComponentID  , # LONGINT -                                                                                       
		widthInStdChar  # INTEGER - The width of the displayed text in standard character count. See GetDlgCtrlWidthStdCh.
		):
	'''
		Python: vs.CreateSheetLayerPullDownMenu(nDialogID, nComponentID, widthInStdChar)
		VectorScript: PROCEDURE CreateSheetLayerPullDownMenu(nDialogID:LONGINT; nComponentID:LONGINT; widthInStdChar:INTEGER);
		
		Category: Dialogs - Modern
		Creates a Layout Manager sheet layer pull down menu control.
	'''
	pass


def CreateShell(
		surface  , # HANDLE -  
		thickness  # REAL   -  
		):
	'''
		Python: Handle = vs.CreateShell(surface, thickness)
		VectorScript: FUNCTION CreateShell(surface:HANDLE; thickness:REAL) : Handle;
		
		Category: Objects - Solids
		Creates a shelled solid from a NURBS surface.
	'''
	pass
	return 'Handle' # 


def CreateSkylight(
		roofObject  # HANDLE - Handle to roof.
		):
	'''
		Python: INTEGER = vs.CreateSkylight(roofObject)
		VectorScript: FUNCTION CreateSkylight(roofObject:HANDLE) : INTEGER;
		
		Category: Objects - Roofs
		Function CreateSkylight creates a new skylight in the referenced roof object.
	'''
	pass
	return 'INTEGER' # 


def CreateSlab(
		profile  # HANDLE - The profile from which to create the slab.
		):
	'''
		Python: HANDLE = vs.CreateSlab(profile)
		VectorScript: FUNCTION CreateSlab(profile:HANDLE) : HANDLE;
		
		Category: Objects - Architectural
		Creates a slab.
	'''
	pass
	return 'HANDLE' # The slab.


def CreateSlabStyle(
		slabStyleName  # STRING - The name of the new Slab Style.  If the name is already in use, the next available name will be used.
		):
	'''
		Python: HANDLE = vs.CreateSlabStyle(slabStyleName)
		VectorScript: FUNCTION CreateSlabStyle(slabStyleName:STRING) : HANDLE;
		
		Category: Objects - Architectural
		Creates a new Slab Style of the given name. If the name is already in use, the next available name will be used.
	'''
	pass
	return 'HANDLE' # The new Slab Style.


def CreateSphere(
		center        , # POINT3D           - Center point of sphere.
		radiusDistance  # REAL (Coordinate) - Radius of sphere.      
		):
	'''
		Python: HANDLE = vs.CreateSphere(center, radiusDistance)
		VectorScript: FUNCTION CreateSphere(centerX, centerY, centerZ:REAL; radiusDistance:REAL (Coordinate)) : HANDLE;
		
		Category: Objects - Solids
		Function CreateSphere creates a new sphere object in a Vectorworks document.
	'''
	pass
	return 'HANDLE' # The function returns a handle to the new sphere object.


def CreateStandardIconControl(
		dialogID     , # LONGINT - ID of the dialog                                         
		iconControlID, # LONGINT - ID of the control within the dialog                      
		iconNumber     # INTEGER - Constant, listed above, indicating which icon to display.
		):
	'''
		Python: vs.CreateStandardIconControl(dialogID, iconControlID, iconNumber)
		VectorScript: PROCEDURE CreateStandardIconControl(dialogID:LONGINT; iconControlID:LONGINT; iconNumber:INTEGER);
		
		Category: Dialogs - Modern
		Creates a standard icon control, which is used to display the application icon or an alert icon. Valid values for iconNumber are:
		0 - Vectorworks application icon
		1 - Informational icon
		2 - Stop icon
		3 - Exclamation mark (warning) icon
		4 - Question icon
	'''
	pass


def CreateStaticHatch(
		inHatchName  , # STRING - The name of the hatch definition to use for the hatch.             
		p            , # POINT  - A point inside the bounds defined by the current selection         
		rotationAngle  # REAL   - An angle that specifies an offset angle.  Zero degress is due East.
		):
	'''
		Python: HANDLE = vs.CreateStaticHatch(inHatchName, p, rotationAngle)
		VectorScript: FUNCTION CreateStaticHatch(inHatchName:STRING; pX, pY:REAL; rotationAngle:REAL) : HANDLE;
		
		Category: Hatches / Vector Fills
		Creates a static hatch using inHatchName inside the bounded selection surrounding the point. rotationAngle determines the rotation of the result.
	'''
	pass
	return 'HANDLE' # A group of lines in the pattern as specified.


def CreateStaticHatchFromObject(
		inObj        , # HANDLE - An object used as the boundary for the output.                 
		inHatchName  , # STRING - The name of the hatch definition                               
		p            , # POINT  - A point specifying the origin of the output                    
		rotationAngle  # REAL   - An angle specifying an offset angle to use to create the output
		):
	'''
		Python: HANDLE = vs.CreateStaticHatchFromObject(inObj, inHatchName, p, rotationAngle)
		VectorScript: FUNCTION CreateStaticHatchFromObject(inObj:HANDLE; inHatchName:STRING; pX, pY:REAL; rotationAngle:REAL) : HANDLE;
		
		Category: Hatches / Vector Fills
		Creates a static hatch using inHatchName inside the bounds of the inObj.  The pX , pY and rotationAngle arguments determine the hatch origin and rotation used to generate the result.
	'''
	pass
	return 'HANDLE' # A group of lines in a hatch pattern as specified.


def CreateStaticText(
		dialogID      , # LONGINT - The index of the dialog layout containing the control.                                
		itemID        , # LONGINT - The index that will identify the control item.                                        
		text          , # STRING  - The display text for the control.                                                     
		widthInStdChar  # LONGINT - The width of the displayed text in standard character count. See GetDlgCtrlWidthStdCh.
		):
	'''
		Python: vs.CreateStaticText(dialogID, itemID, text, widthInStdChar)
		VectorScript: PROCEDURE CreateStaticText(dialogID:LONGINT; itemID:LONGINT; text:STRING; widthInStdChar:LONGINT);
		
		Category: Dialogs - Modern
		Creates a new static text field control in a dialog layout.
		To allow the control to size automatically to the text width, pass -1 as the width parameter of the control.
	'''
	pass


def CreateStory(
		name  , # STRING - The name of the Story to create.                                                   
		suffix  # STRING - The suffix to be used at the end of the name of a Layer assoiciated with the Story.
		):
	'''
		Python: BOOLEAN = vs.CreateStory(name, suffix)
		VectorScript: FUNCTION CreateStory(name:STRING; suffix:STRING) : BOOLEAN;
		
		Category: Layers
		Creates a Story. Stories are used to group layers and are shown on the Story pane of the Organization dialog.
	'''
	pass
	return 'BOOLEAN' # Whether the Story was successfully created. 


def CreateStoryLayerTemplate(
		name             , # STRING - The name of the Story Layer Template.                                                               
		scaleFactor      , # REAL   - The scale to be assinged to any Layers created from this template.                                  
		layerLevelType   , # STRING - The Layer Level Type to be assigned to any Layers created from this template.                       
		elevationOffset  , # REAL   - The offset of the elevation of any Layer created from this template from the elevation of its Story.
		defaultWallHeight  # REAL   - The wall height to be assigned to any Layer created from this template.                             
		):
	'''
		Python: (BOOLEAN, index) = vs.CreateStoryLayerTemplate(name, scaleFactor, layerLevelType, elevationOffset, defaultWallHeight)
		VectorScript: FUNCTION CreateStoryLayerTemplate(name:STRING; scaleFactor:REAL; layerLevelType:STRING; elevationOffset:REAL; defaultWallHeight:REAL; VAR index:INTEGER) : BOOLEAN;
		
		Category: Layers
		Creates a Story Layer Template in the current file. Sets the index parameter to the index of the new template in the list of templates. Story Layer Templates are used to define what Layers are typically found in a Story. When a Story is created, the user has the option to automatically create the Layers defined by the Story Layer Templates.
	'''
	pass
	return ( False  , # Whether a Story Layer Template is successfully created.
	         0       )


def CreateStyledStatic(
		dialogID      , # LONGINT -                                                                                                                                                                                                                                                              
		componentID   , # LONGINT -                                                                                                                                                                                                                                                              
		text          , # STRING  -                                                                                                                                                                                                                                                              
		widthInStdChar, # INTEGER - The width of the displayed text in standard character count. See GetDlgCtrlWidthStdCh.                                                                                                                                                                       
		style           # INTEGER - Type of this static text control. One of:        0 = eStaticTextTypeRegular    1 = eStaticTextTypeCaption    2 = eStaticTextTypeBold,	    3 = eStaticTextTypeReduced,    101-116 = Custom size, normal    201-216 = Custom size, bold                        
		):
	'''
		Python: BOOLEAN = vs.CreateStyledStatic(dialogID, componentID, text, widthInStdChar, style)
		VectorScript: PROCEDURE CreateStyledStatic(dialogID:LONGINT; componentID:LONGINT; text:STRING; widthInStdChar:INTEGER; style:INTEGER);
		
		Category: Dialogs - Modern
		Creates a new static text field control in a dialog layout. Text will have the indicated style.
		To allow the control to size automatically to the text width, pass -1 as the width parameter of the control.
		0 = eStaticTextTypeRegular
		1 = eStaticTextTypeCaption
		2 = eStaticTextTypeBold,
		3 = eStaticTextTypeReduced
	'''
	pass


def CreateSurfacefromCurvesNetwork():
	'''
		Python: BOOLEAN = vs.CreateSurfacefromCurvesNetwork()
		VectorScript: FUNCTION CreateSurfacefromCurvesNetwork : BOOLEAN;
		
		Category: Objects - NURBS
		This function will create a NURBS surface from a network of selected intersecting curves in the document
	'''
	pass
	return 'BOOLEAN' # 


def CreateSwapControl(
		dialogID     , # LONGINT - ID of the dialog.      
		swapControlID  # LONGINT - ID of the swap control.
		):
	'''
		Python: vs.CreateSwapControl(dialogID, swapControlID)
		VectorScript: PROCEDURE CreateSwapControl(dialogID:LONGINT; swapControlID:LONGINT);
		
		Category: Dialogs - Modern
		Create a swap control within a dialog.
		This control manages multiple overlapping groups of controls, of which a single group of controls is displayed at a time.  The script is able to control which group is displayed based on other data in the dialog.  For example, a dialog may present a scrolling list of items on the left, and a swap control on the right.  As the user selects items in the list, different sets of controls are enabled on the right.  This can be used for a settings (preferences) style dialog or when there are too many choices to use a Tab control effectively.
	'''
	pass


def CreateSwapPane(
		dialogID     , # LONGINT - the ID of the dialog                                                
		swapControlID, # LONGINT - the ID of the swap control                                          
		newGroupID     # LONGINT - the ID of the group to be inserted into swap control as a swap pane.
		):
	'''
		Python: vs.CreateSwapPane(dialogID, swapControlID, newGroupID)
		VectorScript: PROCEDURE CreateSwapPane(dialogID:LONGINT; swapControlID:LONGINT; newGroupID:LONGINT);
		
		Category: Dialogs - Modern
		Creates a swap pane within the specified swap control.   Within a swap control, only one swap pane is visible at a time.
	'''
	pass


def CreateSymbolDisplayControl(
		dialogID  , # LONGINT - The ID of the dialog in which to create the control.                  
		itemID    , # LONGINT - The item ID of the control.                                           
		symbolName, # STRING  - The name of the symbol to display.                                    
		height    , # INTEGER - The height of the control in pixels.                                  
		width     , # INTEGER - The width of the control in pixels.                                   
		margin    , # INTEGER - The margin bewteen the border of the control and the symbol in pixels.
		renderMode, # INTEGER - The render mode in which to display the symbol.                       
		view        # INTEGER - The view in which to display the symbol.                              
		):
	'''
		Python: vs.CreateSymbolDisplayControl(dialogID, itemID, symbolName, height, width, margin, renderMode, view)
		VectorScript: PROCEDURE CreateSymbolDisplayControl(dialogID:LONGINT; itemID:LONGINT; symbolName:STRING; height:INTEGER; width:INTEGER; margin:INTEGER; renderMode:INTEGER; view:INTEGER);
		
		Category: Dialogs - Modern
		Creates a new symbol display control in the dialog layout.  The control displays the specified symbol in the specified rendering mode and view.  The actual size of the symbol is not relevent; it is shown as large as possible in the given height and width (the height to width ratio of the symbol is always preserved).  To show a blank SymbolDisplay control, use an empty string as the symbolName parameter.
	'''
	pass


def CreateSymDispCtrlN(
		dialogID   , # LONGINT - The ID of the dialog in which to create the control.                  
		itemID     , # LONGINT - The item ID of the control.                                           
		symbolName , # STRING  - The name of the symbol to display.                                    
		width      , # INTEGER - The width of the control in pixels.                                   
		height     , # INTEGER - The height of the control in pixels.                                  
		margin     , # INTEGER - The margin bewteen the border of the control and the symbol in pixels.
		view       , # INTEGER - The view in which to display the symbol.                              
		renderMode , # INTEGER - The render mode in which to display the symbol.                       
		component  , # INTEGER - The image component.                                                  
		scaleByZoom  # BOOLEAN - Whether the sizing is done by zoom or layer scale.                    
		):
	'''
		Python: vs.CreateSymDispCtrlN(dialogID, itemID, symbolName, width, height, margin, view, renderMode, component, scaleByZoom)
		VectorScript: PROCEDURE CreateSymDispCtrlN(dialogID:LONGINT; itemID:LONGINT; symbolName:STRING; width:INTEGER; height:INTEGER; margin:INTEGER; view:INTEGER; renderMode:INTEGER; component:INTEGER; scaleByZoom:BOOLEAN);
		
		Category: Dialogs - Modern
		Creates a new symbol display control in the dialog layout.  The control displays the specified symbol in the specified rendering mode and view. Specified image component is used.  The actual size of the symbol is not relevant; it is shown as large as possible in the given height and width (the height to width ratio of the symbol is always preserved).  To show a blank SymbolDisplay control, use an empty string as the symbolName parameter.
		Table - Components:
		Component			Constant
		"3D" 				0
		"2D"				1
		"2D Cut"			                2
		"Not set"			                4
	'''
	pass


def CreateTabControl(
		dialogID, # LONGINT - The id of the dialog that contains this Tab control.
		itemID    # LONGINT - The id of the Tab control.                          
		):
	'''
		Python: vs.CreateTabControl(dialogID, itemID)
		VectorScript: PROCEDURE CreateTabControl(dialogID:LONGINT; itemID:LONGINT);
		
		Category: Dialogs - Modern
		Creates a tab control within a dialog.  The tab control manages the display of multiple panes of information and provides tab buttons that allow the user to swtich between panes.
		To create a tab control in a dialog, first define a group for each tab pane.  Add other controls to the groups and arrange them.  Then call CreateTabControl with an id.  Finally, call CreateTabPane for each pane providing the id of the group that defines that pane.
	'''
	pass


def CreateTabPane(
		dialogID, # LONGINT - The id of the dialog.                                          
		itemID  , # LONGINT - The id of the Tab Control to which this tab pane will be added.
		groupID   # LONGINT - The id of the group that defines the tab pane.                 
		):
	'''
		Python: vs.CreateTabPane(dialogID, itemID, groupID)
		VectorScript: PROCEDURE CreateTabPane(dialogID:LONGINT; itemID:LONGINT; groupID:LONGINT);
		
		Category: Dialogs - Modern
		Creates a tab pane within a tab control on a dialog.
		To define a tab pane, create a group control and add items to the group.  Arrange the items within the group.  Then call CreateTabPane to  add a new tab pane to a tab control.  Specify the group that defines the layout of that tab pane.
	'''
	pass


def CreateTaperedExtrd2(
		profileH, # HANDLE - Handle to object defining profile geometry.
		angle   , # REAL   - Taper angle of extrude (in degrees).       
		height    # REAL   - Height of extrude.                         
		):
	'''
		Python: HANDLE = vs.CreateTaperedExtrd2(profileH, angle, height)
		VectorScript: FUNCTION CreateTaperedExtrd2(profileH:HANDLE; angle:REAL; height:REAL) : HANDLE;
		
		Category: Objects - 3D
		Creates a new tapered extrude object in the document. This function returns a "general solid" object while the other function, CreateTaperedExtrude, produces a bunch of NURBS surfaces.
	'''
	pass
	return 'HANDLE' # Returns a HANDLE to the new tapered extrude if successful, otherwise returns NIL.


def CreateTaperedExtrude(
		profileH, # HANDLE - Handle to object defining profile geometry.
		angle   , # REAL   - Taper angle of extrude (in degrees).       
		height    # REAL   - Height of extrude.                         
		):
	'''
		Python: HANDLE = vs.CreateTaperedExtrude(profileH, angle, height)
		VectorScript: FUNCTION CreateTaperedExtrude(profileH:HANDLE; angle:REAL; height:REAL) : HANDLE;
		
		Category: Objects - 3D
		Creates a new tapered extrude object in the document.
	'''
	pass
	return 'HANDLE' # Returns a HANDLE to the new tapered extrude if successful, otherwise returns NIL.


def CreateText(
		theText  # DYNARRAY[] of CHAR - Text string.
		):
	'''
		Python: vs.CreateText(theText)
		VectorScript: PROCEDURE CreateText(theText:DYNARRAY of CHAR);
		
		Category: Objects - Text
		Procedure CreateText creates a new text object in a Vectorworks document. The text object is created using the current pen position and default attributes.
	'''
	pass


def CreateTextStyleRes(
		name  # STRING - The name for the new text style.
		):
	'''
		Python: HANDLE = vs.CreateTextStyleRes(name)
		VectorScript: FUNCTION CreateTextStyleRes(name:STRING) : HANDLE;
		
		Category: Objects - Text
		Creates a new text style resource with the specified name.  A handle to the new resource is returned.  Once the resource is created the attributes of the text style resource should be set appropriately.
	'''
	pass
	return 'HANDLE' # A handle to the newly created text style resource will be returned.


def CreateTexture():
	'''
		Python: HANDLE = vs.CreateTexture()
		VectorScript: FUNCTION CreateTexture : HANDLE;
		
		Category: Textures
		Function CreateTexture creates a new texture object with default values.
	'''
	pass
	return 'HANDLE' # 


def CreateTextureBitmap():
	'''
		Python: HANDLE = vs.CreateTextureBitmap()
		VectorScript: FUNCTION CreateTextureBitmap : HANDLE;
		
		Category: Textures
		Function CreateTextureBitmap creates a new default texture bitmap in a Vectorworks document.
	'''
	pass
	return 'HANDLE' # 


def CreateTextureBitmapD(
		parentShaderRecord  # HANDLE - This is the shader record input that the texture bitmap will be attached to.
		):
	'''
		Python: HANDLE = vs.CreateTextureBitmapD(parentShaderRecord)
		VectorScript: FUNCTION CreateTextureBitmapD(parentShaderRecord:HANDLE) : HANDLE;
		
		Category: Textures
		This function takes a shader record and creates a Texture bitmap.
	'''
	pass
	return 'HANDLE' # A texture bitmap (TextureBitmapHandle) is created from the input shader record and is returned.


def CreateTextureBitmapN(
		shaderRecord  # HANDLE - Handle to shader record.
		):
	'''
		Python: HANDLE = vs.CreateTextureBitmapN(shaderRecord)
		VectorScript: FUNCTION CreateTextureBitmapN(shaderRecord:HANDLE) : HANDLE;
		
		Category: Textures
		Creates a texture bitmap object for the chosen shader record.  Brings up dialog to choose the image file.  Returns nil if user clicked Cancel or if the shader is not an image-based shader.
	'''
	pass
	return 'HANDLE' # 


def CreateThreeStateCheckBox(
		dialogID   , # LONGINT -  
		componentID, # LONGINT -  
		strName      # STRING  -  
		):
	'''
		Python: vs.CreateThreeStateCheckBox(dialogID, componentID, strName)
		VectorScript: PROCEDURE CreateThreeStateCheckBox(dialogID:LONGINT; componentID:LONGINT; strName:STRING);
		
		Category: Dialogs - Modern
		Creates a Layout Manager three state checkbox.
	'''
	pass


def CreateThumbnailPopup(
		dialogID , # LONGINT -  
		controlID  # LONGINT -  
		):
	'''
		Python: vs.CreateThumbnailPopup(dialogID, controlID)
		VectorScript: PROCEDURE CreateThumbnailPopup(dialogID:LONGINT; controlID:LONGINT);
		
		Category: Dialogs - Modern
		Creates a thumbnail popup that can be populated with previews of objects in Vectorworks
	'''
	pass


def CreateTile(
		tileName  # DYNARRAY[] of CHAR - A user-specified name by which the newly created tile will be identified.
		):
	'''
		Python: HANDLE = vs.CreateTile(tileName)
		VectorScript: FUNCTION CreateTile(tileName:DYNARRAY of CHAR) : HANDLE;
		
		Category: Document Attributes
		Creates a new tile resource.
	'''
	pass
	return 'HANDLE' # Returns a handle to a new tile resource if successful, otherwise the function returns nil.


def CreateTrapeziumDormer(
		roofObject  # HANDLE - Handle to roof.
		):
	'''
		Python: INTEGER = vs.CreateTrapeziumDormer(roofObject)
		VectorScript: FUNCTION CreateTrapeziumDormer(roofObject:HANDLE) : INTEGER;
		
		Category: Objects - Roofs
		Function CreateTrapeziumDormer creates a trapezium dormer in the referenced roof object.
	'''
	pass
	return 'INTEGER' # 


def CreateTreeControl(
		nDialogID     , # LONGINT -                                                                                       
		nComponentID  , # LONGINT -                                                                                       
		widthInStdChar, # INTEGER - The width of the displayed text in standard character count. See GetDlgCtrlWidthStdCh.
		heightInLines   # INTEGER -                                                                                       
		):
	'''
		Python: vs.CreateTreeControl(nDialogID, nComponentID, widthInStdChar, heightInLines)
		VectorScript: PROCEDURE CreateTreeControl(nDialogID:LONGINT; nComponentID:LONGINT; widthInStdChar:INTEGER; heightInLines:INTEGER);
		
		Category: Dialogs - Modern
		Creates a Layout Manager tree control.
	'''
	pass


def CreateUUID():
	'''
		Python: STRING = vs.CreateUUID()
		VectorScript: FUNCTION CreateUUID : STRING;
		
		Category: Utility
		Creates a string representing universe unique identifier. The string is in the form: '{00000000-0000-0000-0000-000000000000}'
	'''
	pass
	return 'STRING' # 


def CreateVP(
		parentHandle  # HANDLE -  
		):
	'''
		Python: HANDLE = vs.CreateVP(parentHandle)
		VectorScript: FUNCTION CreateVP(parentHandle:HANDLE) : HANDLE;
		
		Category: Objects - Groups
		Creates a viewport object. The specified parent handle may only be a layer or a group contained within a layer, nested or otherwise.
	'''
	pass
	return 'HANDLE' # 


def CreateVPClOvrd(
		viewportHandle, # HANDLE - The viewport handle.  
		clasName        # STRING - The name of the class.
		):
	'''
		Python: vs.CreateVPClOvrd(viewportHandle, className)
		VectorScript: PROCEDURE CreateVPClOvrd(viewportHandle:HANDLE; className:STRING);
		
		Category: Viewports
		Creates a new override for the specified class in the specified viewport. The override is initially populated with the class's current properties.
	'''
	pass


def CreateVPLrOvrd(
		viewportHandle, # HANDLE - The viewport handle.  
		layerHandle     # HANDLE - The layer to override.
		):
	'''
		Python: vs.CreateVPLrOvrd(viewportHandle, layerHandle)
		VectorScript: PROCEDURE CreateVPLrOvrd(viewportHandle:HANDLE; layerHandle:HANDLE);
		
		Category: Viewports
		Creates a new layer override, initially set to the layer's current properties.
	'''
	pass


def CreateWallFeature(
		wall           , # HANDLE  - The handle to the wall in which to create the Wall Feature. 
		profile        , # HANDLE  - The handle to the object to use as the Wall Feature profile.
		wallFeatureType  # INTEGER - The Wall Feature type.                                      
		):
	'''
		Python: HANDLE = vs.CreateWallFeature(wall, profile, wallFeatureType)
		VectorScript: FUNCTION CreateWallFeature(wall:HANDLE; profile:HANDLE; wallFeatureType:INTEGER) : HANDLE;
		
		Category: Objects - Walls
		Creates a Wall Feature in the wall from the profile object.  The Wall Feature can be a projection from the wall or a recess in the wall.
	'''
	pass
	return 'HANDLE' # The handle to the created Wall Feature.


def CreateWallStyle(
		wallStyleName  # STRING - The name of the new Wall Style. If the name is already in use, the next available name will be used.
		):
	'''
		Python: HANDLE = vs.CreateWallStyle(wallStyleName)
		VectorScript: FUNCTION CreateWallStyle(wallStyleName:STRING) : HANDLE;
		
		Category: Objects - Walls
		Creates a new Wall Style of the give name.  If the name is already in use, the next available name will be used.
	'''
	pass
	return 'HANDLE' # Returns a handle to the new Wall Style.


def CreateWS(
		name   , # STRING  - The name of the worksheet.             
		rows   , # INTEGER - The number of rows in the worksheet.   
		columns  # INTEGER - The number of columns in the worksheet.
		):
	'''
		Python: HANDLE = vs.CreateWS(name, rows, columns)
		VectorScript: FUNCTION CreateWS(name:STRING; rows:INTEGER; columns:INTEGER) : HANDLE;
		
		Category: Worksheets
		Creates a new worksheet in a Vectorworks document.
	'''
	pass
	return 'HANDLE' # Returns a HANDLE to the new worksheet.


def CreateWSImage(
		worksheet, # HANDLE - Handle to worksheet.                    
		location   # POINT  - X-Y coordinate location of image object.
		):
	'''
		Python: HANDLE = vs.CreateWSImage(worksheet, location)
		VectorScript: FUNCTION CreateWSImage(worksheet:HANDLE; locationX, locationY:REAL) : HANDLE;
		
		Category: Worksheets
		Creates an in-document image of the specified worksheet. The specified point location is the top left corner of the image object.
	'''
	pass
	return 'HANDLE' # 


def CriteriaArea(
		c  # CRITERIA - Search criteria.
		):
	'''
		Python: REAL = vs.CriteriaArea(c)
		VectorScript: FUNCTION CriteriaArea(c:CRITERIA) : REAL;
		
		Category: Criteria
		Returns the area of an object. If more than one object matches the search criteria, the function will return the sum of all the matching object areas.
	'''
	pass
	return 'REAL' # 


def CriteriaSurfaceArea(
		c  # CRITERIA - Search criteria.
		):
	'''
		Python: REAL = vs.CriteriaSurfaceArea(c)
		VectorScript: FUNCTION CriteriaSurfaceArea(c:CRITERIA) : REAL;
		
		Category: Criteria
		Returns the surface area of the items matching the specified criteria. If more than one object matches the search criteria, the sum of all the surface areas of the matching objects will be returned.
		CriteriaSurfaceArea will return only return areas on objects which support the solids modelling functions.
	'''
	pass
	return 'REAL' # 


def CriteriaVolume(
		c  # CRITERIA - Search criteria.
		):
	'''
		Python: REAL = vs.CriteriaVolume(c)
		VectorScript: FUNCTION CriteriaVolume(c:CRITERIA) : REAL;
		
		Category: Criteria
		Returns the volume of the items matching the specified criteria. If more than one object matches the search criteria, the sum of all the volumes of the matching objects will be returned.
		CriteriaVolume will return only return volumes on objects which support the solids modelling functions.
	'''
	pass
	return 'REAL' # 


def CrossProduct(
		v1, # VECTOR - Source vector 1.
		v2  # VECTOR - Source vector 2.
		):
	'''
		Python: VECTOR = vs.CrossProduct(v1, v2)
		VectorScript: FUNCTION CrossProduct(v1:VECTOR; v2:VECTOR) : VECTOR;
		
		Category: Math - Vectors
		Returns the cross product of the two specified vectors.
		The cross product is also known as the vector product of the two vectors. The result is a vector whose magnitude is equivalent to the product of the magnitudes of the two vectors multiplied by the sine of the smaller angle between the two vectors. The direction of the resultant vector is perpendicular to a plane formed by the two source vectors.
	'''
	pass
	return 'VECTOR' # Returns a VECTOR which is the cross product of [[p:1]] and [[p:2]].


def CurveThrough(
		p  # POINT - Coordinates of vertex.
		):
	'''
		Python: vs.CurveThrough(p)
		VectorScript: PROCEDURE CurveThrough(pX, pY:REAL);
		
		Category: Objects - Polys
		Procedure CurveThrough fits a cubic spline through the specified point.
	'''
	pass


def CurveTo(
		p  # POINT - Coordinate of vertex.
		):
	'''
		Python: vs.CurveTo(p)
		VectorScript: PROCEDURE CurveTo(pX, pY:REAL);
		
		Category: Objects - Polys
		Procedure CurveTo creates a bezier vertex point at the specified point. Parameter p specifies the coordinate location of the vertex.
	'''
	pass


def CustomTexPartExists(
		obj   , # HANDLE  - Object handle                   
		partID  # LONGINT - Custom texture part ID, ex: 100.
		):
	'''
		Python: BOOLEAN = vs.CustomTexPartExists(obj, partID)
		VectorScript: FUNCTION CustomTexPartExists(obj:HANDLE; partID:LONGINT) : BOOLEAN;
		
		Category: Textures
		Returns true if object has the specified partID custom texture part.
	'''
	pass
	return 'BOOLEAN' # 


def CutProfileHoles(
		hWall  # HANDLE -  
		):
	'''
		Python: vs.CutProfileHoles(hWall)
		VectorScript: PROCEDURE CutProfileHoles(hWall:HANDLE);
		
		Category: Graphic Calculation
		Cut holes in object geometry described in it's profile group.
	'''
	pass


def Date(
		dateFormat, # INTEGER - Specify how verbose or compact the resulting string is.
		infoFormat  # INTEGER - Specify if result should contain date, time or both.   
		):
	'''
		Python: STRING = vs.Date(dateFormat, infoFormat)
		VectorScript: FUNCTION Date(dateFormat:INTEGER; infoFormat:INTEGER) : STRING;
		
		Category: Utility
		Function Date returns a formatted date and time string.
	'''
	pass
	return 'STRING' # 


def DBDiagnose():
	'''
		Python: BOOLEAN = vs.DBDiagnose()
		VectorScript: FUNCTION DBDiagnose : BOOLEAN;
		
		Category: ODBC
		Test ODBC connectivity and creates log file in application folder. Returns true if succeeded.
	'''
	pass
	return 'BOOLEAN' # 


def DBDocAddConn(
		dsn     , # DYNARRAY[] of CHAR -  
		userName, # DYNARRAY[] of CHAR -  
		password  # DYNARRAY[] of CHAR -  
		):
	'''
		Python: BOOLEAN = vs.DBDocAddConn(dsn, userName, password)
		VectorScript: FUNCTION DBDocAddConn(dsn:DYNARRAY of CHAR; userName:DYNARRAY of CHAR; password:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: ODBC
		Add a database connection to the current document
	'''
	pass
	return 'BOOLEAN' # 


def DBDocGetColumns(
		database, # STRING -  
		table     # STRING -  
		):
	'''
		Python: (BOOLEAN, outNames, outTypes, outCanBeKey, outIsKey) = vs.DBDocGetColumns(database, table)
		VectorScript: FUNCTION DBDocGetColumns(database:STRING; table:STRING; VAR outNames:DYNARRAY of CHAR; VAR outTypes:DYNARRAY of CHAR; VAR outCanBeKey:DYNARRAY of CHAR; VAR outIsKey:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: ODBC
		Returns a string representing a ';' delimited lists of the specified table data.
	'''
	pass
	return ( False   , # 
	         'string', 
	         'string', 
	         'string', 
	         'string' )


def DBDocGetConn(
		databaseName  # DYNARRAY[] of CHAR -  
		):
	'''
		Python: (BOOLEAN, outUserName, outPassword) = vs.DBDocGetConn(databaseName)
		VectorScript: FUNCTION DBDocGetConn(databaseName:DYNARRAY of CHAR; VAR outUserName:DYNARRAY of CHAR; VAR outPassword:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: ODBC
		Get database connection info.
	'''
	pass
	return ( False   , # 
	         'string', 
	         'string' )


def DBDocGetDB(
		):
	'''
		Python: (BOOLEAN, outDatabases) = vs.DBDocGetDB()
		VectorScript: FUNCTION DBDocGetDB(VAR outDatabases:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: ODBC
		Returns a string representing a ';' delimited list of the databases currectly connected to the document.
	'''
	pass
	return ( False   , # 
	         'string' )


def DBDocGetTables(
		database  # STRING -  
		):
	'''
		Python: (BOOLEAN, outTables) = vs.DBDocGetTables(database)
		VectorScript: FUNCTION DBDocGetTables(database:STRING; VAR outTables:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: ODBC
		Returns a string representing a ';' delimited list of the tables in the specified database.
	'''
	pass
	return ( False   , # 
	         'string' )


def DBDocHasConn():
	'''
		Python: BOOLEAN = vs.DBDocHasConn()
		VectorScript: FUNCTION DBDocHasConn : BOOLEAN;
		
		Category: ODBC
		Checks if the current document has connections to an ODBC data source.
	'''
	pass
	return 'BOOLEAN' # 


def DBDocRemoveConn(
		databaseName  # DYNARRAY[] of CHAR -  
		):
	'''
		Python: BOOLEAN = vs.DBDocRemoveConn(databaseName)
		VectorScript: FUNCTION DBDocRemoveConn(databaseName:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: ODBC
		Remove a database connection from the current document
	'''
	pass
	return 'BOOLEAN' # 


def DBDocSetColKey(
		databaseName, # DYNARRAY[] of CHAR -  
		tableName   , # DYNARRAY[] of CHAR -  
		columnName  , # DYNARRAY[] of CHAR -  
		setIsKey      # BOOLEAN            -  
		):
	'''
		Python: BOOLEAN = vs.DBDocSetColKey(databaseName, tableName, columnName, setIsKey)
		VectorScript: FUNCTION DBDocSetColKey(databaseName:DYNARRAY of CHAR; tableName:DYNARRAY of CHAR; columnName:DYNARRAY of CHAR; setIsKey:BOOLEAN) : BOOLEAN;
		
		Category: ODBC
		Get database table column to be as a key.
	'''
	pass
	return 'BOOLEAN' # 


def DBeam_Begin():
	'''
		Python: vs.DBeam_Begin()
		VectorScript: PROCEDURE DBeam_Begin;
		
		Category: Spotlight
		start drawing beam routine
	'''
	pass


def DBeam_BeginShttGet():
	'''
		Python: vs.DBeam_BeginShttGet()
		VectorScript: PROCEDURE DBeam_BeginShttGet;
		
		Category: Spotlight
		Start shutter get routine
	'''
	pass


def DBeam_End():
	'''
		Python: vs.DBeam_End()
		VectorScript: PROCEDURE DBeam_End;
		
		Category: Spotlight
		end drawing beam routine and create the beam
	'''
	pass


def DBeam_EndShttGet(
		bUseLampRotFlag  # BOOLEAN -  
		):
	'''
		Python: vs.DBeam_EndShttGet(bUseLampRotFlag)
		VectorScript: PROCEDURE DBeam_EndShttGet(bUseLampRotFlag:BOOLEAN);
		
		Category: Spotlight
		End creating 3D shutter object
	'''
	pass


def DBeam_Get2DLines():
	'''
		Python: HANDLE = vs.DBeam_Get2DLines()
		VectorScript: FUNCTION DBeam_Get2DLines : HANDLE;
		
		Category: Spotlight
		Return the most recently created beam object
	'''
	pass
	return 'HANDLE' # 


def DBeam_Get2DLn2FOff():
	'''
		Python: HANDLE = vs.DBeam_Get2DLn2FOff()
		VectorScript: FUNCTION DBeam_Get2DLn2FOff : HANDLE;
		
		Category: Spotlight
		Return the most recently created beam object
	'''
	pass
	return 'HANDLE' # 


def DBeam_Get2DObjAtFs():
	'''
		Python: HANDLE = vs.DBeam_Get2DObjAtFs()
		VectorScript: FUNCTION DBeam_Get2DObjAtFs : HANDLE;
		
		Category: Spotlight
		Return the most recently created beam object
	'''
	pass
	return 'HANDLE' # 


def DBeam_Get2DObjFOff():
	'''
		Python: HANDLE = vs.DBeam_Get2DObjFOff()
		VectorScript: FUNCTION DBeam_Get2DObjFOff : HANDLE;
		
		Category: Spotlight
		Return the most recently created beam object
	'''
	pass
	return 'HANDLE' # 


def DBeam_Get3DShutter():
	'''
		Python: HANDLE = vs.DBeam_Get3DShutter()
		VectorScript: FUNCTION DBeam_Get3DShutter : HANDLE;
		
		Category: Spotlight
		Return the created 3D shutter object
	'''
	pass
	return 'HANDLE' # 


def DBeam_GetLast2DObj():
	'''
		Python: HANDLE = vs.DBeam_GetLast2DObj()
		VectorScript: FUNCTION DBeam_GetLast2DObj : HANDLE;
		
		Category: Spotlight
		Return the most recently created 2D beam object
	'''
	pass
	return 'HANDLE' # 


def DBeam_GetLastObject():
	'''
		Python: HANDLE = vs.DBeam_GetLastObject()
		VectorScript: FUNCTION DBeam_GetLastObject : HANDLE;
		
		Category: Spotlight
		Return the most recently created beam object
	'''
	pass
	return 'HANDLE' # 


def DBeam_GetLines():
	'''
		Python: HANDLE = vs.DBeam_GetLines()
		VectorScript: FUNCTION DBeam_GetLines : HANDLE;
		
		Category: Spotlight
		Return the most recently created beam object
	'''
	pass
	return 'HANDLE' # 


def DBeam_GetLines2FOff():
	'''
		Python: HANDLE = vs.DBeam_GetLines2FOff()
		VectorScript: FUNCTION DBeam_GetLines2FOff : HANDLE;
		
		Category: Spotlight
		Return the most recently created beam object
	'''
	pass
	return 'HANDLE' # 


def DBeam_GetObjAtFocus():
	'''
		Python: HANDLE = vs.DBeam_GetObjAtFocus()
		VectorScript: FUNCTION DBeam_GetObjAtFocus : HANDLE;
		
		Category: Spotlight
		Return the most recently created beam object
	'''
	pass
	return 'HANDLE' # 


def DBeam_GetObjFallOff():
	'''
		Python: HANDLE = vs.DBeam_GetObjFallOff()
		VectorScript: FUNCTION DBeam_GetObjFallOff : HANDLE;
		
		Category: Spotlight
		Return the most recently created beam object
	'''
	pass
	return 'HANDLE' # 


def DBeam_SetBeamAngle(
		angle  # REAL -  
		):
	'''
		Python: vs.DBeam_SetBeamAngle(angle)
		VectorScript: PROCEDURE DBeam_SetBeamAngle(angle:REAL);
		
		Category: Spotlight
	'''
	pass


def DBeam_SetBeamAngle2(
		angle  # REAL -  
		):
	'''
		Python: vs.DBeam_SetBeamAngle2(angle)
		VectorScript: PROCEDURE DBeam_SetBeamAngle2(angle:REAL);
		
		Category: Spotlight
	'''
	pass


def DBeam_SetBShutAngle(
		angle  # REAL -  
		):
	'''
		Python: vs.DBeam_SetBShutAngle(angle)
		VectorScript: PROCEDURE DBeam_SetBShutAngle(angle:REAL);
		
		Category: Spotlight
	'''
	pass


def DBeam_SetBShutDepth(
		depth  # INTEGER -  
		):
	'''
		Python: vs.DBeam_SetBShutDepth(depth)
		VectorScript: PROCEDURE DBeam_SetBShutDepth(depth:INTEGER);
		
		Category: Spotlight
	'''
	pass


def DBeam_SetFallOffDist(
		dist  # REAL -  
		):
	'''
		Python: vs.DBeam_SetFallOffDist(dist)
		VectorScript: PROCEDURE DBeam_SetFallOffDist(dist:REAL);
		
		Category: Spotlight
	'''
	pass


def DBeam_SetFocusPoint(
		pt  # POINT3D -  
		):
	'''
		Python: vs.DBeam_SetFocusPoint(pt)
		VectorScript: PROCEDURE DBeam_SetFocusPoint(ptX, ptY, ptZ:REAL);
		
		Category: Spotlight
		Set focus point for the beam
	'''
	pass


def DBeam_SetLampRot(
		rot  # REAL -  
		):
	'''
		Python: vs.DBeam_SetLampRot(rot)
		VectorScript: PROCEDURE DBeam_SetLampRot(rot:REAL);
		
		Category: Spotlight
	'''
	pass


def DBeam_SetLightOrigin(
		origin  # POINT3D -  
		):
	'''
		Python: vs.DBeam_SetLightOrigin(origin)
		VectorScript: PROCEDURE DBeam_SetLightOrigin(originX, originY, originZ:REAL);
		
		Category: Spotlight
		Set light origin for the beam.
	'''
	pass


def DBeam_SetLShutAngle(
		angle  # REAL -  
		):
	'''
		Python: vs.DBeam_SetLShutAngle(angle)
		VectorScript: PROCEDURE DBeam_SetLShutAngle(angle:REAL);
		
		Category: Spotlight
	'''
	pass


def DBeam_SetLShutDepth(
		depth  # INTEGER -  
		):
	'''
		Python: vs.DBeam_SetLShutDepth(depth)
		VectorScript: PROCEDURE DBeam_SetLShutDepth(depth:INTEGER);
		
		Category: Spotlight
	'''
	pass


def DBeam_SetRShutAngle(
		angle  # REAL -  
		):
	'''
		Python: vs.DBeam_SetRShutAngle(angle)
		VectorScript: PROCEDURE DBeam_SetRShutAngle(angle:REAL);
		
		Category: Spotlight
	'''
	pass


def DBeam_SetRShutDepth(
		depth  # INTEGER -  
		):
	'''
		Python: vs.DBeam_SetRShutDepth(depth)
		VectorScript: PROCEDURE DBeam_SetRShutDepth(depth:INTEGER);
		
		Category: Spotlight
	'''
	pass


def DBeam_SetShow3DType(
		typeFlag  # INTEGER -  
		):
	'''
		Python: vs.DBeam_SetShow3DType(typeFlag)
		VectorScript: PROCEDURE DBeam_SetShow3DType(typeFlag:INTEGER);
		
		Category: Spotlight
	'''
	pass


def DBeam_SetShowAtPoint(
		showFlag  # INTEGER -  
		):
	'''
		Python: vs.DBeam_SetShowAtPoint(showFlag)
		VectorScript: PROCEDURE DBeam_SetShowAtPoint(showFlag:INTEGER);
		
		Category: Spotlight
	'''
	pass


def DBeam_SetTShutAngle(
		angle  # REAL -  
		):
	'''
		Python: vs.DBeam_SetTShutAngle(angle)
		VectorScript: PROCEDURE DBeam_SetTShutAngle(angle:REAL);
		
		Category: Spotlight
	'''
	pass


def DBeam_SetTShutDepth(
		depth  # INTEGER -  
		):
	'''
		Python: vs.DBeam_SetTShutDepth(depth)
		VectorScript: PROCEDURE DBeam_SetTShutDepth(depth:INTEGER);
		
		Category: Spotlight
	'''
	pass


def DBeam_ShowBeamLines(
		showFlag  # BOOLEAN -  
		):
	'''
		Python: vs.DBeam_ShowBeamLines(showFlag)
		VectorScript: PROCEDURE DBeam_ShowBeamLines(showFlag:BOOLEAN);
		
		Category: Spotlight
	'''
	pass


def DBGetFormatConn(
		formatName  # STRING -  
		):
	'''
		Python: (BOOLEAN, outDatabase, outTable) = vs.DBGetFormatConn(formatName)
		VectorScript: FUNCTION DBGetFormatConn(formatName:STRING; VAR outDatabase:STRING; VAR outTable:STRING) : BOOLEAN;
		
		Category: ODBC
		Returns the ODBC connection for the specified format.
	'''
	pass
	return ( False   , # 
	         'string', 
	         'string' )


def DBGetFormatFieldConn(
		formatName  # STRING -  
		):
	'''
		Python: (BOOLEAN, fieldName, columnName, linkType) = vs.DBGetFormatFieldConn(formatName)
		VectorScript: FUNCTION DBGetFormatFieldConn(formatName:STRING; VAR fieldName:STRING; VAR columnName:STRING; VAR linkType:INTEGER) : BOOLEAN;
		
		Category: ODBC
		Get ODBC connection for the specified format field.
	'''
	pass
	return ( False   , # 
	         'string', 
	         'string', 
	         0        )


def DBObjSQLGetRead(
		hObject  # HANDLE -  
		):
	'''
		Python: (BOOLEAN, SQLSentence) = vs.DBObjSQLGetRead(hObject)
		VectorScript: FUNCTION DBObjSQLGetRead(hObject:HANDLE; VAR SQLSentence:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: ODBC
		Get an object's SQL sentence for ODBC read.
	'''
	pass
	return ( False   , # 
	         'string' )


def DBObjSQLGetWrite(
		hObject  # HANDLE -  
		):
	'''
		Python: (BOOLEAN, SQLSentence) = vs.DBObjSQLGetWrite(hObject)
		VectorScript: FUNCTION DBObjSQLGetWrite(hObject:HANDLE; VAR SQLSentence:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: ODBC
		Get an object's SQL sentence for ODBC write.
	'''
	pass
	return ( False   , # 
	         'string' )


def DBObjSQLSetRead(
		hObject    , # HANDLE             -  
		SQLSentence  # DYNARRAY[] of CHAR -  
		):
	'''
		Python: BOOLEAN = vs.DBObjSQLSetRead(hObject, SQLSentence)
		VectorScript: FUNCTION DBObjSQLSetRead(hObject:HANDLE; SQLSentence:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: ODBC
		Set an object's SQL sentence for ODBC read.
	'''
	pass
	return 'BOOLEAN' # 


def DBObjSQLSetWrite(
		hObject    , # HANDLE             -  
		SQLSentence  # DYNARRAY[] of CHAR -  
		):
	'''
		Python: BOOLEAN = vs.DBObjSQLSetWrite(hObject, SQLSentence)
		VectorScript: FUNCTION DBObjSQLSetWrite(hObject:HANDLE; SQLSentence:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: ODBC
		Set an object's SQL sentence for ODBC write.
	'''
	pass
	return 'BOOLEAN' # 


def DBSetFormatConn(
		formatName, # STRING -  
		database  , # STRING -  
		tableName   # STRING -  
		):
	'''
		Python: BOOLEAN = vs.DBSetFormatConn(formatName, database, tableName)
		VectorScript: FUNCTION DBSetFormatConn(formatName:STRING; database:STRING; tableName:STRING) : BOOLEAN;
		
		Category: ODBC
		Set ODBC connection for the specified format.
	'''
	pass
	return 'BOOLEAN' # 


def DBSetFormatFieldConn(
		formatName, # STRING  -  
		fieldName , # STRING  -  
		columnName, # STRING  -  
		linkType    # INTEGER -  
		):
	'''
		Python: BOOLEAN = vs.DBSetFormatFieldConn(formatName, fieldName, columnName, linkType)
		VectorScript: FUNCTION DBSetFormatFieldConn(formatName:STRING; fieldName:STRING; columnName:STRING; linkType:INTEGER) : BOOLEAN;
		
		Category: ODBC
		Set ODBC connection for the specified format field.
	'''
	pass
	return 'BOOLEAN' # 


def DBShowDBTableDlg(
		database, # STRING -  
		table     # STRING -  
		):
	'''
		Python: BOOLEAN = vs.DBShowDBTableDlg(database, table)
		VectorScript: FUNCTION DBShowDBTableDlg(database:STRING; table:STRING) : BOOLEAN;
		
		Category: ODBC
		Show the specified database table dialog.
	'''
	pass
	return 'BOOLEAN' # 


def DBShowManageDBsDlg():
	'''
		Python: vs.DBShowManageDBsDlg()
		VectorScript: PROCEDURE DBShowManageDBsDlg;
		
		Category: ODBC
		Show the database manager dialog.
	'''
	pass


def DBShowObjConnDlg():
	'''
		Python: BOOLEAN = vs.DBShowObjConnDlg()
		VectorScript: FUNCTION DBShowObjConnDlg : BOOLEAN;
		
		Category: ODBC
		Show the object connection dialog for the selected objects.
	'''
	pass
	return 'BOOLEAN' # 


def DBSQLExecute(
		database, # STRING             -  
		SQLQuery  # DYNARRAY[] of CHAR -  
		):
	'''
		Python: (BOOLEAN, outColumnCnt, outResultSetInst) = vs.DBSQLExecute(database, SQLQuery)
		VectorScript: FUNCTION DBSQLExecute(database:STRING; SQLQuery:DYNARRAY of CHAR; VAR outColumnCnt:LONGINT; VAR outResultSetInst:LONGINT) : BOOLEAN;
		
		Category: ODBC
		Executes a SQL in the specified database connected to the current document. Note! The resultSetInstance have to be deleted with call to 'DBSQLExecuteDelete'
	'''
	pass
	return ( False  , # 
	         0      , 
	         0       )


def DBSQLExecuteDelete(
		resultSetInst  # in/out LONGINT -  
		):
	'''
		Python: resultSetInst = vs.DBSQLExecuteDelete(resultSetInst)
		VectorScript: PROCEDURE DBSQLExecuteDelete(VAR resultSetInst:LONGINT);
		
		Category: ODBC
		Deletes a resultSetInstance created with 'DBSQLExecute' or 'DBSQLExecuteDSN'
	'''
	pass
	return ( 0 )


def DBSQLExecuteDSN(
		dsn     , # DYNARRAY[] of CHAR -  
		userName, # DYNARRAY[] of CHAR -  
		password, # DYNARRAY[] of CHAR -  
		SQLQuery  # DYNARRAY[] of CHAR -  
		):
	'''
		Python: (BOOLEAN, outColumnCnt, outResultSetInst) = vs.DBSQLExecuteDSN(dsn, userName, password, SQLQuery)
		VectorScript: FUNCTION DBSQLExecuteDSN(dsn:DYNARRAY of CHAR; userName:DYNARRAY of CHAR; password:DYNARRAY of CHAR; SQLQuery:DYNARRAY of CHAR; VAR outColumnCnt:LONGINT; VAR outResultSetInst:LONGINT) : BOOLEAN;
		
		Category: ODBC
		Executes a SQL in the specified DSN registered in the ODBC manager. Note! The resultSetInstance have to be deleted with call to 'DBSQLExecuteDelete'
	'''
	pass
	return ( False  , # 
	         0      , 
	         0       )


def DBSQLExecuteError(
		):
	'''
		Python: (BOOLEAN, message, state, code, internalDesc) = vs.DBSQLExecuteError()
		VectorScript: FUNCTION DBSQLExecuteError(VAR message:DYNARRAY of CHAR; VAR state:DYNARRAY of CHAR; VAR code:LONGINT; VAR internalDesc:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: ODBC
		Return information about the last error occured in the ODBC API functions.
	'''
	pass
	return ( False   , # 
	         'string', 
	         'string', 
	         0       , 
	         'string' )


def DBSQLExecuteGet(
		resultSetInst, # LONGINT -  
		colIndex       # LONGINT -  
		):
	'''
		Python: (BOOLEAN, outColumnName, outValue) = vs.DBSQLExecuteGet(resultSetInst, colIndex)
		VectorScript: FUNCTION DBSQLExecuteGet(resultSetInst:LONGINT; colIndex:LONGINT; VAR outColumnName:DYNARRAY of CHAR; VAR outValue:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: ODBC
		Retrieves information from the resultSetInstance created with 'DBSQLExecute' or 'DBSQLExecuteDSN'
	'''
	pass
	return ( False   , # 
	         'string', 
	         'string' )


def DBSQLExecuteNext(
		resultSetInst  # LONGINT -  
		):
	'''
		Python: BOOLEAN = vs.DBSQLExecuteNext(resultSetInst)
		VectorScript: FUNCTION DBSQLExecuteNext(resultSetInst:LONGINT) : BOOLEAN;
		
		Category: ODBC
		Moves the resultSet current pointer to the next entry.
	'''
	pass
	return 'BOOLEAN' # 


def DefDrpShadowEnabled():
	'''
		Python: BOOLEAN = vs.DefDrpShadowEnabled()
		VectorScript: FUNCTION DefDrpShadowEnabled : BOOLEAN;
		
		Category: Document Attributes
	'''
	pass
	return 'BOOLEAN' # 


def DefineCustomObj(
		pluginName, # STRING  -  
		prefWhen    # INTEGER -  
		):
	'''
		Python: HANDLE = vs.DefineCustomObj(pluginName, prefWhen)
		VectorScript: FUNCTION DefineCustomObj(pluginName:STRING; prefWhen:INTEGER) : HANDLE;
		
		Category: Objects - Custom
		Calls GS_DefineCustomObject for a passed plugin name and preference.
	'''
	pass
	return 'HANDLE' # 


def Deg2Rad(
		degreeValue  # REAL - Value in degrees.
		):
	'''
		Python: REAL = vs.Deg2Rad(degreeValue)
		VectorScript: FUNCTION Deg2Rad(degreeValue:REAL) : REAL;
		
		Category: Math - General
		Function Deg2Rad converts the specified value (in degrees) to radians.
	'''
	pass
	return 'REAL' # 


def DegFromStr(
		fSlopeDef  , # STRING -  
		fSlopeValue  # STRING -  
		):
	'''
		Python: (BOOLEAN, fAngle) = vs.DegFromStr(fSlopeDef, fSlopeValue)
		VectorScript: FUNCTION DegFromStr(fSlopeDef:STRING; fSlopeValue:STRING; VAR fAngle:REAL) : BOOLEAN;
		
		Category: SiteModel Interface Library
		Converts slope from string format to degrees.
	'''
	pass
	return ( False  , # 
	         0.0     )


def DelClass(
		clasName   # STRING - Name of class to delete.
		):
	'''
		Python: vs.DelClass(className)
		VectorScript: PROCEDURE DelClass(className:STRING);
		
		Category: Classes
		Deletes the specified class from the active document. If there are objects in the class to be deleted, they are reassigned to the None class.
	'''
	pass


def Delete(
		source, # in/out DYNARRAY[] of CHAR - Source string.                
		index , # INTEGER                   - Start position in text string.
		count   # INTEGER                   - Length of substring.          
		):
	'''
		Python: source = vs.Delete(source, index, count)
		VectorScript: PROCEDURE Delete(VAR source:DYNARRAY of CHAR; index:INTEGER; count:INTEGER);
		
		Category: Strings
		Procedure Delete removes a substring from the specified source string.
	'''
	pass
	return ( 'string' )


def DeleteAllComponents(
		object  # HANDLE - The object. Can be a wall, round wall, Wall Style, or the Wall Preferences.
		):
	'''
		Python: BOOLEAN = vs.DeleteAllComponents(object)
		VectorScript: FUNCTION DeleteAllComponents(object:HANDLE) : BOOLEAN;
		
		Category: Objects - Architectural
		Deletes all components in an object.
	'''
	pass
	return 'BOOLEAN' # 


def DeleteAllDLComponents():
	'''
		Python: BOOLEAN = vs.DeleteAllDLComponents()
		VectorScript: FUNCTION DeleteAllDLComponents : BOOLEAN;
		
		Category: Document Settings
		Deletes all components in the Double Line Preferences.
	'''
	pass
	return 'BOOLEAN' # 


def DeleteAllItems(
		dialogID, # LONGINT - ID of the dialog  
		itemID    # LONGINT - ID of the list box
		):
	'''
		Python: vs.DeleteAllItems(dialogID, itemID)
		VectorScript: PROCEDURE DeleteAllItems(dialogID:LONGINT; itemID:LONGINT);
		
		Category: Dialogs - Modern
		Deletes all rows from the specified list box.
	'''
	pass


def DeleteAllLBItems(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID  # LONGINT - id of the list browser control                 
		):
	'''
		Python: BOOLEAN = vs.DeleteAllLBItems(dialogID, componentID)
		VectorScript: FUNCTION DeleteAllLBItems(dialogID:LONGINT; componentID:LONGINT) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Deletes all list browser items.
	'''
	pass
	return 'BOOLEAN' # 


def DeleteAttribute(
		XMLHandle  , # LONGINT            -  
		elementPath, # DYNARRAY[] of CHAR -  
		attribute    # DYNARRAY[] of CHAR -  
		):
	'''
		Python: INTEGER = vs.DeleteAttribute(XMLHandle, elementPath, attribute)
		VectorScript: FUNCTION DeleteAttribute(XMLHandle:LONGINT; elementPath:DYNARRAY of CHAR; attribute:DYNARRAY of CHAR) : INTEGER;
		
		Category: XML
		Deletes an attribute
	'''
	pass
	return 'INTEGER' # 


def DeleteCDATA(
		XMLHandle  , # LONGINT            -  
		elementPath  # DYNARRAY[] of CHAR -  
		):
	'''
		Python: INTEGER = vs.DeleteCDATA(XMLHandle, elementPath)
		VectorScript: FUNCTION DeleteCDATA(XMLHandle:LONGINT; elementPath:DYNARRAY of CHAR) : INTEGER;
		
		Category: XML
		Deletes a CDATA section
	'''
	pass
	return 'INTEGER' # 


def DeleteComponent(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component to delete.                                                                                                                                 
		):
	'''
		Python: BOOLEAN = vs.DeleteComponent(object, componentIndex)
		VectorScript: FUNCTION DeleteComponent(object:HANDLE; componentIndex:INTEGER) : BOOLEAN;
		
		Category: Objects - Architectural
		Deletes a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def DeleteConstraint(
		obj       , # HANDLE - Handle to object.                  
		constraint  # HANDLE - Handle to constraint being deleted.
		):
	'''
		Python: vs.DeleteConstraint(obj, constraint)
		VectorScript: PROCEDURE DeleteConstraint(obj:HANDLE; constraint:HANDLE);
		
		Category: Parametric Constraints
		Removes a constraint from the referenced object in the document.
	'''
	pass


def DeleteDLComponent(
		index  # INTEGER - The index of the component to delete.
		):
	'''
		Python: BOOLEAN = vs.DeleteDLComponent(index)
		VectorScript: FUNCTION DeleteDLComponent(index:INTEGER) : BOOLEAN;
		
		Category: Document Settings
		Deletes the nth component of the Double Line Preferences, where n is equal to index.
	'''
	pass
	return 'BOOLEAN' # 


def DeleteElement(
		XMLHandle  , # LONGINT            -  
		elementPath  # DYNARRAY[] of CHAR -  
		):
	'''
		Python: INTEGER = vs.DeleteElement(XMLHandle, elementPath)
		VectorScript: FUNCTION DeleteElement(XMLHandle:LONGINT; elementPath:DYNARRAY of CHAR) : INTEGER;
		
		Category: XML
		Deletes the element at the location specified by the path.
	'''
	pass
	return 'INTEGER' # 


def DeleteLBColumn(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID, # LONGINT - id of the list browser control                 
		columnIndex  # INTEGER - index of the column to be deleted              
		):
	'''
		Python: BOOLEAN = vs.DeleteLBColumn(dialogID, componentID, columnIndex)
		VectorScript: FUNCTION DeleteLBColumn(dialogID:LONGINT; componentID:LONGINT; columnIndex:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Deletes a column from the specified list browser control.
	'''
	pass
	return 'BOOLEAN' # 


def DeleteLBItem(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID, # LONGINT - id of the list browser control                 
		itemIndex    # INTEGER - the index of the item to delete                
		):
	'''
		Python: BOOLEAN = vs.DeleteLBItem(dialogID, componentID, itemIndex)
		VectorScript: FUNCTION DeleteLBItem(dialogID:LONGINT; componentID:LONGINT; itemIndex:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Deletes an item from the specified list browser control.
	'''
	pass
	return 'BOOLEAN' # 


def DeleteLevelTemplate(
		index  # INTEGER - The index of the Story Level Template to be deleted.
		):
	'''
		Python: BOOLEAN = vs.DeleteLevelTemplate(index)
		VectorScript: FUNCTION DeleteLevelTemplate(index:INTEGER) : BOOLEAN;
		
		Category: Layers
		Deletes the nth Story Level Template from the current file. For example, if 3 is passed in, it will delete the 3rd Story Level Template in the file.
	'''
	pass
	return 'BOOLEAN' # Whether the Story Level Template at 'index' was found and deleted successfully.


def DeleteObjs():
	'''
		Python: vs.DeleteObjs()
		VectorScript: PROCEDURE DeleteObjs;
		
		Category: Object Editing
		Procedure DeleteObjs deletes all selected objects on the active layer. Using this procedure when the layer display mode is Show/Snap/Modify will cause selected objects on any visible layer will be deleted.
	'''
	pass


def DeleteResourceFromList(
		listID, # LONGINT - an ID for a resource list created by the BuildResourceList function.
		index   # LONGINT - an index into the list.                                             
		):
	'''
		Python: vs.DeleteResourceFromList(listID, index)
		VectorScript: PROCEDURE DeleteResourceFromList(listID:LONGINT; index:LONGINT);
		
		Category: Document List Handling
		Deletes the indicated object in the specified resource list.
	'''
	pass


def DeleteStoryLayerTemplate(
		index  # INTEGER - Index of the Story Layer Template to delete.
		):
	'''
		Python: BOOLEAN = vs.DeleteStoryLayerTemplate(index)
		VectorScript: FUNCTION DeleteStoryLayerTemplate(index:INTEGER) : BOOLEAN;
		
		Category: Layers
		Deletes the nth Story Layer Template from the current file. For example, if 3 is passed in, it will delete the 3rd Story Layer Template in the file.
	'''
	pass
	return 'BOOLEAN' # Whether a Story Layer Template with the indicated index existed in the file.


def DeleteSymbolDefinition(
		hSymDef    , # HANDLE  - Handle to the symbol definition.                                                                              
		bCompletely  # BOOLEAN - Determines whether to replace the corresponding symbol instances with loci or delete the instances completely.
		):
	'''
		Python: vs.DeleteSymbolDefinition(hSymDef, bCompletely)
		VectorScript: PROCEDURE DeleteSymbolDefinition(hSymDef:HANDLE; bCompletely:BOOLEAN);
		
		Category: Object Editing
		Procedure DeleteSymbolDefinition deletes the referenced symbol definition from the document.  If bCompletely is TRUE, all corresponding symbol instances will be deleted completely; otherwise, the symbol instances will be replaced with loci.
	'''
	pass


def DeleteTextureSpace(
		obj   , # HANDLE  - Handle to object.                           
		partID  # INTEGER - Part ID (pass 1 for non-supporting objects).
		):
	'''
		Python: vs.DeleteTextureSpace(obj, partID)
		VectorScript: PROCEDURE DeleteTextureSpace(obj:HANDLE; partID:INTEGER);
		
		Category: Textures
		Function DeleteTextureSpace deletes the texture space attached to the referenced object or object part.
	'''
	pass


def DeleteWallPeak(
		wallHandle, # HANDLE  -  
		index       # INTEGER -  
		):
	'''
		Python: vs.DeleteWallPeak(wallHandle, index)
		VectorScript: PROCEDURE DeleteWallPeak(wallHandle:HANDLE; index:INTEGER);
		
		Category: Objects - Walls
		Deletes the wall peak at the given index number
	'''
	pass


def DeleteWallSym(
		symbolHd  # HANDLE - Handle to symbol.
		):
	'''
		Python: BOOLEAN = vs.DeleteWallSym(symbolHd)
		VectorScript: FUNCTION DeleteWallSym(symbolHd:HANDLE) : BOOLEAN;
		
		Category: Objects - Walls
		Function DeleteWallSym deletes the referenced symbol from a wall object.
	'''
	pass
	return 'BOOLEAN' # 


def DeleteWSColumns(
		worksheet  , # HANDLE  - Handle to worksheet.             
		startColumn, # INTEGER - Start column of delete operation.
		numColumns   # INTEGER - Number of columns to delete.     
		):
	'''
		Python: vs.DeleteWSColumns(worksheet, startColumn, numColumns)
		VectorScript: PROCEDURE DeleteWSColumns(worksheet:HANDLE; startColumn:INTEGER; numColumns:INTEGER);
		
		Category: Worksheets
		Deletes columns from the referenced worksheet.
	'''
	pass


def DeleteWSRows(
		worksheet, # HANDLE  - Handle to worksheet.          
		startRow , # INTEGER - Start row of delete operation.
		numRows    # INTEGER - Number of rows to be deleted. 
		):
	'''
		Python: vs.DeleteWSRows(worksheet, startRow, numRows)
		VectorScript: PROCEDURE DeleteWSRows(worksheet:HANDLE; startRow:INTEGER; numRows:INTEGER);
		
		Category: Worksheets
		Deletes rows from the referenced worksheet.
	'''
	pass


def DelName(
		name  # STRING - Object name to be deleted.
		):
	'''
		Python: vs.DelName(name)
		VectorScript: PROCEDURE DelName(name:STRING);
		
		Category: Object Names
		Procedure DelName deletes an object name from a Vectorworks document. The associated object is not affected by the name deletion.
	'''
	pass


def DelObject(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: vs.DelObject(h)
		VectorScript: PROCEDURE DelObject(h:HANDLE);
		
		Category: Object Editing
		Procedure DelObject deletes the referenced object from the document.
	'''
	pass


def DelObjStoryBound(
		object , # HANDLE  - The object.                       
		boundID  # INTEGER - The identifier of the story bound.
		):
	'''
		Python: vs.DelObjStoryBound(object, boundID)
		VectorScript: PROCEDURE DelObjStoryBound(object:HANDLE; boundID:INTEGER);
		
		Category: Objects - Architectural
		Delete the specified story bounds from this object.
	'''
	pass


def DelObjStoryBounds(
		object  # HANDLE - The object.
		):
	'''
		Python: vs.DelObjStoryBounds(object)
		VectorScript: PROCEDURE DelObjStoryBounds(object:HANDLE);
		
		Category: Objects - Architectural
		Delete all story bounds for this object.
	'''
	pass


def DelRecord(
		h   , # HANDLE             - Handle to object.            
		name  # DYNARRAY[] of CHAR - Name of record to be removed.
		):
	'''
		Python: vs.DelRecord(h, name)
		VectorScript: PROCEDURE DelRecord(h:HANDLE; name:DYNARRAY of CHAR);
		
		Category: Database / Record
		Procedure DelRecord removes an attached record from the referenced object.
	'''
	pass


def DelSavedSetting(
		category, # STRING - The category for the setting.
		setting   # STRING - The setting to be deleted.   
		):
	'''
		Python: BOOLEAN = vs.DelSavedSetting(category, setting)
		VectorScript: FUNCTION DelSavedSetting(category:STRING; setting:STRING) : BOOLEAN;
		
		Category: Utility
		Delete saved settings.
	'''
	pass
	return 'BOOLEAN' # Return TRUE when successful.


def DelSavedSettings(
		category  # STRING - The category to be deleted.
		):
	'''
		Python: BOOLEAN = vs.DelSavedSettings(category)
		VectorScript: FUNCTION DelSavedSettings(category:STRING) : BOOLEAN;
		
		Category: Utility
		Delete all saved settings in the specified category.
	'''
	pass
	return 'BOOLEAN' # Return TRUE when successful.


def DelVectorFill(
		vectorFillName  # STRING - Name of vector fill.
		):
	'''
		Python: vs.DelVectorFill(vectorFillName)
		VectorScript: PROCEDURE DelVectorFill(vectorFillName:STRING);
		
		Category: Hatches / Vector Fills
		Procedure DelVectorFill deletes the specified vector fill definition.
	'''
	pass


def DelVertex(
		objectHd , # HANDLE  - Handle to polygon.            
		vertexNum  # INTEGER - Index of vertex to be deleted.
		):
	'''
		Python: vs.DelVertex(objectHd, vertexNum)
		VectorScript: PROCEDURE DelVertex(objectHd:HANDLE; vertexNum:INTEGER);
		
		Category: Objects - Polys
		Procedure DelVertex deletes a vertex from the referenced object. Parameter vertexNum specifies the vertex to be deleted.
	'''
	pass


def DeregisterDialogFromTimerEvents(
		dialogID  # LONGINT - the dialog identifier given by CreateLayout or CreateResizableLayout
		):
	'''
		Python: vs.DeregisterDialogFromTimerEvents(dialogID)
		VectorScript: PROCEDURE DeregisterDialogFromTimerEvents(dialogID:LONGINT);
		
		Category: Dialogs - Modern
		Removes the dialog from the timer event registry system.
	'''
	pass


def DeselectEditText(
		dialogID , # LONGINT -  
		controlID  # LONGINT -  
		):
	'''
		Python: vs.DeselectEditText(dialogID, controlID)
		VectorScript: PROCEDURE DeselectEditText(dialogID:LONGINT; controlID:LONGINT);
		
		Category: Dialogs - Modern
		Deselects all text in the specified edit control.
	'''
	pass


def DetailGraphicOptDlg(
		Marker        , # in/out STRING  - The name of the selected Marker symbol.           
		ShoulderLength, # in/out REAL    - The shoulder length for the detail callout object.
		TagPosIndex   , # in/out INTEGER - The index of the selected Tag Position.           
		LeaderType    , # in/out LONGINT - The linetype for the leader lines.                
		LeaderThick     # in/out INTEGER - The line thickness for the leader line.           
		):
	'''
		Python: (BOOLEAN, Marker, ShoulderLength, TagPosIndex, LeaderType, LeaderThick) = vs.DetailGraphicOptDlg(Marker, ShoulderLength, TagPosIndex, LeaderType, LeaderThick)
		VectorScript: FUNCTION DetailGraphicOptDlg(VAR Marker:STRING; VAR ShoulderLength:REAL; VAR TagPosIndex:INTEGER; VAR LeaderType:LONGINT; VAR LeaderThick:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Predefined
		This brings up the Graphic Options dialog for Detail-Callout Marker and Detail Callout objects.
	'''
	pass
	return ( False   , # Whether the user clicked on the OK button.
	         'string', 
	         0.0     , 
	         0       , 
	         0       , 
	         0        )


def DidCancel():
	'''
		Python: BOOLEAN = vs.DidCancel()
		VectorScript: FUNCTION DidCancel : BOOLEAN;
		
		Category: Dialogs - Predefined
		Function DidCancel detects whether the Cancel button in a predefined dialog was pressed. DidCancel is intended for use with conditional statements to signal that a cancel event has occurred.
	'''
	pass
	return 'BOOLEAN' # 


def DimArcText():
	'''
		Python: vs.DimArcText()
		VectorScript: PROCEDURE DimArcText;
		
		Category: Dimensions
		Procedure DimArcText creates an angular dimension object from the last arc object that was drawn using VectorScript.
	'''
	pass


def DimText():
	'''
		Python: vs.DimText()
		VectorScript: PROCEDURE DimText;
		
		Category: Dimensions
		Procedure DimText converts the most recently created line object in VectorScript to a dimension.
	'''
	pass


def DisableModules(
		modules  # LONGINT - This modules parameter is a LONGINT value which contains a bit for each possible product module.  If a module is enabled, then the corresponding bit is set to 1.  If that module is disabled, then its bit is 0.  The table below contains selectors that can be used to interpret the results of this function.  To determine if a module is enabled, do a bitwise "and" operation with the selector and the value returned by this function.  See the usage example below.[[BR]][[BR]][[note:ProductModules]]
		):
	'''
		Python: vs.DisableModules(modules)
		VectorScript: PROCEDURE DisableModules(modules:LONGINT);
		
		Category: Utility
		Disables modules.  The modules parameter is a bitfield indicating which modules to disable.
	'''
	pass


def DisplayContextHelpOfCurrentPlugin():
	'''
		Python: vs.DisplayContextHelpOfCurrentPlugin()
		VectorScript: PROCEDURE DisplayContextHelpOfCurrentPlugin;
		
		Category: Utility
		This function will display the context help of the plug-in that is considered 'current'. This could be a command plug-in that has a dialog open, or a tool plug-in that is active.
	'''
	pass


def DisplayContextualHelp(
		Identifier  # STRING -  
		):
	'''
		Python: BOOLEAN = vs.DisplayContextualHelp(Identifier)
		VectorScript: FUNCTION DisplayContextualHelp(Identifier:STRING) : BOOLEAN;
		
		Category: Utility
		Using the identifier string for a GUI element given by the Contextual Help Manager displays the associated contextual help. This could be a WebWorks webpage, a Internet webpage or even a local file.
	'''
	pass
	return 'BOOLEAN' # 


def DisplayLayerScaleDialog():
	'''
		Python: vs.DisplayLayerScaleDialog()
		VectorScript: PROCEDURE DisplayLayerScaleDialog;
		
		Category: Layers
		Brings up the Layer Scale dialog.
	'''
	pass


def DisplayOrganizationDialog(
		tabToSelect  # INTEGER - The tab to be initially selected.
		):
	'''
		Python: vs.DisplayOrganizationDialog(tabToSelect)
		VectorScript: PROCEDURE DisplayOrganizationDialog(tabToSelect:INTEGER);
		
		Category: Utility
		Displays the organization dialog with the specified integer as the initially slected tab.
		0: The most recently displayed tab is selected
		1: The Classes tab is selected .
		2: The Design Layers tab is selected.
		3: The Sheet Layers tab is selected.
		4: The Viewports tab is selected.
		5: The Saved Views tab is selected.
	'''
	pass


def DisplaySwapPane(
		dialogID     , # LONGINT - the ID of the dialog                          
		swapControlID, # LONGINT - the ID of the swap control                    
		groupNumber    # LONGINT - 1-based index of the swap pane to be displayed
		):
	'''
		Python: vs.DisplaySwapPane(dialogID, swapControlID, groupNumber)
		VectorScript: PROCEDURE DisplaySwapPane(dialogID:LONGINT; swapControlID:LONGINT; groupNumber:LONGINT);
		
		Category: Dialogs - Modern
		Causes the specified swap pane to be displayed within the specified swap control.
		This is called from the dialog's event handling routine.
	'''
	pass


def DisplayTabPane(
		dialogID    , # LONGINT - the ID of the dialog                          
		tabControlID, # LONGINT - the ID of the swap control                    
		groupNumber   # LONGINT - 1-based index of the swap pane to be displayed
		):
	'''
		Python: vs.DisplayTabPane(dialogID, tabControlID, groupNumber)
		VectorScript: PROCEDURE DisplayTabPane(dialogID:LONGINT; tabControlID:LONGINT; groupNumber:LONGINT);
		
		Category: Dialogs - Modern
		Causes the specified swap pane to be displayed within the specified swap control.
		This is called from the dialog's event handling routine.
	'''
	pass


def Distance(
		x1, # REAL - X coordinate of first point. 
		y1, # REAL - Y coordinate of first point. 
		x2, # REAL - X coordinate of second point.
		y2  # REAL - Y coordinate of second point.
		):
	'''
		Python: REAL = vs.Distance(x1, y1, x2, y2)
		VectorScript: FUNCTION Distance(x1:REAL; y1:REAL; x2:REAL; y2:REAL) : REAL;
		
		Category: Graphic Calculation
		Function Distance returns the distance between the two specified coordinate locations.
	'''
	pass
	return 'REAL' # 


def Distance3D(
		x1, # REAL -  
		y1, # REAL -  
		z1, # REAL -  
		x2, # REAL -  
		y2, # REAL -  
		z2  # REAL -  
		):
	'''
		Python: REAL = vs.Distance3D(x1, y1, z1, x2, y2, z2)
		VectorScript: FUNCTION Distance3D(x1:REAL; y1:REAL; z1:REAL; x2:REAL; y2:REAL; z2:REAL) : REAL;
		
		Category: Graphic Calculation
		Returns the 3D distance between two points. Same as Norm.
	'''
	pass
	return 'REAL' # 


def DistDialog(
		request, # DYNARRAY[] of CHAR - Dialog user prompt string.    
		default  # DYNARRAY[] of CHAR - Default value for input field.
		):
	'''
		Python: REAL = vs.DistDialog(request, default)
		VectorScript: FUNCTION DistDialog(request:DYNARRAY of CHAR; default:DYNARRAY of CHAR) : REAL;
		
		Category: Dialogs - Predefined
		Function DistDialog displays a dialog box which requests the user to enter a distance value.
		DistDialog automatically screens for valid numeric input.
	'''
	pass
	return 'REAL' # 


def DLDBeginLoadData(
		loadDataType  # INTEGER -  
		):
	'''
		Python: vs.DLDBeginLoadData(loadDataType)
		VectorScript: PROCEDURE DLDBeginLoadData(loadDataType:INTEGER);
		
		Category: Truss Analysis
		Begin creation of load data from that type.
	'''
	pass


def DLDEndLoadData():
	'''
		Python: vs.DLDEndLoadData()
		VectorScript: PROCEDURE DLDEndLoadData;
		
		Category: Truss Analysis
		Add the created data to object properties
	'''
	pass


def DLDSetLoadDataBool(
		selector, # INTEGER -  
		value     # BOOLEAN -  
		):
	'''
		Python: vs.DLDSetLoadDataBool(selector, value)
		VectorScript: PROCEDURE DLDSetLoadDataBool(selector:INTEGER; value:BOOLEAN);
		
		Category: Truss Analysis
		Using selector, sets default load data with boolean value for the parametric object
	'''
	pass


def DLDSetLoadDataReal(
		selector, # INTEGER -  
		value     # REAL    -  
		):
	'''
		Python: vs.DLDSetLoadDataReal(selector, value)
		VectorScript: PROCEDURE DLDSetLoadDataReal(selector:INTEGER; value:REAL);
		
		Category: Truss Analysis
		Using selector, sets default load data with real value for the parametric object
	'''
	pass


def DLDSetLoadDataString(
		selector, # INTEGER -  
		value     # STRING  -  
		):
	'''
		Python: vs.DLDSetLoadDataString(selector, value)
		VectorScript: PROCEDURE DLDSetLoadDataString(selector:INTEGER; value:STRING);
		
		Category: Truss Analysis
		Using selector, sets default load data with string value for the parametric object
	'''
	pass


def DocDropShadowByCls():
	'''
		Python: BOOLEAN = vs.DocDropShadowByCls()
		VectorScript: FUNCTION DocDropShadowByCls : BOOLEAN;
		
		Category: Document Attributes
	'''
	pass
	return 'BOOLEAN' # 


def DoMenuText(
		menuItem  # STRING - Menu item name.
		):
	'''
		Python: vs.DoMenuText(menuItem)
		VectorScript: PROCEDURE DoMenuText(menuItem:STRING);
		
		Category: Command
		Obsolete procedure.
	'''
	pass


def DoMenuTextByName(
		subMenu, # STRING  - Menu item  selector.                       
		index    # INTEGER - Menu chunk item position (range of 1 -  n).
		):
	'''
		Python: vs.DoMenuTextByName(subMenu, index)
		VectorScript: PROCEDURE DoMenuTextByName(subMenu:STRING; index:INTEGER);
		
		Category: Command
		Calls the specified Vectorworks menu command item.
		If the item is part of a Vectorworks menu chunk, pass the position of the item within the chunk as the second parameter. For menu items that are not part of a chunk, pass 0 as the second parameter.
		Note: DoMenuTextByName uses the internal Vectorworks menu item name to reference the menu command, and calls to this procedure will work on localized (international) versions of Vectorworks without modification. Note also that when calling VS plug-ins, you have to use the filename (which could be different from the internal plug-in name).
	'''
	pass


def DotProduct(
		v1, # VECTOR - Source vector 1.
		v2  # VECTOR - Source vector 2.
		):
	'''
		Python: REAL = vs.DotProduct(v1, v2)
		VectorScript: FUNCTION DotProduct(v1:VECTOR; v2:VECTOR) : REAL;
		
		Category: Math - Vectors
		Returns the dot product of the two specified vectors.
		The dot product is also known as the scalar product of the two vectors, and is equivalent to the product of the magnitudes of the two vectors multiplied by the cosine of the angle between the two vectors.
	'''
	pass
	return 'REAL' # Returns the scalar, or dot, product of the vectors [[p:1]] and [[p:2]].


def DoubleFixedTolerance(
		showVal, # BOOLEAN - Dimension text display flag.  
		boxText, # BOOLEAN - Boxed text display flag.      
		leader , # STRING  - Dimension leader text string. 
		trailer, # STRING  - Dimension trailer text string.
		topStr , # STRING  - Tolerance value text string.  
		botStr   # STRING  - Tolerance value text string.  
		):
	'''
		Python: vs.DoubleFixedTolerance(showVal, boxText, leader, trailer, topStr, botStr)
		VectorScript: PROCEDURE DoubleFixedTolerance(showVal:BOOLEAN; boxText:BOOLEAN; leader:STRING; trailer:STRING; topStr:STRING; botStr:STRING);
		
		Category: Dimensions
		Procedure DoubleFixedTolerance is used with dimensioning procedures to define a tolerance for the most recently created dimension object.
	'''
	pass


def DoubleTolerance(
		showVal    , # BOOLEAN           - Dimension text display flag.  
		boxText    , # BOOLEAN           - Boxed text display flag.      
		leader     , # STRING            - Dimension leader text string. 
		trailer    , # STRING            - Dimension trailer text string.
		topDistance, # REAL (Coordinate) - Tolerance value text string.  
		botDistance  # REAL (Coordinate) - Tolerance value text string.  
		):
	'''
		Python: vs.DoubleTolerance(showVal, boxText, leader, trailer, topDistance, botDistance)
		VectorScript: PROCEDURE DoubleTolerance(showVal:BOOLEAN; boxText:BOOLEAN; leader:STRING; trailer:STRING; topDistance:REAL (Coordinate); botDistance:REAL (Coordinate));
		
		Category: Dimensions
		Procedure DoubleTolerance is used with dimensioning procedures to define a tolerance for the most recently created dimension.
	'''
	pass


def DoubLines(
		doubleLineDistance  # REAL (Coordinate) - Width between lines.
		):
	'''
		Python: vs.DoubLines(doubleLineDistance)
		VectorScript: PROCEDURE DoubLines(doubleLineDistance:REAL (Coordinate));
		
		Category: Document Settings
		Procedure DoubLines sets the line spacing width for double-line tools.
	'''
	pass


def DrawNurbsObject(
		h  # HANDLE -  
		):
	'''
		Python: vs.DrawNurbsObject(h)
		VectorScript: PROCEDURE DrawNurbsObject(h:HANDLE);
		
		Category: Objects - NURBS
		Draws the NURBS object h on the screen.
	'''
	pass


def DrwSize(
		rows   , # INTEGER - Number of sheet rows comprising total document area.   
		columns  # INTEGER - Number of sheet columns comprising total document area.
		):
	'''
		Python: vs.DrwSize(rows, columns)
		VectorScript: PROCEDURE DrwSize(rows:INTEGER; columns:INTEGER);
		
		Category: Document Settings
		Procedure DrwSize sets the drawing area of the document.
	'''
	pass


def DS_GetAngle():
	'''
		Python: REAL = vs.DS_GetAngle()
		VectorScript: FUNCTION DS_GetAngle : REAL;
		
		Category: Document Attributes
		Returns document shadow angle.
	'''
	pass
	return 'REAL' # 


def DS_GetFillStyle(
		):
	'''
		Python: (shadowFillStyle, shadowFillName, solidColorRef) = vs.DS_GetFillStyle()
		VectorScript: PROCEDURE DS_GetFillStyle(VAR shadowFillStyle:INTEGER; VAR shadowFillName:STRING; VAR solidColorRef:LONGINT);
		
		Category: Document Attributes
		Returns document shadow fill style, fill name or color index.
	'''
	pass
	return ( 0       , 
	         'string', 
	         0        )


def DS_GetOffset():
	'''
		Python: REAL = vs.DS_GetOffset()
		VectorScript: FUNCTION DS_GetOffset : REAL;
		
		Category: Document Attributes
		Returns document shadow offset.
	'''
	pass
	return 'REAL' # 


def DS_GetOffsetUnit():
	'''
		Python: INTEGER = vs.DS_GetOffsetUnit()
		VectorScript: FUNCTION DS_GetOffsetUnit : INTEGER;
		
		Category: Document Attributes
		Returns document shadow offset unit.
	'''
	pass
	return 'INTEGER' # 


def DS_GetOpacity():
	'''
		Python: LONGINT = vs.DS_GetOpacity()
		VectorScript: FUNCTION DS_GetOpacity : LONGINT;
		
		Category: Document Attributes
		Returns document shadow opacity.
	'''
	pass
	return 'LONGINT' # 


def DS_IsOpacityByClass():
	'''
		Python: BOOLEAN = vs.DS_IsOpacityByClass()
		VectorScript: FUNCTION DS_IsOpacityByClass : BOOLEAN;
		
		Category: Document Attributes
		Returns whether document shadow opacity is by class.
	'''
	pass
	return 'BOOLEAN' # 


def DS_IsUnderCanopy():
	'''
		Python: BOOLEAN = vs.DS_IsUnderCanopy()
		VectorScript: FUNCTION DS_IsUnderCanopy : BOOLEAN;
		
		Category: Document Attributes
		Returns whether document shadow is under Canopy.
	'''
	pass
	return 'BOOLEAN' # 


def DSelectAll():
	'''
		Python: vs.DSelectAll()
		VectorScript: PROCEDURE DSelectAll;
		
		Category: Selection
		Procedure DSelectAll deselects all selected visible objects on the active layer of a Vectorworks document. If Layer Options is set to Show-Snap-Modify Others, then DSelectAll will deselect all selected visible objects within the document.
	'''
	pass


def DSelectObj(
		c  # CRITERIA - Search criteria.
		):
	'''
		Python: vs.DSelectObj(c)
		VectorScript: PROCEDURE DSelectObj(c:CRITERIA);
		
		Category: Criteria
		Deselects all objects which match the search criteria.
	'''
	pass


def DT_BeginMultipleMove():
	'''
		Python: BOOLEAN = vs.DT_BeginMultipleMove()
		VectorScript: FUNCTION DT_BeginMultipleMove : BOOLEAN;
		
		Category: Data Tag Interface Library
		Returns TRUE if moving system was started successful.
	'''
	pass
	return 'BOOLEAN' # 


def DT_EndMultipleMove():
	'''
		Python: BOOLEAN = vs.DT_EndMultipleMove()
		VectorScript: FUNCTION DT_EndMultipleMove : BOOLEAN;
		
		Category: Data Tag Interface Library
		Returns TRUE if moving system was stoped successful.
	'''
	pass
	return 'BOOLEAN' # 


def DT_UpdateTagsOfTagged(
		h  # HANDLE -  
		):
	'''
		Python: BOOLEAN = vs.DT_UpdateTagsOfTagged(h)
		VectorScript: FUNCTION DT_UpdateTagsOfTagged(h:HANDLE) : BOOLEAN;
		
		Category: Data Tag Interface Library
		Returns TRUE if updating is success.
	'''
	pass
	return 'BOOLEAN' # 


def DTM6_ClearModelCache(
		hObject  # HANDLE -  
		):
	'''
		Python: vs.DTM6_ClearModelCache(hObject)
		VectorScript: PROCEDURE DTM6_ClearModelCache(hObject:HANDLE);
		
		Category: SiteModel Interface Library
		Clear the site model's cache.
	'''
	pass


def DTM6_GetDTMObject(
		hLayer      , # HANDLE  -  
		bPickUpModel  # BOOLEAN -  
		):
	'''
		Python: HANDLE = vs.DTM6_GetDTMObject(hLayer, bPickUpModel)
		VectorScript: FUNCTION DTM6_GetDTMObject(hLayer:HANDLE; bPickUpModel:BOOLEAN) : HANDLE;
		
		Category: SiteModel Interface Library
		Gets the DTM. If it's only one on the document and/or on the passed layer return it. If there are many DTMs ask the user to pick up one.
	'''
	pass
	return 'HANDLE' # 


def DTM6_GetDTMOver(
		hObject  # HANDLE -  
		):
	'''
		Python: HANDLE = vs.DTM6_GetDTMOver(hObject)
		VectorScript: FUNCTION DTM6_GetDTMOver(hObject:HANDLE) : HANDLE;
		
		Category: SiteModel Interface Library
		Gets the DTM over (geometrically) a specified object.
	'''
	pass
	return 'HANDLE' # 


def DTM6_GetZatXY(
		hDTMObject, # HANDLE  -  
		TINType   , # INTEGER -  
		x         , # REAL    -  
		y           # REAL    -  
		):
	'''
		Python: (BOOLEAN, outZ) = vs.DTM6_GetZatXY(hDTMObject, TINType, x, y)
		VectorScript: FUNCTION DTM6_GetZatXY(hDTMObject:HANDLE; TINType:INTEGER; x:REAL; y:REAL; VAR outZ:REAL) : BOOLEAN;
		
		Category: SiteModel Interface Library
		Get the elevation at specified x,y on the specified DTM. Returns false if the DTM doesnt exist or the point is outside the DTM. TINType - 0:Existing; 1:Proposed; 2:Current
	'''
	pass
	return ( False  , # 
	         0.0     )


def DTM6_IsDTM6Object(
		hDTMObject  # HANDLE -  
		):
	'''
		Python: BOOLEAN = vs.DTM6_IsDTM6Object(hDTMObject)
		VectorScript: FUNCTION DTM6_IsDTM6Object(hDTMObject:HANDLE) : BOOLEAN;
		
		Category: SiteModel Interface Library
		Check if the passed object handle is for SiteModel object type.
	'''
	pass
	return 'BOOLEAN' # 


def DTM6_IsObjectReady(
		hDTMObject  # HANDLE -  
		):
	'''
		Python: BOOLEAN = vs.DTM6_IsObjectReady(hDTMObject)
		VectorScript: FUNCTION DTM6_IsObjectReady(hDTMObject:HANDLE) : BOOLEAN;
		
		Category: SiteModel Interface Library
		Check if the DTM object is ready to be used. If this returns false, you should call 'ResetObject' on the handle to let the DTM object prepare itself to be used.
	'''
	pass
	return 'BOOLEAN' # 


def DTM6_IsTypeVisible(
		hDTMObject, # HANDLE  -  
		TINType     # INTEGER -  
		):
	'''
		Python: BOOLEAN = vs.DTM6_IsTypeVisible(hDTMObject, TINType)
		VectorScript: FUNCTION DTM6_IsTypeVisible(hDTMObject:HANDLE; TINType:INTEGER) : BOOLEAN;
		
		Category: SiteModel Interface Library
		Return true if the specified DTM type is visible of the passed DTM object.
	'''
	pass
	return 'BOOLEAN' # 


def DTM6_RestoreDefaults(
		hObject  # HANDLE -  
		):
	'''
		Python: vs.DTM6_RestoreDefaults(hObject)
		VectorScript: PROCEDURE DTM6_RestoreDefaults(hObject:HANDLE);
		
		Category: SiteModel Interface Library
		Sets the default settings for a Site model.
	'''
	pass


def DTM6_RiseToSurface(
		hDTMObject, # HANDLE  -  
		hObject   , # HANDLE  -  
		TINType   , # INTEGER -  
		sendType    # INTEGER -  
		):
	'''
		Python: BOOLEAN = vs.DTM6_RiseToSurface(hDTMObject, hObject, TINType, sendType)
		VectorScript: FUNCTION DTM6_RiseToSurface(hDTMObject:HANDLE; hObject:HANDLE; TINType:INTEGER; sendType:INTEGER) : BOOLEAN;
		
		Category: SiteModel Interface Library
		Modifies the passed object so it lies on the surface of the desired DTM.
	'''
	pass
	return 'BOOLEAN' # 


def DTM6_SendToSurface(
		hDTMObject, # HANDLE  -  
		hObject   , # HANDLE  -  
		TINType     # INTEGER -  
		):
	'''
		Python: BOOLEAN = vs.DTM6_SendToSurface(hDTMObject, hObject, TINType)
		VectorScript: FUNCTION DTM6_SendToSurface(hDTMObject:HANDLE; hObject:HANDLE; TINType:INTEGER) : BOOLEAN;
		
		Category: SiteModel Interface Library
		Modifies the passed object so it lies on the surface of the desired DTM.
	'''
	pass
	return 'BOOLEAN' # 


def DTM6_ShowSendEdgeDlg(
		objWEdgeType  # INTEGER -  
		):
	'''
		Python: INTEGER = vs.DTM6_ShowSendEdgeDlg(objWEdgeType)
		VectorScript: FUNCTION DTM6_ShowSendEdgeDlg(objWEdgeType:INTEGER) : INTEGER;
		
		Category: SiteModel Interface Library
		Shows the Send to Surface dialog for modifier objects with retaining edge.
	'''
	pass
	return 'INTEGER' # 


def Duplicate(
		offset  # POINT - Offset value.
		):
	'''
		Python: vs.Duplicate(offset)
		VectorScript: PROCEDURE Duplicate(offsetDX, offsetDY:REAL);
		
		Category: Object Editing
		Procedure Duplicate copies the currently selected objects and moves them the specified offset distance.
	'''
	pass


def DXFScaleString(
		scale  # REAL -  
		):
	'''
		Python: STRING = vs.DXFScaleString(scale)
		VectorScript: FUNCTION DXFScaleString(scale:REAL) : STRING;
		
		Category: ImportExport
		Get DXF scale string
	'''
	pass
	return 'STRING' # 


def EA_ConvDoc2X(
		unitType, # INTEGER -  
		value     # REAL    -  
		):
	'''
		Python: REAL = vs.EA_ConvDoc2X(unitType, value)
		VectorScript: FUNCTION EA_ConvDoc2X(unitType:INTEGER; value:REAL) : REAL;
		
		Category: EnergyAnalysis Interface Library
		Converts value from document unit to X unit and returns the result as real number.
	'''
	pass
	return 'REAL' # 


def EA_ConvStr2X(
		unitType, # INTEGER -  
		value     # STRING  -  
		):
	'''
		Python: REAL = vs.EA_ConvStr2X(unitType, value)
		VectorScript: FUNCTION EA_ConvStr2X(unitType:INTEGER; value:STRING) : REAL;
		
		Category: EnergyAnalysis Interface Library
		Converts string to X unit and returns the result as real number.
	'''
	pass
	return 'REAL' # 


def EA_ConvX2Doc(
		unitType, # INTEGER -  
		value     # REAL    -  
		):
	'''
		Python: REAL = vs.EA_ConvX2Doc(unitType, value)
		VectorScript: FUNCTION EA_ConvX2Doc(unitType:INTEGER; value:REAL) : REAL;
		
		Category: EnergyAnalysis Interface Library
		Converts value from X unit to document unit and returns the result as a real number.
	'''
	pass
	return 'REAL' # 


def EA_ConvX2DocStr(
		unitType   , # INTEGER -  
		value      , # REAL    -  
		incUnitMark  # BOOLEAN -  
		):
	'''
		Python: STRING = vs.EA_ConvX2DocStr(unitType, value, incUnitMark)
		VectorScript: FUNCTION EA_ConvX2DocStr(unitType:INTEGER; value:REAL; incUnitMark:BOOLEAN) : STRING;
		
		Category: EnergyAnalysis Interface Library
		Converts value from X unit to document unit and returns the result as real number.
	'''
	pass
	return 'STRING' # 


def EA_DataAccAdvDlg(
		acc  # INTEGER -  
		):
	'''
		Python: BOOLEAN = vs.EA_DataAccAdvDlg(acc)
		VectorScript: FUNCTION EA_DataAccAdvDlg(acc:INTEGER) : BOOLEAN;
		
		Category: EnergyAnalysis Interface Library
		Shows an advanced settings dialog.
	'''
	pass
	return 'BOOLEAN' # 


def EA_DataAccCompAdd(
		acc      , # INTEGER -  
		include  , # BOOLEAN -  
		lambda   , # REAL    -  
		thickness  # REAL    -  
		):
	'''
		Python: vs.EA_DataAccCompAdd(acc, include, lambda, thickness)
		VectorScript: PROCEDURE EA_DataAccCompAdd(acc:INTEGER; include:BOOLEAN; lambda:REAL; thickness:REAL);
		
		Category: EnergyAnalysis Interface Library
		Adds object component.
	'''
	pass


def EA_DataAccCompDel(
		acc  # INTEGER -  
		):
	'''
		Python: vs.EA_DataAccCompDel(acc)
		VectorScript: PROCEDURE EA_DataAccCompDel(acc:INTEGER);
		
		Category: EnergyAnalysis Interface Library
		Deletes all object components.
	'''
	pass


def EA_DataAccCompGet(
		acc  # INTEGER -  
		):
	'''
		Python: (componentIndex, outInclude, outLambda, outThickness) = vs.EA_DataAccCompGet(acc)
		VectorScript: PROCEDURE EA_DataAccCompGet(acc:INTEGER; VAR componentIndex:INTEGER; VAR outInclude:BOOLEAN; VAR outLambda:REAL; VAR outThickness:REAL);
		
		Category: EnergyAnalysis Interface Library
		Gets object component data.
	'''
	pass
	return ( 0    , 
	         False, 
	         0.0  , 
	         0.0   )


def EA_DataAccCpyInto(
		acc, # INTEGER -  
		h    # HANDLE  -  
		):
	'''
		Python: vs.EA_DataAccCpyInto(acc, h)
		VectorScript: PROCEDURE EA_DataAccCpyInto(acc:INTEGER; h:HANDLE);
		
		Category: EnergyAnalysis Interface Library
		Copies data from accessory to object.
	'''
	pass


def EA_DataAccCreate(
		type, # INTEGER -  
		h     # HANDLE  -  
		):
	'''
		Python: INTEGER = vs.EA_DataAccCreate(type, h)
		VectorScript: FUNCTION EA_DataAccCreate(type:INTEGER; h:HANDLE) : INTEGER;
		
		Category: EnergyAnalysis Interface Library
		Returns accessory index. The function opens a "session" to energy analysis plugin for particular handle. The handle is a handle to record format or to object.
	'''
	pass
	return 'INTEGER' # 


def EA_DataAccDelete(
		acc  # INTEGER -  
		):
	'''
		Python: vs.EA_DataAccDelete(acc)
		VectorScript: PROCEDURE EA_DataAccDelete(acc:INTEGER);
		
		Category: EnergyAnalysis Interface Library
		Destroys accessory by index. The function closes the "session" to energy analysis plugin for particular handle. The handle is a handle to record format or to object.
	'''
	pass


def EA_DataAccFillUI(
		acc     , # INTEGER -  
		dialogID, # INTEGER -  
		ctrlID  , # INTEGER -  
		uiIndex   # INTEGER -  
		):
	'''
		Python: vs.EA_DataAccFillUI(acc, dialogID, ctrlID, uiIndex)
		VectorScript: PROCEDURE EA_DataAccFillUI(acc:INTEGER; dialogID:INTEGER; ctrlID:INTEGER; uiIndex:INTEGER);
		
		Category: EnergyAnalysis Interface Library
		Fills popup with system data.
	'''
	pass


def EA_DataAccGetBool(
		acc       , # INTEGER -  
		valueIndex  # INTEGER -  
		):
	'''
		Python: BOOLEAN = vs.EA_DataAccGetBool(acc, valueIndex)
		VectorScript: FUNCTION EA_DataAccGetBool(acc:INTEGER; valueIndex:INTEGER) : BOOLEAN;
		
		Category: EnergyAnalysis Interface Library
		Returns boolean value from the object, associated to the accessory index.
	'''
	pass
	return 'BOOLEAN' # 


def EA_DataAccGetInt(
		acc       , # INTEGER -  
		valueIndex  # INTEGER -  
		):
	'''
		Python: INTEGER = vs.EA_DataAccGetInt(acc, valueIndex)
		VectorScript: FUNCTION EA_DataAccGetInt(acc:INTEGER; valueIndex:INTEGER) : INTEGER;
		
		Category: EnergyAnalysis Interface Library
		Returns integer value from the object, associated to the accessory index.
	'''
	pass
	return 'INTEGER' # 


def EA_DataAccGetReal(
		acc       , # INTEGER -  
		valueIndex  # INTEGER -  
		):
	'''
		Python: REAL = vs.EA_DataAccGetReal(acc, valueIndex)
		VectorScript: FUNCTION EA_DataAccGetReal(acc:INTEGER; valueIndex:INTEGER) : REAL;
		
		Category: EnergyAnalysis Interface Library
		Returns real value from the object, associated to the accessory index.
	'''
	pass
	return 'REAL' # 


def EA_DataAccGetStr(
		acc       , # INTEGER -  
		valueIndex  # INTEGER -  
		):
	'''
		Python: STRING = vs.EA_DataAccGetStr(acc, valueIndex)
		VectorScript: FUNCTION EA_DataAccGetStr(acc:INTEGER; valueIndex:INTEGER) : STRING;
		
		Category: EnergyAnalysis Interface Library
		Returns string value from the object, associated to the accessory index.
	'''
	pass
	return 'STRING' # 


def EA_DataAccMtrlDlg(
		acc  # INTEGER -  
		):
	'''
		Python: (BOOLEAN, outLambda) = vs.EA_DataAccMtrlDlg(acc)
		VectorScript: FUNCTION EA_DataAccMtrlDlg(acc:INTEGER; VAR outLambda:REAL) : BOOLEAN;
		
		Category: EnergyAnalysis Interface Library
		Shows the lambda material dialog and set the selected lambda value to outLambda.
	'''
	pass
	return ( False  , # 
	         0.0     )


def EA_DataAccSave(
		acc  # INTEGER -  
		):
	'''
		Python: vs.EA_DataAccSave(acc)
		VectorScript: PROCEDURE EA_DataAccSave(acc:INTEGER);
		
		Category: EnergyAnalysis Interface Library
		Saves data to accessory. The function saves the energy data for the handle who is corresponding to the accessory index.
	'''
	pass


def EA_DataAccSelUI(
		acc     , # INTEGER -  
		dialogID, # INTEGER -  
		ctrlID  , # INTEGER -  
		uiIndex   # INTEGER -  
		):
	'''
		Python: vs.EA_DataAccSelUI(acc, dialogID, ctrlID, uiIndex)
		VectorScript: PROCEDURE EA_DataAccSelUI(acc:INTEGER; dialogID:INTEGER; ctrlID:INTEGER; uiIndex:INTEGER);
		
		Category: EnergyAnalysis Interface Library
		Selects item in popup and update system data.
	'''
	pass


def EA_DataAccSetBool(
		acc       , # INTEGER -  
		valueIndex, # INTEGER -  
		value       # BOOLEAN -  
		):
	'''
		Python: vs.EA_DataAccSetBool(acc, valueIndex, value)
		VectorScript: PROCEDURE EA_DataAccSetBool(acc:INTEGER; valueIndex:INTEGER; value:BOOLEAN);
		
		Category: EnergyAnalysis Interface Library
		Set boolean value to the object, associated to the accessory index.
	'''
	pass


def EA_DataAccSetInt(
		acc       , # INTEGER -  
		valueIndex, # INTEGER -  
		value       # INTEGER -  
		):
	'''
		Python: vs.EA_DataAccSetInt(acc, valueIndex, value)
		VectorScript: PROCEDURE EA_DataAccSetInt(acc:INTEGER; valueIndex:INTEGER; value:INTEGER);
		
		Category: EnergyAnalysis Interface Library
		Set integer value to the object, associated to the accessory index.
	'''
	pass


def EA_DataAccSetReal(
		acc       , # INTEGER -  
		valueIndex, # INTEGER -  
		value       # REAL    -  
		):
	'''
		Python: vs.EA_DataAccSetReal(acc, valueIndex, value)
		VectorScript: PROCEDURE EA_DataAccSetReal(acc:INTEGER; valueIndex:INTEGER; value:REAL);
		
		Category: EnergyAnalysis Interface Library
		Set real value to the object, associated to the accessory index.
	'''
	pass


def EA_DataAccSetStr(
		acc       , # INTEGER -  
		valueIndex, # INTEGER -  
		value       # STRING  -  
		):
	'''
		Python: vs.EA_DataAccSetStr(acc, valueIndex, value)
		VectorScript: PROCEDURE EA_DataAccSetStr(acc:INTEGER; valueIndex:INTEGER; value:STRING);
		
		Category: EnergyAnalysis Interface Library
		Set string value to the object, associated to the accessory index.
	'''
	pass


def EA_GetUnitStr(
		unitType  # INTEGER -  
		):
	'''
		Python: STRING = vs.EA_GetUnitStr(unitType)
		VectorScript: FUNCTION EA_GetUnitStr(unitType:INTEGER) : STRING;
		
		Category: EnergyAnalysis Interface Library
		Returns document unit string.
	'''
	pass
	return 'STRING' # 


def EA_IsUsedUValue():
	'''
		Python: BOOLEAN = vs.EA_IsUsedUValue()
		VectorScript: FUNCTION EA_IsUsedUValue : BOOLEAN;
		
		Category: EnergyAnalysis Interface Library
		Returns TRUE if U-Value is used. If R-value is used returns FALSE.
	'''
	pass
	return 'BOOLEAN' # 


def EA_UValueText(
		UValue  # BOOLEAN -  
		):
	'''
		Python: STRING = vs.EA_UValueText(UValue)
		VectorScript: FUNCTION EA_UValueText(UValue:BOOLEAN) : STRING;
		
		Category: EnergyAnalysis Interface Library
		Returns U-Value or R-Value text depending on document settings.
	'''
	pass
	return 'STRING' # 


def EditCriteriaWithUI(
		criteria  # in/out DYNARRAY[] of CHAR - Pass in a criteria to be edited, and output the modified criteria if the function result is TRUE.
		):
	'''
		Python: (INTEGER, criteria) = vs.EditCriteriaWithUI(criteria)
		VectorScript: FUNCTION EditCriteriaWithUI(VAR criteria:DYNARRAY of CHAR) : INTEGER;
		
		Category: Utility
		Edit a criteria string with Edit Criteria Dialog.
	'''
	pass
	return ( 0       , # The funtion returns the following values:[[BR]]0 - failed. The input criteria is incorrect.[[BR]]1 - The edit was OK[[BR]]2 - The edit was Cancel[[BR]]
	         'string' )


def EditGeorefWithUI(
		hLayer  # HANDLE -  
		):
	'''
		Python: BOOLEAN = vs.EditGeorefWithUI(hLayer)
		VectorScript: FUNCTION EditGeorefWithUI(hLayer:HANDLE) : BOOLEAN;
		
		Category: GIS
		Edit the georeferenced settings of the specified layer. Pass NIL to edit the document.
	'''
	pass
	return 'BOOLEAN' # 


def EditObjectSpecial(
		h       , # HANDLE  - The object to edit.                                                  
		editMode  # INTEGER - The edit mode: 0-Default; 2-Properties; 3-Reshape; 4-Edit group like;
		):
	'''
		Python: vs.EditObjectSpecial(h, editMode)
		VectorScript: PROCEDURE EditObjectSpecial(h:HANDLE; editMode:INTEGER);
		
		Category: Object Editing
		Edit the specified object.
	'''
	pass


def EditOpenGLPrefs(
		):
	'''
		Python: updateRendering = vs.EditOpenGLPrefs()
		VectorScript: PROCEDURE EditOpenGLPrefs(VAR updateRendering:BOOLEAN);
		
		Category: View / Zoom
		Allows the user to edit OpenGL renderer preferences and stores them in the current drawing.
	'''
	pass
	return ( False )


def EditProperties(
		c  # CRITERIA - Search criteria.
		):
	'''
		Python: vs.EditProperties(c)
		VectorScript: PROCEDURE EditProperties(c:CRITERIA);
		
		Category: Criteria
		Displays the 'Properties' dialog for all objects matching the specified search criteria
	'''
	pass


def EditRenderWorksPrefs(
		):
	'''
		Python: updateRendering = vs.EditRenderWorksPrefs()
		VectorScript: PROCEDURE EditRenderWorksPrefs(VAR updateRendering:BOOLEAN);
		
		Category: View / Zoom
		Allows the user to edit RenderWorks renderer preferences and stores them in the current drawing.
	'''
	pass
	return ( False )


def EditShaderRecord(
		shaderRecord  # HANDLE - The shader record to edit.
		):
	'''
		Python: BOOLEAN = vs.EditShaderRecord(shaderRecord)
		VectorScript: FUNCTION EditShaderRecord(shaderRecord:HANDLE) : BOOLEAN;
		
		Category: Textures
		Brings up the edit shader dialog for this shader.  Returns true if the user pressed the OK button to dismiss the dialog.
	'''
	pass
	return 'BOOLEAN' # 


def EditTexture(
		texture  # HANDLE - Handle to texture.
		):
	'''
		Python: BOOLEAN = vs.EditTexture(texture)
		VectorScript: FUNCTION EditTexture(texture:HANDLE) : BOOLEAN;
		
		Category: Textures
		Function EditTexture opens the Edit Texture dialog for the referenced texture.
	'''
	pass
	return 'BOOLEAN' # 


def EditTextureBitmap(
		textureBitmap  # HANDLE - Handle to texture bitmap.
		):
	'''
		Python: BOOLEAN = vs.EditTextureBitmap(textureBitmap)
		VectorScript: FUNCTION EditTextureBitmap(textureBitmap:HANDLE) : BOOLEAN;
		
		Category: Textures
		Function EditTextureBitmap opens the Edit Texture Bitmap dialog box to the referenced texture bitmap.  The function returns TRUE if texture bitmap was modified.
	'''
	pass
	return 'BOOLEAN' # 


def EditTextureSpace(
		obj   , # HANDLE  - Handle to object.                           
		partID  # INTEGER - Part ID (pass 1 for non-supporting objects).
		):
	'''
		Python: BOOLEAN = vs.EditTextureSpace(obj, partID)
		VectorScript: FUNCTION EditTextureSpace(obj:HANDLE; partID:INTEGER) : BOOLEAN;
		
		Category: Textures
		Function EditTextureSpace edits the mapping of a specified texture space for the referenced object. Calling this function opens the Edit Mapping dialog for textures.
	'''
	pass
	return 'BOOLEAN' # Returns TRUE if the texture space was modified.


def EllipseEllipseIntersect(
		upperLeft1 , # POINT - Upper-left point of the first ellipse  
		lowerRight1, # POINT - Lower-right point of the first ellipse 
		upperLeft2 , # POINT - Upper-left point of the second ellipse 
		lowerRight2  # POINT - Lower-right point of the second ellipse
		):
	'''
		Python: (INTEGER, int1, int2, int3, int4) = vs.EllipseEllipseIntersect(upperLeft1, lowerRight1, upperLeft2, lowerRight2)
		VectorScript: FUNCTION EllipseEllipseIntersect(upperLeft1:REAL; lowerRight1:REAL; upperLeft2:REAL; lowerRight2:REAL; VAR int1:REAL; VAR int2:REAL; VAR int3:REAL; VAR int4:REAL) : INTEGER;
		
		Category: Graphic Calculation
		Calculates the intersections between the two specified ellipses.
	'''
	pass
	return ( 0      , # Returns the number of valid intersection points.  If the return value is n, the first n points are valid.  For example, if the return value is 1, the int1 parameter contains a valid point of intersection, and int2, int3, and int4 are invalid.  If the return value is 3, int1, int2, and int3 contain valid points, and int4 is invalid.
	         0,0    , 
	         0,0    , 
	         0,0    , 
	         0,0     )


def EnableCLDropShadow(
		clasName , # STRING  -  
		enable     # BOOLEAN -  
		):
	'''
		Python: vs.EnableCLDropShadow(className, enable)
		VectorScript: PROCEDURE EnableCLDropShadow(className:STRING; enable:BOOLEAN);
		
		Category: Classes
	'''
	pass


def EnableDefDropShadow(
		bEnable  # BOOLEAN -  
		):
	'''
		Python: vs.EnableDefDropShadow(bEnable)
		VectorScript: PROCEDURE EnableDefDropShadow(bEnable:BOOLEAN);
		
		Category: Document Attributes
	'''
	pass


def EnableDrawingWorksheetPalette(
		enable   , # BOOLEAN - Specifies if worksheet palettes' drawing  should be enabled or disabled.                                                                       
		worksheet  # HANDLE  - Handle to specific worksheet for which to enable/disable drawing;  Set it to nil to enable/disable drawing in all displayed worksheet palettes.
		):
	'''
		Python: vs.EnableDrawingWorksheetPalette(enable, worksheet)
		VectorScript: PROCEDURE EnableDrawingWorksheetPalette(enable:BOOLEAN; worksheet:HANDLE);
		
		Category: Worksheets
		Enables/disables drawing for the specified worksheet or all displayed worksheet palettes if worksheet is nil.
		To improve speed and avoid flickering, it is highly recommended to disable drawing in worksheet palettes before performing several write operations in an opened worksheet.
		Enable drawing back when the operations are completed.
	'''
	pass


def EnableDropShadow(
		h     , # HANDLE  -  
		enable  # BOOLEAN -  
		):
	'''
		Python: vs.EnableDropShadow(h, enable)
		VectorScript: PROCEDURE EnableDropShadow(h:HANDLE; enable:BOOLEAN);
		
		Category: Object Attributes
	'''
	pass


def EnableItem(
		dialogID   , # LONGINT - the dialog identifier given by CreateLayout or CreateResizableLayout 
		componentID, # LONGINT - The identifier of the component to enable or disable given the state.
		enableState  # BOOLEAN - True if the component should be enabled, false otherwise.            
		):
	'''
		Python: vs.EnableItem(dialogID, componentID, enableState)
		VectorScript: PROCEDURE EnableItem(dialogID:LONGINT; componentID:LONGINT; enableState:BOOLEAN);
		
		Category: Dialogs - Modern
		Sets the enable state of a dialog item.
	'''
	pass


def EnableLB(
		dialogID   , # LONGINT - id of the dialog that contains the list browser              
		componentID, # LONGINT - id of the list browser control                               
		enable       # BOOLEAN - determines if the list browser should be enabled or disabled.
		):
	'''
		Python: BOOLEAN = vs.EnableLB(dialogID, componentID, enable)
		VectorScript: FUNCTION EnableLB(dialogID:LONGINT; componentID:LONGINT; enable:BOOLEAN) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Enables or disables the specified list browser.
	'''
	pass
	return 'BOOLEAN' # 


def EnableLBClickAllDataChange(
		dialogID   , # LONGINT - id of the dialog that contains the list browser                                                            
		componentID, # LONGINT - id of the list browser control                                                                             
		enable       # BOOLEAN - determines if all data items should be changed during the click if the appropriate modifier key is pressed.
		):
	'''
		Python: BOOLEAN = vs.EnableLBClickAllDataChange(dialogID, componentID, enable)
		VectorScript: FUNCTION EnableLBClickAllDataChange(dialogID:LONGINT; componentID:LONGINT; enable:BOOLEAN) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Enables all radio and multi state column data items to be changed with a single click if the alt key or option key is pressed during the click.
	'''
	pass
	return 'BOOLEAN' # 


def EnableLBColumnLines(
		dialogID         , # LONGINT - id of the dialog that contains the list browser
		componentID      , # LONGINT - id of the list browser control                 
		enableColumnLines  # BOOLEAN - specifies if column lines should be drawn      
		):
	'''
		Python: vs.EnableLBColumnLines(dialogID, componentID, enableColumnLines)
		VectorScript: PROCEDURE EnableLBColumnLines(dialogID:LONGINT; componentID:LONGINT; enableColumnLines:BOOLEAN);
		
		Category: Dialogs - Modern - Browser
		Enables/disables column lines.
	'''
	pass


def EnableLBColumnTracking(
		dialogID            , # LONGINT - id of the dialog that contains the list browser           
		componentID         , # LONGINT - id of the list browser control                            
		columnIndex         , # INTEGER - the index of the column                                   
		enableColumnTracking  # BOOLEAN - specifies if column tracking should be enabled or disabled
		):
	'''
		Python: vs.EnableLBColumnTracking(dialogID, componentID, columnIndex, enableColumnTracking)
		VectorScript: PROCEDURE EnableLBColumnTracking(dialogID:LONGINT; componentID:LONGINT; columnIndex:INTEGER; enableColumnTracking:BOOLEAN);
		
		Category: Dialogs - Modern - Browser
		Enables/disables column tracking.
	'''
	pass


def EnableLBDragAndDrop(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID, # LONGINT - id of the list browser control                 
		enable       # BOOLEAN - determines if drag and drop should be enabled  
		):
	'''
		Python: BOOLEAN = vs.EnableLBDragAndDrop(dialogID, componentID, enable)
		VectorScript: FUNCTION EnableLBDragAndDrop(dialogID:LONGINT; componentID:LONGINT; enable:BOOLEAN) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Enables list browser drag and drop.  Use SetLBDragDropColumn to set the drag and drop column.
	'''
	pass
	return 'BOOLEAN' # 


def EnableLBDropOnIndices(
		dialogID   , # LONGINT -  
		componentID, # LONGINT -  
		iStartIndex, # INTEGER -  
		iEndIndex  , # INTEGER -  
		bEnable      # BOOLEAN -  
		):
	'''
		Python: BOOLEAN = vs.EnableLBDropOnIndices(dialogID, componentID, iStartIndex, iEndIndex, bEnable)
		VectorScript: FUNCTION EnableLBDropOnIndices(dialogID:LONGINT; componentID:LONGINT; iStartIndex:INTEGER; iEndIndex:INTEGER; bEnable:BOOLEAN) : BOOLEAN;
		
		Category: Dialogs - Modern
		Enables or disables drag and drop to occur within the specified indices.
	'''
	pass
	return 'BOOLEAN' # 


def EnableLBHierDisplay(
		dialogID         , # LONGINT - The id of the dialog containing the list browser.          
		componentID      , # LONGINT - The id of the list browser.                                
		enableHierDisplay  # BOOLEAN - Whether to enable hierarchical display in the list browser.
		):
	'''
		Python: vs.EnableLBHierDisplay(dialogID, componentID, enableHierDisplay)
		VectorScript: PROCEDURE EnableLBHierDisplay(dialogID:LONGINT; componentID:LONGINT; enableHierDisplay:BOOLEAN);
		
		Category: Dialogs - Modern - Browser
		This function enables/disables the list browser to display items hierarchically. Calling this along will not change the display. The hierarchical display column must be set.
	'''
	pass


def EnableLBRadioColumnLines(
		dialogID              , # LONGINT - id of the dialog that contains the list browser       
		componentID           , # LONGINT - id of the list browser control                        
		columnIndex           , # INTEGER - the index of the column                               
		enableRadioColumnLines  # BOOLEAN - specifies if radio item "column" lines should be drawn
		):
	'''
		Python: vs.EnableLBRadioColumnLines(dialogID, componentID, columnIndex, enableRadioColumnLines)
		VectorScript: PROCEDURE EnableLBRadioColumnLines(dialogID:LONGINT; componentID:LONGINT; columnIndex:INTEGER; enableRadioColumnLines:BOOLEAN);
		
		Category: Dialogs - Modern - Browser
		Enables/disables radio item "column" lines.
	'''
	pass


def EnableLBSingleLineSelection(
		dialogID   , # LONGINT - id of the dialog that contains the list browser            
		componentID, # LONGINT - id of the list browser control                             
		enable       # BOOLEAN - determines if single line selection only should be enabled.
		):
	'''
		Python: BOOLEAN = vs.EnableLBSingleLineSelection(dialogID, componentID, enable)
		VectorScript: FUNCTION EnableLBSingleLineSelection(dialogID:LONGINT; componentID:LONGINT; enable:BOOLEAN) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Enables single line only selection.  Multiple selections will not be permitted.
	'''
	pass
	return 'BOOLEAN' # 


def EnableLBSorting(
		dialogID     , # LONGINT - id of the dialog that contains the list browser
		componentID  , # LONGINT - id of the list browser control                 
		enableSorting  # BOOLEAN - specifies whether to enable or disable sorting 
		):
	'''
		Python: vs.EnableLBSorting(dialogID, componentID, enableSorting)
		VectorScript: PROCEDURE EnableLBSorting(dialogID:LONGINT; componentID:LONGINT; enableSorting:BOOLEAN);
		
		Category: Dialogs - Modern - Browser
		Enables/disables sorting.
	'''
	pass


def EnableLBUpdates(
		liDialogID    , # LONGINT -  
		liComponentID , # LONGINT -  
		bEnableUpdates  # BOOLEAN -  
		):
	'''
		Python: vs.EnableLBUpdates(liDialogID, liComponentID, bEnableUpdates)
		VectorScript: PROCEDURE EnableLBUpdates(liDialogID:LONGINT; liComponentID:LONGINT; bEnableUpdates:BOOLEAN);
		
		Category: Dialogs - Modern - Browser
		Determines if updates should be enabled for the specified list browser.
	'''
	pass


def EnableParameter(
		inPlugin       , # HANDLE  - Handle to the currently executing plug-in object.                       
		inParameterName, # STRING  - Name of parameter, as it appears in the plug-in editor's parameter list.
		inSetEnabled     # BOOLEAN - Enabling flag.                                                          
		):
	'''
		Python: vs.EnableParameter(inPlugin, inParameterName, inSetEnabled)
		VectorScript: PROCEDURE EnableParameter(inPlugin:HANDLE; inParameterName:STRING; inSetEnabled:BOOLEAN);
		
		Category: Objects - Custom
		For plug-in objects, this procedure sets whether or not the specified parameter is enabled on the Object Info Palette.  This routine is used inside plug-in object regeneration scripts to set their parameter enable state.  This state is an object instance property.
	'''
	pass


def EnableTextEdit(
		dialogID     , # LONGINT - the dialog identifier given by CreateLayout or CreateResizableLayout
		componentID  , # LONGINT - The identifier of the text component.                               
		editableState  # BOOLEAN - True if this text component should be editable, false otherwise.    
		):
	'''
		Python: vs.EnableTextEdit(dialogID, componentID, editableState)
		VectorScript: PROCEDURE EnableTextEdit(dialogID:LONGINT; componentID:LONGINT; editableState:BOOLEAN);
		
		Category: Dialogs - Modern
		Enables text editing for the given component.
	'''
	pass


def EndContext(
		acceptOrReject  # INTEGER - Specify 0 to reject changes or 1 to accept changes 
		):
	'''
		Python: vs.EndContext(acceptOrReject)
		VectorScript: PROCEDURE EndContext(acceptOrReject:INTEGER);
		
		Category: Utility
		Use this function in conjuction with BeginContext to have VW automatically accept or reject any changes that were made during the Begin/End block.
	'''
	pass


def EndFolder():
	'''
		Python: vs.EndFolder()
		VectorScript: PROCEDURE EndFolder;
		
		Category: Document List Handling
		Procedure EndFolder completes symbol folder creation in VectorScript. When EndFolder is called, the any procedure calls defined since a call to BeginFolder are used to create symbols and/or symbol folders.
	'''
	pass


def EndGroup():
	'''
		Python: vs.EndGroup()
		VectorScript: PROCEDURE EndGroup;
		
		Category: Objects - Groups
		Procedure EndGroup completes the creation of a new group object in a Vectorworks document. The new group object is then generated in the document.
	'''
	pass


def EndMesh():
	'''
		Python: vs.EndMesh()
		VectorScript: PROCEDURE EndMesh;
		
		Category: Objects - 3D
		Procedure EndMesh completes the definition of a mesh object within a Vectorworks document. On calling EndMesh, the mesh is created in the document from the preceding object creation calls.
		It is recommended to call ResetOrientation3D after 3D object creations in order to ensure that the new 3D objects will draw properly.
	'''
	pass


def EndModeButtonsText():
	'''
		Python: vs.EndModeButtonsText()
		VectorScript: PROCEDURE EndModeButtonsText;
		
		Category: User Interactive
		Ends the creation of a mode bar buttons help text.
	'''
	pass


def EndMultDashConvert():
	'''
		Python: vs.EndMultDashConvert()
		VectorScript: PROCEDURE EndMultDashConvert;
		
		Category: Utility
		Used in conjunction with BeginMultDashConvert to end the set of conversions.
	'''
	pass


def EndMultipleDuplicate():
	'''
		Python: vs.EndMultipleDuplicate()
		VectorScript: PROCEDURE EndMultipleDuplicate;
		
		Category: Object Editing
		Use this function in conjunction with BeginMultipleDuplicate to preserve constraints on duplicated objects.
	'''
	pass


def EndMXtrd():
	'''
		Python: vs.EndMXtrd()
		VectorScript: PROCEDURE EndMXtrd;
		
		Category: Objects - 3D
		Procedure EndMXtrd completes the definition of a multiple extrude object within a Vectorworks document. On calling EndMXtrd, the object is created in the document from the preceding object creation calls.
		It is recommended to call ResetOrientation3D after 3D object creations in order to ensure that the new 3D objects will draw properly.
	'''
	pass


def EndPoly():
	'''
		Python: vs.EndPoly()
		VectorScript: PROCEDURE EndPoly;
		
		Category: Objects - Polys
		Procedure EndPoly completes the definition of a polygon or polyline object within a Vectorworks document. On calling EndPoly, the object is created in the document from the preceding vertex creation calls.
	'''
	pass


def EndPoly3D():
	'''
		Python: vs.EndPoly3D()
		VectorScript: PROCEDURE EndPoly3D;
		
		Category: Objects - 3D
		Procedure EndPoly3D completes the definition of a multiple extrude object within a Vectorworks document. On calling EndPoly3D, the object is created in the document from the preceding object creation calls.
		It is recommended to call ResetOrientation3D after 3D object creations in order to ensure that the new 3D objects will draw properly.
	'''
	pass


def EndSweep():
	'''
		Python: vs.EndSweep()
		VectorScript: PROCEDURE EndSweep;
		
		Category: Objects - 3D
		Procedure EndSweep completes the definition of a sweep object within a Vectorworks document. On calling EndSweep, the object is created in the document from the preceding object creation calls.
		It is recommended to call ResetOrientation3D after 3D object creations in order to ensure that the new 3D objects will draw properly.
	'''
	pass


def EndSym():
	'''
		Python: vs.EndSym()
		VectorScript: PROCEDURE EndSym;
		
		Category: Objects - Symbols
		Procedure EndSym completes symbol creation in VectorScript. When EndSym is called, the any procedure calls defined since a call to BeginSym are used to create the symbol.
	'''
	pass


def EndVectorFill():
	'''
		Python: vs.EndVectorFill()
		VectorScript: PROCEDURE EndVectorFill;
		
		Category: Hatches / Vector Fills
		Procedure EndVectorFill ends the vector fill creation process. This procedure call must follow the BeginVectorFillN call and a variable number of AddVectorFillLayer calls.
	'''
	pass


def EndXtrd():
	'''
		Python: vs.EndXtrd()
		VectorScript: PROCEDURE EndXtrd;
		
		Category: Objects - 3D
		Procedure EndXtrd completes the definition of an extrude object within a Vectorworks document. On calling EndXtrd, the object is created in the document from the preceding object creation calls.
		It is recommended to call ResetOrientation3D after 3D object creations in order to ensure that the new 3D objects will draw properly.
	'''
	pass


def EnsureLBItemIsVisible(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID, # LONGINT - id of the list browser control                 
		index        # INTEGER - the row index                                  
		):
	'''
		Python: BOOLEAN = vs.EnsureLBItemIsVisible(dialogID, componentID, index)
		VectorScript: FUNCTION EnsureLBItemIsVisible(dialogID:LONGINT; componentID:LONGINT; index:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Ensures the element at the given row index is visible in the specified list browser.
	'''
	pass
	return 'BOOLEAN' # 


def EOF(
		fileName  # DYNARRAY[] of CHAR - Name of file.
		):
	'''
		Python: BOOLEAN = vs.EOF(fileName)
		VectorScript: FUNCTION EOF(fileName:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: File I/O
		Function EOF returns TRUE if the file pointer of an open text file has reached the end of the file (EOF marker). Function EOF is used with Procedures Read and ReadLn to ensure proper file reading and closure. Parameter fileName specifies a text file which is open for reading or writing.
	'''
	pass
	return 'BOOLEAN' # 


def EOLN(
		fileName  # DYNARRAY[] of CHAR - Name of file.
		):
	'''
		Python: BOOLEAN = vs.EOLN(fileName)
		VectorScript: FUNCTION EOLN(fileName:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: File I/O
		Function EOLN returns TRUE if the file pointer of an open text file has reached a carriage return within the file. Parameter fileName specifies a text file which is open for reading or writing.
	'''
	pass
	return 'BOOLEAN' # 


def Eq(
		value1   , # REAL -  
		value2   , # REAL -  
		tolerance  # REAL -  
		):
	'''
		Python: BOOLEAN = vs.Eq(value1, value2, tolerance)
		VectorScript: FUNCTION Eq(value1:REAL; value2:REAL; tolerance:REAL) : BOOLEAN;
		
		Category: Graphic Calculation
		Returns TRUE if the two real numbers are equal within the tolerance.
	'''
	pass
	return 'BOOLEAN' # 


def EqPercent(
		value1 , # REAL -  
		value2 , # REAL -  
		percent  # REAL -  
		):
	'''
		Python: BOOLEAN = vs.EqPercent(value1, value2, percent)
		VectorScript: FUNCTION EqPercent(value1:REAL; value2:REAL; percent:REAL) : BOOLEAN;
		
		Category: Graphic Calculation
		Returns TRUE if num1 and num2 are equal within the given percent.
	'''
	pass
	return 'BOOLEAN' # 


def EqPt(
		pt1      , # VECTOR -  
		pt2      , # VECTOR -  
		tolerance  # REAL   -  
		):
	'''
		Python: BOOLEAN = vs.EqPt(pt1, pt2, tolerance)
		VectorScript: FUNCTION EqPt(pt1:VECTOR; pt2:VECTOR; tolerance:REAL) : BOOLEAN;
		
		Category: Graphic Calculation
		Returns TRUE if the 2D points are equal within the tolerance.
	'''
	pass
	return 'BOOLEAN' # 


def EqPt2D(
		pt1      , # VECTOR -  
		pt2      , # VECTOR -  
		tolerance  # REAL   -  
		):
	'''
		Python: BOOLEAN = vs.EqPt2D(pt1, pt2, tolerance)
		VectorScript: FUNCTION EqPt2D(pt1:VECTOR; pt2:VECTOR; tolerance:REAL) : BOOLEAN;
		
		Category: Graphic Calculation
		Returns TRUE if the 2D points are equal within the tolerance
	'''
	pass
	return 'BOOLEAN' # 


def EqPt3D(
		pt1      , # VECTOR -  
		pt2      , # VECTOR -  
		tolerance  # REAL   -  
		):
	'''
		Python: BOOLEAN = vs.EqPt3D(pt1, pt2, tolerance)
		VectorScript: FUNCTION EqPt3D(pt1:VECTOR; pt2:VECTOR; tolerance:REAL) : BOOLEAN;
		
		Category: Graphic Calculation
		Returns TRUE if the 3D points are equal within the tolerance.
	'''
	pass
	return 'BOOLEAN' # 


def EqualPt(
		p1, # POINT - Coordinates of first comparison point. 
		p2  # POINT - Coordinates of second comparison point.
		):
	'''
		Python: BOOLEAN = vs.EqualPt(p1, p2)
		VectorScript: FUNCTION EqualPt(p1X, p1Y:REAL; p2X, p2Y:REAL) : BOOLEAN;
		
		Category: Graphic Calculation
		Function EqualPt returns whether the two specified coordinate locations are equal (i.e., the same point, to 12 significant digits).
	'''
	pass
	return 'BOOLEAN' # 


def EqualRect(
		rectAp1, # POINT - Top left coordinate of rectangle A.    
		rectAp2, # POINT - Bottom right coordinate of rectangle A.
		rectBp1, # POINT - Top left coordinate of rectangle B.    
		rectBp2  # POINT - Bottom right coordinate of rectangle B.
		):
	'''
		Python: BOOLEAN = vs.EqualRect(rectAp1, rectAp2, rectBp1, rectBp2)
		VectorScript: FUNCTION EqualRect(rectAp1X, rectAp1Y:REAL; rectAp2X, rectAp2Y:REAL; rectBp1X, rectBp1Y:REAL; rectBp2X, rectBp2Y:REAL) : BOOLEAN;
		
		Category: Graphic Calculation
		Function EqualRect returns whether the two specified rectangular areas are equal.
	'''
	pass
	return 'BOOLEAN' # 


def Eval(
		h, # HANDLE   - Handle of object to which the search criteria will be applied.
		c  # CRITERIA - Search criteria.                                              
		):
	'''
		Python: REAL = vs.Eval(h, c)
		VectorScript: FUNCTION Eval(h:HANDLE; c:CRITERIA) : REAL;
		
		Category: Criteria
		Evaluates whether an object meets the specified search criteria.
		When used with record criteria, it will determine whether a specific record is attached to the object; if used with record-field criteria, it will return the value of the field as a REAL value.
	'''
	pass
	return 'REAL' # If the criteria is a record-field criteria, the procedure will return the value contained within the field. All other criteria return the TRUE-FALSE state of the criteria condition. 


def EvalStr(
		h, # HANDLE   - Handle of object to which the search criteria will be applied.
		c  # CRITERIA - Search criteria.                                              
		):
	'''
		Python: STRING = vs.EvalStr(h, c)
		VectorScript: FUNCTION EvalStr(h:HANDLE; c:CRITERIA) : STRING;
		
		Category: Criteria
		Evaluates whether an object meets the specified search criteria.
		When used with record criteria, it will determine whether a specific record is attached to the object; if used with record-field criteria, it will return the value of the field as a STRING.
	'''
	pass
	return 'STRING' # If the criteria is a record-field criteria, the procedure will return the value contained within the field. All other criteria return the TRUE-FALSE state of the criteria condition.


def EvaluateNurbsSurfacePointAndNormal(
		surfaceHandle, # HANDLE - Handle to NURBS surface being evaluated                    
		u            , # REAL   - parameter value of the point on the surface being evaluated
		v              # REAL   - parameter value of the point on the surface being evaluated
		):
	'''
		Python: (BOOLEAN, point, normal) = vs.EvaluateNurbsSurfacePointAndNormal(surfaceHandle, u, v)
		VectorScript: FUNCTION EvaluateNurbsSurfacePointAndNormal(surfaceHandle:HANDLE; u:REAL; v:REAL; VAR pointX, pointY, pointZ:REAL; VAR normalX, normalY, normalZ:REAL) : BOOLEAN;
		
		Category: Objects - NURBS
		Determines the point and normal on the NURBS surface at the given u/v value.
	'''
	pass
	return ( False  , # 
	         0,0,0  , 
	         0,0,0   )


def Exp(
		v  # REAL -  
		):
	'''
		Python: REAL = vs.Exp(v)
		VectorScript: FUNCTION Exp(v:REAL) : REAL;
		
		Category: Math - General
		Function Exp returns the value of e to the x, where e is the base of the natural logarithms and x is the specified value.
	'''
	pass
	return 'REAL' # 


def ExpandAllLBItems(
		dialogID   , # LONGINT - The id of the dialog.      
		componentID  # LONGINT - The id of the list browser.
		):
	'''
		Python: vs.ExpandAllLBItems(dialogID, componentID)
		VectorScript: PROCEDURE ExpandAllLBItems(dialogID:LONGINT; componentID:LONGINT);
		
		Category: Dialogs - Modern - Browser
		This function is called when a list browser is in hierarchical display mode, and it redisplays all items that were hidden and opens all the containers.
	'''
	pass


def ExpandTreeControlItem(
		nDialogID   , # LONGINT -  
		nComponentID, # LONGINT -  
		nItemID     , # INTEGER -  
		bExpand       # BOOLEAN -  
		):
	'''
		Python: vs.ExpandTreeControlItem(nDialogID, nComponentID, nItemID, bExpand)
		VectorScript: PROCEDURE ExpandTreeControlItem(nDialogID:LONGINT; nComponentID:LONGINT; nItemID:INTEGER; bExpand:BOOLEAN);
		
		Category: Dialogs - Modern
		Expands or collapses the specified tree control item.
	'''
	pass


def ExportDXFDWG():
	'''
		Python: vs.ExportDXFDWG()
		VectorScript: PROCEDURE ExportDXFDWG;
		
		Category: ImportExport
		Export DXF/DWG
	'''
	pass


def ExportIGES(
		fileName            , # DYNARRAY[] of CHAR - Output file path.               
		exportSolidAsSurface  # BOOLEAN            - Export solit objects as surface.
		):
	'''
		Python: BOOLEAN = vs.ExportIGES(fileName, exportSolidAsSurface)
		VectorScript: FUNCTION ExportIGES(fileName:DYNARRAY of CHAR; exportSolidAsSurface:BOOLEAN) : BOOLEAN;
		
		Category: File I/O
		Export the document in 3D IGES file.
	'''
	pass
	return 'BOOLEAN' # Return TRUE if succeeded.


def ExportImageFile(
		hHmage  , # HANDLE             - The handle of the image object to be exported.
		filePath  # DYNARRAY[] of CHAR - Full path to the output image file.           
		):
	'''
		Python: BOOLEAN = vs.ExportImageFile(hHmage, filePath)
		VectorScript: FUNCTION ExportImageFile(hHmage:HANDLE; filePath:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: Utility
		Export the specified Image object in Vectorworks as an image file.
	'''
	pass
	return 'BOOLEAN' # 


def ExportPDFPages(
		savedViewNameStr  # DYNARRAY[] of CHAR -  
		):
	'''
		Python: INTEGER = vs.ExportPDFPages(savedViewNameStr)
		VectorScript: FUNCTION ExportPDFPages(savedViewNameStr:DYNARRAY of CHAR) : INTEGER;
		
		Category: Command
		This will export the current document to PDF.  You must call OpenPDFDocument before calling this function.  This is intended to support Batch Export to PDF.
	'''
	pass
	return 'INTEGER' # 


def ExportSAT(
		filePath      , # DYNARRAY[] of CHAR - Output file path.
		solidAsSurface  # BOOLEAN            -                  
		):
	'''
		Python: BOOLEAN = vs.ExportSAT(filePath, solidAsSurface)
		VectorScript: FUNCTION ExportSAT(filePath:DYNARRAY of CHAR; solidAsSurface:BOOLEAN) : BOOLEAN;
		
		Category: File I/O
		Export the selection into a SAT file.
	'''
	pass
	return 'BOOLEAN' # Return TRUE if successful.


def ExportSTEP(
		filePath              , # DYNARRAY[] of CHAR -  
		exportSolidsAsSurfaces  # BOOLEAN            -  
		):
	'''
		Python: BOOLEAN = vs.ExportSTEP(filePath, exportSolidsAsSurfaces)
		VectorScript: FUNCTION ExportSTEP(filePath:DYNARRAY of CHAR; exportSolidsAsSurfaces:BOOLEAN) : BOOLEAN;
		
		Category: File I/O
	'''
	pass
	return 'BOOLEAN' # Return TRUE if successful


def ExportSTL(
		filePath            , # DYNARRAY[] of CHAR - Output file path.                                                                                                        
		exportBinary        , # BOOLEAN            - binary or ASCII output                                                                                                   
		percentTess         , # REAL               - tessellation resolution -- from 0 to 100  0 -- low, 100 --high                                                           
		exportObjectsOptions  # INTEGER            - 0 -- export visilble objects selected 1 -- export visible objects in activeLayer 2 -- export visible objects in all Layer
		):
	'''
		Python: BOOLEAN = vs.ExportSTL(filePath, exportBinary, percentTess, exportObjectsOptions)
		VectorScript: FUNCTION ExportSTL(filePath:DYNARRAY of CHAR; exportBinary:BOOLEAN; percentTess:REAL; exportObjectsOptions:INTEGER) : BOOLEAN;
		
		Category: File I/O
		Export the objects into a STL file.
	'''
	pass
	return 'BOOLEAN' # Return TRUE if successful.


def ExtendNurbsCurve(
		curveHandle, # HANDLE  - Handle to a NURBS curve                                                    
		distance   , # REAL    - Distance to extend the curve                                               
		bStart     , # BOOLEAN - True to extend the curve at the beginning, false to extend it at the end.  
		bLinear      # BOOLEAN - True for linear, false to match curvature of existing end.                 
		):
	'''
		Python: HANDLE = vs.ExtendNurbsCurve(curveHandle, distance, bStart, bLinear)
		VectorScript: FUNCTION ExtendNurbsCurve(curveHandle:HANDLE; distance:REAL; bStart:BOOLEAN; bLinear:BOOLEAN) : HANDLE;
		
		Category: Objects - NURBS
		Extends a curve by a given distance at the start or the end.  The extension can either be linear or can match the curvature of the existing end.
	'''
	pass
	return 'HANDLE' # Returns a handle to the extended curve. 


def ExtendNurbsSurface(
		surfaceHandle, # HANDLE  - Handle to a NURBS surface.                                                                                      
		distance     , # REAL    - Distance to extend the surface.                                                                                 
		bStart       , # BOOLEAN - True to extend from the beginning, false to extend from the end.                                                
		bLinear      , # BOOLEAN - True for linear, false to match curvature of existing surface.                                                  
		bUDir          # BOOLEAN - True extends the surface in the u parametric[[BR]]direction, otherwise extends it in the v parametric direction.
		):
	'''
		Python: HANDLE = vs.ExtendNurbsSurface(surfaceHandle, distance, bStart, bLinear, bUDir)
		VectorScript: FUNCTION ExtendNurbsSurface(surfaceHandle:HANDLE; distance:REAL; bStart:BOOLEAN; bLinear:BOOLEAN; bUDir:BOOLEAN) : HANDLE;
		
		Category: Objects - NURBS
		Extends a surface by a given distance at the start or the end of the U direction or V direction.
	'''
	pass
	return 'HANDLE' # Returns a handle to the extended surface


def ExtrudeAlongPath(
		pathHandle   , # HANDLE - Handle to the path object.   
		profileHandle  # HANDLE - Handle to the profile object.
		):
	'''
		Python: HANDLE = vs.ExtrudeAlongPath(pathHandle, profileHandle)
		VectorScript: FUNCTION ExtrudeAlongPath(pathHandle:HANDLE; profileHandle:HANDLE) : HANDLE;
		
		Category: Objects - 3D
		Creates a new path extrude object in the document.  The profile defines the shape of the cross-section, and is extruded along the path to generate the resulting object.
		The path argument must be a handle to a NURBS Curve object (type 111).  The profile argument must be a handle to an object of one of the following types: NURBS Curve, Polygon, Polyline, Arc, Rectangle, Rounded Rectangle, Line, Oval.
	'''
	pass
	return 'HANDLE' # Returns a generic solid HANDLE to the new path extrude if successful, otherwise returns NIL.[[BR]]


def FActLayer():
	'''
		Python: HANDLE = vs.FActLayer()
		VectorScript: FUNCTION FActLayer : HANDLE;
		
		Category: Document List Handling
		Function FActLayer returns a handle to the first object on the active layer. If the object does not exist, the function returns NIL.
	'''
	pass
	return 'HANDLE' # 


def FFillBack(
		):
	'''
		Python: (red, green, blue) = vs.FFillBack()
		VectorScript: PROCEDURE FFillBack(VAR red:LONGINT; VAR green:LONGINT; VAR blue:LONGINT);
		
		Category: Document Attributes
		Procedure FFillBack returns the current fill background color. RGB values are in the range of 0 65535.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def FFillColorByClass():
	'''
		Python: BOOLEAN = vs.FFillColorByClass()
		VectorScript: FUNCTION FFillColorByClass : BOOLEAN;
		
		Category: Document Attributes
		Function FFillColorByClass returns whether the global attributes are set to use the fill colors of the default class.
	'''
	pass
	return 'BOOLEAN' # 


def FFillFore(
		):
	'''
		Python: (red, green, blue) = vs.FFillFore()
		VectorScript: PROCEDURE FFillFore(VAR red:LONGINT; VAR green:LONGINT; VAR blue:LONGINT);
		
		Category: Document Attributes
		Procedure FFillFore returns the current fill foreground color. RGB values are in the range of 0 65535.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def FFillPat():
	'''
		Python: LONGINT = vs.FFillPat()
		VectorScript: FUNCTION FFillPat : LONGINT;
		
		Category: Document Attributes
		Function FFillPat returns the current fill pattern setting.
	'''
	pass
	return 'LONGINT' # 


def FFPatByClass():
	'''
		Python: BOOLEAN = vs.FFPatByClass()
		VectorScript: FUNCTION FFPatByClass : BOOLEAN;
		
		Category: Document Attributes
		Function FFPatByClass returns whether the global attributes are set to use the fill pattern of the default class.
	'''
	pass
	return 'BOOLEAN' # 


def Field(
		h , # HANDLE -  
		s1, # STRING -  
		s2, # STRING -  
		s3  # STRING -  
		):
	'''
		Python: vs.Field(h, s1, s2, s3)
		VectorScript: PROCEDURE Field(h:HANDLE; s1:STRING; s2:STRING; s3:STRING);
		
		Category: Database / Record
		Obsolete.
	'''
	pass


def FillBack(
		color  # COLOR - RGB color value to set as active fill background color.
		):
	'''
		Python: vs.FillBack(color)
		VectorScript: PROCEDURE FillBack(colorR, colorG, colorB:LONGINT);
		
		Category: Document Attributes
		Procedure FillBack sets the active fill background color setting for the document. RGB values are in the range of 0 65535.
	'''
	pass


def FillColorByClass():
	'''
		Python: vs.FillColorByClass()
		VectorScript: PROCEDURE FillColorByClass;
		
		Category: Classes
		Sets the default document fill colors to the fill colors of the active class.
	'''
	pass


def FillFore(
		color  # COLOR - RGB color value to set as active fill foreground color.
		):
	'''
		Python: vs.FillFore(color)
		VectorScript: PROCEDURE FillFore(colorR, colorG, colorB:LONGINT);
		
		Category: Document Attributes
		Procedure FillFore sets the active fill foreground color setting for the document. RGB values are in the range of 0 65535.
	'''
	pass


def FillPat(
		patNumber  # LONGINT - Index of fill pattern to be set as document default.
		):
	'''
		Python: vs.FillPat(patNumber)
		VectorScript: PROCEDURE FillPat(patNumber:LONGINT);
		
		Category: Document Attributes
		Procedure FillPat sets the active fill pattern for the document. Any objects created after a calling this procedure will use the specified fill pattern.
	'''
	pass


def FIn3D(
		objectHd  # HANDLE - Handle to object.
		):
	'''
		Python: HANDLE = vs.FIn3D(objectHd)
		VectorScript: FUNCTION FIn3D(objectHd:HANDLE) : HANDLE;
		
		Category: Document List Handling
		Function FIn3D returns a handle to the first component object in the referenced 3D object definition.
	'''
	pass
	return 'HANDLE' # 


def FindAttribute(
		XMLHandle       , # LONGINT            -  
		startElementPath, # DYNARRAY[] of CHAR -  
		searchAttribute   # DYNARRAY[] of CHAR -  
		):
	'''
		Python: (INTEGER, foundPath, attributeValue) = vs.FindAttribute(XMLHandle, startElementPath, searchAttribute)
		VectorScript: FUNCTION FindAttribute(XMLHandle:LONGINT; startElementPath:DYNARRAY of CHAR; searchAttribute:DYNARRAY of CHAR; VAR foundPath:DYNARRAY of CHAR; VAR attributeValue:DYNARRAY of CHAR) : INTEGER;
		
		Category: XML
		Finds the specified attribute by name.
	'''
	pass
	return ( 0       , # 
	         'string', 
	         'string' )


def FindElement(
		XMLHandle       , # LONGINT            -  
		startElementPath, # DYNARRAY[] of CHAR -  
		searchElement     # DYNARRAY[] of CHAR -  
		):
	'''
		Python: (INTEGER, foundPath) = vs.FindElement(XMLHandle, startElementPath, searchElement)
		VectorScript: FUNCTION FindElement(XMLHandle:LONGINT; startElementPath:DYNARRAY of CHAR; searchElement:DYNARRAY of CHAR; VAR foundPath:DYNARRAY of CHAR) : INTEGER;
		
		Category: XML
		Finds the specified element by name.
	'''
	pass
	return ( 0       , # 
	         'string' )


def FindFile(
		whichPath  , # INTEGER            -  
		relFilePath  # DYNARRAY[] of CHAR -  
		):
	'''
		Python: (BOOLEAN, outPath) = vs.FindFile(whichPath, relFilePath)
		VectorScript: FUNCTION FindFile(whichPath:INTEGER; relFilePath:DYNARRAY of CHAR; VAR outPath:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: File I/O
		Find a file by searching the folder selector (whichPath) plus the relative file path. Searches the user folder, workgroup folders, and the app folder.
	'''
	pass
	return ( False   , # 
	         'string' )


def FindFileInPluginFolder(
		filename  # DYNARRAY[] of CHAR -  
		):
	'''
		Python: (BOOLEAN, path) = vs.FindFileInPluginFolder(filename)
		VectorScript: FUNCTION FindFileInPluginFolder(filename:DYNARRAY of CHAR; VAR path:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: File I/O
		Searches for filename in all plug-in folders.  Returns TRUE if the file is found, FALSE otherwise.  If found, the result is returned in the path parameter.
	'''
	pass
	return ( False   , # 
	         'string' )


def FindLBColumnDataItem(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID, # LONGINT - id of the list browser control                 
		columnIndex, # INTEGER - the index of the column                        
		itemString   # STRING  - the text to find                               
		):
	'''
		Python: (BOOLEAN, columnDataItemIndex) = vs.FindLBColumnDataItem(dialogID, componentID, columnIndex, itemString)
		VectorScript: FUNCTION FindLBColumnDataItem(dialogID:LONGINT; componentID:LONGINT; columnIndex:INTEGER; itemString:STRING; VAR columnDataItemIndex:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Finds the column data item with the specified text.
	'''
	pass
	return ( False  , # 
	         0       )


def FindLBColumnItem(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID, # LONGINT - id of the list browser control                 
		columnIndex, # INTEGER - the index of the column                        
		itemString   # STRING  - the text to find                               
		):
	'''
		Python: (BOOLEAN, itemIndex) = vs.FindLBColumnItem(dialogID, componentID, columnIndex, itemString)
		VectorScript: FUNCTION FindLBColumnItem(dialogID:LONGINT; componentID:LONGINT; columnIndex:INTEGER; itemString:STRING; VAR itemIndex:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Finds the column item with the specified text.
	'''
	pass
	return ( False  , # 
	         0       )


def FindObjAtPt_Create(
		hContainer , # HANDLE  -  
		objOptions , # INTEGER -  
		travOptions, # INTEGER -  
		locX       , # REAL    -  
		locY       , # REAL    -  
		pickRadius   # REAL    -  
		):
	'''
		Python: LONGINT = vs.FindObjAtPt_Create(hContainer, objOptions, travOptions, locX, locY, pickRadius)
		VectorScript: FUNCTION FindObjAtPt_Create(hContainer:HANDLE; objOptions:INTEGER; travOptions:INTEGER; locX:REAL; locY:REAL; pickRadius:REAL) : LONGINT;
		
		Category: Graphic Calculation
		Creates object find for objects at specified point within specified radius. The funtion is capable of iterating
	'''
	pass
	return 'LONGINT' # 

def FindObjAtPt_Create3D(
		hContainer , # HANDLE  -  
		objOptions , # INTEGER -  
		travOptions, # INTEGER -  
		locX       , # REAL    -  
		locY       , # REAL    -  
		locZ       , # REAL    - 
		pickRadius   # REAL    -  
		):
	'''
		Python: LONGINT = vs.FindObjAtPt_Create(hContainer, objOptions, travOptions, locX, locY, locZ, pickRadius)
		VectorScript: FUNCTION FindObjAtPt_Create(hContainer:HANDLE; objOptions:INTEGER; travOptions:INTEGER; locX:REAL; locY:REAL; locZ:REAL; pickRadius:REAL) : LONGINT;
		
		Category: Graphic Calculation
		Creates object find for objects at specified point within specified radius. The funtion is capable of iterating
	'''
	pass
	return 'LONGINT' # 


def FindObjAtPt_Delete(
		finderID  # LONGINT -  
		):
	'''
		Python: vs.FindObjAtPt_Delete(finderID)
		VectorScript: PROCEDURE FindObjAtPt_Delete(finderID:LONGINT);
		
		Category: Graphic Calculation
		Deletes the find object iterator
	'''
	pass


def FindObjAtPt_GetCount(
		finderID  # LONGINT -  
		):
	'''
		Python: INTEGER = vs.FindObjAtPt_GetCount(finderID)
		VectorScript: FUNCTION FindObjAtPt_GetCount(finderID:LONGINT) : INTEGER;
		
		Category: Graphic Calculation
		Gets the number of objects in the find iterator
	'''
	pass
	return 'INTEGER' # 


def FindObjAtPt_GetObj(
		finderID, # LONGINT -  
		objIndex  # INTEGER -  
		):
	'''
		Python: HANDLE = vs.FindObjAtPt_GetObj(finderID, objIndex)
		VectorScript: FUNCTION FindObjAtPt_GetObj(finderID:LONGINT; objIndex:INTEGER) : HANDLE;
		
		Category: Graphic Calculation
		Get an object from the find iterator
	'''
	pass
	return 'HANDLE' # 


def FInFolder(
		sfHd  # HANDLE - Handle to symbol definition or symbol folder.
		):
	'''
		Python: HANDLE = vs.FInFolder(sfHd)
		VectorScript: FUNCTION FInFolder(sfHd:HANDLE) : HANDLE;
		
		Category: Document List Handling
		Function FInFolder returns a handle to the first object in the referenced symbol folder. The object can be either a symbol definition or a nested symbol folder.
		If the folder is empty, the function returns NIL.
	'''
	pass
	return 'HANDLE' # 


def FInGroup(
		ObjectHd  # HANDLE - Handle to group object.
		):
	'''
		Python: HANDLE = vs.FInGroup(ObjectHd)
		VectorScript: FUNCTION FInGroup(ObjectHd:HANDLE) : HANDLE;
		
		Category: Document List Handling
		Function FInGroup returns a handle to the first component object of the referenced group.
	'''
	pass
	return 'HANDLE' # 


def FInLayer(
		h  # HANDLE - Handle to layer.
		):
	'''
		Python: HANDLE = vs.FInLayer(h)
		VectorScript: FUNCTION FInLayer(h:HANDLE) : HANDLE;
		
		Category: Document List Handling
		Function FInLayer returns a handle to the first object within the referenced layer. If the layer is empty, the function returns NIL.
	'''
	pass
	return 'HANDLE' # 


def FInSymDef(
		sdHd  # HANDLE - Handle to symbol definition.
		):
	'''
		Python: HANDLE = vs.FInSymDef(sdHd)
		VectorScript: FUNCTION FInSymDef(sdHd:HANDLE) : HANDLE;
		
		Category: Document List Handling
		Function FInSymDef returns a handle to the first component object within the referenced symbol definition.
	'''
	pass
	return 'HANDLE' # 


def FLayer():
	'''
		Python: HANDLE = vs.FLayer()
		VectorScript: FUNCTION FLayer : HANDLE;
		
		Category: Layers
		Function FLayer returns a handle to the first layer in a Vectorworks document.
	'''
	pass
	return 'HANDLE' # 


def Flip3DObj(
		h    , # HANDLE  - The handle of the 3D object to flip.                 
		horiz  # BOOLEAN - TRUE for a horizonal flip, FALSE for a vertical flip.
		):
	'''
		Python: vs.Flip3DObj(h, horiz)
		VectorScript: PROCEDURE Flip3DObj(h:HANDLE; horiz:BOOLEAN);
		
		Category: Objects - 3D
		This function will flip a 3D object either horizontally or vertically. Its main use is for withing plugin objects when building their geometry and there is a need to mirror a piece.
		The supported types are: Extrude, Sweep, MultiExtrude, Symbol, Mesh and CSGNode.
	'''
	pass


def FlipHor():
	'''
		Python: vs.FlipHor()
		VectorScript: PROCEDURE FlipHor;
		
		Category: General Edit
		Procedure FlipHor horizontally mirrors selected objects about the center of the object(s). This procedure produces the same effect as the command 'Flip Horizontal' .
	'''
	pass


def FlipHybMatrixObj(
		ioHybMatObj    , # HANDLE  -  
		inFlipSpecifier  # INTEGER -  
		):
	'''
		Python: vs.FlipHybMatrixObj(ioHybMatObj, inFlipSpecifier)
		VectorScript: PROCEDURE FlipHybMatrixObj(ioHybMatObj:HANDLE; inFlipSpecifier:INTEGER);
		
		Category: Objects - Custom
		inFlipSpecifier = 0 for flipH inFlipSpecifier = 1 for FlipV
	'''
	pass


def FlipVer():
	'''
		Python: vs.FlipVer()
		VectorScript: PROCEDURE FlipVer;
		
		Category: General Edit
		Procedure FlipVer vertically mirrors selected objects about the center of the
		object(s). This procedure produce the same effect as the command 'Flip Vertical'.
	'''
	pass


def FLSByClass():
	'''
		Python: BOOLEAN = vs.FLSByClass()
		VectorScript: FUNCTION FLSByClass : BOOLEAN;
		
		Category: Document Attributes
		Function FLSByClass returns whether the global attributes are set to use the line style of the default class.
	'''
	pass
	return 'BOOLEAN' # 


def FLWByClass():
	'''
		Python: BOOLEAN = vs.FLWByClass()
		VectorScript: FUNCTION FLWByClass : BOOLEAN;
		
		Category: Document Attributes
		Function FLWByClass returns whether the global attributes are set to use the line weight of the default class.
	'''
	pass
	return 'BOOLEAN' # 


def FMarker(
		):
	'''
		Python: (style, size, ang) = vs.FMarker()
		VectorScript: PROCEDURE FMarker(VAR style:INTEGER; VAR size:REAL; VAR ang:INTEGER);
		
		Category: Document Attributes
		Procedure FMarker returns the active marker style parameters.
	'''
	pass
	return ( 0  , 
	         0.0, 
	         0   )


def FMarkerByClass():
	'''
		Python: BOOLEAN = vs.FMarkerByClass()
		VectorScript: FUNCTION FMarkerByClass : BOOLEAN;
		
		Category: Document Attributes
		Function FMarkerByClass returns whether the global attributes are set to use the arrow style of the default class.
	'''
	pass
	return 'BOOLEAN' # 


def FndError():
	'''
		Python: BOOLEAN = vs.FndError()
		VectorScript: FUNCTION FndError : BOOLEAN;
		
		Category: Utility
		Function FndError returns whether an error has occurred within a VectorScript subroutine. Provided as a debugging tool, FndError receives notification after execution of every line of code whether an error has occurred.
	'''
	pass
	return 'BOOLEAN' # 


def FObject():
	'''
		Python: HANDLE = vs.FObject()
		VectorScript: FUNCTION FObject : HANDLE;
		
		Category: Document List Handling
		Function FObject returns a handle to the first object in the active document. If the document is empty, the function returns NIL.
	'''
	pass
	return 'HANDLE' # 


def ForEachObject(
		callback, # PROCEDURE - Name of action procedure to be applied to matching objects
		c         # CRITERIA  - Search criteria for locating objects.                     
		):
	'''
		Python: vs.ForEachObject(callback, c)
		VectorScript: PROCEDURE ForEachObject(callback:PROCEDURE; c:CRITERIA);
		
		Category: Criteria
		Calls a user defined procedure to operate on each object matching the specified search criteria.
		The procedure subroutine specified by the callback parameter must have one parameter of type HANDLE, which is passed the handle to an object by the ForEachObject call.
	'''
	pass


def ForEachObjectAtPoint(
		actionFunc , # PROCEDURE -  
		objOptions , # INTEGER   -  
		travOptions, # INTEGER   -  
		loc        , # POINT     -  
		pickRadius   # REAL      -  
		):
	'''
		Python: vs.ForEachObjectAtPoint(actionFunc, objOptions, travOptions, loc, pickRadius)
		VectorScript: PROCEDURE ForEachObjectAtPoint(actionFunc:PROCEDURE; objOptions:INTEGER; travOptions:INTEGER; locX, locY:REAL; pickRadius:REAL);
		
		Category: Utility
		Performs an action for each object at the specified point in the drawing. This call was implemented to get past the practical limitations of PickObject, which only finds the topmost object. This call will find all of the objects at a given point.
		"actionFunc" should actually be a function, not a procedure as the declaration indicates.
		If the callback function returns FALSE, ForEachObjectAtPoint will not process any more objects at the specified point.
	'''
	pass


def ForEachObjectInLayer(
		actionFunc  , # PROCEDURE - Subroutine which performs operation on found objects.
		objOptions  , # INTEGER   - Object selection option index.                       
		travOptions , # INTEGER   - Search options index.                                
		layerOptions  # INTEGER   - Layer selection option index.                        
		):
	'''
		Python: vs.ForEachObjectInLayer(actionFunc, objOptions, travOptions, layerOptions)
		VectorScript: PROCEDURE ForEachObjectInLayer(actionFunc:PROCEDURE; objOptions:INTEGER; travOptions:INTEGER; layerOptions:INTEGER);
		
		Category: Utility
		Traverses through all objects according to specified search options and applies the specified action to each object.  The 'actionFunc' procedure should return false to continue with next object, or return true to stop the traversal.
	'''
	pass


def ForEachObjectInList(
		actionFunc , # PROCEDURE - Subroutine which performs operation on found objects.
		objOptions , # INTEGER   - Object selection option index.                       
		travOptions, # INTEGER   - Search options index.                                
		list         # HANDLE    - Handle to first item in list.                        
		):
	'''
		Python: vs.ForEachObjectInList(actionFunc, objOptions, travOptions, list)
		VectorScript: PROCEDURE ForEachObjectInList(actionFunc:PROCEDURE; objOptions:INTEGER; travOptions:INTEGER; list:HANDLE);
		
		Category: Utility
		Processes all items in the specified list and and applies the specified action to each item.
	'''
	pass


def FormatTextDialog(
		fontName   , # in/out STRING  - The name of the selected font.                                                                                                                                     
		style      , # in/out INTEGER - The selected style options.  0 for plain text.  Bit 1 is on for bold, bit 2 for italic, bit 3 for underline, bit 4 for outline and bit 5 for shadow.               
		size       , # in/out REAL    - The selected size (in points).                                                                                                                                     
		spacing    , # in/out INTEGER - The selected spacing option.  0 for custom leading, 2 for single spacing, 3 for 1 1/2 spacing and 4 for double spacing.                                            
		leading    , # in/out REAL    - The selected leading value (in points) for custom spacing or -1 for a standard spacing.                                                                            
		hAlignment , # in/out INTEGER - The selected horizontal alignment options.  0 for general justify (used only on worksheets), 1 for left, 2 for center and 3 for right.                             
		vAlignment , # in/out INTEGER - The selected vertical alignment options.  1 for top, 2 for top baseline, 3 for center, 4 for bottom baseline and 5 for bottom.                                     
		disableMask  # INTEGER        - Disables controls and indicates for worksheet.  Bit 1 disables font name, bit 2 size, bit 3 spacing, bit 4 style, bit 5 h align, bit 6 v align and bit 7 worksheet.
		):
	'''
		Python: (fontName, style, size, spacing, leading, hAlignment, vAlignment) = vs.FormatTextDialog(fontName, style, size, spacing, leading, hAlignment, vAlignment, disableMask)
		VectorScript: PROCEDURE FormatTextDialog(VAR fontName:STRING; VAR style:INTEGER; VAR size:REAL; VAR spacing:INTEGER; VAR leading:REAL; VAR hAlignment:INTEGER; VAR vAlignment:INTEGER; disableMask:INTEGER);
		
		Category: Dialogs - Predefined
		Displays the text formatting dialog and returns the selected text formatting options.
	'''
	pass
	return ( 'string', 
	         0       , 
	         0.0     , 
	         0       , 
	         0.0     , 
	         0       , 
	         0        )


def Forward():
	'''
		Python: vs.Forward()
		VectorScript: PROCEDURE Forward;
		
		Category: General Edit
		Procedure Forward moves the selected objects up one level in the onscreen object stacking order.
		Objects in the document are drawn in the order in which they are created, with newer objects drawn on top of previously created objects. It is sometimes necessary to adjust this drawing, or stacking, order in order to make objects visible or create a desired effect.
	'''
	pass


def FPatByClass():
	'''
		Python: vs.FPatByClass()
		VectorScript: PROCEDURE FPatByClass;
		
		Category: Classes
		Sets the default document fill pattern to the fill pattern of the active class.
	'''
	pass


def FPenBack(
		):
	'''
		Python: (red, green, blue) = vs.FPenBack()
		VectorScript: PROCEDURE FPenBack(VAR red:LONGINT; VAR green:LONGINT; VAR blue:LONGINT);
		
		Category: Document Attributes
		Procedure FPenBack returns the current pen background color. RGB values are in the range of 0 65535.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def FPenColorByClass():
	'''
		Python: BOOLEAN = vs.FPenColorByClass()
		VectorScript: FUNCTION FPenColorByClass : BOOLEAN;
		
		Category: Document Attributes
		Function FPenColorByClass returns whether the global attributes are set to use the pen colors of the default class.
	'''
	pass
	return 'BOOLEAN' # 


def FPenFore(
		):
	'''
		Python: (red, green, blue) = vs.FPenFore()
		VectorScript: PROCEDURE FPenFore(VAR red:LONGINT; VAR green:LONGINT; VAR blue:LONGINT);
		
		Category: Document Attributes
		Procedure FPenFore returns the current pen foreground color of the document. RGB values are in the range of 0 65535.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def FPenPat():
	'''
		Python: INTEGER = vs.FPenPat()
		VectorScript: FUNCTION FPenPat : INTEGER;
		
		Category: Document Attributes
		Deprecated - will generate error. Use FPenPatN instead.
	'''
	pass
	return 'INTEGER' # 


def FPenPatN():
	'''
		Python: LONGINT = vs.FPenPatN()
		VectorScript: FUNCTION FPenPatN : LONGINT;
		
		Category: Document Attributes
		Function FPenPatN returns the active pen pattern setting.
	'''
	pass
	return 'LONGINT' # 


def FPenSize():
	'''
		Python: INTEGER = vs.FPenSize()
		VectorScript: FUNCTION FPenSize : INTEGER;
		
		Category: Document Attributes
		Function FPenSize returns the active pen size setting (in mils).
	'''
	pass
	return 'INTEGER' # 


def FSActLayer():
	'''
		Python: HANDLE = vs.FSActLayer()
		VectorScript: FUNCTION FSActLayer : HANDLE;
		
		Category: Document List Handling
		Function FSActLayer returns a handle to the first selected object on the active layer. If no objects are selected, the function returns NIL.
	'''
	pass
	return 'HANDLE' # 


def FSObject(
		h  # HANDLE - Handle to layer.
		):
	'''
		Python: HANDLE = vs.FSObject(h)
		VectorScript: FUNCTION FSObject(h:HANDLE) : HANDLE;
		
		Category: Document List Handling
		Function FSObject returns the handle to the first selected object in the referenced layer. If no objects are selected, the function returns NIL.
	'''
	pass
	return 'HANDLE' # 


def FSymDef():
	'''
		Python: HANDLE = vs.FSymDef()
		VectorScript: FUNCTION FSymDef : HANDLE;
		
		Category: Document List Handling
		Function FSymDef returns a handle to the first symbol definition in the current document's symbol library. If the symbol library is empty, the function returns NIL.
	'''
	pass
	return 'HANDLE' # 


def Generate2DFrom3DComp(
		objectHandle , # HANDLE  - Handle of a symbol or plug-in object.                                                       
		component    , # INTEGER - 2D component.                                                                               
		renderMode   , # INTEGER - Render mode.                                                                                
		levelOfDetail  # INTEGER - Detail level. 3D objects visible in this detail level will be used to generate 2D component.
		):
	'''
		Python: BOOLEAN = vs.Generate2DFrom3DComp(objectHandle, component, renderMode, levelOfDetail)
		VectorScript: FUNCTION Generate2DFrom3DComp(objectHandle:HANDLE; component:INTEGER; renderMode:INTEGER; levelOfDetail:INTEGER) : BOOLEAN;
		
		Category: Objects - Custom
		Generates the specified 2D component of a symbol definition or plug-in object from the 3D component.
		The resulting graphics will be similar to converting the 3D component to lines from a view corresponding to the 2D component view.
		3D objects visible in the specified detail level will be used to generate the 2D component.
		Table - 2D components
		2D component		Constant
		Not Set			0
		Top			1
		Bottom			2
		Top and Bottom Cut 	3
		Front			4
		Back			5
		Front and Back Cut	                6
		Left			7
		Right			8
		Left and Right Cut	                9
		Table - Available Render Modes
		Render Mode                                          Constant
		Wireframe 			0
		Hidden Line 			6
		Dashed Hidden Line 		7
		Table - Detail levels
		Detail level			Constant
		Low				1
		Medium				2
		High				4
		All				7
	'''
	pass
	return 'BOOLEAN' # TRUE if the operatuion succeeded.


def GeogCoordToVW(
		inLat, # REAL -  
		inLon  # REAL -  
		):
	'''
		Python: (BOOLEAN, outCoord) = vs.GeogCoordToVW(inLat, inLon)
		VectorScript: FUNCTION GeogCoordToVW(inLat:REAL; inLon:REAL; VAR outCoordX, outCoordY:REAL) : BOOLEAN;
		
		Category: GIS
		Get point in Vectorworks coordinates.
	'''
	pass
	return ( False  , # 
	         0,0     )


def Get2DComponentGroup(
		objectHandle, # HANDLE  - Handle to the object.
		component     # INTEGER - 2D component.        
		):
	'''
		Python: HANDLE = vs.Get2DComponentGroup(objectHandle, component)
		VectorScript: FUNCTION Get2DComponentGroup(objectHandle:HANDLE; component:INTEGER) : HANDLE;
		
		Category: Objects - Custom
		Gets the specified 2D component group of a symbol definition or plug-in object or NULL if the group does not exist.                                                                                                                                                                            Table - 2D components
		2D component			Constant
		Not Set			0
		Top			1
		Bottom			2
		Top and Bottom Cut	                3
		Front			4
		Back			5
		Front and Back Cut	                6
		Left			7
		Right			8
		Left and Right Cut	                9
	'''
	pass
	return 'HANDLE' # Returns a HANDLE to the specified 2D component group. 


def Get2DPt(
		obj  , # HANDLE  - Handle to object.             
		index  # INTEGER - Index of vertex to be queried.
		):
	'''
		Python: loc = vs.Get2DPt(obj, index)
		VectorScript: PROCEDURE Get2DPt(obj:HANDLE; index:INTEGER; VAR locX, locY:REAL);
		
		Category: Object Info
		Returns the location of the specified vertex of a referenced object.
	'''
	pass
	return ( 0,0 )


def Get3DCntr(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: (p, zValue) = vs.Get3DCntr(h)
		VectorScript: PROCEDURE Get3DCntr(h:HANDLE; VAR pX, pY:REAL; VAR zValue:REAL);
		
		Category: Objects - 3D
		Procedure Get3DCntr returns the three-dimensional center point of the referenced 3D object.
	'''
	pass
	return ( 0,0, 
	         0.0 )


def Get3DInfo(
		h  # HANDLE - Handle to 3D object.
		):
	'''
		Python: (height, width, depth) = vs.Get3DInfo(h)
		VectorScript: PROCEDURE Get3DInfo(h:HANDLE; VAR height:REAL; VAR width:REAL; VAR depth:REAL);
		
		Category: Objects - 3D
		Procedure Get3DInfo returns the height, width and depth values of the referenced 3D object.
	'''
	pass
	return ( 0.0, 
	         0.0, 
	         0.0 )


def Get3DOrientation(
		h  # HANDLE - Handle to 3D object.
		):
	'''
		Python: (BOOLEAN, xRot, yRot, zRot, isMirroredXY) = vs.Get3DOrientation(h)
		VectorScript: FUNCTION Get3DOrientation(h:HANDLE; VAR xRot:REAL; VAR yRot:REAL; VAR zRot:REAL; VAR isMirroredXY:BOOLEAN) : BOOLEAN;
		
		Category: Objects - 3D
		Function Get3DOrientation returns the 3D orientation of the referenced object.
		If the object is mirrored, a reflection across the X-Y plane must be applied before rotating by the angles above in order to reproduce the object's orientation.
	'''
	pass
	return ( False  , # [[name]] returns TRUE if a valid 3D object was passed to the procedure.
	         0.0    , 
	         0.0    , 
	         0.0    , 
	         False   )


def GetActiveEditItem(
		dialogID  # LONGINT -  
		):
	'''
		Python: LONGINT = vs.GetActiveEditItem(dialogID)
		VectorScript: FUNCTION GetActiveEditItem(dialogID:LONGINT) : LONGINT;
		
		Category: Dialogs - Modern
		Returns the active edit control in the specified dialog.  If no edit control has the focus, -1 is returned.
	'''
	pass
	return 'LONGINT' # 


def GetActivePane(
		dialogID    , # LONGINT - the ID of the dialog      
		tabControlID  # LONGINT - the ID of the swap control
		):
	'''
		Python: LONGINT = vs.GetActivePane(dialogID, tabControlID)
		VectorScript: FUNCTION GetActivePane(dialogID:LONGINT; tabControlID:LONGINT) : LONGINT;
		
		Category: Dialogs - Modern
		Returns the currently displayed tab or swap pane in the specified tab or swap control.
		This is called from the dialog's event handling routine.
	'''
	pass
	return 'LONGINT' # 


def GetActiveSerialNumber():
	'''
		Python: STRING = vs.GetActiveSerialNumber()
		VectorScript: FUNCTION GetActiveSerialNumber : STRING;
		
		Category: Utility
		Gets the currently active serial number.
	'''
	pass
	return 'STRING' # 


def GetActualNameFromResourceList(
		listID, # LONGINT - an ID for a resouce list created by the BuildResourceList function.
		index   # LONGINT - an index into the list.                                            
		):
	'''
		Python: DYNARRAY of CHAR = vs.GetActualNameFromResourceList(listID, index)
		VectorScript: FUNCTION GetActualNameFromResourceList(listID:LONGINT; index:LONGINT) : DYNARRAY of CHAR;
		
		Category: Document List Handling
		Returns the actual name of the indicated item in the specified resource list. This call will delete the filename that is appended for resources with same name from different files.
	'''
	pass
	return 'DYNARRAY[] of CHAR' # 


def GetAngleToNorth():
	'''
		Python: REAL = vs.GetAngleToNorth()
		VectorScript: FUNCTION GetAngleToNorth : REAL;
		
		Category: GIS
		Get angle to north.
	'''
	pass
	return 'REAL' # 


def GetArc(
		h  # HANDLE - Handle to arc.
		):
	'''
		Python: (startAngleR, arcAngleR) = vs.GetArc(h)
		VectorScript: PROCEDURE GetArc(h:HANDLE; VAR startAngleR:REAL; VAR arcAngleR:REAL);
		
		Category: Objects - 2D
		Procedure GetArc returns the start and sweep angle of the referenced arc or round wall.
	'''
	pass
	return ( 0.0, 
	         0.0 )


def GetArrayDimensions(
		arrayname  # ARRAY - Name of array.
		):
	'''
		Python: (rowStart, rowEnd, columnStart, columnEnd) = vs.GetArrayDimensions(arrayname)
		VectorScript: PROCEDURE GetArrayDimensions(arrayname:ARRAY; VAR rowStart:INTEGER; VAR rowEnd:INTEGER; VAR columnStart:INTEGER; VAR columnEnd:INTEGER);
		
		Category: Utility
		Returns the dimensions of the specified array.
	'''
	pass
	return ( 0, 
	         0, 
	         0, 
	         0 )


def GetAssociation(
		handle, # HANDLE  - Associated object handle.
		index   # INTEGER - Index of association.    
		):
	'''
		Python: (HANDLE, associationkind, value) = vs.GetAssociation(handle, index)
		VectorScript: FUNCTION GetAssociation(handle:HANDLE; index:INTEGER; VAR associationkind:INTEGER; VAR value:INTEGER) : HANDLE;
		
		Category: Object Editing
		Gets info about association of specified object.
	'''
	pass
	return ( 0     , # HANDLE
	         0     , 
	         0      )


def GetAttributeValue(
		XMLHandle  , # LONGINT            -  
		elementPath, # DYNARRAY[] of CHAR -  
		attribute    # DYNARRAY[] of CHAR -  
		):
	'''
		Python: (INTEGER, value) = vs.GetAttributeValue(XMLHandle, elementPath, attribute)
		VectorScript: FUNCTION GetAttributeValue(XMLHandle:LONGINT; elementPath:DYNARRAY of CHAR; attribute:DYNARRAY of CHAR; VAR value:STRING) : INTEGER;
		
		Category: XML
		Gets a value of an attribute.
	'''
	pass
	return ( 0       , # 
	         'string' )


def GetBatAttributes(
		roofObject, # HANDLE  - Handle to roof.         
		dormerID    # INTEGER - Index of dormer element.
		):
	'''
		Python: (useHeight, heightDepth, bottomWidth, topWidth, baseHeight, controlPoint, topSlope) = vs.GetBatAttributes(roofObject, dormerID)
		VectorScript: PROCEDURE GetBatAttributes(roofObject:HANDLE; dormerID:INTEGER; VAR useHeight:BOOLEAN; VAR heightDepth:REAL; VAR bottomWidth:REAL; VAR topWidth:REAL; VAR baseHeight:REAL; VAR controlPoint:REAL; VAR topSlope:REAL);
		
		Category: Objects - Roofs
		Procedure GetBatAttributes returns the attributes of a bat dormer in the referenced roof.
	'''
	pass
	return ( False, 
	         0.0  , 
	         0.0  , 
	         0.0  , 
	         0.0  , 
	         0.0  , 
	         0.0   )


def GetBBox(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: (p1, p2) = vs.GetBBox(h)
		VectorScript: PROCEDURE GetBBox(h:HANDLE; VAR p1X, p1Y:REAL; VAR p2X, p2Y:REAL);
		
		Category: Object Info
		Procedure GetBBox returns the bounding box coordinates of the projection of the referenced object on the screen plane.
	'''
	pass
	return ( 0,0, 
	         0,0 )


def GetBeamAngle(
		h  # HANDLE - Handle to light.
		):
	'''
		Python: beamAngleR = vs.GetBeamAngle(h)
		VectorScript: PROCEDURE GetBeamAngle(h:HANDLE; VAR beamAngleR:REAL);
		
		Category: Objects - Lights
		Procedure GetBeamAngle returns the spread angle of the referenced spot light.
	'''
	pass
	return ( 0.0 )


def GetBinaryConstraint(
		constrType   , # INTEGER - Type of constraint to be returned.                       
		obj1         , # HANDLE  - Handle to first object in constraint relationship.       
		obj2         , # HANDLE  - Handle to second object in constraint relationship.      
		obj1VertA    , # INTEGER - Vertex defining the constraint geometry of first object. 
		obj1VertB    , # INTEGER - Vertex defining the constraint geometry of first object. 
		obj2VertA    , # INTEGER - Vertex defining the constraint geometry of second object.
		obj2VertB    , # INTEGER - Vertex defining the constraint geometry of second object.
		containedObj1, # LONGINT -                                                          
		containedObj2  # LONGINT -                                                          
		):
	'''
		Python: HANDLE = vs.GetBinaryConstraint(constrType, obj1, obj2, obj1VertA, obj1VertB, obj2VertA, obj2VertB, containedObj1, containedObj2)
		VectorScript: FUNCTION GetBinaryConstraint(constrType:INTEGER; obj1:HANDLE; obj2:HANDLE; obj1VertA:INTEGER; obj1VertB:INTEGER; obj2VertA:INTEGER; obj2VertB:INTEGER; containedObj1:LONGINT; containedObj2:LONGINT) : HANDLE;
		
		Category: Parametric Constraints
		Returns a handle to a binary parametric constraint applied to the referenced objects.
	'''
	pass
	return 'HANDLE' # Returns a HANDLE to the constraint if exists, otherwise returns NIL.


def GetBooleanItem(
		dialogID   , # LONGINT - the dialog identifier given by CreateLayout or CreateResizableLayout
		componentID  # LONGINT - The identifier for the radio or checkbox button component.          
		):
	'''
		Python: outState = vs.GetBooleanItem(dialogID, componentID)
		VectorScript: PROCEDURE GetBooleanItem(dialogID:LONGINT; componentID:LONGINT; VAR outState:BOOLEAN);
		
		Category: Dialogs - Modern
		Determines if a radio or checkbox button is selected or not.
	'''
	pass
	return ( False )


def GetCAlign(
		h  , # HANDLE  - Handle to worksheet.   
		row, # INTEGER - Worksheet row index.   
		col  # INTEGER - Worksheet column index.
		):
	'''
		Python: INTEGER = vs.GetCAlign(h, row, col)
		VectorScript: FUNCTION GetCAlign(h:HANDLE; row:INTEGER; col:INTEGER) : INTEGER;
		
		Category: Worksheets
		Function GetCAlign returns the alignment value of a cell in the referenced worksheet.
	'''
	pass
	return 'INTEGER' # 


def GetCallBackInval():
	'''
		Python: BOOLEAN = vs.GetCallBackInval()
		VectorScript: FUNCTION GetCallBackInval : BOOLEAN;
		
		Category: Utility
		Returns whether callbacks are invalidating portions of the screen that are being changed.
	'''
	pass
	return 'BOOLEAN' # 


def GetCatalogItem(
		hObj  # HANDLE - Handle to plug-in object.
		):
	'''
		Python: BOOLEAN = vs.GetCatalogItem(hObj)
		VectorScript: FUNCTION GetCatalogItem(hObj:HANDLE) : BOOLEAN;
		
		Category: Objects - Custom
		Show the plug-in item catalog dialog to choose an item defined in the catalog. The object will be updated with all parameters defiend in the catalog.
	'''
	pass
	return 'BOOLEAN' # TRUE if a catalog item is selected.


def GetCatalogPath(
		inhObject  # HANDLE - Handle of parametric object.
		):
	'''
		Python: (BOOLEAN, outFolderSpec, outRelativePath) = vs.GetCatalogPath(inhObject)
		VectorScript: FUNCTION GetCatalogPath(inhObject:HANDLE; VAR outFolderSpec:INTEGER; VAR outRelativePath:STRING) : BOOLEAN;
		
		Category: Objects - Custom
		Get the path to catalog files for a plug-in object.
	'''
	pass
	return ( False   , # TRUE of the object supports catalogs.[[BR]]FALSE if the object does not support catalogs.
	         0       , 
	         'string' )


def GetCDATA(
		XMLHandle  , # LONGINT            -  
		elementPath  # DYNARRAY[] of CHAR -  
		):
	'''
		Python: (INTEGER, returnVal) = vs.GetCDATA(XMLHandle, elementPath)
		VectorScript: FUNCTION GetCDATA(XMLHandle:LONGINT; elementPath:DYNARRAY of CHAR; VAR returnVal:DYNARRAY of CHAR) : INTEGER;
		
		Category: XML
		Gets CDATA section.
	'''
	pass
	return ( 0       , # 
	         'string' )


def GetCellNum(
		h  , # HANDLE  - Handle to worksheet.   
		row, # INTEGER - Worksheet row index.   
		col  # INTEGER - Worksheet column index.
		):
	'''
		Python: REAL = vs.GetCellNum(h, row, col)
		VectorScript: FUNCTION GetCellNum(h:HANDLE; row:INTEGER; col:INTEGER) : REAL;
		
		Category: Worksheets
		Function GetCellNum returns the numeric value of a cell in the referenced worksheet.
	'''
	pass
	return 'REAL' # 


def GetCellStr(
		h  , # HANDLE  - Handle to worksheet.   
		row, # INTEGER - Worksheet row index.   
		col  # INTEGER - Worksheet column index.
		):
	'''
		Python: STRING = vs.GetCellStr(h, row, col)
		VectorScript: FUNCTION GetCellStr(h:HANDLE; row:INTEGER; col:INTEGER) : STRING;
		
		Category: Worksheets
		Function GetCellStr returns the string value of a cell in the referenced worksheet.
	'''
	pass
	return 'STRING' # 


def GetCharColor(
		theText , # HANDLE  - Handle of the text object                             
		position  # INTEGER - Position of the character in the text string (0-based)
		):
	'''
		Python: (red, green, blue) = vs.GetCharColor(theText, position)
		VectorScript: PROCEDURE GetCharColor(theText:HANDLE; position:INTEGER; VAR red:LONGINT; VAR green:LONGINT; VAR blue:LONGINT);
		
		Category: Objects - Text
		Function GetCharColor returns the color of a character at a specified position in the given text object.
		The position is in a range between 0 and 32767, representing a character position in the text string. An index of 0 refers to the first character in the string.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetCheckoutsComment(
		):
	'''
		Python: (BOOLEAN, comment) = vs.GetCheckoutsComment()
		VectorScript: FUNCTION GetCheckoutsComment(VAR comment:STRING) : BOOLEAN;
		
		Category: Project Sharing
		Get the comment that will be used for checkouts and commits.
	'''
	pass
	return ( False   , # True on success, false on failure or not Project Sharing file.
	         'string' )


def GetChoiceCount(
		dialogID   , # LONGINT - the dialog identifier given by CreateLayout or CreateResizableLayout
		componentID  # LONGINT - The identifier for the component that contains the choices.         
		):
	'''
		Python: outCount = vs.GetChoiceCount(dialogID, componentID)
		VectorScript: PROCEDURE GetChoiceCount(dialogID:LONGINT; componentID:LONGINT; VAR outCount:INTEGER);
		
		Category: Dialogs - Modern
		Gets the number of items in the component that contains the choices.
	'''
	pass
	return ( 0 )


def GetChoiceIndex(
		dialogID   , # LONGINT -  
		componentID, # LONGINT -  
		itemText     # STRING  -  
		):
	'''
		Python: itemIndex = vs.GetChoiceIndex(dialogID, componentID, itemText)
		VectorScript: PROCEDURE GetChoiceIndex(dialogID:LONGINT; componentID:LONGINT; itemText:STRING; VAR itemIndex:INTEGER);
		
		Category: Dialogs - Modern
		Finds the index of the given string in a layout manager list box or pull down menu. The index is zero based and is set to -1 if the item is not found.
	'''
	pass
	return ( 0 )


def GetChoiceStringFromStoryBoundData(
		boundType     , # INTEGER - Bounding type: 0 - DefaultWallHeight; 1 - LayerZ; 2 - Story.                                                                                                                                                      
		boundStory    , # INTEGER - The story identified by 'boundType' = (2 - Story). If 'boundStory' = 0 then it is this story (the object's story); If 'boundStory' = 1 then it is the story above; If 'boundStory' = 2 then it is the story below.
		layerLevelType  # STRING  - The layer type which defines this bound.                                                                                                                                                                          
		):
	'''
		Python: choiceString = vs.GetChoiceStringFromStoryBoundData(boundType, boundStory, layerLevelType)
		VectorScript: PROCEDURE GetChoiceStringFromStoryBoundData(boundType:INTEGER; boundStory:INTEGER; layerLevelType:STRING; VAR choiceString:STRING);
		
		Category: Dialogs - Modern
		Gets the story bound choice string from story bound data.
	'''
	pass
	return ( 'string' )


def GetChoiceText(
		dialogID   , # LONGINT - The dialog identifier given by CreateLayout or CreateResizableLayout                                  
		componentID, # LONGINT - The identifier of the control that contains the menu items from which the text will be retrieved from.
		itemIndex    # INTEGER - The item index that contains the desired text.                                                        
		):
	'''
		Python: itemText = vs.GetChoiceText(dialogID, componentID, itemIndex)
		VectorScript: PROCEDURE GetChoiceText(dialogID:LONGINT; componentID:LONGINT; itemIndex:INTEGER; VAR itemText:STRING);
		
		Category: Dialogs - Modern
		Using the index, gets the text of the menu item of the given component.
	'''
	pass
	return ( 'string' )


def GetClass(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: STRING = vs.GetClass(h)
		VectorScript: FUNCTION GetClass(h:HANDLE) : STRING;
		
		Category: Object Attributes
		Function GetClass returns the class assigned to the referenced object. None is returned if the object has no class assigned to it.
	'''
	pass
	return 'STRING' # 


def GetClassArrow(
		clasName   # STRING - The indicated class.
		):
	'''
		Python: (style, size, angle) = vs.GetClassArrow(className)
		VectorScript: PROCEDURE GetClassArrow(className:STRING; VAR style:INTEGER; VAR size:REAL; VAR angle:INTEGER);
		
		Category: Classes
		Procedure GetClassArrow returns the arrow style parameters for the indicated class.
	'''
	pass
	return ( 0  , 
	         0.0, 
	         0   )


def GetClassBeginningMarker(
		name  # STRING - Name of the class 
		):
	'''
		Python: (BOOLEAN, style, angle, size, width, thicknessBasis, thickness) = vs.GetClassBeginningMarker(name)
		VectorScript: FUNCTION GetClassBeginningMarker(name:STRING; VAR style:LONGINT; VAR angle:INTEGER; VAR size:REAL; VAR width:REAL; VAR thicknessBasis:INTEGER; VAR thickness:REAL) : BOOLEAN;
		
		Category: Classes
		Gets all properties for the named class' beginning marker. Return TRUE if operation was successful.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0      , 
	         0.0    , 
	         0.0    , 
	         0      , 
	         0.0     )


def GetClassEndMarker(
		name  # STRING - Name of the class 
		):
	'''
		Python: (BOOLEAN, style, angle, size, width, thicknessBasis, thickness) = vs.GetClassEndMarker(name)
		VectorScript: FUNCTION GetClassEndMarker(name:STRING; VAR style:LONGINT; VAR angle:INTEGER; VAR size:REAL; VAR width:REAL; VAR thicknessBasis:INTEGER; VAR thickness:REAL) : BOOLEAN;
		
		Category: Classes
		Gets all properties for the named class's end marker. Return TRUE if operation was successful.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0      , 
	         0.0    , 
	         0.0    , 
	         0      , 
	         0.0     )


def GetClassOptions():
	'''
		Python: INTEGER = vs.GetClassOptions()
		VectorScript: FUNCTION GetClassOptions : INTEGER;
		
		Category: Classes
		Returns the class visibility setting for the active document.
	'''
	pass
	return 'INTEGER' # An INTEGER value indicating the current class visibility setting for the document.


def GetCLDrpShadowData(
		clasName   # STRING -  
		):
	'''
		Python: (nUnits, dOffset, dBlurRadius, dAngle, nOpacity, colorRV, colorGV, colorBV) = vs.GetCLDrpShadowData(className)
		VectorScript: PROCEDURE GetCLDrpShadowData(className:STRING; VAR nUnits:INTEGER; VAR dOffset:REAL; VAR dBlurRadius:REAL; VAR dAngle:REAL; VAR nOpacity:INTEGER; VAR colorRV:INTEGER; VAR colorGV:INTEGER; VAR colorBV:INTEGER);
		
		Category: Classes
	'''
	pass
	return ( 0  , 
	         0.0, 
	         0.0, 
	         0.0, 
	         0  , 
	         0  , 
	         0  , 
	         0   )


def GetClFillBack(
		clasName   # STRING - Name of class.
		):
	'''
		Python: (colorRV, colorGV, colorBV) = vs.GetClFillBack(className)
		VectorScript: PROCEDURE GetClFillBack(className:STRING; VAR colorRV:LONGINT; VAR colorGV:LONGINT; VAR colorBV:LONGINT);
		
		Category: Classes
		Returns the fill background color setting of the specified class. The color is returned as the three RGB components of the color. RGB values are in the range of 0 65535.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetClFillFore(
		clasName   # STRING - Name of class.
		):
	'''
		Python: (colorRV, colorGV, colorBV) = vs.GetClFillFore(className)
		VectorScript: PROCEDURE GetClFillFore(className:STRING; VAR colorRV:LONGINT; VAR colorGV:LONGINT; VAR colorBV:LONGINT);
		
		Category: Classes
		Returns the fill foreground color setting of the specified class. The color is returned as the RGB components of the color. RGB values are in the range of 0 65535.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetClFPat(
		clasName   # STRING - Name of class.
		):
	'''
		Python: LONGINT = vs.GetClFPat(className)
		VectorScript: FUNCTION GetClFPat(className:STRING) : LONGINT;
		
		Category: Classes
		Returns the fill or hatch pattern of the specified class.
		A positive return value in a range of 0 to 71 is the index of the bitmap fill pattern of the class. A negative value is the negative of the fill pattern index (index * -1).
	'''
	pass
	return 'LONGINT' # 


def GetClLS(
		clasName   # STRING - Name of class.
		):
	'''
		Python: INTEGER = vs.GetClLS(className)
		VectorScript: FUNCTION GetClLS(className:STRING) : INTEGER;
		
		Category: Classes
		Deprecated - will generate error. Use GetClLSN instead.
		Returns the line style of the specified class.
	'''
	pass
	return 'INTEGER' # 


def GetClLSN(
		clasName   # STRING - Name of class.
		):
	'''
		Python: LONGINT = vs.GetClLSN(className)
		VectorScript: FUNCTION GetClLSN(className:STRING) : LONGINT;
		
		Category: Classes
		Returns the line style of the specified class.
	'''
	pass
	return 'LONGINT' # 


def GetClLW(
		clasName   # STRING - Name of class.
		):
	'''
		Python: INTEGER = vs.GetClLW(className)
		VectorScript: FUNCTION GetClLW(className:STRING) : INTEGER;
		
		Category: Classes
		Returns the line weight of the specified class.
	'''
	pass
	return 'INTEGER' # 


def GetClOpacity(
		clasName   # STRING -  
		):
	'''
		Python: INTEGER = vs.GetClOpacity(className)
		VectorScript: FUNCTION GetClOpacity(className:STRING) : INTEGER;
		
		Category: Classes
		Gets the opacity of the specified class.
	'''
	pass
	return 'INTEGER' # 


def GetClOpacityN(
		strClassName  # STRING -  
		):
	'''
		Python: (outFillOpacity, outPenOpacity) = vs.GetClOpacityN(strClassName)
		VectorScript: PROCEDURE GetClOpacityN(strClassName:STRING; VAR outFillOpacity:INTEGER; VAR outPenOpacity:INTEGER);
		
		Category: Classes
	'''
	pass
	return ( 0, 
	         0 )


def GetClosestPt(
		pt  # POINT - Coordinate location of comparison point.
		):
	'''
		Python: (obj, index, containedObj) = vs.GetClosestPt(pt)
		VectorScript: PROCEDURE GetClosestPt(VAR obj:HANDLE; ptX, ptY:REAL; VAR index:INTEGER; VAR containedObj:LONGINT);
		
		Category: Utility
		Returns the index number of the object closest to the specified location.
		The index value will return 0 if no vertex can be determined as closest, and will return -1 if the object does not support GetClosestPt.
		For container objects, GetClosestPt has distinct behaviors. For walls, if the closest vertex is
		is in a subobject, obj will be set to a handle to the subobject. For symbols and plug-in objects, an index to the sub-object will be returned via parameter containedObj.
		GetClosestPt supports only 2D objects.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetClosestSide(
		obj, # HANDLE - Handle to object.       
		pt   # POINT  - Coordinates of location.
		):
	'''
		Python: (index1, index2) = vs.GetClosestSide(obj, pt)
		VectorScript: PROCEDURE GetClosestSide(obj:HANDLE; ptX, ptY:REAL; VAR index1:INTEGER; VAR index2:INTEGER);
		
		Category: Utility
		Returns the indices of the vertices that define the side closest to the specified location.
		GetClosestSide supports only 2D objects.  If the object is unsupported, -1 will be returned as the index values.
	'''
	pass
	return ( 0, 
	         0 )


def GetClPenBack(
		clasName   # STRING - Name of class.
		):
	'''
		Python: (colorRV, colorGV, colorBV) = vs.GetClPenBack(className)
		VectorScript: PROCEDURE GetClPenBack(className:STRING; VAR colorRV:LONGINT; VAR colorGV:LONGINT; VAR colorBV:LONGINT);
		
		Category: Classes
		Returns the pen background color setting of the specified class. The color is returned as the three RGB components of the color. RGB values are in the range of 0 65535.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetClPenFore(
		clasName   # STRING - Name of class.
		):
	'''
		Python: (colorRV, colorGV, colorBV) = vs.GetClPenFore(className)
		VectorScript: PROCEDURE GetClPenFore(className:STRING; VAR colorRV:LONGINT; VAR colorGV:LONGINT; VAR colorBV:LONGINT);
		
		Category: Classes
		Returns the pen foreground color setting of the specified class. The color is returned as the three RGB components of the color. RGB values are in the range of 0 65535.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetClTextStyleRef(
		clasName   # STRING - Name of class
		):
	'''
		Python: LONGINT = vs.GetClTextStyleRef(className)
		VectorScript: FUNCTION GetClTextStyleRef(className:STRING) : LONGINT;
		
		Category: Classes
		Function GetClTextStyleRef gets the text style of the specified class.  The integer style is the internal index of the text style.
	'''
	pass
	return 'LONGINT' # 


def GetClTextureC(
		clasName   # STRING - Class name.
		):
	'''
		Python: LONGINT = vs.GetClTextureC(className)
		VectorScript: FUNCTION GetClTextureC(className:STRING) : LONGINT;
		
		Category: Textures
		Function GetClTextureC returns the wall center texture of the specified class.
	'''
	pass
	return 'LONGINT' # 


def GetClTextureD(
		clasName   # STRING - Class name.
		):
	'''
		Python: LONGINT = vs.GetClTextureD(className)
		VectorScript: FUNCTION GetClTextureD(className:STRING) : LONGINT;
		
		Category: Textures
		Function GetClTextureD returns the roof dormer texture of the specified class.
	'''
	pass
	return 'LONGINT' # 


def GetClTextureG(
		clasName   # STRING - Class name.
		):
	'''
		Python: LONGINT = vs.GetClTextureG(className)
		VectorScript: FUNCTION GetClTextureG(className:STRING) : LONGINT;
		
		Category: Textures
		Function GetClTextureG returns the generic texture of the specified class.
	'''
	pass
	return 'LONGINT' # 


def GetClTextureL(
		clasName   # STRING - Class name.
		):
	'''
		Python: LONGINT = vs.GetClTextureL(className)
		VectorScript: FUNCTION GetClTextureL(className:STRING) : LONGINT;
		
		Category: Textures
		Function GetClTextureL returns the left side wall texture of the specified class.
	'''
	pass
	return 'LONGINT' # 


def GetClTextureR(
		clasName   # STRING - Class name.
		):
	'''
		Python: LONGINT = vs.GetClTextureR(className)
		VectorScript: FUNCTION GetClTextureR(className:STRING) : LONGINT;
		
		Category: Textures
		Function GetClTextureR returns the right side wall texture of the specified class.
	'''
	pass
	return 'LONGINT' # 


def GetClTextureT(
		clasName   # STRING - Class name.
		):
	'''
		Python: LONGINT = vs.GetClTextureT(className)
		VectorScript: FUNCTION GetClTextureT(className:STRING) : LONGINT;
		
		Category: Textures
		Function GetClTextureT returns the roof top texture of the specified class.
	'''
	pass
	return 'LONGINT' # 


def GetClUseGraphic(
		clasName   # STRING - Name of class.
		):
	'''
		Python: BOOLEAN = vs.GetClUseGraphic(className)
		VectorScript: FUNCTION GetClUseGraphic(className:STRING) : BOOLEAN;
		
		Category: Classes
		Returns whether the graphic attributes of the specified class will be used at object creation.
	'''
	pass
	return 'BOOLEAN' # True indicates that this class is set to use its graphic attributes when objects are created in this class. False indicates that the objects created in this class will get default attributes from the default global attribute settings.


def GetClUseTextStyle(
		clasName   # STRING - Name of class
		):
	'''
		Python: BOOLEAN = vs.GetClUseTextStyle(className)
		VectorScript: FUNCTION GetClUseTextStyle(className:STRING) : BOOLEAN;
		
		Category: Classes
		Function GetClUseTextStyle returns whether the text style of the specified class is used at object creation.
	'''
	pass
	return 'BOOLEAN' # 


def GetClUseTexture(
		clasName   # STRING - Class name.
		):
	'''
		Python: BOOLEAN = vs.GetClUseTexture(className)
		VectorScript: FUNCTION GetClUseTexture(className:STRING) : BOOLEAN;
		
		Category: Textures
		Function GetClUseTexture returns whether a classes' texture attributes will be used at object creation.
	'''
	pass
	return 'BOOLEAN' # 


def GetClVectorFill(
		clasName   # STRING - Name of class.
		):
	'''
		Python: (BOOLEAN, hatchName) = vs.GetClVectorFill(className)
		VectorScript: FUNCTION GetClVectorFill(className:STRING; VAR hatchName:STRING) : BOOLEAN;
		
		Category: Classes
		Returns the name of the hatch pattern setting of the specified class.
		The function return value will be TRUE if the class uses a hatch pattern, and will be FALSE if the class does not use a hatch pattern.
	'''
	pass
	return ( False   , # 
	         'string' )


def GetColorButton(
		dialogID, # LONGINT - The index of the dialog layout containing the control.
		itemID    # LONGINT - The index of the color button.                        
		):
	'''
		Python: (red, green, blue) = vs.GetColorButton(dialogID, itemID)
		VectorScript: PROCEDURE GetColorButton(dialogID:LONGINT; itemID:LONGINT; VAR red:LONGINT; VAR green:LONGINT; VAR blue:LONGINT);
		
		Category: Dialogs - Modern
		Gets the color of a modern dialog color button.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetColorChoice(
		dialogID, # LONGINT -  
		itemID    # LONGINT -  
		):
	'''
		Python: colorIndex = vs.GetColorChoice(dialogID, itemID)
		VectorScript: PROCEDURE GetColorChoice(dialogID:LONGINT; itemID:LONGINT; VAR colorIndex:INTEGER);
		
		Category: Dialogs - Modern
		Get current choice for color popup dialog control.
	'''
	pass
	return ( 0 )


def GetColorName(
		ColorIndex  # INTEGER - The index of the color
		):
	'''
		Python: STRING = vs.GetColorName(ColorIndex)
		VectorScript: FUNCTION GetColorName(ColorIndex:INTEGER) : STRING;
		
		Category: Object Names
		Retrieves the color name of the specified color index.
	'''
	pass
	return 'STRING' # The name of the color specified by the index.


def GetCompABoundEOffOff(
		object        , # HANDLE  - The object. Can be a  slab, Slab Style, or the Slab Preferences.
		componentIndex  # INTEGER - The index of the component.                                     
		):
	'''
		Python: (BOOLEAN, autoBoundEdgeOffsetOffset) = vs.GetCompABoundEOffOff(object, componentIndex)
		VectorScript: FUNCTION GetCompABoundEOffOff(object:HANDLE; componentIndex:INTEGER; VAR autoBoundEdgeOffsetOffset:REAL) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the auto-bound edge offset offset of a component in an object.
	'''
	pass
	return ( False  , # 
	         0.0     )


def GetCompAltSecFill(
		object        , # HANDLE  - The object. Can be a roof face, roof, Roof Style, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                               
		):
	'''
		Python: (BOOLEAN, alternateSectionFill) = vs.GetCompAltSecFill(object, componentIndex)
		VectorScript: FUNCTION GetCompAltSecFill(object:HANDLE; componentIndex:INTEGER; VAR alternateSectionFill:LONGINT) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the alternate section fill of a component in an object.
	'''
	pass
	return ( False  , # 
	         0       )


def GetCompAltSecFillCl(
		object        , # HANDLE  - The object. Can be a roof face, roof, Roof Style, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                               
		):
	'''
		Python: (BOOLEAN, alternateSectionFillForeColor, alternateSectionFillBackColor) = vs.GetCompAltSecFillCl(object, componentIndex)
		VectorScript: FUNCTION GetCompAltSecFillCl(object:HANDLE; componentIndex:INTEGER; VAR alternateSectionFillForeColor:INTEGER; VAR alternateSectionFillBackColor:INTEGER) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the alternate section fill colors of a component in an object.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0       )


def GetCompAutoJoinCap(
		object        , # HANDLE  - The object. Can be a wall, round wall, Wall Style, or the Wall Preferences.
		componentIndex  # INTEGER - The index of the component.                                                
		):
	'''
		Python: (BOOLEAN, alwaysAutoJoinInCappedJoinMode) = vs.GetCompAutoJoinCap(object, componentIndex)
		VectorScript: FUNCTION GetCompAutoJoinCap(object:HANDLE; componentIndex:INTEGER; VAR alwaysAutoJoinInCappedJoinMode:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the always auto join in Capped Join mode flag of a component in an object.
	'''
	pass
	return ( False  , # 
	         False   )


def GetCompBotIsRelStory(
		object        , # HANDLE  - The object. Can be a wall, round wall, Wall Style, or the Wall Preferences.
		componentIndex  # INTEGER - The index of the component.                                                
		):
	'''
		Python: (BOOLEAN, bottomIsRelativeToStory) = vs.GetCompBotIsRelStory(object, componentIndex)
		VectorScript: FUNCTION GetCompBotIsRelStory(object:HANDLE; componentIndex:INTEGER; VAR bottomIsRelativeToStory:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets whether or not the component bottom is relative to a story.
	'''
	pass
	return ( False  , # 
	         False   )


def GetCompBoundOffset(
		object        , # HANDLE  - The object. Can be a roof face, roof, Roof Style, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                               
		):
	'''
		Python: (BOOLEAN, boundOffset) = vs.GetCompBoundOffset(object, componentIndex)
		VectorScript: FUNCTION GetCompBoundOffset(object:HANDLE; componentIndex:INTEGER; VAR boundOffset:REAL) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the bound offset of a component in an object.
	'''
	pass
	return ( False  , # 
	         0.0     )


def GetCompDatTopOfComp(
		object        , # HANDLE  - The object. Can be a slab, roof face, roof, Slab Style, Roof Style, the Slab Preferences, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                                                                       
		):
	'''
		Python: (BOOLEAN, datumIsTopOfComponent) = vs.GetCompDatTopOfComp(object, componentIndex)
		VectorScript: FUNCTION GetCompDatTopOfComp(object:HANDLE; componentIndex:INTEGER; VAR datumIsTopOfComponent:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the datum is top of component flag of a component in an object.
	'''
	pass
	return ( False  , # 
	         False   )


def GetCompManualBound(
		object        , # HANDLE  - The object. Can be a roof face, roof, Roof Style, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                               
		):
	'''
		Python: (BOOLEAN, manualBound) = vs.GetCompManualBound(object, componentIndex)
		VectorScript: FUNCTION GetCompManualBound(object:HANDLE; componentIndex:INTEGER; VAR manualBound:INTEGER) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the manual bound of a component in an object.
	'''
	pass
	return ( False  , # 
	         0       )


def GetCompMasterSnaps(
		object        , # HANDLE  - The object. Can be a wall, round wall, Wall Style, or the Wall Preferences.
		componentIndex  # INTEGER - The index of the component.                                                
		):
	'''
		Python: (BOOLEAN, masterSnapOnLeft, masterSnapOnRight) = vs.GetCompMasterSnaps(object, componentIndex)
		VectorScript: FUNCTION GetCompMasterSnaps(object:HANDLE; componentIndex:INTEGER; VAR masterSnapOnLeft:BOOLEAN; VAR masterSnapOnRight:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the master snaps of a component in an object.
	'''
	pass
	return ( False  , # 
	         False  , 
	         False   )


def GetComponentAutoBoundEdgeOffset(
		object        , # HANDLE  - The object. Can be a  slab, Slab Style, or the Slab Preferences.
		componentIndex  # INTEGER - The index of the component.                                     
		):
	'''
		Python: (BOOLEAN, autoBoundEdgeOffset) = vs.GetComponentAutoBoundEdgeOffset(object, componentIndex)
		VectorScript: FUNCTION GetComponentAutoBoundEdgeOffset(object:HANDLE; componentIndex:INTEGER; VAR autoBoundEdgeOffset:INTEGER) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the auto-bound edge offset of a component in an object.
	'''
	pass
	return ( False  , # 
	         0       )


def GetComponentClass(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                                                                                                                           
		):
	'''
		Python: (BOOLEAN, componentClass) = vs.GetComponentClass(object, componentIndex)
		VectorScript: FUNCTION GetComponentClass(object:HANDLE; componentIndex:INTEGER; VAR componentClass:LONGINT) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the class of a component in an object.
	'''
	pass
	return ( False  , # 
	         0       )


def GetComponentFill(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                                                                                                                           
		):
	'''
		Python: (BOOLEAN, fill) = vs.GetComponentFill(object, componentIndex)
		VectorScript: FUNCTION GetComponentFill(object:HANDLE; componentIndex:INTEGER; VAR fill:LONGINT) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the fill of a component in an object.
	'''
	pass
	return ( False  , # 
	         0       )


def GetComponentFillColors(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                                                                                                                           
		):
	'''
		Python: (BOOLEAN, fillForeColor, fillBackColor) = vs.GetComponentFillColors(object, componentIndex)
		VectorScript: FUNCTION GetComponentFillColors(object:HANDLE; componentIndex:INTEGER; VAR fillForeColor:INTEGER; VAR fillBackColor:INTEGER) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the fore and back fill colors of a component in an object.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0       )


def GetComponentFollowBottomWallPeaks(
		object        , # HANDLE  - The object. Can be a wall, round wall, Wall Style, or the Wall Preferences.
		componentIndex  # INTEGER - The index of the component.                                                
		):
	'''
		Python: (BOOLEAN, followBottomWallPeaks) = vs.GetComponentFollowBottomWallPeaks(object, componentIndex)
		VectorScript: FUNCTION GetComponentFollowBottomWallPeaks(object:HANDLE; componentIndex:INTEGER; VAR followBottomWallPeaks:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the follow bottom wall peaks flag of a component in an object.
	'''
	pass
	return ( False  , # 
	         False   )


def GetComponentFollowTopWallPeaks(
		object        , # HANDLE  - The object. Can be a wall, round wall, Wall Style, or the Wall Preferences.
		componentIndex  # INTEGER - The index of the component.                                                
		):
	'''
		Python: (BOOLEAN, followTopWallPeaks) = vs.GetComponentFollowTopWallPeaks(object, componentIndex)
		VectorScript: FUNCTION GetComponentFollowTopWallPeaks(object:HANDLE; componentIndex:INTEGER; VAR followTopWallPeaks:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the follow top wall peaks flag of a component in an object.
	'''
	pass
	return ( False  , # 
	         False   )


def GetComponentFunction(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                                                                                                                           
		):
	'''
		Python: (BOOLEAN, func) = vs.GetComponentFunction(object, componentIndex)
		VectorScript: FUNCTION GetComponentFunction(object:HANDLE; componentIndex:INTEGER; VAR func:INTEGER) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the function of a component in an object.
	'''
	pass
	return ( False  , # 
	         0       )


def GetComponentManualEdgeOffset(
		object        , # HANDLE  - The object. Can be a  slab, Slab Style, or the Slab Preferences.
		componentIndex  # INTEGER - The index of the component.                                     
		):
	'''
		Python: (BOOLEAN, manualEdgeOffset) = vs.GetComponentManualEdgeOffset(object, componentIndex)
		VectorScript: FUNCTION GetComponentManualEdgeOffset(object:HANDLE; componentIndex:INTEGER; VAR manualEdgeOffset:REAL) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the manual edge offset of a component in an object.
	'''
	pass
	return ( False  , # 
	         0.0     )


def GetComponentName(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                                                                                                                           
		):
	'''
		Python: STRING = vs.GetComponentName(object, componentIndex)
		VectorScript: FUNCTION GetComponentName(object:HANDLE; componentIndex:INTEGER) : STRING;
		
		Category: Objects - Architectural
		Gets the name of a component in an object.
	'''
	pass
	return 'STRING' # The name of the component.


def GetComponentNetArea(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                                                                                                                           
		):
	'''
		Python: REAL = vs.GetComponentNetArea(object, componentIndex)
		VectorScript: FUNCTION GetComponentNetArea(object:HANDLE; componentIndex:INTEGER) : REAL;
		
		Category: Objects - Architectural
		Gets the net area of a component in an object.
	'''
	pass
	return 'REAL' # The net area of the component.


def GetComponentNetVolume(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                                                                                                                           
		):
	'''
		Python: REAL = vs.GetComponentNetVolume(object, componentIndex)
		VectorScript: FUNCTION GetComponentNetVolume(object:HANDLE; componentIndex:INTEGER) : REAL;
		
		Category: Objects - Architectural
		Gets the net volume of a component in an object.
	'''
	pass
	return 'REAL' # The net volume of the component.


def GetComponentPenColors(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                                                                                                                           
		):
	'''
		Python: (BOOLEAN, leftPenForeColor, leftPenBackColor, rightPenForeColor, rightPenBackColor) = vs.GetComponentPenColors(object, componentIndex)
		VectorScript: FUNCTION GetComponentPenColors(object:HANDLE; componentIndex:INTEGER; VAR leftPenForeColor:INTEGER; VAR leftPenBackColor:INTEGER; VAR rightPenForeColor:INTEGER; VAR rightPenBackColor:INTEGER) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the colors of the pens of a component in an object.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0      , 
	         0      , 
	         0       )


def GetComponentPenStyles(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                                                                                                                           
		):
	'''
		Python: (BOOLEAN, leftPenStyle, rightPenStyle) = vs.GetComponentPenStyles(object, componentIndex)
		VectorScript: FUNCTION GetComponentPenStyles(object:HANDLE; componentIndex:INTEGER; VAR leftPenStyle:INTEGER; VAR rightPenStyle:INTEGER) : BOOLEAN;
		
		Category: Objects - Architectural
		Deprecated - will generate error. Use GetCompPenStylesN instead.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0       )


def GetComponentPenWeights(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                                                                                                                           
		):
	'''
		Python: (BOOLEAN, leftPenWeight, rightPenWeight) = vs.GetComponentPenWeights(object, componentIndex)
		VectorScript: FUNCTION GetComponentPenWeights(object:HANDLE; componentIndex:INTEGER; VAR leftPenWeight:INTEGER; VAR rightPenWeight:INTEGER) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the pen weights of the left and right sides of a component in an object.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0       )


def GetComponentRect(
		nDialogID   , # LONGINT -  
		nComponentID  # LONGINT -  
		):
	'''
		Python: (BOOLEAN, nLeft, nTop, nRight, nBottom) = vs.GetComponentRect(nDialogID, nComponentID)
		VectorScript: FUNCTION GetComponentRect(nDialogID:LONGINT; nComponentID:LONGINT; VAR nLeft:INTEGER; VAR nTop:INTEGER; VAR nRight:INTEGER; VAR nBottom:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern
		Retrieves the bounding rect coordinates of the specified Layout Manager component.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0      , 
	         0      , 
	         0       )


def GetComponents(
		object  # HANDLE - The object. Can be a wall, round wall, slab, Wall Style, Slab Style, the Wall Preferences, or the Slab Preferences.
		):
	'''
		Python: HANDLE = vs.GetComponents(object)
		VectorScript: FUNCTION GetComponents(object:HANDLE) : HANDLE;
		
		Category: Objects - Architectural
		Gets the components of the object.
	'''
	pass
	return 'HANDLE' # 


def GetComponentTexture(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                                                                                                                           
		):
	'''
		Python: (BOOLEAN, texture) = vs.GetComponentTexture(object, componentIndex)
		VectorScript: FUNCTION GetComponentTexture(object:HANDLE; componentIndex:INTEGER; VAR texture:LONGINT) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the texture of a component in an object.
	'''
	pass
	return ( False  , # 
	         0       )


def GetComponentTextWidth(
		nDialogID   , # LONGINT -  
		nComponentID  # LONGINT -  
		):
	'''
		Python: (BOOLEAN, nWidthInLMUnits) = vs.GetComponentTextWidth(nDialogID, nComponentID)
		VectorScript: FUNCTION GetComponentTextWidth(nDialogID:LONGINT; nComponentID:LONGINT; VAR nWidthInLMUnits:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern
		Retrieves the static text's width in Layout Manager Units.
	'''
	pass
	return ( False  , # 
	         0       )


def GetComponentUseFillClassAttr(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                                                                                                                           
		):
	'''
		Python: (BOOLEAN, useFillClassAttributes) = vs.GetComponentUseFillClassAttr(object, componentIndex)
		VectorScript: FUNCTION GetComponentUseFillClassAttr(object:HANDLE; componentIndex:INTEGER; VAR useFillClassAttributes:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the use fill class attributes flag of a component in an object.
	'''
	pass
	return ( False  , # 
	         False   )


def GetComponentUsePenClassAttr(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                                                                                                                           
		):
	'''
		Python: (BOOLEAN, useLeftPenClassAttributes, useRightPenClassAttributes) = vs.GetComponentUsePenClassAttr(object, componentIndex)
		VectorScript: FUNCTION GetComponentUsePenClassAttr(object:HANDLE; componentIndex:INTEGER; VAR useLeftPenClassAttributes:BOOLEAN; VAR useRightPenClassAttributes:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the use class attributes flags of the pens of a component in an object.
	'''
	pass
	return ( False  , # 
	         False  , 
	         False   )


def GetComponentWallBottomOffset(
		object        , # HANDLE  - The object. Can be a wall, round wall, Wall Style, or the Wall Preferences.
		componentIndex  # INTEGER - The index of the component.                                                
		):
	'''
		Python: (BOOLEAN, offsetFromWallBottom) = vs.GetComponentWallBottomOffset(object, componentIndex)
		VectorScript: FUNCTION GetComponentWallBottomOffset(object:HANDLE; componentIndex:INTEGER; VAR offsetFromWallBottom:REAL) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the offset from wall bottom of a component in an object.
	'''
	pass
	return ( False  , # 
	         0.0     )


def GetComponentWallTopOffset(
		object        , # HANDLE  - The object. Can be a wall, round wall, Wall Style, or the Wall Preferences.
		componentIndex  # INTEGER - The index of the component.                                                
		):
	'''
		Python: (BOOLEAN, offsetFromWallTop) = vs.GetComponentWallTopOffset(object, componentIndex)
		VectorScript: FUNCTION GetComponentWallTopOffset(object:HANDLE; componentIndex:INTEGER; VAR offsetFromWallTop:REAL) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the offset from wall top of a component in an object.
	'''
	pass
	return ( False  , # 
	         0.0     )


def GetComponentWidth(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                                                                                                                           
		):
	'''
		Python: (BOOLEAN, width) = vs.GetComponentWidth(object, componentIndex)
		VectorScript: FUNCTION GetComponentWidth(object:HANDLE; componentIndex:INTEGER; VAR width:REAL) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the width of a component in an object.
	'''
	pass
	return ( False  , # 
	         0.0     )


def GetCompPenStylesN(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                                                                                                                           
		):
	'''
		Python: (BOOLEAN, leftPenStyle, rightPenStyle) = vs.GetCompPenStylesN(object, componentIndex)
		VectorScript: FUNCTION GetCompPenStylesN(object:HANDLE; componentIndex:INTEGER; VAR leftPenStyle:LONGINT; VAR rightPenStyle:LONGINT) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the pen styles of a component in an object.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0       )


def GetCompSecFillChgPt(
		object        , # HANDLE  - The object. Can be a roof face, roof, Roof Style, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                               
		):
	'''
		Python: (BOOLEAN, wallAssociatedSectionFillChangePoint) = vs.GetCompSecFillChgPt(object, componentIndex)
		VectorScript: FUNCTION GetCompSecFillChgPt(object:HANDLE; componentIndex:INTEGER; VAR wallAssociatedSectionFillChangePoint:INTEGER) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the wall associated section fill change point of a component in an object.
	'''
	pass
	return ( False  , # 
	         0       )


def GetCompTopIsRelStory(
		object        , # HANDLE  - The object. Can be a wall, round wall, Wall Style, or the Wall Preferences.
		componentIndex  # INTEGER - The index of the component.                                                
		):
	'''
		Python: (BOOLEAN, topIsRelativeToStory) = vs.GetCompTopIsRelStory(object, componentIndex)
		VectorScript: FUNCTION GetCompTopIsRelStory(object:HANDLE; componentIndex:INTEGER; VAR topIsRelativeToStory:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets whether or not the component top is relative to a story.
	'''
	pass
	return ( False  , # 
	         False   )


def GetCompUseClassASF(
		object        , # HANDLE  - The object. Can be a roof face, roof, Roof Style, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                               
		):
	'''
		Python: (BOOLEAN, useClassFillStyleForAlternateSectionFill) = vs.GetCompUseClassASF(object, componentIndex)
		VectorScript: FUNCTION GetCompUseClassASF(object:HANDLE; componentIndex:INTEGER; VAR useClassFillStyleForAlternateSectionFill:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the use class fill style for alternate section fill flag of a component in an object.
	'''
	pass
	return ( False  , # 
	         False   )


def GetCompUseClassASFCl(
		object        , # HANDLE  - The object. Can be a roof face, roof, Roof Style, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                               
		):
	'''
		Python: (BOOLEAN, useClassFillColorsForAlternateSectionFill) = vs.GetCompUseClassASFCl(object, componentIndex)
		VectorScript: FUNCTION GetCompUseClassASFCl(object:HANDLE; componentIndex:INTEGER; VAR useClassFillColorsForAlternateSectionFill:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the use class fill colors for alternate section fill flag of a component in an object.
	'''
	pass
	return ( False  , # 
	         False   )


def GetCompUseClassFCl(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                                                                                                                           
		):
	'''
		Python: (BOOLEAN, useClassFillColorsForFill) = vs.GetCompUseClassFCl(object, componentIndex)
		VectorScript: FUNCTION GetCompUseClassFCl(object:HANDLE; componentIndex:INTEGER; VAR useClassFillColorsForFill:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the use class fill colors for fill flag of a component in an object.
	'''
	pass
	return ( False  , # 
	         False   )


def GetCompUseClassFill(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                                                                                                                           
		):
	'''
		Python: (BOOLEAN, useClassFillStyleForFill) = vs.GetCompUseClassFill(object, componentIndex)
		VectorScript: FUNCTION GetCompUseClassFill(object:HANDLE; componentIndex:INTEGER; VAR useClassFillStyleForFill:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the use class fill style for fill flag of a component in an object.
	'''
	pass
	return ( False  , # 
	         False   )


def GetCompUseClassLPCl(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                                                                                                                           
		):
	'''
		Python: (BOOLEAN, useClassPenColorsForLeftPen) = vs.GetCompUseClassLPCl(object, componentIndex)
		VectorScript: FUNCTION GetCompUseClassLPCl(object:HANDLE; componentIndex:INTEGER; VAR useClassPenColorsForLeftPen:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the use class pen colors for left pen flag of a component in an object.
	'''
	pass
	return ( False  , # 
	         False   )


def GetCompUseClassLPS(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                                                                                                                           
		):
	'''
		Python: (BOOLEAN, useClassPenStyleForLeftPen) = vs.GetCompUseClassLPS(object, componentIndex)
		VectorScript: FUNCTION GetCompUseClassLPS(object:HANDLE; componentIndex:INTEGER; VAR useClassPenStyleForLeftPen:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the use class pen style for left pen flag of a component in an object.
	'''
	pass
	return ( False  , # 
	         False   )


def GetCompUseClassLPW(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                                                                                                                           
		):
	'''
		Python: (BOOLEAN, useClassPenWeightForLeftPen) = vs.GetCompUseClassLPW(object, componentIndex)
		VectorScript: FUNCTION GetCompUseClassLPW(object:HANDLE; componentIndex:INTEGER; VAR useClassPenWeightForLeftPen:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the use class pen weight for left pen flag of a component in an object.
	'''
	pass
	return ( False  , # 
	         False   )


def GetCompUseClassRPCl(
		object        , # HANDLE  - The object. Can be a wall, round wall, Wall Style, or the Wall Preferences.
		componentIndex  # INTEGER - The index of the component.                                                
		):
	'''
		Python: (BOOLEAN, useClassPenColorsForRightPen) = vs.GetCompUseClassRPCl(object, componentIndex)
		VectorScript: FUNCTION GetCompUseClassRPCl(object:HANDLE; componentIndex:INTEGER; VAR useClassPenColorsForRightPen:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the use class pen colors for right pen flag of a component in an object.
	'''
	pass
	return ( False  , # 
	         False   )


def GetCompUseClassRPS(
		object        , # HANDLE  - The object. Can be a wall, round wall, Wall Style, or the Wall Preferences.
		componentIndex  # INTEGER - The index of the component.                                                
		):
	'''
		Python: (BOOLEAN, useClassPenStyleForRightPen) = vs.GetCompUseClassRPS(object, componentIndex)
		VectorScript: FUNCTION GetCompUseClassRPS(object:HANDLE; componentIndex:INTEGER; VAR useClassPenStyleForRightPen:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the use class pen style for right pen flag of a component in an object.
	'''
	pass
	return ( False  , # 
	         False   )


def GetCompUseClassRPW(
		object        , # HANDLE  - The object. Can be a wall, round wall, Wall Style, or the Wall Preferences.
		componentIndex  # INTEGER - The index of the component.                                                
		):
	'''
		Python: (BOOLEAN, useClassPenWeightForRightPen) = vs.GetCompUseClassRPW(object, componentIndex)
		VectorScript: FUNCTION GetCompUseClassRPW(object:HANDLE; componentIndex:INTEGER; VAR useClassPenWeightForRightPen:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the use class pen weight for right pen flag of a component in an object.
	'''
	pass
	return ( False  , # 
	         False   )


def GetCompWallAssBound(
		object        , # HANDLE  - The object. Can be a roof face, roof, Roof Style, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                               
		):
	'''
		Python: (BOOLEAN, wallAssociatedBound) = vs.GetCompWallAssBound(object, componentIndex)
		VectorScript: FUNCTION GetCompWallAssBound(object:HANDLE; componentIndex:INTEGER; VAR wallAssociatedBound:INTEGER) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the wall associated bound of a component in an object.
	'''
	pass
	return ( False  , # 
	         0       )


def GetCompWallAssMod(
		object        , # HANDLE  - The object. Can be a roof face, roof, Roof Style, or the Roof Preferences.
		componentIndex  # INTEGER - The index of the component.                                               
		):
	'''
		Python: (BOOLEAN, wallAssociatedModification) = vs.GetCompWallAssMod(object, componentIndex)
		VectorScript: FUNCTION GetCompWallAssMod(object:HANDLE; componentIndex:INTEGER; VAR wallAssociatedModification:INTEGER) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the wall associated modification of a component in an object.
	'''
	pass
	return ( False  , # 
	         0       )


def GetControlData(
		dialogID, # LONGINT - Index of dialog layout containing the control item.
		itemID    # LONGINT - Index of the control item.                         
		):
	'''
		Python: data = vs.GetControlData(dialogID, itemID)
		VectorScript: PROCEDURE GetControlData(dialogID:LONGINT; itemID:LONGINT; VAR data:LONGINT);
		
		Category: Dialogs - Modern
		Returns information about the specified extended control item.
	'''
	pass
	return ( 0 )


def GetCoreWallComponent(
		object  # HANDLE - The object. Can be a wall, round wall, Wall Style, or the Wall Preferences.
		):
	'''
		Python: INTEGER = vs.GetCoreWallComponent(object)
		VectorScript: FUNCTION GetCoreWallComponent(object:HANDLE) : INTEGER;
		
		Category: Objects - Architectural
		Gets the core wall component of an object.
	'''
	pass
	return 'INTEGER' # The index of the core wall component.  If it is 0, there is no core wall component.


def GetCurrentLocalization(
		):
	'''
		Python: (language, subLanguage) = vs.GetCurrentLocalization()
		VectorScript: PROCEDURE GetCurrentLocalization(VAR language:STRING; VAR subLanguage:STRING);
		
		Category: Utility
		Get the Vectorworks language in the ISO 639-3 draft standard Language ID and sublanguage is unused and will be the empty string reserved for future use for a regional dialect.
		Currently this will always return the same language for a given installation of Vectorworks.
	'''
	pass
	return ( 'string', 
	         'string' )


def GetCurrentMode():
	'''
		Python: INTEGER = vs.GetCurrentMode()
		VectorScript: FUNCTION GetCurrentMode : INTEGER;
		
		Category: Utility
		Returns the current application protection mode.
		Return values:
		0 - Mode Not Set
		1 - Full Mode
		2 - Demo Mode
		4 - Education Mode
		8 - Student Mode
		16 - Viewer Mode
		32 - Unlicensed Mode
		64 - Banner Mode
		128 - Watermark New Files Mode
		256 - Print Watermark Mode
		512 - Save Educational File Format Mode
		1024 - Open Educational File Format Mode
		2048 - Vector Script Export Mode
		4096 - Beta Serial Number Mode
	'''
	pass
	return 'INTEGER' # 


def GetCurrentPlanarRefID():
	'''
		Python: LONGINT = vs.GetCurrentPlanarRefID()
		VectorScript: FUNCTION GetCurrentPlanarRefID : LONGINT;
		
		Category: Document Settings
		Return the current plane ref ID. This could be any plane: a working plane, screen plane (0), ground plane of a container, or any arbitrary plane.
	'''
	pass
	return 'LONGINT' # 


def GetCurrentUserId(
		):
	'''
		Python: (BOOLEAN, userid) = vs.GetCurrentUserId()
		VectorScript: FUNCTION GetCurrentUserId(VAR userid:STRING) : BOOLEAN;
		
		Category: Project Sharing
		Get the user id for the current user.
	'''
	pass
	return ( False   , # True on success, false on failure
	         'string' )


def GetCurtainWallCutPl(
		wall  # HANDLE - The wall.
		):
	'''
		Python: REAL = vs.GetCurtainWallCutPl(wall)
		VectorScript: FUNCTION GetCurtainWallCutPl(wall:HANDLE) : REAL;
		
		Category: Objects - Walls
		Gets the curtain wall cut plane of the wall.
	'''
	pass
	return 'REAL' # 


def GetCustomFeedback(
		ParametricHandle  # HANDLE - The parametric object to which the feedback group was added.
		):
	'''
		Python: (Boolean, FeedbackGroup) = vs.GetCustomFeedback(ParametricHandle)
		VectorScript: FUNCTION GetCustomFeedback(ParametricHandle:HANDLE; VAR FeedbackGroup:HANDLE) : Boolean;
		
		Category: Objects - Custom
		Gets the group of objects attached to a parametric used only for display on screen, this group will not export or print.
	'''
	pass
	return ( False  , # True if a feedback group was attached to the parametric, false if the object was not a parametric or a feedback group was not attached.
	         0       )


def GetCustomObjectChoice(
		objectName   , # STRING  - Name of the plugin object.        
		parameterName, # STRING  - String indicating which parameter.
		choiceIndex    # INTEGER - Index of desired choice.          
		):
	'''
		Python: STRING = vs.GetCustomObjectChoice(objectName, parameterName, choiceIndex)
		VectorScript: FUNCTION GetCustomObjectChoice(objectName:STRING; parameterName:STRING; choiceIndex:INTEGER) : STRING;
		
		Category: Objects - Custom
		Function GetCustomObjectChoice returns a choice string of the specified plug-in object popup menu or radio group parameter.  These parameters are displayed in the Object Info palette or the plug-in objects' creation dialog.
		The choiceIndex parameter should be passed an integer between 1 and the number of choices, which can be determined by calling the NumCustomObjectChoices function.
	'''
	pass
	return 'STRING' # Returns associated string of specified choice list item.


def GetCustomObjectColor(
		objectHand, # HANDLE  - Handle to object.
		inTagID     # INTEGER -                  
		):
	'''
		Python: (BOOLEAN, outColorIndex) = vs.GetCustomObjectColor(objectHand, inTagID)
		VectorScript: FUNCTION GetCustomObjectColor(objectHand:HANDLE; inTagID:INTEGER; VAR outColorIndex:INTEGER) : BOOLEAN;
		
		Category: Objects - Custom
		Get an auxilary color index stored in'objectHand' previously  with SetCustomObjectColor .  Aplication will preserve the color mapped to inTagID.
	'''
	pass
	return ( False  , # Returns TRUE if the operation was successful.
	         0       )


def GetCustomObjectInfo(
		):
	'''
		Python: (BOOLEAN, objectName, objectHand, recordHand, wallHand) = vs.GetCustomObjectInfo()
		VectorScript: FUNCTION GetCustomObjectInfo(VAR objectName:STRING; VAR objectHand:HANDLE; VAR recordHand:HANDLE; VAR wallHand:HANDLE) : BOOLEAN;
		
		Category: Objects - Custom
		Function GetCustomObjectInfo is used within plug-in object scripts to determine information about the object. Only returns false if the object is corrupt.
	'''
	pass
	return ( False   , # 
	         'string', 
	         0       , 
	         0       , 
	         0        )


def GetCustomObjectPath(
		objectHand  # HANDLE - Handle to object.
		):
	'''
		Python: HANDLE = vs.GetCustomObjectPath(objectHand)
		VectorScript: FUNCTION GetCustomObjectPath(objectHand:HANDLE) : HANDLE;
		
		Category: Objects - Custom
		Returns a handle to the path polygon of a path custom object.
	'''
	pass
	return 'HANDLE' # Returns a HANDLE to the path polygon.


def GetCustomObjectProfileGroup(
		objectHand  # HANDLE - Handle to path custom object.
		):
	'''
		Python: HANDLE = vs.GetCustomObjectProfileGroup(objectHand)
		VectorScript: FUNCTION GetCustomObjectProfileGroup(objectHand:HANDLE) : HANDLE;
		
		Category: Objects - Custom
		Returns a handle to the profile group of a path custom object.
		A path object has two "containers" for storing subordinate objects: the path, and the profile. As an example, if a path object is going to do an extrude along path, it will store the path in the path container, and the shape to be extruded in the profile container. The code within the object will then supply the handles to the path and the profile to the CreateExtrudeAlongPath call.
	'''
	pass
	return 'HANDLE' # Returns a HANDLE to the profile group.


def GetCustomObjectSelectionGroup(
		objectHand  # HANDLE - Handle to custom object.
		):
	'''
		Python: HANDLE = vs.GetCustomObjectSelectionGroup(objectHand)
		VectorScript: FUNCTION GetCustomObjectSelectionGroup(objectHand:HANDLE) : HANDLE;
		
		Category: Objects - Custom
		Access the handle to selection group. This group contains geometry that defines the selection and pre-selection indication of this object.
	'''
	pass
	return 'HANDLE' # Returns a HANDLE to the selection group.


def GetCustomObjectWallHoleGroup(
		objectHand  # HANDLE - Handle to custom object.
		):
	'''
		Python: HANDLE = vs.GetCustomObjectWallHoleGroup(objectHand)
		VectorScript: FUNCTION GetCustomObjectWallHoleGroup(objectHand:HANDLE) : HANDLE;
		
		Category: Objects - Custom
		Access the handle to wall hole group. This group contains geometry that defines the opening that will be cut into the wall for this parametric object.
	'''
	pass
	return 'HANDLE' # Returns a HANDLE to the wall hole group.


def GetCVis(
		clasName   # STRING - Name of class.
		):
	'''
		Python: INTEGER = vs.GetCVis(className)
		VectorScript: FUNCTION GetCVis(className:STRING) : INTEGER;
		
		Category: Classes
		Returns the visibility status of the specified class.
	'''
	pass
	return 'INTEGER' # [[note:ClassVisResultTable]][[BR]]


def GetCWFramesFromPt(
		hWall             , # HANDLE  - Handle to the curtain wall                                                                                         
		testPt            , # POINT   - Point to test on the curtian wall. Typically the center point of the object to be placed in the curtian wall panel.
		includeBottomFrame  # BOOLEAN - Include the bottom frame.                                                                                          
		):
	'''
		Python: (BOOLEAN, panelThickness, panelOffset, frameInsetTop, frameInsetBottom, frameInsetRight, frameInsetLeft) = vs.GetCWFramesFromPt(hWall, testPt, includeBottomFrame)
		VectorScript: FUNCTION GetCWFramesFromPt(hWall:HANDLE; testPt:REAL; includeBottomFrame:BOOLEAN; VAR panelThickness:REAL; VAR panelOffset:REAL; VAR frameInsetTop:REAL; VAR frameInsetBottom:REAL; VAR frameInsetRight:REAL; VAR frameInsetLeft:REAL) : BOOLEAN;
		
		Category: Objects - Walls
		Returns information about the frames  in a crutain wall from a given point.
		Used for placing objects inside a panel in a curtain wall. When passing the center point of the object in the wall, it will find the panel in the curtain wall and return information about the surrouding frames.
	'''
	pass
	return ( False  , # Returns TRUE if hWall is a crutain wall and frames are found.[[BR]]Returns FALSE is hWall is not a curtiain wall or the test point is not found on the wall.
	         0.0    , 
	         0.0    , 
	         0.0    , 
	         0.0    , 
	         0.0    , 
	         0.0     )


def GetCWidth(
		h  , # HANDLE  - Handle to worksheet.   
		row, # INTEGER - Worksheet row index.   
		col  # INTEGER - Worksheet column index.
		):
	'''
		Python: INTEGER = vs.GetCWidth(h, row, col)
		VectorScript: FUNCTION GetCWidth(h:HANDLE; row:INTEGER; col:INTEGER) : INTEGER;
		
		Category: Worksheets
		Function GetCWidth returns the column width of a cell in the referenced worksheet.
	'''
	pass
	return 'INTEGER' # 


def GetCWPanelFromPt(
		hWall             , # HANDLE  - Handle to the curtain wall                                                                                         
		testPt            , # POINT   - Point to test on the curtian wall. Typically the center point of the object to be placed in the curtian wall panel.
		includeBottomFrame  # BOOLEAN - Include the bottom frame in the return height.                                                                     
		):
	'''
		Python: (BOOLEAN, centerPt, width, height) = vs.GetCWPanelFromPt(hWall, testPt, includeBottomFrame)
		VectorScript: FUNCTION GetCWPanelFromPt(hWall:HANDLE; testPt:REAL; includeBottomFrame:BOOLEAN; VAR centerPt:REAL; VAR width:REAL; VAR height:REAL) : BOOLEAN;
		
		Category: Objects - Walls
		Returns information about a panel in a crutain wall from a given point.
		Used for placing objects inside a panel in a curtain wall. When passing the center point of the object in the wall, it will find the panel in the curtain wall and return a new center point and the height and width of the panel.
	'''
	pass
	return ( False  , # Returns TRUE if hWall is a crutain wall and a panel is found.[[BR]]Returns FALSE is hWall is not a curtiain wall or the test point is not found on the wall.
	         0,0    , 
	         0.0    , 
	         0.0     )


def GetDashDataValPairAt(
		dashStyleIndex, # INTEGER - The dash style index.        
		dataIndex       # INTEGER - Index fo the data value pair.
		):
	'''
		Python: (BOOLEAN, dash, gap) = vs.GetDashDataValPairAt(dashStyleIndex, dataIndex)
		VectorScript: FUNCTION GetDashDataValPairAt(dashStyleIndex:INTEGER; dataIndex:INTEGER; VAR dash:REAL; VAR gap:REAL) : BOOLEAN;
		
		Category: Document Attributes
		Deprecated - will generate error. Use GetDashDataValPrAtN instead.
	'''
	pass
	return ( False  , # 
	         0.0    , 
	         0.0     )


def GetDashDataValPrAtN(
		dashStyleIndex, # LONGINT - The negative value of the dash pattern's internal index.
		dataIndex       # INTEGER - Index of the data value pair.                           
		):
	'''
		Python: (BOOLEAN, dash, gap) = vs.GetDashDataValPrAtN(dashStyleIndex, dataIndex)
		VectorScript: FUNCTION GetDashDataValPrAtN(dashStyleIndex:LONGINT; dataIndex:INTEGER; VAR dash:REAL; VAR gap:REAL) : BOOLEAN;
		
		Category: Document Attributes
		Function GetDashDataValPrAtN gets the dash data for the specified dash style. The dash data is a dash/gap value pair. GetDashDataValPrAtN returns false if the dash style or dash data doesn't exist. Dash styles support up to 5 dash/gap value pairs.
	'''
	pass
	return ( False  , # 
	         0.0    , 
	         0.0     )


def GetDashFromPseudoInd(
		pseudoIndex  # INTEGER - Pseudo index (negative value)  for which a dash style is requested. 
		):
	'''
		Python: (BOOLEAN, outDashStyle) = vs.GetDashFromPseudoInd(pseudoIndex)
		VectorScript: FUNCTION GetDashFromPseudoInd(pseudoIndex:INTEGER; VAR outDashStyle:LONGINT) : BOOLEAN;
		
		Category: Utility
		Gets the dash style that corresponds to the pseudo index and returns the style's internal index. Returns TRUE if successful.
	'''
	pass
	return ( False  , # 
	         0       )


def GetDashLineTypeName(
		DashStyleIndex  # LONGINT - The negated internal index of the dash style.
		):
	'''
		Python: STRING = vs.GetDashLineTypeName(DashStyleIndex)
		VectorScript: FUNCTION GetDashLineTypeName(DashStyleIndex:LONGINT) : STRING;
		
		Category: Object Names
		Retrieves the dash style name for the specified dash style using its negated internal index.
	'''
	pass
	return 'STRING' # Name of the dash style specified by the index.


def GetDashStyle(
		swt     , # BOOLEAN -  
		numPairs, # INTEGER -  
		pair1   , # POINT   -  
		pair2   , # POINT   -  
		pair3   , # POINT   -  
		pair4   , # POINT   -  
		pair5     # POINT   -  
		):
	'''
		Python: INTEGER = vs.GetDashStyle(swt, numPairs, pair1, pair2, pair3, pair4, pair5)
		VectorScript: FUNCTION GetDashStyle(swt:BOOLEAN; numPairs:INTEGER; pair1DX, pair1DY:REAL; pair2DX, pair2DY:REAL; pair3DX, pair3DY:REAL; pair4DX, pair4DY:REAL; pair5DX, pair5DY:REAL) : INTEGER;
		
		Category: Document Attributes
		Deprecated - will generate error. Use GetDashStyleN instead.
	'''
	pass
	return 'INTEGER' # 


def GetDashStyleIndex(
		swt     , # BOOLEAN -  
		numPairs, # INTEGER -  
		pair1   , # POINT   -  
		pair2   , # POINT   -  
		pair3   , # POINT   -  
		pair4   , # POINT   -  
		pair5     # POINT   -  
		):
	'''
		Python: INTEGER = vs.GetDashStyleIndex(swt, numPairs, pair1, pair2, pair3, pair4, pair5)
		VectorScript: FUNCTION GetDashStyleIndex(swt:BOOLEAN; numPairs:INTEGER; pair1DX, pair1DY:REAL; pair2DX, pair2DY:REAL; pair3DX, pair3DY:REAL; pair4DX, pair4DY:REAL; pair5DX, pair5DY:REAL) : INTEGER;
		
		Category: Document Attributes
		Deprecated - will generate error. Use GetDashStyleIndexN instead.
	'''
	pass
	return 'INTEGER' # 


def GetDashStyleIndexN(
		swt     , # BOOLEAN -  
		numPairs, # INTEGER -  
		pair1   , # POINT   -  
		pair2   , # POINT   -  
		pair3   , # POINT   -  
		pair4   , # POINT   -  
		pair5     # POINT   -  
		):
	'''
		Python: LONGINT = vs.GetDashStyleIndexN(swt, numPairs, pair1, pair2, pair3, pair4, pair5)
		VectorScript: FUNCTION GetDashStyleIndexN(swt:BOOLEAN; numPairs:INTEGER; pair1DX, pair1DY:REAL; pair2DX, pair2DY:REAL; pair3DX, pair3DY:REAL; pair4DX, pair4DY:REAL; pair5DX, pair5DY:REAL) : LONGINT;
		
		Category: Document Attributes
		Function GetDashStyleIndexN searches for the pattern specified by the parameters. If it exists, then the negative value of the dash pattern's internal index is returned. If it does not exist, then it is added to the document and the negative value of the new dash pattern's internal index is returned.
	'''
	pass
	return 'LONGINT' # 


def GetDashStyleN(
		swt     , # BOOLEAN -  
		numPairs, # INTEGER -  
		pair1   , # POINT   -  
		pair2   , # POINT   -  
		pair3   , # POINT   -  
		pair4   , # POINT   -  
		pair5     # POINT   -  
		):
	'''
		Python: LONGINT = vs.GetDashStyleN(swt, numPairs, pair1, pair2, pair3, pair4, pair5)
		VectorScript: FUNCTION GetDashStyleN(swt:BOOLEAN; numPairs:INTEGER; pair1DX, pair1DY:REAL; pair2DX, pair2DY:REAL; pair3DX, pair3DY:REAL; pair4DX, pair4DY:REAL; pair5DX, pair5DY:REAL) : LONGINT;
		
		Category: Document Attributes
		Function GetDashStyleN searches for the pattern specified by the parameters. If it exists, then the negative value of the dash pattern's internal index is returned. If it does not exist, then it is added to the document and the negative value of the dash pattern's internal index is returned.
	'''
	pass
	return 'LONGINT' # 


def GetDashStyleName(
		DashStyleIndex  # INTEGER - The the index of the dash style.
		):
	'''
		Python: STRING = vs.GetDashStyleName(DashStyleIndex)
		VectorScript: FUNCTION GetDashStyleName(DashStyleIndex:INTEGER) : STRING;
		
		Category: Object Names
		Deprecated - will generate error. Use GetDashLineTypeName instead.
		Retrieves the dash style name of the specified dash style index.
	'''
	pass
	return 'STRING' # Name of the dash style specified by the index.


def GetDatumRoofComp(
		object  # HANDLE - The object. Can be a roof face, roof, Roof Style, or the Roof Preferences.
		):
	'''
		Python: INTEGER = vs.GetDatumRoofComp(object)
		VectorScript: FUNCTION GetDatumRoofComp(object:HANDLE) : INTEGER;
		
		Category: Objects - Architectural
		Gets the datum roof component of the object.
	'''
	pass
	return 'INTEGER' # The index of the datum roof component.


def GetDatumSlabComponent(
		object  # HANDLE - The object. Can be a slab, Slab Style, or the Slab Preferences.
		):
	'''
		Python: INTEGER = vs.GetDatumSlabComponent(object)
		VectorScript: FUNCTION GetDatumSlabComponent(object:HANDLE) : INTEGER;
		
		Category: Objects - Architectural
		Gets the datum slab component of an object.
	'''
	pass
	return 'INTEGER' # The index of the datum slab component.


def GetDefaultBeginningMarker(
		):
	'''
		Python: (BOOLEAN, style, angle, size, width, thicknessBasis, thickness, visibility) = vs.GetDefaultBeginningMarker()
		VectorScript: FUNCTION GetDefaultBeginningMarker(VAR style:LONGINT; VAR angle:INTEGER; VAR size:REAL; VAR width:REAL; VAR thicknessBasis:INTEGER; VAR thickness:REAL; VAR visibility:BOOLEAN) : BOOLEAN;
		
		Category: Document Attributes
		Gets all properties for the document default beginning marker. Return TRUE if operation was successful.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0      , 
	         0.0    , 
	         0.0    , 
	         0      , 
	         0.0    , 
	         False   )


def GetDefaultEndMarker(
		):
	'''
		Python: (BOOLEAN, style, angle, size, width, thicknessBasis, thickness, visibility) = vs.GetDefaultEndMarker()
		VectorScript: FUNCTION GetDefaultEndMarker(VAR style:LONGINT; VAR angle:INTEGER; VAR size:REAL; VAR width:REAL; VAR thicknessBasis:INTEGER; VAR thickness:REAL; VAR visibility:BOOLEAN) : BOOLEAN;
		
		Category: Document Attributes
		Gets all properties for the document default end marker. Return TRUE if operation was successful.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0      , 
	         0.0    , 
	         0.0    , 
	         0      , 
	         0.0    , 
	         False   )


def GetDefaultOpacity(
		):
	'''
		Python: opacity = vs.GetDefaultOpacity()
		VectorScript: PROCEDURE GetDefaultOpacity(VAR opacity:INTEGER);
		
		Category: Document Attributes
		Returns the default opacity.
	'''
	pass
	return ( 0 )


def GetDefaultOpacityN(
		):
	'''
		Python: (outPenOpacity, outFillOpacity) = vs.GetDefaultOpacityN()
		VectorScript: PROCEDURE GetDefaultOpacityN(VAR outPenOpacity:INTEGER; VAR outFillOpacity:INTEGER);
		
		Category: Document Attributes
	'''
	pass
	return ( 0, 
	         0 )


def GetDefaultTextSize():
	'''
		Python: REAL = vs.GetDefaultTextSize()
		VectorScript: FUNCTION GetDefaultTextSize : REAL;
		
		Category: Document Settings
		Function GetDefaultTextSize returns the default text size in points.
	'''
	pass
	return 'REAL' # 


def GetDefGenStoryBound(
		format  # HANDLE - Handle of the parametric's format
		):
	'''
		Python: (BOOLEAN, boundType, boundStory, layerLevelType, offset) = vs.GetDefGenStoryBound(format)
		VectorScript: FUNCTION GetDefGenStoryBound(format:HANDLE; VAR boundType:INTEGER; VAR boundStory:INTEGER; VAR layerLevelType:STRING; VAR offset:REAL) : BOOLEAN;
		
		Category: Objects - Architectural
		This will get the default story bound for a plugin that has the kObjXPropSupportGenericStoryLevel property.
		The bound information returned is only valid when the return value of the function is TRUE.
	'''
	pass
	return ( False   , # Returns TRUE if the default bounds were obtained; FALSE if the input format was not a format associated with a plugin that supports the generic PIO bound (i.e. has the kObjXPropSupportGenericStoryLevel property set).
	         0       , 
	         0       , 
	         'string', 
	         0.0      )


def GetDefOpacityByClsN(
		):
	'''
		Python: (outDefFillOpacityByClass, outDefPenOpacityByClass) = vs.GetDefOpacityByClsN()
		VectorScript: PROCEDURE GetDefOpacityByClsN(VAR outDefFillOpacityByClass:BOOLEAN; VAR outDefPenOpacityByClass:BOOLEAN);
		
		Category: Document Attributes
	'''
	pass
	return ( False, 
	         False )


def GetDescriptionText(
		hObject  # HANDLE - Handle of object for which to retrieve the text.
		):
	'''
		Python: descriptionText = vs.GetDescriptionText(hObject)
		VectorScript: PROCEDURE GetDescriptionText(hObject:HANDLE; VAR descriptionText:DYNARRAY of CHAR);
		
		Category: Object Attributes
		Retrieves any description text that exists for a specified object and passes it back in the descriptionText argument. The descriptionText argument will be empty if the object has no description text.
	'''
	pass
	return ( 'string' )


def GetDimText(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: STRING = vs.GetDimText(h)
		VectorScript: FUNCTION GetDimText(h:HANDLE) : STRING;
		
		Category: Dimensions
		Function GetDimText returns the dimension value displayed with the referenced object.
	'''
	pass
	return 'STRING' # 


def GetDisplayWith2DComp(
		objectHandle, # HANDLE  - 3D object handle.
		component     # INTEGER - 2D component.    
		):
	'''
		Python: BOOLEAN = vs.GetDisplayWith2DComp(objectHandle, component)
		VectorScript: FUNCTION GetDisplayWith2DComp(objectHandle:HANDLE; component:INTEGER) : BOOLEAN;
		
		Category: Objects - Custom
		Gets whether a 3D object in a symbol definition or plug-in object is shown when the specified 2D component is shown.
		Table - 2D components
		2D component			Constant
		Not Set			0
		Top			1
		Bottom			2
		Top and Bottom Cut	                3
		Front			4
		Back			5
		Front and Back Cut	                6
		Left			7
		Right			8
		Left and Right Cut	                9
	'''
	pass
	return 'BOOLEAN' # Returns whether a 3D object in a symbol definition or plug-in object is shown when the specified 2D component is shown.


def GetDLComponentClass(
		index  # INTEGER - The index of the component.
		):
	'''
		Python: (BOOLEAN, componentClass) = vs.GetDLComponentClass(index)
		VectorScript: FUNCTION GetDLComponentClass(index:INTEGER; VAR componentClass:LONGINT) : BOOLEAN;
		
		Category: Document Settings
		Gets the class of the component at index in the Double Line Preferences.
	'''
	pass
	return ( False  , # 
	         0       )


def GetDLComponentFill(
		index  # INTEGER - The index of the component.
		):
	'''
		Python: (BOOLEAN, fill) = vs.GetDLComponentFill(index)
		VectorScript: FUNCTION GetDLComponentFill(index:INTEGER; VAR fill:LONGINT) : BOOLEAN;
		
		Category: Document Settings
		Gets the fill of the component at index in the Double Line Preferences.
	'''
	pass
	return ( False  , # 
	         0       )


def GetDLComponentFillColors(
		index  # INTEGER - The index of the component.
		):
	'''
		Python: (BOOLEAN, fillForeColor, fillBackColor) = vs.GetDLComponentFillColors(index)
		VectorScript: FUNCTION GetDLComponentFillColors(index:INTEGER; VAR fillForeColor:INTEGER; VAR fillBackColor:INTEGER) : BOOLEAN;
		
		Category: Document Settings
		Gets the fore and back fill colors of the component at index in the Double Line Preferences.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0       )


def GetDLComponentName(
		index  # INTEGER - The index of the component.
		):
	'''
		Python: STRING = vs.GetDLComponentName(index)
		VectorScript: FUNCTION GetDLComponentName(index:INTEGER) : STRING;
		
		Category: Document Settings
		Gets the name of the component at index in the Double Line Preferences.
	'''
	pass
	return 'STRING' # The name of the component.


def GetDLComponentPenColors(
		index  # INTEGER - The index of the component.
		):
	'''
		Python: (BOOLEAN, leftPenForeColor, leftPenBackColor, rightPenForeColor, rightPenBackColor) = vs.GetDLComponentPenColors(index)
		VectorScript: FUNCTION GetDLComponentPenColors(index:INTEGER; VAR leftPenForeColor:INTEGER; VAR leftPenBackColor:INTEGER; VAR rightPenForeColor:INTEGER; VAR rightPenBackColor:INTEGER) : BOOLEAN;
		
		Category: Document Settings
		Gets the fore and back colors of the left and right side pens of the component at index in the Double Line Preferences.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0      , 
	         0      , 
	         0       )


def GetDLComponentPenStyles(
		index  # INTEGER - The index of the component.
		):
	'''
		Python: (BOOLEAN, penStyleLeft, penStyleRight) = vs.GetDLComponentPenStyles(index)
		VectorScript: FUNCTION GetDLComponentPenStyles(index:INTEGER; VAR penStyleLeft:INTEGER; VAR penStyleRight:INTEGER) : BOOLEAN;
		
		Category: Document Settings
		Deprecated - will generate error. Use GetDLCompPenStylesN instead.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0       )


def GetDLComponentPenWeights(
		index  # INTEGER - The index of the component.
		):
	'''
		Python: (BOOLEAN, penWeightLeft, penWeightRight) = vs.GetDLComponentPenWeights(index)
		VectorScript: FUNCTION GetDLComponentPenWeights(index:INTEGER; VAR penWeightLeft:INTEGER; VAR penWeightRight:INTEGER) : BOOLEAN;
		
		Category: Document Settings
		Gets the pen weights of the left and right sides of the component at index in the Double Line Preferences.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0       )


def GetDLComponentUseFillClassAttr(
		index  # INTEGER - The index of the component.
		):
	'''
		Python: (BOOLEAN, useClassAttr) = vs.GetDLComponentUseFillClassAttr(index)
		VectorScript: FUNCTION GetDLComponentUseFillClassAttr(index:INTEGER; VAR useClassAttr:BOOLEAN) : BOOLEAN;
		
		Category: Document Settings
		Gets the use fill class attributes flag of the component at index in the Double Line Preferences.
	'''
	pass
	return ( False  , # 
	         False   )


def GetDLComponentUsePenClassAttr(
		index  # INTEGER - The index of the component.
		):
	'''
		Python: (BOOLEAN, leftPenUseClassAttr, rightPenUseClassAttr) = vs.GetDLComponentUsePenClassAttr(index)
		VectorScript: FUNCTION GetDLComponentUsePenClassAttr(index:INTEGER; VAR leftPenUseClassAttr:BOOLEAN; VAR rightPenUseClassAttr:BOOLEAN) : BOOLEAN;
		
		Category: Document Settings
		Gets the useclass attributes flags of the left and right side pens of the component at index in the Double Line Preferences.
	'''
	pass
	return ( False  , # 
	         False  , 
	         False   )


def GetDLComponentWidth(
		index  # INTEGER - The index of the component.
		):
	'''
		Python: (BOOLEAN, width) = vs.GetDLComponentWidth(index)
		VectorScript: FUNCTION GetDLComponentWidth(index:INTEGER; VAR width:REAL) : BOOLEAN;
		
		Category: Document Settings
		Gets the width of the component at index in the Double Line Preferences.
	'''
	pass
	return ( False  , # 
	         0.0     )


def GetDLCompPenStylesN(
		index  # INTEGER - The index of the component.
		):
	'''
		Python: (BOOLEAN, penStyleLeft, penStyleRight) = vs.GetDLCompPenStylesN(index)
		VectorScript: FUNCTION GetDLCompPenStylesN(index:INTEGER; VAR penStyleLeft:LONGINT; VAR penStyleRight:LONGINT) : BOOLEAN;
		
		Category: Document Settings
		Gets the left and right side pen styles of the component at index in the Double Line Preferences.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0       )


def GetDLControlOffset():
	'''
		Python: REAL = vs.GetDLControlOffset()
		VectorScript: FUNCTION GetDLControlOffset : REAL;
		
		Category: Document Settings
		Gets the Double Line Preferences control offset.
	'''
	pass
	return 'REAL' # 


def GetDlgCtrlWidthStdCh(
		str  # DYNARRAY[] of CHAR - The string used to calculate the std character count.
		):
	'''
		Python: INTEGER = vs.GetDlgCtrlWidthStdCh(str)
		VectorScript: FUNCTION GetDlgCtrlWidthStdCh(str:DYNARRAY of CHAR) : INTEGER;
		
		Category: Dialogs - Modern
		Returns the width in standard characters for dialog control creation.
		The width is different than the number of symbols (Len) as in some languages (Japanese for example) the symbols are very different in size on the dialog.
		E.g. CreateStaticText
	'''
	pass
	return 'INTEGER' # Return the number of std characters in the input string.


def GetDLOptions():
	'''
		Python: INTEGER = vs.GetDLOptions()
		VectorScript: FUNCTION GetDLOptions : INTEGER;
		
		Category: Document Settings
		Gets the Double Line Preferences options.  0 for Create Lines, 1 for Create Polygons, 2 for Create Lines and Polygons.
	'''
	pass
	return 'INTEGER' # 


def GetDLSeparation():
	'''
		Python: REAL = vs.GetDLSeparation()
		VectorScript: FUNCTION GetDLSeparation : REAL;
		
		Category: Document Settings
		Gets the Double Line Preferences separation.
	'''
	pass
	return 'REAL' # 


def GetDocDrpShadowData(
		):
	'''
		Python: (bUseDropShadow, nUnits, dOffset, dBlurRadius, dAngle, nOpacity, colorRV, colorGV, colorBV) = vs.GetDocDrpShadowData()
		VectorScript: PROCEDURE GetDocDrpShadowData(VAR bUseDropShadow:BOOLEAN; VAR nUnits:INTEGER; VAR dOffset:REAL; VAR dBlurRadius:REAL; VAR dAngle:REAL; VAR nOpacity:INTEGER; VAR colorRV:INTEGER; VAR colorGV:INTEGER; VAR colorBV:INTEGER);
		
		Category: Document Attributes
	'''
	pass
	return ( False, 
	         0    , 
	         0.0  , 
	         0.0  , 
	         0.0  , 
	         0    , 
	         0    , 
	         0    , 
	         0     )


def GetDocumentDefaultSketchStyle():
	'''
		Python: STRING = vs.GetDocumentDefaultSketchStyle()
		VectorScript: FUNCTION GetDocumentDefaultSketchStyle : STRING;
		
		Category: Document Attributes
		Returns the document default sketch style.  Returns the string 'No Sketch' if the current sketch style is 'No Sketch'.
	'''
	pass
	return 'STRING' # 


def GetDormerAttributes(
		roofObject, # HANDLE  - Handle to roof.         
		dormerID    # INTEGER - Index of dormer element.
		):
	'''
		Python: (edgeIndex, cornerOffset, isPerpOffset, perpOrHeightOffset, symName, centerSymbol, symOffset) = vs.GetDormerAttributes(roofObject, dormerID)
		VectorScript: PROCEDURE GetDormerAttributes(roofObject:HANDLE; dormerID:INTEGER; VAR edgeIndex:INTEGER; VAR cornerOffset:REAL; VAR isPerpOffset:BOOLEAN; VAR perpOrHeightOffset:REAL; VAR symName:LONGINT; VAR centerSymbol:BOOLEAN; VAR symOffset:REAL);
		
		Category: Objects - Roofs
		Procedure GetDormerAttributes returns the attributes of a roof element in the referenced roof.
	'''
	pass
	return ( 0    , 
	         0.0  , 
	         False, 
	         0.0  , 
	         0    , 
	         False, 
	         0.0   )


def GetDormerThick(
		roofObject  # HANDLE - Handle to dormer.
		):
	'''
		Python: (wallThick, roofThick) = vs.GetDormerThick(roofObject)
		VectorScript: PROCEDURE GetDormerThick(roofObject:HANDLE; VAR wallThick:REAL; VAR roofThick:REAL);
		
		Category: Objects - Roofs
		Procedure GetDormerThick returns dormer roof and wall thicknesses for the referenced roof.
	'''
	pass
	return ( 0.0, 
	         0.0 )


def GetDrawingArea(
		):
	'''
		Python: (outDrawingArea, outIsOther, outIsOnePrintedPage) = vs.GetDrawingArea()
		VectorScript: PROCEDURE GetDrawingArea(VAR outDrawingArea:STRING; VAR outIsOther:BOOLEAN; VAR outIsOnePrintedPage:BOOLEAN);
		
		Category: Layers
		Gets the drawing area of the active layer, as in Page Setup dialog. If Other is selected returns an empty string as outDrawingArea and true for outIsOther.If One Printer Page is Selected, returns empty string for outDrawingArea and true for outIsOnePrinterPage. Otherwise, returns the drawing area name (ISO A3, US ARCH A, etc.)
	'''
	pass
	return ( 'string', 
	         False   , 
	         False    )


def GetDrawingSizeRect(
		):
	'''
		Python: (p1, p2) = vs.GetDrawingSizeRect()
		VectorScript: PROCEDURE GetDrawingSizeRect(VAR p1X, p1Y:REAL; VAR p2X, p2Y:REAL);
		
		Category: Document Settings
		Returns  the top left and bottom right coordinates of a rectangle surrounding the entire area of the document containing objects.
	'''
	pass
	return ( 0,0, 
	         0,0 )


def GetDrawingSizeRectN(
		hLayer  # HANDLE - The layer to be used for calculating the drawing rectangle.
		):
	'''
		Python: (p1, p2) = vs.GetDrawingSizeRectN(hLayer)
		VectorScript: PROCEDURE GetDrawingSizeRectN(hLayer:HANDLE; VAR p1X, p1Y:REAL; VAR p2X, p2Y:REAL);
		
		Category: Document Settings
		Returns the top left and bottom right coordinates of a rectangle surrounding the entire area of the document containing objects.
		Similar to GetDrawingSizeRect but can work on specified layer.
	'''
	pass
	return ( 0,0, 
	         0,0 )


def GetDropShadowByCls(
		H  # HANDLE -  
		):
	'''
		Python: BOOLEAN = vs.GetDropShadowByCls(H)
		VectorScript: FUNCTION GetDropShadowByCls(H:HANDLE) : BOOLEAN;
		
		Category: Object Attributes
	'''
	pass
	return 'BOOLEAN' # 


def GetDropShadowData(
		h  # HANDLE -  
		):
	'''
		Python: (BOOLEAN, nUnits, dOffset, dBlurRadius, dAngle, nOpacity, colorRV, colorGV, colorBV) = vs.GetDropShadowData(h)
		VectorScript: FUNCTION GetDropShadowData(h:HANDLE; VAR nUnits:INTEGER; VAR dOffset:REAL; VAR dBlurRadius:REAL; VAR dAngle:REAL; VAR nOpacity:INTEGER; VAR colorRV:INTEGER; VAR colorGV:INTEGER; VAR colorBV:INTEGER) : BOOLEAN;
		
		Category: Object Attributes
	'''
	pass
	return ( False  , # 
	         0      , 
	         0.0    , 
	         0.0    , 
	         0.0    , 
	         0      , 
	         0      , 
	         0      , 
	         0       )


def GetDXFColorToLW(
		dxfClrIndex  # INTEGER -  
		):
	'''
		Python: INTEGER = vs.GetDXFColorToLW(dxfClrIndex)
		VectorScript: FUNCTION GetDXFColorToLW(dxfClrIndex:INTEGER) : INTEGER;
		
		Category: ImportExport
		Get DXF color to lineweight
	'''
	pass
	return 'INTEGER' # 


def GetEditInteger(
		dialogID, # LONGINT - The index of the dialog layout containing the control.
		itemID    # LONGINT - The index of the control item.                        
		):
	'''
		Python: (BOOLEAN, value) = vs.GetEditInteger(dialogID, itemID)
		VectorScript: FUNCTION GetEditInteger(dialogID:LONGINT; itemID:LONGINT; VAR value:LONGINT) : BOOLEAN;
		
		Category: Dialogs - Modern
		Returns the numeric value from the specified INTEGER numeric edit field control.
	'''
	pass
	return ( False  , # A BOOLEAN value indicating the success of the operation.
	         0       )


def GetEditReal(
		dialogID    , # LONGINT - The index of the dialog layout containing the control.
		itemID      , # LONGINT - The index of the control item.                        
		editRealType  # LONGINT - The type of REAL value being returned.                
		):
	'''
		Python: (BOOLEAN, value) = vs.GetEditReal(dialogID, itemID, editRealType)
		VectorScript: FUNCTION GetEditReal(dialogID:LONGINT; itemID:LONGINT; editRealType:LONGINT; VAR value:REAL) : BOOLEAN;
		
		Category: Dialogs - Modern
		Returns the numeric value from the specified REAL numeric edit field control.
	'''
	pass
	return ( False  , # A BOOLEAN value indicating the success of the operation.
	         0.0     )


def GetElementValue(
		XMLHandle  , # LONGINT            -  
		elementPath  # DYNARRAY[] of CHAR -  
		):
	'''
		Python: (INTEGER, value) = vs.GetElementValue(XMLHandle, elementPath)
		VectorScript: FUNCTION GetElementValue(XMLHandle:LONGINT; elementPath:DYNARRAY of CHAR; VAR value:DYNARRAY of CHAR) : INTEGER;
		
		Category: XML
		Gets a value of an element, given a path.
	'''
	pass
	return ( 0       , # 
	         'string' )


def GetEnabledModules():
	'''
		Python: LONGINT = vs.GetEnabledModules()
		VectorScript: FUNCTION GetEnabledModules : LONGINT;
		
		Category: Utility
		Determines which combination of product modules are currently enabled.
		This function returns a LONGINT value which contains a bit for each possible product module.  If a module is enabled, then the corresponding bit will be set to 1.  If that module is disabled, then its bit will be 0.  The table below contains selectors that can be used to interpret the results of this function.  To determine if a module is enabled, do a bitwise "and" operation with the selector and the value returned by this function.  See the usage example below.
	'''
	pass
	return 'LONGINT' # A LONGINT bitfield value with a bit for each possible product module.


def GetEntityMatrix(
		objectHandle  # HANDLE - The object for which the matrix of its plane is being obtained.
		):
	'''
		Python: (BOOLEAN, offset, rotationXAngle, rotationYAngle, rotationZAngle) = vs.GetEntityMatrix(objectHandle)
		VectorScript: FUNCTION GetEntityMatrix(objectHandle:HANDLE; VAR offsetX, offsetY, offsetZ:REAL; VAR rotationXAngle:REAL; VAR rotationYAngle:REAL; VAR rotationZAngle:REAL) : BOOLEAN;
		
		Category: Object Attributes
		Gets the matrix of the plane for a planar object.
	'''
	pass
	return ( False  , # Returns true if the object passed is a planar object.
	         0,0,0  , 
	         0.0    , 
	         0.0    , 
	         0.0     )


def GetEvent():
	'''
		Python: LONGINT = vs.GetEvent()
		VectorScript: FUNCTION GetEvent : LONGINT;
		
		Category: Object Events
	'''
	pass
	return 'LONGINT' # 


def GetFile(
		):
	'''
		Python: fileName = vs.GetFile()
		VectorScript: PROCEDURE GetFile(VAR fileName:DYNARRAY of CHAR);
		
		Category: File I/O
		Procedure GetFile displays a standard file dialog which requests the user to select a text document.
		It is advisable to call DidCancel after using this procedure and check that the user did not cancel the file selection process.
	'''
	pass
	return ( 'string' )


def GetFileInfo(
		filename  # DYNARRAY[] of CHAR -  
		):
	'''
		Python: (fullReadPath, fullWritePath, readFileExists, writeFileExists, locked, hasReadPermission, hasWritePermission, hasFolderPermission) = vs.GetFileInfo(filename)
		VectorScript: PROCEDURE GetFileInfo(filename:DYNARRAY of CHAR; VAR fullReadPath:DYNARRAY of CHAR; VAR fullWritePath:DYNARRAY of CHAR; VAR readFileExists:BOOLEAN; VAR writeFileExists:BOOLEAN; VAR locked:BOOLEAN; VAR hasReadPermission:BOOLEAN; VAR hasWritePermission:BOOLEAN; VAR hasFolderPermission:BOOLEAN);
		
		Category: File I/O
		This function gets the attributes of a file.
	'''
	pass
	return ( 'string', 
	         'string', 
	         False   , 
	         False   , 
	         False   , 
	         False   , 
	         False   , 
	         False    )


def GetFileN(
		title        , # DYNARRAY[] of CHAR -  
		defaultFolder, # DYNARRAY[] of CHAR -  
		mask           # DYNARRAY[] of CHAR -  
		):
	'''
		Python: (BOOLEAN, fileName) = vs.GetFileN(title, defaultFolder, mask)
		VectorScript: FUNCTION GetFileN(title:DYNARRAY of CHAR; defaultFolder:DYNARRAY of CHAR; mask:DYNARRAY of CHAR; VAR fileName:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: File I/O
		Returns the fully-qualified pathname of the selected file.
	'''
	pass
	return ( False   , # 
	         'string' )


def GetFilesInFolder(
		folderName, # DYNARRAY[] of CHAR -  
		index       # LONGINT            -  
		):
	'''
		Python: DYNARRAY of CHAR = vs.GetFilesInFolder(folderName, index)
		VectorScript: FUNCTION GetFilesInFolder(folderName:DYNARRAY of CHAR; index:LONGINT) : DYNARRAY of CHAR;
		
		Category: File I/O
		Returns the Nth filename in a folder.
	'''
	pass
	return 'DYNARRAY[] of CHAR' # 


def GetFileSize(
		FilePath  # in/out STRING -  
		):
	'''
		Python: (LONGINT, FilePath) = vs.GetFileSize(FilePath)
		VectorScript: FUNCTION GetFileSize(VAR FilePath:STRING) : LONGINT;
		
		Category: File I/O
	'''
	pass
	return ( 0       , # Returns the size of a file in bytes.
	         'string' )


def GetFillBack(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: (red, green, blue) = vs.GetFillBack(h)
		VectorScript: PROCEDURE GetFillBack(h:HANDLE; VAR red:LONGINT; VAR green:LONGINT; VAR blue:LONGINT);
		
		Category: Object Attributes
		Procedure GetFillBack returns the fill background color of the referenced object. RGB values are in the range of 0 65535.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetFillFore(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: (red, green, blue) = vs.GetFillFore(h)
		VectorScript: PROCEDURE GetFillFore(h:HANDLE; VAR red:LONGINT; VAR green:LONGINT; VAR blue:LONGINT);
		
		Category: Object Attributes
		Procedure GetFillFore returns the fill foreground color of the referenced object. RGB values are in the range of 0 65535.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetFillIAxisEndPoint(
		objectHandle  # HANDLE - Handle to the object with fill.
		):
	'''
		Python: (xIAxisEndPoint, yIAxisEndPoint) = vs.GetFillIAxisEndPoint(objectHandle)
		VectorScript: PROCEDURE GetFillIAxisEndPoint(objectHandle:HANDLE; VAR xIAxisEndPoint:REAL; VAR yIAxisEndPoint:REAL);
		
		Category: Object Attributes
		Gets the I-axis end point of the fill.
		Note: only works with 2D objects that have a gradient or image fill.
	'''
	pass
	return ( 0.0, 
	         0.0 )


def GetFillJAxisEndPoint(
		objectHandle  # HANDLE - Handle to the object with fill.
		):
	'''
		Python: (xJAxisEndPoint, yJAxisEndPoint) = vs.GetFillJAxisEndPoint(objectHandle)
		VectorScript: PROCEDURE GetFillJAxisEndPoint(objectHandle:HANDLE; VAR xJAxisEndPoint:REAL; VAR yJAxisEndPoint:REAL);
		
		Category: Object Attributes
		Gets the J-axis end point of the fill.
		Note: only works with 2D objects that have a gradient or image fill.
	'''
	pass
	return ( 0.0, 
	         0.0 )


def GetFillOriginPoint(
		objectHandle  # HANDLE - Handle to the object with fill.
		):
	'''
		Python: (xOriginPoint, yOriginPoint) = vs.GetFillOriginPoint(objectHandle)
		VectorScript: PROCEDURE GetFillOriginPoint(objectHandle:HANDLE; VAR xOriginPoint:REAL; VAR yOriginPoint:REAL);
		
		Category: Object Attributes
		Gets the origin point of the fill.
		Note: only works with 2D objects that have a gradient or image fill.
	'''
	pass
	return ( 0.0, 
	         0.0 )


def GetFillPoints(
		objectHandle  # HANDLE - Handle to the object with fill.
		):
	'''
		Python: (xOriginPoint, yOriginPoint, xIAxisEndPoint, yIAxisEndPoint, xJAxisEndPoint, yJAxisEndPoint) = vs.GetFillPoints(objectHandle)
		VectorScript: PROCEDURE GetFillPoints(objectHandle:HANDLE; VAR xOriginPoint:REAL; VAR yOriginPoint:REAL; VAR xIAxisEndPoint:REAL; VAR yIAxisEndPoint:REAL; VAR xJAxisEndPoint:REAL; VAR yJAxisEndPoint:REAL);
		
		Category: Object Attributes
		Gets start and axis end points of the fill.
		Note: only works with 2D objects that have a gradient or image fill.
	'''
	pass
	return ( 0.0, 
	         0.0, 
	         0.0, 
	         0.0, 
	         0.0, 
	         0.0 )


def GetFillSpace(
		h    , # HANDLE  - Handle to the object containing the fill space.
		index  # INTEGER - Index of the fill space to be returned.        
		):
	'''
		Python: HANDLE = vs.GetFillSpace(h, index)
		VectorScript: FUNCTION GetFillSpace(h:HANDLE; index:INTEGER) : HANDLE;
		
		Category: Object Attributes
		Returns the handle of the index-th fill space in the specified object's aux list.
	'''
	pass
	return 'HANDLE' # Handle to the index-th fill space in h's aux list.


def GetFirstChild(
		XMLHandle  , # LONGINT            -  
		elementPath  # DYNARRAY[] of CHAR -  
		):
	'''
		Python: (INTEGER, value) = vs.GetFirstChild(XMLHandle, elementPath)
		VectorScript: FUNCTION GetFirstChild(XMLHandle:LONGINT; elementPath:DYNARRAY of CHAR; VAR value:DYNARRAY of CHAR) : INTEGER;
		
		Category: XML
		Returns first child of given element.
	'''
	pass
	return ( 0       , # 
	         'string' )


def GetFldFlag(
		h, # HANDLE  - Handle to record.            
		t  # INTEGER - Field index (range of 1 - n).
		):
	'''
		Python: INTEGER = vs.GetFldFlag(h, t)
		VectorScript: FUNCTION GetFldFlag(h:HANDLE; t:INTEGER) : INTEGER;
		
		Category: Database / Record
		Returns a number indicating the accuracy flag of a specified field in the referenced record.
	'''
	pass
	return 'INTEGER' # 


def GetFldName(
		h    , # HANDLE  - Handle to record.                                               
		index  # INTEGER - Number of field whose name will be returned (in a range of 1-n).
		):
	'''
		Python: STRING = vs.GetFldName(h, index)
		VectorScript: FUNCTION GetFldName(h:HANDLE; index:INTEGER) : STRING;
		
		Category: Database / Record
		Returns the name of the specified field in the referenced record.
	'''
	pass
	return 'STRING' # 


def GetFldType(
		h, # HANDLE  - Handle to record.            
		t  # INTEGER - Field index (range of 1 - n).
		):
	'''
		Python: INTEGER = vs.GetFldType(h, t)
		VectorScript: FUNCTION GetFldType(h:HANDLE; t:INTEGER) : INTEGER;
		
		Category: Database / Record
		Returns a constant indicating the data type of a specified field in the referenced record.
	'''
	pass
	return 'INTEGER' # 


def GetFName():
	'''
		Python: STRING = vs.GetFName()
		VectorScript: FUNCTION GetFName : STRING;
		
		Category: Document Settings
		Function GetFName returns the current file name of the active document.
	'''
	pass
	return 'STRING' # 


def GetFolder(
		promptStr  # STRING -  
		):
	'''
		Python: (INTEGER, directoryPath) = vs.GetFolder(promptStr)
		VectorScript: FUNCTION GetFolder(promptStr:STRING; VAR directoryPath:DYNARRAY of CHAR) : INTEGER;
		
		Category: File I/O
		Gets the path to a user selected folder
	'''
	pass
	return ( 0       , # 
	         'string' )


def GetFolderPath(
		whichPath  # INTEGER - Path constant.
		):
	'''
		Python: DYNARRAY of CHAR = vs.GetFolderPath(whichPath)
		VectorScript: FUNCTION GetFolderPath(whichPath:INTEGER) : DYNARRAY of CHAR;
		
		Category: File I/O
		Function GetFolderPath returns the full path to the requested folder independent of localized folder names.
	'''
	pass
	return 'DYNARRAY[] of CHAR' # 


def GetFontID(
		fontName  # STRING - Name of installed font.
		):
	'''
		Python: INTEGER = vs.GetFontID(fontName)
		VectorScript: FUNCTION GetFontID(fontName:STRING) : INTEGER;
		
		Category: Objects - Text
		Function GetFontID converts the string name of an available font to a font ID which can be passed to other VectorScript routines.
	'''
	pass
	return 'INTEGER' # 


def GetFontListSize():
	'''
		Python: INTEGER = vs.GetFontListSize()
		VectorScript: FUNCTION GetFontListSize : INTEGER;
		
		Category: Objects - Text
		Returns the number of available fonts on the local system.
	'''
	pass
	return 'INTEGER' # 


def GetFontName(
		fontID  # INTEGER - Font ID value.
		):
	'''
		Python: STRING = vs.GetFontName(fontID)
		VectorScript: FUNCTION GetFontName(fontID:INTEGER) : STRING;
		
		Category: Objects - Text
		Function GetFontName converts a system font ID to a font name.
	'''
	pass
	return 'STRING' # 


def GetFPat(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: LONGINT = vs.GetFPat(h)
		VectorScript: FUNCTION GetFPat(h:HANDLE) : LONGINT;
		
		Category: Object Attributes
		Function GetFPat returns the fill pattern of the referenced object.
		A positive value corresponds to the index of the fill pattern on the pattern palette. A negative value corresponds to internal index of a vector fill pattern applied to the object.
	'''
	pass
	return 'LONGINT' # 


def GetFPathName():
	'''
		Python: DYNARRAY of CHAR = vs.GetFPathName()
		VectorScript: FUNCTION GetFPathName : DYNARRAY of CHAR;
		
		Category: File I/O
		Returns the fully-qualified file path of the active document.
	'''
	pass
	return 'DYNARRAY[] of CHAR' # 


def GetGableAttributes(
		roofObject, # HANDLE  - Handle to roof.         
		dormerID    # INTEGER - Index of dormer element.
		):
	'''
		Python: (useHeight, heightDepth, bottomWidth, overhang, leftSlope, rightSlope) = vs.GetGableAttributes(roofObject, dormerID)
		VectorScript: PROCEDURE GetGableAttributes(roofObject:HANDLE; dormerID:INTEGER; VAR useHeight:BOOLEAN; VAR heightDepth:REAL; VAR bottomWidth:REAL; VAR overhang:REAL; VAR leftSlope:REAL; VAR rightSlope:REAL);
		
		Category: Objects - Roofs
		Procedure GetGableAttributes returns the attributes of a gable dormer in the referenced roof.
	'''
	pass
	return ( False, 
	         0.0  , 
	         0.0  , 
	         0.0  , 
	         0.0  , 
	         0.0   )


def GetGISOrigin(
		):
	'''
		Python: (BOOLEAN, outLat, outLon, outAngleToNorth) = vs.GetGISOrigin()
		VectorScript: FUNCTION GetGISOrigin(VAR outLat:REAL; VAR outLon:REAL; VAR outAngleToNorth:REAL) : BOOLEAN;
		
		Category: GIS
		Get geographical origin.
	'''
	pass
	return ( False  , # 
	         0.0    , 
	         0.0    , 
	         0.0     )


def GetGradientData(
		gradient    , # HANDLE  - Gradient that contains the segment.                                    
		segmentIndex  # INTEGER - Segment from which to get the data.[[BR]](segment indexes begin with 1)
		):
	'''
		Python: (spotPosition, midpointPosition, red, green, blue) = vs.GetGradientData(gradient, segmentIndex)
		VectorScript: PROCEDURE GetGradientData(gradient:HANDLE; segmentIndex:INTEGER; VAR spotPosition:REAL; VAR midpointPosition:REAL; VAR red:LONGINT; VAR green:LONGINT; VAR blue:LONGINT);
		
		Category: Document Attributes
		Gets the spot position, midpoint position and color of the specified gradient segment.
	'''
	pass
	return ( 0.0, 
	         0.0, 
	         0  , 
	         0  , 
	         0   )


def GetGradientDataN(
		gradient    , # HANDLE  - Gradient that contains the segment.
		segmentIndex  # INTEGER - Segment from which to get the data.
		):
	'''
		Python: (Boolean, spotPosition, midpointPosition, red, green, blue, opacity) = vs.GetGradientDataN(gradient, segmentIndex)
		VectorScript: PROCEDURE GetGradientDataN(gradient:HANDLE; segmentIndex:INTEGER; VAR spotPosition:REAL; VAR midpointPosition:REAL; VAR red:LONGINT; VAR green:LONGINT; VAR blue:LONGINT; VAR opacity:INTEGER);
		
		Category: Document Attributes
	'''
	pass
	return ( 0.0, 
	         0.0, 
	         0  , 
	         0  , 
	         0  , 
	         0   )


def GetGradientMidpointPosition(
		gradient    , # HANDLE  - Gradient that contains the segment.                                    
		segmentIndex  # INTEGER - Segment from which to get the data.[[BR]](segment indexes begin with 1)
		):
	'''
		Python: position = vs.GetGradientMidpointPosition(gradient, segmentIndex)
		VectorScript: PROCEDURE GetGradientMidpointPosition(gradient:HANDLE; segmentIndex:INTEGER; VAR position:REAL);
		
		Category: Document Attributes
		Gets the midpoint position of the specified gradient segment.
	'''
	pass
	return ( 0.0 )


def GetGradientOpacity(
		gradient    , # HANDLE  - Gradient that contains the segment.
		segmentIndex  # INTEGER - Segment from which to get the data.
		):
	'''
		Python: opacity = vs.GetGradientOpacity(gradient, segmentIndex)
		VectorScript: PROCEDURE GetGradientOpacity(gradient:HANDLE; segmentIndex:INTEGER; VAR opacity:INTEGER);
		
		Category: Document Attributes
	'''
	pass
	return ( 0 )


def GetGradientSlider(
		dialogID    , # LONGINT - Index to the dialog layout that contains the gradient slider component.
		componentID , # LONGINT - Index to a specific gradient slider component.                         
		segmentIndex  # INTEGER - Segment from which to get the data.                                    
		):
	'''
		Python: (spotPosition, midpointPosition, red, green, blue, opacity) = vs.GetGradientSlider(dialogID, componentID, segmentIndex)
		VectorScript: PROCEDURE GetGradientSlider(dialogID:LONGINT; componentID:LONGINT; segmentIndex:INTEGER; VAR spotPosition:REAL; VAR midpointPosition:REAL; VAR red:LONGINT; VAR green:LONGINT; VAR blue:LONGINT; VAR opacity:INTEGER);
		
		Category: Dialogs - Modern
	'''
	pass
	return ( 0.0, 
	         0.0, 
	         0  , 
	         0  , 
	         0  , 
	         0   )


def GetGradientSliderData(
		dialogID    , # LONGINT - Index to the dialog layout that contains the gradient slider component.
		componentID , # LONGINT - Index to a specific gradient slider component.                         
		segmentIndex  # INTEGER - Segment from which to get the data.[[BR]](segment indexes begin with 1)
		):
	'''
		Python: (spotPosition, midpointPosition, red, green, blue) = vs.GetGradientSliderData(dialogID, componentID, segmentIndex)
		VectorScript: PROCEDURE GetGradientSliderData(dialogID:LONGINT; componentID:LONGINT; segmentIndex:INTEGER; VAR spotPosition:REAL; VAR midpointPosition:REAL; VAR red:LONGINT; VAR green:LONGINT; VAR blue:LONGINT);
		
		Category: Dialogs - Modern
		Gets the spot position, midpoint position and color of the specified gradient slider segment.
	'''
	pass
	return ( 0.0, 
	         0.0, 
	         0  , 
	         0  , 
	         0   )


def GetGradientSliderSelectedMarker(
		dialogID   , # LONGINT - Index to the dialog layout that contains the gradient slider component.
		componentID  # LONGINT - Index to a specific gradient slider component.                         
		):
	'''
		Python: (segmentIndex, markerType) = vs.GetGradientSliderSelectedMarker(dialogID, componentID)
		VectorScript: PROCEDURE GetGradientSliderSelectedMarker(dialogID:LONGINT; componentID:LONGINT; VAR segmentIndex:INTEGER; VAR markerType:INTEGER);
		
		Category: Dialogs - Modern
		Gets the selected marker for the specified gradient slider.
		Note: use the number, 1, to identify a color marker and the number, 2, to identify a midpoint marker.
	'''
	pass
	return ( 0, 
	         0 )


def GetGradientSpotColor(
		gradient    , # HANDLE  - Gradient that contains the segment.                                    
		segmentIndex  # INTEGER - Segment from which to get the data.[[BR]](segment indexes begin with 1)
		):
	'''
		Python: (red, green, blue) = vs.GetGradientSpotColor(gradient, segmentIndex)
		VectorScript: PROCEDURE GetGradientSpotColor(gradient:HANDLE; segmentIndex:INTEGER; VAR red:LONGINT; VAR green:LONGINT; VAR blue:LONGINT);
		
		Category: Document Attributes
		Gets the spot color of the specified gradient segment.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetGradientSpotPosition(
		gradient    , # HANDLE  - Gradient that contains the segment.                                    
		segmentIndex  # INTEGER - Segment from which to get the data.[[BR]](segment indexes begin with 1)
		):
	'''
		Python: position = vs.GetGradientSpotPosition(gradient, segmentIndex)
		VectorScript: PROCEDURE GetGradientSpotPosition(gradient:HANDLE; segmentIndex:INTEGER; VAR position:REAL);
		
		Category: Document Attributes
		Gets the spot position of the specified gradient segment.
	'''
	pass
	return ( 0.0 )


def GetHipAttributes(
		roofObject, # HANDLE  - Handle to roof.         
		dormerID    # INTEGER - Index of dormer element.
		):
	'''
		Python: (useHeight, heightDepth, bottomWidth, overhang, leftSlope, rightSlope, frontSlope) = vs.GetHipAttributes(roofObject, dormerID)
		VectorScript: PROCEDURE GetHipAttributes(roofObject:HANDLE; dormerID:INTEGER; VAR useHeight:BOOLEAN; VAR heightDepth:REAL; VAR bottomWidth:REAL; VAR overhang:REAL; VAR leftSlope:REAL; VAR rightSlope:REAL; VAR frontSlope:REAL);
		
		Category: Objects - Roofs
		Procedure GetHipAttributes returns the attributes of a hip dormer in the referenced roof.
	'''
	pass
	return ( False, 
	         0.0  , 
	         0.0  , 
	         0.0  , 
	         0.0  , 
	         0.0  , 
	         0.0   )


def GetHLLineStyle(
		HLOptionsHandle  # HANDLE -  
		):
	'''
		Python: lineStyle = vs.GetHLLineStyle(HLOptionsHandle)
		VectorScript: PROCEDURE GetHLLineStyle(HLOptionsHandle:HANDLE; VAR lineStyle:INTEGER);
		
		Category: View / Zoom
		Gets the Line Style of the specified Hidden Line Rendering options handle.
	'''
	pass
	return ( 0 )


def GetHole(
		inOutsidePolyline, # HANDLE  - Handle to polyline.                         
		inIndex            # INTEGER - Index number of opening definition polyline.
		):
	'''
		Python: (BOOLEAN, outHole) = vs.GetHole(inOutsidePolyline, inIndex)
		VectorScript: FUNCTION GetHole(inOutsidePolyline:HANDLE; inIndex:INTEGER; VAR outHole:HANDLE) : BOOLEAN;
		
		Category: Objects - Polys
		Returns a handle to a polyline defining an opening within the referenced polyline.
		The definition polyline can be edited or queried using the standard VectorScript polyline API functions.
	'''
	pass
	return ( False  , # Returns TRUE if the polyline contains openings, otherwise returns FALSE.
	         0       )


def GetIconPushButtonState(
		nDialogID   , # LONGINT -  
		nComponentID  # LONGINT -  
		):
	'''
		Python: (BOOLEAN, bPressed) = vs.GetIconPushButtonState(nDialogID, nComponentID)
		VectorScript: FUNCTION GetIconPushButtonState(nDialogID:LONGINT; nComponentID:LONGINT; VAR bPressed:BOOLEAN) : BOOLEAN;
		
		Category: Dialogs - Modern
		Retrieves the state of the specified Layout Manager icon push button (pressed or not pressed).
	'''
	pass
	return ( False  , # 
	         False   )


def GetImageCropObject(
		object  # HANDLE -  
		):
	'''
		Python: HANDLE = vs.GetImageCropObject(object)
		VectorScript: FUNCTION GetImageCropObject(object:HANDLE) : HANDLE;
		
		Category: Textures
		Get the crop of a cropped image.
	'''
	pass
	return 'HANDLE' # Returns the handle of the cropper of the image.


def GetImagePopupObject(
		dialogID   , # LONGINT - Index to the dialog layout that contains the image popup component.
		componentID, # LONGINT - Index to a specific image popup component.                         
		itemIndex    # INTEGER - Image popup item index for object to be retrieved.                 
		):
	'''
		Python: STRING = vs.GetImagePopupObject(dialogID, componentID, itemIndex)
		VectorScript: FUNCTION GetImagePopupObject(dialogID:LONGINT; componentID:LONGINT; itemIndex:INTEGER) : STRING;
		
		Category: Dialogs - Modern
		Returns the object name for the specified image popup item.
	'''
	pass
	return 'STRING' # Returns name of object stored at specified image popup index.


def GetImagePopupObjectItemIndex(
		dialogID   , # LONGINT - Index to the dialog layout that contains the image popup component.
		componentID, # LONGINT - Index to a specific image popup component.                         
		objectName   # STRING  - Name of object for which the image popup index should be retrieved.
		):
	'''
		Python: INTEGER = vs.GetImagePopupObjectItemIndex(dialogID, componentID, objectName)
		VectorScript: FUNCTION GetImagePopupObjectItemIndex(dialogID:LONGINT; componentID:LONGINT; objectName:STRING) : INTEGER;
		
		Category: Dialogs - Modern
		Returns item index for the specified object.
	'''
	pass
	return 'INTEGER' # Returns the image popup index for the specified object.


def GetImagePopupSelectedItem(
		dialogID   , # LONGINT - Index to the dialog layout that contains the image popup component.
		componentID  # LONGINT - Index to a specific image popup component.                         
		):
	'''
		Python: INTEGER = vs.GetImagePopupSelectedItem(dialogID, componentID)
		VectorScript: FUNCTION GetImagePopupSelectedItem(dialogID:LONGINT; componentID:LONGINT) : INTEGER;
		
		Category: Dialogs - Modern
		Gets the selected image popup item.
	'''
	pass
	return 'INTEGER' # Returns the image popup index for the currently selected item.


def GetItemText(
		dialogID   , # LONGINT - the dialog identifier given by CreateLayout or CreateResizableLayout 
		componentID  # LONGINT - The identifier of the component that the text will be retrieved from.
		):
	'''
		Python: text = vs.GetItemText(dialogID, componentID)
		VectorScript: PROCEDURE GetItemText(dialogID:LONGINT; componentID:LONGINT; VAR text:STRING);
		
		Category: Dialogs - Modern
		Gets the text that is contained in the given componentID.
	'''
	pass
	return ( 'string' )


def GetKeyDown(
		):
	'''
		Python: asciiCode = vs.GetKeyDown()
		VectorScript: PROCEDURE GetKeyDown(VAR asciiCode:LONGINT);
		
		Category: User Interactive
		Procedure GetKeyDown pauses execution of a VectorScript routine until a key is pressed by the user. When the key is pressed, the ASCII code of the key is returned.
	'''
	pass
	return ( 0 )


def GetLastDXFImportOpt(
		selector, # INTEGER   -  
		value     # PROCEDURE -  
		):
	'''
		Python: BOOLEAN = vs.GetLastDXFImportOpt(selector, value)
		VectorScript: FUNCTION GetLastDXFImportOpt(selector:INTEGER; value:PROCEDURE) : BOOLEAN;
		
		Category: ImportExport
		Get Last Used DXF Import Settings
	'''
	pass
	return 'BOOLEAN' # 


def GetLastFileErr():
	'''
		Python: INTEGER = vs.GetLastFileErr()
		VectorScript: FUNCTION GetLastFileErr : INTEGER;
		
		Category: File I/O
		Returns an error code indicating whether an error occured during a file operation.
		This function should be called after file I/O calls such as Open() or Rewrite().
	'''
	pass
	return 'INTEGER' # 


def GetLayer(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: HANDLE = vs.GetLayer(h)
		VectorScript: FUNCTION GetLayer(h:HANDLE) : HANDLE;
		
		Category: Layers
		Function GetLayer returns a handle to the layer of the referenced object.
	'''
	pass
	return 'HANDLE' # 


def GetLayerAmbientColor(
		layer  # HANDLE - Handle to layer.
		):
	'''
		Python: (red, green, blue) = vs.GetLayerAmbientColor(layer)
		VectorScript: PROCEDURE GetLayerAmbientColor(layer:HANDLE; VAR red:LONGINT; VAR green:LONGINT; VAR blue:LONGINT);
		
		Category: Objects - Lights
		Procedure GetLayerAmbientColor returns the color of the ambient light of the referenced layer. RGB values are in the range of 0 65535.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetLayerAmbientInfo(
		layer  # HANDLE - Handle to layer.
		):
	'''
		Python: (isOn, brightness) = vs.GetLayerAmbientInfo(layer)
		VectorScript: PROCEDURE GetLayerAmbientInfo(layer:HANDLE; VAR isOn:BOOLEAN; VAR brightness:INTEGER);
		
		Category: Objects - Lights
		Procedure GetLayerAmbientInfo returns the attribute values for the ambient light object of the referenced layer.
	'''
	pass
	return ( False, 
	         0     )


def GetLayerByName(
		layerName  # STRING - Name of layer.
		):
	'''
		Python: HANDLE = vs.GetLayerByName(layerName)
		VectorScript: FUNCTION GetLayerByName(layerName:STRING) : HANDLE;
		
		Category: Layers
		Returns a handle to the specified layer.
	'''
	pass
	return 'HANDLE' # Returns a HANDLE to the layer.


def GetLayerCutPlane(
		layer  # HANDLE - The layer.
		):
	'''
		Python: REAL = vs.GetLayerCutPlane(layer)
		VectorScript: FUNCTION GetLayerCutPlane(layer:HANDLE) : REAL;
		
		Category: Layers
		Gets the cut plane of the layer.
	'''
	pass
	return 'REAL' # The cut plane of the layer.


def GetLayerDeltaZOffset(
		theWall  # HANDLE - The wall.
		):
	'''
		Python: REAL = vs.GetLayerDeltaZOffset(theWall)
		VectorScript: FUNCTION GetLayerDeltaZOffset(theWall:HANDLE) : REAL;
		
		Category: Objects - Walls
		Returns the wall height's offset to the layer delta z.
	'''
	pass
	return 'REAL' # 


def GetLayerElevation(
		h  # HANDLE - Handle to the layer
		):
	'''
		Python: (baseElev, thickness) = vs.GetLayerElevation(h)
		VectorScript: PROCEDURE GetLayerElevation(h:HANDLE; VAR baseElev:REAL; VAR thickness:REAL);
		
		Category: Layers
		Gets the elevation and thickness of the specified layer.
	'''
	pass
	return ( 0.0, 
	         0.0 )


def GetLayerEnableCutPl(
		layer  # HANDLE - The layer.
		):
	'''
		Python: BOOLEAN = vs.GetLayerEnableCutPl(layer)
		VectorScript: FUNCTION GetLayerEnableCutPl(layer:HANDLE) : BOOLEAN;
		
		Category: Layers
		Gets whether the cut plane of the layer is enabled.
	'''
	pass
	return 'BOOLEAN' # Whether the cut plane of the layer is enabled.


def GetLayerForStory(
		story    , # HANDLE - The Story for which the will be looked up for level types.           
		levelType  # STRING - The level type of the story, which associated layer will be returned.
		):
	'''
		Python: HANDLE = vs.GetLayerForStory(story, levelType)
		VectorScript: FUNCTION GetLayerForStory(story:HANDLE; levelType:STRING) : HANDLE;
		
		Category: Layers
		Gets the layer with the story and layer level type specified.
	'''
	pass
	return 'HANDLE' # The Layer associated with the Story and layer level specified, which may be NULL.


def GetLayerLevelType(
		layer  # HANDLE - The Layer whose Layer Level Type is desired.
		):
	'''
		Python: STRING = vs.GetLayerLevelType(layer)
		VectorScript: FUNCTION GetLayerLevelType(layer:HANDLE) : STRING;
		
		Category: Layers
		Returns the Layer Level Type of the Layer.
	'''
	pass
	return 'STRING' # The Layer Level Type of the Layer.


def GetLayerOptions():
	'''
		Python: INTEGER = vs.GetLayerOptions()
		VectorScript: FUNCTION GetLayerOptions : INTEGER;
		
		Category: Layers
		Returns layer visibility setting for the active document.
	'''
	pass
	return 'INTEGER' # Returns an INTEGER indicating the layer visibility status of the document.


def GetLayerProjectInfo(
		layer  # HANDLE - Get status for this Layer
		):
	'''
		Python: (BOOLEAN, masterLayer, modificationDate, checkoutDate, checkoutOwner, workingFileId, comment, outOfDate) = vs.GetLayerProjectInfo(layer)
		VectorScript: FUNCTION GetLayerProjectInfo(layer:HANDLE; VAR masterLayer:BOOLEAN; VAR modificationDate:LONGINT; VAR checkoutDate:LONGINT; VAR checkoutOwner:STRING; VAR workingFileId:STRING; VAR comment:STRING; VAR outOfDate:BOOLEAN) : BOOLEAN;
		
		Category: Project Sharing
		Retrieves values similar to the Layers tab of the Project Sharing dialog.
		Timestamps are measured in seconds since January 1, 1904.  The value 0 has special meaning depending on the timestamp.
	'''
	pass
	return ( False   , # True on success, false on failure or not Project Sharing file.
	         False   , 
	         0       , 
	         0       , 
	         'string', 
	         'string', 
	         'string', 
	         False    )


def GetLayerRenderMode(
		theLayer  # HANDLE -  
		):
	'''
		Python: INTEGER = vs.GetLayerRenderMode(theLayer)
		VectorScript: FUNCTION GetLayerRenderMode(theLayer:HANDLE) : INTEGER;
		
		Category: Layers
		Returns the render mode for the referenced layer.
	'''
	pass
	return 'INTEGER' # 


def GetLayerTransparency():
	'''
		Python: REAL = vs.GetLayerTransparency()
		VectorScript: FUNCTION GetLayerTransparency : REAL;
		
		Category: Layers
		Return the tranparency of the current layer.
	'''
	pass
	return 'REAL' # 


def GetLayoutDialogPosition(
		dialogID  # LONGINT - Index of the dialog.
		):
	'''
		Python: (BOOLEAN, left, top, right, bottom) = vs.GetLayoutDialogPosition(dialogID)
		VectorScript: FUNCTION GetLayoutDialogPosition(dialogID:LONGINT; VAR left:INTEGER; VAR top:INTEGER; VAR right:INTEGER; VAR bottom:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern
		This function will retrieve the screen location of the dialog window, in pixels.
		This function can be useful for displaying a dialog in a position in which it was placed during prior use.
	'''
	pass
	return ( False  , # true - success - the location of the dialog window was retrieved.[[BR]]false - failure - the location of the dialog window was not retrieved, likely because it does not currently exist, or the dialogID is invalid.  The dialog window will exist anytime between the Setup message and OK/Cancel message.
	         0      , 
	         0      , 
	         0      , 
	         0       )


def GetLayoutDialogSize(
		dialogID  # LONGINT -  
		):
	'''
		Python: (width, height) = vs.GetLayoutDialogSize(dialogID)
		VectorScript: PROCEDURE GetLayoutDialogSize(dialogID:LONGINT; VAR width:INTEGER; VAR height:INTEGER);
		
		Category: Dialogs - Modern
		Retrieves a Layout Manager dialog's size, in pixels.
	'''
	pass
	return ( 0, 
	         0 )


def GetLBColumnDataItemInfo(
		dialogID           , # LONGINT - id of the dialog that contains the list browser
		componentID        , # LONGINT - id of the list browser control                 
		columnIndex        , # INTEGER - the column from which to get the data          
		columnDataItemIndex  # INTEGER - the column data item                           
		):
	'''
		Python: (BOOLEAN, itemString, imageOn, imageOff, itemData) = vs.GetLBColumnDataItemInfo(dialogID, componentID, columnIndex, columnDataItemIndex)
		VectorScript: FUNCTION GetLBColumnDataItemInfo(dialogID:LONGINT; componentID:LONGINT; columnIndex:INTEGER; columnDataItemIndex:INTEGER; VAR itemString:STRING; VAR imageOn:INTEGER; VAR imageOff:INTEGER; VAR itemData:LONGINT) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Gets the specified column data item's text, image and user data.
	'''
	pass
	return ( False   , # 
	         'string', 
	         0       , 
	         0       , 
	         0        )


def GetLBColumnHeaderJust(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID, # LONGINT - id of the list browser control                 
		columnIndex  # INTEGER - the column index                               
		):
	'''
		Python: (BOOLEAN, justification) = vs.GetLBColumnHeaderJust(dialogID, componentID, columnIndex)
		VectorScript: FUNCTION GetLBColumnHeaderJust(dialogID:LONGINT; componentID:LONGINT; columnIndex:INTEGER; VAR justification:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Retrieves the specified column header's justification.
	'''
	pass
	return ( False  , # 
	         0       )


def GetLBColumnHeaderToolTip(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID, # LONGINT - id of the list browser control                 
		columnIndex  # INTEGER - the column index                               
		):
	'''
		Python: (BOOLEAN, toolTipPrimaryText, toolTipSubText) = vs.GetLBColumnHeaderToolTip(dialogID, componentID, columnIndex)
		VectorScript: FUNCTION GetLBColumnHeaderToolTip(dialogID:LONGINT; componentID:LONGINT; columnIndex:INTEGER; VAR toolTipPrimaryText:STRING; VAR toolTipSubText:STRING) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Gets the list browser column header's tooltip text.
	'''
	pass
	return ( False   , # 
	         'string', 
	         'string' )


def GetLBColumnOwnerDrawnType(
		dialogID    , # LONGINT - id of the dialog that contains the list browser
		componentID , # LONGINT - id of the list browser control                 
		itemIndex   , # INTEGER - the row index                                  
		subItemIndex  # INTEGER - the column index                               
		):
	'''
		Python: (BOOLEAN, ownerDrawnType) = vs.GetLBColumnOwnerDrawnType(dialogID, componentID, itemIndex, subItemIndex)
		VectorScript: FUNCTION GetLBColumnOwnerDrawnType(dialogID:LONGINT; componentID:LONGINT; itemIndex:INTEGER; subItemIndex:INTEGER; VAR ownerDrawnType:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Gets the list browser column's owner drawn type.
	'''
	pass
	return ( False  , # 
	         0       )


def GetLBColumnSortState(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID, # LONGINT - id of the list browser control                 
		columnIndex  # INTEGER - the column index                               
		):
	'''
		Python: INTEGER = vs.GetLBColumnSortState(dialogID, componentID, columnIndex)
		VectorScript: FUNCTION GetLBColumnSortState(dialogID:LONGINT; componentID:LONGINT; columnIndex:INTEGER) : INTEGER;
		
		Category: Dialogs - Modern - Browser
		Gets the column sort state.
	'''
	pass
	return 'INTEGER' # 


def GetLBColumnWidth(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID, # LONGINT - id of the list browser control                 
		columnIndex  # INTEGER - the column from which to get the width         
		):
	'''
		Python: (BOOLEAN, width) = vs.GetLBColumnWidth(dialogID, componentID, columnIndex)
		VectorScript: FUNCTION GetLBColumnWidth(dialogID:LONGINT; componentID:LONGINT; columnIndex:INTEGER; VAR width:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Gets the width of the specified column in the specified list browser control.
	'''
	pass
	return ( False  , # 
	         0       )


def GetLBControlType(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID, # LONGINT - id of the list browser control                 
		columnIndex  # INTEGER - the index of the column                        
		):
	'''
		Python: INTEGER = vs.GetLBControlType(dialogID, componentID, columnIndex)
		VectorScript: FUNCTION GetLBControlType(dialogID:LONGINT; componentID:LONGINT; columnIndex:INTEGER) : INTEGER;
		
		Category: Dialogs - Modern - Browser
		Gets control type for column.
	'''
	pass
	return 'INTEGER' # 


def GetLBEditDisplayType(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID, # LONGINT - id of the list browser control                 
		columnIndex  # INTEGER - the index of the column                        
		):
	'''
		Python: INTEGER = vs.GetLBEditDisplayType(dialogID, componentID, columnIndex)
		VectorScript: FUNCTION GetLBEditDisplayType(dialogID:LONGINT; componentID:LONGINT; columnIndex:INTEGER) : INTEGER;
		
		Category: Dialogs - Modern - Browser
		Gets edit display type for list items in specified column.
	'''
	pass
	return 'INTEGER' # 


def GetLBEventInfo(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID  # LONGINT - id of the list browser control                 
		):
	'''
		Python: (BOOLEAN, eventType, rowIndex, columIndex) = vs.GetLBEventInfo(dialogID, componentID)
		VectorScript: FUNCTION GetLBEventInfo(dialogID:LONGINT; componentID:LONGINT; VAR eventType:INTEGER; VAR rowIndex:INTEGER; VAR columIndex:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Retrieves the last event information for the specified list browser.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0      , 
	         0       )


def GetLBHeaderTextWidth(
		clasName        , # STRING  -  
		allowForSortIcon  # BOOLEAN -  
		):
	'''
		Python: INTEGER = vs.GetLBHeaderTextWidth(className, allowForSortIcon)
		VectorScript: FUNCTION GetLBHeaderTextWidth(className:STRING; allowForSortIcon:BOOLEAN) : INTEGER;
		
		Category: Dialogs - Modern
		Produces the width in pixels that will show the given string without truncation in a listbrowser column header.  This will provide a guaranteed appropriate width for InsertLBColumn.
	'''
	pass
	return 'INTEGER' # 


def GetLBItemDashStyle(
		dialogID    , # LONGINT - id of the dialog that contains the list browser
		componentID , # LONGINT - id of the list browser control                 
		itemIndex   , # INTEGER - the row index                                  
		subItemIndex  # INTEGER - the column index                               
		):
	'''
		Python: (BOOLEAN, styleIndex, lineWeight) = vs.GetLBItemDashStyle(dialogID, componentID, itemIndex, subItemIndex)
		VectorScript: FUNCTION GetLBItemDashStyle(dialogID:LONGINT; componentID:LONGINT; itemIndex:INTEGER; subItemIndex:INTEGER; VAR styleIndex:INTEGER; VAR lineWeight:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Deprecated - will generate error. Use GetLBItemLineType instead.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0       )


def GetLBItemData(
		nDialogID    , # LONGINT -  
		nComponentID , # LONGINT -  
		nItemIndex   , # INTEGER -  
		nSubItemIndex  # INTEGER -  
		):
	'''
		Python: nUserData = vs.GetLBItemData(nDialogID, nComponentID, nItemIndex, nSubItemIndex)
		VectorScript: PROCEDURE GetLBItemData(nDialogID:LONGINT; nComponentID:LONGINT; nItemIndex:INTEGER; nSubItemIndex:INTEGER; VAR nUserData:LONGINT);
		
		Category: Dialogs - Modern - Browser
		Retrieves the user data associated with the list browser item.
	'''
	pass
	return ( 0 )


def GetLBItemDisplayType(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID, # LONGINT - id of the list browser control                 
		columnIndex  # INTEGER - the index of the column                        
		):
	'''
		Python: INTEGER = vs.GetLBItemDisplayType(dialogID, componentID, columnIndex)
		VectorScript: FUNCTION GetLBItemDisplayType(dialogID:LONGINT; componentID:LONGINT; columnIndex:INTEGER) : INTEGER;
		
		Category: Dialogs - Modern - Browser
		Gets item display type for list items in specified column.
	'''
	pass
	return 'INTEGER' # 


def GetLBItemFillBackColor(
		dialogID    , # LONGINT - id of the dialog that contains the list browser
		componentID , # LONGINT - id of the list browser control                 
		itemIndex   , # INTEGER - the row index                                  
		subItemIndex  # INTEGER - the column index                               
		):
	'''
		Python: (BOOLEAN, redIndex, greenIndex, blueIndex) = vs.GetLBItemFillBackColor(dialogID, componentID, itemIndex, subItemIndex)
		VectorScript: FUNCTION GetLBItemFillBackColor(dialogID:LONGINT; componentID:LONGINT; itemIndex:INTEGER; subItemIndex:INTEGER; VAR redIndex:INTEGER; VAR greenIndex:INTEGER; VAR blueIndex:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Gets the specified list browser item's fill background color.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0      , 
	         0       )


def GetLBItemFillForeColor(
		dialogID    , # LONGINT - id of the dialog that contains the list browser
		componentID , # LONGINT - id of the list browser control                 
		itemIndex   , # INTEGER - the row index                                  
		subItemIndex  # INTEGER - the column index                               
		):
	'''
		Python: (BOOLEAN, redIndex, greenIndex, blueIndex) = vs.GetLBItemFillForeColor(dialogID, componentID, itemIndex, subItemIndex)
		VectorScript: FUNCTION GetLBItemFillForeColor(dialogID:LONGINT; componentID:LONGINT; itemIndex:INTEGER; subItemIndex:INTEGER; VAR redIndex:INTEGER; VAR greenIndex:INTEGER; VAR blueIndex:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Gets the specified list browser item's fill foreground color.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0      , 
	         0       )


def GetLBItemGradientOrImageRefNumber(
		dialogID    , # LONGINT - id of the dialog that contains the list browser
		componentID , # LONGINT - id of the list browser control                 
		itemIndex   , # INTEGER - the row index                                  
		subItemIndex  # INTEGER - the column index                               
		):
	'''
		Python: (BOOLEAN, refNumber) = vs.GetLBItemGradientOrImageRefNumber(dialogID, componentID, itemIndex, subItemIndex)
		VectorScript: FUNCTION GetLBItemGradientOrImageRefNumber(dialogID:LONGINT; componentID:LONGINT; itemIndex:INTEGER; subItemIndex:INTEGER; VAR refNumber:LONGINT) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Gets the specified list browser item's gradient or image.
	'''
	pass
	return ( False  , # 
	         0       )


def GetLBItemInfo(
		dialogID    , # LONGINT - id of the dialog that contains the list browser
		componentID , # LONGINT - id of the list browser control                 
		itemIndex   , # INTEGER - the item index                                 
		subItemIndex  # INTEGER - the subitem index                              
		):
	'''
		Python: (BOOLEAN, itemString, imageIndex) = vs.GetLBItemInfo(dialogID, componentID, itemIndex, subItemIndex)
		VectorScript: FUNCTION GetLBItemInfo(dialogID:LONGINT; componentID:LONGINT; itemIndex:INTEGER; subItemIndex:INTEGER; VAR itemString:STRING; VAR imageIndex:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Gets string and image information for a specified item of a List Browser control.
	'''
	pass
	return ( False   , # 
	         'string', 
	         0        )


def GetLBItemLineType(
		dialogID    , # LONGINT - id of the dialog that contains the list browser
		componentID , # LONGINT - id of the list browser control                 
		itemIndex   , # INTEGER - the row index                                  
		subItemIndex  # INTEGER - the column index                               
		):
	'''
		Python: (BOOLEAN, lineType, lineWeight) = vs.GetLBItemLineType(dialogID, componentID, itemIndex, subItemIndex)
		VectorScript: FUNCTION GetLBItemLineType(dialogID:LONGINT; componentID:LONGINT; itemIndex:INTEGER; subItemIndex:INTEGER; VAR lineType:LONGINT; VAR lineWeight:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Gets the specified list browser item's line type.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0       )


def GetLBItemOrigName(
		dialogID   , # LONGINT - The id of the dialog.                                         
		compenentID, # LONGINT - The id of the list browser.                                   
		itemIndex    # INTEGER - The index of the item for which the original name is returned.
		):
	'''
		Python: STRING = vs.GetLBItemOrigName(dialogID, compenentID, itemIndex)
		VectorScript: FUNCTION GetLBItemOrigName(dialogID:LONGINT; compenentID:LONGINT; itemIndex:INTEGER) : STRING;
		
		Category: Dialogs - Modern - Browser
		Returns the original name for a list browser item when hierarchical display is on. If the item is a container item, it will return an empty string.
	'''
	pass
	return 'STRING' # The original name of the indicated item.


def GetLBItemPatternIndex(
		dialogID        , # LONGINT - id of the dialog that contains the list browser
		componentID     , # LONGINT - id of the list browser control                 
		itemIndex       , # INTEGER - the row index                                  
		thecolumnindex    # INTEGER - the column index                               
		):
	'''
		Python: (BOOLEAN, outPatIndex) = vs.GetLBItemPatternIndex(dialogID, componentID, itemIndex, the column index)
		VectorScript: FUNCTION GetLBItemPatternIndex(dialogID:LONGINT; componentID:LONGINT; itemIndex:INTEGER; the column index:INTEGER; VAR outPatIndex:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Gets the specified list browser item's pattern index.
	'''
	pass
	return ( False  , # 
	         0       )


def GetLBItemPenBackColor(
		dialogID    , # LONGINT - id of the dialog that contains the list browser
		componentID , # LONGINT - id of the list browser control                 
		itemIndex   , # INTEGER - the row index                                  
		subItemIndex  # INTEGER - the column index                               
		):
	'''
		Python: (BOOLEAN, redIndex, greenIndex, blueIndex) = vs.GetLBItemPenBackColor(dialogID, componentID, itemIndex, subItemIndex)
		VectorScript: FUNCTION GetLBItemPenBackColor(dialogID:LONGINT; componentID:LONGINT; itemIndex:INTEGER; subItemIndex:INTEGER; VAR redIndex:INTEGER; VAR greenIndex:INTEGER; VAR blueIndex:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Gets the specified list browser item's pen background color.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0      , 
	         0       )


def GetLBItemPenForeColor(
		dialogID    , # LONGINT - id of the dialog that contains the list browser
		componentID , # LONGINT - id of the list browser control                 
		itemIndex   , # INTEGER - the row index                                  
		subItemIndex  # INTEGER - the column index                               
		):
	'''
		Python: (BOOLEAN, redIndex, greenIndex, blueIndex) = vs.GetLBItemPenForeColor(dialogID, componentID, itemIndex, subItemIndex)
		VectorScript: FUNCTION GetLBItemPenForeColor(dialogID:LONGINT; componentID:LONGINT; itemIndex:INTEGER; subItemIndex:INTEGER; VAR redIndex:INTEGER; VAR greenIndex:INTEGER; VAR blueIndex:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Gets the specified list browser item's pen foreground color.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0      , 
	         0       )


def GetLBItemTextColor(
		dialogID    , # LONGINT - id of the dialog that contains the list browser
		componentID , # LONGINT - id of the list browser control                 
		itemIndex   , # INTEGER - the row index                                  
		subItemIndex  # INTEGER - the column index                               
		):
	'''
		Python: (BOOLEAN, redIndex, greenIndex, blueIndex) = vs.GetLBItemTextColor(dialogID, componentID, itemIndex, subItemIndex)
		VectorScript: FUNCTION GetLBItemTextColor(dialogID:LONGINT; componentID:LONGINT; itemIndex:INTEGER; subItemIndex:INTEGER; VAR redIndex:INTEGER; VAR greenIndex:INTEGER; VAR blueIndex:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Gets the text color for the specified list browser item.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0      , 
	         0       )


def GetLBItemTextJust(
		dialogID    , # LONGINT - id of the dialog that contains the list browser
		componentID , # LONGINT - id of the list browser control                 
		itemIndex   , # INTEGER - the row index                                  
		subItemIndex  # INTEGER - the column index                               
		):
	'''
		Python: (BOOLEAN, justification) = vs.GetLBItemTextJust(dialogID, componentID, itemIndex, subItemIndex)
		VectorScript: FUNCTION GetLBItemTextJust(dialogID:LONGINT; componentID:LONGINT; itemIndex:INTEGER; subItemIndex:INTEGER; VAR justification:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Gets the text alignment for the specified list browser item.
	'''
	pass
	return ( False  , # 
	         0       )


def GetLBItemTextStyle(
		dialogID    , # LONGINT - id of the dialog that contains the list browser
		componentID , # LONGINT - id of the list browser control                 
		itemIndex   , # INTEGER - the row index                                  
		subItemIndex  # INTEGER - the column index                               
		):
	'''
		Python: (BOOLEAN, textStyle) = vs.GetLBItemTextStyle(dialogID, componentID, itemIndex, subItemIndex)
		VectorScript: FUNCTION GetLBItemTextStyle(dialogID:LONGINT; componentID:LONGINT; itemIndex:INTEGER; subItemIndex:INTEGER; VAR textStyle:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Gets the text style for the specified list browser item.
	'''
	pass
	return ( False  , # 
	         0       )


def GetLBMultImageIndexes(
		dialogID    , # LONGINT - id of the dialog that contains the list browser
		componentID , # LONGINT - id of the list browser control                 
		itemIndex   , # INTEGER - the row index                                  
		subItemIndex  # INTEGER - the column index                               
		):
	'''
		Python: (BOOLEAN, imageIndex0, imageIndex1, imageIndex2) = vs.GetLBMultImageIndexes(dialogID, componentID, itemIndex, subItemIndex)
		VectorScript: FUNCTION GetLBMultImageIndexes(dialogID:LONGINT; componentID:LONGINT; itemIndex:INTEGER; subItemIndex:INTEGER; VAR imageIndex0:INTEGER; VAR imageIndex1:INTEGER; VAR imageIndex2:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Gets the index of the images within the list browser multi image display.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0      , 
	         0       )


def GetLBOrigNameClLevel(
		dialogID    , # LONGINT - The id of the dialog.         
		componentID , # LONGINT - The id of the list browser.   
		originalName  # STRING  - The original name of the item.
		):
	'''
		Python: (level1Closed, level2Closed, level3Closed) = vs.GetLBOrigNameClLevel(dialogID, componentID, originalName)
		VectorScript: PROCEDURE GetLBOrigNameClLevel(dialogID:LONGINT; componentID:LONGINT; originalName:STRING; VAR level1Closed:BOOLEAN; VAR level2Closed:BOOLEAN; VAR level3Closed:BOOLEAN);
		
		Category: Dialogs - Modern - Browser
		This function returns the close levels for an original name in the list browser. If the item for the name is displayed, then all the closeLevels will be false.
	'''
	pass
	return ( False, 
	         False, 
	         False )


def GetLBSortColumn(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID  # LONGINT - id of the list browser control                 
		):
	'''
		Python: INTEGER = vs.GetLBSortColumn(dialogID, componentID)
		VectorScript: FUNCTION GetLBSortColumn(dialogID:LONGINT; componentID:LONGINT) : INTEGER;
		
		Category: Dialogs - Modern - Browser
		Gets the index of the sort column in the specified list browser control.
	'''
	pass
	return 'INTEGER' # 


def GetLevelElevation(
		storyHandle, # HANDLE - The handle of the Story containing the Story Level we would like to know the elevation of.
		levelType    # STRING - The level type of the Story Level that we would like to know the elevation of.            
		):
	'''
		Python: REAL = vs.GetLevelElevation(storyHandle, levelType)
		VectorScript: FUNCTION GetLevelElevation(storyHandle:HANDLE; levelType:STRING) : REAL;
		
		Category: Layers
		Gets the elevation of a Story Level, relative to its containing Story.
	'''
	pass
	return 'REAL' # The elevation of the requested Story Level.


def GetLevelTemplateInfo(
		index  # INTEGER - The index of the desired Story Level Template.
		):
	'''
		Python: (BOOLEAN, layerName, scaleFactor, levelType, elevation, wallHeight) = vs.GetLevelTemplateInfo(index)
		VectorScript: FUNCTION GetLevelTemplateInfo(index:INTEGER; VAR layerName:STRING; VAR scaleFactor:REAL; VAR levelType:STRING; VAR elevation:REAL; VAR wallHeight:REAL) : BOOLEAN;
		
		Category: Layers
		Used to access the properties of the Story Level Template at 'index'.  The name, scaleFactor, levelType, elevation, and wallHeight parameters of the requested Story Level Template will be returned in the appropriate parameters.
	'''
	pass
	return ( False   , # Whether the Story Level Template at 'index' was found and valid.
	         'string', 
	         0.0     , 
	         'string', 
	         0.0     , 
	         0.0      )


def GetLevelTemplateName(
		index  # INTEGER - The index of the Story Level Template whose name is to be returned.
		):
	'''
		Python: STRING = vs.GetLevelTemplateName(index)
		VectorScript: FUNCTION GetLevelTemplateName(index:INTEGER) : STRING;
		
		Category: Layers
		Returns the name of the nth Story Level Template in the file. For example, if 3 is passed in, it will return the name of the 3rd Story Level Template in the file.
	'''
	pass
	return 'STRING' # The name of the Story Level Template at 'index',


def GetLevelTypeName(
		index  # INTEGER - The index of the level type whose name is desired.
		):
	'''
		Python: STRING = vs.GetLevelTypeName(index)
		VectorScript: FUNCTION GetLevelTypeName(index:INTEGER) : STRING;
		
		Category: Layers
		Returns the name of the nth Level Type in the file. For example, if 3 is passed in, it will return the name of the 3rd Level Type in the file.
	'''
	pass
	return 'STRING' # The name of the indicated level type.


def GetLightColorRGB(
		light  # HANDLE - Handle to light.
		):
	'''
		Python: (red, green, blue) = vs.GetLightColorRGB(light)
		VectorScript: PROCEDURE GetLightColorRGB(light:HANDLE; VAR red:LONGINT; VAR green:LONGINT; VAR blue:LONGINT);
		
		Category: Objects - Lights
		Procedure GetLightColorRGB returns the RGB color values for the referenced light object.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetLightDirection(
		h  # HANDLE - Handle to light.
		):
	'''
		Python: (panAngleR, tiltAngleR) = vs.GetLightDirection(h)
		VectorScript: PROCEDURE GetLightDirection(h:HANDLE; VAR panAngleR:REAL; VAR tiltAngleR:REAL);
		
		Category: Objects - Lights
		Procedure GetLightDirection returns the direction angles of the referenced light object.
	'''
	pass
	return ( 0.0, 
	         0.0 )


def GetLightFalloff(
		light  # HANDLE - Handle to light.
		):
	'''
		Python: (distFalloff, angFalloff) = vs.GetLightFalloff(light)
		VectorScript: PROCEDURE GetLightFalloff(light:HANDLE; VAR distFalloff:INTEGER; VAR angFalloff:INTEGER);
		
		Category: Objects - Lights
		Procedure GetLightFalloff returns the fall off attributes for the referenced light object.
	'''
	pass
	return ( 0, 
	         0 )


def GetLightInfo(
		h  # HANDLE - Handle to light.
		):
	'''
		Python: (lightType, brightness, isOn, castShadow) = vs.GetLightInfo(h)
		VectorScript: PROCEDURE GetLightInfo(h:HANDLE; VAR lightType:INTEGER; VAR brightness:INTEGER; VAR isOn:BOOLEAN; VAR castShadow:BOOLEAN);
		
		Category: Objects - Lights
		Procedure GetLightInfo returns the attributes of the referenced light object.
	'''
	pass
	return ( 0    , 
	         0    , 
	         False, 
	         False )


def GetLightLocation(
		h  # HANDLE - Handle to light.
		):
	'''
		Python: p = vs.GetLightLocation(h)
		VectorScript: PROCEDURE GetLightLocation(h:HANDLE; VAR pX, pY, pZ:REAL);
		
		Category: Objects - Lights
		Procedure GetLightLocation returns the position of the referenced light object.
	'''
	pass
	return ( 0,0,0 )


def GetLine(
		):
	'''
		Python: (p1, p2) = vs.GetLine()
		VectorScript: PROCEDURE GetLine(VAR p1X, p1Y:REAL; VAR p2X, p2Y:REAL);
		
		Category: User Interactive
		Procedure GetLine returns two user selected points, and draws a temporary "rubberband" line when prompting for the second point. This cannot be used if there is a function anywhere in the calling chain.
	'''
	pass
	return ( 0,0, 
	         0,0 )


def GetLine3D(
		useWP  # BOOLEAN - TRUE if the returned point have to be on the active Working Plane. Snapping to arbitrary 3D geometry will produce vertical projection result on the WP; FALSE if the point can be arbitrary 3D point (produced, for example, by snapping to a 3D geometry)
		):
	'''
		Python: (p1, p2) = vs.GetLine3D(useWP)
		VectorScript: PROCEDURE GetLine3D(VAR p1X, p1Y, p1Z:REAL; VAR p2X, p2Y, p2Z:REAL; useWP:BOOLEAN);
		
		Category: User Interactive
		Procedure GetLine3D returns two user selected points, and draws a temporary "rubberband" 3D line when prompting for the second point. This cannot be used if there is a function anywhere in the calling chain.
	'''
	pass
	return ( 0,0,0, 
	         0,0,0 )


def GetLineAttributeData(
		dialogID, # LONGINT -  
		itemID    # LONGINT -  
		):
	'''
		Python: (lineStyle, lineWeight) = vs.GetLineAttributeData(dialogID, itemID)
		VectorScript: PROCEDURE GetLineAttributeData(dialogID:LONGINT; itemID:LONGINT; VAR lineStyle:INTEGER; VAR lineWeight:INTEGER);
		
		Category: Dialogs - Modern
		Deprecated - will generate error. Use GetLineTypeAttriData instead.
	'''
	pass
	return ( 0, 
	         0 )


def GetLineStyleChoice(
		dialogID, # LONGINT -  
		itemID    # LONGINT -  
		):
	'''
		Python: lineStyle = vs.GetLineStyleChoice(dialogID, itemID)
		VectorScript: PROCEDURE GetLineStyleChoice(dialogID:LONGINT; itemID:LONGINT; VAR lineStyle:INTEGER);
		
		Category: Dialogs - Modern
		Deprecated - will generate error. Use GetLineTypeChoice instead.
	'''
	pass
	return ( 0 )


def GetLineTypeAtIndex(
		dialogID, # LONGINT - The index of the dialog layout containing the control.
		itemID  , # LONGINT - The index of the line style control.                  
		index     # INTEGER - The choice index.                                     
		):
	'''
		Python: lineType = vs.GetLineTypeAtIndex(dialogID, itemID, index)
		VectorScript: PROCEDURE GetLineTypeAtIndex(dialogID:LONGINT; itemID:LONGINT; index:INTEGER; VAR lineType:LONGINT);
		
		Category: Dialogs - Modern
		Get the line type at the specified index in the line style control.
	'''
	pass
	return ( 0 )


def GetLineTypeAttriData(
		dialogID, # LONGINT - The index of the dialog layout containing the control.
		itemID    # LONGINT - The index of the line attribute control.              
		):
	'''
		Python: (lineType, lineWeight) = vs.GetLineTypeAttriData(dialogID, itemID)
		VectorScript: PROCEDURE GetLineTypeAttriData(dialogID:LONGINT; itemID:LONGINT; VAR lineType:LONGINT; VAR lineWeight:INTEGER);
		
		Category: Dialogs - Modern
		Get the current choices for the combined line style and line weight dialog control.  The line type value is the line type internal index (reference number). The line weight value is in mils.
	'''
	pass
	return ( 0, 
	         0 )


def GetLineTypeChoice(
		dialogID, # LONGINT - The index of the dialog layout containing the control.
		itemID    # LONGINT - The index of the line style control.                  
		):
	'''
		Python: lineType = vs.GetLineTypeChoice(dialogID, itemID)
		VectorScript: PROCEDURE GetLineTypeChoice(dialogID:LONGINT; itemID:LONGINT; VAR lineType:LONGINT);
		
		Category: Dialogs - Modern
		Get current choice of line style popup dialog control.  Choice is the internal index (reference number) of the line type.
	'''
	pass
	return ( 0 )


def GetLineWeightChoice(
		dialogID, # LONGINT -  
		itemID    # LONGINT -  
		):
	'''
		Python: lineWeight = vs.GetLineWeightChoice(dialogID, itemID)
		VectorScript: PROCEDURE GetLineWeightChoice(dialogID:LONGINT; itemID:LONGINT; VAR lineWeight:INTEGER);
		
		Category: Dialogs - Modern
		Get current choice for a line weight dialog control.  The value is in mils.
	'''
	pass
	return ( 0 )


def GetLinkHeightToLayerDeltaZ(
		theWall  # HANDLE - The wall.
		):
	'''
		Python: BOOLEAN = vs.GetLinkHeightToLayerDeltaZ(theWall)
		VectorScript: FUNCTION GetLinkHeightToLayerDeltaZ(theWall:HANDLE) : BOOLEAN;
		
		Category: Objects - Walls
		Returns whether or not the wall's height is linked to the layer delta z.
	'''
	pass
	return 'BOOLEAN' # 


def GetLName(
		h  # HANDLE - Handle to layer.
		):
	'''
		Python: STRING = vs.GetLName(h)
		VectorScript: FUNCTION GetLName(h:HANDLE) : STRING;
		
		Category: Layers
		Function GetLName returns the name of the referenced layer.
	'''
	pass
	return 'STRING' # 


def GetLocalizedPluginChoice(
		inPluginName   , # STRING  - The universal name of the plug-in.                    
		inParameterName, # STRING  - The universal name of the parameter.                  
		inChoiceIndex    # INTEGER - The  index of the requested choice. ( range is 1 to n)
		):
	'''
		Python: (BOOLEAN, outChoice) = vs.GetLocalizedPluginChoice(inPluginName, inParameterName, inChoiceIndex)
		VectorScript: FUNCTION GetLocalizedPluginChoice(inPluginName:STRING; inParameterName:STRING; inChoiceIndex:INTEGER; VAR outChoice:STRING) : BOOLEAN;
		
		Category: Objects - Custom
		Returns true with outChoice as specified by inPluginName, inParameterName and inChoiceIndex.  Each of the input names are universal names.
	'''
	pass
	return ( False   , # Returns true if the function call succeeded.
	         'string' )


def GetLocalizedPluginName(
		inPluginName  # STRING - Universal name of the plug-in.
		):
	'''
		Python: (BOOLEAN, outName) = vs.GetLocalizedPluginName(inPluginName)
		VectorScript: FUNCTION GetLocalizedPluginName(inPluginName:STRING; VAR outName:STRING) : BOOLEAN;
		
		Category: Objects - Custom
		Get the localized name of a plug-in given its universal name.
		When Vectorworks plug-ins are localized by distributors in other countries, their names are translated to the appropriate language.  The plug-in file stores both the original universal name and this translated localized name.  The translated name is displayed by the Vectorworks user interface instead of the original name.  If a script needs to display the name of a plug-in in a dialog or message then it should call this function to determine the localized name.  (Note that scripts will use the universal name to specify a plug-in when the name is not being displayed to the user.)
		If the plug-in has not been localized, then this function will return the universal name.
	'''
	pass
	return ( False   , # Returns true if the specified plug-in exists, and false if it is not found.
	         'string' )


def GetLocalizedPluginParameter(
		inPluginName   , # STRING - Universal name of the plug-in.  
		inParameterName  # STRING - Universal name of the parameter.
		):
	'''
		Python: (BOOLEAN, outParameter) = vs.GetLocalizedPluginParameter(inPluginName, inParameterName)
		VectorScript: FUNCTION GetLocalizedPluginParameter(inPluginName:STRING; inParameterName:STRING; VAR outParameter:STRING) : BOOLEAN;
		
		Category: Objects - Custom
		Get the localized name of a plug-in parameter.
		When Vectorworks plug-ins are localized by distributors in other countries, their parameter names are translated to the appropriate language.  The plug-in file stores both the original universal name and this translated localized name for each parameter.  The translated name is displayed by the Vectorworks user interface instead of the original name.  If a script needs to display the name of a plug-in parameter in a dialog or message then it should call this function to determine the localized name.  (Note that scripts will use the universal name to specify a plug-in parameter when the name is not being displayed to the user.)
		If the plug-in has not been localized, then this function will return the universal name of the parameter.
	'''
	pass
	return ( False   , # Returns true if the specified plug-in exists, and false if it is not found.
	         'string' )


def GetLocPt(
		h  # HANDLE - Handle to locus.
		):
	'''
		Python: p = vs.GetLocPt(h)
		VectorScript: PROCEDURE GetLocPt(h:HANDLE; VAR pX, pY:REAL);
		
		Category: Objects - 2D
		Procedure GetLocPt returns the coordinate location of the referenced locus.
	'''
	pass
	return ( 0,0 )


def GetLocus3D(
		h  # HANDLE - Handle to 3D locus.
		):
	'''
		Python: p = vs.GetLocus3D(h)
		VectorScript: PROCEDURE GetLocus3D(h:HANDLE; VAR pX, pY, pZ:REAL);
		
		Category: Objects - 3D
		Procedure GetLocus3D returns the coordinates of the referenced 3D locus object.
	'''
	pass
	return ( 0,0,0 )


def GetLS(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: INTEGER = vs.GetLS(h)
		VectorScript: FUNCTION GetLS(h:HANDLE) : INTEGER;
		
		Category: Object Attributes
		Deprecated - will generate error. Use GetLSN instead.
	'''
	pass
	return 'INTEGER' # 


def GetLScale(
		h  # HANDLE - Handle to layer.
		):
	'''
		Python: REAL = vs.GetLScale(h)
		VectorScript: FUNCTION GetLScale(h:HANDLE) : REAL;
		
		Category: Layers
		Function GetLScale returns the scale of the referenced layer.
	'''
	pass
	return 'REAL' # 


def GetLSN(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: LONGINT = vs.GetLSN(h)
		VectorScript: FUNCTION GetLSN(h:HANDLE) : LONGINT;
		
		Category: Object Attributes
		Function GetLSN returns the line style of the referenced object.
	'''
	pass
	return 'LONGINT' # 


def GetLVis(
		h  # HANDLE - Handle to layer.
		):
	'''
		Python: INTEGER = vs.GetLVis(h)
		VectorScript: FUNCTION GetLVis(h:HANDLE) : INTEGER;
		
		Category: Layers
		Function GetLVis returns the visibility of the referenced layer.
	'''
	pass
	return 'INTEGER' # 


def GetLW(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: INTEGER = vs.GetLW(h)
		VectorScript: FUNCTION GetLW(h:HANDLE) : INTEGER;
		
		Category: Object Attributes
		Function GetLW returns the line weight of the referenced object. The value returned represents the width in mils.
	'''
	pass
	return 'INTEGER' # 


def GetMainDisplayBounds(
		):
	'''
		Python: (outTop, outLeft, outBottom, outRight) = vs.GetMainDisplayBounds()
		VectorScript: PROCEDURE GetMainDisplayBounds(VAR outTop:INTEGER; VAR outLeft:INTEGER; VAR outBottom:INTEGER; VAR outRight:INTEGER);
		
		Category: Utility
		Returns the bounds of the main display device (Macintosh Only).
	'''
	pass
	return ( 0, 
	         0, 
	         0, 
	         0 )


def GetMarker(
		h  # HANDLE - Handle to the object.
		):
	'''
		Python: (start, end, style, size) = vs.GetMarker(h)
		VectorScript: PROCEDURE GetMarker(h:HANDLE; VAR start:BOOLEAN; VAR end:BOOLEAN; VAR style:INTEGER; VAR size:REAL);
		
		Category: Object Attributes
		Returns marker information on the referenced object.
	'''
	pass
	return ( False, 
	         False, 
	         0    , 
	         0.0   )


def GetMarkerChoice(
		dialogID, # LONGINT -  
		itemID    # LONGINT -  
		):
	'''
		Python: (index, style, angle, size) = vs.GetMarkerChoice(dialogID, itemID)
		VectorScript: PROCEDURE GetMarkerChoice(dialogID:LONGINT; itemID:LONGINT; VAR index:INTEGER; VAR style:INTEGER; VAR angle:INTEGER; VAR size:REAL);
		
		Category: Dialogs - Modern
		OBSOLETE procedure for VW2008
		Get current choice for Marker popup dialog control.
	'''
	pass
	return ( 0  , 
	         0  , 
	         0  , 
	         0.0 )


def GetMarkerPopupSelectedItem(
		dialogID   , # LONGINT - ID of the dialog           
		componentID  # LONGINT - ID of the marker popup item
		):
	'''
		Python: (INTEGER, style, angle, size) = vs.GetMarkerPopupSelectedItem(dialogID, componentID)
		VectorScript: FUNCTION GetMarkerPopupSelectedItem(dialogID:LONGINT; componentID:LONGINT; VAR style:INTEGER; VAR angle:INTEGER; VAR size:INTEGER) : INTEGER;
		
		Category: Dialogs - Modern
		This is a deprecated function.  Use GetMarkerChoice instead.
		Returns the 1-based index number of the selected item in the specified marker popup menu item.  If return value is 8, a custom marker is selected.
	'''
	pass
	return ( 0      , # 
	         0      , 
	         0      , 
	         0       )


def GetMarkerValue(
		dialogID, # LONGINT - ID of the dialog              
		itemID    # LONGINT - ID of the marker popup control
		):
	'''
		Python: (style, angle, length, width, basis, thickness) = vs.GetMarkerValue(dialogID, itemID)
		VectorScript: PROCEDURE GetMarkerValue(dialogID:LONGINT; itemID:LONGINT; VAR style:INTEGER; VAR angle:INTEGER; VAR length:REAL; VAR width:REAL; VAR basis:INTEGER; VAR thickness:REAL);
		
		Category: Dialogs - Modern
		Gets MarkerPopup value in dialog (replaces MarkerPopup procedures prior to VW2008).
	'''
	pass
	return ( 0  , 
	         0  , 
	         0.0, 
	         0.0, 
	         0  , 
	         0.0 )


def GetMeshVertex(
		hMesh, # HANDLE  - Handle to the mesh object.
		index  # INTEGER - The Index of the vertex.  
		):
	'''
		Python: outPt = vs.GetMeshVertex(hMesh, index)
		VectorScript: PROCEDURE GetMeshVertex(hMesh:HANDLE; index:INTEGER; VAR outPtX, outPtY, outPtZ:REAL);
		
		Category: Objects - 3D
		Return the specified vertex of a mesh object.
	'''
	pass
	return ( 0,0,0 )


def GetMeshVertsCnt(
		hMesh  # HANDLE - Handle to the mesh object.
		):
	'''
		Python: INTEGER = vs.GetMeshVertsCnt(hMesh)
		VectorScript: FUNCTION GetMeshVertsCnt(hMesh:HANDLE) : INTEGER;
		
		Category: Objects - 3D
		Returns the number of vertices of the passed mesh handle.
	'''
	pass
	return 'INTEGER' # 


def GetMirrorEmpty2DComp(
		objectHandle  # HANDLE - Handle of a symbol or plug-in object.
		):
	'''
		Python: BOOLEAN = vs.GetMirrorEmpty2DComp(objectHandle)
		VectorScript: FUNCTION GetMirrorEmpty2DComp(objectHandle:HANDLE) : BOOLEAN;
		
		Category: Objects - Custom
		Gets whether the opposite view graphics are mirrored for empty 2D components of a symbol definition or plug-in object.
	'''
	pass
	return 'BOOLEAN' # TRUE if the opposite view graphics are mirrored for empty 2D components of a symbol definition or plug-in object.


def GetMouse(
		):
	'''
		Python: p = vs.GetMouse()
		VectorScript: PROCEDURE GetMouse(VAR pX, pY:REAL);
		
		Category: User Interactive
		Procedure GetMouse tracks and returns the current location of the cursor within the active Vectorworks document, allowing the cursor coordinates to be returned dynamically while moving the cursor onscreen.
	'''
	pass
	return ( 0,0 )


def GetMultilineText(
		dialogID   , # LONGINT - The dialog identifier given by CreateLayout or CreateResizableLayout 
		componentID  # LONGINT - The identifier of the component that the text will be retrieved from.
		):
	'''
		Python: text = vs.GetMultilineText(dialogID, componentID)
		VectorScript: PROCEDURE GetMultilineText(dialogID:LONGINT; componentID:LONGINT; VAR text:DYNARRAY of CHAR);
		
		Category: Dialogs - Modern
		Gets the text that is contained in the given componentID.
	'''
	pass
	return ( 'string' )


def GetName(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: STRING = vs.GetName(h)
		VectorScript: FUNCTION GetName(h:HANDLE) : STRING;
		
		Category: Object Names
		Function GetName returns the object name of the referenced object. The function returns None if the object has no object name.
		A handle to layer may not passed to this routine; to obtain a layer name, use GetLName.
	'''
	pass
	return 'STRING' # 


def GetNameFromResourceList(
		listID, # LONGINT - an ID for a resouce list created by the BuildResourceList function.
		index   # LONGINT - an index into the list.                                            
		):
	'''
		Python: DYNARRAY of CHAR = vs.GetNameFromResourceList(listID, index)
		VectorScript: FUNCTION GetNameFromResourceList(listID:LONGINT; index:LONGINT) : DYNARRAY of CHAR;
		
		Category: Document List Handling
		Returns the name to display of the indicated item in the specified resource list.  If the list has items with the same name from different files, the display name will have the filename added to it in parentheses.
	'''
	pass
	return 'DYNARRAY[] of CHAR' # 


def GetNetAdapterInfo(
		adapterIndex  # INTEGER -  
		):
	'''
		Python: (BOOLEAN, outMacAddr) = vs.GetNetAdapterInfo(adapterIndex)
		VectorScript: FUNCTION GetNetAdapterInfo(adapterIndex:INTEGER; VAR outMacAddr:STRING) : BOOLEAN;
		
		Category: Utility
		Return information about the network adapter
	'''
	pass
	return ( False   , # 
	         'string' )


def GetNextElement(
		XMLHandle  , # LONGINT            -  
		elementPath  # DYNARRAY[] of CHAR -  
		):
	'''
		Python: (INTEGER, value) = vs.GetNextElement(XMLHandle, elementPath)
		VectorScript: FUNCTION GetNextElement(XMLHandle:LONGINT; elementPath:DYNARRAY of CHAR; VAR value:DYNARRAY of CHAR) : INTEGER;
		
		Category: XML
		Returns the next element (sibling) of the given element.
	'''
	pass
	return ( 0       , # 
	         'string' )


def GetNumAssociations(
		handle  # HANDLE - Object handle.
		):
	'''
		Python: INTEGER = vs.GetNumAssociations(handle)
		VectorScript: FUNCTION GetNumAssociations(handle:HANDLE) : INTEGER;
		
		Category: Object Editing
		Get number of associations for specified object.
	'''
	pass
	return 'INTEGER' # INTEGER


def GetNumberOfComponents(
		object  # HANDLE - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		):
	'''
		Python: (BOOLEAN, numComponents) = vs.GetNumberOfComponents(object)
		VectorScript: FUNCTION GetNumberOfComponents(object:HANDLE; VAR numComponents:INTEGER) : BOOLEAN;
		
		Category: Objects - Architectural
		Gets the number of components in an object.
	'''
	pass
	return ( False  , # 
	         0       )


def GetNumberOfDLComponents(
		):
	'''
		Python: (BOOLEAN, numComponents) = vs.GetNumberOfDLComponents()
		VectorScript: FUNCTION GetNumberOfDLComponents(VAR numComponents:INTEGER) : BOOLEAN;
		
		Category: Document Settings
		Gets the number of components in the Double Line Preferences.
	'''
	pass
	return ( False  , # 
	         0       )


def GetNumDashDataPairs(
		dashIndex  # INTEGER - The dash style index.
		):
	'''
		Python: (INTEGER, swt) = vs.GetNumDashDataPairs(dashIndex)
		VectorScript: FUNCTION GetNumDashDataPairs(dashIndex:INTEGER; VAR swt:BOOLEAN) : INTEGER;
		
		Category: Document Attributes
		Deprecated - will generate error. Use GetNumDashDataPairsN instead.
	'''
	pass
	return ( 0      , # 
	         False   )


def GetNumDashDataPairsN(
		dashIndex  # LONGINT - The negative value of the dash pattern's internal index.
		):
	'''
		Python: (INTEGER, swt) = vs.GetNumDashDataPairsN(dashIndex)
		VectorScript: FUNCTION GetNumDashDataPairsN(dashIndex:LONGINT; VAR swt:BOOLEAN) : INTEGER;
		
		Category: Document Attributes
		Function GetNumDashDataPairsN returns the number of dash/gap value pairs defined for the specified dash style. The "scale with thickness" setting is also returned. Dash styles support up to 5 dash/gap value pairs.
	'''
	pass
	return ( 0      , # 
	         False   )


def GetNumGradientSegments(
		gradient  # HANDLE - The gradient from which to get the number of segments.
		):
	'''
		Python: INTEGER = vs.GetNumGradientSegments(gradient)
		VectorScript: FUNCTION GetNumGradientSegments(gradient:HANDLE) : INTEGER;
		
		Category: Document Attributes
		Gets the number of segments in the gradient.
	'''
	pass
	return 'INTEGER' # Returns the number of segments in the gradient if successful; 0 otherwise.


def GetNumGradientSliderSegments(
		dialogID   , # LONGINT - Index to the dialog layout that contains the gradient slider component.
		componentID  # LONGINT - Index to a specific gradient slider component.                         
		):
	'''
		Python: INTEGER = vs.GetNumGradientSliderSegments(dialogID, componentID)
		VectorScript: FUNCTION GetNumGradientSliderSegments(dialogID:LONGINT; componentID:LONGINT) : INTEGER;
		
		Category: Dialogs - Modern
		Gets the number of segments in the gradient slider.
		Note: a gradient slider must always have at least 2 segments.
	'''
	pass
	return 'INTEGER' # Retuns number of segments in gradient slider.[[BR]][[BR]](a segment consists of a color marker and the associated midpoint marker immediately to the right)


def GetNumHoles(
		inPolyline  # HANDLE - Handle to polyline.
		):
	'''
		Python: (BOOLEAN, outNumHoles) = vs.GetNumHoles(inPolyline)
		VectorScript: FUNCTION GetNumHoles(inPolyline:HANDLE; VAR outNumHoles:INTEGER) : BOOLEAN;
		
		Category: Objects - Polys
		Returns the number of openings in the referenced polyline.
	'''
	pass
	return ( False  , # Returns TRUE if the polyline contains openings, otherwise returns FALSE.
	         0       )


def GetNumImagePopupItems(
		dialogID   , # LONGINT - Index to the dialog layout that contains the image popup component.
		componentID  # LONGINT - Index to a specific image popup component.                         
		):
	'''
		Python: INTEGER = vs.GetNumImagePopupItems(dialogID, componentID)
		VectorScript: FUNCTION GetNumImagePopupItems(dialogID:LONGINT; componentID:LONGINT) : INTEGER;
		
		Category: Dialogs - Modern
		Returns the number of items in the image popup.
	'''
	pass
	return 'INTEGER' # Returns the number of items in the specified image popup.


def GetNumLayerLevelTypes():
	'''
		Python: INTEGER = vs.GetNumLayerLevelTypes()
		VectorScript: FUNCTION GetNumLayerLevelTypes : INTEGER;
		
		Category: Layers
		Returns the number of layer level types in the file. A layer can be assigned a layer level type, which defines its location within a story.
	'''
	pass
	return 'INTEGER' # The number of layer level types in the file.


def GetNumLBColumnDataItems(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID, # LONGINT - id of the list browser control                 
		columnIndex  # INTEGER - the index of the column                        
		):
	'''
		Python: INTEGER = vs.GetNumLBColumnDataItems(dialogID, componentID, columnIndex)
		VectorScript: FUNCTION GetNumLBColumnDataItems(dialogID:LONGINT; componentID:LONGINT; columnIndex:INTEGER) : INTEGER;
		
		Category: Dialogs - Modern - Browser
		Get the number of columnDataItems.
	'''
	pass
	return 'INTEGER' # 


def GetNumLBColumns(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID  # LONGINT - id of the list browser control                 
		):
	'''
		Python: INTEGER = vs.GetNumLBColumns(dialogID, componentID)
		VectorScript: FUNCTION GetNumLBColumns(dialogID:LONGINT; componentID:LONGINT) : INTEGER;
		
		Category: Dialogs - Modern - Browser
		Gets the number of columns in the specified list browser control.
	'''
	pass
	return 'INTEGER' # 


def GetNumLBItems(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID  # LONGINT - id of the list browser control                 
		):
	'''
		Python: INTEGER = vs.GetNumLBItems(dialogID, componentID)
		VectorScript: FUNCTION GetNumLBItems(dialogID:LONGINT; componentID:LONGINT) : INTEGER;
		
		Category: Dialogs - Modern - Browser
		Gets the number of items in the specified list browser control.
	'''
	pass
	return 'INTEGER' # Returns the number of items in the list browser. 


def GetNumLevelTemplates():
	'''
		Python: INTEGER = vs.GetNumLevelTemplates()
		VectorScript: FUNCTION GetNumLevelTemplates : INTEGER;
		
		Category: Layers
		Returns the number of story level templates in the file. Story Levels contain a level type, elevation, and optional layer to be used to bound objects on stories; Story Level Templates define a generic level that can be added to multiple stories.
	'''
	pass
	return 'INTEGER' # The number of Story Level Templates in the document.


def GetNumLineTypeItems(
		dialogID, # LONGINT - The index of the dialog layout containing the control.
		itemID    # LONGINT - The index of the line style control.                  
		):
	'''
		Python: INTEGER = vs.GetNumLineTypeItems(dialogID, itemID)
		VectorScript: FUNCTION GetNumLineTypeItems(dialogID:LONGINT; itemID:LONGINT) : INTEGER;
		
		Category: Dialogs - Modern
		Returns the number of line types in the line style control.
	'''
	pass
	return 'INTEGER' # 


def GetNumOfWallBreaks(
		wallH  # HANDLE -  
		):
	'''
		Python: (BOOLEAN, numWallBreaks) = vs.GetNumOfWallBreaks(wallH)
		VectorScript: FUNCTION GetNumOfWallBreaks(wallH:HANDLE; VAR numWallBreaks:INTEGER) : BOOLEAN;
		
		Category: Objects - Walls
		Gets the number of breaks in a wall.
	'''
	pass
	return ( False  , # 
	         0       )


def GetNumResourceTags(
		handle  # HANDLE - The handle to the resource
		):
	'''
		Python: INTEGER = vs.GetNumResourceTags(handle)
		VectorScript: FUNCTION GetNumResourceTags(handle:HANDLE) : INTEGER;
		
		Category: General Edit
		Returns the number of tags attached to the specified resource.
	'''
	pass
	return 'INTEGER' # The number of tags attached to the specified resource.


def GetNumRoofElements(
		roofObject  # HANDLE - Handle to roof.
		):
	'''
		Python: INTEGER = vs.GetNumRoofElements(roofObject)
		VectorScript: FUNCTION GetNumRoofElements(roofObject:HANDLE) : INTEGER;
		
		Category: Objects - Roofs
		Function GetNumRoofElements returns the number of roof elements (dormers and skylights) in the referenced roof object.
	'''
	pass
	return 'INTEGER' # 


def GetNumSelectedLBItems(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID  # LONGINT - id of the list browser control                 
		):
	'''
		Python: INTEGER = vs.GetNumSelectedLBItems(dialogID, componentID)
		VectorScript: FUNCTION GetNumSelectedLBItems(dialogID:LONGINT; componentID:LONGINT) : INTEGER;
		
		Category: Dialogs - Modern - Browser
		Returns the number of selected list browser items.
	'''
	pass
	return 'INTEGER' # 


def GetNumStories():
	'''
		Python: INTEGER = vs.GetNumStories()
		VectorScript: FUNCTION GetNumStories : INTEGER;
		
		Category: Layers
		Returns the number of stories in the file. Stories are used to group layers and are shown on the Story pane of the Organization dialog.
	'''
	pass
	return 'INTEGER' # Returns the number of stories in the file.


def GetNumStoryLayerTemplates():
	'''
		Python: INTEGER = vs.GetNumStoryLayerTemplates()
		VectorScript: FUNCTION GetNumStoryLayerTemplates : INTEGER;
		
		Category: Layers
		Returns the number of story layer templates in the file. Story Layer Templates are used to define what Layers are typically found in a Story. When a Story is created, the user has the option to automatically create the Layers defined by the Story Layer Templates.
	'''
	pass
	return 'INTEGER' # The number of Story Layer Templates in the file.


def GetNumTexLayers(
		obj      , # HANDLE  -  
		texPartID  # LONGINT -  
		):
	'''
		Python: LONGINT = vs.GetNumTexLayers(obj, texPartID)
		VectorScript: FUNCTION GetNumTexLayers(obj:HANDLE; texPartID:LONGINT) : LONGINT;
		
		Category: Textures
		Returns number of texture layers (base + decals) for the specified part.
	'''
	pass
	return 'LONGINT' # 


def GetNumWallPeaks(
		h  # HANDLE - Handle to wall.
		):
	'''
		Python: INTEGER = vs.GetNumWallPeaks(h)
		VectorScript: FUNCTION GetNumWallPeaks(h:HANDLE) : INTEGER;
		
		Category: Objects - Walls
		Returns the number of peaks in the referenced wall.
	'''
	pass
	return 'INTEGER' # Returns the number of wall peaks.


def GetNurbsObjectDistanceFromPoint(
		h    , # HANDLE - Handle to a NURBS object.
		point  # POINT  - point                    
		):
	'''
		Python: (BOOLEAN, distance) = vs.GetNurbsObjectDistanceFromPoint(h, point)
		VectorScript: FUNCTION GetNurbsObjectDistanceFromPoint(h:HANDLE; pointX, pointY:REAL; VAR distance:REAL) : BOOLEAN;
		
		Category: Objects - NURBS
		Returns the distance from the input point  to the input NURBS Object h.
	'''
	pass
	return ( False  , # 
	         0.0     )


def GetObjArrow(
		obj  # HANDLE - The indicated object.
		):
	'''
		Python: (style, size, angle, start, end) = vs.GetObjArrow(obj)
		VectorScript: PROCEDURE GetObjArrow(obj:HANDLE; VAR style:INTEGER; VAR size:REAL; VAR angle:INTEGER; VAR start:BOOLEAN; VAR end:BOOLEAN);
		
		Category: Object Attributes
		Procedure GetObjArrow returns the arrow style parameters for the indicated object.
	'''
	pass
	return ( 0    , 
	         0.0  , 
	         0    , 
	         False, 
	         False )


def GetObjBeginningMarker(
		object  # HANDLE - Handle to object.
		):
	'''
		Python: (BOOLEAN, style, angle, size, width, thicknessBasis, thickness, visibility) = vs.GetObjBeginningMarker(object)
		VectorScript: FUNCTION GetObjBeginningMarker(object:HANDLE; VAR style:LONGINT; VAR angle:INTEGER; VAR size:REAL; VAR width:REAL; VAR thicknessBasis:INTEGER; VAR thickness:REAL; VAR visibility:BOOLEAN) : BOOLEAN;
		
		Category: Object Attributes
		Gets all properties for an object's beginning marker. Return TRUE if operation was successful.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0      , 
	         0.0    , 
	         0.0    , 
	         0      , 
	         0.0    , 
	         False   )


def GetObjBoundElevation(
		object , # HANDLE  - The object.                       
		boundID  # INTEGER - The identifier of the story bound.
		):
	'''
		Python: REAL = vs.GetObjBoundElevation(object, boundID)
		VectorScript: FUNCTION GetObjBoundElevation(object:HANDLE; boundID:INTEGER) : REAL;
		
		Category: Objects - Architectural
		Get the elevation of the specified bound ID relative to the object's layer.
	'''
	pass
	return 'REAL' # Return the elevation of the specified bound ID relative to the object's layer.


def GetObject(
		name  # STRING - Object name.
		):
	'''
		Python: HANDLE = vs.GetObject(name)
		VectorScript: FUNCTION GetObject(name:STRING) : HANDLE;
		
		Category: Object Names
		Function GetObject returns a handle to a named object. If the name does not exist, NIL is returned.
	'''
	pass
	return 'HANDLE' # 


def GetObjectByUuid(
		UUID  # STRING - Object UUID
		):
	'''
		Python: HANDLE = vs.GetObjectByUuid(UUID)
		VectorScript: FUNCTION GetObjectByUuid(UUID:STRING) : HANDLE;
		
		Category: Object Info
		Function GetObjectByUuid returns a handle to the object with the specified UUID. If the UUID is not valid, or if no object with that UUID exists, NIL is returned.
	'''
	pass
	return 'HANDLE' # HANDLE


def GetObjectHiddenLine(
		hGeometry3D     , # HANDLE  -  
		cuttingHeight   , # REAL    -  
		bottomOfCutPlane  # BOOLEAN -  
		):
	'''
		Python: HANDLE = vs.GetObjectHiddenLine(hGeometry3D, cuttingHeight, bottomOfCutPlane)
		VectorScript: FUNCTION GetObjectHiddenLine(hGeometry3D:HANDLE; cuttingHeight:REAL; bottomOfCutPlane:BOOLEAN) : HANDLE;
		
		Category: Graphic Calculation
		Create lines representing the hidden line geometry of the specified object.
	'''
	pass
	return 'HANDLE' # 


def GetObjectTags(
		objHandle  # HANDLE - The handle to the object to query Tags from.
		):
	'''
		Python: (BOOLEAN, outArrTags) = vs.GetObjectTags(objHandle)
		VectorScript: FUNCTION GetObjectTags(objHandle:HANDLE; VAR outArrTags:ARRAY) : BOOLEAN;
		
		Category: General Edit
		Lets the user query the list of Tags set on an object such as a Class,Layer or Resource.
	'''
	pass
	return ( False  , # 
	         0       )


def GetObjectUuid(
		h  # HANDLE - Handle to object
		):
	'''
		Python: STRING = vs.GetObjectUuid(h)
		VectorScript: FUNCTION GetObjectUuid(h:HANDLE) : STRING;
		
		Category: Object Info
		Function GetObjectUuid returns the UUID of the referenced object.
	'''
	pass
	return 'STRING' # STRING


def GetObjectVariableBoolean(
		h    , # HANDLE  - Handle to object.     
		index  # INTEGER - Object property index.
		):
	'''
		Python: BOOLEAN = vs.GetObjectVariableBoolean(h, index)
		VectorScript: FUNCTION GetObjectVariableBoolean(h:HANDLE; index:INTEGER) : BOOLEAN;
		
		Category: Object Info
		Returns the ON-OFF status of a Vectorworks object property.
	'''
	pass
	return 'BOOLEAN' # Returns a BOOLEAN value indicating the ON-OFF status of the property.


def GetObjectVariableHandle(
		h    , # HANDLE  -  
		index  # INTEGER -  
		):
	'''
		Python: HANDLE = vs.GetObjectVariableHandle(h, index)
		VectorScript: FUNCTION GetObjectVariableHandle(h:HANDLE; index:INTEGER) : HANDLE;
		
		Category: Object Info
		Returns the value of a Vectorworks object property.
	'''
	pass
	return 'HANDLE' # 


def GetObjectVariableInt(
		h    , # HANDLE  - Handle to object.     
		index  # INTEGER - Object property index.
		):
	'''
		Python: INTEGER = vs.GetObjectVariableInt(h, index)
		VectorScript: FUNCTION GetObjectVariableInt(h:HANDLE; index:INTEGER) : INTEGER;
		
		Category: Object Info
		Returns the value of a Vectorworks object property. Used with properties returning an INTEGER value.
	'''
	pass
	return 'INTEGER' # Returns the value of the property as an INTEGER value.


def GetObjectVariableLongInt(
		h    , # HANDLE  - Handle to object.     
		index  # INTEGER - Object property index.
		):
	'''
		Python: LONGINT = vs.GetObjectVariableLongInt(h, index)
		VectorScript: FUNCTION GetObjectVariableLongInt(h:HANDLE; index:INTEGER) : LONGINT;
		
		Category: Object Info
		Returns the value of a Vectorworks object property. Used with properties returning a LONGINT value.
	'''
	pass
	return 'LONGINT' # Returns the value of the property as a LONGINT value.


def GetObjectVariablePoint(
		h    , # HANDLE  - Handle to object.     
		index  # INTEGER - Object property index.
		):
	'''
		Python: (BOOLEAN, outP) = vs.GetObjectVariablePoint(h, index)
		VectorScript: FUNCTION GetObjectVariablePoint(h:HANDLE; index:INTEGER; VAR outPX, outPY, outPZ:REAL) : BOOLEAN;
		
		Category: Object Info
		Returns the value of a Vectorworks object property. Used with properties returning a 2D or 3D point value.
		For specific object selector index values, see the Appendix.
	'''
	pass
	return ( False  , # 
	         0,0,0   )


def GetObjectVariableReal(
		h    , # HANDLE  - Handle to object.     
		index  # INTEGER - Object property index.
		):
	'''
		Python: REAL = vs.GetObjectVariableReal(h, index)
		VectorScript: FUNCTION GetObjectVariableReal(h:HANDLE; index:INTEGER) : REAL;
		
		Category: Object Info
		Returns the value of a Vectorworks object property. Used with properties returning a REAL value. Always returns values in mm, regardless of document units.
	'''
	pass
	return 'REAL' # Returns the value of the property as a REAL value.


def GetObjectVariableString(
		h    , # HANDLE  - Handle to object.     
		index  # INTEGER - Object property index.
		):
	'''
		Python: STRING = vs.GetObjectVariableString(h, index)
		VectorScript: FUNCTION GetObjectVariableString(h:HANDLE; index:INTEGER) : STRING;
		
		Category: Object Info
		Returns the value of a Vectorworks object property. Used with properties returning a STRING value.
	'''
	pass
	return 'STRING' # Returns the value of the property as a STRING value.


def GetObjectWallHeight(
		objH , # HANDLE -  
		wallH  # HANDLE -  
		):
	'''
		Python: (BOOLEAN, height) = vs.GetObjectWallHeight(objH, wallH)
		VectorScript: FUNCTION GetObjectWallHeight(objH:HANDLE; wallH:HANDLE; VAR height:REAL) : BOOLEAN;
		
		Category: Objects - Walls
		Gets an object's height value in it's break record.
		The object (objH) must be contained in wall (wallH)  to succeed.
	'''
	pass
	return ( False  , # True or False upon successful setting of the flag.[[BR]][[BR]]False can occur for the following conditions:[[BR]]objH is null.[[BR]]wallH is null.[[BR]]objH is not contained in wallH.
	         0.0     )


def GetObjectWallOffset(
		objH , # HANDLE -  
		wallH  # HANDLE -  
		):
	'''
		Python: (BOOLEAN, offset) = vs.GetObjectWallOffset(objH, wallH)
		VectorScript: FUNCTION GetObjectWallOffset(objH:HANDLE; wallH:HANDLE; VAR offset:REAL) : BOOLEAN;
		
		Category: Objects - Walls
		Gets an object's offset value in it's break record.
		The object (objH) must be contained in wall (wallH)  to succeed.
	'''
	pass
	return ( False  , # True or False upon successful setting of the flag.[[BR]][[BR]]False can occur for the following conditions:[[BR]]objH is null.[[BR]]wallH is null.[[BR]]objH is not contained in wallH.
	         0.0     )


def GetObjEndMarker(
		object  # HANDLE - Handle to object.
		):
	'''
		Python: (BOOLEAN, style, angle, size, width, thicknessBasis, thickness, visibility) = vs.GetObjEndMarker(object)
		VectorScript: FUNCTION GetObjEndMarker(object:HANDLE; VAR style:LONGINT; VAR angle:INTEGER; VAR size:REAL; VAR width:REAL; VAR thicknessBasis:INTEGER; VAR thickness:REAL; VAR visibility:BOOLEAN) : BOOLEAN;
		
		Category: Object Attributes
		Gets all properties for an object's end marker. Return TRUE if operation was successful.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0      , 
	         0.0    , 
	         0.0    , 
	         0      , 
	         0.0    , 
	         False   )


def GetObjExpandTexture(
		obj  # HANDLE - Handle to object.
		):
	'''
		Python: BOOLEAN = vs.GetObjExpandTexture(obj)
		VectorScript: FUNCTION GetObjExpandTexture(obj:HANDLE) : BOOLEAN;
		
		Category: Textures
		Function GetObjExpandTexture returns whether the referenced objects' textures have been "expanded". When a texture is expanded, different components of an object can have different textures.
	'''
	pass
	return 'BOOLEAN' # 


def GetObjExtentsInWall(
		symH , # HANDLE -  
		wallH  # HANDLE -  
		):
	'''
		Python: (BOOLEAN, startPt, endPt) = vs.GetObjExtentsInWall(symH, wallH)
		VectorScript: FUNCTION GetObjExtentsInWall(symH:HANDLE; wallH:HANDLE; VAR startPtX, startPtY:REAL; VAR endPtX, endPtY:REAL) : BOOLEAN;
		
		Category: Objects - Walls
		Gets the extents of a Plugin object or symbol that is in a wall.  Returns the object's start point and end point along the wall line.
	'''
	pass
	return ( False  , # 
	         0,0    , 
	         0,0     )


def GetObjStoryBound(
		object , # HANDLE  - The object.                       
		boundID  # INTEGER - The identifier of the story bound.
		):
	'''
		Python: (BOOLEAN, boundType, boundStory, layerLevelType, offset) = vs.GetObjStoryBound(object, boundID)
		VectorScript: FUNCTION GetObjStoryBound(object:HANDLE; boundID:INTEGER; VAR boundType:INTEGER; VAR boundStory:INTEGER; VAR layerLevelType:STRING; VAR offset:REAL) : BOOLEAN;
		
		Category: Objects - Architectural
		Get the data of the specified story bound of this object.
	'''
	pass
	return ( False   , # Return TRUE if the operation is successful.
	         0       , 
	         0       , 
	         'string', 
	         0.0      )


def GetObjStoryBoundsAt(
		object, # HANDLE  - The object.                                                                                                               
		index   # INTEGER - Index of the story bound which ID will be returned. This index should be between 1 and the result of GetObjStoryBoundsCnt.
		):
	'''
		Python: INTEGER = vs.GetObjStoryBoundsAt(object, index)
		VectorScript: FUNCTION GetObjStoryBoundsAt(object:HANDLE; index:INTEGER) : INTEGER;
		
		Category: Objects - Architectural
		Return the story bound ID of the specified story bound index. The index is between 1 and the result of GetObjStoryBoundsCnt.
	'''
	pass
	return 'INTEGER' # Return the story bound ID.


def GetObjStoryBoundsCnt(
		object  # HANDLE - The object.
		):
	'''
		Python: INTEGER = vs.GetObjStoryBoundsCnt(object)
		VectorScript: FUNCTION GetObjStoryBoundsCnt(object:HANDLE) : INTEGER;
		
		Category: Objects - Architectural
		Return the number of story bounds defined for this object.
	'''
	pass
	return 'INTEGER' # The number of story bounds for this object.


def GetObjTypeProperties(
		ObjectType  # INTEGER - Object type whose properties are desired
		):
	'''
		Python: INTEGER = vs.GetObjTypeProperties(ObjectType)
		VectorScript: FUNCTION GetObjTypeProperties(ObjectType:INTEGER) : INTEGER;
		
		Category: Object Attributes
		Receives an object type and returns the properties of that object type
	'''
	pass
	return 'INTEGER' # Returns bit map of properties associated with an object's type


def GetObjWallBreakMode(
		objH     , # HANDLE         -  
		wallH    , # HANDLE         -  
		breakMode  # in/out INTEGER -  
		):
	'''
		Python: (Boolean, breakMode) = vs.GetObjWallBreakMode(objH, wallH, breakMode)
		VectorScript: FUNCTION GetObjWallBreakMode(objH:HANDLE; wallH:HANDLE; VAR breakMode:INTEGER) : Boolean;
		
		Category: Objects - Walls
		Returns the break mode for an object in a wall.
		1 - Full Break with Caps
		2 - Full Break no Caps
		3 - Half Break
		4 - No Break
		The object (objH) must be contained in wall (wallH)  to succeed.
	'''
	pass
	return ( False  , # True or False upon successful retrieving of the break mode.[[BR]][[BR]]False can occur for the following conditions:[[BR]]objH is null.[[BR]]wallH is null.[[BR]]objH is not contained in wallH.
	         0       )


def GetObjWallInsertMode(
		objH      , # HANDLE         -  
		wallH     , # HANDLE         -  
		insertMode  # in/out INTEGER -  
		):
	'''
		Python: (Boolean, insertMode) = vs.GetObjWallInsertMode(objH, wallH, insertMode)
		VectorScript: FUNCTION GetObjWallInsertMode(objH:HANDLE; wallH:HANDLE; VAR insertMode:INTEGER) : Boolean;
		
		Category: Objects - Walls
		Returns the insertion mode for an object in a wall.
		1 - Center
		2 - Leaf Edge
		3 - Right Edge
		The object (objH) must be contained in wall (wallH)  to succeed.
	'''
	pass
	return ( False  , # True or False upon successful retrieving of the insertion mode.[[BR]][[BR]]False can occur for the following conditions:[[BR]]objH is null.[[BR]]wallH is null.[[BR]]objH is not contained in wallH.
	         0       )


def GetOpacity(
		h  # HANDLE - The object which opacity will be get.
		):
	'''
		Python: opacity = vs.GetOpacity(h)
		VectorScript: PROCEDURE GetOpacity(h:HANDLE; VAR opacity:INTEGER);
		
		Category: Object Attributes
		Gets the opacity of and object. Opacity is obtained as percentage value in range [0-100].
	'''
	pass
	return ( 0 )


def GetOpacityByClass(
		h  # HANDLE -  
		):
	'''
		Python: isByClass = vs.GetOpacityByClass(h)
		VectorScript: PROCEDURE GetOpacityByClass(h:HANDLE; VAR isByClass:BOOLEAN);
		
		Category: Object Attributes
		Returns whether the object is using the class opacity.
	'''
	pass
	return ( False )


def GetOpacityByClassN(
		h  # HANDLE -  
		):
	'''
		Python: (isPenOpacityByClass, isFillOpacityByClass) = vs.GetOpacityByClassN(h)
		VectorScript: PROCEDURE GetOpacityByClassN(h:HANDLE; VAR isPenOpacityByClass:BOOLEAN; VAR isFillOpacityByClass:BOOLEAN);
		
		Category: Object Attributes
	'''
	pass
	return ( False, 
	         False )


def GetOpacityN(
		h  # HANDLE - Object handle to get the opacity values.
		):
	'''
		Python: (Boolean, outPenOpacity, outFillOpacity) = vs.GetOpacityN(h)
		VectorScript: FUNCTION GetOpacityN(h:HANDLE; VAR outPenOpacity:INTEGER; VAR outFillOpacity:INTEGER) : Boolean;
		
		Category: Object Attributes
	'''
	pass
	return ( False  , # 
	         0      , 
	         0       )


def GetOrigin(
		):
	'''
		Python: (x, y) = vs.GetOrigin()
		VectorScript: PROCEDURE GetOrigin(VAR x:REAL; VAR y:REAL);
		
		Category: Document Settings
		Procedure GetOrigin returns the current origin location relative to the center of the page.
	'''
	pass
	return ( 0.0, 
	         0.0 )


def GetOriginInDocUnits(
		):
	'''
		Python: (x, y) = vs.GetOriginInDocUnits()
		VectorScript: PROCEDURE GetOriginInDocUnits(VAR x:REAL; VAR y:REAL);
		
		Category: Document Settings
		Procedure GetOriginInDocUnits returns the current origin location relative to the center of the page in current units. It fixes the problem existing for GetOrigin (see remarks). The behavior is the same while used during objects reset and in commands.
	'''
	pass
	return ( 0.0, 
	         0.0 )


def GetOSVersion(
		):
	'''
		Python: (major, minor, incr) = vs.GetOSVersion()
		VectorScript: PROCEDURE GetOSVersion(VAR major:LONGINT; VAR minor:LONGINT; VAR incr:LONGINT);
		
		Category: Utility
		Returns the version of the current operating system.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetPaletteVisibility(
		paletteName  # STRING - Name of the palette
		):
	'''
		Python: BOOLEAN = vs.GetPaletteVisibility(paletteName)
		VectorScript: FUNCTION GetPaletteVisibility(paletteName:STRING) : BOOLEAN;
		
		Category: Utility
		Gets the visibility state of a palette.
	'''
	pass
	return 'BOOLEAN' # Returns true if the palette is visible, false otherwise.


def GetParameterOnNurbsCurve(
		h    , # HANDLE  -  
		point  # POINT3D -  
		):
	'''
		Python: (BOOLEAN, parameter, index) = vs.GetParameterOnNurbsCurve(h, point)
		VectorScript: FUNCTION GetParameterOnNurbsCurve(h:HANDLE; pointX, pointY, pointZ:REAL; VAR parameter:REAL; VAR index:LONGINT) : BOOLEAN;
		
		Category: Objects - NURBS
		Given a NURBS curve handle and a point (in world space), this function returns the parameter of the point obtained by projecting the input point. The function also returns the index of the piece in the piecewise NURBS curve on which the projected point lies.
	'''
	pass
	return ( False  , # 
	         0.0    , 
	         0       )


def GetParametricRecord(
		h  # HANDLE - Handle to a parametric object
		):
	'''
		Python: HANDLE = vs.GetParametricRecord(h)
		VectorScript: FUNCTION GetParametricRecord(h:HANDLE) : HANDLE;
		
		Category: Database / Record
		Returns the handle to the parametric record attached the referenced object.
		Parametric record is a hidden record format containing the parameter values of the parametric object.
		Only parametric objects have parametric records.
	'''
	pass
	return 'HANDLE' # Returns a handle to the record, or NIL if the record doesn't exist (e.g. not a parametric object passed)


def GetParamStyleType(
		hStyle   , # HANDLE - Handle to a symbol containing a plug-in style.        
		paramName  # STRING - Universal name of a parameter to check for style type.
		):
	'''
		Python: INTEGER = vs.GetParamStyleType(hStyle, paramName)
		VectorScript: FUNCTION GetParamStyleType(hStyle:HANDLE; paramName:STRING) : INTEGER;
		
		Category: Objects - Custom
		Returns the style type (by instance or by style) for a parameter.
	'''
	pass
	return 'INTEGER' # 0 = Parametrer is an instance parameter[[BR]]1 = Parameter is a style parameter.[[BR]][[BR]]If the object in unstyled or the parameter name if not found 0 will be returned and should be treated as an instance parameter.


def GetParent(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: HANDLE = vs.GetParent(h)
		VectorScript: FUNCTION GetParent(h:HANDLE) : HANDLE;
		
		Category: Object Info
		Returns a handle to the parent container object of the referenced object. If the object does not have a container, a handle to the objects' layer will be returned.
	'''
	pass
	return 'HANDLE' # Returns a HANDLE to the parent object or layer.


def GetPatternData(
		dialogID, # LONGINT -  
		itemID    # LONGINT -  
		):
	'''
		Python: (patternIndex, foreColor, backColor) = vs.GetPatternData(dialogID, itemID)
		VectorScript: PROCEDURE GetPatternData(dialogID:LONGINT; itemID:LONGINT; VAR patternIndex:INTEGER; VAR foreColor:INTEGER; VAR backColor:INTEGER);
		
		Category: Dialogs - Modern
		Get current choice for pattern popup dialog control, and the displayed foreground and background color indexes.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetPenBack(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: (red, green, blue) = vs.GetPenBack(h)
		VectorScript: PROCEDURE GetPenBack(h:HANDLE; VAR red:LONGINT; VAR green:LONGINT; VAR blue:LONGINT);
		
		Category: Object Attributes
		Procedure GetPenBack returns the pen background color of the referenced object. RGB values are in the range of 0 65535.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetPenFore(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: (red, green, blue) = vs.GetPenFore(h)
		VectorScript: PROCEDURE GetPenFore(h:HANDLE; VAR red:LONGINT; VAR green:LONGINT; VAR blue:LONGINT);
		
		Category: Object Attributes
		Procedure GetPenFore returns the pen foreground color components of the referenced object. RGB values are in the range of 0 65535.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetPickObjectInfo(
		p  # POINT - Coordinate location to test for object.
		):
	'''
		Python: (BOOLEAN, h, subH, message) = vs.GetPickObjectInfo(p)
		VectorScript: FUNCTION GetPickObjectInfo(pX, pY:REAL; VAR h:HANDLE; VAR subH:HANDLE; VAR message:INTEGER) : BOOLEAN;
		
		Category: Utility
		Function GetPickObjectInfo returns a handle to an object found at a user selected point.
		Parameter subH returns a handle to a sub-selectable object (e.g., a symbol in a wall) if such an object exists. Parameter message is currently unused, and always returns 0.
	'''
	pass
	return ( False  , # 
	         0      , 
	         0      , 
	         0       )


def GetPlanarRef(
		h  # HANDLE - Handle to the object.
		):
	'''
		Python: LONGINT = vs.GetPlanarRef(h)
		VectorScript: FUNCTION GetPlanarRef(h:HANDLE) : LONGINT;
		
		Category: Object Info
		Get the plane ref ID of the specified object.
	'''
	pass
	return 'LONGINT' # 


def GetPlantToolInitialized():
	'''
		Python: BOOLEAN = vs.GetPlantToolInitialized()
		VectorScript: FUNCTION GetPlantToolInitialized : BOOLEAN;
		
		Category: Utility
		Returns whether or not the plant tool has been initialized or not.
	'''
	pass
	return 'BOOLEAN' # 


def GetPlantToolPlacementMode():
	'''
		Python: INTEGER = vs.GetPlantToolPlacementMode()
		VectorScript: FUNCTION GetPlantToolPlacementMode : INTEGER;
		
		Category: Utility
		This returns the current placement mode stored in the plant tool
	'''
	pass
	return 'INTEGER' # 


def GetPlantToolPlantName():
	'''
		Python: STRING = vs.GetPlantToolPlantName()
		VectorScript: FUNCTION GetPlantToolPlantName : STRING;
		
		Category: Utility
		Returns the name of the current plant that is stored in the plant tool.
	'''
	pass
	return 'STRING' # 


def GetPlantToolSpacing():
	'''
		Python: REAL = vs.GetPlantToolSpacing()
		VectorScript: FUNCTION GetPlantToolSpacing : REAL;
		
		Category: Utility
		This returns the spacing that is currently stored in the plant tool.
	'''
	pass
	return 'REAL' # 


def GetPluginChoiceIndex(
		inPluginName   , # STRING - The universal name of the plug-in.  
		inParameterName, # STRING - The universal name of the parameter.
		inChoiceName     # STRING - The universal name of the choice.   
		):
	'''
		Python: (BOOLEAN, outIndex) = vs.GetPluginChoiceIndex(inPluginName, inParameterName, inChoiceName)
		VectorScript: FUNCTION GetPluginChoiceIndex(inPluginName:STRING; inParameterName:STRING; inChoiceName:STRING; VAR outIndex:INTEGER) : BOOLEAN;
		
		Category: Objects - Custom
		Returns true with outIndex as specified by inPluginNameand inParameterName.  Each of the input names are universal names.
	'''
	pass
	return ( False  , # Returns true if the function succeeded.
	         0       )


def GetPluginInfo(
		):
	'''
		Python: (BOOLEAN, pluginName, recordHand) = vs.GetPluginInfo()
		VectorScript: FUNCTION GetPluginInfo(VAR pluginName:STRING; VAR recordHand:HANDLE) : BOOLEAN;
		
		Category: Objects - Custom
		Returns the name and attached parameter record of the currently executing plug-in. Use with menu command or tool item plug-ins.
	'''
	pass
	return ( False   , # 
	         'string', 
	         0        )


def GetPluginString(
		stringIndex  # INTEGER - The index of the string as represented in the plug-in editor.
		):
	'''
		Python: DYNARRAY of CHAR = vs.GetPluginString(stringIndex)
		VectorScript: FUNCTION GetPluginString(stringIndex:INTEGER) : DYNARRAY of CHAR;
		
		Category: Objects - Custom
		Returns the string specified by stringIndex. The strings are created using the "Strings" button in the plug-in editor.
	'''
	pass
	return 'DYNARRAY[] of CHAR' # The requested string.


def GetPluginStyle(
		hObject  # HANDLE - Handle to a plug-in object
		):
	'''
		Python: STRING = vs.GetPluginStyle(hObject)
		VectorScript: FUNCTION GetPluginStyle(hObject:HANDLE) : STRING;
		
		Category: Objects - Custom
		Get the name of the plug-in style for an object.
	'''
	pass
	return 'STRING' # Returns the name of the plug-in style associated with an object.[[BR]][[BR]]


def GetPluginStyleSymbol(
		hObject, # HANDLE        - Handle to a plug-in object.                                                            
		hSymDef  # in/out HANDLE - Hanlde to a symbol definition that contrains the plug-in style associated with hObject.
		):
	'''
		Python: (BOOLEAN, hSymDef) = vs.GetPluginStyleSymbol(hObject, hSymDef)
		VectorScript: FUNCTION GetPluginStyleSymbol(hObject:HANDLE; VAR hSymDef:HANDLE) : BOOLEAN;
		
		Category: Objects - Custom
		Retrieves the handled to a symbol that defines the plug-in style for a given plug-in object.
	'''
	pass
	return ( False  , # TRUE if the object is styled.[[BR]]FALSE if the object is uynstyled.
	         0       )


def GetPointAndParameterOnNurbsCurveAtGivenLength(
		inNurbCurve      , # HANDLE - Handle to the NURBS curve.                                    
		inPercentOfLength  # REAL   - Specify location on curve as percent of total length.  (0 - 1)
		):
	'''
		Python: (BOOLEAN, p, outParam, outIndex) = vs.GetPointAndParameterOnNurbsCurveAtGivenLength(inNurbCurve, inPercentOfLength)
		VectorScript: FUNCTION GetPointAndParameterOnNurbsCurveAtGivenLength(inNurbCurve:HANDLE; inPercentOfLength:REAL; VAR pX, pY, pZ:REAL; VAR outParam:REAL; VAR outIndex:LONGINT) : BOOLEAN;
		
		Category: Objects - NURBS
		Gets point, parametric parameter, and curve index of specified location along a NURBS Curve.
	'''
	pass
	return ( False  , # 
	         0,0,0  , 
	         0.0    , 
	         0       )


def GetPolylineArcMaxRadius(
		hPoly    , # HANDLE  - Handle of the poliline        
		vertexNum  # INTEGER - Index of vertex to be queried.
		):
	'''
		Python: REAL = vs.GetPolylineArcMaxRadius(hPoly, vertexNum)
		VectorScript: FUNCTION GetPolylineArcMaxRadius(hPoly:HANDLE; vertexNum:INTEGER) : REAL;
		
		Category: Objects - Polys
		Return a maximum radius of the specified vertex of type arc or radius of a polyline.
	'''
	pass
	return 'REAL' # If the vertex type is not arc or radius it returns -1.


def GetPolylineVertex(
		obj      , # HANDLE  - Handle to object.              
		vertexNum  # INTEGER - Index of vertex to be queried. 
		):
	'''
		Python: (p, vertexType, arcRadius) = vs.GetPolylineVertex(obj, vertexNum)
		VectorScript: PROCEDURE GetPolylineVertex(obj:HANDLE; vertexNum:INTEGER; VAR pX, pY:REAL; VAR vertexType:INTEGER; VAR arcRadius:REAL);
		
		Category: Objects - Polys
		Returns information about the specified polyline vertex.
		Note that vertexNum is 1-based for Polygons and Polylines, and 0-based for 3D Polylines.
	'''
	pass
	return ( 0,0, 
	         0  , 
	         0.0 )


def GetPolyPt(
		objectHd, # HANDLE  - Handle to polygon.                
		index     # INTEGER - Index of vertex (range of 1 to n).
		):
	'''
		Python: p = vs.GetPolyPt(objectHd, index)
		VectorScript: PROCEDURE GetPolyPt(objectHd:HANDLE; index:INTEGER; VAR pX, pY:REAL);
		
		Category: Objects - Polys
		Procedure GetPolyPt returns the coordinates of a specified vertex of the referenced object.
	'''
	pass
	return ( 0,0 )


def GetPolyPt3D(
		objectHd, # HANDLE  - Handle to 3D mesh or polygon.       
		index     # INTEGER - Index of vertex (range of 0 to n-1).
		):
	'''
		Python: p = vs.GetPolyPt3D(objectHd, index)
		VectorScript: PROCEDURE GetPolyPt3D(objectHd:HANDLE; index:INTEGER; VAR pX, pY, pZ:REAL);
		
		Category: Objects - 3D
		Procedure GetPolyPt3D returns the coordinates of the specified vertex of the referenced mesh, 3D polygon, or NURBS curve object.
		Error checking for valid index values must be provided by the programmer.
	'''
	pass
	return ( 0,0,0 )


def GetPopUpChoiceIndex(
		dialogID   , # LONGINT - the dialog identifier given by CreateLayout or CreateResizableLayout                             
		componentID, # LONGINT - The identifier of the component which choice index will be retrieved from by a given choice name.
		itemText     # STRING  - The name of the choice which index will be obtained.                                             
		):
	'''
		Python: itemIndex = vs.GetPopUpChoiceIndex(dialogID, componentID, itemText)
		VectorScript: PROCEDURE GetPopUpChoiceIndex(dialogID:LONGINT; componentID:LONGINT; itemText:STRING; VAR itemIndex:INTEGER);
		
		Category: Dialogs - Modern
		Gets the zero based index of the first choice in the pop-up which has itemText name. If there is no choice named itemText in the pop-up itemIndex is set to -1.
	'''
	pass
	return ( 0 )


def GetPref(
		prefIndex  # INTEGER - Preference item constant.
		):
	'''
		Python: BOOLEAN = vs.GetPref(prefIndex)
		VectorScript: FUNCTION GetPref(prefIndex:INTEGER) : BOOLEAN;
		
		Category: Document Settings
		Function GetPref returns the on-off status of the specified preference item.
	'''
	pass
	return 'BOOLEAN' # 


def GetPrefInt(
		prefIndex  # INTEGER - Preference item constant.
		):
	'''
		Python: INTEGER = vs.GetPrefInt(prefIndex)
		VectorScript: FUNCTION GetPrefInt(prefIndex:INTEGER) : INTEGER;
		
		Category: Document Settings
		Function GetPrefInt returns the value of a numeric Vectorworks preference setting.
	'''
	pass
	return 'INTEGER' # The status of the requested preference. If the preference is a checkbox, then [[name]] returns TRUE or false. If it is a radio group or editable text item, then [[name]] returns an integer value representing that setting.


def GetPrefLongInt(
		prefIndex  # INTEGER - Preference item index.
		):
	'''
		Python: LONGINT = vs.GetPrefLongInt(prefIndex)
		VectorScript: FUNCTION GetPrefLongInt(prefIndex:INTEGER) : LONGINT;
		
		Category: Document Settings
		Returns the value of a Vectorworks preference setting. Used with preference settings returning a LONGINT value.
	'''
	pass
	return 'LONGINT' # Returns the value of the specified preference.[[BR]][[BR]]


def GetPrefReal(
		prefIndex  # INTEGER - Preference item index.
		):
	'''
		Python: REAL = vs.GetPrefReal(prefIndex)
		VectorScript: FUNCTION GetPrefReal(prefIndex:INTEGER) : REAL;
		
		Category: Document Settings
		Returns the value of a Vectorworks preference setting. Used with preference settings returning a REAL value.
	'''
	pass
	return 'REAL' # Returns the value of the specified preference.


def GetPrefRGB(
		prefIndex  # INTEGER - Preference item constant
		):
	'''
		Python: (colorRV, colorGV, colorBV) = vs.GetPrefRGB(prefIndex)
		VectorScript: PROCEDURE GetPrefRGB(prefIndex:INTEGER; VAR colorRV:LONGINT; VAR colorGV:LONGINT; VAR colorBV:LONGINT);
		
		Category: Document Settings
		Procedure GetPrefRGB return the RGB color components of the specified preference item. The RGB values are in the range of 0 - 65535.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetPrefString(
		prefIndex  # INTEGER - Preference item index.
		):
	'''
		Python: STRING = vs.GetPrefString(prefIndex)
		VectorScript: FUNCTION GetPrefString(prefIndex:INTEGER) : STRING;
		
		Category: Document Settings
		Returns the value of a Vectorworks preference setting. Used with preference settings returning a STRING value.
	'''
	pass
	return 'STRING' # Returns the value of the specified preference.


def GetPreviousElement(
		XMLHandle  , # LONGINT            -  
		elementPath  # DYNARRAY[] of CHAR -  
		):
	'''
		Python: (INTEGER, value) = vs.GetPreviousElement(XMLHandle, elementPath)
		VectorScript: FUNCTION GetPreviousElement(XMLHandle:LONGINT; elementPath:DYNARRAY of CHAR; VAR value:DYNARRAY of CHAR) : INTEGER;
		
		Category: XML
		Returns the previous element (sibling) of the given element.
	'''
	pass
	return ( 0       , # 
	         'string' )


def GetPrimaryUnitInfo(
		):
	'''
		Python: (style, prec, dimPrec, format, angPrec, showMark, dispFrac) = vs.GetPrimaryUnitInfo()
		VectorScript: PROCEDURE GetPrimaryUnitInfo(VAR style:INTEGER; VAR prec:LONGINT; VAR dimPrec:LONGINT; VAR format:INTEGER; VAR angPrec:INTEGER; VAR showMark:BOOLEAN; VAR dispFrac:BOOLEAN);
		
		Category: Units
		Procedure GetPrimaryUnitInfo returns the primary units settings for the active document.
	'''
	pass
	return ( 0    , 
	         0    , 
	         0    , 
	         0    , 
	         0    , 
	         False, 
	         False )


def GetProduct(
		):
	'''
		Python: (product, modules) = vs.GetProduct()
		VectorScript: PROCEDURE GetProduct(VAR product:INTEGER; VAR modules:LONGINT);
		
		Category: Utility
		Identifies what NNA products and product packages are available in the current product installation.
		Obsolete as of 10. Use GetEnabledModules instead.
	'''
	pass
	return ( 0, 
	         0 )


def GetProjectFullPath(
		):
	'''
		Python: (BOOLEAN, fullPath) = vs.GetProjectFullPath()
		VectorScript: FUNCTION GetProjectFullPath(VAR fullPath:STRING) : BOOLEAN;
		
		Category: Project Sharing
		Gets the path and filename of the Project File for Project Sharing.
	'''
	pass
	return ( False   , # Returns True on success, False on failure or if not Project Sharing
	         'string' )


def GetProjection(
		theyLayer  # HANDLE - Layer which the projection is returned for.
		):
	'''
		Python: INTEGER = vs.GetProjection(theyLayer)
		VectorScript: FUNCTION GetProjection(theyLayer:HANDLE) : INTEGER;
		
		Category: View / Zoom
		Returns the projection index from the specified layer.
	'''
	pass
	return 'INTEGER' # 


def GetProjectionLocName(
		hLayer  # HANDLE -  
		):
	'''
		Python: (BOOLEAN, outProj) = vs.GetProjectionLocName(hLayer)
		VectorScript: FUNCTION GetProjectionLocName(hLayer:HANDLE; VAR outProj:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: GIS
		Get the projection format localized name
	'''
	pass
	return ( False   , # 
	         'string' )


def GetProjectionProj4(
		hLayer   , # HANDLE  -  
		esriStyle  # BOOLEAN -  
		):
	'''
		Python: (BOOLEAN, outProj4) = vs.GetProjectionProj4(hLayer, esriStyle)
		VectorScript: FUNCTION GetProjectionProj4(hLayer:HANDLE; esriStyle:BOOLEAN; VAR outProj4:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: GIS
		Get the projection information in Proj4 format.
	'''
	pass
	return ( False   , # 
	         'string' )


def GetProjectionWKT(
		hLayer   , # HANDLE  -  
		esriStyle  # BOOLEAN -  
		):
	'''
		Python: (BOOLEAN, outWKT) = vs.GetProjectionWKT(hLayer, esriStyle)
		VectorScript: FUNCTION GetProjectionWKT(hLayer:HANDLE; esriStyle:BOOLEAN; VAR outWKT:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: GIS
		Get the projection information in Well Known Text (WKT) format..
	'''
	pass
	return ( False   , # 
	         'string' )


def GetProjectUser(
		userId  # STRING - The userid to look up
		):
	'''
		Python: (BOOLEAN, fullName, permission) = vs.GetProjectUser(userId)
		VectorScript: FUNCTION GetProjectUser(userId:STRING; VAR fullName:STRING; VAR permission:INTEGER) : BOOLEAN;
		
		Category: Project Sharing
		For a given userid in the current Project, get their full name and permission level.
	'''
	pass
	return ( False   , # True on success, false on failure or not Project Sharing file.
	         'string', 
	         0        )


def GetProjectUserNames(
		):
	'''
		Python: (BOOLEAN, userArray) = vs.GetProjectUserNames()
		VectorScript: FUNCTION GetProjectUserNames(VAR userArray:ARRAY) : BOOLEAN;
		
		Category: Project Sharing
		Get a list of userids that are part of the current project.
	'''
	pass
	return ( False  , # True on success, false on failure or not Project Sharing file.
	         0       )


def GetPseudoIndFromDash(
		dashStyle  # LONGINT - Negative internal index of a dashed line type.
		):
	'''
		Python: (BOOLEAN, outPseudoIndex) = vs.GetPseudoIndFromDash(dashStyle)
		VectorScript: FUNCTION GetPseudoIndFromDash(dashStyle:LONGINT; VAR outPseudoIndex:INTEGER) : BOOLEAN;
		
		Category: Utility
		Supplies a pseudo index for a dashed style. The returned index is not guaranteed to produce the same line type from file to file, nor even in the same file if line types change.
		Returns TRUE if successful.
	'''
	pass
	return ( False  , # 
	         0       )


def GetPt(
		):
	'''
		Python: p = vs.GetPt()
		VectorScript: PROCEDURE GetPt(VAR pX, pY:REAL);
		
		Category: User Interactive
		Procedure GetPt switches the cursor to selection mode and allows the user to select a point in a Vectorworks document. This cannot be used if there is a function anywhere in the calling chain.
	'''
	pass
	return ( 0,0 )


def GetPt3D(
		useWPOnly  # BOOLEAN - TRUE if the returned point have to be on the active Working Plane. Snapping to arbitrary 3D geometry will produce vertical projection result on the WP; FALSE if the point can be arbitrary 3D point (produced, for example, by snapping to a 3D geometry)
		):
	'''
		Python: p = vs.GetPt3D(useWPOnly)
		VectorScript: PROCEDURE GetPt3D(VAR pX, pY, pZ:REAL; useWPOnly:BOOLEAN);
		
		Category: User Interactive
		Procedure GetPt3D switches the cursor to 3D selection mode and allows the user to select a point in a VectorWorks document. This cannot be used if there is a function anywhere in the calling chain.
	'''
	pass
	return ( 0,0,0 )


def GetPtInPoly(
		h  # HANDLE -  
		):
	'''
		Python: VECTOR = vs.GetPtInPoly(h)
		VectorScript: FUNCTION GetPtInPoly(h:HANDLE) : VECTOR;
		
		Category: Graphic Calculation
		Finds a point inside a polyline.
	'''
	pass
	return 'VECTOR' # 


def GetPtL(
		p1  # POINT - Coordinates of line start point.
		):
	'''
		Python: p2 = vs.GetPtL(p1)
		VectorScript: PROCEDURE GetPtL(p1X, p1Y:REAL; VAR p2X, p2Y:REAL);
		
		Category: User Interactive
		Procedure GetPtL creates a temporary "rubberband" line from a specified point to the user selected end point. This cannot be used if there is a function anywhere in the calling chain.
	'''
	pass
	return ( 0,0 )


def GetPtL3D(
		p1       , # POINT3D - Coordinates of line start point.                                                                                                                                                                                                                          
		useWPOnly  # BOOLEAN - TRUE if the returned point have to be on the active Working Plane. Snapping to arbitrary 3D geometry will produce vertical projection result on the WP; FALSE if the point can be arbitrary 3D point (produced, for example, by snapping to a 3D geometry)
		):
	'''
		Python: p2 = vs.GetPtL3D(p1, useWPOnly)
		VectorScript: PROCEDURE GetPtL3D(p1X, p1Y, p1Z:REAL; VAR p2X, p2Y, p2Z:REAL; useWPOnly:BOOLEAN);
		
		Category: User Interactive
		Procedure GetPtL3D creates a temporary "rubberband" 3D line from a specified point to the user selected end point. This cannot be used if there is a function anywhere in the calling chain.
	'''
	pass
	return ( 0,0,0 )


def GetRecord(
		h  , # HANDLE  - Handle to object.                               
		cnt  # INTEGER - Index of attached record (in a range of 1 -  n).
		):
	'''
		Python: HANDLE = vs.GetRecord(h, cnt)
		VectorScript: FUNCTION GetRecord(h:HANDLE; cnt:INTEGER) : HANDLE;
		
		Category: Database / Record
		Returns the handle to a specified record attached the referenced object.
	'''
	pass
	return 'HANDLE' # 


def GetRect(
		):
	'''
		Python: (p1, p2) = vs.GetRect()
		VectorScript: PROCEDURE GetRect(VAR p1X, p1Y:REAL; VAR p2X, p2Y:REAL);
		
		Category: User Interactive
		Procedure GetRect draws a temporary "rubberband" rectangle onscreen, similar to a selection marquee. The user defines the rectangle by selecting two points which define the top left and bottom right of the rectangle. This cannot be used if there is a function anywhere in the calling chain.
	'''
	pass
	return ( 0,0, 
	         0,0 )


def GetRect3D(
		useWP  # BOOLEAN - TRUE if the returned point have to be on the active Working Plane. Snapping to arbitrary 3D geometry will produce vertical projection result on the WP; FALSE if the point can be arbitrary 3D point (produced, for example, by snapping to a 3D geometry)
		):
	'''
		Python: (p1, p2) = vs.GetRect3D(useWP)
		VectorScript: PROCEDURE GetRect3D(VAR p1X, p1Y, p1Z:REAL; VAR p2X, p2Y, p2Z:REAL; useWP:BOOLEAN);
		
		Category: User Interactive
		Procedure GetRect3D draws a temporary "rubberband" 3D rectangle on the working plane. The user defines the rectangle by selecting two points which define the top left and bottom right of the rectangle. This cannot be used if there is a function anywhere in the calling chain.
	'''
	pass
	return ( 0,0,0, 
	         0,0,0 )


def GetResourceFromList(
		listID, # LONGINT - an ID for a resource list created by the BuildResourceList command.
		index   # LONGINT - an index into the list.                                            
		):
	'''
		Python: HANDLE = vs.GetResourceFromList(listID, index)
		VectorScript: FUNCTION GetResourceFromList(listID:LONGINT; index:LONGINT) : HANDLE;
		
		Category: Document List Handling
		Returns the indicated resource from the indicated resource list, if the resource is in the current document.  Otherwise it returns nil.
	'''
	pass
	return 'HANDLE' # 


def GetResourceString(
		id   , # INTEGER - The ID of the resource.          
		index  # INTEGER - The index of the string resource.
		):
	'''
		Python: theString = vs.GetResourceString(id, index)
		VectorScript: PROCEDURE GetResourceString(VAR theString:DYNARRAY of CHAR; id:INTEGER; index:INTEGER);
		
		Category: Strings
		Returns the specified resource string from a resource file.
	'''
	pass
	return ( 'string' )


def GetResourceTags(
		handle  # HANDLE - The handle to the resource.
		):
	'''
		Python: tags = vs.GetResourceTags(handle)
		VectorScript: PROCEDURE GetResourceTags(handle:HANDLE; VAR tags:ARRAY);
		
		Category: General Edit
		Gets the tags attached to the specified resource.
	'''
	pass
	return ( 0 )


def GetRField(
		h     , # HANDLE - Handle to object.           
		record, # STRING - Name of record format.      
		field   # STRING - Name of field to be queried.
		):
	'''
		Python: DYNARRAY of CHAR = vs.GetRField(h, record, field)
		VectorScript: FUNCTION GetRField(h:HANDLE; record:STRING; field:STRING) : DYNARRAY of CHAR;
		
		Category: Database / Record
		Returns string description of a value in the specified record field.
	'''
	pass
	return 'DYNARRAY[] of CHAR' # Returns the field value as a variable length string.


def GetRoofAttributes(
		theRoof  # HANDLE - Handle to roof object.
		):
	'''
		Python: (BOOLEAN, genGableWall, bearingInset, roofThick, miterType, vertMiter) = vs.GetRoofAttributes(theRoof)
		VectorScript: FUNCTION GetRoofAttributes(theRoof:HANDLE; VAR genGableWall:BOOLEAN; VAR bearingInset:REAL; VAR roofThick:REAL; VAR miterType:INTEGER; VAR vertMiter:REAL) : BOOLEAN;
		
		Category: Objects - Roofs
		Function GetRoofAttributes returns the attributes of the referenced roof object.
	'''
	pass
	return ( False  , # 
	         False  , 
	         0.0    , 
	         0.0    , 
	         0      , 
	         0.0     )


def GetRoofEdge(
		theRoof, # HANDLE  - Handle to roof.                          
		index    # INTEGER - Index of roof edge (in a range of 1 - n).
		):
	'''
		Python: (BOOLEAN, vertexPt, slope, projection, eaveHeight) = vs.GetRoofEdge(theRoof, index)
		VectorScript: FUNCTION GetRoofEdge(theRoof:HANDLE; index:INTEGER; VAR vertexPtX, vertexPtY:REAL; VAR slope:REAL; VAR projection:REAL; VAR eaveHeight:REAL) : BOOLEAN;
		
		Category: Objects - Roofs
		Procedure GetRoofEdge returns the definition attributes of a roof edge for the referenced roof object.
	'''
	pass
	return ( False  , # 
	         0,0    , 
	         0.0    , 
	         0.0    , 
	         0.0     )


def GetRoofElementType(
		roofObject, # HANDLE  - Handle to roof object.
		dormerID    # INTEGER - Index of roof element.
		):
	'''
		Python: (edgeIndex, isDormer, dormerType) = vs.GetRoofElementType(roofObject, dormerID)
		VectorScript: PROCEDURE GetRoofElementType(roofObject:HANDLE; dormerID:INTEGER; VAR edgeIndex:INTEGER; VAR isDormer:BOOLEAN; VAR dormerType:INTEGER);
		
		Category: Objects - Roofs
		Returns information on the specified roof element.  The dormer type value is one of the following: 1 for Trapezium Dormer, 2 for Saddle Dormer, 3 for Shed Dormer, 4 for Slope Dormer, 5 for Bat Dormer.
	'''
	pass
	return ( 0    , 
	         False, 
	         0     )


def GetRoofFaceAttrib(
		roofFace  # HANDLE - Handle to roof face object.
		):
	'''
		Python: (roofRise, roofRun, miterType, holeStyle, vertPart, thickness) = vs.GetRoofFaceAttrib(roofFace)
		VectorScript: PROCEDURE GetRoofFaceAttrib(roofFace:HANDLE; VAR roofRise:REAL; VAR roofRun:REAL; VAR miterType:INTEGER; VAR holeStyle:INTEGER; VAR vertPart:REAL; VAR thickness:REAL);
		
		Category: Objects - Roofs
		Returns information on the referenced roof face object.
	'''
	pass
	return ( 0.0, 
	         0.0, 
	         0  , 
	         0  , 
	         0.0, 
	         0.0 )


def GetRoofFaceCoords(
		h  # HANDLE - Handle to roof face object.
		):
	'''
		Python: (axis1, axis2, Zaxis, upslope) = vs.GetRoofFaceCoords(h)
		VectorScript: PROCEDURE GetRoofFaceCoords(h:HANDLE; VAR axis1X, axis1Y:REAL; VAR axis2X, axis2Y:REAL; VAR Zaxis:REAL; VAR upslopeX, upslopeY:REAL);
		
		Category: Objects - Roofs
		Returns the coordinates of the defining geometry of a roof face.
	'''
	pass
	return ( 0,0, 
	         0,0, 
	         0.0, 
	         0,0 )


def GetRoofPreferences():
	'''
		Python: HANDLE = vs.GetRoofPreferences()
		VectorScript: FUNCTION GetRoofPreferences : HANDLE;
		
		Category: Objects - Architectural
		Gets the Roof Preferences. This can be used with the component calls and the Style selectors.
	'''
	pass
	return 'HANDLE' # The Roof Preferences.


def GetRoofPrefStyle():
	'''
		Python: LONGINT = vs.GetRoofPrefStyle()
		VectorScript: FUNCTION GetRoofPrefStyle : LONGINT;
		
		Category: Objects - Architectural
		Gets the Roof Style of the Roof Preferences.
	'''
	pass
	return 'LONGINT' # The ref number of the Roof Style of the Roof Preferences. 0 for unstyled.


def GetRoofStyle(
		roof  # HANDLE - The roof.
		):
	'''
		Python: LONGINT = vs.GetRoofStyle(roof)
		VectorScript: FUNCTION GetRoofStyle(roof:HANDLE) : LONGINT;
		
		Category: Objects - Roofs
		Gets the Roof Style of a roof.
	'''
	pass
	return 'LONGINT' # The ref number of the Roof Style of the roof. 0 for unstyled.


def GetRoofVertices(
		roofObject  # HANDLE - Handle to roof.
		):
	'''
		Python: INTEGER = vs.GetRoofVertices(roofObject)
		VectorScript: FUNCTION GetRoofVertices(roofObject:HANDLE) : INTEGER;
		
		Category: Objects - Roofs
		Function GetRoofVertices returns the number of roof edges in the referenced roof object.
	'''
	pass
	return 'INTEGER' # 


def GetRoundingBase(
		):
	'''
		Python: (display, primary, secondary) = vs.GetRoundingBase()
		VectorScript: PROCEDURE GetRoundingBase(VAR display:INTEGER; VAR primary:INTEGER; VAR secondary:INTEGER);
		
		Category: Units
		Gets the rounding base (1, 2.5, or 5) for the display, primary units, and secondary units.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetRRDiam(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: (xDiam, yDiam) = vs.GetRRDiam(h)
		VectorScript: PROCEDURE GetRRDiam(h:HANDLE; VAR xDiam:REAL; VAR yDiam:REAL);
		
		Category: Objects - 2D
		Procedure GetRRDiam returns the horizontal and vertical diameters of the rounded corners of a rounded rectangle object.
	'''
	pass
	return ( 0.0, 
	         0.0 )


def GetSavedSetting(
		category, # STRING -  
		setting   # STRING -  
		):
	'''
		Python: (BOOLEAN, value) = vs.GetSavedSetting(category, setting)
		VectorScript: FUNCTION GetSavedSetting(category:STRING; setting:STRING; VAR value:STRING) : BOOLEAN;
		
		Category: Utility
		Reads a value from the saved settnigs file.  This can be used to remember various user settings between running sessions of Vectorworks.  For example, a script may want to remember a dialog's position or a font settings.  The saved settings should not be used for critical information, but rather for convenience settings.
		If the settings file is lost or damaged the script should revert to a reasonable default value, and typically this would not warrant an alert dialog.
	'''
	pass
	return ( False   , # Returns true is the requested setting is found and read from the saved settings file, false otherwise.  
	         'string' )


def GetScreen(
		):
	'''
		Python: (x1, y1, x2, y2) = vs.GetScreen()
		VectorScript: PROCEDURE GetScreen(VAR x1:INTEGER; VAR y1:INTEGER; VAR x2:INTEGER; VAR y2:INTEGER);
		
		Category: Utility
		Procedure GetScreen returns the top-left and bottom-right corners of the display screen. These values will change as different sized screens are used. This procedure can be utilized to aid in development of dialog boxes, or as a check of screen size for sizing or displaying custom dialogs.
	'''
	pass
	return ( 0, 
	         0, 
	         0, 
	         0 )


def GetScriptResource(
		scriptName  # STRING - The script name identifying the resource.
		):
	'''
		Python: (BOOLEAN, script, python) = vs.GetScriptResource(scriptName)
		VectorScript: FUNCTION GetScriptResource(scriptName:STRING; VAR script:DYNARRAY of CHAR; VAR python:BOOLEAN) : BOOLEAN;
		
		Category: General Edit
		Return the script text of the specified script resource.
	'''
	pass
	return ( False   , # Return TRUE if the creation was successful. The routine will fail if script with the specified name does't exist.
	         'string', 
	         False    )


def GetSDName(
		h  # HANDLE - Handle to symbol definition.
		):
	'''
		Python: STRING = vs.GetSDName(h)
		VectorScript: FUNCTION GetSDName(h:HANDLE) : STRING;
		
		Category: Objects - Symbols
		Function GetSDName returns the name of the referenced symbol definition.
	'''
	pass
	return 'STRING' # 


def GetSecondaryUnitInfo(
		):
	'''
		Python: (style, dimPrec, format, showMark, dispFrac) = vs.GetSecondaryUnitInfo()
		VectorScript: PROCEDURE GetSecondaryUnitInfo(VAR style:INTEGER; VAR dimPrec:LONGINT; VAR format:INTEGER; VAR showMark:BOOLEAN; VAR dispFrac:BOOLEAN);
		
		Category: Units
		Procedure GetSecondaryUnitInfo sets the secondary unit parameters for the active document.
	'''
	pass
	return ( 0    , 
	         0    , 
	         0    , 
	         False, 
	         False )


def GetSegPt1(
		h  # HANDLE - Handle to line.
		):
	'''
		Python: p = vs.GetSegPt1(h)
		VectorScript: PROCEDURE GetSegPt1(h:HANDLE; VAR pX, pY:REAL);
		
		Category: Objects - 2D
		Procedure GetSegPt1 returns the X-Y coordinates of the start point of the referenced line, wall, or linear dimension object.
	'''
	pass
	return ( 0,0 )


def GetSegPt2(
		h  # HANDLE - Handle to line.
		):
	'''
		Python: p = vs.GetSegPt2(h)
		VectorScript: PROCEDURE GetSegPt2(h:HANDLE; VAR pX, pY:REAL);
		
		Category: Objects - 2D
		Procedure GetSegPt2 returns the end point of the of the referenced line, wall, or linear dimension object.
	'''
	pass
	return ( 0,0 )


def GetSelectedChoiceIndex(
		dialogID   , # LONGINT - The dialog identifier given by CreateLayout or CreateResizableLayout
		componentID, # LONGINT - The identifier for the component that contains the choices.         
		startIndex   # INTEGER - The index at which to start looking for a selected item.            
		):
	'''
		Python: outSelectedIndex = vs.GetSelectedChoiceIndex(dialogID, componentID, startIndex)
		VectorScript: PROCEDURE GetSelectedChoiceIndex(dialogID:LONGINT; componentID:LONGINT; startIndex:INTEGER; VAR outSelectedIndex:INTEGER);
		
		Category: Dialogs - Modern
		Gets the index of the selected choice.
	'''
	pass
	return ( 0 )


def GetSelectedChoiceInfo(
		dialogID   , # LONGINT - The dialog identifier given by CreateLayout or CreateResizableLayout
		componentID, # LONGINT - The identifier for the component that contains the choices.         
		startIndex   # INTEGER - The index at which to start looking for a selected item.            
		):
	'''
		Python: (outSelectedIndex, outSelectedChoiceText) = vs.GetSelectedChoiceInfo(dialogID, componentID, startIndex)
		VectorScript: PROCEDURE GetSelectedChoiceInfo(dialogID:LONGINT; componentID:LONGINT; startIndex:INTEGER; VAR outSelectedIndex:INTEGER; VAR outSelectedChoiceText:STRING);
		
		Category: Dialogs - Modern
		Gets the index of the selected item and the text of the selected item in a menu.
	'''
	pass
	return ( 0       , 
	         'string' )


def GetSelectionRange(
		dialogID , # LONGINT -  
		controlID  # LONGINT -  
		):
	'''
		Python: (startPos, endPos) = vs.GetSelectionRange(dialogID, controlID)
		VectorScript: PROCEDURE GetSelectionRange(dialogID:LONGINT; controlID:LONGINT; VAR startPos:INTEGER; VAR endPos:INTEGER);
		
		Category: Dialogs - Modern
		Returns the range of the current selection for the specified control.
	'''
	pass
	return ( 0, 
	         0 )


def GetShaderRecord(
		texture, # HANDLE  - Get the shader record attached to this texture.                                          
		family   # LONGINT - The kind of shader to retrieve (1 = color, 2 = reflectivity, 3 = transparency, 4 = bump).
		):
	'''
		Python: HANDLE = vs.GetShaderRecord(texture, family)
		VectorScript: FUNCTION GetShaderRecord(texture:HANDLE; family:LONGINT) : HANDLE;
		
		Category: Textures
		Returns the shader record of the specified family (1 = color, 2 = reflectivity, 3 = transparency, 4 = bump), if one is attached to the texture.
	'''
	pass
	return 'HANDLE' # 


def GetShedAttributes(
		roofObject, # HANDLE  - Handle to roof.         
		dormerID    # INTEGER - Index of dormer element.
		):
	'''
		Python: (useHeight, heightDepth, bottomWidth, overhang, topSlope) = vs.GetShedAttributes(roofObject, dormerID)
		VectorScript: PROCEDURE GetShedAttributes(roofObject:HANDLE; dormerID:INTEGER; VAR useHeight:BOOLEAN; VAR heightDepth:REAL; VAR bottomWidth:REAL; VAR overhang:REAL; VAR topSlope:REAL);
		
		Category: Objects - Roofs
		Procedure GetShedAttributes returns the attributes of a shed dormer in the referenced roof.
	'''
	pass
	return ( False, 
	         0.0  , 
	         0.0  , 
	         0.0  , 
	         0.0   )


def GetSheetLayerUserOrigin(
		layerHandle  # HANDLE - Handle of the layer.
		):
	'''
		Python: (BOOLEAN, xOrigin, yOrigin) = vs.GetSheetLayerUserOrigin(layerHandle)
		VectorScript: FUNCTION GetSheetLayerUserOrigin(layerHandle:HANDLE; VAR xOrigin:REAL; VAR yOrigin:REAL) : BOOLEAN;
		
		Category: Layers
		Gets the user origin of the specified sheet layer.
	'''
	pass
	return ( False  , # 
	         0.0    , 
	         0.0     )


def GetSingularConstraint(
		typeOfConstraint, # INTEGER - Type of constraint to be returned.      
		obj             , # HANDLE  - Handle to object.                       
		vertexA         , # INTEGER - Vertex defining the constraint geometry.
		vertexB           # INTEGER - Vertex defining the constraint geometry.
		):
	'''
		Python: HANDLE = vs.GetSingularConstraint(typeOfConstraint, obj, vertexA, vertexB)
		VectorScript: FUNCTION GetSingularConstraint(typeOfConstraint:INTEGER; obj:HANDLE; vertexA:INTEGER; vertexB:INTEGER) : HANDLE;
		
		Category: Parametric Constraints
		Returns the type of constraint applied to the referenced object.
	'''
	pass
	return 'HANDLE' # Returns a HANDLE to the constraint if exists, otherwise returns NIL.


def GetSkylight(
		roofObject, # HANDLE  - Handle to roof.           
		skylightID  # INTEGER - Index of skylight element.
		):
	'''
		Python: (edgeIndex, cornerOffset, perpOffset, symName) = vs.GetSkylight(roofObject, skylightID)
		VectorScript: PROCEDURE GetSkylight(roofObject:HANDLE; skylightID:INTEGER; VAR edgeIndex:INTEGER; VAR cornerOffset:REAL; VAR perpOffset:REAL; VAR symName:LONGINT);
		
		Category: Objects - Roofs
		Function GetSkylight returns the definition attributes of a specified skylight in the referenced roof object.
	'''
	pass
	return ( 0  , 
	         0.0, 
	         0.0, 
	         0   )


def GetSlabHeight(
		slab  # HANDLE - The slab.
		):
	'''
		Python: REAL = vs.GetSlabHeight(slab)
		VectorScript: FUNCTION GetSlabHeight(slab:HANDLE) : REAL;
		
		Category: Objects - Architectural
		Gets the height of a slab.
	'''
	pass
	return 'REAL' # The height of the slab.


def GetSlabPreferences():
	'''
		Python: HANDLE = vs.GetSlabPreferences()
		VectorScript: FUNCTION GetSlabPreferences : HANDLE;
		
		Category: Objects - Architectural
		Gets the Slab Preferences. This can be used with the component calls and the Style selectors.
	'''
	pass
	return 'HANDLE' # The Slab Preferences.


def GetSlabPreferencesStyle():
	'''
		Python: LONGINT = vs.GetSlabPreferencesStyle()
		VectorScript: FUNCTION GetSlabPreferencesStyle : LONGINT;
		
		Category: Objects - Architectural
		Gets the Slab Style of the Slab Preferences.
	'''
	pass
	return 'LONGINT' # The ref number of the Slab Style of the Slab Preferences. 0 for unstyled.


def GetSlabStyle(
		slab  # HANDLE - The slab.
		):
	'''
		Python: LONGINT = vs.GetSlabStyle(slab)
		VectorScript: FUNCTION GetSlabStyle(slab:HANDLE) : LONGINT;
		
		Category: Objects - Architectural
		Gets the Slab Style of a slab.
	'''
	pass
	return 'LONGINT' # The ref number of the Slab Style of the slab. 0 for unstyled.


def GetSprdSortSum(
		sheetHd, # HANDLE  - Handle to worksheet.         
		row      # INTEGER - Worksheet database row index.
		):
	'''
		Python: (sortCol1, sortCol2, sortCol3, sumCol) = vs.GetSprdSortSum(sheetHd, row)
		VectorScript: PROCEDURE GetSprdSortSum(sheetHd:HANDLE; row:INTEGER; VAR sortCol1:INTEGER; VAR sortCol2:INTEGER; VAR sortCol3:INTEGER; VAR sumCol:INTEGER);
		
		Category: Worksheets
		Procedure GetSprdSortSum returns sorting and summation options for a database row in the referenced worksheet.
	'''
	pass
	return ( 0, 
	         0, 
	         0, 
	         0 )


def GetSprdSortSumColumns(
		sheetHd, # HANDLE  - Handle to worksheet.       
		row      # INTEGER - Database row to be queried.
		):
	'''
		Python: (sortCol1, sortCol2, sortCol3, sumCol1, sumCol2, sumCol3) = vs.GetSprdSortSumColumns(sheetHd, row)
		VectorScript: PROCEDURE GetSprdSortSumColumns(sheetHd:HANDLE; row:INTEGER; VAR sortCol1:INTEGER; VAR sortCol2:INTEGER; VAR sortCol3:INTEGER; VAR sumCol1:INTEGER; VAR sumCol2:INTEGER; VAR sumCol3:INTEGER);
		
		Category: Worksheets
		Returns the sorting and summation options for a database row.
	'''
	pass
	return ( 0, 
	         0, 
	         0, 
	         0, 
	         0, 
	         0 )


def GetSpreadAngle(
		h  # HANDLE - Handle to light.
		):
	'''
		Python: spreadAngleR = vs.GetSpreadAngle(h)
		VectorScript: PROCEDURE GetSpreadAngle(h:HANDLE; VAR spreadAngleR:REAL);
		
		Category: Objects - Lights
		Procedure GetSpreadAngle returns the spread angle of the referenced spot light.
	'''
	pass
	return ( 0.0 )


def GetStoryAbove(
		story  # HANDLE - The indicated Story for which the Story above it is desired.
		):
	'''
		Python: HANDLE = vs.GetStoryAbove(story)
		VectorScript: FUNCTION GetStoryAbove(story:HANDLE) : HANDLE;
		
		Category: Layers
		Returns the Story above the indicated Story. Returns NULL if there is none. If passed a NULL handle, returns the top-most Story in the current drawing.
	'''
	pass
	return 'HANDLE' # The Story above the indicated Story, or NULL if there is none. If a NULL handle is passed in, the topmost Story in the current drawing.


def GetStoryBelow(
		story  # HANDLE - The indicated Story for which the Story below it is desired
		):
	'''
		Python: HANDLE = vs.GetStoryBelow(story)
		VectorScript: FUNCTION GetStoryBelow(story:HANDLE) : HANDLE;
		
		Category: Layers
		Returns the Story below the indicated Story. Returns NULL if there is none. If passed a NULL handle, returns the bottom-most Story in the current drawing.
	'''
	pass
	return 'HANDLE' # The Story below the indicated Story, or NULL if there is none. If a NULL handle is passed in, the bottom-most Story in the current drawing.


def GetStoryBoundChoiceStrings(
		story   , # HANDLE  - The story relative to which to get the strings. Nil gets a generic list of strings.
		topBound  # BOOLEAN - Whether to get the strings for a top bound or a bottom bound.                      
		):
	'''
		Python: strings = vs.GetStoryBoundChoiceStrings(story, topBound)
		VectorScript: PROCEDURE GetStoryBoundChoiceStrings(story:HANDLE; topBound:BOOLEAN; VAR strings:ARRAY);
		
		Category: Dialogs - Modern
		Gets the choice strings for a story bound control.
	'''
	pass
	return ( 0 )


def GetStoryBoundDataFromChoiceString(
		choiceString  # STRING - The choice string that represents the story bound data.
		):
	'''
		Python: (boundType, boundStory, layerLevelType) = vs.GetStoryBoundDataFromChoiceString(choiceString)
		VectorScript: PROCEDURE GetStoryBoundDataFromChoiceString(choiceString:STRING; VAR boundType:INTEGER; VAR boundStory:INTEGER; VAR layerLevelType:STRING);
		
		Category: Dialogs - Modern
		Gets the story bound data from a story bound choice string.
	'''
	pass
	return ( 0       , 
	         0       , 
	         'string' )


def GetStoryChoiceStrsN(
		story         , # HANDLE  - The story relative to which to get the strings. Nil gets a generic list of strings.                                          
		boundSelection  # INTEGER - Type of bounds strings being requested: 0 for Top Bound; 1 for Dual Bound (combines both top and bottom); 2 for Bottom Bound.
		):
	'''
		Python: strings = vs.GetStoryChoiceStrsN(story, boundSelection)
		VectorScript: PROCEDURE GetStoryChoiceStrsN(story:HANDLE; VAR strings:ARRAY; boundSelection:INTEGER);
		
		Category: Dialogs - Modern
		Gets story bound strings to supply to the bound popup. Can request strings for top bound, bottom bound, or dual (both) bounds.
	'''
	pass
	return ( 0 )


def GetStoryElevation(
		story  # HANDLE - The Story whose elevation is desired.
		):
	'''
		Python: REAL = vs.GetStoryElevation(story)
		VectorScript: FUNCTION GetStoryElevation(story:HANDLE) : REAL;
		
		Category: Layers
		Returns the elevaton of the indicated Story.
	'''
	pass
	return 'REAL' # The elevation of the Story.


def GetStoryLayerInfo(
		index  # INTEGER - Index of story.
		):
	'''
		Python: (Boolean, name, scaleFactor, layerLevelType, eleveationOffset, defaultWallHeight) = vs.GetStoryLayerInfo(index)
		VectorScript: FUNCTION GetStoryLayerInfo(index:INTEGER; VAR name:STRING; VAR scaleFactor:REAL; VAR layerLevelType:STRING; VAR eleveationOffset:REAL; VAR defaultWallHeight:REAL) : Boolean;
		
		Category: Objects - Architectural
		Returns information on the given story layer template
	'''
	pass
	return ( False   , # Boolean - TRUE if the story at given index was found, FALSE if no story was found at the given index.
	         'string', 
	         0.0     , 
	         'string', 
	         0.0     , 
	         0.0      )


def GetStoryLayerTemplateName(
		index  # INTEGER - The index of the Story Layer Template whose name is desired.
		):
	'''
		Python: STRING = vs.GetStoryLayerTemplateName(index)
		VectorScript: FUNCTION GetStoryLayerTemplateName(index:INTEGER) : STRING;
		
		Category: Layers
		Returns the name of the nth Story Layer Template in the file. For example, if 3 is passed in, it will return the name of the 3rd Story Layer Template in the file.
	'''
	pass
	return 'STRING' # The name of the nth Story Layer Template.


def GetStoryOfLayer(
		layer  # HANDLE - The Layer for which the associated Story is returned.
		):
	'''
		Python: HANDLE = vs.GetStoryOfLayer(layer)
		VectorScript: FUNCTION GetStoryOfLayer(layer:HANDLE) : HANDLE;
		
		Category: Layers
		Returns the Story that the indicated Layer is associated with. Returns NULL if the Layer is not associated with a Story.
	'''
	pass
	return 'HANDLE' # The Story associated with the Layer, which may be NULL.


def GetStorySuffix(
		story  # HANDLE - The Story whose suffix is desired.
		):
	'''
		Python: STRING = vs.GetStorySuffix(story)
		VectorScript: FUNCTION GetStorySuffix(story:HANDLE) : STRING;
		
		Category: Layers
		Returns the suffix of the indicated Story.
	'''
	pass
	return 'STRING' # The suffix of the indicated Story.


def GetSymbolOptionsN(
		name  # STRING - Name of symbol.
		):
	'''
		Python: (insertMode, breakMode, className) = vs.GetSymbolOptionsN(name)
		VectorScript: PROCEDURE GetSymbolOptionsN(name:STRING; VAR insertMode:INTEGER; VAR breakMode:INTEGER; VAR className:STRING);
		
		Category: Objects - Symbols
		Returns default class, insert  options, and break options for the specified symbol.
	'''
	pass
	return ( 0       , 
	         0       , 
	         'string' )


def GetSymbolType(
		objectHandle  # HANDLE - Handle to a symbol instance. 
		):
	'''
		Python: INTEGER = vs.GetSymbolType(objectHandle)
		VectorScript: FUNCTION GetSymbolType(objectHandle:HANDLE) : INTEGER;
		
		Category: Objects - Symbols
		Determines the type of the specified symbol instance.  The return values are:
		0 - 2D Only
		1 - 3D Only
		2 - Hybrid
	'''
	pass
	return 'INTEGER' # -1 = error.  Possibly wrong type of object passed in.[[BR]]0 = 2D Symbol[[BR]]1 = 3D Symbol[[BR]]2 = Hybrid Symbol


def GetSymBrightMult(
		symbol  # HANDLE - Handle to symbol.
		):
	'''
		Python: INTEGER = vs.GetSymBrightMult(symbol)
		VectorScript: FUNCTION GetSymBrightMult(symbol:HANDLE) : INTEGER;
		
		Category: Objects - Symbols
		Function GetSymBrightMult returns the brightness multiplier of the referenced symbol.
		The brightness multiplier is used for symbols that contains lights.  This value is a percentage of the symbol definition's light brightness.
	'''
	pass
	return 'INTEGER' # 


def GetSymDefSubType(
		hSymDef  # HANDLE - Handle to a symbol definition contaiing a plug-in style.
		):
	'''
		Python: INTEGER = vs.GetSymDefSubType(hSymDef)
		VectorScript: FUNCTION GetSymDefSubType(hSymDef:HANDLE) : INTEGER;
		
		Category: Objects - Symbols
		Returns the sub type defined for a symbol definiiton. This is used when creating and using plug-in styles.
	'''
	pass
	return 'INTEGER' # 


def GetSymLoc(
		symHd  # HANDLE - Handle to placed symbol.
		):
	'''
		Python: p = vs.GetSymLoc(symHd)
		VectorScript: PROCEDURE GetSymLoc(symHd:HANDLE; VAR pX, pY:REAL);
		
		Category: Object Info
		Procedure GetSymLoc returns the insertion point of the referenced symbol or plug-in object.
	'''
	pass
	return ( 0,0 )


def GetSymLoc3D(
		objectHandle  # HANDLE - Handle to a symbol instance or a plug-in object in the drawing.
		):
	'''
		Python: (x, y, z) = vs.GetSymLoc3D(objectHandle)
		VectorScript: PROCEDURE GetSymLoc3D(objectHandle:HANDLE; VAR x:REAL; VAR y:REAL; VAR z:REAL);
		
		Category: Objects - Symbols
		Determines the location of a specified symbol or plug-in object in 3D space.
	'''
	pass
	return ( 0.0, 
	         0.0, 
	         0.0 )


def GetSymName(
		symHd  # HANDLE - Handle to placed symbol.
		):
	'''
		Python: STRING = vs.GetSymName(symHd)
		VectorScript: FUNCTION GetSymName(symHd:HANDLE) : STRING;
		
		Category: Objects - Symbols
		Function GetSymName returns the symbol name of a referenced symbol in a Vectorworks document.
	'''
	pass
	return 'STRING' # 


def GetSymRot(
		symHd  # HANDLE - Handle to symbol.
		):
	'''
		Python: REAL = vs.GetSymRot(symHd)
		VectorScript: FUNCTION GetSymRot(symHd:HANDLE) : REAL;
		
		Category: Object Info
		Function GetSymRot returns the rotation angle (in degrees) of the referenced symbol or plug-in object.
	'''
	pass
	return 'REAL' # 


def GetTaperedComponent(
		object  # HANDLE - The object. Can be a slab, Slab Style, or the Slab Preferences.
		):
	'''
		Python: INTEGER = vs.GetTaperedComponent(object)
		VectorScript: FUNCTION GetTaperedComponent(object:HANDLE) : INTEGER;
		
		Category: Objects - Architectural
		Gets the tapered component of the object.
	'''
	pass
	return 'INTEGER' # The index of the tapered component.


def GetTexBFeatureEnd(
		textureBitmap  # HANDLE - Handle to texture bitmap.
		):
	'''
		Python: (featureEndX, featureEndY) = vs.GetTexBFeatureEnd(textureBitmap)
		VectorScript: PROCEDURE GetTexBFeatureEnd(textureBitmap:HANDLE; VAR featureEndX:INTEGER; VAR featureEndY:INTEGER);
		
		Category: Textures
		Procedure GetTexBFeatureEnd returns the "feature endpoint" of the referenced texture bitmap.  The point is expressed in pixels from the top left corner of the bitmap.
	'''
	pass
	return ( 0, 
	         0 )


def GetTexBFeatureStart(
		textureBitmap  # HANDLE - Handle to texture bitmap.
		):
	'''
		Python: (featureStartX, featureStartY) = vs.GetTexBFeatureStart(textureBitmap)
		VectorScript: PROCEDURE GetTexBFeatureStart(textureBitmap:HANDLE; VAR featureStartX:INTEGER; VAR featureStartY:INTEGER);
		
		Category: Textures
		Procedure GetTexBFeatureStart returns the "feature startpoint" of the referenced texture bitmap.   The point is expressed in pixels from the top left corner of the bitmap.
	'''
	pass
	return ( 0, 
	         0 )


def GetTexBitFeatureSize(
		textureBitmap  # HANDLE - Handle to texture bitmap.
		):
	'''
		Python: REAL = vs.GetTexBitFeatureSize(textureBitmap)
		VectorScript: FUNCTION GetTexBitFeatureSize(textureBitmap:HANDLE) : REAL;
		
		Category: Textures
		Function GetTexBitFeatureSize returns the feature size of the referenced bitmap in real world inches.
	'''
	pass
	return 'REAL' # 


def GetTexBitmapOrigin(
		textureBitmap  # HANDLE - Handle to texture bitmap.
		):
	'''
		Python: (originX, originY) = vs.GetTexBitmapOrigin(textureBitmap)
		VectorScript: PROCEDURE GetTexBitmapOrigin(textureBitmap:HANDLE; VAR originX:INTEGER; VAR originY:INTEGER);
		
		Category: Textures
		Procedure GetTexBitmapOrigin returns the origin of the bitmap applied to the referenced texture bitmap. The origin is measured in pixels, with the top left corner as (0,0).
	'''
	pass
	return ( 0, 
	         0 )


def GetTexBitPaintNode(
		textureBitmap  # HANDLE - Handle to texture bitmap.
		):
	'''
		Python: HANDLE = vs.GetTexBitPaintNode(textureBitmap)
		VectorScript: FUNCTION GetTexBitPaintNode(textureBitmap:HANDLE) : HANDLE;
		
		Category: Textures
		Function GetTexBitPaintNode returns the paint node of the referenced texture bitmap.
	'''
	pass
	return 'HANDLE' # 


def GetTexBitRepHoriz(
		textureBitmap  # HANDLE - Handle to texture bitmap.
		):
	'''
		Python: BOOLEAN = vs.GetTexBitRepHoriz(textureBitmap)
		VectorScript: FUNCTION GetTexBitRepHoriz(textureBitmap:HANDLE) : BOOLEAN;
		
		Category: Textures
		Function GetTexBitRepHoriz returns whether the referenced texture bitmap is set to repeat horizontally.
	'''
	pass
	return 'BOOLEAN' # The function returns TRUE if the texture bitmap is set to repeat. 


def GetTexBitRepVert(
		textureBitmap  # HANDLE - Handle to texture bitmap.
		):
	'''
		Python: BOOLEAN = vs.GetTexBitRepVert(textureBitmap)
		VectorScript: FUNCTION GetTexBitRepVert(textureBitmap:HANDLE) : BOOLEAN;
		
		Category: Textures
		Function GetTexBitRepVert returns whether the referenced texture bitmap is set to repeat vertically.
	'''
	pass
	return 'BOOLEAN' #  The function returns TRUE if the texture bitmap is set to repeat. 


def GetTexMapBool(
		h       , # HANDLE  -  
		partID  , # LONGINT -  
		selector  # INTEGER -  
		):
	'''
		Python: BOOLEAN = vs.GetTexMapBool(h, partID, selector)
		VectorScript: FUNCTION GetTexMapBool(h:HANDLE; partID:LONGINT; selector:INTEGER) : BOOLEAN;
		
		Category: Textures
		Get map info for specific part of object. partID is texture part, overall is 3. Selector: init:1, flip:2, repH:3, repV:4, long edge:5, worldZ:6, auto align:7
	'''
	pass
	return 'BOOLEAN' # 


def GetTexMapBoolN(
		obj       , # HANDLE  -                          
		texPartID , # LONGINT -                          
		texLayerID, # LONGINT - 0 for base, >0 for decals
		selector    # INTEGER -                          
		):
	'''
		Python: BOOLEAN = vs.GetTexMapBoolN(obj, texPartID, texLayerID, selector)
		VectorScript: FUNCTION GetTexMapBoolN(obj:HANDLE; texPartID:LONGINT; texLayerID:LONGINT; selector:INTEGER) : BOOLEAN;
		
		Category: Textures
		Get map info for specific part of object. partID is texture part, overall is 3. Selector: init:1, flip:2, repH:3, repV:4, long edge:5, worldZ:6, auto align:7
	'''
	pass
	return 'BOOLEAN' # 


def GetTexMapInt(
		h       , # HANDLE  -  
		partID  , # LONGINT -  
		selector  # INTEGER -  
		):
	'''
		Python: INTEGER = vs.GetTexMapInt(h, partID, selector)
		VectorScript: FUNCTION GetTexMapInt(h:HANDLE; partID:LONGINT; selector:INTEGER) : INTEGER;
		
		Category: Textures
		Get map info for specific part of object. partID is texture part, overall is 3. Selector should be1, to return the texture map type integer.
	'''
	pass
	return 'INTEGER' # 


def GetTexMapIntN(
		obj       , # HANDLE  -                          
		texPartID , # LONGINT -                          
		texLayerID, # LONGINT - 0 for base, >0 for decals
		selector    # INTEGER -                          
		):
	'''
		Python: INTEGER = vs.GetTexMapIntN(obj, texPartID, texLayerID, selector)
		VectorScript: FUNCTION GetTexMapIntN(obj:HANDLE; texPartID:LONGINT; texLayerID:LONGINT; selector:INTEGER) : INTEGER;
		
		Category: Textures
		Get map info for specific part of object. partID is texture part, overall is 3. Selector should be1, to return the texture map type integer.
	'''
	pass
	return 'INTEGER' # 


def GetTexMapReal(
		h       , # HANDLE  -  
		partID  , # LONGINT -  
		selector  # INTEGER -  
		):
	'''
		Python: REAL = vs.GetTexMapReal(h, partID, selector)
		VectorScript: FUNCTION GetTexMapReal(h:HANDLE; partID:LONGINT; selector:INTEGER) : REAL;
		
		Category: Textures
		Get map info for specific part of object. partID is texture part, overall is 3. Selector: offsetX:1, offsetY:2, scale2D:3, rotate2D:4, radius:5, matrix mat00 through mat32: 6-17
	'''
	pass
	return 'REAL' # 


def GetTexMapRealN(
		obj       , # HANDLE  -                          
		texPartID , # LONGINT -                          
		texLayerID, # LONGINT - 0 for base, >0 for decals
		selector    # INTEGER -                          
		):
	'''
		Python: REAL = vs.GetTexMapRealN(obj, texPartID, texLayerID, selector)
		VectorScript: FUNCTION GetTexMapRealN(obj:HANDLE; texPartID:LONGINT; texLayerID:LONGINT; selector:INTEGER) : REAL;
		
		Category: Textures
		Get map info for specific part of object. partID is texture part, overall is 3. Selector: offsetX:1, offsetY:2, scale2D:3, rotate2D:4, radius:5, matrix mat00 through mat32: 6-17
	'''
	pass
	return 'REAL' # 


def GetTexSpace2DOffset(
		textureSpace  # HANDLE - Handle to texture space.
		):
	'''
		Python: (offsetU, offsetV) = vs.GetTexSpace2DOffset(textureSpace)
		VectorScript: PROCEDURE GetTexSpace2DOffset(textureSpace:HANDLE; VAR offsetU:REAL; VAR offsetV:REAL);
		
		Category: Textures
		Procedure GetTexSpace2DOffset returns the 2D offset for the referenced texture space in real-world inches.
	'''
	pass
	return ( 0.0, 
	         0.0 )


def GetTexSpace2DRadius(
		textureSpace  # HANDLE - Handle to texture space.
		):
	'''
		Python: REAL = vs.GetTexSpace2DRadius(textureSpace)
		VectorScript: FUNCTION GetTexSpace2DRadius(textureSpace:HANDLE) : REAL;
		
		Category: Textures
		Function GetTexSpace2DRadius returns the radius of the referenced texture space for applicable mapping types.
	'''
	pass
	return 'REAL' # 


def GetTexSpace2DRot(
		textureSpace  # HANDLE - Handle to texture space.
		):
	'''
		Python: REAL = vs.GetTexSpace2DRot(textureSpace)
		VectorScript: FUNCTION GetTexSpace2DRot(textureSpace:HANDLE) : REAL;
		
		Category: Textures
		Function GetTexSpace2DRot returns the rotation of the referenced texture space (in degrees).
	'''
	pass
	return 'REAL' # 


def GetTexSpace2DScale(
		textureSpace  # HANDLE - Handle to texture space.
		):
	'''
		Python: REAL = vs.GetTexSpace2DScale(textureSpace)
		VectorScript: FUNCTION GetTexSpace2DScale(textureSpace:HANDLE) : REAL;
		
		Category: Textures
		Function GetTexSpace2DScale returns the 2D scale for the referenced texture space.
	'''
	pass
	return 'REAL' # 


def GetTexSpaceEndCap(
		textureSpace  # HANDLE - Handle to texture space.
		):
	'''
		Python: BOOLEAN = vs.GetTexSpaceEndCap(textureSpace)
		VectorScript: FUNCTION GetTexSpaceEndCap(textureSpace:HANDLE) : BOOLEAN;
		
		Category: Textures
		Function GetTexSpaceEndCap returns whether the end cap of the referenced extrude or sweep is textured.
	'''
	pass
	return 'BOOLEAN' # 


def GetTexSpaceKind(
		textureSpace  # HANDLE - Handle to texture space.
		):
	'''
		Python: INTEGER = vs.GetTexSpaceKind(textureSpace)
		VectorScript: FUNCTION GetTexSpaceKind(textureSpace:HANDLE) : INTEGER;
		
		Category: Textures
		Function GetTexSpaceKind returns the object type for texture mapping space.
	'''
	pass
	return 'INTEGER' # 


def GetTexSpaceOrientU(
		textureSpace  # HANDLE - Handle to texture space.
		):
	'''
		Python: (uXAxis, uYAxis, uZAxis) = vs.GetTexSpaceOrientU(textureSpace)
		VectorScript: PROCEDURE GetTexSpaceOrientU(textureSpace:HANDLE; VAR uXAxis:REAL; VAR uYAxis:REAL; VAR uZAxis:REAL);
		
		Category: Textures
		Procedure GetTexSpaceOrientU returns the vector that describes the u-axis of the referenced texture (from world space to texture space).
	'''
	pass
	return ( 0.0, 
	         0.0, 
	         0.0 )


def GetTexSpaceOrientV(
		textureSpace  # HANDLE - Handle to texture space.
		):
	'''
		Python: (vXAxis, vYAxis, vZAxis) = vs.GetTexSpaceOrientV(textureSpace)
		VectorScript: PROCEDURE GetTexSpaceOrientV(textureSpace:HANDLE; VAR vXAxis:REAL; VAR vYAxis:REAL; VAR vZAxis:REAL);
		
		Category: Textures
		Procedure GetTexSpaceOrientV returns the vector that describes the v-axis of the referenced texture (from world space to texture space).
	'''
	pass
	return ( 0.0, 
	         0.0, 
	         0.0 )


def GetTexSpaceOrientW(
		textureSpace  # HANDLE - Handle to texture space.
		):
	'''
		Python: (wXAxis, wYAxis, wZAxis) = vs.GetTexSpaceOrientW(textureSpace)
		VectorScript: PROCEDURE GetTexSpaceOrientW(textureSpace:HANDLE; VAR wXAxis:REAL; VAR wYAxis:REAL; VAR wZAxis:REAL);
		
		Category: Textures
		Procedure GetTexSpaceOrientW returns the vector that describes the w-axis of the referenced texture (from world space to texture space).
	'''
	pass
	return ( 0.0, 
	         0.0, 
	         0.0 )


def GetTexSpaceOrigin(
		textureSpace  # HANDLE - Handle to texture space.
		):
	'''
		Python: offset = vs.GetTexSpaceOrigin(textureSpace)
		VectorScript: PROCEDURE GetTexSpaceOrigin(textureSpace:HANDLE; VAR offsetX, offsetY, offsetZ:REAL);
		
		Category: Textures
		Procedure GetTexSpaceOrigin returns the offset of the referenced texture space that takes coordinates from world space to texture space.
	'''
	pass
	return ( 0,0,0 )


def GetTexSpacePartID(
		textureSpace  # HANDLE - Handle to texture space.
		):
	'''
		Python: INTEGER = vs.GetTexSpacePartID(textureSpace)
		VectorScript: FUNCTION GetTexSpacePartID(textureSpace:HANDLE) : INTEGER;
		
		Category: Textures
		Function GetTexSpacePartID returns the parent of the referenced texture space in an expanded object (walls or roofs).
	'''
	pass
	return 'INTEGER' # 


def GetTexSpaceStartCap(
		textureSpace  # HANDLE - Handle to texture space.
		):
	'''
		Python: BOOLEAN = vs.GetTexSpaceStartCap(textureSpace)
		VectorScript: FUNCTION GetTexSpaceStartCap(textureSpace:HANDLE) : BOOLEAN;
		
		Category: Textures
		Function GetTexSpaceStartCap returns whether the start cap of an extrude or sweep is textured.
	'''
	pass
	return 'BOOLEAN' # 


def GetText(
		objectHd  # HANDLE - Handle to text object.
		):
	'''
		Python: DYNARRAY of CHAR = vs.GetText(objectHd)
		VectorScript: FUNCTION GetText(objectHd:HANDLE) : DYNARRAY of CHAR;
		
		Category: Objects - Text
		Function GetText returns the text contained within the referenced text object.
	'''
	pass
	return 'DYNARRAY[] of CHAR' # 


def GetTextFont(
		objectHd, # HANDLE  - Handle to text object.  
		Position  # INTEGER - Position in text string.
		):
	'''
		Python: INTEGER = vs.GetTextFont(objectHd, Position)
		VectorScript: FUNCTION GetTextFont(objectHd:HANDLE; Position:INTEGER) : INTEGER;
		
		Category: Objects - Text
		Procedure GetTextFont returns the font of the referenced text object at a specified position in the string.
	'''
	pass
	return 'INTEGER' # 


def GetTextJust(
		TextHd  # HANDLE - Handle to text object.
		):
	'''
		Python: INTEGER = vs.GetTextJust(TextHd)
		VectorScript: FUNCTION GetTextJust(TextHd:HANDLE) : INTEGER;
		
		Category: Objects - Text
		Function GetTextJust returns the text justification of the referenced text object.
	'''
	pass
	return 'INTEGER' # 


def GetTextLeading(
		theText  # HANDLE - Handle to text object.
		):
	'''
		Python: REAL = vs.GetTextLeading(theText)
		VectorScript: FUNCTION GetTextLeading(theText:HANDLE) : REAL;
		
		Category: Objects - Text
		Procedure GetTextLeading returns the custom leading value(in points) of the referenced text object.
	'''
	pass
	return 'REAL' # 


def GetTextLength(
		TextHd  # HANDLE - Handle to text object.
		):
	'''
		Python: INTEGER = vs.GetTextLength(TextHd)
		VectorScript: FUNCTION GetTextLength(TextHd:HANDLE) : INTEGER;
		
		Category: Objects - Text
		GetTextLength returns the string length of the referenced text object.
	'''
	pass
	return 'INTEGER' # 


def GetTextOrientation(
		theText  # HANDLE - Handle to text object.
		):
	'''
		Python: (textOrigin, textAng, textIsMirrored) = vs.GetTextOrientation(theText)
		VectorScript: PROCEDURE GetTextOrientation(theText:HANDLE; VAR textOriginX, textOriginY:REAL; VAR textAng:REAL; VAR textIsMirrored:BOOLEAN);
		
		Category: Objects - Text
		Procedure GetTextOrientation returns the position and orientation attributes of the referenced text object.
	'''
	pass
	return ( 0,0  , 
	         0.0  , 
	         False )


def GetTextSize(
		TextHd  , # HANDLE  - Handle to text object.  
		Position  # INTEGER - Position in text string.
		):
	'''
		Python: REAL = vs.GetTextSize(TextHd, Position)
		VectorScript: FUNCTION GetTextSize(TextHd:HANDLE; Position:INTEGER) : REAL;
		
		Category: Objects - Text
		Procedure GetTextSize returns the text point size at a specified position within the referenced text object. 1 point = 1/72".
	'''
	pass
	return 'REAL' # 


def GetTextSpace(
		theText  # HANDLE - Handle to text object.
		):
	'''
		Python: INTEGER = vs.GetTextSpace(theText)
		VectorScript: FUNCTION GetTextSpace(theText:HANDLE) : INTEGER;
		
		Category: Objects - Text
		Procedure GetTextSpace returns the line spacing of the referenced text object.
	'''
	pass
	return 'INTEGER' # 


def GetTextStyle(
		TextHd  , # HANDLE  - Handle to text object.  
		Position  # INTEGER - Position in text string.
		):
	'''
		Python: INTEGER = vs.GetTextStyle(TextHd, Position)
		VectorScript: FUNCTION GetTextStyle(TextHd:HANDLE; Position:INTEGER) : INTEGER;
		
		Category: Objects - Text
		Procedure GetTextStyle returns the text style at a specified position within the referenced text object.
	'''
	pass
	return 'INTEGER' # 


def GetTextStyleRef(
		objectId  # HANDLE - handle to object
		):
	'''
		Python: LONGINT = vs.GetTextStyleRef(objectId)
		VectorScript: FUNCTION GetTextStyleRef(objectId:HANDLE) : LONGINT;
		
		Category: Objects - Text
		Function GetTextStyleRef returns the text style for the referenced object. The integer returned is the internal index of the text style used by this object.
		If the text object is using class text style, this returns the effective style.  You should use the *TextStyleByClass* functions to check and preserve by-class behavior.
	'''
	pass
	return 'LONGINT' # 


def GetTextStyleRefN(
		objectId, # HANDLE  - handle to text object                
		position  # INTEGER - Position in text string, zero-based. 
		):
	'''
		Python: LONGINT = vs.GetTextStyleRefN(objectId, position)
		VectorScript: FUNCTION GetTextStyleRefN(objectId:HANDLE; position:INTEGER) : LONGINT;
		
		Category: Objects - Text
		GetTextStyleRefN returns the text style reference at a specified position within the text object. Reference 0 means Un-Styled.
		If the text object is using class text style, this returns the effective style.  You should use the *TextStyleByClass* functions to check and preserve by-class behavior.
	'''
	pass
	return 'LONGINT' # Returns the text style reference id for the requested character postion


def GetTextureBitmap(
		shaderRecord  # HANDLE - Handle to shader record.
		):
	'''
		Python: HANDLE = vs.GetTextureBitmap(shaderRecord)
		VectorScript: FUNCTION GetTextureBitmap(shaderRecord:HANDLE) : HANDLE;
		
		Category: Textures
		Function GetTextureBitmap returns the bitmap object attached to the referenced texture.
	'''
	pass
	return 'HANDLE' #  If there is no texture applied to an object the function returns NIL.


def GetTextureRef(
		obj           , # HANDLE  - Handle to object.                            
		partID        , # INTEGER - Identifies texture to be returned by part ID.
		resolveByClass  # BOOLEAN - Resolve texture reference by class.          
		):
	'''
		Python: LONGINT = vs.GetTextureRef(obj, partID, resolveByClass)
		VectorScript: FUNCTION GetTextureRef(obj:HANDLE; partID:INTEGER; resolveByClass:BOOLEAN) : LONGINT;
		
		Category: Textures
		Function GetTextureRef returns the texture reference ID for the referenced object. The integer returned is the internal index of the texture node used by this object.
	'''
	pass
	return 'LONGINT' # 


def GetTextureRefN(
		obj           , # HANDLE  -                                            
		texPartID     , # LONGINT -                                            
		texLayerID    , # LONGINT - Texture layer ID, 0 for base, >0 for decals
		resolveByClass  # BOOLEAN -                                            
		):
	'''
		Python: LongInt = vs.GetTextureRefN(obj, texPartID, texLayerID, resolveByClass)
		VectorScript: FUNCTION GetTextureRefN(obj:HANDLE; texPartID:LONGINT; texLayerID:LONGINT; resolveByClass:BOOLEAN) : LongInt;
		
		Category: Textures
		Returns the texture reference for a specified object.
	'''
	pass
	return 'LongInt' # 


def GetTextureSet(
		object  # HANDLE - The object.
		):
	'''
		Python: INTEGER = vs.GetTextureSet(object)
		VectorScript: FUNCTION GetTextureSet(object:HANDLE) : INTEGER;
		
		Category: Textures
		Gets the texture set of an object.
	'''
	pass
	return 'INTEGER' # The texture set.[[BR]][[BR]]0 - Object textures[[BR]]1 - Component textures


def GetTextureShader(
		texture  # HANDLE - Handle to texture.
		):
	'''
		Python: LONGINT = vs.GetTextureShader(texture)
		VectorScript: FUNCTION GetTextureShader(texture:HANDLE) : LONGINT;
		
		Category: Textures
		Function GetTextureShader returns the LightWorks internal property reference ID for the shader attached to the referenced texture.
	'''
	pass
	return 'LONGINT' # 


def GetTextureShininess(
		texture  # HANDLE - Handle to texture.
		):
	'''
		Python: INTEGER = vs.GetTextureShininess(texture)
		VectorScript: FUNCTION GetTextureShininess(texture:HANDLE) : INTEGER;
		
		Category: Textures
		Function GetTextureShininess returns the shininess value of the referenced texture. The value is expressed as a percentage value with 0 equaling "Dull".
	'''
	pass
	return 'INTEGER' # 


def GetTextureSize(
		texture  # HANDLE -  
		):
	'''
		Python: REAL = vs.GetTextureSize(texture)
		VectorScript: FUNCTION GetTextureSize(texture:HANDLE) : REAL;
		
		Category: Textures
		Returns the texture size in real-world inches.
	'''
	pass
	return 'REAL' # 


def GetTextureSpace(
		obj   , # HANDLE  - Handle to object.                           
		partID  # INTEGER - Part ID (pass 1 for non-supporting objects).
		):
	'''
		Python: HANDLE = vs.GetTextureSpace(obj, partID)
		VectorScript: FUNCTION GetTextureSpace(obj:HANDLE; partID:INTEGER) : HANDLE;
		
		Category: Textures
		Function GetTextureSpace returns a handle to the texture space attached to the referenced object(or object part).
	'''
	pass
	return 'HANDLE' # 


def GetTextureTransp(
		texture  # HANDLE - Handle to texture.
		):
	'''
		Python: INTEGER = vs.GetTextureTransp(texture)
		VectorScript: FUNCTION GetTextureTransp(texture:HANDLE) : INTEGER;
		
		Category: Textures
		Function GetTextureTransp returns the degree of transparency applied to the referenced texture. It is expressed as a percentage with 0 creating an opaque texture.
	'''
	pass
	return 'INTEGER' # 


def GetTextVerticalAlign(
		TextHd  # HANDLE - Handle to text object.
		):
	'''
		Python: INTEGER = vs.GetTextVerticalAlign(TextHd)
		VectorScript: FUNCTION GetTextVerticalAlign(TextHd:HANDLE) : INTEGER;
		
		Category: Objects - Text
		Function GetTextVerticalAlign returns the vertical alignment of the referenced text object.
	'''
	pass
	return 'INTEGER' # 


def GetTextWidth(
		theText  # HANDLE - Handle to text object.
		):
	'''
		Python: REAL = vs.GetTextWidth(theText)
		VectorScript: FUNCTION GetTextWidth(theText:HANDLE) : REAL;
		
		Category: Objects - Text
		Procedure GetTextWidth returns the margin width of the referenced text object.
	'''
	pass
	return 'REAL' # 


def GetTextWrap(
		theText  # HANDLE - Handle to text object.
		):
	'''
		Python: BOOLEAN = vs.GetTextWrap(theText)
		VectorScript: FUNCTION GetTextWrap(theText:HANDLE) : BOOLEAN;
		
		Category: Objects - Text
		Procedure GetTextWrap returns the text wrap mode of the referenced text object.
	'''
	pass
	return 'BOOLEAN' # 


def GetThreeStateCheckBoxState(
		dialogID   , # LONGINT -  
		componentID  # LONGINT -  
		):
	'''
		Python: iState = vs.GetThreeStateCheckBoxState(dialogID, componentID)
		VectorScript: PROCEDURE GetThreeStateCheckBoxState(dialogID:LONGINT; componentID:LONGINT; VAR iState:INTEGER);
		
		Category: Dialogs - Modern
		Retrieves the state of a Layout Manager three state checkbox.
	'''
	pass
	return ( 0 )


def GetTickCount():
	'''
		Python: LONGINT = vs.GetTickCount()
		VectorScript: FUNCTION GetTickCount : LONGINT;
		
		Category: Utility
		Returns number of ticks (1/60th second) since system startup.
	'''
	pass
	return 'LONGINT' # 


def GetTileBackgroundColor(
		tileHandle  # HANDLE - The tile resource from which to get the background color.
		):
	'''
		Python: (red, green, blue) = vs.GetTileBackgroundColor(tileHandle)
		VectorScript: PROCEDURE GetTileBackgroundColor(tileHandle:HANDLE; VAR red:LONGINT; VAR green:LONGINT; VAR blue:LONGINT);
		
		Category: Document Attributes
		Gets the specified tile resource's background color.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetTileGeometryGroup(
		tileHandle  # HANDLE - The handle to the tile from which to get the group.
		):
	'''
		Python: HANDLE = vs.GetTileGeometryGroup(tileHandle)
		VectorScript: FUNCTION GetTileGeometryGroup(tileHandle:HANDLE) : HANDLE;
		
		Category: Document Attributes
		Gets the tile resource's geometry group.
	'''
	pass
	return 'HANDLE' # A handle to the tile geometry group, if successful; nil otherwise.


def GetTileGroupParent(
		groupHandle  # HANDLE - The group handle of which to get the tile resource parent.
		):
	'''
		Python: HANDLE = vs.GetTileGroupParent(groupHandle)
		VectorScript: FUNCTION GetTileGroupParent(groupHandle:HANDLE) : HANDLE;
		
		Category: Document Attributes
		Gets the tile resource parent of the specified tile group.
	'''
	pass
	return 'HANDLE' # The tile parent handle; nil otherwise.


def GetTileOffsetPoint(
		tileHandle  # HANDLE - The tile resource from which to get the offset point.
		):
	'''
		Python: offsetPoint = vs.GetTileOffsetPoint(tileHandle)
		VectorScript: PROCEDURE GetTileOffsetPoint(tileHandle:HANDLE; VAR offsetPoint:REAL);
		
		Category: Document Attributes
		Gets the specified tile resource's offset point.
	'''
	pass
	return ( 0,0 )


def GetTileRepetitionPoint(
		tileHandle  # HANDLE - The tile resource from which to get the repetition point.
		):
	'''
		Python: repetitionPoint = vs.GetTileRepetitionPoint(tileHandle)
		VectorScript: PROCEDURE GetTileRepetitionPoint(tileHandle:HANDLE; VAR repetitionPoint:REAL);
		
		Category: Document Attributes
		Gets the specified tile resource's repetition point.
	'''
	pass
	return ( 0,0 )


def GetTopPlan2DComp(
		objectHandle  # HANDLE - Handle to the object.
		):
	'''
		Python: INTEGER = vs.GetTopPlan2DComp(objectHandle)
		VectorScript: FUNCTION GetTopPlan2DComp(objectHandle:HANDLE) : INTEGER;
		
		Category: Objects - Custom
		Gets the 2D component that is shown in Top/Plan view for a symbol definition or plug-in object
		Table - components:
		Component			Constant
		Top				0
		Top and Bottom Cut		                1
	'''
	pass
	return 'INTEGER' # Returns the 2D component that is shown in Top/Plan view for a symbol definition or plug-in object.


def GetTopVisibleWS():
	'''
		Python: HANDLE = vs.GetTopVisibleWS()
		VectorScript: FUNCTION GetTopVisibleWS : HANDLE;
		
		Category: Worksheets
		Returns a handle to topmost visible worksheet.
	'''
	pass
	return 'HANDLE' # Returns a HANDLE to the worksheet whose window is at the top of the window stacking order.


def GetTrapeziumAttributes(
		roofObject, # HANDLE  - Handle to roof.         
		dormerID    # INTEGER - Index of dormer element.
		):
	'''
		Python: (useHeight, heightDepth, bottomWidth, useTopWidth, topWidth, leftSlope, rightSlope, topSlope) = vs.GetTrapeziumAttributes(roofObject, dormerID)
		VectorScript: PROCEDURE GetTrapeziumAttributes(roofObject:HANDLE; dormerID:INTEGER; VAR useHeight:BOOLEAN; VAR heightDepth:REAL; VAR bottomWidth:REAL; VAR useTopWidth:BOOLEAN; VAR topWidth:REAL; VAR leftSlope:REAL; VAR rightSlope:REAL; VAR topSlope:REAL);
		
		Category: Objects - Roofs
		Procedure GetTrapeziumAttributes returns the attributes of a trapezium dormer in the referenced roof.
	'''
	pass
	return ( False, 
	         0.0  , 
	         0.0  , 
	         False, 
	         0.0  , 
	         0.0  , 
	         0.0  , 
	         0.0   )


def GetTreeControlItemData(
		nDialogID   , # LONGINT -  
		nComponentID, # LONGINT -  
		nItemID       # INTEGER -  
		):
	'''
		Python: nUserData = vs.GetTreeControlItemData(nDialogID, nComponentID, nItemID)
		VectorScript: PROCEDURE GetTreeControlItemData(nDialogID:LONGINT; nComponentID:LONGINT; nItemID:INTEGER; VAR nUserData:LONGINT);
		
		Category: Dialogs - Modern
		Retrieves the user data of the specified item from a tree control.
	'''
	pass
	return ( 0 )


def GetTreeControlItemText(
		nDialogID   , # LONGINT -  
		nComponentID, # LONGINT -  
		nItemID       # INTEGER -  
		):
	'''
		Python: (BOOLEAN, itemText) = vs.GetTreeControlItemText(nDialogID, nComponentID, nItemID)
		VectorScript: FUNCTION GetTreeControlItemText(nDialogID:LONGINT; nComponentID:LONGINT; nItemID:INTEGER; VAR itemText:STRING) : BOOLEAN;
		
		Category: Dialogs - Modern
		Retrieves the item text of the specified item from a tree control.
	'''
	pass
	return ( False   , # 
	         'string' )


def GetTreeControlSelectedItem(
		nDialogID   , # LONGINT -  
		nComponentID  # LONGINT -  
		):
	'''
		Python: (BOOLEAN, nItemID) = vs.GetTreeControlSelectedItem(nDialogID, nComponentID)
		VectorScript: FUNCTION GetTreeControlSelectedItem(nDialogID:LONGINT; nComponentID:LONGINT; VAR nItemID:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern
		Retrieves the itemID of the selected item from a Layout Manager tree control.
	'''
	pass
	return ( False  , # 
	         0       )


def GetTreeControlTextSelectedItem(
		nDialogID   , # LONGINT -  
		nComponentID  # LONGINT -  
		):
	'''
		Python: (BOOLEAN, itemText) = vs.GetTreeControlTextSelectedItem(nDialogID, nComponentID)
		VectorScript: FUNCTION GetTreeControlTextSelectedItem(nDialogID:LONGINT; nComponentID:LONGINT; VAR itemText:STRING) : BOOLEAN;
		
		Category: Dialogs - Modern
		Retrieves the item text of the selected item from a tree control.
	'''
	pass
	return ( False   , # 
	         'string' )


def GetType(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: INTEGER = vs.GetType(h)
		VectorScript: FUNCTION GetType(h:HANDLE) : INTEGER;
		
		Category: Object Info
		Returns the type index of the referenced screen object.
	'''
	pass
	return 'INTEGER' # 


def GetTypeN(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: INTEGER = vs.GetTypeN(h)
		VectorScript: FUNCTION GetTypeN(h:HANDLE) : INTEGER;
		
		Category: Object Info
		Returns the type index of the referenced planar or screen object.
	'''
	pass
	return 'INTEGER' # 


def GetUnits(
		):
	'''
		Python: (fraction, display, format, upi, lenUnitMk, areaUnitMk) = vs.GetUnits()
		VectorScript: PROCEDURE GetUnits(VAR fraction:LONGINT; VAR display:LONGINT; VAR format:INTEGER; VAR upi:REAL; VAR lenUnitMk:STRING; VAR areaUnitMk:STRING);
		
		Category: Units
		Procedure GetUnits returns the current units settings of the document.
		More extensive Units information is available using the GetPref routines with the selectors shown in the tables of the VectorScript Appendix.
	'''
	pass
	return ( 0       , 
	         0       , 
	         0       , 
	         0.0     , 
	         'string', 
	         'string' )


def GetVCenter(
		):
	'''
		Python: center = vs.GetVCenter()
		VectorScript: PROCEDURE GetVCenter(VAR centerX, centerY:REAL);
		
		Category: View / Zoom
		Procedure GetVCenter returns the Vectorworks document coordinates at the center of the drawing window.
	'''
	pass
	return ( 0,0 )


def GetVectorFill(
		theObj  # HANDLE - Handle to object.
		):
	'''
		Python: (BOOLEAN, hatchName) = vs.GetVectorFill(theObj)
		VectorScript: FUNCTION GetVectorFill(theObj:HANDLE; VAR hatchName:STRING) : BOOLEAN;
		
		Category: Hatches / Vector Fills
		Function GetVectorFill returns if the referenced object has a vector fill assigned.
	'''
	pass
	return ( False   , # 
	         'string' )


def GetVectorFillDefault(
		):
	'''
		Python: (BOOLEAN, vectorFillName) = vs.GetVectorFillDefault()
		VectorScript: FUNCTION GetVectorFillDefault(VAR vectorFillName:STRING) : BOOLEAN;
		
		Category: Hatches / Vector Fills
		Function GetVectorFillDefault returns TRUE if the the active document contains a default vector fill, and returns the name of the vector fill pattern.
	'''
	pass
	return ( False   , # 
	         'string' )


def GetVersion(
		):
	'''
		Python: (major, minor, maintenance, platform) = vs.GetVersion()
		VectorScript: PROCEDURE GetVersion(VAR major:INTEGER; VAR minor:INTEGER; VAR maintenance:INTEGER; VAR platform:INTEGER);
		
		Category: Utility
		Returns version information about the Vectorworks application. Parameter major returns the major version number of the application. Parameters minor and maintenance return minor version information. Parameter platform returns the OS platform on which Vectorworks is running (1 = Macintosh, 2 = Windows).
		Vectorworks 2008 has version major number 13, 2009 - 14 and so on.
		For example:
		Vectorworks 8.0.1 running on a Macintosh would return:
		major: 8
		minor: 0
		maintenance: 1
		platform: 1
	'''
	pass
	return ( 0, 
	         0, 
	         0, 
	         0 )


def GetVersionEx(
		):
	'''
		Python: (major, minor, maintenance, platform, buildNum) = vs.GetVersionEx()
		VectorScript: PROCEDURE GetVersionEx(VAR major:INTEGER; VAR minor:INTEGER; VAR maintenance:INTEGER; VAR platform:INTEGER; VAR buildNum:LONGINT);
		
		Category: Utility
		Returns version information about the Vectorworks application. Parameter major returns the major version number of the application. Parameters minor and maintenance return minor version information. Parameter platform returns the OS platform on which Vectorworks is running (1 = Macintosh, 2 = Windows).
		Parameter buildNum returns the build number of the version.
		Vectorworks 2008 has version major number 13, 2009 - 14 and so on.
		For example:
		Vectorworks 2010.0.1 running on a Macintosh would return:
		major: 15
		minor: 0
		maintenance: 1
		platform: 1
		buildNum: 95668
	'''
	pass
	return ( 0, 
	         0, 
	         0, 
	         0, 
	         0 )


def GetVertexVisibility(
		h      , # HANDLE  - Handle to the polygon or polyline
		vertnum  # INTEGER - Index of the vertex (zero-based).
		):
	'''
		Python: BOOLEAN = vs.GetVertexVisibility(h, vertnum)
		VectorScript: FUNCTION GetVertexVisibility(h:HANDLE; vertnum:INTEGER) : BOOLEAN;
		
		Category: Objects - Polys
		Returns the visibility of the specified vertex of the referenced object.
	'''
	pass
	return 'BOOLEAN' # Returns true if the vertex is visible, false otherwise.


def GetVertNum(
		PolyHd  # HANDLE - Handle to polygon.
		):
	'''
		Python: INTEGER = vs.GetVertNum(PolyHd)
		VectorScript: FUNCTION GetVertNum(PolyHd:HANDLE) : INTEGER;
		
		Category: Objects - Polys
		Function GetVertNum returns the number of vertices of the referenced polygon or polyline object.
	'''
	pass
	return 'INTEGER' # 


def GetView(
		):
	'''
		Python: (xAngleR, yAngelR, zAngleR, offset) = vs.GetView()
		VectorScript: PROCEDURE GetView(VAR xAngleR:REAL; VAR yAngelR:REAL; VAR zAngleR:REAL; VAR offsetX, offsetY, offsetZ:REAL);
		
		Category: View / Zoom
		Returns information about the current 3D view.
	'''
	pass
	return ( 0.0  , 
	         0.0  , 
	         0.0  , 
	         0,0,0 )


def GetViewMatrix(
		objectHandle  # HANDLE -  
		):
	'''
		Python: (BOOLEAN, offset, rotationXAng, rotationYAng, rotationZAng) = vs.GetViewMatrix(objectHandle)
		VectorScript: FUNCTION GetViewMatrix(objectHandle:HANDLE; VAR offsetX, offsetY, offsetZ:REAL; VAR rotationXAng:REAL; VAR rotationYAng:REAL; VAR rotationZAng:REAL) : BOOLEAN;
		
		Category: Object Attributes
		Gets view matrix for layer or viewport object.
	'''
	pass
	return ( False  , # 
	         0,0,0  , 
	         0.0    , 
	         0.0    , 
	         0.0     )


def GetVisionMapping(
		):
	'''
		Python: (color, universe, gobo, name, channel, fixtureid) = vs.GetVisionMapping()
		VectorScript: PROCEDURE GetVisionMapping(VAR color:STRING; VAR universe:STRING; VAR gobo:STRING; VAR name:STRING; VAR channel:STRING; VAR fixtureid:STRING);
		
		Category: Spotlight
		Gets the mapping of the lighting device fields from Vectorworks to a visualizer.
	'''
	pass
	return ( 'string', 
	         'string', 
	         'string', 
	         'string', 
	         'string', 
	         'string' )


def GetVPClassVisibility(
		viewportHandle, # HANDLE -  
		clasName        # STRING -  
		):
	'''
		Python: (BOOLEAN, visibilityType) = vs.GetVPClassVisibility(viewportHandle, className)
		VectorScript: FUNCTION GetVPClassVisibility(viewportHandle:HANDLE; className:STRING; VAR visibilityType:INTEGER) : BOOLEAN;
		
		Category: Objects - Groups
		Gets the visibility for the specified class in the specified viewport.
	'''
	pass
	return ( False  , # 
	         0       )


def GetVPClOvrdCount(
		viewportHandle  # HANDLE - The viewport handle.
		):
	'''
		Python: INTEGER = vs.GetVPClOvrdCount(viewportHandle)
		VectorScript: FUNCTION GetVPClOvrdCount(viewportHandle:HANDLE) : INTEGER;
		
		Category: Viewports
		Returns the number of class overrides associated with a particular viewport.
	'''
	pass
	return 'INTEGER' # Returns the number of class overrides associated with the given viewport.[[BR]]If the handle is invalid, returns -1.


def GetVPClOvrdFillBack(
		viewportHandle, # HANDLE - Handle to the viewport.
		clasName        # STRING - Name of class.         
		):
	'''
		Python: (colorRV, colorGV, colorBV) = vs.GetVPClOvrdFillBack(viewportHandle, className)
		VectorScript: PROCEDURE GetVPClOvrdFillBack(viewportHandle:HANDLE; className:STRING; VAR colorRV:LONGINT; VAR colorGV:LONGINT; VAR colorBV:LONGINT);
		
		Category: Viewports
		Fetches the fill background color of the class override. The color is returned as three RGB components in the range 0 65535.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetVPClOvrdFillFore(
		viewportHandle, # HANDLE - The viewport handle.  
		clasName        # STRING - The name of the class.
		):
	'''
		Python: (colorRV, colorGV, colorBV) = vs.GetVPClOvrdFillFore(viewportHandle, className)
		VectorScript: PROCEDURE GetVPClOvrdFillFore(viewportHandle:HANDLE; className:STRING; VAR colorRV:LONGINT; VAR colorGV:LONGINT; VAR colorBV:LONGINT);
		
		Category: Viewports
		Fetches the fill foreground color of the class override. The color is returned as three RGB components in the range 0 65535.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetVPClOvrdFillOpty(
		viewportHandle, # HANDLE - The viewport handle.
		clasName        # STRING - Name of the class.  
		):
	'''
		Python: INTEGER = vs.GetVPClOvrdFillOpty(viewportHandle, className)
		VectorScript: FUNCTION GetVPClOvrdFillOpty(viewportHandle:HANDLE; className:STRING) : INTEGER;
		
		Category: Viewports
		Retrieves the fill opacity for a viewport class override.
	'''
	pass
	return 'INTEGER' # Returns the fill opacity of the class override.


def GetVPClOvrdFillStyle(
		viewportHandle, # HANDLE - The viewport Handle           
		clasName        # STRING - The name of the class override
		):
	'''
		Python: LONGINT = vs.GetVPClOvrdFillStyle(viewportHandle, className)
		VectorScript: FUNCTION GetVPClOvrdFillStyle(viewportHandle:HANDLE; className:STRING) : LONGINT;
		
		Category: Viewports
	'''
	pass
	return 'LONGINT' # 


def GetVPClOvrdLineStyle(
		viewportHandle, # HANDLE - The viewport handle.           
		clasName        # STRING - The name of the class override.
		):
	'''
		Python: LONGINT = vs.GetVPClOvrdLineStyle(viewportHandle, className)
		VectorScript: FUNCTION GetVPClOvrdLineStyle(viewportHandle:HANDLE; className:STRING) : LONGINT;
		
		Category: Viewports
	'''
	pass
	return 'LONGINT' # 


def GetVPClOvrdLnWeight(
		viewportHandle, # HANDLE - The handle of the viewport    
		clasName        # STRING - The name of the class override
		):
	'''
		Python: INTEGER = vs.GetVPClOvrdLnWeight(viewportHandle, className)
		VectorScript: FUNCTION GetVPClOvrdLnWeight(viewportHandle:HANDLE; className:STRING) : INTEGER;
		
		Category: Viewports
	'''
	pass
	return 'INTEGER' # 


def GetVPClOvrdName(
		viewportHandle, # HANDLE  - The viewport handle.                   
		index           # INTEGER - The index into the class override list.
		):
	'''
		Python: STRING = vs.GetVPClOvrdName(viewportHandle, index)
		VectorScript: FUNCTION GetVPClOvrdName(viewportHandle:HANDLE; index:INTEGER) : STRING;
		
		Category: Viewports
		Gets the name for the override at a particular index in the override list.
	'''
	pass
	return 'STRING' # Returns the name of the class which is overriden at the specified index.[[BR]]Returns -1 if the index is out of bounds.


def GetVPClOvrdObjTxt(
		viewportHandle, # HANDLE - The viewport handle           
		clasName        # STRING - The name of the class override
		):
	'''
		Python: INTEGER = vs.GetVPClOvrdObjTxt(viewportHandle, className)
		VectorScript: FUNCTION GetVPClOvrdObjTxt(viewportHandle:HANDLE; className:STRING) : INTEGER;
		
		Category: Viewports
	'''
	pass
	return 'INTEGER' # 


def GetVPClOvrdPenBack(
		viewportHandle, # HANDLE - The viewport handle.  
		clasName        # STRING - The name of the class.
		):
	'''
		Python: (colorRV, colorGV, colorBV) = vs.GetVPClOvrdPenBack(viewportHandle, className)
		VectorScript: PROCEDURE GetVPClOvrdPenBack(viewportHandle:HANDLE; className:STRING; VAR colorRV:LONGINT; VAR colorGV:LONGINT; VAR colorBV:LONGINT);
		
		Category: Viewports
		Fetches the pen background color of the class override. The color is returned as three RGB components in the range 0 65535.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetVPClOvrdPenFore(
		viewportHandle, # HANDLE - The viewport handle.  
		clasName        # STRING - The name of the class.
		):
	'''
		Python: (colorRV, colorGV, colorBV) = vs.GetVPClOvrdPenFore(viewportHandle, className)
		VectorScript: PROCEDURE GetVPClOvrdPenFore(viewportHandle:HANDLE; className:STRING; VAR colorRV:LONGINT; VAR colorGV:LONGINT; VAR colorBV:LONGINT);
		
		Category: Viewports
		Fetches the pen foreground color of the class override. The color is returned as three RGB components in the range 0 65535.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetVPClOvrdPenOpty(
		viewportHandle, # HANDLE - The viewport handle.
		clasName        # STRING - Name of the class.  
		):
	'''
		Python: INTEGER = vs.GetVPClOvrdPenOpty(viewportHandle, className)
		VectorScript: FUNCTION GetVPClOvrdPenOpty(viewportHandle:HANDLE; className:STRING) : INTEGER;
		
		Category: Viewports
		Retrieves the pen opacity for a class override. Opacity is in the range 0-100.
	'''
	pass
	return 'INTEGER' # Returns the pen opacity of the class override.


def GetVPClOvrdRoofTxt(
		viewportHandle, # HANDLE - The viewport handle           
		clasName        # STRING - The name of the class override
		):
	'''
		Python: (topMaterial, dormerMaterial) = vs.GetVPClOvrdRoofTxt(viewportHandle, className)
		VectorScript: PROCEDURE GetVPClOvrdRoofTxt(viewportHandle:HANDLE; className:STRING; VAR topMaterial:LONGINT; VAR dormerMaterial:LONGINT);
		
		Category: Viewports
	'''
	pass
	return ( 0, 
	         0 )


def GetVPClOvrdWallTxt(
		viewportHandle, # HANDLE - The viewport handle           
		clasName        # STRING - The name of the class override
		):
	'''
		Python: (leftTexture, centerTexture, rightTexture) = vs.GetVPClOvrdWallTxt(viewportHandle, className)
		VectorScript: PROCEDURE GetVPClOvrdWallTxt(viewportHandle:HANDLE; className:STRING; VAR leftTexture:LONGINT; VAR centerTexture:LONGINT; VAR rightTexture:LONGINT);
		
		Category: Viewports
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetVPCropObject(
		viewportHandle  # HANDLE -  
		):
	'''
		Python: HANDLE = vs.GetVPCropObject(viewportHandle)
		VectorScript: FUNCTION GetVPCropObject(viewportHandle:HANDLE) : HANDLE;
		
		Category: Objects - Groups
		Gets the specified viewport's crop object, if any.
	'''
	pass
	return 'HANDLE' # 


def GetVPGroup(
		viewportHandle, # HANDLE  -  
		groupType       # INTEGER -  
		):
	'''
		Python: HANDLE = vs.GetVPGroup(viewportHandle, groupType)
		VectorScript: FUNCTION GetVPGroup(viewportHandle:HANDLE; groupType:INTEGER) : HANDLE;
		
		Category: Objects - Groups
		Gets the specified viewport group.
		groupType values:
		Crop = 1
		Annotation = 2
		Cache = 3
	'''
	pass
	return 'HANDLE' # 


def GetVPGroupParent(
		groupHandle  # HANDLE - handle to a viewport group (crop, annotation, etc)
		):
	'''
		Python: HANDLE = vs.GetVPGroupParent(groupHandle)
		VectorScript: FUNCTION GetVPGroupParent(groupHandle:HANDLE) : HANDLE;
		
		Category: Objects - Groups
		Gets the viewport that is the parent of specified viewport group.
	'''
	pass
	return 'HANDLE' # Returns a handle to the viewport object (type 122) that is the parent of the specified group, or nil if unsuccessful. 


def GetVPLayerVisibility(
		viewportHandle, # HANDLE -  
		layerHandle     # HANDLE -  
		):
	'''
		Python: (BOOLEAN, visibilityType) = vs.GetVPLayerVisibility(viewportHandle, layerHandle)
		VectorScript: FUNCTION GetVPLayerVisibility(viewportHandle:HANDLE; layerHandle:HANDLE; VAR visibilityType:INTEGER) : BOOLEAN;
		
		Category: Objects - Groups
		Gets the visibility for the specified layer in the specified viewport.
	'''
	pass
	return ( False  , # 
	         0       )


def GetVPLrOvrdCount(
		viewportHandle  # HANDLE - The viewport handle.
		):
	'''
		Python: INTEGER = vs.GetVPLrOvrdCount(viewportHandle)
		VectorScript: FUNCTION GetVPLrOvrdCount(viewportHandle:HANDLE) : INTEGER;
		
		Category: Viewports
		Retrieves the number of layer overrides.
	'''
	pass
	return 'INTEGER' # Returns the number of layer overrides associated with the specified viewport.[[BR]]If the handle is invalid, returns -1.


def GetVPLrOvrdFillBack(
		viewportHandle, # HANDLE - The viewport handle.
		layerHandle     # HANDLE - The layer handle.   
		):
	'''
		Python: (colorRV, colorGV, colorBV) = vs.GetVPLrOvrdFillBack(viewportHandle, layerHandle)
		VectorScript: PROCEDURE GetVPLrOvrdFillBack(viewportHandle:HANDLE; layerHandle:HANDLE; VAR colorRV:LONGINT; VAR colorGV:LONGINT; VAR colorBV:LONGINT);
		
		Category: Viewports
		Gets the fill background color from a layer override.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetVPLrOvrdFillFore(
		viewportHandle, # HANDLE - The viewport handle.
		layerHandle     # HANDLE - The layer handle.   
		):
	'''
		Python: (colorRV, colorGV, colorBV) = vs.GetVPLrOvrdFillFore(viewportHandle, layerHandle)
		VectorScript: PROCEDURE GetVPLrOvrdFillFore(viewportHandle:HANDLE; layerHandle:HANDLE; VAR colorRV:LONGINT; VAR colorGV:LONGINT; VAR colorBV:LONGINT);
		
		Category: Viewports
		Gets the fill foreground color from a layer override.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetVPLrOvrdHandle(
		viewportHandle, # HANDLE  - The viewport handle.                    
		index           # INTEGER - The index into the layer overrides list.
		):
	'''
		Python: HANDLE = vs.GetVPLrOvrdHandle(viewportHandle, index)
		VectorScript: FUNCTION GetVPLrOvrdHandle(viewportHandle:HANDLE; index:INTEGER) : HANDLE;
		
		Category: Viewports
		Retrieves the handle of the layer overridden at the specified index in the overrides list.
	'''
	pass
	return 'HANDLE' # Returns a handle to the layer overriden at the given index.[[BR]]Returns 0 if the index is out of range.


def GetVPLrOvrdOpty(
		viewportHandle, # HANDLE - The viewport handle.
		layerHandle     # HANDLE - The layer handle.   
		):
	'''
		Python: INTEGER = vs.GetVPLrOvrdOpty(viewportHandle, layerHandle)
		VectorScript: FUNCTION GetVPLrOvrdOpty(viewportHandle:HANDLE; layerHandle:HANDLE) : INTEGER;
		
		Category: Viewports
		Gets the opacity for a layer override.
	'''
	pass
	return 'INTEGER' # Returns the opacity for a layer override (0-100).


def GetVPLrOvrdPenBack(
		viewportHandle, # HANDLE - The viewport handle.
		layerHandle     # HANDLE - The layer handle.   
		):
	'''
		Python: (colorRV, colorGV, colorBV) = vs.GetVPLrOvrdPenBack(viewportHandle, layerHandle)
		VectorScript: PROCEDURE GetVPLrOvrdPenBack(viewportHandle:HANDLE; layerHandle:HANDLE; VAR colorRV:LONGINT; VAR colorGV:LONGINT; VAR colorBV:LONGINT);
		
		Category: Viewports
		Gets the pen background color from a layer override.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetVPLrOvrdPenFore(
		viewportHandle, # HANDLE - The viewport handle.
		layerHandle     # HANDLE - The layer handle.   
		):
	'''
		Python: (colorRV, colorGV, colorBV) = vs.GetVPLrOvrdPenFore(viewportHandle, layerHandle)
		VectorScript: PROCEDURE GetVPLrOvrdPenFore(viewportHandle:HANDLE; layerHandle:HANDLE; VAR colorRV:LONGINT; VAR colorGV:LONGINT; VAR colorBV:LONGINT);
		
		Category: Viewports
		Gets the pen foreground color from a layer override.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetVWRString(
		resIdentifier   , # DYNARRAY[] of CHAR - VWR identifier and path to vwstrings file
		stringIdentifier  # DYNARRAY[] of CHAR - key in vwstrings file                    
		):
	'''
		Python: outputString = vs.GetVWRString(resIdentifier, stringIdentifier)
		VectorScript: PROCEDURE GetVWRString(VAR outputString:DYNARRAY of CHAR; resIdentifier:DYNARRAY of CHAR; stringIdentifier:DYNARRAY of CHAR);
		
		Category: Strings
		Replaces GetResourceString -- load a string from VWR file
	'''
	pass
	return ( 'string' )


def GetWallBelCutPlClass(
		wall  # HANDLE - The wall.
		):
	'''
		Python: LONGINT = vs.GetWallBelCutPlClass(wall)
		VectorScript: FUNCTION GetWallBelCutPlClass(wall:HANDLE) : LONGINT;
		
		Category: Objects - Walls
		Gets the below cut plane class of the wall.
	'''
	pass
	return 'LONGINT' # The below cut plane class of the wall.


def GetWallCapAttributesType(
		wall  # HANDLE - The handle to the wall or round wall.
		):
	'''
		Python: INTEGER = vs.GetWallCapAttributesType(wall)
		VectorScript: FUNCTION GetWallCapAttributesType(wall:HANDLE) : INTEGER;
		
		Category: Objects - Walls
		Gets the wall cap attributes type of a wall or round wall.  The wall cap attributes type determines whether the wall caps have the wall line attributes or the component lines attributes.  If they have the component lines attributes, each wall component is capped with its own left line attributes.
	'''
	pass
	return 'INTEGER' # The wall cap attributes type.[[BR]][[BR]]0 - The wall cap attributes are the wall line attributes[[BR]]1 - The wall cap attributes are the wall component lines attributes


def GetWallCaps(
		theWall  # HANDLE - The wall.
		):
	'''
		Python: (leftCap, rightCap, round) = vs.GetWallCaps(theWall)
		VectorScript: PROCEDURE GetWallCaps(theWall:HANDLE; VAR leftCap:BOOLEAN; VAR rightCap:BOOLEAN; VAR round:BOOLEAN);
		
		Category: Objects - Walls
		Gets the wall's caps.
	'''
	pass
	return ( False, 
	         False, 
	         False )


def GetWallCapsOffsets(
		theWall  # HANDLE - The wall.
		):
	'''
		Python: (leftCapLeftOffset, leftCapRightOffset, rightCapLeftOffset, rightCapRightOffset) = vs.GetWallCapsOffsets(theWall)
		VectorScript: PROCEDURE GetWallCapsOffsets(theWall:HANDLE; VAR leftCapLeftOffset:REAL; VAR leftCapRightOffset:REAL; VAR rightCapLeftOffset:REAL; VAR rightCapRightOffset:REAL);
		
		Category: Objects - Walls
		Get the wall's caps' offsets.
	'''
	pass
	return ( 0.0, 
	         0.0, 
	         0.0, 
	         0.0 )


def GetWallCompEndPts(
		wall          , # HANDLE  - The wall or round wall
		componentIndex  # INTEGER - The component index   
		):
	'''
		Python: (leftPoint, centerPoint, rightPoint) = vs.GetWallCompEndPts(wall, componentIndex)
		VectorScript: PROCEDURE GetWallCompEndPts(wall:HANDLE; componentIndex:INTEGER; VAR leftPoint:REAL; VAR centerPoint:REAL; VAR rightPoint:REAL);
		
		Category: Objects - Walls
		Gets the end points of a wall component.
	'''
	pass
	return ( 0,0, 
	         0,0, 
	         0,0 )


def GetWallCompStartPts(
		wall          , # HANDLE  - The wall or round wall
		componentIndex  # INTEGER - The component index   
		):
	'''
		Python: (leftPoint, centerPoint, rightPoint) = vs.GetWallCompStartPts(wall, componentIndex)
		VectorScript: PROCEDURE GetWallCompStartPts(wall:HANDLE; componentIndex:INTEGER; VAR leftPoint:REAL; VAR centerPoint:REAL; VAR rightPoint:REAL);
		
		Category: Objects - Walls
		Gets the start points of a wall component.
	'''
	pass
	return ( 0,0, 
	         0,0, 
	         0,0 )


def GetWallControlOffset():
	'''
		Python: REAL = vs.GetWallControlOffset()
		VectorScript: FUNCTION GetWallControlOffset : REAL;
		
		Category: Objects - Walls
		Returns the default wall control line offset value.
	'''
	pass
	return 'REAL' # 


def GetWallCornerHeights(
		theWall  # HANDLE - The wall or round wall
		):
	'''
		Python: (startHeightTop, startHeightBottom, endHeightTop, endHeightBottom) = vs.GetWallCornerHeights(theWall)
		VectorScript: PROCEDURE GetWallCornerHeights(theWall:HANDLE; VAR startHeightTop:REAL; VAR startHeightBottom:REAL; VAR endHeightTop:REAL; VAR endHeightBottom:REAL);
		
		Category: Objects - Walls
		Gets the corner heights of a wall or round wall.
	'''
	pass
	return ( 0.0, 
	         0.0, 
	         0.0, 
	         0.0 )


def GetWallHalfBreakInfo(
		wallH     , # HANDLE  -  
		breakIndex  # INTEGER -  
		):
	'''
		Python: (BOOLEAN, startPt, centerPt, endPt) = vs.GetWallHalfBreakInfo(wallH, breakIndex)
		VectorScript: FUNCTION GetWallHalfBreakInfo(wallH:HANDLE; breakIndex:INTEGER; VAR startPtX, startPtY:REAL; VAR centerPtX, centerPtY:REAL; VAR endPtX, endPtY:REAL) : BOOLEAN;
		
		Category: Objects - Walls
		Gets the start point, center point and end point of a half break in a wall along the wall line.
	'''
	pass
	return ( False  , # 
	         0,0    , 
	         0,0    , 
	         0,0     )


def GetWallHeight(
		hWall  # HANDLE -  
		):
	'''
		Python: (dStartTopHght, dStartBotHght, dEndTopHght, dEndBotHght) = vs.GetWallHeight(hWall)
		VectorScript: PROCEDURE GetWallHeight(hWall:HANDLE; VAR dStartTopHght:REAL; VAR dStartBotHght:REAL; VAR dEndTopHght:REAL; VAR dEndBotHght:REAL);
		
		Category: Graphic Calculation
		Returns the height at the start and at the end of a wall.
	'''
	pass
	return ( 0.0, 
	         0.0, 
	         0.0, 
	         0.0 )


def GetWallHoleTexturePart(
		object  # HANDLE - The handle to the cutting object in the wall hole group of a symbol definition or plug-in object.
		):
	'''
		Python: INTEGER = vs.GetWallHoleTexturePart(object)
		VectorScript: FUNCTION GetWallHoleTexturePart(object:HANDLE) : INTEGER;
		
		Category: Textures
		Gets the wall texture part of an object in the wall hole group of a symbol definition or plug-in object.  This is the wall texture part given to faces of the wall that are created by cutting a hole in the wall with the object.
	'''
	pass
	return 'INTEGER' # The wall texture part.[[BR]][[BR]]0 - The wall Holes texture part[[BR]]1 - The wall Left texture part[[BR]]2 - The wall Right texture part


def GetWallOverallHeights(
		theWall  # HANDLE - The wall or round wall
		):
	'''
		Python: (overallHeightTop, overallHeightBottom) = vs.GetWallOverallHeights(theWall)
		VectorScript: PROCEDURE GetWallOverallHeights(theWall:HANDLE; VAR overallHeightTop:REAL; VAR overallHeightBottom:REAL);
		
		Category: Objects - Walls
		Gets the overall heights of a wall or round wall.
	'''
	pass
	return ( 0.0, 
	         0.0 )


def GetWallPeak(
		h    , # HANDLE  - Handle to wall.    
		index  # INTEGER - Index of wall peak.
		):
	'''
		Python: (xPeak, yPeak, zPeak) = vs.GetWallPeak(h, index)
		VectorScript: PROCEDURE GetWallPeak(h:HANDLE; index:INTEGER; VAR xPeak:REAL; VAR yPeak:REAL; VAR zPeak:REAL);
		
		Category: Objects - Walls
		Returns the coordinates of a wall peak in the referenced wall.
	'''
	pass
	return ( 0.0, 
	         0.0, 
	         0.0 )


def GetWallPreferences():
	'''
		Python: HANDLE = vs.GetWallPreferences()
		VectorScript: FUNCTION GetWallPreferences : HANDLE;
		
		Category: Objects - Architectural
		Gets the Wall Preferences. This can be used with the component calls and the Style selectors.
	'''
	pass
	return 'HANDLE' # The Wall Preferences.


def GetWallPrefStyle():
	'''
		Python: STRING = vs.GetWallPrefStyle()
		VectorScript: FUNCTION GetWallPrefStyle : STRING;
		
		Category: Document Settings
		Gets the name of the current document default wall style
	'''
	pass
	return 'STRING' # 


def GetWallStyle(
		theWall  # HANDLE - The wall.
		):
	'''
		Python: STRING = vs.GetWallStyle(theWall)
		VectorScript: FUNCTION GetWallStyle(theWall:HANDLE) : STRING;
		
		Category: Objects - Walls
		Gets the name of the Wall Style for theWall.
	'''
	pass
	return 'STRING' # 


def GetWallThickness(
		h  # HANDLE -  
		):
	'''
		Python: (BOOLEAN, thicknessDist) = vs.GetWallThickness(h)
		VectorScript: FUNCTION GetWallThickness(h:HANDLE; VAR thicknessDist:REAL) : BOOLEAN;
		
		Category: Objects - Walls
		Gets the thickness of a wall
	'''
	pass
	return ( False  , # 
	         0.0     )


def GetWallWidth():
	'''
		Python: REAL = vs.GetWallWidth()
		VectorScript: FUNCTION GetWallWidth : REAL;
		
		Category: Objects - Walls
		Function GetWallWidth returns the default wall width setting of the document.
	'''
	pass
	return 'REAL' # 


def GetWorkingFileId(
		):
	'''
		Python: (BOOLEAN, uuid) = vs.GetWorkingFileId()
		VectorScript: FUNCTION GetWorkingFileId(VAR uuid:STRING) : BOOLEAN;
		
		Category: Project Sharing
		Get the unique id for this Working File.  This is not a filename.
		Every Working File has a unique identifier. When layers are checked-out, they are reserved for not just a particular user, but also for a particular Working File Id.
		The reserved layer can then only be edited in that specific Working File.  If the user creates a second Working File and looks at the layer status, it will show in the second Working File as unavailable for checkout or edit, until it has been committed or released in the first file.
		The specific value of the Working File Id is not meaningful, so it is not directly visible in any of the dialogs.  It is used for the color highlighting of layer names in dialogs that show layer ownership.
	'''
	pass
	return ( False   , # True on success, false on failure or not Project Sharing file.
	         'string' )


def GetWorkingPlane(
		):
	'''
		Python: (x, y, z, xRotation, yRotation, zRotation) = vs.GetWorkingPlane()
		VectorScript: PROCEDURE GetWorkingPlane(VAR x:REAL; VAR y:REAL; VAR z:REAL; VAR xRotation:REAL; VAR yRotation:REAL; VAR zRotation:REAL);
		
		Category: Utility
		Retrieves the location and orientation of the working plane.
	'''
	pass
	return ( 0.0, 
	         0.0, 
	         0.0, 
	         0.0, 
	         0.0, 
	         0.0 )


def GetWorkingPlaneMat(
		refID  # LONGINT - Reference ID of the working plane.
		):
	'''
		Python: (outCenterPt, outNormal, outUVec) = vs.GetWorkingPlaneMat(refID)
		VectorScript: PROCEDURE GetWorkingPlaneMat(refID:LONGINT; VAR outCenterPtX, outCenterPtY, outCenterPtZ:REAL; VAR outNormalX, outNormalY, outNormalZ:REAL; VAR outUVecX, outUVecY, outUVecZ:REAL);
		
		Category: Utility
		Get the specified working plane matrix.
	'''
	pass
	return ( 0,0,0, 
	         0,0,0, 
	         0,0,0 )


def GetWorkingPlaneN(
		):
	'''
		Python: (outCenterPt, outNormal, outUVec) = vs.GetWorkingPlaneN()
		VectorScript: PROCEDURE GetWorkingPlaneN(VAR outCenterPtX, outCenterPtY, outCenterPtZ:REAL; VAR outNormalX, outNormalY, outNormalZ:REAL; VAR outUVecX, outUVecY, outUVecZ:REAL);
		
		Category: Utility
		Get the active working plane.
	'''
	pass
	return ( 0,0,0, 
	         0,0,0, 
	         0,0,0 )


def GetWSAutoRecalcState(
		worksheet  # HANDLE - Handle to worksheet.
		):
	'''
		Python: BOOLEAN = vs.GetWSAutoRecalcState(worksheet)
		VectorScript: FUNCTION GetWSAutoRecalcState(worksheet:HANDLE) : BOOLEAN;
		
		Category: Worksheets
		Gets the AutoRecalc state for the specified worksheet.
		When the AutoRecalc flag is on for a worksheet, it automatically recalculates every time a cell is edited.
		In order to improve speed when editing mutiple cells one after the other or in a loop, it is highly recommended to turn this flag off prior to the edits and restore it, then recalculate the worksheet when all the edits are completed.
	'''
	pass
	return 'BOOLEAN' # 


def GetWSCellAlignment(
		worksheet, # HANDLE  - Handle to a worksheet.       
		row      , # INTEGER - Row of cell to be queried.   
		column     # INTEGER - Column of cell to be queried.
		):
	'''
		Python: cellAlignment = vs.GetWSCellAlignment(worksheet, row, column)
		VectorScript: PROCEDURE GetWSCellAlignment(worksheet:HANDLE; row:INTEGER; column:INTEGER; VAR cellAlignment:INTEGER);
		
		Category: Worksheets
		Returns the horizontal alignment setting of a cell in the referenced worksheet.
	'''
	pass
	return ( 0 )


def GetWSCellBorder(
		worksheet, # HANDLE  - Handle to worksheet.         
		row      , # INTEGER - Row of cell to be queried.   
		column     # INTEGER - Column of cell to be queried.
		):
	'''
		Python: (top, left, bottom, right) = vs.GetWSCellBorder(worksheet, row, column)
		VectorScript: PROCEDURE GetWSCellBorder(worksheet:HANDLE; row:INTEGER; column:INTEGER; VAR top:BOOLEAN; VAR left:BOOLEAN; VAR bottom:BOOLEAN; VAR right:BOOLEAN);
		
		Category: Worksheets
		Returns the cell border of a cell in the referenced worksheet.
	'''
	pass
	return ( False, 
	         False, 
	         False, 
	         False )


def GetWSCellFill(
		worksheet, # HANDLE  - Handle to worksheet         
		row      , # INTEGER - Row of cell to be queried   
		column     # INTEGER - Column of cell to be queried
		):
	'''
		Python: (style, bgcolor, fgcolor, fillpattern) = vs.GetWSCellFill(worksheet, row, column)
		VectorScript: PROCEDURE GetWSCellFill(worksheet:HANDLE; row:INTEGER; column:INTEGER; VAR style:INTEGER; VAR bgcolor:LONGINT; VAR fgcolor:LONGINT; VAR fillpattern:INTEGER);
		
		Category: Worksheets
		Returns the fill style and color of a cell in the referenced worksheet
	'''
	pass
	return ( 0, 
	         0, 
	         0, 
	         0 )


def GetWSCellFormula(
		worksheet, # HANDLE  - Handle to worksheet.         
		row      , # INTEGER - Row of cell to be queried.   
		column     # INTEGER - Column of cell to be queried.
		):
	'''
		Python: formula = vs.GetWSCellFormula(worksheet, row, column)
		VectorScript: PROCEDURE GetWSCellFormula(worksheet:HANDLE; row:INTEGER; column:INTEGER; VAR formula:STRING);
		
		Category: Worksheets
		Returns the formula from a cell in the referenced worksheet.
	'''
	pass
	return ( 'string' )


def GetWSCellFormulaN(
		worksheet, # HANDLE  - Handle to worksheet.         
		row      , # INTEGER - Row of cell to be queried.   
		column     # INTEGER - Column of cell to be queried.
		):
	'''
		Python: formula = vs.GetWSCellFormulaN(worksheet, row, column)
		VectorScript: PROCEDURE GetWSCellFormulaN(worksheet:HANDLE; row:INTEGER; column:INTEGER; VAR formula:DYNARRAY of CHAR);
		
		Category: Worksheets
		Returns the formula from a cell in the referenced worksheet.
	'''
	pass
	return ( 'string' )


def GetWSCellNumberFormat(
		worksheet, # HANDLE  - Handle to worksheet.         
		row      , # INTEGER - Row of cell to be queried.   
		column     # INTEGER - Column of cell to be queried.
		):
	'''
		Python: (style, accuracy, leaderString, trailerString) = vs.GetWSCellNumberFormat(worksheet, row, column)
		VectorScript: PROCEDURE GetWSCellNumberFormat(worksheet:HANDLE; row:INTEGER; column:INTEGER; VAR style:INTEGER; VAR accuracy:INTEGER; VAR leaderString:STRING; VAR trailerString:STRING);
		
		Category: Worksheets
		Returns the numeric formatting of a cell in the referenced worksheet.
		Specific index values for numeric formats and accuracy are listed in the Appendix.
	'''
	pass
	return ( 0       , 
	         0       , 
	         'string', 
	         'string' )


def GetWSCellsImgDPIRes(
		worksheet  # HANDLE - The worksheet handle.
		):
	'''
		Python: dpiResolution = vs.GetWSCellsImgDPIRes(worksheet)
		VectorScript: PROCEDURE GetWSCellsImgDPIRes(worksheet:HANDLE; VAR dpiResolution:INTEGER);
		
		Category: Worksheets
		Gets the DPI resolution for images in the specified worksheet.
	'''
	pass
	return ( 0 )


def GetWSCellString(
		worksheet, # HANDLE  - Handle to worksheet.         
		row      , # INTEGER - Row of cell to be queried.   
		column     # INTEGER - Column of cell to be queried.
		):
	'''
		Python: cellString = vs.GetWSCellString(worksheet, row, column)
		VectorScript: PROCEDURE GetWSCellString(worksheet:HANDLE; row:INTEGER; column:INTEGER; VAR cellString:STRING);
		
		Category: Worksheets
		Returns the displayed string value of a cell in the referenced worksheet.
	'''
	pass
	return ( 'string' )


def GetWSCellStringN(
		worksheet, # HANDLE  - Handle to worksheet.         
		row      , # INTEGER - Row of cell to be queried.   
		column     # INTEGER - Column of cell to be queried.
		):
	'''
		Python: cellString = vs.GetWSCellStringN(worksheet, row, column)
		VectorScript: PROCEDURE GetWSCellStringN(worksheet:HANDLE; row:INTEGER; column:INTEGER; VAR cellString:DYNARRAY of CHAR);
		
		Category: Worksheets
		Returns the displayed string value of a cell in the referenced worksheet.
	'''
	pass
	return ( 'string' )


def GetWSCellTextAngle(
		worksheet, # HANDLE  - Handle to worksheet         
		row      , # INTEGER - Row of cell to be queried   
		column     # INTEGER - Column of cell to be queried
		):
	'''
		Python: angle = vs.GetWSCellTextAngle(worksheet, row, column)
		VectorScript: PROCEDURE GetWSCellTextAngle(worksheet:HANDLE; row:INTEGER; column:INTEGER; VAR angle:INTEGER);
		
		Category: Worksheets
		Returns the text angle of a cell in the referenced worksheet
	'''
	pass
	return ( 0 )


def GetWSCellTextColor(
		worksheet, # HANDLE  - Handle to worksheet         
		row      , # INTEGER - Row of cell to be queried   
		column     # INTEGER - Column of cell to be queried
		):
	'''
		Python: color = vs.GetWSCellTextColor(worksheet, row, column)
		VectorScript: PROCEDURE GetWSCellTextColor(worksheet:HANDLE; row:INTEGER; column:INTEGER; VAR color:LONGINT);
		
		Category: Worksheets
		Returns the text color of a cell in the referenced worksheet
	'''
	pass
	return ( 0 )


def GetWSCellTextFormat(
		worksheet, # HANDLE  - Handle to worksheet.         
		row      , # INTEGER - Row of cell to be queried.   
		column     # INTEGER - Column of cell to be queried.
		):
	'''
		Python: (fontIndex, size, style) = vs.GetWSCellTextFormat(worksheet, row, column)
		VectorScript: PROCEDURE GetWSCellTextFormat(worksheet:HANDLE; row:INTEGER; column:INTEGER; VAR fontIndex:INTEGER; VAR size:INTEGER; VAR style:INTEGER);
		
		Category: Worksheets
		Returns text format settings for a cell in the referenced worksheet.
	'''
	pass
	return ( 0, 
	         0, 
	         0 )


def GetWSCellValue(
		worksheet, # HANDLE  - Handle to worksheet.         
		row      , # INTEGER - Row of cell to be queried.   
		column     # INTEGER - Column of cell to be queried.
		):
	'''
		Python: cellValue = vs.GetWSCellValue(worksheet, row, column)
		VectorScript: PROCEDURE GetWSCellValue(worksheet:HANDLE; row:INTEGER; column:INTEGER; VAR cellValue:REAL);
		
		Category: Worksheets
		Returns the displayed numeric value of a cell in the referenced worksheet.
	'''
	pass
	return ( 0.0 )


def GetWSCellVertAlignment(
		worksheet, # HANDLE  - Handle to worksheet               
		row      , # INTEGER - Row index of cell to be queried   
		column     # INTEGER - Column index of cell to be queried
		):
	'''
		Python: vAlignment = vs.GetWSCellVertAlignment(worksheet, row, column)
		VectorScript: PROCEDURE GetWSCellVertAlignment(worksheet:HANDLE; row:INTEGER; column:INTEGER; VAR vAlignment:INTEGER);
		
		Category: Worksheets
		Returns the vertical alignment setting of a cell in the referenced worksheet.
	'''
	pass
	return ( 0 )


def GetWSCellWrapTextFlag(
		worksheet, # HANDLE  - Handle to worksheet      
		row      , # INTEGER - Row of cell to be queried
		column     # INTEGER - Row of cell to be queried
		):
	'''
		Python: wrapTextFlag = vs.GetWSCellWrapTextFlag(worksheet, row, column)
		VectorScript: PROCEDURE GetWSCellWrapTextFlag(worksheet:HANDLE; row:INTEGER; column:INTEGER; VAR wrapTextFlag:BOOLEAN);
		
		Category: Worksheets
		Returns the wrap text state of a cell in the referenced worksheet.
	'''
	pass
	return ( False )


def GetWSColumnOperators(
		worksheet, # HANDLE  - Handle to worksheet.
		row        # INTEGER - Row to be queried.  
		):
	'''
		Python: (sort1, sort2, sort3, sum1, sum2, sum3) = vs.GetWSColumnOperators(worksheet, row)
		VectorScript: PROCEDURE GetWSColumnOperators(worksheet:HANDLE; row:INTEGER; VAR sort1:INTEGER; VAR sort2:INTEGER; VAR sort3:INTEGER; VAR sum1:INTEGER; VAR sum2:INTEGER; VAR sum3:INTEGER);
		
		Category: Worksheets
		Returns the sort and summarize column operators for a database row in the referenced worksheet.
	'''
	pass
	return ( 0, 
	         0, 
	         0, 
	         0, 
	         0, 
	         0 )


def GetWSColumnSortPrecedence(
		worksheet  , # HANDLE  - Handle to worksheet.       
		databaseRow, # INTEGER - Database row to be queried.
		column       # INTEGER - Column to be queried.      
		):
	'''
		Python: INTEGER = vs.GetWSColumnSortPrecedence(worksheet, databaseRow, column)
		VectorScript: FUNCTION GetWSColumnSortPrecedence(worksheet:HANDLE; databaseRow:INTEGER; column:INTEGER) : INTEGER;
		
		Category: Worksheets
		Gets database column sort precedence, if any.
	'''
	pass
	return 'INTEGER' # 


def GetWSColumnSortType(
		worksheet  , # HANDLE  - Handle to worksheet.       
		databaseRow, # INTEGER - Database row to be queried.
		column       # INTEGER - Column to be queried.      
		):
	'''
		Python: INTEGER = vs.GetWSColumnSortType(worksheet, databaseRow, column)
		VectorScript: FUNCTION GetWSColumnSortType(worksheet:HANDLE; databaseRow:INTEGER; column:INTEGER) : INTEGER;
		
		Category: Worksheets
		Gets database column's sort type.
	'''
	pass
	return 'INTEGER' # 


def GetWSColumnWidth(
		worksheet, # HANDLE  - Handle to worksheet. 
		column     # INTEGER - Column to be queried.
		):
	'''
		Python: width = vs.GetWSColumnWidth(worksheet, column)
		VectorScript: PROCEDURE GetWSColumnWidth(worksheet:HANDLE; column:INTEGER; VAR width:INTEGER);
		
		Category: Worksheets
		Returns the width of a column in the referenced worksheet.
	'''
	pass
	return ( 0 )


def GetWSFromImage(
		worksheetImage  # HANDLE - Handle to worksheet image object.
		):
	'''
		Python: HANDLE = vs.GetWSFromImage(worksheetImage)
		VectorScript: FUNCTION GetWSFromImage(worksheetImage:HANDLE) : HANDLE;
		
		Category: Worksheets
		Returns a handle to the worksheet being displayed by a worksheet image object..
	'''
	pass
	return 'HANDLE' # 


def GetWSImage(
		worksheet  # HANDLE - Handle to worksheet.
		):
	'''
		Python: HANDLE = vs.GetWSImage(worksheet)
		VectorScript: FUNCTION GetWSImage(worksheet:HANDLE) : HANDLE;
		
		Category: Worksheets
		Returns a handle to the on-drawing object (image) of the referenced worksheet.
	'''
	pass
	return 'HANDLE' # Returns a HANDLE of the worksheet image object.


def GetWSImageScaleF(
		handle  # HANDLE - The handle to the worksheet on drawing object.
		):
	'''
		Python: REAL = vs.GetWSImageScaleF(handle)
		VectorScript: FUNCTION GetWSImageScaleF(handle:HANDLE) : REAL;
		
		Category: Worksheets
		Returns the scale factor of the specified worksheet on drawing object.
	'''
	pass
	return 'REAL' # The scale factor of the specified worksheet on drawing object.


def GetWSImgAngle(
		worksheet, # HANDLE  -                 
		row      , # INTEGER - The cell row.   
		column     # INTEGER - The cell column.
		):
	'''
		Python: NewParam = vs.GetWSImgAngle(worksheet, row, column)
		VectorScript: PROCEDURE GetWSImgAngle(worksheet:HANDLE; row:INTEGER; column:INTEGER; VAR NewParam:REAL);
		
		Category: Worksheets
		Gets the specified worksheet cell's image angle.
	'''
	pass
	return ( 0.0 )


def GetWSImgComponent(
		worksheet, # HANDLE  - The worksheet handle.
		row      , # INTEGER - The cell row.        
		column     # INTEGER - The cell column.     
		):
	'''
		Python: component = vs.GetWSImgComponent(worksheet, row, column)
		VectorScript: PROCEDURE GetWSImgComponent(worksheet:HANDLE; row:INTEGER; column:INTEGER; VAR component:INTEGER);
		
		Category: Worksheets
		Gets the specified component of a worksheet cell image.
		Table - Components:
		Component			Constant
		"3D" 				0
		"2D"				1
		"2D Cut"			                2
		"Not set"			                4
	'''
	pass
	return ( 0 )


def GetWSImgMarginSize(
		worksheet, # HANDLE  - The worksheet handle.
		row      , # INTEGER - The cell row.        
		column     # INTEGER - The cell column.     
		):
	'''
		Python: marginSize = vs.GetWSImgMarginSize(worksheet, row, column)
		VectorScript: PROCEDURE GetWSImgMarginSize(worksheet:HANDLE; row:INTEGER; column:INTEGER; VAR marginSize:INTEGER);
		
		Category: Worksheets
		Gets the worksheet cell's image margin size.
	'''
	pass
	return ( 0 )


def GetWSImgRenderMode(
		worksheet, # HANDLE  - The worksheet handle.
		row      , # INTEGER - The cell row.        
		column     # INTEGER - The cell column.     
		):
	'''
		Python: renderMode = vs.GetWSImgRenderMode(worksheet, row, column)
		VectorScript: PROCEDURE GetWSImgRenderMode(worksheet:HANDLE; row:INTEGER; column:INTEGER; VAR renderMode:INTEGER);
		
		Category: Worksheets
		Gets the specified worksheet cell's image render mode
	'''
	pass
	return ( 0 )


def GetWSImgScale(
		worksheet, # HANDLE  - The worksheet handle.
		row      , # INTEGER - The cell row.        
		column     # INTEGER - The cell column.     
		):
	'''
		Python: scale = vs.GetWSImgScale(worksheet, row, column)
		VectorScript: PROCEDURE GetWSImgScale(worksheet:HANDLE; row:INTEGER; column:INTEGER; VAR scale:REAL);
		
		Category: Worksheets
		Gets the worksheet cell's image scale.
	'''
	pass
	return ( 0.0 )


def GetWSImgShowDBHeader(
		hWorksheetImage  # HANDLE -  
		):
	'''
		Python: BOOLEAN = vs.GetWSImgShowDBHeader(hWorksheetImage)
		VectorScript: FUNCTION GetWSImgShowDBHeader(hWorksheetImage:HANDLE) : BOOLEAN;
		
		Category: Worksheets
		Check whether worksheet image is set to show database headers.
	'''
	pass
	return 'BOOLEAN' # 


def GetWSImgSize(
		worksheet, # HANDLE  - The worksheet handle.
		row      , # INTEGER - The cell row.        
		column     # INTEGER - The cell column.     
		):
	'''
		Python: (height, width) = vs.GetWSImgSize(worksheet, row, column)
		VectorScript: PROCEDURE GetWSImgSize(worksheet:HANDLE; row:INTEGER; column:INTEGER; VAR height:INTEGER; VAR width:INTEGER);
		
		Category: Worksheets
		Gets the specified worksheet cell's image size.
	'''
	pass
	return ( 0, 
	         0 )


def GetWSImgSizeType(
		worksheet, # HANDLE  - The worksheet handle.
		row      , # INTEGER - The cell row.        
		column     # INTEGER - The cell column.     
		):
	'''
		Python: INTEGER = vs.GetWSImgSizeType(worksheet, row, column)
		VectorScript: FUNCTION GetWSImgSizeType(worksheet:HANDLE; row:INTEGER; column:INTEGER) : INTEGER;
		
		Category: Worksheets
		Gets the worksheet cell's image size type.
	'''
	pass
	return 'INTEGER' # INTEGER specifying the cell image size type.


def GetWSImgType(
		worksheet, # HANDLE  - The worksheet handle.
		row      , # INTEGER - The cell row.        
		column     # INTEGER - The cell column.     
		):
	'''
		Python: type = vs.GetWSImgType(worksheet, row, column)
		VectorScript: PROCEDURE GetWSImgType(worksheet:HANDLE; row:INTEGER; column:INTEGER; VAR type:INTEGER);
		
		Category: Worksheets
		Gets the specified worksheet cell's image type.
	'''
	pass
	return ( 0 )


def GetWSImgUseLayScale(
		worksheet, # HANDLE  - The worksheet handle.
		row      , # INTEGER - The cell row.        
		column     # INTEGER - The cell column.     
		):
	'''
		Python: BOOLEAN = vs.GetWSImgUseLayScale(worksheet, row, column)
		VectorScript: FUNCTION GetWSImgUseLayScale(worksheet:HANDLE; row:INTEGER; column:INTEGER) : BOOLEAN;
		
		Category: Worksheets
		Determines if the image size type is Layer Scale.
	'''
	pass
	return 'BOOLEAN' # BOOLEAN indicating if state of cell's use layer scale.


def GetWSImgUseObjectImg(
		worksheet, # HANDLE  - The worksheet handle.
		row      , # INTEGER - The cell row.        
		column     # INTEGER - The cell column.     
		):
	'''
		Python: BOOLEAN = vs.GetWSImgUseObjectImg(worksheet, row, column)
		VectorScript: FUNCTION GetWSImgUseObjectImg(worksheet:HANDLE; row:INTEGER; column:INTEGER) : BOOLEAN;
		
		Category: Worksheets
		Determines if cell uses object image.
	'''
	pass
	return 'BOOLEAN' # BOOLEAN indicating state of cell's use object image.


def GetWSImgView(
		worksheet, # HANDLE  - The worksheet handle.
		row      , # INTEGER - The cell row.        
		column     # INTEGER - The cell column.     
		):
	'''
		Python: view = vs.GetWSImgView(worksheet, row, column)
		VectorScript: PROCEDURE GetWSImgView(worksheet:HANDLE; row:INTEGER; column:INTEGER; VAR view:INTEGER);
		
		Category: Worksheets
		Gets the specified worksheet cell's image view.
	'''
	pass
	return ( 0 )


def GetWSMergedCellRange(
		worksheet, # HANDLE  - Worksheet on which function is to operate.                      
		row      , # INTEGER - Row index of merged cell from which to get the covered range.   
		column     # INTEGER - Column index of merged cell from which to get the covered range.
		):
	'''
		Python: (BOOLEAN, topRow, leftColumn, bottomRow, rightColumn) = vs.GetWSMergedCellRange(worksheet, row, column)
		VectorScript: FUNCTION GetWSMergedCellRange(worksheet:HANDLE; row:INTEGER; column:INTEGER; VAR topRow:INTEGER; VAR leftColumn:INTEGER; VAR bottomRow:INTEGER; VAR rightColumn:INTEGER) : BOOLEAN;
		
		Category: Worksheets
		Gets the range of cells covered by the specified cell. Returns true if the specified cell is a merged cell.
	'''
	pass
	return ( False  , # 'true' if specified cell is a merged cell[[BR]]'false' otherwise.
	         0      , 
	         0      , 
	         0      , 
	         0       )


def GetWSPlacement(
		worksheet  # HANDLE - Handle to worksheet.
		):
	'''
		Python: (top, left, bottom, right) = vs.GetWSPlacement(worksheet)
		VectorScript: PROCEDURE GetWSPlacement(worksheet:HANDLE; VAR top:INTEGER; VAR left:INTEGER; VAR bottom:INTEGER; VAR right:INTEGER);
		
		Category: Worksheets
		Returns the on-screen location of the referenced worksheets' window.
	'''
	pass
	return ( 0, 
	         0, 
	         0, 
	         0 )


def GetWSRowColumnCount(
		worksheet  # HANDLE - Handle to worksheet.
		):
	'''
		Python: (numRows, numColumns) = vs.GetWSRowColumnCount(worksheet)
		VectorScript: PROCEDURE GetWSRowColumnCount(worksheet:HANDLE; VAR numRows:INTEGER; VAR numColumns:INTEGER);
		
		Category: Worksheets
		Returns the number of rows and columns in the referenced worksheet.
	'''
	pass
	return ( 0, 
	         0 )


def GetWSRowHeight(
		worksheet, # HANDLE  - Handle to worksheet.
		row        # INTEGER - Row to be queried.  
		):
	'''
		Python: height = vs.GetWSRowHeight(worksheet, row)
		VectorScript: PROCEDURE GetWSRowHeight(worksheet:HANDLE; row:INTEGER; VAR height:INTEGER);
		
		Category: Worksheets
		Returns the height of a row in the referenced worksheet.
	'''
	pass
	return ( 0 )


def GetWSRowHLockState(
		worksheet, # HANDLE  - Handle to worksheet
		row        # INTEGER - Worksheet row index
		):
	'''
		Python: lockState = vs.GetWSRowHLockState(worksheet, row)
		VectorScript: PROCEDURE GetWSRowHLockState(worksheet:HANDLE; row:INTEGER; VAR lockState:BOOLEAN);
		
		Category: Worksheets
		Returns the lock state of a row in the referenced worksheet
		Note: If a row height is locked, the row will not automatically resize to fit the contents of the cells when text is entered.
	'''
	pass
	return ( False )


def GetWSSelection(
		worksheet  # HANDLE - Handle to worksheet.
		):
	'''
		Python: (currentCellRow, currentCellColumn, topRangeRow, leftRangeColumn, topRangeSubrow, bottomRangeRow, rightRangeColumn, bottomRangeSubrow) = vs.GetWSSelection(worksheet)
		VectorScript: PROCEDURE GetWSSelection(worksheet:HANDLE; VAR currentCellRow:INTEGER; VAR currentCellColumn:INTEGER; VAR topRangeRow:INTEGER; VAR leftRangeColumn:INTEGER; VAR topRangeSubrow:INTEGER; VAR bottomRangeRow:INTEGER; VAR rightRangeColumn:INTEGER; VAR bottomRangeSubrow:INTEGER);
		
		Category: Worksheets
		Returns the current selection range of the referenced worksheet.
		In addition to returning the selection range of a worksheet, GetWSSelection will also return the range of selected database subrows, where applicable.
	'''
	pass
	return ( 0, 
	         0, 
	         0, 
	         0, 
	         0, 
	         0, 
	         0, 
	         0 )


def GetWSSubrowActualCellString(
		worksheet, # HANDLE  - Handle to worksheet.               
		row      , # INTEGER - Database row to be queried.        
		column   , # INTEGER - Column to be queried.              
		subrow     # INTEGER - Index of subrow cell to be queried.
		):
	'''
		Python: cellString = vs.GetWSSubrowActualCellString(worksheet, row, column, subrow)
		VectorScript: PROCEDURE GetWSSubrowActualCellString(worksheet:HANDLE; row:INTEGER; column:INTEGER; subrow:INTEGER; VAR cellString:STRING);
		
		Category: Worksheets
		Returns the actual string in a database subrow cell.
	'''
	pass
	return ( 'string' )


def GetWSSubrowActualStringN(
		worksheet, # HANDLE  - Handle to worksheet.               
		row      , # INTEGER - Database row to be queried.        
		column   , # INTEGER - Column to be queried.              
		subrow     # INTEGER - Index of subrow cell to be queried.
		):
	'''
		Python: cellString = vs.GetWSSubrowActualStringN(worksheet, row, column, subrow)
		VectorScript: PROCEDURE GetWSSubrowActualStringN(worksheet:HANDLE; row:INTEGER; column:INTEGER; subrow:INTEGER; VAR cellString:DYNARRAY of CHAR);
		
		Category: Worksheets
		Returns the actual string in a database subrow cell.
	'''
	pass
	return ( 'string' )


def GetWSSubrowCellString(
		worksheet, # HANDLE  - Handle to worksheet.               
		row      , # INTEGER - Database row to be queried.        
		column   , # INTEGER - Column to be queried.              
		subrow     # INTEGER - Index of subrow cell to be queried.
		):
	'''
		Python: cellString = vs.GetWSSubrowCellString(worksheet, row, column, subrow)
		VectorScript: PROCEDURE GetWSSubrowCellString(worksheet:HANDLE; row:INTEGER; column:INTEGER; subrow:INTEGER; VAR cellString:STRING);
		
		Category: Worksheets
		Returns the displayed string in a database subrow cell.
	'''
	pass
	return ( 'string' )


def GetWSSubrowCellStrN(
		worksheet, # HANDLE  - Handle to worksheet.               
		row      , # INTEGER - Database row to be queried.        
		column   , # INTEGER - Column to be queried.              
		subrow     # INTEGER - Index of subrow cell to be queried.
		):
	'''
		Python: cellString = vs.GetWSSubrowCellStrN(worksheet, row, column, subrow)
		VectorScript: PROCEDURE GetWSSubrowCellStrN(worksheet:HANDLE; row:INTEGER; column:INTEGER; subrow:INTEGER; VAR cellString:DYNARRAY of CHAR);
		
		Category: Worksheets
		Returns the displayed string in a database subrow cell.
	'''
	pass
	return ( 'string' )


def GetWSSubrowCellValue(
		worksheet, # HANDLE  - Handle to worksheet.               
		row      , # INTEGER - Database row to be queried.        
		column   , # INTEGER - Column to be queried.              
		subrow     # INTEGER - Index of subrow cell to be queried.
		):
	'''
		Python: cellValue = vs.GetWSSubrowCellValue(worksheet, row, column, subrow)
		VectorScript: PROCEDURE GetWSSubrowCellValue(worksheet:HANDLE; row:INTEGER; column:INTEGER; subrow:INTEGER; VAR cellValue:REAL);
		
		Category: Worksheets
		Returns the displayed numeric value in a database subrow cell.
	'''
	pass
	return ( 0.0 )


def GetWSSubrowCount(
		worksheet  , # HANDLE  - Handle to worksheet.       
		databaseRow  # INTEGER - Database row to be queried.
		):
	'''
		Python: numSubrows = vs.GetWSSubrowCount(worksheet, databaseRow)
		VectorScript: PROCEDURE GetWSSubrowCount(worksheet:HANDLE; databaseRow:INTEGER; VAR numSubrows:INTEGER);
		
		Category: Worksheets
		Returns a count of displayed subrows for a specified database row.
	'''
	pass
	return ( 0 )


def GetWSSubrowHeight(
		worksheet  , # HANDLE  - Handle to worksheet.             
		databaserow, # INTEGER - The database row                 
		subrow       # INTEGER - The database subrow to be queried
		):
	'''
		Python: height = vs.GetWSSubrowHeight(worksheet, databaserow, subrow)
		VectorScript: PROCEDURE GetWSSubrowHeight(worksheet:HANDLE; databaserow:INTEGER; subrow:INTEGER; VAR height:INTEGER);
		
		Category: Worksheets
		Return the height of a database subrow in the referenced worksheet.
	'''
	pass
	return ( 0 )


def GetXPropVersion(
		):
	'''
		Python: outVersion = vs.GetXPropVersion()
		VectorScript: PROCEDURE GetXPropVersion(VAR outVersion:LONGINT);
		
		Category: Object Events
	'''
	pass
	return ( 0 )


def GetZatXY(
		hObject, # HANDLE -  
		X      , # REAL   -  
		Y        # REAL   -  
		):
	'''
		Python: (BOOLEAN, outZ) = vs.GetZatXY(hObject, X, Y)
		VectorScript: FUNCTION GetZatXY(hObject:HANDLE; X:REAL; Y:REAL; VAR outZ:REAL) : BOOLEAN;
		
		Category: Graphic Calculation
		Returns the Z elevation of a point X,Y on the specified object. If hObject = NIL then searches all visible objects; hObject = layer - all objects on the layer
	'''
	pass
	return ( False  , # 
	         0.0     )


def GetZoom():
	'''
		Python: REAL = vs.GetZoom()
		VectorScript: FUNCTION GetZoom : REAL;
		
		Category: View / Zoom
		Function GetZoom returns the percentage of the zoom factor in the current document view.
	'''
	pass
	return 'REAL' # 


def GetZVals(
		):
	'''
		Python: (zVal, deltaZVal) = vs.GetZVals()
		VectorScript: PROCEDURE GetZVals(VAR zVal:REAL; VAR deltaZVal:REAL);
		
		Category: Layers
		Procedure GetZVals returns the Z (layer base elevation) and delta Z (layer thickness) values for the active layer.
	'''
	pass
	return ( 0.0, 
	         0.0 )


def GrayClass(
		clasName   # STRING - Name of class.
		):
	'''
		Python: vs.GrayClass(className)
		VectorScript: PROCEDURE GrayClass(className:STRING);
		
		Category: Classes
		Sets the visibility of the specified class to grayed status.
	'''
	pass


def GrayLayer():
	'''
		Python: vs.GrayLayer()
		VectorScript: PROCEDURE GrayLayer;
		
		Category: Layers
		Procedure GrayLayer sets the visibility status of the active layer to grayed. Objects on grayed layers will always appear grayed when viewed from other layers.
	'''
	pass


def GridLines(
		gridDistance  # REAL (Coordinate) - Grid spacing distance.
		):
	'''
		Python: vs.GridLines(gridDistance)
		VectorScript: PROCEDURE GridLines(gridDistance:REAL (Coordinate));
		
		Category: Document Settings
		Procedure GridLines sets the distance between the drawing grid lines in the document.
	'''
	pass


def Group():
	'''
		Python: vs.Group()
		VectorScript: PROCEDURE Group;
		
		Category: Objects - Groups
		Procedures Group groups selected objects in a Vectorworks document. Any selected objects on the active layer(or any selected objects in the document when in Show-Snap-Modify mode) will be included in the new group object.
	'''
	pass


def GroupToMesh(
		groupObj  # HANDLE - Handle to a group containing 3D polygons
		):
	'''
		Python: HANDLE = vs.GroupToMesh(groupObj)
		VectorScript: FUNCTION GroupToMesh(groupObj:HANDLE) : HANDLE;
		
		Category: Objects - Groups
		Converts a group of 3D polygons into a mesh network.
	'''
	pass
	return 'HANDLE' # Returns a handle to the mesh network.


def GS_EdSh_ConstructLayout(
		shaderNameCStr, # ANY -  
		paramsPtr     , # ANY -  
		libraryDataPtr  # ANY -  
		):
	'''
		Python: vs.GS_EdSh_ConstructLayout(shaderNameCStr, paramsPtr, libraryDataPtr)
		VectorScript: PROCEDURE GS_EdSh_ConstructLayout(shaderNameCStr1,shaderNameCStr2,...,shaderNameCStrN:ANY; paramsPtr1,paramsPtr2,...,paramsPtrN:ANY; libraryDataPtr1,libraryDataPtr2,...,libraryDataPtrN:ANY);
		
		Category: Textures
		Creates a dialog layout for editing a shader's parameter values.
	'''
	pass


def GS_EdSh_PopulateMenu(
		itemID        , # LONGINT -  
		numStrings    , # LONGINT -  
		cStringsArray , # LONGINT -  
		libraryDataPtr  # LONGINT -  
		):
	'''
		Python: vs.GS_EdSh_PopulateMenu(itemID, numStrings, cStringsArray, libraryDataPtr)
		VectorScript: PROCEDURE GS_EdSh_PopulateMenu(itemID:LONGINT; numStrings:LONGINT; cStringsArray:LONGINT; libraryDataPtr:LONGINT);
		
		Category: Textures
		Adds menu items to a popup in an edit shader dialog.
	'''
	pass


def GS_EdSh_RunDialog(
		):
	'''
		Python: (userHitOK, libraryDataPtr) = vs.GS_EdSh_RunDialog()
		VectorScript: PROCEDURE GS_EdSh_RunDialog(VAR userHitOK:BOOLEAN; VAR libraryDataPtr:BOOLEAN);
		
		Category: Textures
		Runs an edit shader dialog layout.
	'''
	pass
	return ( False, 
	         False )


def HAngle(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: REAL = vs.HAngle(h)
		VectorScript: FUNCTION HAngle(h:HANDLE) : REAL;
		
		Category: Object Info
		Function HAngle returns the angle of the referenced line or arc object.
	'''
	pass
	return 'REAL' # 


def HArea(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: REAL = vs.HArea(h)
		VectorScript: FUNCTION HArea(h:HANDLE) : REAL;
		
		Category: Object Info
		Function HArea returns the area of the referenced object.
	'''
	pass
	return 'REAL' # 


def HAreaN(
		ObjectHandle  # HANDLE - It is the object we want to calculate its area.
		):
	'''
		Python: REAL = vs.HAreaN(ObjectHandle)
		VectorScript: FUNCTION HAreaN(ObjectHandle:HANDLE) : REAL;
		
		Category: Object Info
		Compute the area of a given object, it has the same function as HArea(), but the result in case of polyline is more accurate.
	'''
	pass
	return 'REAL' # 


def HasConstraint(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: BOOLEAN = vs.HasConstraint(h)
		VectorScript: FUNCTION HasConstraint(h:HANDLE) : BOOLEAN;
		
		Category: Parametric Constraints
		Returns whether the referenced object has a parametric constraint .
	'''
	pass
	return 'BOOLEAN' # 


def HasDim(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: BOOLEAN = vs.HasDim(h)
		VectorScript: FUNCTION HasDim(h:HANDLE) : BOOLEAN;
		
		Category: Dimensions
		Function HasDim returns TRUE if a line or arc object has dimension text associated with it, otherwise it returns FALSE.
	'''
	pass
	return 'BOOLEAN' # 


def HasObjStoryBound(
		object , # HANDLE  - The object.                       
		boundID  # INTEGER - The identifier of the story bound.
		):
	'''
		Python: BOOLEAN = vs.HasObjStoryBound(object, boundID)
		VectorScript: FUNCTION HasObjStoryBound(object:HANDLE; boundID:INTEGER) : BOOLEAN;
		
		Category: Objects - Architectural
		Determine if the object has the specified story bound ID present.
	'''
	pass
	return 'BOOLEAN' # Retrun TRUE if the story bound ID is present. Otherwise - FALSE.


def HasObjStoryBounds(
		object  # HANDLE - The object.
		):
	'''
		Python: BOOLEAN = vs.HasObjStoryBounds(object)
		VectorScript: FUNCTION HasObjStoryBounds(object:HANDLE) : BOOLEAN;
		
		Category: Objects - Architectural
		Determine if the object has any story bounds.
	'''
	pass
	return 'BOOLEAN' # Return TRUE if the object has any story bounds. Otherwise - FALSE.


def HasPlugin(
		itemUniversalName  # STRING - Universal name of the plug-in
		):
	'''
		Python: (BOOLEAN, PaletteName) = vs.HasPlugin(itemUniversalName)
		VectorScript: FUNCTION HasPlugin(itemUniversalName:STRING; VAR PaletteName:STRING) : BOOLEAN;
		
		Category: Objects - Custom
		Returns whether tool item or menu command is in current workspace.
	'''
	pass
	return ( False   , # Returns true if the plug-in is found in the workspace; false otherwise.
	         'string' )


def HasWSColumnOperator(
		worksheet   , # HANDLE  - Handle to worksheet.       
		databaseRow , # INTEGER - Database row to be queried.
		column      , # INTEGER - Column to be queried.      
		operatorType  # INTEGER - Operator type.             
		):
	'''
		Python: BOOLEAN = vs.HasWSColumnOperator(worksheet, databaseRow, column, operatorType)
		VectorScript: FUNCTION HasWSColumnOperator(worksheet:HANDLE; databaseRow:INTEGER; column:INTEGER; operatorType:INTEGER) : BOOLEAN;
		
		Category: Worksheets
		Determines if specified column operator is set in column.
	'''
	pass
	return 'BOOLEAN' # 


def HCenter(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: p = vs.HCenter(h)
		VectorScript: PROCEDURE HCenter(h:HANDLE; VAR pX, pY:REAL);
		
		Category: Graphic Calculation
		Procedure HCenter returns the logical center point of the object specified in h. For most objects, this is the center of the bounding box. For circles, arcs, and round walls HCenter returns the arc center of the object.
	'''
	pass
	return ( 0,0 )


def HDuplicate(
		objectHandle, # HANDLE - Handle to the object to duplicate                                       
		x           , # REAL   - X-coordinate of distance object should be shifted from original location
		y             # REAL   - Y-coordinate of distance object should be shifted from original location
		):
	'''
		Python: HANDLE = vs.HDuplicate(objectHandle, x, y)
		VectorScript: FUNCTION HDuplicate(objectHandle:HANDLE; x:REAL; y:REAL) : HANDLE;
		
		Category: Object Editing
		Duplicates and moves an object by the offsets specified.
	'''
	pass
	return 'HANDLE' # Returns a handle to the new object.


def Height(
		c  # CRITERIA - Search criteria.
		):
	'''
		Python: REAL = vs.Height(c)
		VectorScript: FUNCTION Height(c:CRITERIA) : REAL;
		
		Category: Criteria
		Returns the height of an object. If more than one object matches the search criteria, the function will return the sum of all the matching object heights.
	'''
	pass
	return 'REAL' # 


def HExtrude(
		objectH, # HANDLE - The profile to be extruded.               
		bottom , # REAL   - The z height of the bottom of the extrude.
		top      # REAL   - The z height of the top of the extrude.   
		):
	'''
		Python: HANDLE = vs.HExtrude(objectH, bottom, top)
		VectorScript: FUNCTION HExtrude(objectH:HANDLE; bottom:REAL; top:REAL) : HANDLE;
		
		Category: Objects - 3D
		Creates an extrude object from the specified object.
	'''
	pass
	return 'HANDLE' # A handle to the newly created extrude object.


def HGetLayerTransp(
		hLayer  # HANDLE - Handle to the layer.
		):
	'''
		Python: REAL = vs.HGetLayerTransp(hLayer)
		VectorScript: FUNCTION HGetLayerTransp(hLayer:HANDLE) : REAL;
		
		Category: Layers
		Get the transparency of the spcified layer.
	'''
	pass
	return 'REAL' # 


def HHeight(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: REAL = vs.HHeight(h)
		VectorScript: FUNCTION HHeight(h:HANDLE) : REAL;
		
		Category: Object Info
		Function HHeight returns the height of the referenced object.
	'''
	pass
	return 'REAL' # 


def Hide(
		c  # CRITERIA - Search criteria.
		):
	'''
		Python: vs.Hide(c)
		VectorScript: PROCEDURE Hide(c:CRITERIA);
		
		Category: Criteria
		Hides any visible or grayed objects matching the specified search criteria.
	'''
	pass


def HideClass(
		clasName   # STRING - Name of class.
		):
	'''
		Python: vs.HideClass(className)
		VectorScript: PROCEDURE HideClass(className:STRING);
		
		Category: Classes
		Sets the class visibility of the specified class to hidden (invisible) status.
	'''
	pass


def HideLayer():
	'''
		Python: vs.HideLayer()
		VectorScript: PROCEDURE HideLayer;
		
		Category: Layers
		Procedure HideLayer sets the visibility status of the active layer to hidden. Objects on hidden layers will not be viewable from other layers.
	'''
	pass


def HierLBItemClosed(
		dialogID   , # LONGINT - The id of the dialog containing the list browser.                             
		componentID, # LONGINT - The id of the list browser.                                                   
		itemIndex  , # INTEGER - The index of the item that was clicked on.                                    
		recursive    # BOOLEAN - Whether to also close any containers inside the container that was clicked on.
		):
	'''
		Python: vs.HierLBItemClosed(dialogID, componentID, itemIndex, recursive)
		VectorScript: PROCEDURE HierLBItemClosed(dialogID:LONGINT; componentID:LONGINT; itemIndex:INTEGER; recursive:BOOLEAN);
		
		Category: Dialogs - Modern - Browser
		This function is called when the user clicks on a container item to close it. It will remove items that are inside the container being closed.
	'''
	pass


def HierLBItemIsClosed(
		dialogID   , # LONGINT - The id of the dialog.      
		componentID, # LONGINT - The id of the list browser.
		itemIndex    # INTEGER - The index of the item.     
		):
	'''
		Python: BOOLEAN = vs.HierLBItemIsClosed(dialogID, componentID, itemIndex)
		VectorScript: FUNCTION HierLBItemIsClosed(dialogID:LONGINT; componentID:LONGINT; itemIndex:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Returns whether the indicated container item is closed.
	'''
	pass
	return 'BOOLEAN' # 


def HierLBItemIsContain(
		dialogID   , # LONGINT - The id of the dialog containing the list browser.
		componentID, # LONGINT - The ID of the list browser.                      
		itemIndex    # INTEGER - The index of the item.                           
		):
	'''
		Python: BOOLEAN = vs.HierLBItemIsContain(dialogID, componentID, itemIndex)
		VectorScript: FUNCTION HierLBItemIsContain(dialogID:LONGINT; componentID:LONGINT; itemIndex:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Returns whether the indicated item is a container item.
	'''
	pass
	return 'BOOLEAN' # Whether the indicated item is a container item.


def HierLBItemOpened(
		dialogID   , # LONGINT - The id of the dialog containing the list browser.         
		componentID, # LONGINT - The id of the list browser.                               
		itemIndex  , # INTEGER - The index of the item that was clicked on.                
		recursive    # BOOLEAN - Indicates whether any subcontainers should also be opened.
		):
	'''
		Python: numbRedisplItems = vs.HierLBItemOpened(dialogID, componentID, itemIndex, recursive)
		VectorScript: PROCEDURE HierLBItemOpened(dialogID:LONGINT; componentID:LONGINT; itemIndex:INTEGER; recursive:BOOLEAN; VAR numbRedisplItems:INTEGER);
		
		Category: Dialogs - Modern - Browser
		This function is called when the user clicks on a container item to open it. It wil redisplay items inside the container that were hidden (unless they are inside a lower level container that is closed), but only with the hierarchical name set. If other data needs to be redisplayed, it will need to be done with other functions. numbRedisplItems indicates how many non-container items were redisplayed.
	'''
	pass
	return ( 0 )


def HLength(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: REAL = vs.HLength(h)
		VectorScript: FUNCTION HLength(h:HANDLE) : REAL;
		
		Category: Object Info
		Function HLength returns the length of a line.
	'''
	pass
	return 'REAL' # 


def HMove(
		h      , # HANDLE - Handle to object. 
		xOffset, # REAL   - X offset distance.
		yOffset  # REAL   - Y offset distance.
		):
	'''
		Python: vs.HMove(h, xOffset, yOffset)
		VectorScript: PROCEDURE HMove(h:HANDLE; xOffset:REAL; yOffset:REAL);
		
		Category: Object Editing
		Procedure HMove moves the referenced object a relative offset distance.
	'''
	pass


def HMoveBackward(
		h     , # HANDLE  - Handle to object.              
		toBack  # BOOLEAN - Move to back of stacking order.
		):
	'''
		Python: vs.HMoveBackward(h, toBack)
		VectorScript: PROCEDURE HMoveBackward(h:HANDLE; toBack:BOOLEAN);
		
		Category: Object Editing
		Move the referenced object backward in the object stacking order. If toBack is TRUE, the object will be moved to the back of the stacking order.
	'''
	pass


def HMoveForward(
		h      , # HANDLE  - Handle to object.                      
		toFront  # BOOLEAN - Move object to front of stacking order.
		):
	'''
		Python: vs.HMoveForward(h, toFront)
		VectorScript: PROCEDURE HMoveForward(h:HANDLE; toFront:BOOLEAN);
		
		Category: Object Editing
		Move the referenced object forward in the object stacking order. If toFront is TRUE, the object will be moved to the front of the stacking order.
	'''
	pass


def HO_GetHoistColorLbl(
		value   , # REAL -  
		maxValue  # REAL -  
		):
	'''
		Python: (BOOLEAN, colorIndex) = vs.HO_GetHoistColorLbl(value, maxValue)
		VectorScript: FUNCTION HO_GetHoistColorLbl(value:REAL; maxValue:REAL; VAR colorIndex:INTEGER) : BOOLEAN;
		
		Category: Spotlight
		Get the color index of the hoist lable for truss analysis.
	'''
	pass
	return ( False  , # 
	         0       )


def HO_GetHoistOriginAt(
		index  # LONGINT -  
		):
	'''
		Python: STRING = vs.HO_GetHoistOriginAt(index)
		VectorScript: FUNCTION HO_GetHoistOriginAt(index:LONGINT) : STRING;
		
		Category: Spotlight
		Get the name of the Hoist Origin at the given position.
	'''
	pass
	return 'STRING' # 


def HO_GetNumHoistOrigin():
	'''
		Python: LONGINT = vs.HO_GetNumHoistOrigin()
		VectorScript: FUNCTION HO_GetNumHoistOrigin : LONGINT;
		
		Category: Spotlight
		Get the number of all Hoist Origin objects in the current document
	'''
	pass
	return 'LONGINT' # 


def HP_AutoAttachLoads(
		positionHandle  # HANDLE -  
		):
	'''
		Python: vs.HP_AutoAttachLoads(positionHandle)
		VectorScript: PROCEDURE HP_AutoAttachLoads(positionHandle:HANDLE);
		
		Category: Truss Analysis
		Using the given position handle, attaches all loads, that can be calculated as a part of the system.
	'''
	pass


def HP_ConvertToHangPos():
	'''
		Python: vs.HP_ConvertToHangPos()
		VectorScript: PROCEDURE HP_ConvertToHangPos;
		
		Category: Truss Analysis
		Invkoes the Convert To Hanging Position menu command on the systems of the selected objects.
	'''
	pass


def HPerim(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: REAL = vs.HPerim(h)
		VectorScript: FUNCTION HPerim(h:HANDLE) : REAL;
		
		Category: Object Info
		Function HPerim returns the perimeter of the referenced object.
	'''
	pass
	return 'REAL' # 


def HPerimN(
		ObjectHandle  # HANDLE -  
		):
	'''
		Python: REAL = vs.HPerimN(ObjectHandle)
		VectorScript: FUNCTION HPerimN(ObjectHandle:HANDLE) : REAL;
		
		Category: Object Info
		Calculate a perimeter of an object. Same as HPerim(), but it gives more accurate result when the object is a polyline.
	'''
	pass
	return 'REAL' # 


def HRotate(
		h            , # HANDLE - Handle to object.                           
		center       , # POINT  - X-Y coordinates of center point of rotation.
		rotationAngle  # REAL   - Angle of rotation.                          
		):
	'''
		Python: vs.HRotate(h, center, rotationAngle)
		VectorScript: PROCEDURE HRotate(h:HANDLE; centerX, centerY:REAL; rotationAngle:REAL);
		
		Category: Object Editing
		Procedure HRotate rotates the referenced object about a coordinate point location. rotationAngle is in degrees.
	'''
	pass


def HScale2D(
		h        , # HANDLE  -  
		centerX  , # REAL    -  
		centerY  , # REAL    -  
		scaleX   , # REAL    -  
		scaleY   , # REAL    -  
		scaleText  # BOOLEAN -  
		):
	'''
		Python: vs.HScale2D(h, centerX, centerY, scaleX, scaleY, scaleText)
		VectorScript: PROCEDURE HScale2D(h:HANDLE; centerX:REAL; centerY:REAL; scaleX:REAL; scaleY:REAL; scaleText:BOOLEAN);
		
		Category: Object Editing
		Scales a 2D object.
	'''
	pass


def HScale3D(
		h      , # HANDLE -  
		centerX, # REAL   -  
		centerY, # REAL   -  
		centerZ, # REAL   -  
		scaleX , # REAL   -  
		scaleY , # REAL   -  
		scaleZ   # REAL   -  
		):
	'''
		Python: vs.HScale3D(h, centerX, centerY, centerZ, scaleX, scaleY, scaleZ)
		VectorScript: PROCEDURE HScale3D(h:HANDLE; centerX:REAL; centerY:REAL; centerZ:REAL; scaleX:REAL; scaleY:REAL; scaleZ:REAL);
		
		Category: Object Editing
		Scales a 3D object.
	'''
	pass


def HSetLayerTransp(
		hLayer      , # HANDLE - Handle to the layer.                                       
		transparency  # REAL   - The transparency for the layer. Value between 0.0 and 100.0
		):
	'''
		Python: vs.HSetLayerTransp(hLayer, transparency)
		VectorScript: PROCEDURE HSetLayerTransp(hLayer:HANDLE; transparency:REAL);
		
		Category: Layers
		Set the transparency of the specified layer.
	'''
	pass


def HUngroup(
		h  # HANDLE - Handle to group.
		):
	'''
		Python: vs.HUngroup(h)
		VectorScript: PROCEDURE HUngroup(h:HANDLE);
		
		Category: Objects - Groups
		Decomposes the referenced group into component objects.
	'''
	pass


def HWallHeight(
		wallHd             , # HANDLE            - Handle to wall.          
		startHeightDistance, # REAL (Coordinate) - New start height of wall.
		endHeightDistance    # REAL (Coordinate) - New end height of wall.  
		):
	'''
		Python: vs.HWallHeight(wallHd, startHeightDistance, endHeightDistance)
		VectorScript: PROCEDURE HWallHeight(wallHd:HANDLE; startHeightDistance:REAL (Coordinate); endHeightDistance:REAL (Coordinate));
		
		Category: Objects - Walls
		Procedure HWallHeight sets the wall heights of the referenced wall object.
	'''
	pass


def HWallWidth(
		wallHd       , # HANDLE            - Handle to wall.
		widthDistance  # REAL (Coordinate) - New wall width.
		):
	'''
		Python: vs.HWallWidth(wallHd, widthDistance)
		VectorScript: PROCEDURE HWallWidth(wallHd:HANDLE; widthDistance:REAL (Coordinate));
		
		Category: Objects - Walls
		Procedure HWallWidth sets the wall width of the referenced wall object.
	'''
	pass


def HWidth(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: REAL = vs.HWidth(h)
		VectorScript: FUNCTION HWidth(h:HANDLE) : REAL;
		
		Category: Object Info
		Function HWidth returns the width of the referenced object.
	'''
	pass
	return 'REAL' # 


def IFC_AttachPset(
		hObject      , # HANDLE -  
		inStrPsetName  # STRING -  
		):
	'''
		Python: BOOLEAN = vs.IFC_AttachPset(hObject, inStrPsetName)
		VectorScript: FUNCTION IFC_AttachPset(hObject:HANDLE; inStrPsetName:STRING) : BOOLEAN;
		
		Category: IFC
		Attaches a property set to the object
	'''
	pass
	return 'BOOLEAN' # 


def IFC_ClearAllPsets(
		hObject  # HANDLE -  
		):
	'''
		Python: BOOLEAN = vs.IFC_ClearAllPsets(hObject)
		VectorScript: FUNCTION IFC_ClearAllPsets(hObject:HANDLE) : BOOLEAN;
		
		Category: IFC
		Removes all IFC Psets
	'''
	pass
	return 'BOOLEAN' # 


def IFC_ClearIFCInfo(
		hObject  # HANDLE -  
		):
	'''
		Python: BOOLEAN = vs.IFC_ClearIFCInfo(hObject)
		VectorScript: FUNCTION IFC_ClearIFCInfo(hObject:HANDLE) : BOOLEAN;
		
		Category: IFC
		Removes all IFC data
	'''
	pass
	return 'BOOLEAN' # 


def IFC_ClearPset(
		hObject      , # HANDLE -  
		inStrPsetName  # STRING -  
		):
	'''
		Python: BOOLEAN = vs.IFC_ClearPset(hObject, inStrPsetName)
		VectorScript: FUNCTION IFC_ClearPset(hObject:HANDLE; inStrPsetName:STRING) : BOOLEAN;
		
		Category: IFC
		Removes a property set from the object
	'''
	pass
	return 'BOOLEAN' # 


def IFC_CopyIFCData(
		hSource     , # HANDLE  -  
		hDestination, # HANDLE  -  
		inMode        # INTEGER -  
		):
	'''
		Python: BOOLEAN = vs.IFC_CopyIFCData(hSource, hDestination, inMode)
		VectorScript: FUNCTION IFC_CopyIFCData(hSource:HANDLE; hDestination:HANDLE; inMode:INTEGER) : BOOLEAN;
		
		Category: IFC
		Copies IFC data from one object to another
	'''
	pass
	return 'BOOLEAN' # 


def IFC_CreateObjGUID(
		hObject  # HANDLE -  
		):
	'''
		Python: BOOLEAN = vs.IFC_CreateObjGUID(hObject)
		VectorScript: FUNCTION IFC_CreateObjGUID(hObject:HANDLE) : BOOLEAN;
		
		Category: IFC
		Create a Tag record for the specified object if it doesn't have any IFC info.
	'''
	pass
	return 'BOOLEAN' # 


def IFC_DefPsetAddMember(
		psetName, # STRING -  
		propName, # STRING -  
		propType  # STRING -  
		):
	'''
		Python: BOOLEAN = vs.IFC_DefPsetAddMember(psetName, propName, propType)
		VectorScript: FUNCTION IFC_DefPsetAddMember(psetName:STRING; propName:STRING; propType:STRING) : BOOLEAN;
		
		Category: IFC
		Adds a new member to the currently defined Custom Object Preset.
	'''
	pass
	return 'BOOLEAN' # 


def IFC_DefPsetBegin(
		psetName  # STRING -  
		):
	'''
		Python: BOOLEAN = vs.IFC_DefPsetBegin(psetName)
		VectorScript: FUNCTION IFC_DefPsetBegin(psetName:STRING) : BOOLEAN;
		
		Category: IFC
		Marks the beginning of creation of a new Custom Object Preset.
	'''
	pass
	return 'BOOLEAN' # 


def IFC_DefPsetEnd(
		psetName  # STRING -  
		):
	'''
		Python: BOOLEAN = vs.IFC_DefPsetEnd(psetName)
		VectorScript: FUNCTION IFC_DefPsetEnd(psetName:STRING) : BOOLEAN;
		
		Category: IFC
		Marks the end of creation of a new Custom Object Preset.
	'''
	pass
	return 'BOOLEAN' # 


def IFC_DefPsetImport(
		strFilePath  # STRING -  
		):
	'''
		Python: BOOLEAN = vs.IFC_DefPsetImport(strFilePath)
		VectorScript: FUNCTION IFC_DefPsetImport(strFilePath:STRING) : BOOLEAN;
		
		Category: IFC
		Imports Custom Object Presets from XML or text file.
	'''
	pass
	return 'BOOLEAN' # 


def IFC_DeleteIFCInfo(
		hObject, # HANDLE  -  
		bDoUndo  # BOOLEAN -  
		):
	'''
		Python: BOOLEAN = vs.IFC_DeleteIFCInfo(hObject, bDoUndo)
		VectorScript: FUNCTION IFC_DeleteIFCInfo(hObject:HANDLE; bDoUndo:BOOLEAN) : BOOLEAN;
		
		Category: IFC
		Removes all IFC data
	'''
	pass
	return 'BOOLEAN' # 


def IFC_DMAddEntry(
		inStrObjName  , # STRING  -  
		inStrEntryName, # STRING  -  
		bEnable         # BOOLEAN -  
		):
	'''
		Python: BOOLEAN = vs.IFC_DMAddEntry(inStrObjName, inStrEntryName, bEnable)
		VectorScript: FUNCTION IFC_DMAddEntry(inStrObjName:STRING; inStrEntryName:STRING; bEnable:BOOLEAN) : BOOLEAN;
		
		Category: IFC
		Adds an entry to indicated object from current IFC Data Mapping.
	'''
	pass
	return 'BOOLEAN' # 


def IFC_DMAddField(
		inStrObjName  , # STRING  -  
		inStrEntryName, # STRING  -  
		inStrFieldName, # STRING  -  
		type          , # INTEGER -  
		bOptional     , # BOOLEAN -  
		bEnable       , # BOOLEAN -  
		bEmpty          # BOOLEAN -  
		):
	'''
		Python: BOOLEAN = vs.IFC_DMAddField(inStrObjName, inStrEntryName, inStrFieldName, type, bOptional, bEnable, bEmpty)
		VectorScript: FUNCTION IFC_DMAddField(inStrObjName:STRING; inStrEntryName:STRING; inStrFieldName:STRING; type:INTEGER; bOptional:BOOLEAN; bEnable:BOOLEAN; bEmpty:BOOLEAN) : BOOLEAN;
		
		Category: IFC
		Adds a field to current IFC Data Mapping.
	'''
	pass
	return 'BOOLEAN' # 


def IFC_DMDeleteEntry(
		inStrObjName  , # STRING -  
		inStrEntryName  # STRING -  
		):
	'''
		Python: BOOLEAN = vs.IFC_DMDeleteEntry(inStrObjName, inStrEntryName)
		VectorScript: FUNCTION IFC_DMDeleteEntry(inStrObjName:STRING; inStrEntryName:STRING) : BOOLEAN;
		
		Category: IFC
		Deletes an entry from indicated object, from current IFC Data Mapping.
	'''
	pass
	return 'BOOLEAN' # 


def IFC_DMDeleteField(
		inStrObjName  , # STRING -  
		inStrEntryName, # STRING -  
		inStrFieldName  # STRING -  
		):
	'''
		Python: BOOLEAN = vs.IFC_DMDeleteField(inStrObjName, inStrEntryName, inStrFieldName)
		VectorScript: FUNCTION IFC_DMDeleteField(inStrObjName:STRING; inStrEntryName:STRING; inStrFieldName:STRING) : BOOLEAN;
		
		Category: IFC
		Deletes a field from current IFC Data Mapping.
	'''
	pass
	return 'BOOLEAN' # 


def IFC_DMEnableEntry(
		inStrObjName  , # STRING  -  
		inStrEntryName, # STRING  -  
		bEnable         # BOOLEAN -  
		):
	'''
		Python: BOOLEAN = vs.IFC_DMEnableEntry(inStrObjName, inStrEntryName, bEnable)
		VectorScript: FUNCTION IFC_DMEnableEntry(inStrObjName:STRING; inStrEntryName:STRING; bEnable:BOOLEAN) : BOOLEAN;
		
		Category: IFC
		Enables/Disables indicated entry from current IFC Data Mapping is enabled.
	'''
	pass
	return 'BOOLEAN' # 


def IFC_DMEnableObject(
		inStrObjName, # STRING  -  
		bEnable       # BOOLEAN -  
		):
	'''
		Python: BOOLEAN = vs.IFC_DMEnableObject(inStrObjName, bEnable)
		VectorScript: FUNCTION IFC_DMEnableObject(inStrObjName:STRING; bEnable:BOOLEAN) : BOOLEAN;
		
		Category: IFC
		Enables/Disables the indicated object from current IFC Data Mapping.
	'''
	pass
	return 'BOOLEAN' # 


def IFC_DMGetEntriesCnt(
		inStrObjName  # STRING -  
		):
	'''
		Python: (BOOLEAN, outCount) = vs.IFC_DMGetEntriesCnt(inStrObjName)
		VectorScript: FUNCTION IFC_DMGetEntriesCnt(inStrObjName:STRING; VAR outCount:INTEGER) : BOOLEAN;
		
		Category: IFC
		Gets the count of entries for indicated object from current IFC Data Mapping.
	'''
	pass
	return ( False  , # 
	         0       )


def IFC_DMGetEntryName(
		index       , # INTEGER -  
		inStrObjName  # STRING  -  
		):
	'''
		Python: (BOOLEAN, outStrResult) = vs.IFC_DMGetEntryName(index, inStrObjName)
		VectorScript: FUNCTION IFC_DMGetEntryName(index:INTEGER; inStrObjName:STRING; VAR outStrResult:STRING) : BOOLEAN;
		
		Category: IFC
		Gets the name of entry for indicated index from current IFC Data Mapping.
	'''
	pass
	return ( False   , # 
	         'string' )


def IFC_DMGetFieldMap(
		inStrObjName  , # STRING -  
		inStrEntryName, # STRING -  
		inStrFieldName  # STRING -  
		):
	'''
		Python: (BOOLEAN, outStrResult) = vs.IFC_DMGetFieldMap(inStrObjName, inStrEntryName, inStrFieldName)
		VectorScript: FUNCTION IFC_DMGetFieldMap(inStrObjName:STRING; inStrEntryName:STRING; inStrFieldName:STRING; VAR outStrResult:STRING) : BOOLEAN;
		
		Category: IFC
		Gets indicated field mapping source from current IFC Data Mapping.
	'''
	pass
	return ( False   , # 
	         'string' )


def IFC_DMGetFieldName(
		inStrObjName  , # STRING  -  
		inStrEntryName, # STRING  -  
		index           # INTEGER -  
		):
	'''
		Python: (BOOLEAN, outStrFieldName) = vs.IFC_DMGetFieldName(inStrObjName, inStrEntryName, index)
		VectorScript: FUNCTION IFC_DMGetFieldName(inStrObjName:STRING; inStrEntryName:STRING; index:INTEGER; VAR outStrFieldName:STRING) : BOOLEAN;
		
		Category: IFC
		Gets indicated field name from current IFC Data Mapping.
	'''
	pass
	return ( False   , # 
	         'string' )


def IFC_DMGetFieldsCount(
		inStrObjName  , # STRING -  
		inStrEntryName  # STRING -  
		):
	'''
		Python: (BOOLEAN, outCount) = vs.IFC_DMGetFieldsCount(inStrObjName, inStrEntryName)
		VectorScript: FUNCTION IFC_DMGetFieldsCount(inStrObjName:STRING; inStrEntryName:STRING; VAR outCount:INTEGER) : BOOLEAN;
		
		Category: IFC
		Gets fields count for indicated entry from current IFC Data Mapping.
	'''
	pass
	return ( False  , # 
	         0       )


def IFC_DMGetFieldType(
		inStrObjName  , # STRING -  
		inStrEntryName, # STRING -  
		inStrFieldName  # STRING -  
		):
	'''
		Python: (BOOLEAN, outType) = vs.IFC_DMGetFieldType(inStrObjName, inStrEntryName, inStrFieldName)
		VectorScript: FUNCTION IFC_DMGetFieldType(inStrObjName:STRING; inStrEntryName:STRING; inStrFieldName:STRING; VAR outType:INTEGER) : BOOLEAN;
		
		Category: IFC
		Gets indicated field type from current IFC Data Mapping.
	'''
	pass
	return ( False  , # 
	         0       )


def IFC_DMIsEntryEnabled(
		inStrObjName  , # STRING -  
		inStrEntryName  # STRING -  
		):
	'''
		Python: BOOLEAN = vs.IFC_DMIsEntryEnabled(inStrObjName, inStrEntryName)
		VectorScript: FUNCTION IFC_DMIsEntryEnabled(inStrObjName:STRING; inStrEntryName:STRING) : BOOLEAN;
		
		Category: IFC
		Checks if the indicated entry from current IFC Data Mapping is enabled.
	'''
	pass
	return 'BOOLEAN' # 


def IFC_DMIsFieldEmpty(
		inStrObjName  , # STRING -  
		inStrEntryName, # STRING -  
		inStrFieldName  # STRING -  
		):
	'''
		Python: BOOLEAN = vs.IFC_DMIsFieldEmpty(inStrObjName, inStrEntryName, inStrFieldName)
		VectorScript: FUNCTION IFC_DMIsFieldEmpty(inStrObjName:STRING; inStrEntryName:STRING; inStrFieldName:STRING) : BOOLEAN;
		
		Category: IFC
		Checks if the indicated field, from current IFC Data Mapping, is empty.
	'''
	pass
	return 'BOOLEAN' # 


def IFC_DMIsFieldEnabled(
		inStrObjName  , # STRING -  
		inStrEntryName, # STRING -  
		inStrFieldName  # STRING -  
		):
	'''
		Python: BOOLEAN = vs.IFC_DMIsFieldEnabled(inStrObjName, inStrEntryName, inStrFieldName)
		VectorScript: FUNCTION IFC_DMIsFieldEnabled(inStrObjName:STRING; inStrEntryName:STRING; inStrFieldName:STRING) : BOOLEAN;
		
		Category: IFC
		Checks if the indicated field, from current IFC Data Mapping, is enabled.
	'''
	pass
	return 'BOOLEAN' # 


def IFC_DMIsFieldOpt(
		inStrObjName  , # STRING -  
		inStrEntryName, # STRING -  
		inStrFieldName  # STRING -  
		):
	'''
		Python: BOOLEAN = vs.IFC_DMIsFieldOpt(inStrObjName, inStrEntryName, inStrFieldName)
		VectorScript: FUNCTION IFC_DMIsFieldOpt(inStrObjName:STRING; inStrEntryName:STRING; inStrFieldName:STRING) : BOOLEAN;
		
		Category: IFC
		Checks if the indicated field, from current IFC Data Mapping,  is optional.
	'''
	pass
	return 'BOOLEAN' # 


def IFC_DMIsObjEnabled(
		inStrObjName  # STRING -  
		):
	'''
		Python: BOOLEAN = vs.IFC_DMIsObjEnabled(inStrObjName)
		VectorScript: FUNCTION IFC_DMIsObjEnabled(inStrObjName:STRING) : BOOLEAN;
		
		Category: IFC
		Checks if the indicated object from the current IFC Data Mapping is enabled.
	'''
	pass
	return 'BOOLEAN' # 


def IFC_DMLoadSettings(
		inStrParam  # STRING -  
		):
	'''
		Python: BOOLEAN = vs.IFC_DMLoadSettings(inStrParam)
		VectorScript: FUNCTION IFC_DMLoadSettings(inStrParam:STRING) : BOOLEAN;
		
		Category: IFC
		Loads the indicated IFC Data Mapping.
	'''
	pass
	return 'BOOLEAN' # 


def IFC_DMResetToDef():
	'''
		Python: BOOLEAN = vs.IFC_DMResetToDef()
		VectorScript: FUNCTION IFC_DMResetToDef : BOOLEAN;
		
		Category: IFC
		Resets the IFC Data Mapping to Vectorworks Defaults.
	'''
	pass
	return 'BOOLEAN' # 


def IFC_DMSaveSettings(
		inStrParam   , # STRING  -  
		inObjName    , # STRING  -  
		bFileSettings  # BOOLEAN -  
		):
	'''
		Python: BOOLEAN = vs.IFC_DMSaveSettings(inStrParam, inObjName, bFileSettings)
		VectorScript: FUNCTION IFC_DMSaveSettings(inStrParam:STRING; inObjName:STRING; bFileSettings:BOOLEAN) : BOOLEAN;
		
		Category: IFC
		Saves the IFC Data Mapping.
	'''
	pass
	return 'BOOLEAN' # 


def IFC_DMSetFieldEmpty(
		inStrObjName  , # STRING  -  
		inStrEntryName, # STRING  -  
		inStrFieldName, # STRING  -  
		bEmpty          # BOOLEAN -  
		):
	'''
		Python: BOOLEAN = vs.IFC_DMSetFieldEmpty(inStrObjName, inStrEntryName, inStrFieldName, bEmpty)
		VectorScript: FUNCTION IFC_DMSetFieldEmpty(inStrObjName:STRING; inStrEntryName:STRING; inStrFieldName:STRING; bEmpty:BOOLEAN) : BOOLEAN;
		
		Category: IFC
		Sets the indicated field empty.
	'''
	pass
	return 'BOOLEAN' # 


def IFC_DMSetFieldEnable(
		inStrObjName  , # STRING  -  
		inStrEntryName, # STRING  -  
		inStrFieldName, # STRING  -  
		bEnable         # BOOLEAN -  
		):
	'''
		Python: BOOLEAN = vs.IFC_DMSetFieldEnable(inStrObjName, inStrEntryName, inStrFieldName, bEnable)
		VectorScript: FUNCTION IFC_DMSetFieldEnable(inStrObjName:STRING; inStrEntryName:STRING; inStrFieldName:STRING; bEnable:BOOLEAN) : BOOLEAN;
		
		Category: IFC
		Sets the indicated field enabled.
	'''
	pass
	return 'BOOLEAN' # 


def IFC_DMSetFieldMap(
		inStrObjName  , # STRING -  
		inStrEntryName, # STRING -  
		inStrFieldName, # STRING -  
		strMappingSrc   # STRING -  
		):
	'''
		Python: BOOLEAN = vs.IFC_DMSetFieldMap(inStrObjName, inStrEntryName, inStrFieldName, strMappingSrc)
		VectorScript: FUNCTION IFC_DMSetFieldMap(inStrObjName:STRING; inStrEntryName:STRING; inStrFieldName:STRING; strMappingSrc:STRING) : BOOLEAN;
		
		Category: IFC
		Sets indicated field mapping source from current IFC Data Mapping.
	'''
	pass
	return 'BOOLEAN' # 


def IFC_DMSetFieldOpt(
		inStrObjName  , # STRING  -  
		inStrEntryName, # STRING  -  
		inStrFieldName, # STRING  -  
		bOptional       # BOOLEAN -  
		):
	'''
		Python: BOOLEAN = vs.IFC_DMSetFieldOpt(inStrObjName, inStrEntryName, inStrFieldName, bOptional)
		VectorScript: FUNCTION IFC_DMSetFieldOpt(inStrObjName:STRING; inStrEntryName:STRING; inStrFieldName:STRING; bOptional:BOOLEAN) : BOOLEAN;
		
		Category: IFC
		Sets the indicated field optional.
	'''
	pass
	return 'BOOLEAN' # 


def IFC_DMSetFieldType(
		inStrObjName  , # STRING  -  
		inStrEntryName, # STRING  -  
		inStrFieldName, # STRING  -  
		type            # INTEGER -  
		):
	'''
		Python: BOOLEAN = vs.IFC_DMSetFieldType(inStrObjName, inStrEntryName, inStrFieldName, type)
		VectorScript: FUNCTION IFC_DMSetFieldType(inStrObjName:STRING; inStrEntryName:STRING; inStrFieldName:STRING; type:INTEGER) : BOOLEAN;
		
		Category: IFC
		Sets indicated field type from current IFC Data Mapping.
	'''
	pass
	return 'BOOLEAN' # 


def IFC_ExportWithUI(
		bExpSingleObj  # BOOLEAN -  
		):
	'''
		Python: vs.IFC_ExportWithUI(bExpSingleObj)
		VectorScript: PROCEDURE IFC_ExportWithUI(bExpSingleObj:BOOLEAN);
		
		Category: IFC
		Exports IFC file, showing Export IFC Project dialog
	'''
	pass


def IFC_GetEntityColor(
		inStrIfcType  # STRING -  
		):
	'''
		Python: (BOOLEAN, outRed, outGreen, outBlue, outTransp) = vs.IFC_GetEntityColor(inStrIfcType)
		VectorScript: FUNCTION IFC_GetEntityColor(inStrIfcType:STRING; VAR outRed:INTEGER; VAR outGreen:INTEGER; VAR outBlue:INTEGER; VAR outTransp:INTEGER) : BOOLEAN;
		
		Category: IFC
		Gets the default color for an IFC entity type
	'''
	pass
	return ( False  , # 
	         0      , 
	         0      , 
	         0      , 
	         0       )


def IFC_GetEntityProp(
		hObject      , # HANDLE -  
		inStrPropName  # STRING -  
		):
	'''
		Python: (BOOLEAN, outStrPropValue, outTypeSelect) = vs.IFC_GetEntityProp(hObject, inStrPropName)
		VectorScript: FUNCTION IFC_GetEntityProp(hObject:HANDLE; inStrPropName:STRING; VAR outStrPropValue:STRING; VAR outTypeSelect:INTEGER) : BOOLEAN;
		
		Category: IFC
		Gets the value and type of a selected property from the IFC entity
	'''
	pass
	return ( False   , # 
	         'string', 
	         0        )


def IFC_GetEntityProp2(
		hObject     , # HANDLE -  
		propertyName  # STRING -  
		):
	'''
		Python: (BOOLEAN, outPropValue, outType, outMap) = vs.IFC_GetEntityProp2(hObject, propertyName)
		VectorScript: FUNCTION IFC_GetEntityProp2(hObject:HANDLE; propertyName:STRING; VAR outPropValue:STRING; VAR outType:INTEGER; VAR outMap:INTEGER) : BOOLEAN;
		
		Category: IFC
		Gets the property value, its type and if the value comes from mapping or by instance.
	'''
	pass
	return ( False   , # 
	         'string', 
	         0       , 
	         0        )


def IFC_GetIFCEntity(
		hObject  # HANDLE -  
		):
	'''
		Python: (BOOLEAN, outStrName) = vs.IFC_GetIFCEntity(hObject)
		VectorScript: FUNCTION IFC_GetIFCEntity(hObject:HANDLE; VAR outStrName:STRING) : BOOLEAN;
		
		Category: IFC
		Gets IFC entity type
	'''
	pass
	return ( False   , # 
	         'string' )


def IFC_GetIFCEntity2(
		hObject  # HANDLE -  
		):
	'''
		Python: (BOOLEAN, outType, outStrNameRec, outStrNameMap) = vs.IFC_GetIFCEntity2(hObject)
		VectorScript: FUNCTION IFC_GetIFCEntity2(hObject:HANDLE; VAR outType:INTEGER; VAR outStrNameRec:STRING; VAR outStrNameMap:STRING) : BOOLEAN;
		
		Category: IFC
		Gets the IFC entity type for an object by IFC record and IFC Data Mapping plus the type of the IFC record
	'''
	pass
	return ( False   , # 
	         0       , 
	         'string', 
	         'string' )


def IFC_GetIFCScheme(
		):
	'''
		Python: (BOOLEAN, outScheme) = vs.IFC_GetIFCScheme()
		VectorScript: FUNCTION IFC_GetIFCScheme(VAR outScheme:INTEGER) : BOOLEAN;
		
		Category: IFC
		Gets the active IFC version
	'''
	pass
	return ( False  , # 
	         0       )


def IFC_GetNumPsets(
		hObject  # HANDLE -  
		):
	'''
		Python: (BOOLEAN, outNumPsets) = vs.IFC_GetNumPsets(hObject)
		VectorScript: FUNCTION IFC_GetNumPsets(hObject:HANDLE; VAR outNumPsets:INTEGER) : BOOLEAN;
		
		Category: IFC
		Gets the number of property sets, attached to the object
	'''
	pass
	return ( False  , # 
	         0       )


def IFC_GetNumPsets2(
		hObject  , # HANDLE  -  
		bAllPsets  # BOOLEAN -  
		):
	'''
		Python: (BOOLEAN, outNumPsets) = vs.IFC_GetNumPsets2(hObject, bAllPsets)
		VectorScript: FUNCTION IFC_GetNumPsets2(hObject:HANDLE; bAllPsets:BOOLEAN; VAR outNumPsets:INTEGER) : BOOLEAN;
		
		Category: IFC
		Returns the number of psets for the specified ifc type.
	'''
	pass
	return ( False  , # 
	         0       )


def IFC_GetPsetInfoAt(
		hObject  , # HANDLE  -  
		bAllPsets, # BOOLEAN -  
		index      # INTEGER -  
		):
	'''
		Python: (BOOLEAN, outIfcPsetName, outType) = vs.IFC_GetPsetInfoAt(hObject, bAllPsets, index)
		VectorScript: FUNCTION IFC_GetPsetInfoAt(hObject:HANDLE; bAllPsets:BOOLEAN; index:INTEGER; VAR outIfcPsetName:STRING; VAR outType:INTEGER) : BOOLEAN;
		
		Category: IFC
		Gets the Pset name and if it is attached and where from (if it is from mapping or from record).
	'''
	pass
	return ( False   , # 
	         'string', 
	         0        )


def IFC_GetPsetName(
		hObject    , # HANDLE  -  
		inPsetIndex  # INTEGER -  
		):
	'''
		Python: (BOOLEAN, outStrPsetName) = vs.IFC_GetPsetName(hObject, inPsetIndex)
		VectorScript: FUNCTION IFC_GetPsetName(hObject:HANDLE; inPsetIndex:INTEGER; VAR outStrPsetName:STRING) : BOOLEAN;
		
		Category: IFC
		Gets the name of the property set at that index
	'''
	pass
	return ( False   , # 
	         'string' )


def IFC_GetPsetProp(
		hObject      , # HANDLE -  
		inStrPsetName, # STRING -  
		inStrPropName  # STRING -  
		):
	'''
		Python: (BOOLEAN, outStrPropValue, outTypeSelect) = vs.IFC_GetPsetProp(hObject, inStrPsetName, inStrPropName)
		VectorScript: FUNCTION IFC_GetPsetProp(hObject:HANDLE; inStrPsetName:STRING; inStrPropName:STRING; VAR outStrPropValue:STRING; VAR outTypeSelect:INTEGER) : BOOLEAN;
		
		Category: IFC
		Gets the value and type of a selected property from a property set
	'''
	pass
	return ( False   , # 
	         'string', 
	         0        )


def IFC_GetPsetProp2(
		hObject     , # HANDLE -  
		pSetName    , # STRING -  
		propertyName  # STRING -  
		):
	'''
		Python: (BOOLEAN, outPropValue, outType, outMap) = vs.IFC_GetPsetProp2(hObject, pSetName, propertyName)
		VectorScript: FUNCTION IFC_GetPsetProp2(hObject:HANDLE; pSetName:STRING; propertyName:STRING; VAR outPropValue:STRING; VAR outType:INTEGER; VAR outMap:INTEGER) : BOOLEAN;
		
		Category: IFC
		Gets the property value, its type and if the value comes from mapping or by instance.
	'''
	pass
	return ( False   , # 
	         'string', 
	         0       , 
	         0        )


def IFC_GetSpaceParamFO(
		hSpace    , # HANDLE -  
		inStrParam  # STRING -  
		):
	'''
		Python: (BOOLEAN, outStrResult) = vs.IFC_GetSpaceParamFO(hSpace, inStrParam)
		VectorScript: FUNCTION IFC_GetSpaceParamFO(hSpace:HANDLE; inStrParam:STRING; VAR outStrResult:STRING) : BOOLEAN;
		
		Category: IFC
		Gets the space type, name or number
	'''
	pass
	return ( False   , # 
	         'string' )


def IFC_ImportLibrary(
		strFilePath   , # STRING  -  
		bKeepHierarchy  # BOOLEAN -  
		):
	'''
		Python: BOOLEAN = vs.IFC_ImportLibrary(strFilePath, bKeepHierarchy)
		VectorScript: FUNCTION IFC_ImportLibrary(strFilePath:STRING; bKeepHierarchy:BOOLEAN) : BOOLEAN;
		
		Category: IFC
		Imports IFC Library of objects
	'''
	pass
	return 'BOOLEAN' # 


def IFC_ImportNoUI(
		strFilePath  # STRING -  
		):
	'''
		Python: vs.IFC_ImportNoUI(strFilePath)
		VectorScript: PROCEDURE IFC_ImportNoUI(strFilePath:STRING);
		
		Category: IFC
		Imports IFC file, silent mode
	'''
	pass


def IFC_ImportWithUI():
	'''
		Python: vs.IFC_ImportWithUI()
		VectorScript: PROCEDURE IFC_ImportWithUI;
		
		Category: IFC
		Imports IFC file with user interface
	'''
	pass


def IFC_IsPsetCustom(
		pSetName  # STRING -  
		):
	'''
		Python: (BOOLEAN, bCustom) = vs.IFC_IsPsetCustom(pSetName)
		VectorScript: FUNCTION IFC_IsPsetCustom(pSetName:STRING; VAR bCustom:BOOLEAN) : BOOLEAN;
		
		Category: IFC
		Check if Pset is custom.
	'''
	pass
	return ( False  , # 
	         False   )


def IFC_IsPsetDefined(
		strPsetName  # STRING -  
		):
	'''
		Python: BOOLEAN = vs.IFC_IsPsetDefined(strPsetName)
		VectorScript: FUNCTION IFC_IsPsetDefined(strPsetName:STRING) : BOOLEAN;
		
		Category: IFC
		Check if the custom Pset exists
	'''
	pass
	return 'BOOLEAN' # 


def IFC_SetEntityColor(
		inStrIfcType, # STRING  -  
		inRed       , # INTEGER -  
		inGreen     , # INTEGER -  
		inBlue      , # INTEGER -  
		inTransp      # INTEGER -  
		):
	'''
		Python: BOOLEAN = vs.IFC_SetEntityColor(inStrIfcType, inRed, inGreen, inBlue, inTransp)
		VectorScript: FUNCTION IFC_SetEntityColor(inStrIfcType:STRING; inRed:INTEGER; inGreen:INTEGER; inBlue:INTEGER; inTransp:INTEGER) : BOOLEAN;
		
		Category: IFC
		Sets the default color for an IFC entity type
	'''
	pass
	return 'BOOLEAN' # 


def IFC_SetEntityProp(
		hObject       , # HANDLE -  
		inStrPropName , # STRING -  
		inStrPropValue  # STRING -  
		):
	'''
		Python: BOOLEAN = vs.IFC_SetEntityProp(hObject, inStrPropName, inStrPropValue)
		VectorScript: FUNCTION IFC_SetEntityProp(hObject:HANDLE; inStrPropName:STRING; inStrPropValue:STRING) : BOOLEAN;
		
		Category: IFC
		Sets the value of a selected property from the IFC entity
	'''
	pass
	return 'BOOLEAN' # 


def IFC_SetIFCEntity(
		hObject     , # HANDLE -  
		inStrIfcName  # STRING -  
		):
	'''
		Python: BOOLEAN = vs.IFC_SetIFCEntity(hObject, inStrIfcName)
		VectorScript: FUNCTION IFC_SetIFCEntity(hObject:HANDLE; inStrIfcName:STRING) : BOOLEAN;
		
		Category: IFC
		Sets IFC entity type
	'''
	pass
	return 'BOOLEAN' # 


def IFC_SetIFCEntity2(
		hObject     , # HANDLE -  
		inStrIfcType  # STRING -  
		):
	'''
		Python: BOOLEAN = vs.IFC_SetIFCEntity2(hObject, inStrIfcType)
		VectorScript: FUNCTION IFC_SetIFCEntity2(hObject:HANDLE; inStrIfcType:STRING) : BOOLEAN;
		
		Category: IFC
		Sets IFC entity type and its default Psets and values from IFC Data Mapping.
	'''
	pass
	return 'BOOLEAN' # 


def IFC_SetIFCScheme(
		scheme  # INTEGER -  
		):
	'''
		Python: BOOLEAN = vs.IFC_SetIFCScheme(scheme)
		VectorScript: FUNCTION IFC_SetIFCScheme(scheme:INTEGER) : BOOLEAN;
		
		Category: IFC
		Sets the active IFC version
	'''
	pass
	return 'BOOLEAN' # 


def IFC_SetProperty(
		hObject     , # HANDLE -  
		pSetName    , # STRING -  
		propertyName, # STRING -  
		propValue     # STRING -  
		):
	'''
		Python: BOOLEAN = vs.IFC_SetProperty(hObject, pSetName, propertyName, propValue)
		VectorScript: FUNCTION IFC_SetProperty(hObject:HANDLE; pSetName:STRING; propertyName:STRING; propValue:STRING) : BOOLEAN;
		
		Category: IFC
		Sets the specified property value.
	'''
	pass
	return 'BOOLEAN' # 


def IFC_SetPsetProp(
		hObject       , # HANDLE -  
		inStrPsetName , # STRING -  
		inStrPropName , # STRING -  
		inStrPropValue  # STRING -  
		):
	'''
		Python: BOOLEAN = vs.IFC_SetPsetProp(hObject, inStrPsetName, inStrPropName, inStrPropValue)
		VectorScript: FUNCTION IFC_SetPsetProp(hObject:HANDLE; inStrPsetName:STRING; inStrPropName:STRING; inStrPropValue:STRING) : BOOLEAN;
		
		Category: IFC
		Sets the value of a selected property from a property set
	'''
	pass
	return 'BOOLEAN' # 


def ImportDXFDWG():
	'''
		Python: vs.ImportDXFDWG()
		VectorScript: PROCEDURE ImportDXFDWG;
		
		Category: ImportExport
		Import one or many DXF/DWG or DWF files
	'''
	pass


def ImportDXFDWGFile(
		fileName, # DYNARRAY[] of CHAR -  
		isBatch   # BOOLEAN            -  
		):
	'''
		Python: INTEGER = vs.ImportDXFDWGFile(fileName, isBatch)
		VectorScript: FUNCTION ImportDXFDWGFile(fileName:DYNARRAY of CHAR; isBatch:BOOLEAN) : INTEGER;
		
		Category: ImportExport
		Import specific DXF/DWG file
	'''
	pass
	return 'INTEGER' # 


def ImportIGES(
		fileName  # DYNARRAY[] of CHAR - full path to the file for import
		):
	'''
		Python: BOOLEAN = vs.ImportIGES(fileName)
		VectorScript: FUNCTION ImportIGES(fileName:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: File I/O
		Import a 3D IGES file.
	'''
	pass
	return 'BOOLEAN' # Return TRUE if succeeded.


def ImportImageFile(
		filePath, # DYNARRAY[] of CHAR - Full path to the image file.                  
		importPt  # POINT              - Location on which the file should be imported.
		):
	'''
		Python: HANDLE = vs.ImportImageFile(filePath, importPt)
		VectorScript: FUNCTION ImportImageFile(filePath:DYNARRAY of CHAR; importPtX, importPtY:REAL) : HANDLE;
		
		Category: Utility
		Import the specified image file as an Image object in Vectorworks.
	'''
	pass
	return 'HANDLE' # 


def ImportImageFileN(
		filePath, # DYNARRAY[] of CHAR - Import file path.                                                                                                                                                                         
		importPt, # POINT              - The import location.                                                                                                                                                                      
		mode      # INTEGER            - Import mode: 0 - import using import option dialog; 1 - import using the last options. If the call was never made with option dialog, then the first time it will show the options dialog.
		):
	'''
		Python: HANDLE = vs.ImportImageFileN(filePath, importPt, mode)
		VectorScript: FUNCTION ImportImageFileN(filePath:DYNARRAY of CHAR; importPtX, importPtY:REAL; mode:INTEGER) : HANDLE;
		
		Category: Utility
		Import the specified image file as an Image object in Vectorworks. This function allow controlling the options when importing the image.
	'''
	pass
	return 'HANDLE' # Return the imported image handle, or NIL if the import failed.


def ImportOBJ(
		fileName   , # DYNARRAY[] of CHAR - Full file path.                               
		bAllMatAsRW  # BOOLEAN            - Imports all materials as Renderworks textures.
		):
	'''
		Python: BOOLEAN = vs.ImportOBJ(fileName, bAllMatAsRW)
		VectorScript: FUNCTION ImportOBJ(fileName:DYNARRAY of CHAR; bAllMatAsRW:BOOLEAN) : BOOLEAN;
		
		Category: ImportExport
		Imports Wavefront (*.obj) files.
	'''
	pass
	return 'BOOLEAN' # TRUE if import is successful.


def ImportResourceToCurrentFile(
		listID, # LONGINT - an ID for a resource list created by the BuildResourceList command.
		index   # LONGINT - an index into the list.                                            
		):
	'''
		Python: HANDLE = vs.ImportResourceToCurrentFile(listID, index)
		VectorScript: FUNCTION ImportResourceToCurrentFile(listID:LONGINT; index:LONGINT) : HANDLE;
		
		Category: Document List Handling
		Imports the indicated resource from the specified list to the current file, if it is not already in the current file, and returns the handle to the resource.
	'''
	pass
	return 'HANDLE' # 


def ImportResToCurFileN(
		listID  , # LONGINT   -  
		index   , # LONGINT   -  
		callback  # PROCEDURE -  
		):
	'''
		Python: HANDLE = vs.ImportResToCurFileN(listID, index, callback)
		VectorScript: FUNCTION ImportResToCurFileN(listID:LONGINT; index:LONGINT; callback:PROCEDURE) : HANDLE;
		
		Category: Document List Handling
		Imports the indicated resource from the specified list to the current file, if it is not already in the current file, and returns the handle to the resource. It will use a callback function to determine how to handle duplicate resouce.
	'''
	pass
	return 'HANDLE' # 


def ImportRevit(
		fileName  # DYNARRAY[] of CHAR -  
		):
	'''
		Python: vs.ImportRevit(fileName)
		VectorScript: PROCEDURE ImportRevit(fileName:DYNARRAY of CHAR);
		
		Category: ImportExport
		Import RVT and RFA files
	'''
	pass


def ImportSAT(
		filePath   , # DYNARRAY[] of CHAR - full path to the file for import
		doSingleSym  # BOOLEAN            - import the file as a symbol     
		):
	'''
		Python: HANDLE = vs.ImportSAT(filePath, doSingleSym)
		VectorScript: FUNCTION ImportSAT(filePath:DYNARRAY of CHAR; doSingleSym:BOOLEAN) : HANDLE;
		
		Category: File I/O
		Import a SAT file.
	'''
	pass
	return 'HANDLE' # Return handle to the imported symbol, or to the first imported object (first selected).


def ImportSingleDXFDWG():
	'''
		Python: vs.ImportSingleDXFDWG()
		VectorScript: PROCEDURE ImportSingleDXFDWG;
		
		Category: ImportExport
		Import single DXF/DWG files
	'''
	pass


def ImportSketchUp(
		filePath     , # DYNARRAY[] of CHAR - Full file path.                              
		bImportAsMesh  # BOOLEAN            - Import as a Mesh or as 3D polys. Mesh = TRUE.
		):
	'''
		Python: BOOLEAN = vs.ImportSketchUp(filePath, bImportAsMesh)
		VectorScript: FUNCTION ImportSketchUp(filePath:DYNARRAY of CHAR; bImportAsMesh:BOOLEAN) : BOOLEAN;
		
		Category: ImportExport
		Imports SketchUp ( *.skp)  files.
	'''
	pass
	return 'BOOLEAN' # TRUE if import is successful.


def ImportSketchup1(
		filePath   , # STRING  -  
		doSingleSym  # BOOLEAN -  
		):
	'''
		Python: BOOLEAN = vs.ImportSketchup1(filePath, doSingleSym)
		VectorScript: FUNCTION ImportSketchup1(filePath:STRING; doSingleSym:BOOLEAN) : BOOLEAN;
		
		Category: File I/O
		Import a sketch up file.
	'''
	pass
	return 'BOOLEAN' # 


def Index2Name(
		index  # LONGINT - Object index number.
		):
	'''
		Python: STRING = vs.Index2Name(index)
		VectorScript: FUNCTION Index2Name(index:LONGINT) : STRING;
		
		Category: Object Names
		Function Index2Name returns the name of the object with specified index number.
	'''
	pass
	return 'STRING' # 


def Init3DSServices():
	'''
		Python: vs.Init3DSServices()
		VectorScript: PROCEDURE Init3DSServices;
		
		Category: ImportExport
		Init 3DS Library services for Import and Export
	'''
	pass


def InitDWGServices():
	'''
		Python: vs.InitDWGServices()
		VectorScript: PROCEDURE InitDWGServices;
		
		Category: ImportExport
		Init DWG Library services for Import and Export
	'''
	pass


def InitRevitServices():
	'''
		Python: vs.InitRevitServices()
		VectorScript: PROCEDURE InitRevitServices;
		
		Category: ImportExport
		Init Revit Library services for Import and Export
	'''
	pass


def InitXML():
	'''
		Python: LONGINT = vs.InitXML()
		VectorScript: FUNCTION InitXML : LONGINT;
		
		Category: XML
		Initializes the XML System
	'''
	pass
	return 'LONGINT' # 


def Insert(
		source, # DYNARRAY[] of CHAR - String to be inserted.                  
		index   # INTEGER            - Position where string is to be inserted.
		):
	'''
		Python: dest = vs.Insert(source, index)
		VectorScript: PROCEDURE Insert(source:DYNARRAY of CHAR; VAR dest:DYNARRAY of CHAR; index:INTEGER);
		
		Category: Strings
		Procedure Insert will insert the specified string into a destination string.
	'''
	pass
	return ( 'string' )


def InsertEnhancedPullDownMenuItem(
		dialogID   , # LONGINT -  
		componentID, # LONGINT -  
		strName    , # STRING  -  
		iIconID      # INTEGER -  
		):
	'''
		Python: INTEGER = vs.InsertEnhancedPullDownMenuItem(dialogID, componentID, strName, iIconID)
		VectorScript: FUNCTION InsertEnhancedPullDownMenuItem(dialogID:LONGINT; componentID:LONGINT; strName:STRING; iIconID:INTEGER) : INTEGER;
		
		Category: Dialogs - Modern
		Inserts the item into the specified Layout Manager enhanced pull down menu control.
	'''
	pass
	return 'INTEGER' # 


def InsertEnhanPullDownMenuItem(
		dialogID      , # LONGINT            -                                                                                                                  
		controlID     , # LONGINT            -                                                                                                                  
		strName       , # STRING             -                                                                                                                  
		imageSpecifier  # DYNARRAY[] of CHAR - The string identifier for the image. It should be of the form "ResourceFileNameWithoutExtension/PathOfImageFile".
		):
	'''
		Python: INTEGER = vs.InsertEnhanPullDownMenuItem(dialogID, controlID, strName, imageSpecifier)
		VectorScript: FUNCTION InsertEnhanPullDownMenuItem(dialogID:LONGINT; controlID:LONGINT; strName:STRING; imageSpecifier:DYNARRAY of CHAR) : INTEGER;
		
		Category: Dialogs - Modern
		Inserts a image Replaces InsertEnhancedPulldownMenuItem
	'''
	pass
	return 'INTEGER' # 


def InsertGradientData(
		gradient        , # HANDLE  - Gradient into which a segment is to be inserted.                                  
		spotPosition    , # REAL    - Position of the segment's color spot relative to left-most point of the gradient. 
		midpointPosition, # REAL    - Position of the segment's midpoint relative to color spot immediately to left.    
		red             , # LONGINT - Red component of the color spot's color.                                          
		green           , # LONGINT - Green component of the color spot's color.                                        
		blue            , # LONGINT - Blue component of the color spot's color.                                         
		opacity           # INTEGER - Opacity of the color spot.                                                        
		):
	'''
		Python: INTEGER = vs.InsertGradientData(gradient, spotPosition, midpointPosition, red, green, blue, opacity)
		VectorScript: FUNCTION InsertGradientData(gradient:HANDLE; spotPosition:REAL; midpointPosition:REAL; red:LONGINT; green:LONGINT; blue:LONGINT; opacity:INTEGER) : INTEGER;
		
		Category: Document Attributes
		A segment consists of a single color spot and the single midpoint immediately to the right of the color spot.
	'''
	pass
	return 'INTEGER' # Returns the index of the newly created segment; 0 otherwise. [[BR]]Note: segment indexes begin with 1. [[BR]]


def InsertGradientSegment(
		gradient        , # HANDLE  - Gradient into which a segment is to be inserted.                                                                             
		spotPosition    , # REAL    - Position of the segment's color spot relative to left-most point of the gradient. [[BR]](position >= 0.0 and position <= 1.0)
		midpointPosition, # REAL    - Position of the segment's midpoint relative to color spot immediately to left. [[BR]](position >= 0.0 and position <= 1.0)   
		red             , # LONGINT - Red component of the color spot's color. [[BR]](red >= 0 and red <= 255)                                                     
		green           , # LONGINT - Green component of the color spot's color. [[BR]](green >= 0 and green <= 255)                                               
		blue              # LONGINT - Blue component of the color spot's color. [[BR]](blue >= 0 and blue <= 255)                                                  
		):
	'''
		Python: INTEGER = vs.InsertGradientSegment(gradient, spotPosition, midpointPosition, red, green, blue)
		VectorScript: FUNCTION InsertGradientSegment(gradient:HANDLE; spotPosition:REAL; midpointPosition:REAL; red:LONGINT; green:LONGINT; blue:LONGINT) : INTEGER;
		
		Category: Document Attributes
		Inserts a new segment into the gradient and initializes its data to the specified values.
		A segment consists of a single color spot and the single midpoint immediately to the right of the color spot.
	'''
	pass
	return 'INTEGER' # Returns the index of the newly created segment; 0 otherwise.[[BR]][[BR]]Note: segment indexes begin with 1.


def InsertGradientSliderSegment(
		dialogID    , # LONGINT - Index to the dialog layout that contains the gradient slider component.                                                      
		componentID , # LONGINT - Index to a specific gradient slider component.                                                                               
		spotPosition, # REAL    - Position of the segment's color marker relative to left-most point of the slider. [[BR]](position >= 0.0 and position <= 1.0)
		red         , # LONGINT - Red component of the color spot's color. [[BR]](red >= 0 and red <= 255)                                                     
		green       , # LONGINT - Green component of the color spot's color. [[BR]](green >= 0 and green <= 255)                                               
		blue          # LONGINT - Blue component of the color spot's color. [[BR]](blue >= 0 and blue <= 255)                                                  
		):
	'''
		Python: INTEGER = vs.InsertGradientSliderSegment(dialogID, componentID, spotPosition, red, green, blue)
		VectorScript: FUNCTION InsertGradientSliderSegment(dialogID:LONGINT; componentID:LONGINT; spotPosition:REAL; red:LONGINT; green:LONGINT; blue:LONGINT) : INTEGER;
		
		Category: Dialogs - Modern
		Inserts a new segment into the gradient slider and initializes its data to the specified values.
	'''
	pass
	return 'INTEGER' # Returns index to new segment.


def InsertGradientSliSeg(
		dialogID    , # LONGINT - Index to the dialog layout that contains the gradient slider component.                                                                                                           
		componentID , # LONGINT - Index to a specific gradient slider component.                                                                                                                                    
		spotPosition, # REAL    - Position of the segment's color marker relative to left-most point of the slider. The value should be >= 0.0 and <= 1.0, which represents a percentage distance across the slider.
		red         , # LONGINT - Red component of the color spot's color.                                                                                                                                          
		green       , # LONGINT - Green component of the color spot's color.                                                                                                                                        
		blue        , # LONGINT - Blue component of the color spot's color.                                                                                                                                         
		opacity       # INTEGER - Opacity for the color at the spot position.                                                                                                                                       
		):
	'''
		Python: INTEGER = vs.InsertGradientSliSeg(dialogID, componentID, spotPosition, red, green, blue, opacity)
		VectorScript: FUNCTION InsertGradientSliSeg(dialogID:LONGINT; componentID:LONGINT; spotPosition:REAL; red:LONGINT; green:LONGINT; blue:LONGINT; opacity:INTEGER) : INTEGER;
		
		Category: Dialogs - Modern
	'''
	pass
	return 'INTEGER' # Returns index to new segment. 


def InsertImagePopupObjectItem(
		dialogID   , # LONGINT - Index to the dialog layout that contains the image popup component.
		componentID, # LONGINT - Index to a specific image popup component.                         
		objectName   # STRING  - Name of the object to insert.                                      
		):
	'''
		Python: INTEGER = vs.InsertImagePopupObjectItem(dialogID, componentID, objectName)
		VectorScript: FUNCTION InsertImagePopupObjectItem(dialogID:LONGINT; componentID:LONGINT; objectName:STRING) : INTEGER;
		
		Category: Dialogs - Modern
		Inserts the specified object into the image popup.
		Note: the image popup only supports the following object types: gradients, hatches, images, record formats, render backgrounds, symbol folders, symbols, textures, vectorscript palettes, vectorscripts, worksheets.
	'''
	pass
	return 'INTEGER' # Returns an image popup index to the object inserted.


def InsertImagePopupResource(
		dialogID   , # LONGINT - index to the dialog layout that contains the image popup component. 
		componentID, # LONGINT - index to a specific image popup component.                          
		listID     , # LONGINT - an ID for a resource list created by the BuildResourceList function.
		index        # LONGINT - an index into the list.                                             
		):
	'''
		Python: LONGINT = vs.InsertImagePopupResource(dialogID, componentID, listID, index)
		VectorScript: FUNCTION InsertImagePopupResource(dialogID:LONGINT; componentID:LONGINT; listID:LONGINT; index:LONGINT) : LONGINT;
		
		Category: Dialogs - Modern
		Inserts the indicated item of the specified resource list into the indicated image popup and returns the image popup index of the inserted item.
	'''
	pass
	return 'LONGINT' # 


def InsertImagePopupSeparator(
		liDialogID   , # LONGINT -  
		liComponentID, # LONGINT -  
		strLabel       # STRING  -  
		):
	'''
		Python: INTEGER = vs.InsertImagePopupSeparator(liDialogID, liComponentID, strLabel)
		VectorScript: FUNCTION InsertImagePopupSeparator(liDialogID:LONGINT; liComponentID:LONGINT; strLabel:STRING) : INTEGER;
		
		Category: Dialogs - Modern
		Inserts a separator with the specified label at the end of the image popup list.
	'''
	pass
	return 'INTEGER' # 


def InsertLBColumn(
		dialogID    , # LONGINT - id of the dialog that contains the list browser
		componentID , # LONGINT - id of the list browser control                 
		columnIndex , # INTEGER - index at which the column is to be inserted    
		headerString, # STRING  - text to set as column header                   
		width         # INTEGER - the width of the column in pixels              
		):
	'''
		Python: INTEGER = vs.InsertLBColumn(dialogID, componentID, columnIndex, headerString, width)
		VectorScript: FUNCTION InsertLBColumn(dialogID:LONGINT; componentID:LONGINT; columnIndex:INTEGER; headerString:STRING; width:INTEGER) : INTEGER;
		
		Category: Dialogs - Modern - Browser
		Inserts a column into the specified list browser control. Returns index of created column.
	'''
	pass
	return 'INTEGER' # 


def InsertLBColumnDataItem(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID, # LONGINT - id of the list browser control                 
		columnIndex, # INTEGER - the column for which to set the data           
		itemString , # STRING  - the item text                                  
		imageOn    , # INTEGER - the 'on' image list index                      
		imageOff   , # INTEGER - the 'off' image list index                     
		itemData     # LONGINT - the item user data                             
		):
	'''
		Python: INTEGER = vs.InsertLBColumnDataItem(dialogID, componentID, columnIndex, itemString, imageOn, imageOff, itemData)
		VectorScript: FUNCTION InsertLBColumnDataItem(dialogID:LONGINT; componentID:LONGINT; columnIndex:INTEGER; itemString:STRING; imageOn:INTEGER; imageOff:INTEGER; itemData:LONGINT) : INTEGER;
		
		Category: Dialogs - Modern - Browser
		Inserts column data item with specified data. Returns the index to the newly inserted item.
	'''
	pass
	return 'INTEGER' # 


def InsertLBItem(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID, # LONGINT - id of the list browser control                 
		itemIndex  , # INTEGER - index at which the item is to be inserted      
		itemString   # STRING  - text to set for item                           
		):
	'''
		Python: INTEGER = vs.InsertLBItem(dialogID, componentID, itemIndex, itemString)
		VectorScript: FUNCTION InsertLBItem(dialogID:LONGINT; componentID:LONGINT; itemIndex:INTEGER; itemString:STRING) : INTEGER;
		
		Category: Dialogs - Modern - Browser
		Insert an item into the specified list browser control. Returns the index of the created item.
	'''
	pass
	return 'INTEGER' # 


def InsertNewComponent(
		object              , # HANDLE            - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		beforeComponentIndex, # INTEGER           - The index before which to insert the new component.                                                                                                                   
		width               , # REAL (Coordinate) - The width of the component.                                                                                                                                           
		fill                , # LONGINT           - The fill of the component.  Positive values for patterns, negative ref numbers for hatches.                                                                           
		leftPenWeight       , # INTEGER           - The pen weight of the component's left line.                                                                                                                          
		rightPenWeight      , # INTEGER           - The pen weight of the component's right line.                                                                                                                         
		leftPenStyle        , # INTEGER           - The pen style of the component's left line.  Positive values for patterns, negative values for dash styles.                                                           
		rightPenStyle         # INTEGER           - The pen style of the component's right line.  Positive values for patterns, negative values for dash styles.                                                          
		):
	'''
		Python: BOOLEAN = vs.InsertNewComponent(object, beforeComponentIndex, width, fill, leftPenWeight, rightPenWeight, leftPenStyle, rightPenStyle)
		VectorScript: FUNCTION InsertNewComponent(object:HANDLE; beforeComponentIndex:INTEGER; width:REAL (Coordinate); fill:LONGINT; leftPenWeight:INTEGER; rightPenWeight:INTEGER; leftPenStyle:INTEGER; rightPenStyle:INTEGER) : BOOLEAN;
		
		Category: Objects - Architectural
		Deprecated - will generate error. Use InsertNewComponentN instead.
	'''
	pass
	return 'BOOLEAN' # 


def InsertNewComponentN(
		object              , # HANDLE            - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		beforeComponentIndex, # INTEGER           - The index before which to insert the new component.                                                                                                                   
		width               , # REAL (Coordinate) - The width of the component.                                                                                                                                           
		fill                , # LONGINT           - The fill of the component.  Positive values for patterns, negative ref numbers for hatches.                                                                           
		leftPenWeight       , # INTEGER           - The pen weight of the component's left line.                                                                                                                          
		rightPenWeight      , # INTEGER           - The pen weight of the component's right line.                                                                                                                         
		leftPenStyle        , # LONGINT           - The pen style of the component's left line.  Positive values for patterns, negative values for line types.                                                            
		rightPenStyle         # LONGINT           - The pen style of the component's right line.  Positive values for patterns, negative values for line types.                                                           
		):
	'''
		Python: BOOLEAN = vs.InsertNewComponentN(object, beforeComponentIndex, width, fill, leftPenWeight, rightPenWeight, leftPenStyle, rightPenStyle)
		VectorScript: FUNCTION InsertNewComponentN(object:HANDLE; beforeComponentIndex:INTEGER; width:REAL (Coordinate); fill:LONGINT; leftPenWeight:INTEGER; rightPenWeight:INTEGER; leftPenStyle:LONGINT; rightPenStyle:LONGINT) : BOOLEAN;
		
		Category: Objects - Architectural
		Inserts a new component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def InsertNewDLCompN(
		beforeIndex   , # INTEGER           - The index before which to insert the new component.                                                        
		widthDistance , # REAL (Coordinate) - The width of the component.                                                                                
		fill          , # LONGINT           - The fill of the component.  Positive values for patterns, negative ref numbers for hatches.                
		penWeightLeft , # INTEGER           - The pen weight of the component's left line.                                                               
		penWeightRight, # INTEGER           - The pen weight of the component's right line.                                                              
		penStyleLeft  , # LONGINT           - The pen style of the component's left line.  Positive values for patterns, negative values for line types. 
		penStyleRight   # LONGINT           - The pen style of the component's right line.  Positive values for patterns, negative values for line types.
		):
	'''
		Python: BOOLEAN = vs.InsertNewDLCompN(beforeIndex, widthDistance, fill, penWeightLeft, penWeightRight, penStyleLeft, penStyleRight)
		VectorScript: FUNCTION InsertNewDLCompN(beforeIndex:INTEGER; widthDistance:REAL (Coordinate); fill:LONGINT; penWeightLeft:INTEGER; penWeightRight:INTEGER; penStyleLeft:LONGINT; penStyleRight:LONGINT) : BOOLEAN;
		
		Category: Document Settings
		Inserts a new component before index in the Double Line Preferences.
	'''
	pass
	return 'BOOLEAN' # 


def InsertNewDLComponent(
		beforeIndex   , # INTEGER           - The index before which to insert the new component.                                                         
		widthDistance , # REAL (Coordinate) - The width of the component.                                                                                 
		fill          , # LONGINT           - The fill of the component.  Positive values for patterns, negative ref numbers for hatches.                 
		penWeightLeft , # INTEGER           - The pen weight of the component's left line.                                                                
		penWeightRight, # INTEGER           - The pen weight of the component's right line.                                                               
		penStyleLeft  , # INTEGER           - The pen style of the component's left line.  Positive values for patterns, negative values for dash styles. 
		penStyleRight   # INTEGER           - The pen style of the component's right line.  Positive values for patterns, negative values for dash styles.
		):
	'''
		Python: BOOLEAN = vs.InsertNewDLComponent(beforeIndex, widthDistance, fill, penWeightLeft, penWeightRight, penStyleLeft, penStyleRight)
		VectorScript: FUNCTION InsertNewDLComponent(beforeIndex:INTEGER; widthDistance:REAL (Coordinate); fill:LONGINT; penWeightLeft:INTEGER; penWeightRight:INTEGER; penStyleLeft:INTEGER; penStyleRight:INTEGER) : BOOLEAN;
		
		Category: Document Settings
		Deprecated - will generate error. Use InsertNewDLCompN instead.
	'''
	pass
	return 'BOOLEAN' # 


def InsertPropClassOrLayerItem(
		dialogID      , # LONGINT            - The dialog identifier given by the command to create the dialog.                                                 
		controlID     , # LONGINT            - The control identifier.                                                                                          
		strLabel      , # STRING             - Text for the label of the Pull Down.                                                                             
		imageSpecifier  # DYNARRAY[] of CHAR - The string identifier for the image. It should be of the form "ResourceFileNameWithoutExtension/PathOfImageFile".
		):
	'''
		Python: BOOLEAN = vs.InsertPropClassOrLayerItem(dialogID, controlID, strLabel, imageSpecifier)
		VectorScript: FUNCTION InsertPropClassOrLayerItem(dialogID:LONGINT; controlID:LONGINT; strLabel:STRING; imageSpecifier:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: Dialogs - Modern
		Inserts a class or layer item in the proposed section of a Class, Design Layer, or Sheet Layer Layout Manager Pull Down.
	'''
	pass
	return 'BOOLEAN' # 


def InsertProposedClassOrLayerItem(
		nDialogID   , # LONGINT -  
		nComponentID, # LONGINT -  
		strLabel    , # STRING  -  
		nIconIndex    # INTEGER -  
		):
	'''
		Python: BOOLEAN = vs.InsertProposedClassOrLayerItem(nDialogID, nComponentID, strLabel, nIconIndex)
		VectorScript: FUNCTION InsertProposedClassOrLayerItem(nDialogID:LONGINT; nComponentID:LONGINT; strLabel:STRING; nIconIndex:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern
		Inserts a class or layer item in the proposed section of a Class, Design Layer, or Sheet Layer Layout Manager Pull Down.
	'''
	pass
	return 'BOOLEAN' # 


def InsertSymbol(
		offsetDistance, # REAL (Coordinate) - Offset distance from wall start.      
		heightDistance, # REAL (Coordinate) - Elevation of symbol.                  
		flipped       , # BOOLEAN           - Flip orientation of symbol.           
		right         , # BOOLEAN           - Left-right orientation of symbol.     
		capped        , # BOOLEAN           - Cap wall breaks.                      
		symbolName      # STRING            - Name of symbol to be inserted in wall.
		):
	'''
		Python: vs.InsertSymbol(offsetDistance, heightDistance, flipped, right, capped, symbolName)
		VectorScript: PROCEDURE InsertSymbol(offsetDistance:REAL (Coordinate); heightDistance:REAL (Coordinate); flipped:BOOLEAN; right:BOOLEAN; capped:BOOLEAN; symbolName:STRING);
		
		Category: Objects - Walls
		Procedure InsertSymbol places a specified symbol into a wall.
	'''
	pass


def InsertSymbolInFolder(
		targetFolder, # HANDLE - Handle to symbol folder.    
		symbolDef     # HANDLE - Handle to symbol definition.
		):
	'''
		Python: vs.InsertSymbolInFolder(targetFolder, symbolDef)
		VectorScript: PROCEDURE InsertSymbolInFolder(targetFolder:HANDLE; symbolDef:HANDLE);
		
		Category: Objects - Symbols
		Inserts a symbol definition into the referenced symbol folder.
	'''
	pass


def InsertTreeControlItem(
		nDialogID   , # LONGINT -  
		nComponentID, # LONGINT -  
		strItemLabel, # STRING  -  
		nParentID   , # INTEGER -  
		nAfterID      # INTEGER -  
		):
	'''
		Python: INTEGER = vs.InsertTreeControlItem(nDialogID, nComponentID, strItemLabel, nParentID, nAfterID)
		VectorScript: FUNCTION InsertTreeControlItem(nDialogID:LONGINT; nComponentID:LONGINT; strItemLabel:STRING; nParentID:INTEGER; nAfterID:INTEGER) : INTEGER;
		
		Category: Dialogs - Modern
		Inserts an item into a Layout Manager tree control.
	'''
	pass
	return 'INTEGER' # 


def InsertVertex(
		objectHandle   , # HANDLE  - Handle to the polygon or polyline                          
		x              , # REAL    - X-coordinate of the vertex to add                          
		y              , # REAL    - Y-coordinate of the vertex to add                          
		beforeVertexNum, # INTEGER - Vertex number before which the new vertex is to be inserted
		vertexType     , # INTEGER - Vertex type of the new vertex                              
		arcRadius        # REAL    - For arc vertices, the radius of the arc                    
		):
	'''
		Python: vs.InsertVertex(objectHandle, x, y, beforeVertexNum, vertexType, arcRadius)
		VectorScript: PROCEDURE InsertVertex(objectHandle:HANDLE; x:REAL; y:REAL; beforeVertexNum:INTEGER; vertexType:INTEGER; arcRadius:REAL);
		
		Category: Objects - Polys
		Inserts a new vertex into polygon or polyline.  If the vertexType is nonzero, it will convert the objectHandle into a polyline.
	'''
	pass


def InsertWSColumns(
		worksheet   , # HANDLE  - Handle to worksheet.           
		beforeColumn, # INTEGER - Insert location of new columns.
		numColumns    # INTEGER - Number of columns to insert.   
		):
	'''
		Python: vs.InsertWSColumns(worksheet, beforeColumn, numColumns)
		VectorScript: PROCEDURE InsertWSColumns(worksheet:HANDLE; beforeColumn:INTEGER; numColumns:INTEGER);
		
		Category: Worksheets
		Inserts columns into the referenced worksheet.
	'''
	pass


def InsertWSRows(
		worksheet, # HANDLE  - Handle to worksheet.                   
		beforeRow, # INTEGER - Insert location for new worksheet rows.
		numRows    # INTEGER - Number of rows to insert.              
		):
	'''
		Python: vs.InsertWSRows(worksheet, beforeRow, numRows)
		VectorScript: PROCEDURE InsertWSRows(worksheet:HANDLE; beforeRow:INTEGER; numRows:INTEGER);
		
		Category: Worksheets
		Inserts rows into a referenced worksheet.
	'''
	pass


def IntDialog(
		request, # DYNARRAY[] of CHAR - Dialog user prompt string.    
		default  # DYNARRAY[] of CHAR - Default value for input field.
		):
	'''
		Python: INTEGER = vs.IntDialog(request, default)
		VectorScript: FUNCTION IntDialog(request:DYNARRAY of CHAR; default:DYNARRAY of CHAR) : INTEGER;
		
		Category: Dialogs - Predefined
		Function IntDialog displays a dialog box which requests the user to enter an integer value.
		IntDialog automatically screens for valid numeric input.
	'''
	pass
	return 'INTEGER' # 


def IntersectSolid(
		obj1, # HANDLE - Handle to source object for intersect operation.
		obj2  # HANDLE - Handle to source object for intersect operation.
		):
	'''
		Python: (INTEGER, newSolid) = vs.IntersectSolid(obj1, obj2)
		VectorScript: FUNCTION IntersectSolid(obj1:HANDLE; obj2:HANDLE; VAR newSolid:HANDLE) : INTEGER;
		
		Category: Objects - Solids
		Function IntersectSolid creates a new solid intersection object from the referenced source objects.
	'''
	pass
	return ( 0      , # 
	         0       )


def IntersectSurface(
		s1, # HANDLE - Handle to object.
		s2  # HANDLE - Handle to object.
		):
	'''
		Python: HANDLE = vs.IntersectSurface(s1, s2)
		VectorScript: FUNCTION IntersectSurface(s1:HANDLE; s2:HANDLE) : HANDLE;
		
		Category: Objects - 2D
		Creates new surface objects that are the intersection of  the two referenced surface objects. The original surface objects are not modified. The new objects get "inserted" into the drawing list, after s2, and before the next object after that.
	'''
	pass
	return 'HANDLE' # Returns a HANDLE to the new surface object, or to a group containing multiple surface objects.


def IsAWorkingFile():
	'''
		Python: BOOLEAN = vs.IsAWorkingFile()
		VectorScript: FUNCTION IsAWorkingFile : BOOLEAN;
		
		Category: Project Sharing
		Returns True if the current document is a Project Sharing Working File. Otherwise returns False.
	'''
	pass
	return 'BOOLEAN' # Returns True if the current document is a Project Sharing Working File. Otherwise returns False.


def IsCatalogParameter(
		hObj     , # HANDLE - Handle to plug-in object  
		paramName  # STRING - Name of parameter to check
		):
	'''
		Python: BOOLEAN = vs.IsCatalogParameter(hObj, paramName)
		VectorScript: FUNCTION IsCatalogParameter(hObj:HANDLE; paramName:STRING) : BOOLEAN;
		
		Category: Objects - Custom
		Check if a parameter is defined in the catalog that has been associated with an object's plug-in style.
	'''
	pass
	return 'BOOLEAN' # 


def IsClassChoiceSelected(
		dialogID   , # LONGINT - Id of the dialog       
		componentID  # LONGINT - Id of the popup control
		):
	'''
		Python: BOOLEAN = vs.IsClassChoiceSelected(dialogID, componentID)
		VectorScript: FUNCTION IsClassChoiceSelected(dialogID:LONGINT; componentID:LONGINT) : BOOLEAN;
		
		Category: Dialogs - Modern
		Returns if 'By Class' is the selected choice in a marker, line style, or color popup control.
	'''
	pass
	return 'BOOLEAN' # 


def IsCoPlanar(
		refID1, # LONGINT - Reference ID of the first plane. 
		refID2  # LONGINT - Reference ID of the second plane.
		):
	'''
		Python: BOOLEAN = vs.IsCoPlanar(refID1, refID2)
		VectorScript: FUNCTION IsCoPlanar(refID1:LONGINT; refID2:LONGINT) : BOOLEAN;
		
		Category: Utility
		Returns true if two planes are coplanar.
	'''
	pass
	return 'BOOLEAN' # 


def IsCurtainWall(
		wall  # HANDLE - The wall.
		):
	'''
		Python: BOOLEAN = vs.IsCurtainWall(wall)
		VectorScript: FUNCTION IsCurtainWall(wall:HANDLE) : BOOLEAN;
		
		Category: Objects - Walls
		Gets whether or not a wall is a curtain wall.
	'''
	pass
	return 'BOOLEAN' # 


def IsDropShadowEnabled(
		h  # HANDLE -  
		):
	'''
		Python: BOOLEAN = vs.IsDropShadowEnabled(h)
		VectorScript: FUNCTION IsDropShadowEnabled(h:HANDLE) : BOOLEAN;
		
		Category: Object Attributes
	'''
	pass
	return 'BOOLEAN' # 


def IsFillColorByClass(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: BOOLEAN = vs.IsFillColorByClass(h)
		VectorScript: FUNCTION IsFillColorByClass(h:HANDLE) : BOOLEAN;
		
		Category: Object Attributes
		Function IsFillColorByClass returns whether class fill colors are used for the referenced object.
	'''
	pass
	return 'BOOLEAN' # 


def IsFlipped(
		c  # CRITERIA - Search criteria.
		):
	'''
		Python: REAL = vs.IsFlipped(c)
		VectorScript: FUNCTION IsFlipped(c:CRITERIA) : REAL;
		
		Category: Criteria
		Returns the number of objects meeting the criteria that are flipped.
	'''
	pass
	return 'REAL' # 


def IsFPatByClass(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: BOOLEAN = vs.IsFPatByClass(h)
		VectorScript: FUNCTION IsFPatByClass(h:HANDLE) : BOOLEAN;
		
		Category: Object Attributes
		Function IsFPatByClass whether a class fill pattern is used for the referenced object.
	'''
	pass
	return 'BOOLEAN' # 


def IsGeoreferenced(
		hLayer  # HANDLE -  
		):
	'''
		Python: BOOLEAN = vs.IsGeoreferenced(hLayer)
		VectorScript: FUNCTION IsGeoreferenced(hLayer:HANDLE) : BOOLEAN;
		
		Category: GIS
		Check if the layer is georeferenced. Pass NIL to check the document.
	'''
	pass
	return 'BOOLEAN' # 


def IsImageCropped(
		object  # HANDLE -  
		):
	'''
		Python: BOOLEAN = vs.IsImageCropped(object)
		VectorScript: FUNCTION IsImageCropped(object:HANDLE) : BOOLEAN;
		
		Category: Textures
		Check is the given image cropped.
	'''
	pass
	return 'BOOLEAN' # Returns true if the given image is cropped, FALSE otherwise.


def IsImageCropVisible(
		object  # HANDLE -  
		):
	'''
		Python: BOOLEAN = vs.IsImageCropVisible(object)
		VectorScript: FUNCTION IsImageCropVisible(object:HANDLE) : BOOLEAN;
		
		Category: Textures
		Check is the crop of the image visible.
	'''
	pass
	return 'BOOLEAN' # Returns true if the crop is visible, FALSE otherwise.


def IsItemEnabled(
		nDialogID   , # LONGINT -  
		nComponentID  # LONGINT -  
		):
	'''
		Python: BOOLEAN = vs.IsItemEnabled(nDialogID, nComponentID)
		VectorScript: FUNCTION IsItemEnabled(nDialogID:LONGINT; nComponentID:LONGINT) : BOOLEAN;
		
		Category: Dialogs - Modern
		Determines if the specified item is currently enabled.
	'''
	pass
	return 'BOOLEAN' # 


def IsItemVisible(
		nDialogID   , # LONGINT -  
		nComponentID  # LONGINT -  
		):
	'''
		Python: BOOLEAN = vs.IsItemVisible(nDialogID, nComponentID)
		VectorScript: FUNCTION IsItemVisible(nDialogID:LONGINT; nComponentID:LONGINT) : BOOLEAN;
		
		Category: Dialogs - Modern
		Determines if the specified item is currently visible.
	'''
	pass
	return 'BOOLEAN' # 


def IsLayerReferenced(
		layer  # HANDLE - Handle to the layer
		):
	'''
		Python: (BOOLEAN, pathname) = vs.IsLayerReferenced(layer)
		VectorScript: FUNCTION IsLayerReferenced(layer:HANDLE; VAR pathname:STRING) : BOOLEAN;
		
		Category: Layers
		Returns whether a layer is workgroup referenced, and if so, the path to the source document is returned.
	'''
	pass
	return ( False   , # Returns true if the layer is referenced, false otherwise.
	         'string' )


def IsLBColumnTrackingEnabled(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID, # LONGINT - id of the list browser control                 
		columnIndex  # INTEGER - the index of the column                        
		):
	'''
		Python: BOOLEAN = vs.IsLBColumnTrackingEnabled(dialogID, componentID, columnIndex)
		VectorScript: FUNCTION IsLBColumnTrackingEnabled(dialogID:LONGINT; componentID:LONGINT; columnIndex:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Determines if column tracking is enabled for the specified column.
	'''
	pass
	return 'BOOLEAN' # 


def IsLBDisplayHier(
		dialogID   , # LONGINT - The id of the dialog containing the list browser.
		componentID  # LONGINT - The id of the list browser.                      
		):
	'''
		Python: BOOLEAN = vs.IsLBDisplayHier(dialogID, componentID)
		VectorScript: FUNCTION IsLBDisplayHier(dialogID:LONGINT; componentID:LONGINT) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Returns whether the indicated list browser is set to display items hierarchically. One column in the list browser can be set to display names heirarchically.
	'''
	pass
	return 'BOOLEAN' # 


def IsLBItemSelected(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID, # LONGINT - id of the list browser control                 
		itemIndex    # INTEGER - the row number                                 
		):
	'''
		Python: BOOLEAN = vs.IsLBItemSelected(dialogID, componentID, itemIndex)
		VectorScript: FUNCTION IsLBItemSelected(dialogID:LONGINT; componentID:LONGINT; itemIndex:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Determines if the specified item is currently selected.
	'''
	pass
	return 'BOOLEAN' # 


def IsLBSortingEnabled(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID  # LONGINT - id of the list browser control                 
		):
	'''
		Python: BOOLEAN = vs.IsLBSortingEnabled(dialogID, componentID)
		VectorScript: FUNCTION IsLBSortingEnabled(dialogID:LONGINT; componentID:LONGINT) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Determines if sorting is enabled or disabled.
	'''
	pass
	return 'BOOLEAN' # 


def IsLSByClass(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: BOOLEAN = vs.IsLSByClass(h)
		VectorScript: FUNCTION IsLSByClass(h:HANDLE) : BOOLEAN;
		
		Category: Object Attributes
		Function IsLSByClass returns whether a class line style is used for the referenced object.
	'''
	pass
	return 'BOOLEAN' # 


def IsLWByClass(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: BOOLEAN = vs.IsLWByClass(h)
		VectorScript: FUNCTION IsLWByClass(h:HANDLE) : BOOLEAN;
		
		Category: Object Attributes
		Function IsLWByClass returns whether a class line weight is used for the referenced object.
	'''
	pass
	return 'BOOLEAN' # 


def IsMarkerByClass(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: BOOLEAN = vs.IsMarkerByClass(h)
		VectorScript: FUNCTION IsMarkerByClass(h:HANDLE) : BOOLEAN;
		
		Category: Object Attributes
		Function IsMarkerByClass returns whether a class marker style is used for the referenced object.
	'''
	pass
	return 'BOOLEAN' # 


def IsNewCustomObject(
		objectName  # STRING - Name of plugin object.
		):
	'''
		Python: BOOLEAN = vs.IsNewCustomObject(objectName)
		VectorScript: FUNCTION IsNewCustomObject(objectName:STRING) : BOOLEAN;
		
		Category: Objects - Custom
		Function IsNewCustomObject returns whether the specified plug-in object is a new object, indicating that the object is being regenerated for the first time.
		New object status is useful in specifying initialization and setup data, as well as calling initialization specific subroutines. This function should only be called in plug-in objects.
	'''
	pass
	return 'BOOLEAN' # 


def IsObjectFlipped(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: BOOLEAN = vs.IsObjectFlipped(h)
		VectorScript: FUNCTION IsObjectFlipped(h:HANDLE) : BOOLEAN;
		
		Category: Object Attributes
		Function IsObjectFlipped returns the flip orientation of the specified 3D object. The function returns TRUE if the object is currently flipped.
		This function works for sweeps, extrudes, multiple extrudes, symbols, solids, layer references, and plug-in objects.
	'''
	pass
	return 'BOOLEAN' # 


def IsPenColorByClass(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: BOOLEAN = vs.IsPenColorByClass(h)
		VectorScript: FUNCTION IsPenColorByClass(h:HANDLE) : BOOLEAN;
		
		Category: Object Attributes
		Function IsPenColorByClass returns whether class pen colors are used for the referenced object.
	'''
	pass
	return 'BOOLEAN' # 


def IsPerpPlane(
		refID1, # LONGINT - Reference ID of the first plane. 
		refID2  # LONGINT - Reference ID of the second plane.
		):
	'''
		Python: BOOLEAN = vs.IsPerpPlane(refID1, refID2)
		VectorScript: FUNCTION IsPerpPlane(refID1:LONGINT; refID2:LONGINT) : BOOLEAN;
		
		Category: Utility
		Returns true if two planes are perpendicular.
	'''
	pass
	return 'BOOLEAN' # 


def IsPlanarObj(
		object  # HANDLE - Object to test
		):
	'''
		Python: (BOOLEAN, NewParam) = vs.IsPlanarObj(object)
		VectorScript: FUNCTION IsPlanarObj(object:HANDLE; VAR NewParam:LONGINT) : BOOLEAN;
		
		Category: Object Attributes
	'''
	pass
	return ( False  , # 
	         0       )


def IsPluginFormat(
		theFormat  # HANDLE - Handle to the format node in question.
		):
	'''
		Python: BOOLEAN = vs.IsPluginFormat(theFormat)
		VectorScript: FUNCTION IsPluginFormat(theFormat:HANDLE) : BOOLEAN;
		
		Category: Objects - Custom
		Determines if the format node is used for the parameters of a plug-in object, plug-in tool or plug-in menu command.
	'''
	pass
	return 'BOOLEAN' # Returns true if format is used by a plug-in and false if it is a regular format that may have been created by the user.


def IsPolyClosed(
		polyHandle  # HANDLE -  
		):
	'''
		Python: BOOLEAN = vs.IsPolyClosed(polyHandle)
		VectorScript: FUNCTION IsPolyClosed(polyHandle:HANDLE) : BOOLEAN;
		
		Category: Objects - Polys
		Returns true if the specified polyline or polygon is a closed shape, and false otherwise.
	'''
	pass
	return 'BOOLEAN' # 


def IsProjectOffline():
	'''
		Python: BOOLEAN = vs.IsProjectOffline()
		VectorScript: FUNCTION IsProjectOffline : BOOLEAN;
		
		Category: Project Sharing
		Checks if current document is a Working File operating in Offline Mode.
		Offline Mode is when the Working File is opened and the Project File cannot be found.
	'''
	pass
	return 'BOOLEAN' # Returns True if current document is a Working File operating in Offline Mode.[[BR]]Returns False on failure or not Project Sharing file, or not in Offline Mode.


def IsRW():
	'''
		Python: BOOLEAN = vs.IsRW()
		VectorScript: FUNCTION IsRW : BOOLEAN;
		
		Category: Textures
		Indicates whether RenderWorks is available.
	'''
	pass
	return 'BOOLEAN' # Returns true if RenderWorks is available, false otherwise.


def IsTextStyleByClass(
		objectId  # HANDLE - handle to object
		):
	'''
		Python: BOOLEAN = vs.IsTextStyleByClass(objectId)
		VectorScript: FUNCTION IsTextStyleByClass(objectId:HANDLE) : BOOLEAN;
		
		Category: Object Attributes
		Procedure IsTextStyleByClass returns whether the class text style is used for the referenced object.
	'''
	pass
	return 'BOOLEAN' # 


def IsTextStyleByClassN(
		objectId, # HANDLE  - handle to text object                
		position  # INTEGER - Position in text string, zero-based. 
		):
	'''
		Python: BOOLEAN = vs.IsTextStyleByClassN(objectId, position)
		VectorScript: FUNCTION IsTextStyleByClassN(objectId:HANDLE; position:INTEGER) : BOOLEAN;
		
		Category: Objects - Text
		IsTextStyleByClassN returns whether the class text style is used at a specified position within the text object.
	'''
	pass
	return 'BOOLEAN' # Returns True if the requested character postion uses the class text style


def IsTextureableObject(
		obj  # HANDLE - Handle to object.
		):
	'''
		Python: BOOLEAN = vs.IsTextureableObject(obj)
		VectorScript: FUNCTION IsTextureableObject(obj:HANDLE) : BOOLEAN;
		
		Category: Textures
		Function IsTextureableObject returns whether the referenced object supports texture mapping.
	'''
	pass
	return 'BOOLEAN' # Returns TRUE if object supports texture mapping.


def IsTileGroupContainedObject(
		objectHandle  # HANDLE - The object handle to check.
		):
	'''
		Python: BOOLEAN = vs.IsTileGroupContainedObject(objectHandle)
		VectorScript: FUNCTION IsTileGroupContainedObject(objectHandle:HANDLE) : BOOLEAN;
		
		Category: Document Attributes
		Determines if the specified object is a tile group-contained object.
	'''
	pass
	return 'BOOLEAN' # TRUE if the object is a tile group-contained object; FALSE otherwise.


def IsUserColor(
		ColorIDX  # INTEGER -  
		):
	'''
		Python: (BOOLEAN, ColorName) = vs.IsUserColor(ColorIDX)
		VectorScript: FUNCTION IsUserColor(ColorIDX:INTEGER; VAR ColorName:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: Document Attributes
		Returns True if the color is a user color.
	'''
	pass
	return ( False   , # 
	         'string' )


def IsValidWSCell(
		worksheet, # HANDLE  - Handle to worksheet.  
		row      , # INTEGER - Row of target cell.   
		column     # INTEGER - Column of target cell.
		):
	'''
		Python: BOOLEAN = vs.IsValidWSCell(worksheet, row, column)
		VectorScript: FUNCTION IsValidWSCell(worksheet:HANDLE; row:INTEGER; column:INTEGER) : BOOLEAN;
		
		Category: Worksheets
		Returns if a specified cell is within the valid range of the referenced worksheet.
	'''
	pass
	return 'BOOLEAN' # A BOOLEAN value indicating whether the cell is in the valid range of the worksheet.


def IsValidWSRange(
		worksheet  , # HANDLE  - Handle to worksheet.             
		topRow     , # INTEGER - Top row of target range.         
		leftColumn , # INTEGER - Leftmost column of target range. 
		bottomRow  , # INTEGER - Bottom row of target range.      
		rightColumn  # INTEGER - Rightmost column of target range.
		):
	'''
		Python: BOOLEAN = vs.IsValidWSRange(worksheet, topRow, leftColumn, bottomRow, rightColumn)
		VectorScript: FUNCTION IsValidWSRange(worksheet:HANDLE; topRow:INTEGER; leftColumn:INTEGER; bottomRow:INTEGER; rightColumn:INTEGER) : BOOLEAN;
		
		Category: Worksheets
		Returns whether the specified range is within the valid range of the referenced worksheet.
	'''
	pass
	return 'BOOLEAN' # A BOOLEAN value indicating whether the range is valid.


def IsValidWSSubrowCell(
		worksheet, # HANDLE  - Handle to worksheet.       
		row      , # INTEGER - Database row to be queried.
		column   , # INTEGER - Column to be queried.      
		subrow     # INTEGER - Index of subrow.           
		):
	'''
		Python: BOOLEAN = vs.IsValidWSSubrowCell(worksheet, row, column, subrow)
		VectorScript: FUNCTION IsValidWSSubrowCell(worksheet:HANDLE; row:INTEGER; column:INTEGER; subrow:INTEGER) : BOOLEAN;
		
		Category: Worksheets
		Returns whether a specified database subrow cell is in the valid range of displayed subrows.
	'''
	pass
	return 'BOOLEAN' # A BOOLEAN value indicating whether the subrow cell location is valid.


def IsVPGroupContainedObject(
		objectHandle, # HANDLE  - Handle to object                                                                       
		groupType     # INTEGER - Type of group containing the object: (1 = Crop, 2 = Annotation, 3 = Cache, 4 = Section)
		):
	'''
		Python: BOOLEAN = vs.IsVPGroupContainedObject(objectHandle, groupType)
		VectorScript: FUNCTION IsVPGroupContainedObject(objectHandle:HANDLE; groupType:INTEGER) : BOOLEAN;
		
		Category: Objects - Groups
		Determines if specified object is contained within a viewport group, and if so which type of group.
	'''
	pass
	return 'BOOLEAN' # true if object is contained within a viewport group


def IsWallPeakTop(
		hWall    , # HANDLE  -  
		peakIndex  # INTEGER -  
		):
	'''
		Python: BOOLEAN = vs.IsWallPeakTop(hWall, peakIndex)
		VectorScript: FUNCTION IsWallPeakTop(hWall:HANDLE; peakIndex:INTEGER) : BOOLEAN;
		
		Category: Objects - Walls
		Returns true if specified peak (by index) of a wall is top.
	'''
	pass
	return 'BOOLEAN' # 


def IsWSCellNumber(
		worksheet, # HANDLE  - Handle to worksheet.        
		row      , # INTEGER - Row of cell to be queried.  
		column     # INTEGER - Column of cell to be queried
		):
	'''
		Python: BOOLEAN = vs.IsWSCellNumber(worksheet, row, column)
		VectorScript: FUNCTION IsWSCellNumber(worksheet:HANDLE; row:INTEGER; column:INTEGER) : BOOLEAN;
		
		Category: Worksheets
		Determines if a cell in the referenced worksheet contains a numeric value. The cell is referenced by its row-column position in the worksheet.
	'''
	pass
	return 'BOOLEAN' # A BOOLEAN value indicating whether the value is numeric.


def IsWSCellString(
		worksheet, # HANDLE  - Handle to worksheet.         
		row      , # INTEGER - Row of cell to be queried.   
		column     # INTEGER - Column of cell to be queried.
		):
	'''
		Python: BOOLEAN = vs.IsWSCellString(worksheet, row, column)
		VectorScript: FUNCTION IsWSCellString(worksheet:HANDLE; row:INTEGER; column:INTEGER) : BOOLEAN;
		
		Category: Worksheets
		Determines if a cell in the referenced worksheet contains a string value. The cell is referenced by its row-column position in the worksheet.
	'''
	pass
	return 'BOOLEAN' # A BOOLEAN value indicating whether the value is a string.


def IsWSDatabaseRow(
		worksheet  , # HANDLE  - Handle to worksheet.
		databaseRow  # INTEGER - Row to be queried.  
		):
	'''
		Python: BOOLEAN = vs.IsWSDatabaseRow(worksheet, databaseRow)
		VectorScript: FUNCTION IsWSDatabaseRow(worksheet:HANDLE; databaseRow:INTEGER) : BOOLEAN;
		
		Category: Worksheets
		Returns whether a row in the referenced worksheet is a database row.
	'''
	pass
	return 'BOOLEAN' # A BOOLEAN value indicating the database status of the targeted row.


def IsWSImg(
		worksheet, # HANDLE  - The worksheet handle.
		row      , # INTEGER - The cell row.        
		column     # INTEGER - The cell column.     
		):
	'''
		Python: BOOLEAN = vs.IsWSImg(worksheet, row, column)
		VectorScript: FUNCTION IsWSImg(worksheet:HANDLE; row:INTEGER; column:INTEGER) : BOOLEAN;
		
		Category: Worksheets
		Determines if worksheet cell is set to display an image.
	'''
	pass
	return 'BOOLEAN' # A BOOLEAN value indicating whether the cell contains an image or not.


def IsWSSubrowCellNumber(
		worksheet, # HANDLE  - Handle to worksheet.          
		row      , # INTEGER - Database row to be queried.   
		column   , # INTEGER - Column to be queried.         
		subrow     # INTEGER - Index of subrow to be queried.
		):
	'''
		Python: BOOLEAN = vs.IsWSSubrowCellNumber(worksheet, row, column, subrow)
		VectorScript: FUNCTION IsWSSubrowCellNumber(worksheet:HANDLE; row:INTEGER; column:INTEGER; subrow:INTEGER) : BOOLEAN;
		
		Category: Worksheets
		Returns whether a specified database subrow cell contains a numeric value.
	'''
	pass
	return 'BOOLEAN' # A BOOLEAN value indicating whether the cell contains a numeric value.


def IsWSSubrowCellString(
		worksheet, # HANDLE  - Handle to worksheet.          
		row      , # INTEGER - Database row to be queried.   
		column   , # INTEGER - Column to be queried.         
		subrow     # INTEGER - Index of subrow to be queried.
		):
	'''
		Python: BOOLEAN = vs.IsWSSubrowCellString(worksheet, row, column, subrow)
		VectorScript: FUNCTION IsWSSubrowCellString(worksheet:HANDLE; row:INTEGER; column:INTEGER; subrow:INTEGER) : BOOLEAN;
		
		Category: Worksheets
		Returns whether a specified database subrow cell contains a numeric value.
	'''
	pass
	return 'BOOLEAN' # A BOOLEAN value indicating whether the cell contains a string value.


def IsWSVisible(
		worksheet  # HANDLE - Handle to worksheet.
		):
	'''
		Python: BOOLEAN = vs.IsWSVisible(worksheet)
		VectorScript: FUNCTION IsWSVisible(worksheet:HANDLE) : BOOLEAN;
		
		Category: Worksheets
		Returns display status of referenced worksheet.
	'''
	pass
	return 'BOOLEAN' # Returns a BOOLEAN indicating the current visibility of the worksheet.


def JoinWalls(
		firstWall   , # HANDLE  - The first wall of the join operation. For T joins this is the wall that is extended to meet the second wall. 
		secondWall  , # HANDLE  - The second wall of the join operation.                                                                       
		firstWall1  , # POINT   - The first and second wall points are used to clarify corner joins.                                           
		secondWall2 , # POINT   - The first and second wall points are used to clarify corner joins.                                           
		joinModifier, # INTEGER - Specifies the type of join: T-join = 1, L-join = 2, X-join = 3, and auto join = 4.                           
		capped      , # BOOLEAN - True for capped joins, false for un-capped joins.                                                            
		showAlerts    # BOOLEAN - Show an alert dialog if the join operation fails.                                                            
		):
	'''
		Python: BOOLEAN = vs.JoinWalls(firstWall, secondWall, firstWall, secondWall, joinModifier, capped, showAlerts)
		VectorScript: FUNCTION JoinWalls(firstWall:HANDLE; secondWall:HANDLE; firstWallX, firstWallY:REAL; secondWallX, secondWallY:REAL; joinModifier:INTEGER; capped:BOOLEAN; showAlerts:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Walls
		This function provides a VectorScript interface to the Wall Join Tool. The parameters firstWall and secondWall are used to specify the pick points that determine which ends of the walls are to be joined, similar to the points requested by the Wall Join Tool.
	'''
	pass
	return 'BOOLEAN' # 


def KeyDown(
		):
	'''
		Python: (BOOLEAN, asciiCode) = vs.KeyDown()
		VectorScript: FUNCTION KeyDown(VAR asciiCode:LONGINT) : BOOLEAN;
		
		Category: User Interactive
		Function KeyDown returns TRUE if a non-modifier keyboard character has been depressed. When TRUE is returned, the ASCII code of the character is returned.
		Modifier keys are the Caps Lock, Command, Control, Option, and Shift keys.
	'''
	pass
	return ( False  , # 
	         0       )


def LActLayer():
	'''
		Python: HANDLE = vs.LActLayer()
		VectorScript: FUNCTION LActLayer : HANDLE;
		
		Category: Document List Handling
		Function LActLayer returns a handle to the last object in the active layer.
	'''
	pass
	return 'HANDLE' # 


def LandmarkMatchSlope(
		h          , # HANDLE -  
		h3d        , # HANDLE -  
		landmarkObj  # HANDLE -  
		):
	'''
		Python: vs.LandmarkMatchSlope(h, h3d, landmarkObj)
		VectorScript: PROCEDURE LandmarkMatchSlope(h:HANDLE; h3d:HANDLE; landmarkObj:HANDLE);
		
		Category: Utility
		Matches slope and contour angle information of a Landmark object to the specified 3D polygon.
	'''
	pass


def Layer(
		name  # STRING - Name of new or existing layer.
		):
	'''
		Python: vs.Layer(name)
		VectorScript: PROCEDURE Layer(name:STRING);
		
		Category: Layers
		Procedure Layer creates a new layer in a Vectorworks document. After creation, the new layer becomes the active layer of the document.
		Layer can also be used to switch the active layer of the document. If the layer name passed to the procedure already exists, the procedure switches the active layer to the specified layer.
	'''
	pass


def LayerRef(
		layerName  # STRING - Name of referenced layer.
		):
	'''
		Python: vs.LayerRef(layerName)
		VectorScript: PROCEDURE LayerRef(layerName:STRING);
		
		Category: Layers
		Procedure LayerRef places a layer reference (layer link) into the active layer at location (0,0).
	'''
	pass


def LckObjs():
	'''
		Python: vs.LckObjs()
		VectorScript: PROCEDURE LckObjs;
		
		Category: General Edit
		Procedure LckObjs locks the selected objects. When an object is locked, it
		may be copied or duplicated, but it may not be changed in any other way.
	'''
	pass


def LDevice_DlgResource(
		LayoutID  , # INTEGER -  
		ControlID , # INTEGER -  
		SymbolName  # STRING  -  
		):
	'''
		Python: vs.LDevice_DlgResource(LayoutID, ControlID, SymbolName)
		VectorScript: PROCEDURE LDevice_DlgResource(LayoutID:INTEGER; ControlID:INTEGER; SymbolName:STRING);
		
		Category: Spotlight
		Sets the Ligtning Device Resource selector in the pointed field
	'''
	pass


def LDevice_GetActSym():
	'''
		Python: HANDLE = vs.LDevice_GetActSym()
		VectorScript: FUNCTION LDevice_GetActSym : HANDLE;
		
		Category: Spotlight
		Get the active Ligtning symbol form the resource content
	'''
	pass
	return 'HANDLE' # 


def LDevice_Reset(
		h  # HANDLE -  
		):
	'''
		Python: vs.LDevice_Reset(h)
		VectorScript: PROCEDURE LDevice_Reset(h:HANDLE);
		
		Category: Spotlight
		Reset the specified lighting device object.
	'''
	pass


def LDevice_ResetVisual(
		h  # HANDLE -  
		):
	'''
		Python: vs.LDevice_ResetVisual(h)
		VectorScript: PROCEDURE LDevice_ResetVisual(h:HANDLE);
		
		Category: Spotlight
		Cleans up the visual/drawing cache for the specified lighting device object.
	'''
	pass


def LeftBound(
		c  # CRITERIA - Search criteria.
		):
	'''
		Python: REAL = vs.LeftBound(c)
		VectorScript: FUNCTION LeftBound(c:CRITERIA) : REAL;
		
		Category: Criteria
		Returns the x-coordinate of the bounding box (top left corner) of an object matching the search criteria. If more than one object matches the search criteria, the function will return the left value of the last matching object found.
	'''
	pass
	return 'REAL' # 


def LeftBoundN(
		c  # CRITERIA - Search criteria.
		):
	'''
		Python: REAL = vs.LeftBoundN(c)
		VectorScript: FUNCTION LeftBoundN(c:CRITERIA) : REAL;
		
		Category: Criteria
		Returns the x-coordinate of the bounding box (top left corner) of an object matching the search criteria. If more than one object matches the search criteria, the function will return the value of the coordinate of the leftmost matching object found.
	'''
	pass
	return 'REAL' # 


def LegacyShapefileExp():
	'''
		Python: vs.LegacyShapefileExp()
		VectorScript: PROCEDURE LegacyShapefileExp;
		
		Category: GIS
		Use the old UI to export shape files.
	'''
	pass


def LegacyShapefileImp():
	'''
		Python: vs.LegacyShapefileImp()
		VectorScript: PROCEDURE LegacyShapefileImp;
		
		Category: GIS
		Use the old UI to export import files.
	'''
	pass


def Len(
		v  # DYNARRAY[] of CHAR - Source string.
		):
	'''
		Python: INTEGER = vs.Len(v)
		VectorScript: FUNCTION Len(v:DYNARRAY of CHAR) : INTEGER;
		
		Category: Strings
		Function Len returns the length of the specified string value.
	'''
	pass
	return 'INTEGER' # 


def LenEncoding(
		v       , # DYNARRAY[] of CHAR - Source string.                                   
		encoding  # INTEGER            - 0 _ mac; 1 _ win; 2 _ system; 3 _ UTF8; 4 _ UTF16
		):
	'''
		Python: INTEGER = vs.LenEncoding(v, encoding)
		VectorScript: FUNCTION LenEncoding(v:DYNARRAY of CHAR; encoding:INTEGER) : INTEGER;
		
		Category: Strings
		Function LenEncoding returns the length of the specified string value in the specified encoding: 0 _ mac; 1 _ win; 2 _ system; 3 _ UTF8; 4 _ UTF16
	'''
	pass
	return 'INTEGER' # 


def Length(
		c  # CRITERIA - Search criteria.
		):
	'''
		Python: REAL = vs.Length(c)
		VectorScript: FUNCTION Length(c:CRITERIA) : REAL;
		
		Category: Criteria
		Returns the length of an object. If more than one object matches the search criteria, the function will return the sum of all the matching object lengths.
	'''
	pass
	return 'REAL' # 


def LengthN(
		c  # CRITERIA - Search criteria.
		):
	'''
		Python: REAL = vs.LengthN(c)
		VectorScript: FUNCTION LengthN(c:CRITERIA) : REAL;
		
		Category: Criteria
		Returns the length of an object. If more than one object matches the search criteria, the function will return the sum of all the matching object lengths.
	'''
	pass
	return 'REAL' # 


def LFillBack(
		color  # COLOR - RGB color component value.
		):
	'''
		Python: vs.LFillBack(color)
		VectorScript: PROCEDURE LFillBack(colorR, colorG, colorB:LONGINT);
		
		Category: Layers
		Procedure LFillBack sets the background fill color for the active layer. RGB values are in the range of 0 65535.
	'''
	pass


def LFillFore(
		color  # COLOR - RGB color component value.
		):
	'''
		Python: vs.LFillFore(color)
		VectorScript: PROCEDURE LFillFore(colorR, colorG, colorB:LONGINT);
		
		Category: Layers
		Procedure LFillFore sets the foreground fill color for the active layer. RGB values are in the range of 0 65535.
	'''
	pass


def LightingDevParamEdit():
	'''
		Python: vs.LightingDevParamEdit()
		VectorScript: PROCEDURE LightingDevParamEdit;
		
		Category: Spotlight
		Shows a dialog to edit the Lighting Device Parameters.
	'''
	pass


def LightingInvExport():
	'''
		Python: vs.LightingInvExport()
		VectorScript: PROCEDURE LightingInvExport;
		
		Category: Spotlight
		Exports Lighting inventory to data exchange file.
	'''
	pass


def LightingInvImport():
	'''
		Python: BOOLEAN = vs.LightingInvImport()
		VectorScript: FUNCTION LightingInvImport : BOOLEAN;
		
		Category: Spotlight
		Imports Lighting inventory from data exchange file. Returns TRUE if items were imported.
	'''
	pass
	return 'BOOLEAN' # 


def LightingUnivExport():
	'''
		Python: vs.LightingUnivExport()
		VectorScript: PROCEDURE LightingUnivExport;
		
		Category: Spotlight
		Exports Lighting universe settings to data exchange file.
	'''
	pass


def LightingUnivImport():
	'''
		Python: BOOLEAN = vs.LightingUnivImport()
		VectorScript: FUNCTION LightingUnivImport : BOOLEAN;
		
		Category: Spotlight
		Imports Lighting universe settings from data exchange file. Returns TRUE if any universes were changed.
	'''
	pass
	return 'BOOLEAN' # 


def LimitTolerance(
		showVal    , # BOOLEAN           - Dimension text display flag.  
		boxText    , # BOOLEAN           - Boxed text display flag.      
		leader     , # STRING            - Dimension leader text string. 
		trailer    , # STRING            - Dimension trailer text string.
		lowDistance, # REAL (Coordinate) - Tolerance value text string.  
		hiDistance   # REAL (Coordinate) - Tolerance value text string.  
		):
	'''
		Python: vs.LimitTolerance(showVal, boxText, leader, trailer, lowDistance, hiDistance)
		VectorScript: PROCEDURE LimitTolerance(showVal:BOOLEAN; boxText:BOOLEAN; leader:STRING; trailer:STRING; lowDistance:REAL (Coordinate); hiDistance:REAL (Coordinate));
		
		Category: Dimensions
		Procedure LimitTolerance is used with dimensioning procedures to define a tolerance for the most recently created dimension object.
	'''
	pass


def Line(
		line  # POINT - Offset values for line.
		):
	'''
		Python: vs.Line(line)
		VectorScript: PROCEDURE Line(lineDX, lineDY:REAL);
		
		Category: Objects - 2D
		Procedure Line creates a line object in Vectorworks. The line is drawn from the current pen position(x,y) to the specified point. The point may also be thought of as the location (x+dX,y+dY), where dX and dY are x and y offsets, respectively.
		The line object is drawn with the current default attributes unless otherwise specified.
	'''
	pass


def LinearDim(
		startPt       , # POINT             - X-Y coordinates of dimension start point.     
		endPt         , # POINT             - X-Y coordinates of dimension end point.       
		offsetDistance, # REAL (Coordinate) - Offset distance of dimension line from object.
		dimType       , # INTEGER           - Dimension type flag.                          
		arrow         , # INTEGER           - Arrowhead style flag.                         
		textFlag      , # INTEGER           - Text style flag.                              
		textOffset      # REAL              - Dimension text offset distance.               
		):
	'''
		Python: vs.LinearDim(startPt, endPt, offsetDistance, dimType, arrow, textFlag, textOffset)
		VectorScript: PROCEDURE LinearDim(startPtX, startPtY:REAL; endPtX, endPtY:REAL; offsetDistance:REAL (Coordinate); dimType:INTEGER; arrow:INTEGER; textFlag:INTEGER; textOffset:REAL);
		
		Category: Dimensions
		Procedure LinearDim creates a linear dimension in a Vectorworks document.
		<I>Linear Dimension</I><P>
	'''
	pass


def LineCircleIntersect(
		begPt , # VECTOR -  
		endPt , # VECTOR -  
		cenPt , # VECTOR -  
		radius  # REAL   -  
		):
	'''
		Python: (BOOLEAN, pt1, pt2) = vs.LineCircleIntersect(begPt, endPt, cenPt, radius)
		VectorScript: FUNCTION LineCircleIntersect(begPt:VECTOR; endPt:VECTOR; cenPt:VECTOR; radius:REAL; VAR pt1:VECTOR; VAR pt2:VECTOR) : BOOLEAN;
		
		Category: Graphic Calculation
		Finds the intersection points of a line and a circle.
	'''
	pass
	return ( False  , # 
	         0,0,0  , 
	         0,0,0   )


def LineEllipseIntersect(
		a1        , # POINT - Start point of the line         
		a2        , # POINT - End point of the line           
		upperRight, # POINT - Upper-right point of the ellipse
		lowerLeft   # POINT - Lower-left point of the ellipse 
		):
	'''
		Python: (int1, legal1, int2, legal2) = vs.LineEllipseIntersect(a1, a2, upperRight, lowerLeft)
		VectorScript: PROCEDURE LineEllipseIntersect(a1:REAL; a2:REAL; upperRight:REAL; lowerLeft:REAL; VAR int1:REAL; VAR legal1:BOOLEAN; VAR int2:REAL; VAR legal2:BOOLEAN);
		
		Category: Graphic Calculation
		Calculates the intersection between the specified line and ellipse.
	'''
	pass
	return ( 0,0  , 
	         False, 
	         0,0  , 
	         False )


def LineLineIntersection(
		l1start, # POINT - Start point of the first line 
		l1end  , # POINT - End point of the first line   
		l2start, # POINT - Start point of the second line
		l2end    # POINT - End point of the second line  
		):
	'''
		Python: (parallel, intOnLines, sectpt) = vs.LineLineIntersection(l1start, l1end, l2start, l2end)
		VectorScript: PROCEDURE LineLineIntersection(l1start:REAL; l1end:REAL; l2start:REAL; l2end:REAL; VAR parallel:BOOLEAN; VAR intOnLines:BOOLEAN; VAR sectpt:REAL);
		
		Category: Graphic Calculation
		Returns intersection point of the two specified lines.  parallel is true if the lines are parallel. intOnLines is true if the intersection is on both lines.
	'''
	pass
	return ( False, 
	         False, 
	         0,0   )


def LineTo(
		p  # POINT - Line endpoint.
		):
	'''
		Python: vs.LineTo(p)
		VectorScript: PROCEDURE LineTo(pX, pY:REAL);
		
		Category: Objects - 2D
		Procedure LineTo creates a line object in the document. LineTo draws from the current graphics pen position to the specified coordinate location. The line object is drawn with the current default attributes unless otherwise specified in the VectorScript routine.
	'''
	pass


def LinkText(
		h  , # HANDLE             - Handle to text object that will be linked to record.
		rec, # DYNARRAY[] of CHAR - Name of record that will be linked to text string.  
		fld  # DYNARRAY[] of CHAR - Name of field that will be linked to text string.   
		):
	'''
		Python: vs.LinkText(h, rec, fld)
		VectorScript: PROCEDURE LinkText(h:HANDLE; rec:DYNARRAY of CHAR; fld:DYNARRAY of CHAR);
		
		Category: Database / Record
		Creates a linked text field in a newly created symbol. The specified text is linked to a record field, whose value is displayed by the text object.
		LinkText must be called during symbol creation; the record to be associated with the linked text string must also exist at the time the link is created.
	'''
	pass


def LLayer():
	'''
		Python: HANDLE = vs.LLayer()
		VectorScript: FUNCTION LLayer : HANDLE;
		
		Category: Layers
		Function LLayer returns a handle to the last layer in a Vectorworks document.
	'''
	pass
	return 'HANDLE' # 


def Ln(
		v  # REAL - Numeric value for which to find the natural logarithm.
		):
	'''
		Python: REAL = vs.Ln(v)
		VectorScript: FUNCTION Ln(v:REAL) : REAL;
		
		Category: Math - General
		Function Ln returns the natural logarithm of the specified value.
	'''
	pass
	return 'REAL' # 


def LNewObj():
	'''
		Python: HANDLE = vs.LNewObj()
		VectorScript: FUNCTION LNewObj : HANDLE;
		
		Category: Document List Handling
		Returns a handle to the last object created by a VectorScript function call during the current script execution.
	'''
	pass
	return 'HANDLE' # Returns a HANDLE to the most recently created object, otherwise returns NIL.


def LoadCell(
		ro   , # INTEGER - Worksheet row index.   
		col  , # INTEGER - Worksheet column index.
		entry  # STRING  - Worksheet entry value. 
		):
	'''
		Python: vs.LoadCell(ro, col, entry)
		VectorScript: PROCEDURE LoadCell(ro:INTEGER; col:INTEGER; entry:STRING);
		
		Category: Worksheets
		Procedure LoadCell inserts a value into a specified cell of the active worksheet.
	'''
	pass


def LObject():
	'''
		Python: HANDLE = vs.LObject()
		VectorScript: FUNCTION LObject : HANDLE;
		
		Category: Document List Handling
		Function LObject returns a handle to the last object in the active document.
	'''
	pass
	return 'HANDLE' # 


def Locus(
		p  # POINT - Coordinate location of new locus.
		):
	'''
		Python: vs.Locus(p)
		VectorScript: PROCEDURE Locus(pX, pY:REAL);
		
		Category: Objects - 2D
		Procedure Locus creates a 2D locus object at the specified coordinate location.
	'''
	pass


def Locus3D(
		p  # POINT3D - 3D coordinates of new locus.
		):
	'''
		Python: vs.Locus3D(p)
		VectorScript: PROCEDURE Locus3D(pX, pY, pZ:REAL);
		
		Category: Objects - 3D
		Procedure Locus3D creates a new 3D locus in the document at the specified 3D coordinate location.
	'''
	pass


def LPenBack(
		color  # COLOR - RGB color component value.
		):
	'''
		Python: vs.LPenBack(color)
		VectorScript: PROCEDURE LPenBack(colorR, colorG, colorB:LONGINT);
		
		Category: Layers
		Procedure LPenBack sets the background pen color for the active layer. RGB values are in the range of 0 65535.
	'''
	pass


def LPenFore(
		color  # COLOR - RGB color component value.
		):
	'''
		Python: vs.LPenFore(color)
		VectorScript: PROCEDURE LPenFore(colorR, colorG, colorB:LONGINT);
		
		Category: Layers
		Procedure LPenFore sets the foreground pen color for the active layer. RGB values are in the range of 0 65535.
	'''
	pass


def LSActLayer():
	'''
		Python: HANDLE = vs.LSActLayer()
		VectorScript: FUNCTION LSActLayer : HANDLE;
		
		Category: Document List Handling
		Function LSActLayer returns a handle to the last selected object on the active layer. If no objects are selected,  the function returns NIL.
	'''
	pass
	return 'HANDLE' # 


def LSByClass():
	'''
		Python: vs.LSByClass()
		VectorScript: PROCEDURE LSByClass;
		
		Category: Classes
		Sets the default document line style to the line style of the active class.
	'''
	pass


def LWByClass():
	'''
		Python: vs.LWByClass()
		VectorScript: PROCEDURE LWByClass;
		
		Category: Classes
		Sets the default document line weight to the line weight of the active class.
	'''
	pass


def MakeModifierClass(
		modifierClass  # STRING -  
		):
	'''
		Python: vs.MakeModifierClass(modifierClass)
		VectorScript: PROCEDURE MakeModifierClass(modifierClass:STRING);
		
		Category: SiteModel Interface Library
		Creates special class for modifiers (if it not exists).
	'''
	pass


def MakePolygon(
		inSourceObject  # HANDLE - inSource object should be a 2D object that can be polygonalized.
		):
	'''
		Python: HANDLE = vs.MakePolygon(inSourceObject)
		VectorScript: FUNCTION MakePolygon(inSourceObject:HANDLE) : HANDLE;
		
		Category: Objects - 2D
		MakePolygon creates a 2D Polygon using inSourceObject. Does not delete inSourceObject.
	'''
	pass
	return 'HANDLE' # A polygonalized copy of inSourceObject


def MakePolyline(
		inSourceObject  # HANDLE - The 2D object from which to make a polyline.
		):
	'''
		Python: HANDLE = vs.MakePolyline(inSourceObject)
		VectorScript: FUNCTION MakePolyline(inSourceObject:HANDLE) : HANDLE;
		
		Category: Objects - 2D
		Creates a polyline using inSourceObject. inSourceObject is unchanged.
	'''
	pass
	return 'HANDLE' # A polyline representation of [[p:1]].


def Marker(
		style, # INTEGER - Marker style constant.                                                     
		size , # REAL    - Marker size in inches measured in page space.  Legal values are 0.0 to 2.0.
		ang    # INTEGER - Marker angle.                                                              
		):
	'''
		Python: vs.Marker(style, size, ang)
		VectorScript: PROCEDURE Marker(style:INTEGER; size:REAL; ang:INTEGER);
		
		Category: Document Attributes
		Marker defines a marker (arrowhead) style for the document. This marker style becomes the active style for the document.
	'''
	pass


def MarkerByClass():
	'''
		Python: vs.MarkerByClass()
		VectorScript: PROCEDURE MarkerByClass;
		
		Category: Classes
		Sets the default document marker style to the marker style of the active class.
	'''
	pass


def Max(
		val1, # REAL -  
		val2  # REAL -  
		):
	'''
		Python: REAL = vs.Max(val1, val2)
		VectorScript: FUNCTION Max(val1:REAL; val2:REAL) : REAL;
		
		Category: Math - General
		Returns the maximum of the two numbers.
	'''
	pass
	return 'REAL' # 


def MeshToGroup(
		meshObj  # HANDLE - Handle to a mesh object
		):
	'''
		Python: HANDLE = vs.MeshToGroup(meshObj)
		VectorScript: FUNCTION MeshToGroup(meshObj:HANDLE) : HANDLE;
		
		Category: Objects - 3D
		Converts meshObj to a group of 3D polygons.
	'''
	pass
	return 'HANDLE' # Returns a handle containing 3D polygons.


def Min(
		val1, # REAL -  
		val2  # REAL -  
		):
	'''
		Python: REAL = vs.Min(val1, val2)
		VectorScript: FUNCTION Min(val1:REAL; val2:REAL) : REAL;
		
		Category: Math - General
		Returns the minimum of the two numbers.
	'''
	pass
	return 'REAL' # 


def Mirror(
		h  , # HANDLE  - The object to reflect                                                                    
		dup, # BOOLEAN - If false, transform the original object to the new position. If true, create a new object
		p1 , # POINT   - An arbitrary point on the mirror axis                                                    
		p2   # POINT   - A second arbitrary point on the mirror axis                                              
		):
	'''
		Python: HANDLE = vs.Mirror(h, dup, p1, p2)
		VectorScript: FUNCTION Mirror(h:HANDLE; dup:BOOLEAN; p1:REAL; p2:REAL) : HANDLE;
		
		Category: Object Editing
		Reflect an object across an axis.
		For a 2D reflection, the axis is a line containing arbitrary point p and extending along vector v.
	'''
	pass
	return 'HANDLE' # The reflected object (this will be the same as the input object if dup is false).


def MirrorXY3D():
	'''
		Python: vs.MirrorXY3D()
		VectorScript: PROCEDURE MirrorXY3D;
		
		Category: General Edit
		Procedure MirrorXY3D mirrors the currently selected object through the XY plane.
	'''
	pass


def ModelPt2DToScreenPt(
		p  # in/out POINT -  
		):
	'''
		Python: p = vs.ModelPt2DToScreenPt(p)
		VectorScript: PROCEDURE ModelPt2DToScreenPt(VAR pX, pY:REAL);
		
		Category: Objects - 2D
		Transforms a point from world coordinate to the screen coordinates in plan rotation.
	'''
	pass
	return ( 0,0 )


def ModelVecToScreenVec(
		p  # in/out POINT -  
		):
	'''
		Python: p = vs.ModelVecToScreenVec(p)
		VectorScript: PROCEDURE ModelVecToScreenVec(VAR pX, pY:REAL);
		
		Category: Objects - 2D
		Takes Data from one space to another.
	'''
	pass
	return ( 0,0 )


def ModifySlab(
		slab          , # HANDLE  - The slab.                                                                     
		modifier      , # HANDLE  - The adding or clipping object.                                                
		isClipObject  , # BOOLEAN - Whether the modifier is an add object or a clip object.                       
		componentFlags  # LONGINT - Bit flags that indicate which components will be affected by the modification.
		):
	'''
		Python: BOOLEAN = vs.ModifySlab(slab, modifier, isClipObject, componentFlags)
		VectorScript: FUNCTION ModifySlab(slab:HANDLE; modifier:HANDLE; isClipObject:BOOLEAN; componentFlags:LONGINT) : BOOLEAN;
		
		Category: Objects - Architectural
		Adds to or clips from a slab.
	'''
	pass
	return 'BOOLEAN' # Whether or not the modification succeeds.


def Moments3D(
		object  # HANDLE - The object for which to find the 3D moments.
		):
	'''
		Python: (BOOLEAN, lxx, lyy, lzz) = vs.Moments3D(object)
		VectorScript: FUNCTION Moments3D(object:HANDLE; VAR lxx:REAL; VAR lyy:REAL; VAR lzz:REAL) : BOOLEAN;
		
		Category: Objects - 3D
		Returns the moments of inertia of a 3D object about the x, y, and z axes of a point at the center of gravity of the object.
	'''
	pass
	return ( False  , # Returns true if the function succeeded.
	         0.0    , 
	         0.0    , 
	         0.0     )


def MouseDown(
		):
	'''
		Python: (BOOLEAN, p) = vs.MouseDown()
		VectorScript: FUNCTION MouseDown(VAR pX, pY:REAL) : BOOLEAN;
		
		Category: User Interactive
		Function MouseDown returns TRUE if a mouse down event has occurred within the active document window.
	'''
	pass
	return ( False  , # 
	         0,0     )


def Move(
		move  # POINT - X-Y offset distance.
		):
	'''
		Python: vs.Move(move)
		VectorScript: PROCEDURE Move(moveDX, moveDY:REAL);
		
		Category: Command
		Sets the position of the graphics pen in the Vectorworks document by moving a specified distance from the current pen location.
		Horizontal and vertical offsets from the initial location. The final position of the pen at a point whose coordinates are (x+moveDX, y+moveDY).
	'''
	pass


def Move3D(
		xDistance, # REAL (Coordinate) - X offset distance.
		yDistance, # REAL (Coordinate) - Y offset distance.
		zDistance  # REAL (Coordinate) - Z offset ditance. 
		):
	'''
		Python: vs.Move3D(xDistance, yDistance, zDistance)
		VectorScript: PROCEDURE Move3D(xDistance:REAL (Coordinate); yDistance:REAL (Coordinate); zDistance:REAL (Coordinate));
		
		Category: Object Editing
		Procedure Move3D moves the most recently created three-dimensional object a relative distance from it's original location. The object is moved relative to its center.
	'''
	pass


def Move3DObj(
		h        , # HANDLE            - Handle to object. 
		xDistance, # REAL (Coordinate) - X offset distance.
		yDistance, # REAL (Coordinate) - Y offset distance.
		zDistance  # REAL (Coordinate) - Z offset distance.
		):
	'''
		Python: vs.Move3DObj(h, xDistance, yDistance, zDistance)
		VectorScript: PROCEDURE Move3DObj(h:HANDLE; xDistance:REAL (Coordinate); yDistance:REAL (Coordinate); zDistance:REAL (Coordinate));
		
		Category: Object Editing
		Procedure Move3DObj moves the referenced object a specified  distance from its current location. Movement distances are calculated from the 3D center of the object.
	'''
	pass


def MoveBack():
	'''
		Python: vs.MoveBack()
		VectorScript: PROCEDURE MoveBack;
		
		Category: General Edit
		Procedure MoveBack moves the selected objects to the back (bottom) of the onscreen object stacking order.
	'''
	pass


def MoveFront():
	'''
		Python: vs.MoveFront()
		VectorScript: PROCEDURE MoveFront;
		
		Category: General Edit
		Procedure MoveFront moves the selected objects to the front (top) of the onscreen object stacking order.
	'''
	pass


def MoveObjs(
		move      , # POINT   - X-Y object offset distance.               
		allLayers , # BOOLEAN - Move objects on all layers option setting.
		allObjects  # BOOLEAN - Move all objects option setting.          
		):
	'''
		Python: vs.MoveObjs(move, allLayers, allObjects)
		VectorScript: PROCEDURE MoveObjs(moveDX, moveDY:REAL; allLayers:BOOLEAN; allObjects:BOOLEAN);
		
		Category: Object Editing
		Procedure MoveObjs moves object(s) a specified offset distance. The last two parameters, allLayers and allObjects,  control which objects are offset by this procedure.
	'''
	pass


def MoveTo(
		p  # POINT - X-Y coordinate location.
		):
	'''
		Python: vs.MoveTo(p)
		VectorScript: PROCEDURE MoveTo(pX, pY:REAL);
		
		Category: Command
		Sets the position of the graphics pen in the Vectorworks document using absolute coordinate values. The parameter specifies the X-Y coordinate location where the pen should be moved.
	'''
	pass


def MoveWallByOffset(
		theWall, # HANDLE      - A handle to the wall to move.                                                                                                                                                                    
		offset   # in/out REAL - The distance to move the given wall. Negative offsets move the wall to the left and positive offsets move the wall to the right. The actual amount the wall was moved is returned in this field. 
		):
	'''
		Python: offset = vs.MoveWallByOffset(theWall, offset)
		VectorScript: PROCEDURE MoveWallByOffset(theWall:HANDLE; VAR offset:REAL);
		
		Category: Objects - Walls
		Available in Architect only. Moves the wall perpendicular to its definition line by the specified offset and maintains all wall connections. Wall movement may be constrained by the surrounding geometry so the actual amount of the offset is returned.
	'''
	pass
	return ( 0.0 )


def MoveWSColumnOperator(
		worksheet   , # HANDLE  - Handle to worksheet.       
		databaseRow , # INTEGER - Database row to be queried.
		fromColumn  , # INTEGER - From column to be queried. 
		toColumn    , # INTEGER - To column to be queried.   
		operatorType  # INTEGER - Operator type.             
		):
	'''
		Python: vs.MoveWSColumnOperator(worksheet, databaseRow, fromColumn, toColumn, operatorType)
		VectorScript: PROCEDURE MoveWSColumnOperator(worksheet:HANDLE; databaseRow:INTEGER; fromColumn:INTEGER; toColumn:INTEGER; operatorType:INTEGER);
		
		Category: Worksheets
		Moves database column operator between columns.
	'''
	pass


def Name2Index(
		name  # STRING - Name of object.
		):
	'''
		Python: LONGINT = vs.Name2Index(name)
		VectorScript: FUNCTION Name2Index(name:STRING) : LONGINT;
		
		Category: Object Names
		Function Name2Index returns the internal index number for the specified object.
	'''
	pass
	return 'LONGINT' # 


def NameClass(
		clasName   # STRING - Name of class.
		):
	'''
		Python: vs.NameClass(className)
		VectorScript: PROCEDURE NameClass(className:STRING);
		
		Category: Classes
		Creates a new class in a Vectorworks document, which then become the active class.
		If the specified class already exists, then it will become the active class of the document.
		Note:
	'''
	pass


def NameList(
		index  # LONGINT - Name list position index (in a arange of 1 - n).
		):
	'''
		Python: STRING = vs.NameList(index)
		VectorScript: FUNCTION NameList(index:LONGINT) : STRING;
		
		Category: Object Names
		Function NameList returns the specified object name from the object name list.
	'''
	pass
	return 'STRING' # 


def NameNum():
	'''
		Python: LONGINT = vs.NameNum()
		VectorScript: FUNCTION NameNum : LONGINT;
		
		Category: Object Names
		Function NameNum returns the number of different object names in the active Vectorworks document.
	'''
	pass
	return 'LONGINT' # 


def NameObject(
		objName  # STRING - Name to be assigned to object.
		):
	'''
		Python: vs.NameObject(objName)
		VectorScript: PROCEDURE NameObject(objName:STRING);
		
		Category: Object Names
		Procedure NameObject assigns an object name to the next object created.
	'''
	pass


def NameUndoEvent(
		eventName  # STRING - Name of undo event.
		):
	'''
		Python: vs.NameUndoEvent(eventName)
		VectorScript: PROCEDURE NameUndoEvent(eventName:STRING);
		
		Category: Utility
		Procedure NameUndoEvent names the undo event that is currently being built by VectorScript execution. Parameter eventName is the name of the undo event.
	'''
	pass


def NewField(
		recName   , # DYNARRAY[] of CHAR - Name of record to which field will be added. 
		fieldName , # DYNARRAY[] of CHAR - Name of new field.                           
		fieldValue, # DYNARRAY[] of CHAR - Default value for new field.                 
		fType     , # INTEGER            - Data type of new field.                      
		fFlag       # INTEGER            - Display style of field.                      
		):
	'''
		Python: vs.NewField(recName, fieldName, fieldValue, fType, fFlag)
		VectorScript: PROCEDURE NewField(recName:DYNARRAY of CHAR; fieldName:DYNARRAY of CHAR; fieldValue:DYNARRAY of CHAR; fType:INTEGER; fFlag:INTEGER);
		
		Category: Database / Record
		Creates a new field in a specified record format. If the record does not exist, a new one is created using the specified record name.
	'''
	pass


def NewSprdSheet(
		name           , # STRING  - Name of new worksheet.        
		location       , # POINT   - Insertion point of worksheet. 
		rows           , # INTEGER - Number of rows.               
		columns        , # INTEGER - Number of columns.            
		showOnDrawing  , # BOOLEAN - Display worksheet in document.
		openAfterCreate  # BOOLEAN - Open worksheet after creation.
		):
	'''
		Python: vs.NewSprdSheet(name, location, rows, columns, showOnDrawing, openAfterCreate)
		VectorScript: PROCEDURE NewSprdSheet(name:STRING; locationX, locationY:REAL; rows:INTEGER; columns:INTEGER; showOnDrawing:BOOLEAN; openAfterCreate:BOOLEAN);
		
		Category: Worksheets
		Procedure NewSprdSheet creates a new worksheet in a Vectorworks document.
	'''
	pass


def NextDObj(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: HANDLE = vs.NextDObj(h)
		VectorScript: FUNCTION NextDObj(h:HANDLE) : HANDLE;
		
		Category: Document List Handling
		Function NextDObj returns the next deselected object after the referenced object in a list. If the end of the list is reached, the function returns NIL.
	'''
	pass
	return 'HANDLE' # 


def NextLayer(
		h  # HANDLE - Handle to layer.
		):
	'''
		Python: HANDLE = vs.NextLayer(h)
		VectorScript: FUNCTION NextLayer(h:HANDLE) : HANDLE;
		
		Category: Document List Handling
		Function NextLayer returns a handle to the next layer in the document after the referenced. If the end of the list has been reached, the function returns NIL.
	'''
	pass
	return 'HANDLE' # 


def NextObj(
		h  # HANDLE - Handle to object,  group, or  symbol definition.
		):
	'''
		Python: HANDLE = vs.NextObj(h)
		VectorScript: FUNCTION NextObj(h:HANDLE) : HANDLE;
		
		Category: Document List Handling
		Function NextObj returns the next object in any list . If the end of the list is reached, the function returns NIL. This procedure can be used with other handle routines such as FirstIn3D,FInGroup, FirstInSymDef, or FLayer.
	'''
	pass
	return 'HANDLE' # 


def NextSObj(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: HANDLE = vs.NextSObj(h)
		VectorScript: FUNCTION NextSObj(h:HANDLE) : HANDLE;
		
		Category: Document List Handling
		Function NextSObj returns the next selected object in a list. If the end of the list is reached, the function returns NIL.
	'''
	pass
	return 'HANDLE' # 


def NextSymDef(
		symHd  # HANDLE - Handle to symbol definition in library.
		):
	'''
		Python: HANDLE = vs.NextSymDef(symHd)
		VectorScript: FUNCTION NextSymDef(symHd:HANDLE) : HANDLE;
		
		Category: Document List Handling
		Function NextSymDef returns a handle to the next definition in the symbol library after the referenced symbol. If the end of the list has been reached, the function returns NIL.
	'''
	pass
	return 'HANDLE' # 


def NonUndoableActionOK():
	'''
		Python: BOOLEAN = vs.NonUndoableActionOK()
		VectorScript: FUNCTION NonUndoableActionOK : BOOLEAN;
		
		Category: Dialogs - Predefined
		Function NonUndoableActionOK displays a dialog informing the user that the action that is about to be performed cannot be undone. If the user selects OK, the function returns TRUE. If the "Show Undo Warnings" preference is turned off, this function just returns TRUE and does not display a dialog.
	'''
	pass
	return 'BOOLEAN' # 


def Norm(
		Vec  # VECTOR - Vector to be measured.
		):
	'''
		Python: REAL = vs.Norm(Vec)
		VectorScript: FUNCTION Norm(Vec:VECTOR) : REAL;
		
		Category: Math - Vectors
		Returns the length, or magnitude, of the specified vector.
	'''
	pass
	return 'REAL' # A REAL value which is the length of the vector.


def NotifyPullDownClicked(
		nDialogID   , # LONGINT -  
		nComponentID  # LONGINT -  
		):
	'''
		Python: vs.NotifyPullDownClicked(nDialogID, nComponentID)
		VectorScript: PROCEDURE NotifyPullDownClicked(nDialogID:LONGINT; nComponentID:LONGINT);
		
		Category: Dialogs - Modern
		Sends an item hit notification when the pull down menu is clicked, allowing developers to dynamically populate the menu.
	'''
	pass


def Num2Str(
		decPlace, # INTEGER - Number of decimal places.
		v         # REAL    - Numeric value.           
		):
	'''
		Python: STRING = vs.Num2Str(decPlace, v)
		VectorScript: FUNCTION Num2Str(decPlace:INTEGER; v:REAL) : STRING;
		
		Category: Strings
		Function Num2Str converts a REAL value to a string and returns the value.
		Parameter decPlace has a range of -1 to 10; if -1 is specified, the value will be returned in scientific notation.
	'''
	pass
	return 'STRING' # 


def Num2StrF(
		vDistance  # REAL (Coordinate) - Numeric value.
		):
	'''
		Python: STRING = vs.Num2StrF(vDistance)
		VectorScript: FUNCTION Num2StrF(vDistance:REAL (Coordinate)) : STRING;
		
		Category: Strings
		Function Num2StrF converts a specified REAL value into a string. The numeric value will be converted and displayed in the current unit settings of the drawing.
	'''
	pass
	return 'STRING' # 


def NumColors():
	'''
		Python: INTEGER = vs.NumColors()
		VectorScript: FUNCTION NumColors : INTEGER;
		
		Category: Document Attributes
		Returns the last used color index in the current document.
	'''
	pass
	return 'INTEGER' # 


def NumCustomObjectChoices(
		objectName   , # STRING - Name of plugin object.           
		parameterName  # STRING - String indicating which parameter
		):
	'''
		Python: INTEGER = vs.NumCustomObjectChoices(objectName, parameterName)
		VectorScript: FUNCTION NumCustomObjectChoices(objectName:STRING; parameterName:STRING) : INTEGER;
		
		Category: Objects - Custom
		Function NumCustomObjectChoices returns the number of choice strings for a specified popup menu or radio group parameter in a plug-in object.
	'''
	pass
	return 'INTEGER' # 


def NumDashStyles():
	'''
		Python: INTEGER = vs.NumDashStyles()
		VectorScript: FUNCTION NumDashStyles : INTEGER;
		
		Category: Document Attributes
		Function NumDashStyles returns the number of available line dash patterns.
	'''
	pass
	return 'INTEGER' # 


def NumFields(
		h  # HANDLE - Handle to record.
		):
	'''
		Python: INTEGER = vs.NumFields(h)
		VectorScript: FUNCTION NumFields(h:HANDLE) : INTEGER;
		
		Category: Database / Record
		Returns the number of fields in the referenced record.
	'''
	pass
	return 'INTEGER' # 


def NumLayers():
	'''
		Python: INTEGER = vs.NumLayers()
		VectorScript: FUNCTION NumLayers : INTEGER;
		
		Category: Layers
		Function NumLayers returns the current number of layers within the active document.
	'''
	pass
	return 'INTEGER' # 


def NumObj(
		h  # HANDLE - Handle to layer.
		):
	'''
		Python: LONGINT = vs.NumObj(h)
		VectorScript: FUNCTION NumObj(h:HANDLE) : LONGINT;
		
		Category: Layers
		Function NumObj returns the number of objects on the referenced layer.
	'''
	pass
	return 'LONGINT' # 


def NumRecords(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: INTEGER = vs.NumRecords(h)
		VectorScript: FUNCTION NumRecords(h:HANDLE) : INTEGER;
		
		Category: Database / Record
		Returns the number of records attached to the referenced object.
	'''
	pass
	return 'INTEGER' # 


def NumSelectedObjects():
	'''
		Python: LONGINT = vs.NumSelectedObjects()
		VectorScript: FUNCTION NumSelectedObjects : LONGINT;
		
		Category: Selection
		Returns the number of selected objects in all working layers.
	'''
	pass
	return 'LONGINT' # 


def NumSObj(
		h  # HANDLE - Handle to layer.
		):
	'''
		Python: LONGINT = vs.NumSObj(h)
		VectorScript: FUNCTION NumSObj(h:HANDLE) : LONGINT;
		
		Category: Selection
		Function NumSObj returns the number of selected objects on the referenced layer.
	'''
	pass
	return 'LONGINT' # 


def NumVectorFills():
	'''
		Python: LONGINT = vs.NumVectorFills()
		VectorScript: FUNCTION NumVectorFills : LONGINT;
		
		Category: Hatches / Vector Fills
		Function NumVectorFills returns the number of vector fills in the active document.
	'''
	pass
	return 'LONGINT' # 


def NurbsCurveEvalPt(
		objectHd, # HANDLE  - Handle to a NURBS curve.                             
		index   , # LONGINT - Segment of curve to be queried.                      
		u         # REAL    - Parameter between the minimum and maximum knot value.
		):
	'''
		Python: p = vs.NurbsCurveEvalPt(objectHd, index, u)
		VectorScript: PROCEDURE NurbsCurveEvalPt(objectHd:HANDLE; index:LONGINT; u:REAL; VAR pX, pY, pZ:REAL);
		
		Category: Objects - NURBS
		This procedure determines the point on the nurbs curve at the given u value in the indexed piece.
		The index is zero based (0 to number of knots - 1). The u value can range from 0 to the value of the last knot in the curve segment.
	'''
	pass
	return ( 0,0,0 )


def NurbsCurveGetNumPieces(
		objectHd  # HANDLE - Handle to NURBS curve.
		):
	'''
		Python: INTEGER = vs.NurbsCurveGetNumPieces(objectHd)
		VectorScript: FUNCTION NurbsCurveGetNumPieces(objectHd:HANDLE) : INTEGER;
		
		Category: Objects - NURBS
		Returns the number of pieces that compose the referenced NURBS curve.
	'''
	pass
	return 'INTEGER' # An INTEGER count of the pieces composing the curve.


def NurbsCurveType(
		objectHd, # HANDLE  - Handle to NURBS curve. 
		index     # LONGINT - Index of curve segment.
		):
	'''
		Python: isByFit = vs.NurbsCurveType(objectHd, index)
		VectorScript: PROCEDURE NurbsCurveType(objectHd:HANDLE; index:LONGINT; VAR isByFit:BOOLEAN);
		
		Category: Objects - NURBS
		Returns the curve type of a segment of the referenced NURBS curve.
		The index is zero based (0 to number of segments - 1).
	'''
	pass
	return ( False )


def NurbsDegree(
		objectHd, # HANDLE  - Handle to NURBS curve or surface.                                       
		index     # INTEGER - Index of curve segment (NURBS curve) or direction index (NURBS surface).
		):
	'''
		Python: INTEGER = vs.NurbsDegree(objectHd, index)
		VectorScript: FUNCTION NurbsDegree(objectHd:HANDLE; index:INTEGER) : INTEGER;
		
		Category: Objects - NURBS
		Returns the degree of a segment in a NURBS curve or surface.
		For NURBS curves, the index indicates which segment of the curve is to be queried. The index is zero based (0 to number of segments - 1).
		For NURBS surfaces, specify an index of 1 to indicate u-direction, and an index of 0 to indicate v-direction when querying the surface object.
	'''
	pass
	return 'INTEGER' # The degree of the segment as an INTEGER value.


def NurbsDelVertex(
		objectHd, # HANDLE  - Handle to NURBS curve or surface.                                     
		index1  , # LONGINT - Index of point in NURBS curve, or U-index of a point in NURBS surface.
		index2    # LONGINT - V-index of point in NURBS surface.                                    
		):
	'''
		Python: vs.NurbsDelVertex(objectHd, index1, index2)
		VectorScript: PROCEDURE NurbsDelVertex(objectHd:HANDLE; index1:LONGINT; index2:LONGINT);
		
		Category: Objects - NURBS
		Deletes a point in the referenced NURBS curve or surface.
		The index is zero based (0 to number of points - 1).
	'''
	pass


def NurbsGetNumPts(
		objectHd, # HANDLE  - Handle to NURBS curve or surface.                                       
		index     # LONGINT - Index of curve segment (NURBS curve) or direction index (NURBS surface).
		):
	'''
		Python: LONGINT = vs.NurbsGetNumPts(objectHd, index)
		VectorScript: FUNCTION NurbsGetNumPts(objectHd:HANDLE; index:LONGINT) : LONGINT;
		
		Category: Objects - NURBS
		Returns the number of points for segment of the referenced NURBS curve, or the number of points of the referenced NURBS surface in the u- or v-direction.
		For NURBS curves, the index indicates which segment of the curve is to be queried. The index is zero based (0 to number of segments - 1).
		For NURBS surfaces, specify an index of 1 to indicate u-direction, and an index of 0 to indicate v-direction when querying the surface object.
	'''
	pass
	return 'LONGINT' # The number of control points as a LONGINT value.


def NurbsGetPt3D(
		objectHd, # HANDLE  - Handle to NURBS curve or surface.                                                 
		index1  , # LONGINT - Index of point in NURBS curve, or u-coordinate of point location in NURBS surface.
		index2    # LONGINT - V-coordinate of point location in NURBS surface.                                  
		):
	'''
		Python: p = vs.NurbsGetPt3D(objectHd, index1, index2)
		VectorScript: PROCEDURE NurbsGetPt3D(objectHd:HANDLE; index1:LONGINT; index2:LONGINT; VAR pX, pY, pZ:REAL);
		
		Category: Objects - NURBS
		Returns the coordinates of a point in the referenced NURBS curve or surface.
		The index is zero based (0 to number of points - 1).
	'''
	pass
	return ( 0,0,0 )


def NurbsGetWeight(
		objectHd, # HANDLE  - Handle to NURBS curve or surface.                                        
		index1  , # LONGINT - Segment of curve to be queried (NURBS curve), or u-index (NURBS surface).
		index2    # LONGINT - Index of point (NURBS curve) or v-index (NURBS surface).                 
		):
	'''
		Python: weight = vs.NurbsGetWeight(objectHd, index1, index2)
		VectorScript: PROCEDURE NurbsGetWeight(objectHd:HANDLE; index1:LONGINT; index2:LONGINT; VAR weight:REAL);
		
		Category: Objects - NURBS
		Returns the weight of a point in a NURBS curve or surface.
		For NURBS curves, index1 corresponds to the segment of the curve to be queried, and index2 corresponds to the index of the point in the segment.
		For NURBS surfaces, index1 corresponds to the u-index and index2 corresponds to the v-index of the surface.
		The index is zero based (0 to number of points - 1).
	'''
	pass
	return ( 0.0 )


def NurbsKnot(
		objectHd, # HANDLE  - Handle to NURBS curve or surface.                                          
		index1  , # LONGINT - Segment of curve to be queried (NURBS curve), or direction (NURBS surface).
		index2    # LONGINT - Index of segment or direction knot.                                        
		):
	'''
		Python: knot = vs.NurbsKnot(objectHd, index1, index2)
		VectorScript: PROCEDURE NurbsKnot(objectHd:HANDLE; index1:LONGINT; index2:LONGINT; VAR knot:REAL);
		
		Category: Objects - NURBS
		Returns the specified knot in a NURBS curve or surface.
		For NURBS curves, index1 corresponds to the segment of the curve to be queried, and index2 corresponds to the knot in the segment.
		For NURBS surfaces, index1 corresponds to the u- or v-direction of the surface (u=1, v=0), and index2 corresponds to the knot index.
		The index is zero based (0 to number of knots - 1).
	'''
	pass
	return ( 0.0 )


def NurbsNumKnots(
		objectHd, # HANDLE  - Handle to NURBS curve or surface.         
		index     # LONGINT - Index of curve, or U/V choice for surface.
		):
	'''
		Python: LONGINT = vs.NurbsNumKnots(objectHd, index)
		VectorScript: FUNCTION NurbsNumKnots(objectHd:HANDLE; index:LONGINT) : LONGINT;
		
		Category: Objects - NURBS
		Returns the number of knots for the referenced NURBS curve or surface. If the object is a curve, then index indicates the segment of the curve to consider. If the object is a surface, then the index indicates the U direction (for index = 1) or the V direction (for index = 0).
	'''
	pass
	return 'LONGINT' # 


def NurbsSetKnot(
		objectHd, # HANDLE  - Handle to NURBS curve or surface.                                          
		index1  , # LONGINT - Segment of curve to be queried (NURBS curve), or direction (NURBS surface).
		index2  , # LONGINT - Index of segment or direction knot.                                        
		knot      # REAL    - Knot value.                                                                
		):
	'''
		Python: vs.NurbsSetKnot(objectHd, index1, index2, knot)
		VectorScript: PROCEDURE NurbsSetKnot(objectHd:HANDLE; index1:LONGINT; index2:LONGINT; knot:REAL);
		
		Category: Objects - NURBS
		Sets the specified knot in a NURBS curve or surface.
		For NURBS curves, index1 corresponds to a segment of the curve, and index2 corresponds to the knot in the segment.
		For NURBS surfaces, index1 corresponds to the u- or v-direction of the surface and index2 corresponds to the knot.
		The index is zero based (0 to number of knots - 1).
	'''
	pass


def NurbsSetPt3D(
		objectHd, # HANDLE  - Handle to NURBS curve or surface.                                                 
		index1  , # LONGINT - Index of point in NURBS curve, or u-coordinate of point location in NURBS surface.
		index2  , # LONGINT - V-coordinate of point location in NURBS surface.                                  
		p         # POINT3D - New coordinates for the point.                                                    
		):
	'''
		Python: vs.NurbsSetPt3D(objectHd, index1, index2, p)
		VectorScript: PROCEDURE NurbsSetPt3D(objectHd:HANDLE; index1:LONGINT; index2:LONGINT; pX, pY, pZ:REAL);
		
		Category: Objects - NURBS
		Sets the coordinates of a point in the referenced NURBS curve or surface.
		The index is zero based (0 to number of points - 1).
		For a nurbs curve, index1 is the piece number of the nurbs curve. Index2 is the vertex number within that piece. NurbsCurveGetNumPieces will give you the number of pieces inside of the nurbs curve (1-based). NurbsGetNumPts will give you the number of points inside of a piece.
	'''
	pass


def NurbsSetWeight(
		objectHd, # HANDLE  - Handle to NURBS curve or surface.                                        
		index1  , # LONGINT - Segment of curve to be queried (NURBS curve), or u-index (NURBS surface).
		index2  , # LONGINT - Index of point (NURBS curve) or v-index (NURBS surface).                 
		weight    # REAL    - New weight of point.                                                     
		):
	'''
		Python: vs.NurbsSetWeight(objectHd, index1, index2, weight)
		VectorScript: PROCEDURE NurbsSetWeight(objectHd:HANDLE; index1:LONGINT; index2:LONGINT; weight:REAL);
		
		Category: Objects - NURBS
		Sets the weight of a point in a NURBS curve or surface.
		For NURBS curves, index1 corresponds to the segment of the curve to be queried, and index2 corresponds to the index of the point in the segment.
		For NURBS surfaces, index1 corresponds to the u-index and index2 corresponds to the v-index of the surface.
		The index is zero based (0 to number of points - 1).
	'''
	pass


def NurbsSurfaceEvalPt(
		objectHd, # HANDLE - Handle to a NURBS surface.                                          
		u       , # REAL   - Parameter between the minimum and maximum knot value in U direction.
		v         # REAL   - Parameter between the minimum and maximum knot value in V direction.
		):
	'''
		Python: p = vs.NurbsSurfaceEvalPt(objectHd, u, v)
		VectorScript: PROCEDURE NurbsSurfaceEvalPt(objectHd:HANDLE; u:REAL; v:REAL; VAR pX, pY, pZ:REAL);
		
		Category: Objects - NURBS
		This procedure determines the point on the nurbs surface at the given u,v values.
		The u vand v values can range from 0 to the value of the last knot in each direction.
	'''
	pass
	return ( 0,0,0 )


def ObjArea(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: REAL = vs.ObjArea(h)
		VectorScript: FUNCTION ObjArea(h:HANDLE) : REAL;
		
		Category: Object Info
		Function ObjArea returns the area of the referenced object.
	'''
	pass
	return 'REAL' # 


def ObjAreaN(
		ObjectHandle   # HANDLE -  
		):
	'''
		Python: REAL = vs.ObjAreaN(ObjectHandle )
		VectorScript: FUNCTION ObjAreaN(ObjectHandle :HANDLE) : REAL;
		
		Category: Object Info
		HObjAreaN, this VS Call is the same as HOBJArea() call but it gives more accurate result when the object is a polyline.
	'''
	pass
	return 'REAL' # 


def ObjectType(
		c  # CRITERIA - Search criteria.
		):
	'''
		Python: INTEGER = vs.ObjectType(c)
		VectorScript: FUNCTION ObjectType(c:CRITERIA) : INTEGER;
		
		Category: Criteria
		Returns the type identifier an object. If more than one object matches the search criteria, the type identifier of the last matching object will be returned.
	'''
	pass
	return 'INTEGER' # 


def ObjPropsEditDlg(
		hObj  # HANDLE - The object which properties will be edited.
		):
	'''
		Python: BOOLEAN = vs.ObjPropsEditDlg(hObj)
		VectorScript: FUNCTION ObjPropsEditDlg(hObj:HANDLE) : BOOLEAN;
		
		Category: Utility
		Show object properties edit dialog.
	'''
	pass
	return 'BOOLEAN' # Return TRUE if the edit was successful.


def ObjSurfaceArea(
		solidObject  # HANDLE - Handle to solids object.
		):
	'''
		Python: REAL = vs.ObjSurfaceArea(solidObject)
		VectorScript: FUNCTION ObjSurfaceArea(solidObject:HANDLE) : REAL;
		
		Category: Objects - Solids
		Function ObjSurfaceArea calculates the surface area of the referenced solid object. The function supports only valid solids objects.
	'''
	pass
	return 'REAL' # 


def ObjVolume(
		solidObject  # HANDLE - Handle to solids object.
		):
	'''
		Python: REAL = vs.ObjVolume(solidObject)
		VectorScript: FUNCTION ObjVolume(solidObject:HANDLE) : REAL;
		
		Category: Objects - Solids
		Function ObjVolume calculates the volume of the referenced solid object. The function supports only valid solids objects.
	'''
	pass
	return 'REAL' # 


def OffsetHandle(
		h               , # HANDLE  -  
		offsetDistance  , # REAL    -  
		EdgeRestoration , # BOOLEAN -  
		FilletSharpEdges  # BOOLEAN -  
		):
	'''
		Python: HANDLE = vs.OffsetHandle(h, offsetDistance, EdgeRestoration, FilletSharpEdges)
		VectorScript: FUNCTION OffsetHandle(h:HANDLE; offsetDistance:REAL; EdgeRestoration:BOOLEAN; FilletSharpEdges:BOOLEAN) : HANDLE;
		
		Category: Object Editing
		Creates a group of lines which represent the weighted medial axis of given polygon.
	'''
	pass
	return 'HANDLE' # 


def OffsetPoly(
		h                     , # HANDLE  -  
		offsetDistance        , # REAL    -  
		numberOfOffsets       , # INTEGER -  
		consolidateVertices   , # BOOLEAN -  
		sharpCorners          , # BOOLEAN -  
		conversionRes         , # INTEGER -  
		consolidationTolerance  # REAL    -  
		):
	'''
		Python: HANDLE = vs.OffsetPoly(h, offsetDistance, numberOfOffsets, consolidateVertices, sharpCorners, conversionRes, consolidationTolerance)
		VectorScript: FUNCTION OffsetPoly(h:HANDLE; offsetDistance:REAL; numberOfOffsets:INTEGER; consolidateVertices:BOOLEAN; sharpCorners:BOOLEAN; conversionRes:INTEGER; consolidationTolerance:REAL) : HANDLE;
		
		Category: Graphic Calculation
		Offsets a polygon or polyline. Must handle open & closed polys. A positive distance offsets to the outside; negative to the inside. Should remove self-intersecting segments from the result. Should support smooth vs. sharp offsets.
	'''
	pass
	return 'HANDLE' # 


def OffsetPolyClosed(
		obj          , # HANDLE  -  
		offset       , # REAL    -  
		smoothCorners  # BOOLEAN -  
		):
	'''
		Python: HANDLE = vs.OffsetPolyClosed(obj, offset, smoothCorners)
		VectorScript: FUNCTION OffsetPolyClosed(obj:HANDLE; offset:REAL; smoothCorners:BOOLEAN) : HANDLE;
		
		Category: Objects - 2D
		Offsets a polyline or polygon, then uses the original geometry to construct a closed profile.
	'''
	pass
	return 'HANDLE' # 


def OffsetPolyN(
		h             , # HANDLE  -  
		offsetDistance, # REAL    -  
		smoothCorners   # BOOLEAN -  
		):
	'''
		Python: HANDLE = vs.OffsetPolyN(h, offsetDistance, smoothCorners)
		VectorScript: FUNCTION OffsetPolyN(h:HANDLE; offsetDistance:REAL; smoothCorners:BOOLEAN) : HANDLE;
		
		Category: Graphic Calculation
		Offsets a polygon or polyline. Uses Parasolid to do it. Equivalent of Voronoy based OffsetPoly.
	'''
	pass
	return 'HANDLE' # 


def OLDAddLoadHangPoint(
		handle   , # HANDLE  -  
		loadIndex, # INTEGER -  
		point    , # VECTOR  -  
		hasLoad    # BOOLEAN -  
		):
	'''
		Python: vs.OLDAddLoadHangPoint(handle, loadIndex, point, hasLoad)
		VectorScript: PROCEDURE OLDAddLoadHangPoint(handle:HANDLE; loadIndex:INTEGER; point:VECTOR; hasLoad:BOOLEAN);
		
		Category: Truss Analysis
		Adds hang point of the specified load for the parametric object
	'''
	pass


def OLDClearHangPtsPath(
		handle   , # HANDLE  -  
		loadIndex  # INTEGER -  
		):
	'''
		Python: vs.OLDClearHangPtsPath(handle, loadIndex)
		VectorScript: PROCEDURE OLDClearHangPtsPath(handle:HANDLE; loadIndex:INTEGER);
		
		Category: Truss Analysis
		Clears the hang points of the specified load for the parametric object
	'''
	pass


def OLDConstructMatsCnt():
	'''
		Python: LONGINT = vs.OLDConstructMatsCnt()
		VectorScript: FUNCTION OLDConstructMatsCnt : LONGINT;
		
		Category: Truss Analysis
		Returns the count of the construction materials available for truss analysis.
	'''
	pass
	return 'LONGINT' # 


def OLDFindAttachHangPos(
		handle   , # HANDLE  -  
		loadIndex  # INTEGER -  
		):
	'''
		Python: HANDLE = vs.OLDFindAttachHangPos(handle, loadIndex)
		VectorScript: FUNCTION OLDFindAttachHangPos(handle:HANDLE; loadIndex:INTEGER) : HANDLE;
		
		Category: Truss Analysis
		Searches for a Hanging Position for the Hang Points of the given load index. Returns the Position handle if found, NIL otherwise.
	'''
	pass
	return 'HANDLE' # 


def OLDForceRealToStr(
		forceValue  # REAL -  
		):
	'''
		Python: STRING = vs.OLDForceRealToStr(forceValue)
		VectorScript: FUNCTION OLDForceRealToStr(forceValue:REAL) : STRING;
		
		Category: Truss Analysis
		Converts force real value to string and returns TRUE on success.
	'''
	pass
	return 'STRING' # 


def OLDForceStrToReal(
		forceString  # STRING -  
		):
	'''
		Python: (BOOLEAN, realValue) = vs.OLDForceStrToReal(forceString)
		VectorScript: FUNCTION OLDForceStrToReal(forceString:STRING; VAR realValue:REAL) : BOOLEAN;
		
		Category: Truss Analysis
		Converts force string to real number and returns the result.
	'''
	pass
	return ( False  , # 
	         0.0     )


def OLDGetConstructMat(
		materialIndex  # LONGINT -  
		):
	'''
		Python: (UniversalName, LocalizedName) = vs.OLDGetConstructMat(materialIndex)
		VectorScript: PROCEDURE OLDGetConstructMat(materialIndex:LONGINT; VAR UniversalName:STRING; VAR LocalizedName:STRING);
		
		Category: Truss Analysis
		Returns the universal and the localized names of the construction material at the given index.
	'''
	pass
	return ( 'string', 
	         'string' )


def OLDGetDragSnapPoint(
		):
	'''
		Python: (BOOLEAN, point) = vs.OLDGetDragSnapPoint()
		VectorScript: FUNCTION OLDGetDragSnapPoint(VAR point:VECTOR) : BOOLEAN;
		
		Category: Truss Analysis
		If the object has been dragged and snapped, the fuction will return TRUE and the point parameter will contain the snapping location.
	'''
	pass
	return ( False  , # 
	         0,0,0   )


def OLDGetHangingPos(
		handle   , # HANDLE  -  
		loadIndex  # INTEGER -  
		):
	'''
		Python: HANDLE = vs.OLDGetHangingPos(handle, loadIndex)
		VectorScript: FUNCTION OLDGetHangingPos(handle:HANDLE; loadIndex:INTEGER) : HANDLE;
		
		Category: Truss Analysis
		Returns handle of the Hanging Position where the specified load is attached.
	'''
	pass
	return 'HANDLE' # 


def OLDGetHangPointAt(
		handle    , # HANDLE  -  
		loadIndex , # INTEGER -  
		pointIndex  # LONGINT -  
		):
	'''
		Python: (point, hasLoad) = vs.OLDGetHangPointAt(handle, loadIndex, pointIndex)
		VectorScript: PROCEDURE OLDGetHangPointAt(handle:HANDLE; loadIndex:INTEGER; pointIndex:LONGINT; VAR point:VECTOR; VAR hasLoad:BOOLEAN);
		
		Category: Truss Analysis
		Get hang point for given index of the specified load for the parametric object
	'''
	pass
	return ( 0,0,0, 
	         False )


def OLDGetHangPointsCnt(
		handle   , # HANDLE  -  
		loadIndex  # INTEGER -  
		):
	'''
		Python: LONGINT = vs.OLDGetHangPointsCnt(handle, loadIndex)
		VectorScript: FUNCTION OLDGetHangPointsCnt(handle:HANDLE; loadIndex:INTEGER) : LONGINT;
		
		Category: Truss Analysis
		Get hang points cout of the specified load for the parametric object
	'''
	pass
	return 'LONGINT' # 


def OLDGetLoadDataBool(
		handle   , # HANDLE  -  
		selector , # INTEGER -  
		loadIndex  # INTEGER -  
		):
	'''
		Python: BOOLEAN = vs.OLDGetLoadDataBool(handle, selector, loadIndex)
		VectorScript: FUNCTION OLDGetLoadDataBool(handle:HANDLE; selector:INTEGER; loadIndex:INTEGER) : BOOLEAN;
		
		Category: Truss Analysis
		Using selector, gets load data with bool value for the parametric object
	'''
	pass
	return 'BOOLEAN' # 


def OLDGetLoadDataReal(
		handle   , # HANDLE  -  
		selector , # INTEGER -  
		loadIndex  # INTEGER -  
		):
	'''
		Python: REAL = vs.OLDGetLoadDataReal(handle, selector, loadIndex)
		VectorScript: FUNCTION OLDGetLoadDataReal(handle:HANDLE; selector:INTEGER; loadIndex:INTEGER) : REAL;
		
		Category: Truss Analysis
		Using selector, gets load data with real value for the parametric object
	'''
	pass
	return 'REAL' # 


def OLDGetLoadDataStr(
		handle   , # HANDLE  -  
		selector , # INTEGER -  
		loadIndex  # INTEGER -  
		):
	'''
		Python: STRING = vs.OLDGetLoadDataStr(handle, selector, loadIndex)
		VectorScript: FUNCTION OLDGetLoadDataStr(handle:HANDLE; selector:INTEGER; loadIndex:INTEGER) : STRING;
		
		Category: Truss Analysis
		Using selector, gets load data with string value for the parametric object
	'''
	pass
	return 'STRING' # 


def OLDGetMatDestiny(
		materialName  # STRING -  
		):
	'''
		Python: REAL = vs.OLDGetMatDestiny(materialName)
		VectorScript: FUNCTION OLDGetMatDestiny(materialName:STRING) : REAL;
		
		Category: Truss Analysis
		Returns the destiny of the specified construction material.
	'''
	pass
	return 'REAL' # 


def OLDGetPositionTransf(
		handle   , # HANDLE  -  
		loadIndex  # INTEGER -  
		):
	'''
		Python: (BOOLEAN, offsetDistance, rotationAngle, hasWitnessLine) = vs.OLDGetPositionTransf(handle, loadIndex)
		VectorScript: FUNCTION OLDGetPositionTransf(handle:HANDLE; loadIndex:INTEGER; VAR offsetDistance:VECTOR; VAR rotationAngle:REAL; VAR hasWitnessLine:BOOLEAN) : BOOLEAN;
		
		Category: Truss Analysis
		Retunrs TRUE if the position, where the load is attached, is moved/rotated. Get the offset applied to the load in object local coordinates and the rotataion angle applied to the position. HasWitnessLine point weather the object is alredy connected via a witness line
	'''
	pass
	return ( False  , # 
	         0,0,0  , 
	         0.0    , 
	         False   )


def OLDHoistSectionDlg(
		):
	'''
		Python: (BOOLEAN, crossSection) = vs.OLDHoistSectionDlg()
		VectorScript: FUNCTION OLDHoistSectionDlg(VAR crossSection:STRING) : BOOLEAN;
		
		Category: Truss Analysis
		Show Hoist Cross Section dialog.
	'''
	pass
	return ( False   , # 
	         'string' )


def OLDMassDistRealToStr(
		distrMassValue  # REAL -  
		):
	'''
		Python: STRING = vs.OLDMassDistRealToStr(distrMassValue)
		VectorScript: FUNCTION OLDMassDistRealToStr(distrMassValue:REAL) : STRING;
		
		Category: Truss Analysis
		Converts distributed mass real value to string and returns TRUE on success.
	'''
	pass
	return 'STRING' # 


def OLDMassDistStrToReal(
		distrMassString  # STRING -  
		):
	'''
		Python: (BOOLEAN, realValue) = vs.OLDMassDistStrToReal(distrMassString)
		VectorScript: FUNCTION OLDMassDistStrToReal(distrMassString:STRING; VAR realValue:REAL) : BOOLEAN;
		
		Category: Truss Analysis
		Converts distributed mass string to real number and returns TRUE on success.
	'''
	pass
	return ( False  , # 
	         0.0     )


def OLDMassRealToStr(
		massValue  # REAL -  
		):
	'''
		Python: STRING = vs.OLDMassRealToStr(massValue)
		VectorScript: FUNCTION OLDMassRealToStr(massValue:REAL) : STRING;
		
		Category: Truss Analysis
		Converts mass real value to string and returns the result.
	'''
	pass
	return 'STRING' # 


def OLDMassStrToReal(
		massString  # STRING -  
		):
	'''
		Python: (BOOLEAN, realValue) = vs.OLDMassStrToReal(massString)
		VectorScript: FUNCTION OLDMassStrToReal(massString:STRING; VAR realValue:REAL) : BOOLEAN;
		
		Category: Truss Analysis
		Converts mass string to real number and returns TURE on success.
	'''
	pass
	return ( False  , # 
	         0.0     )


def OLDSelectTrussSystem(
		trussHandle  # HANDLE -  
		):
	'''
		Python: vs.OLDSelectTrussSystem(trussHandle)
		VectorScript: PROCEDURE OLDSelectTrussSystem(trussHandle:HANDLE);
		
		Category: Truss Analysis
		Using the given handle, selects the whole truss system the objects is part of.
	'''
	pass


def OLDSetHangPathHandle(
		handle          , # HANDLE  -  
		loadIndex       , # INTEGER -  
		path            , # HANDLE  -  
		height          , # REAL    -  
		deletePathHandle  # BOOLEAN -  
		):
	'''
		Python: REAL = vs.OLDSetHangPathHandle(handle, loadIndex, path, height, deletePathHandle)
		VectorScript: FUNCTION OLDSetHangPathHandle(handle:HANDLE; loadIndex:INTEGER; path:HANDLE; height:REAL; deletePathHandle:BOOLEAN) : REAL;
		
		Category: Truss Analysis
		Adds the path to the hang points of the specified load for the parametric object
	'''
	pass
	return 'REAL' # 


def OLDSetLoadDataBool(
		handle   , # HANDLE  -  
		selector , # INTEGER -  
		value    , # BOOLEAN -  
		loadIndex  # INTEGER -  
		):
	'''
		Python: vs.OLDSetLoadDataBool(handle, selector, value, loadIndex)
		VectorScript: PROCEDURE OLDSetLoadDataBool(handle:HANDLE; selector:INTEGER; value:BOOLEAN; loadIndex:INTEGER);
		
		Category: Truss Analysis
		Using selector, sets load data with bool value for the parametric object
	'''
	pass


def OLDSetLoadDataReal(
		handle   , # HANDLE  -  
		selector , # INTEGER -  
		value    , # REAL    -  
		loadIndex  # INTEGER -  
		):
	'''
		Python: vs.OLDSetLoadDataReal(handle, selector, value, loadIndex)
		VectorScript: PROCEDURE OLDSetLoadDataReal(handle:HANDLE; selector:INTEGER; value:REAL; loadIndex:INTEGER);
		
		Category: Truss Analysis
		Using selector, sets load data with real value for the parametric object
	'''
	pass


def OLDSetLoadDataStr(
		handle   , # HANDLE  -  
		selector , # INTEGER -  
		value    , # STRING  -  
		loadIndex  # INTEGER -  
		):
	'''
		Python: vs.OLDSetLoadDataStr(handle, selector, value, loadIndex)
		VectorScript: PROCEDURE OLDSetLoadDataStr(handle:HANDLE; selector:INTEGER; value:STRING; loadIndex:INTEGER);
		
		Category: Truss Analysis
		Using selector, sets load data with string value for the parametric object
	'''
	pass


def OLDShowTrussSnapping():
	'''
		Python: BOOLEAN = vs.OLDShowTrussSnapping()
		VectorScript: FUNCTION OLDShowTrussSnapping : BOOLEAN;
		
		Category: Truss Analysis
		Call this function On Drag event to enable Braceworks snapping while dragging single object
	'''
	pass
	return 'BOOLEAN' # 


def OLDTrussSectionDlg(
		):
	'''
		Python: (BOOLEAN, crossSection, height, width, design, chordDiameter) = vs.OLDTrussSectionDlg()
		VectorScript: FUNCTION OLDTrussSectionDlg(VAR crossSection:STRING; VAR height:REAL; VAR width:REAL; VAR design:INTEGER; VAR chordDiameter:REAL) : BOOLEAN;
		
		Category: Truss Analysis
		Show Truss Cross Section dialog.
	'''
	pass
	return ( False   , # 
	         'string', 
	         0.0     , 
	         0.0     , 
	         0       , 
	         0.0      )


def Opacity(
		opacity  # INTEGER -  
		):
	'''
		Python: vs.Opacity(opacity)
		VectorScript: PROCEDURE Opacity(opacity:INTEGER);
		
		Category: Document Attributes
		Sets the active opacity.
	'''
	pass


def OpacityByClass():
	'''
		Python: vs.OpacityByClass()
		VectorScript: PROCEDURE OpacityByClass;
		
		Category: Classes
		Sets the document default settings to the opacity of the active class.
	'''
	pass


def OpacityByClassN(
		fillOpacityByClass, # BOOLEAN -  
		penOpacityByClass   # BOOLEAN -  
		):
	'''
		Python: vs.OpacityByClassN(fillOpacityByClass, penOpacityByClass)
		VectorScript: PROCEDURE OpacityByClassN(fillOpacityByClass:BOOLEAN; penOpacityByClass:BOOLEAN);
		
		Category: Classes
	'''
	pass


def OpacityN(
		fillOpacity, # INTEGER -  
		penOpacity   # INTEGER -  
		):
	'''
		Python: vs.OpacityN(fillOpacity, penOpacity)
		VectorScript: PROCEDURE OpacityN(fillOpacity:INTEGER; penOpacity:INTEGER);
		
		Category: Document Attributes
	'''
	pass


def Open(
		fileName  # DYNARRAY[] of CHAR - Name or path of file to open.
		):
	'''
		Python: vs.Open(fileName)
		VectorScript: PROCEDURE Open(fileName:DYNARRAY of CHAR);
		
		Category: File I/O
		Procedure Open opens a ASCII text file for reading.
		Remember to use Close when you are finished reading or writing to a file.
	'''
	pass


def OpenPDFDocument(
		inFilenameStr  # DYNARRAY[] of CHAR -  
		):
	'''
		Python: BOOLEAN = vs.OpenPDFDocument(inFilenameStr)
		VectorScript: FUNCTION OpenPDFDocument(inFilenameStr:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: Command
		Begins the export to a PDF document.  You must call AcquireExportPDFSettingsAndLocation before calling this function. This is intended to support Batch PDF Export.
	'''
	pass
	return 'BOOLEAN' # 


def OpenPoly():
	'''
		Python: vs.OpenPoly()
		VectorScript: PROCEDURE OpenPoly;
		
		Category: Objects - Polys
		Procedures OpenPoly set the polygon creation mode for polygon objects created in VectorScript to open. To turn this mode off, use Procedure ClosePoly; the two modes used in conjunction will act as a toggle for the feature.
	'''
	pass


def OpenScriptResPal(
		paletteName, # STRING  - The script resource palette.              
		open         # BOOLEAN - Pass in TRUE for the palette to be opened.
		):
	'''
		Python: vs.OpenScriptResPal(paletteName, open)
		VectorScript: PROCEDURE OpenScriptResPal(paletteName:STRING; open:BOOLEAN);
		
		Category: Utility
		Open or close a script resource palette.
	'''
	pass


def OpenURL(
		URLname  # DYNARRAY[] of CHAR - The Uniform Resource Locator for the web page or file to open. 
		):
	'''
		Python: BOOLEAN = vs.OpenURL(URLname)
		VectorScript: FUNCTION OpenURL(URLname:DYNARRAY of CHAR) : BOOLEAN;
		
		Category: Utility
		Opens a web page or file using the default browser or appropriate application (e.g. Adobe Acrobat).  Returns a boolean indicating the success of the operation.
		The URL (Uniform Resource Locator) is a pointer to a resource on the World Wide Web.  It specifies both the protocol and location of the document to open.  For files on the local computer, the URL should begin with file:// protocol specifier.  For web pages, the URL should begin with http://.  The URL should use forward slashes / to separate parts of the path.
		There are some platform differences to be aware of.  Windows will accept either \ or / as the path separators.  MacOS X requires that file:// URLs begin with /Volumes/ before the drive name.  Also, currently the MacOS X implementation of OpenURL does not accept spaces in the URL.  Spaces should be replaced with the escape code %20 before calling this function.
		Note: The function GetFolderPath returns a string with separators specific for the platform it is running on (: on Mac and \ on Windows).  If your script calls this function to assemble a local file:// URL then you will have to replace the : separators with / characters.
	'''
	pass
	return 'BOOLEAN' # 


def Option():
	'''
		Python: BOOLEAN = vs.Option()
		VectorScript: FUNCTION Option : BOOLEAN;
		
		Category: User Interactive
		Option return TRUE if the Option key (Mac) or Alt key (Windows) was depressed during the last user event. This function operates with the MouseDown, KeyDown, AutoKey, GetPt, GetPtL, GetLine, and GetRect calls.
	'''
	pass
	return 'BOOLEAN' # 


def Ord(
		v  # CHAR - ASCII character.
		):
	'''
		Python: INTEGER = vs.Ord(v)
		VectorScript: FUNCTION Ord(v:CHAR) : INTEGER;
		
		Category: Strings
		Function Ord returns the corresponding ASCII number of the specified character value. Parameter Ord specifies the character.
	'''
	pass
	return 'INTEGER' # 


def Oval(
		p1, # POINT - Top left coordinate of oval bounding box.    
		p2  # POINT - Bottom right coordinate of oval bounding box.
		):
	'''
		Python: vs.Oval(p1, p2)
		VectorScript: PROCEDURE Oval(p1X, p1Y:REAL; p2X, p2Y:REAL);
		
		Category: Objects - 2D
		Procedure Oval creates an oval object in a Vectorworks document.
	'''
	pass


def OvalN(
		orgin    , # POINT -  
		direction, # POINT -  
		width    , # REAL  -  
		height     # REAL  -  
		):
	'''
		Python: vs.OvalN(orgin, direction, width, height)
		VectorScript: PROCEDURE OvalN(orginX, orginY:REAL; directionX, directionY:REAL; width:REAL; height:REAL);
		
		Category: Objects - 2D
		Creates an oval with the specified bounds.
	'''
	pass


def OverlapLineArc(
		begPt    , # VECTOR -  
		endpt    , # VECTOR -  
		cenPt    , # VECTOR -  
		radius   , # REAL   -  
		startAng , # REAL   -  
		sweepAng , # REAL   -  
		tolerance  # REAL   -  
		):
	'''
		Python: (BOOLEAN, lapPt1, lapPt2) = vs.OverlapLineArc(begPt, endpt, cenPt, radius, startAng, sweepAng, tolerance)
		VectorScript: FUNCTION OverlapLineArc(begPt:VECTOR; endpt:VECTOR; cenPt:VECTOR; radius:REAL; startAng:REAL; sweepAng:REAL; VAR lapPt1:VECTOR; VAR lapPt2:VECTOR; tolerance:REAL) : BOOLEAN;
		
		Category: Graphic Calculation
		Finds the overlap of a line and an arc. Returns the overlapping segment if it exists.
	'''
	pass
	return ( False  , # 
	         0,0,0  , 
	         0,0,0   )


def OverlapLineLine(
		begPt1   , # VECTOR -  
		endPt1   , # VECTOR -  
		begPt2   , # VECTOR -  
		endPt2   , # VECTOR -  
		tolerance  # REAL   -  
		):
	'''
		Python: (BOOLEAN, lapPt1, lapPt2) = vs.OverlapLineLine(begPt1, endPt1, begPt2, endPt2, tolerance)
		VectorScript: FUNCTION OverlapLineLine(begPt1:VECTOR; endPt1:VECTOR; begPt2:VECTOR; endPt2:VECTOR; VAR lapPt1:VECTOR; VAR lapPt2:VECTOR; tolerance:REAL) : BOOLEAN;
		
		Category: Graphic Calculation
		Returns two points the lap zone of two lines.
	'''
	pass
	return ( False  , # 
	         0,0,0  , 
	         0,0,0   )


def PDF_AnnotationsFromBlob(
		inBlobPtr , # PROCEDURE -  
		inBlobSize, # LONGINT   -  
		inCurPage , # LONGINT   -  
		boundsX   , # REAL      -  
		boundsY   , # REAL      -  
		ioSnapGeom  # HANDLE    -  
		):
	'''
		Python: BOOLEAN = vs.PDF_AnnotationsFromBlob(inBlobPtr, inBlobSize, inCurPage, boundsX, boundsY, ioSnapGeom)
		VectorScript: FUNCTION PDF_AnnotationsFromBlob(inBlobPtr:PROCEDURE; inBlobSize:LONGINT; inCurPage:LONGINT; boundsX:REAL; boundsY:REAL; ioSnapGeom:HANDLE) : BOOLEAN;
		
		Category: PDF
		Draws annotations from the PDF Blob
	'''
	pass
	return 'BOOLEAN' # 


def PDF_CreateBlob(
		inFilePath, # PROCEDURE -  
		ioBlobPtr , # PROCEDURE -  
		ioBlobSize, # PROCEDURE -  
		ioCurPage   # PROCEDURE -  
		):
	'''
		Python: BOOLEAN = vs.PDF_CreateBlob(inFilePath, ioBlobPtr, ioBlobSize, ioCurPage)
		VectorScript: FUNCTION PDF_CreateBlob(inFilePath:PROCEDURE; ioBlobPtr:PROCEDURE; ioBlobSize:PROCEDURE; ioCurPage:PROCEDURE) : BOOLEAN;
		
		Category: PDF
		Creates a memory blob representation of a specified document and page.
	'''
	pass
	return 'BOOLEAN' # 


def PDF_CreatePDFABlobFromBlob(
		inBlobPtr   , # PROCEDURE -  
		inBlobSize  , # LONGINT   -  
		inPDFAFormat, # LONGINT   -  
		ioBlobPtr   , # PROCEDURE -  
		ioBlobSize    # PROCEDURE -  
		):
	'''
		Python: BOOLEAN = vs.PDF_CreatePDFABlobFromBlob(inBlobPtr, inBlobSize, inPDFAFormat, ioBlobPtr, ioBlobSize)
		VectorScript: FUNCTION PDF_CreatePDFABlobFromBlob(inBlobPtr:PROCEDURE; inBlobSize:LONGINT; inPDFAFormat:LONGINT; ioBlobPtr:PROCEDURE; ioBlobSize:PROCEDURE) : BOOLEAN;
		
		Category: PDF
		Takes Blob Data and creates a PDFA blob
	'''
	pass
	return 'BOOLEAN' # 


def PDF_DestroyBlob(
		ioBlobPtr  # PROCEDURE -  
		):
	'''
		Python: BOOLEAN = vs.PDF_DestroyBlob(ioBlobPtr)
		VectorScript: FUNCTION PDF_DestroyBlob(ioBlobPtr:PROCEDURE) : BOOLEAN;
		
		Category: PDF
		After Creating and Copping Blob Data call this method to release Blob memory
	'''
	pass
	return 'BOOLEAN' # 


def PDF_DrawDCFromBlob(
		inBlobPtr   , # PROCEDURE -  
		inBlobSize  , # LONGINT   -  
		inCurPage   , # LONGINT   -  
		inDC        , # PROCEDURE -  
		inDrawMatrix, # PROCEDURE -  
		inInvalRect , # PROCEDURE -  
		inCancelCB    # PROCEDURE -  
		):
	'''
		Python: BOOLEAN = vs.PDF_DrawDCFromBlob(inBlobPtr, inBlobSize, inCurPage, inDC, inDrawMatrix, inInvalRect, inCancelCB)
		VectorScript: FUNCTION PDF_DrawDCFromBlob(inBlobPtr:PROCEDURE; inBlobSize:LONGINT; inCurPage:LONGINT; inDC:PROCEDURE; inDrawMatrix:PROCEDURE; inInvalRect:PROCEDURE; inCancelCB:PROCEDURE) : BOOLEAN;
		
		Category: PDF
		Draws PDF DocID into passed DC
	'''
	pass
	return 'BOOLEAN' # 


def PDF_FlushCache():
	'''
		Python: BOOLEAN = vs.PDF_FlushCache()
		VectorScript: FUNCTION PDF_FlushCache : BOOLEAN;
		
		Category: PDF
		Flushes all Document Cache.
	'''
	pass
	return 'BOOLEAN' # 


def PDF_GetNumOfAnnotations(
		inBlobPtr , # PROCEDURE -  
		inBlobSize, # LONGINT   -  
		inCurPage   # LONGINT   -  
		):
	'''
		Python: BOOLEAN = vs.PDF_GetNumOfAnnotations(inBlobPtr, inBlobSize, inCurPage)
		VectorScript: FUNCTION PDF_GetNumOfAnnotations(inBlobPtr:PROCEDURE; inBlobSize:LONGINT; inCurPage:LONGINT) : BOOLEAN;
		
		Category: PDF
		Returns the number of the PDF annotations per PDF page
	'''
	pass
	return 'BOOLEAN' # 


def PDF_GetPageCount(
		inFilePath  # PROCEDURE -  
		):
	'''
		Python: INTEGER = vs.PDF_GetPageCount(inFilePath)
		VectorScript: FUNCTION PDF_GetPageCount(inFilePath:PROCEDURE) : INTEGER;
		
		Category: PDF
		Returns the page count of the selected document file.
	'''
	pass
	return 'INTEGER' # 


def PDF_GetPageMatrixFromBlob(
		inBlobPtr , # PROCEDURE -  
		inBlobSize, # LONGINT   -  
		inCurPage , # LONGINT   -  
		inMatrix    # PROCEDURE -  
		):
	'''
		Python: BOOLEAN = vs.PDF_GetPageMatrixFromBlob(inBlobPtr, inBlobSize, inCurPage, inMatrix)
		VectorScript: FUNCTION PDF_GetPageMatrixFromBlob(inBlobPtr:PROCEDURE; inBlobSize:LONGINT; inCurPage:LONGINT; inMatrix:PROCEDURE) : BOOLEAN;
		
		Category: PDF
		Get PDF Default Matrix.
	'''
	pass
	return 'BOOLEAN' # 


def PDF_GetPageSizeFromBlob(
		inBlobPtr    , # PROCEDURE -  
		inBlobSize   , # LONGINT   -  
		inPageBoxID  , # LONGINT   -  
		inCurPage    , # PROCEDURE -  
		outBoxLeft   , # PROCEDURE -  
		outBoxTop    , # PROCEDURE -  
		outBoxRight  , # PROCEDURE -  
		outBoxBottom   # PROCEDURE -  
		):
	'''
		Python: BOOLEAN = vs.PDF_GetPageSizeFromBlob(inBlobPtr, inBlobSize, inPageBoxID, inCurPage, outBoxLeft, outBoxTop, outBoxRight,  outBoxBottom)
		VectorScript: FUNCTION PDF_GetPageSizeFromBlob(inBlobPtr:PROCEDURE; inBlobSize:LONGINT; inPageBoxID:LONGINT; inCurPage:PROCEDURE; outBoxLeft:PROCEDURE; outBoxTop:PROCEDURE; outBoxRight:PROCEDURE;  outBoxBottom:PROCEDURE) : BOOLEAN;
		
		Category: PDF
		Takes Blob Data and returns corresponding page rect
	'''
	pass
	return 'BOOLEAN' # 


def PDF_PrintBlob(
		inBlobPtr , # PROCEDURE -  
		inBlobSize, # LONGINT   -  
		inSettings  # PROCEDURE -  
		):
	'''
		Python: BOOLEAN = vs.PDF_PrintBlob(inBlobPtr, inBlobSize, inSettings)
		VectorScript: FUNCTION PDF_PrintBlob(inBlobPtr:PROCEDURE; inBlobSize:LONGINT; inSettings:PROCEDURE) : BOOLEAN;
		
		Category: PDF
		Prints a page from the PDF Blob
	'''
	pass
	return 'BOOLEAN' # 


def PDF_SetPageImage(
		inBlobPtr  # HANDLE -  
		):
	'''
		Python: BOOLEAN = vs.PDF_SetPageImage(inBlobPtr)
		VectorScript: FUNCTION PDF_SetPageImage(inBlobPtr:HANDLE) : BOOLEAN;
		
		Category: PDF
		Creates image of the passed PDF page object and attaches it into it's child
	'''
	pass
	return 'BOOLEAN' # 


def PDF_SetProgressBar(
		progressPtr, # PROCEDURE -  
		status       # BOOLEAN   -  
		):
	'''
		Python: BOOLEAN = vs.PDF_SetProgressBar(progressPtr, status)
		VectorScript: FUNCTION PDF_SetProgressBar(progressPtr:PROCEDURE; status:BOOLEAN) : BOOLEAN;
		
		Category: PDF
		Sets the progress bar from the PDF Import Menu Command
	'''
	pass
	return 'BOOLEAN' # 


def PDF_SnapGeomFromBlob(
		inBlobPtr , # PROCEDURE -  
		inBlobSize, # LONGINT   -  
		inCurPage , # LONGINT   -  
		boundsX   , # REAL      -  
		boundsY   , # REAL      -  
		ioSnapGeom  # HANDLE    -  
		):
	'''
		Python: BOOLEAN = vs.PDF_SnapGeomFromBlob(inBlobPtr, inBlobSize, inCurPage, boundsX, boundsY, ioSnapGeom)
		VectorScript: FUNCTION PDF_SnapGeomFromBlob(inBlobPtr:PROCEDURE; inBlobSize:LONGINT; inCurPage:LONGINT; boundsX:REAL; boundsY:REAL; ioSnapGeom:HANDLE) : BOOLEAN;
		
		Category: PDF
		Collects vector graphic into ioSnapGeom from the PDF Blob
	'''
	pass
	return 'BOOLEAN' # 


def PDF_ThreadDeInitialize():
	'''
		Python: BOOLEAN = vs.PDF_ThreadDeInitialize()
		VectorScript: FUNCTION PDF_ThreadDeInitialize : BOOLEAN;
		
		Category: PDF
		When the thread completes clean up library usage
	'''
	pass
	return 'BOOLEAN' # 


def PDF_ThreadInitialize():
	'''
		Python: BOOLEAN = vs.PDF_ThreadInitialize()
		VectorScript: FUNCTION PDF_ThreadInitialize : BOOLEAN;
		
		Category: PDF
		The library needs to be Initialized per thread
	'''
	pass
	return 'BOOLEAN' # 


def PDF_VerifyLibrary():
	'''
		Python: BOOLEAN = vs.PDF_VerifyLibrary()
		VectorScript: FUNCTION PDF_VerifyLibrary : BOOLEAN;
		
		Category: PDF
		Verifies the library is avaiable and loaded.
	'''
	pass
	return 'BOOLEAN' # 


def PenBack(
		color  # COLOR - RGB color value to be set as active pen background.
		):
	'''
		Python: vs.PenBack(color)
		VectorScript: PROCEDURE PenBack(colorR, colorG, colorB:LONGINT);
		
		Category: Document Attributes
		Procedure PenBack set the active pen background color for the document. RGB values are in the range of 0 65535.
	'''
	pass


def PenColorByClass():
	'''
		Python: vs.PenColorByClass()
		VectorScript: PROCEDURE PenColorByClass;
		
		Category: Classes
		Sets the default document pen colors to the pen colors of the active class.
	'''
	pass


def PenFore(
		color  # COLOR - RGB color value to be set as active pen foreground.
		):
	'''
		Python: vs.PenFore(color)
		VectorScript: PROCEDURE PenFore(colorR, colorG, colorB:LONGINT);
		
		Category: Document Attributes
		Procedure PenFore sets the active pen foreground color for the document. RGB values are in the range of 0 65535.
	'''
	pass


def PenGrid(
		gridDistance  # REAL (Coordinate) - Pen grid spacing.
		):
	'''
		Python: vs.PenGrid(gridDistance)
		VectorScript: PROCEDURE PenGrid(gridDistance:REAL (Coordinate));
		
		Category: Document Settings
		Procedure PenGrid sets the snap grid distance in the document.
	'''
	pass


def PenLoc(
		):
	'''
		Python: p = vs.PenLoc()
		VectorScript: PROCEDURE PenLoc(VAR pX, pY:REAL);
		
		Category: Command
		Returns the current coordinate location of the graphics pen.
	'''
	pass
	return ( 0,0 )


def PenPat(
		patNumber  # INTEGER - Pattern/linestyle ID value.
		):
	'''
		Python: vs.PenPat(patNumber)
		VectorScript: PROCEDURE PenPat(patNumber:INTEGER);
		
		Category: Document Attributes
		Deprecated - will generate error. Use PenPatN instead.
	'''
	pass


def PenPatN(
		patNumber  # LONGINT - Pattern/linestyle ID value.
		):
	'''
		Python: vs.PenPatN(patNumber)
		VectorScript: PROCEDURE PenPatN(patNumber:LONGINT);
		
		Category: Document Attributes
		Procedure PenPatN sets the active pen pattern (line style) for the document.
		If patNumber is in the range 0 to 71 the linestyle will be set to the corresponding fill pattern. A negative value, will set the linestyle to the line type resource whose index is the negative of the value.
	'''
	pass


def PenSize(
		lw  # INTEGER - Line weight (in mils). Fourteen (14) mils equals one pixel.
		):
	'''
		Python: vs.PenSize(lw)
		VectorScript: PROCEDURE PenSize(lw:INTEGER);
		
		Category: Document Attributes
		Procedure PenSize sets the active line weight for the document.
	'''
	pass


def PercStrFromDeg(
		fSlopeDeg  # REAL -  
		):
	'''
		Python: STRING = vs.PercStrFromDeg(fSlopeDeg)
		VectorScript: FUNCTION PercStrFromDeg(fSlopeDeg:REAL) : STRING;
		
		Category: SiteModel Interface Library
		Converts slope from degrees to percent string.
	'''
	pass
	return 'STRING' # 


def Perim(
		c  # CRITERIA - Search criteria.
		):
	'''
		Python: REAL = vs.Perim(c)
		VectorScript: FUNCTION Perim(c:CRITERIA) : REAL;
		
		Category: Criteria
		Returns the perimeter of an object. If more than one object matches the search criteria, the function will return the sum of the matching objects' perimeters.
	'''
	pass
	return 'REAL' # 


def PerimN(
		c  # CRITERIA - Search criteria.
		):
	'''
		Python: REAL = vs.PerimN(c)
		VectorScript: FUNCTION PerimN(c:CRITERIA) : REAL;
		
		Category: Criteria
		Returns the perimeter of an object. If more than one object matches the search criteria, the function will return the sum of the matching objects' perimeters.
	'''
	pass
	return 'REAL' # 


def Perp(
		Vec  # VECTOR - Source vector.
		):
	'''
		Python: VECTOR = vs.Perp(Vec)
		VectorScript: FUNCTION Perp(Vec:VECTOR) : VECTOR;
		
		Category: Math - Vectors
		Returns a vector which is perpendicular to the specified vector. The resultant vector will have the same magnitude as the source vector, and their scalar product will be zero. The direction of the return vector will equal Vec2Ang(Vec) - 90.
	'''
	pass
	return 'VECTOR' # Returns a VECTOR.


def PickObject(
		p  # POINT - Coordinate location to test for object.
		):
	'''
		Python: HANDLE = vs.PickObject(p)
		VectorScript: FUNCTION PickObject(pX, pY:REAL) : HANDLE;
		
		Category: Utility
		Function PickObject returns a handle to an object in the document. The function receives a coordinate location, specified by parameter p, and checks this location for the presence of an object. If an object exists at the location, the function returns a handle to the object.
	'''
	pass
	return 'HANDLE' # 


def PlanarPtTo3DModelPt(
		refID, # LONGINT - Reference ID of the plane.          
		pt2D   # POINT   - The 2D point on the specified plane.
		):
	'''
		Python: (BOOLEAN, outPt3D) = vs.PlanarPtTo3DModelPt(refID, pt2D)
		VectorScript: FUNCTION PlanarPtTo3DModelPt(refID:LONGINT; pt2DX, pt2DY:REAL; VAR outPt3DX, outPt3DY, outPt3DZ:REAL) : BOOLEAN;
		
		Category: Utility
		Transform a 2D point on the specified plane into a 3D point.
	'''
	pass
	return ( False  , # 
	         0,0,0   )


def PlanarPtToScreenPlanePt(
		refID, # LONGINT - Reference ID of the plane.      
		pt2D   # POINT   - Input the 2D point on the plane.
		):
	'''
		Python: (BOOLEAN, outPt) = vs.PlanarPtToScreenPlanePt(refID, pt2D)
		VectorScript: FUNCTION PlanarPtToScreenPlanePt(refID:LONGINT; pt2DX, pt2DY:REAL; VAR outPtX, outPtY:REAL) : BOOLEAN;
		
		Category: Utility
		Projects a 2D point from the specified plane onto the screen plane.
	'''
	pass
	return ( False  , # 
	         0,0     )


def Plant_CreateDupPlant(
		plantToCreateFrom  # HANDLE -  
		):
	'''
		Python: vs.Plant_CreateDupPlant(plantToCreateFrom)
		VectorScript: PROCEDURE Plant_CreateDupPlant(plantToCreateFrom:HANDLE);
		
		Category: PlantObjectCoreTools
		Creates a new plant from the currently selected plant
	'''
	pass


def Plant_EditPlantDefRB(
		plantToEdit  # HANDLE -  
		):
	'''
		Python: vs.Plant_EditPlantDefRB(plantToEdit)
		VectorScript: PROCEDURE Plant_EditPlantDefRB(plantToEdit:HANDLE);
		
		Category: PlantObjectCoreTools
		Updates the definition when the user edits a plant definition from the resource browser
	'''
	pass


def Plant_GetToolInit():
	'''
		Python: BOOLEAN = vs.Plant_GetToolInit()
		VectorScript: FUNCTION Plant_GetToolInit : BOOLEAN;
		
		Category: PlantObjectCoreTools
		Returns true if the plant tool is initialized.
	'''
	pass
	return 'BOOLEAN' # 


def Plant_GetToolPlantNm():
	'''
		Python: STRING = vs.Plant_GetToolPlantNm()
		VectorScript: FUNCTION Plant_GetToolPlantNm : STRING;
		
		Category: PlantObjectCoreTools
		Gets the current plant that the tool has loaded.
	'''
	pass
	return 'STRING' # 


def Plant_GetToolPlcMode():
	'''
		Python: INTEGER = vs.Plant_GetToolPlcMode()
		VectorScript: FUNCTION Plant_GetToolPlcMode : INTEGER;
		
		Category: PlantObjectCoreTools
		Gets the current placement mode associated with the plant tool.
	'''
	pass
	return 'INTEGER' # 


def Plant_GetToolSpacing():
	'''
		Python: REAL = vs.Plant_GetToolSpacing()
		VectorScript: FUNCTION Plant_GetToolSpacing : REAL;
		
		Category: PlantObjectCoreTools
		Gets the current spacing associated with the plant tool.
	'''
	pass
	return 'REAL' # 


def Plant_ReplacePlant(
		plantToReplace  # HANDLE -  
		):
	'''
		Python: vs.Plant_ReplacePlant(plantToReplace)
		VectorScript: PROCEDURE Plant_ReplacePlant(plantToReplace:HANDLE);
		
		Category: PlantObjectCoreTools
		Replaces a the currently selected plant
	'''
	pass


def Plant_ReplacePlantParam(
		origPlantObj  # HANDLE -  
		):
	'''
		Python: HANDLE = vs.Plant_ReplacePlantParam(origPlantObj)
		VectorScript: FUNCTION Plant_ReplacePlantParam(origPlantObj:HANDLE) : HANDLE;
		
		Category: PlantObjectCoreTools
		Replaces plant parameters using information from replacement plant object.
	'''
	pass
	return 'HANDLE' # 


def Plant_ResetPlantInst(
		plantSymbolName  # DYNARRAY[] of CHAR -  
		):
	'''
		Python: vs.Plant_ResetPlantInst(plantSymbolName)
		VectorScript: PROCEDURE Plant_ResetPlantInst(plantSymbolName:DYNARRAY of CHAR);
		
		Category: PlantObjectCoreTools
		Resets all instances of the plant symbol definition that is edited.
	'''
	pass


def Plant_UpdatePlaceTool(
		plantToUpdateWith  # HANDLE -  
		):
	'''
		Python: vs.Plant_UpdatePlaceTool(plantToUpdateWith)
		VectorScript: PROCEDURE Plant_UpdatePlaceTool(plantToUpdateWith:HANDLE);
		
		Category: PlantObjectCoreTools
		Updates the place plant tool when plant is double clicked from resource browser
	'''
	pass


def Plant_UpdateTranslat(
		newSymbolName, # DYNARRAY[] of CHAR -  
		oldID        , # DYNARRAY[] of CHAR -  
		newID        , # DYNARRAY[] of CHAR -  
		masterPlant  , # HANDLE             -  
		currentPlant   # HANDLE             -  
		):
	'''
		Python: vs.Plant_UpdateTranslat(newSymbolName, oldID, newID, masterPlant, currentPlant)
		VectorScript: PROCEDURE Plant_UpdateTranslat(newSymbolName:DYNARRAY of CHAR; oldID:DYNARRAY of CHAR; newID:DYNARRAY of CHAR; masterPlant:HANDLE; currentPlant:HANDLE);
		
		Category: PlantObjectCoreTools
		Updates the plant record with the new ID.
	'''
	pass


def PointAlongPoly(
		h   , # HANDLE -  
		dist  # REAL   -  
		):
	'''
		Python: (BOOLEAN, pt, tangent) = vs.PointAlongPoly(h, dist)
		VectorScript: FUNCTION PointAlongPoly(h:HANDLE; dist:REAL; VAR pt:VECTOR; VAR tangent:VECTOR) : BOOLEAN;
		
		Category: Graphic Calculation
		Returns a point at the specified distance along the poly, and a vector tangent to the poly at that point.
	'''
	pass
	return ( False  , # 
	         0,0,0  , 
	         0,0,0   )


def PointAlongPolyN(
		h      , # HANDLE -  
		dist   , # REAL   -  
		epsilon  # REAL   -  
		):
	'''
		Python: (BOOLEAN, pt, tangent) = vs.PointAlongPolyN(h, dist, epsilon)
		VectorScript: FUNCTION PointAlongPolyN(h:HANDLE; dist:REAL; epsilon:REAL; VAR pt:VECTOR; VAR tangent:VECTOR) : BOOLEAN;
		
		Category: Graphic Calculation
		Returns a point at the specified distance along the poly, and a vector tangent to the poly at that point. Similar to PointAlongPoly with an addition of an epsilon value.
	'''
	pass
	return ( False  , # 
	         0,0,0  , 
	         0,0,0   )


def Polygonize(
		h                 , # HANDLE  -  
		segmentationLength, # REAL    -  
		polygonizeStraight  # BOOLEAN -  
		):
	'''
		Python: HANDLE = vs.Polygonize(h, segmentationLength, polygonizeStraight)
		VectorScript: FUNCTION Polygonize(h:HANDLE; segmentationLength:REAL; polygonizeStraight:BOOLEAN) : HANDLE;
		
		Category: Graphic Calculation
		Polygonize polylines and polygons.
	'''
	pass
	return 'HANDLE' # 


def PolyMedialAxis(
		h  # HANDLE -  
		):
	'''
		Python: HANDLE = vs.PolyMedialAxis(h)
		VectorScript: FUNCTION PolyMedialAxis(h:HANDLE) : HANDLE;
		
		Category: Graphic Calculation
		Creates a group of lines which represent the weighted medial axis of given polygon.
	'''
	pass
	return 'HANDLE' # 


def PopAttrs():
	'''
		Python: vs.PopAttrs()
		VectorScript: PROCEDURE PopAttrs;
		
		Category: Command
		Restores the attribute, tool, and constraint settings saved by an earlier call to PushAttrs.
	'''
	pass


def Pos(
		subStr, # DYNARRAY[] of CHAR - Substring to be located.
		str     # DYNARRAY[] of CHAR - Target string.          
		):
	'''
		Python: INTEGER = vs.Pos(subStr, str)
		VectorScript: FUNCTION Pos(subStr:DYNARRAY of CHAR; str:DYNARRAY of CHAR) : INTEGER;
		
		Category: Strings
		Function Pos searches for a specified substring contained within in a target string.
		Pos returns the position of the substring. If the string is not found, 0 is returned.
	'''
	pass
	return 'INTEGER' # 


def PrepRelatedObjectForChange(
		objectAboutToBeChange  # HANDLE - The object to be prepared for a change
		):
	'''
		Python: vs.PrepRelatedObjectForChange(objectAboutToBeChange)
		VectorScript: PROCEDURE PrepRelatedObjectForChange(objectAboutToBeChange:HANDLE);
		
		Category: Utility
		Prepares some other related object for a change thats about to occur.
	'''
	pass


def PrevDObj(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: HANDLE = vs.PrevDObj(h)
		VectorScript: FUNCTION PrevDObj(h:HANDLE) : HANDLE;
		
		Category: Document List Handling
		Function PrevDObj returns the previous deselected object in a list of objects . If the end of the object list is reached, the function returns NIL.
	'''
	pass
	return 'HANDLE' # 


def PrevLayer(
		h  # HANDLE - Handle to layer.
		):
	'''
		Python: HANDLE = vs.PrevLayer(h)
		VectorScript: FUNCTION PrevLayer(h:HANDLE) : HANDLE;
		
		Category: Document List Handling
		Function PrevLayer returns a handle to the layer in the document preceding the referenced layer.
	'''
	pass
	return 'HANDLE' # 


def PrevObj(
		h  # HANDLE - Handle to object,  group, or  symbol definition.
		):
	'''
		Python: HANDLE = vs.PrevObj(h)
		VectorScript: FUNCTION PrevObj(h:HANDLE) : HANDLE;
		
		Category: Document List Handling
		Function PrevObj returns the object in any list which precedes the specified object.  If the end of the list is reached, the function returns NIL.
	'''
	pass
	return 'HANDLE' # 


def PrevSObj(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: HANDLE = vs.PrevSObj(h)
		VectorScript: FUNCTION PrevSObj(h:HANDLE) : HANDLE;
		
		Category: Document List Handling
		Function PrevSObj returns the previous selected object in the list preceding the referenced object.
	'''
	pass
	return 'HANDLE' # 


def PrevSymDef(
		symHd  # HANDLE - Handle to symbol definition.
		):
	'''
		Python: HANDLE = vs.PrevSymDef(symHd)
		VectorScript: FUNCTION PrevSymDef(symHd:HANDLE) : HANDLE;
		
		Category: Document List Handling
		Function PrevSymDef returns a handle to the symbol definition in the symbol library preceding the referenced definition.
	'''
	pass
	return 'HANDLE' # 


def PrimaryUnits(
		style   , # INTEGER - Active primary unit style for document.
		prec    , # LONGINT - Display precision.                     
		dimPrec , # LONGINT - Dimension precision.                   
		format  , # INTEGER - Decimal formatting.                    
		angPrec , # INTEGER - Angular precision.                     
		showMark, # BOOLEAN - Unit mark display setting.             
		dispFrac  # BOOLEAN - Fractional display setting.            
		):
	'''
		Python: vs.PrimaryUnits(style, prec, dimPrec, format, angPrec, showMark, dispFrac)
		VectorScript: PROCEDURE PrimaryUnits(style:INTEGER; prec:LONGINT; dimPrec:LONGINT; format:INTEGER; angPrec:INTEGER; showMark:BOOLEAN; dispFrac:BOOLEAN);
		
		Category: Units
		Procedure PrimaryUnits specifies the primary units settings for the active document. The primary units setting is used by the document for all measurement entry and display values in the document.
	'''
	pass


def PrintUsingPrintDialog():
	'''
		Python: INTEGER = vs.PrintUsingPrintDialog()
		VectorScript: FUNCTION PrintUsingPrintDialog : INTEGER;
		
		Category: Command
		Available in Industry Series products only. Prints the active document.  The Print Dialog will be displayed.  The PageSetup dialog will be displayed, before the print dialog, if the existing print settings are not valid for the current printer.
	'''
	pass
	return 'INTEGER' # 


def PrintWithoutUsingPrintDialog():
	'''
		Python: INTEGER = vs.PrintWithoutUsingPrintDialog()
		VectorScript: FUNCTION PrintWithoutUsingPrintDialog : INTEGER;
		
		Category: Command
		Available in Industry Series products only. Prints the active document. Neither the Print Dialog nor the PageSetup dialog will be displayed. This function can fail with certain printers if PrintUsingPrintDialog had not previously been called for the active document.
	'''
	pass
	return 'INTEGER' # 


def Products3D(
		object  # HANDLE - The object from which to calculate the Products
		):
	'''
		Python: (BOOLEAN, lxy, lyz, lzx) = vs.Products3D(object)
		VectorScript: FUNCTION Products3D(object:HANDLE; VAR lxy:REAL; VAR lyz:REAL; VAR lzx:REAL) : BOOLEAN;
		
		Category: Objects - 3D
		Returns the products of inertia of a 3D object for the xy, yz, and zx planes passing through a point at the center of gravity of the object.
	'''
	pass
	return ( False  , # Returns true if the function succeeds.
	         0.0    , 
	         0.0    , 
	         0.0     )


def ProgressDlgClose():
	'''
		Python: vs.ProgressDlgClose()
		VectorScript: PROCEDURE ProgressDlgClose;
		
		Category: Utility
		Close the progress dialog opened with ProgressDlgOpen.
	'''
	pass


def ProgressDlgEnd():
	'''
		Python: vs.ProgressDlgEnd()
		VectorScript: PROCEDURE ProgressDlgEnd;
		
		Category: Utility
		End a progress context started with ProgressDlgStart. This will make the progress jump to the percentage declared when started.
	'''
	pass


def ProgressDlgHasCancel():
	'''
		Python: BOOLEAN = vs.ProgressDlgHasCancel()
		VectorScript: FUNCTION ProgressDlgHasCancel : BOOLEAN;
		
		Category: Utility
		Determine if the dialog has been canceled. The dialog must have cancelation enabled when created.
	'''
	pass
	return 'BOOLEAN' # 


def ProgressDlgOpen(
		title    , # STRING  -  
		canCancel  # BOOLEAN -  
		):
	'''
		Python: vs.ProgressDlgOpen(title, canCancel)
		VectorScript: PROCEDURE ProgressDlgOpen(title:STRING; canCancel:BOOLEAN);
		
		Category: Utility
		Show a progress dialog that doesn't interrupt the script. ProgressDlgClose must be used to close the dialog.
	'''
	pass


def ProgressDlgOpenDelay(
		title    , # STRING  -  
		canCancel, # BOOLEAN -  
		delaySec   # INTEGER -  
		):
	'''
		Python: vs.ProgressDlgOpenDelay(title, canCancel, delaySec)
		VectorScript: PROCEDURE ProgressDlgOpenDelay(title:STRING; canCancel:BOOLEAN; delaySec:INTEGER);
		
		Category: Utility
		Show a progress dialog that doesn't interrupt the script. The dialog will be displaed after specified dealy time (in miliseconds). ProgressDlgClose must be used to close the dialog.
	'''
	pass


def ProgressDlgSetBotMsg(
		message  # STRING -  
		):
	'''
		Python: vs.ProgressDlgSetBotMsg(message)
		VectorScript: PROCEDURE ProgressDlgSetBotMsg(message:STRING);
		
		Category: Utility
		Set bottom message of a progress dialog.
	'''
	pass


def ProgressDlgSetMeter(
		message  # STRING -  
		):
	'''
		Python: vs.ProgressDlgSetMeter(message)
		VectorScript: PROCEDURE ProgressDlgSetMeter(message:STRING);
		
		Category: Utility
		Set progress meter message of a progress dialog.
	'''
	pass


def ProgressDlgSetTopMsg(
		message  # STRING -  
		):
	'''
		Python: vs.ProgressDlgSetTopMsg(message)
		VectorScript: PROCEDURE ProgressDlgSetTopMsg(message:STRING);
		
		Category: Utility
		Set top message of a progress dialog.
	'''
	pass


def ProgressDlgStart(
		Percentage, # REAL    -  
		LoopCount   # LONGINT -  
		):
	'''
		Python: vs.ProgressDlgStart(Percentage, LoopCount)
		VectorScript: PROCEDURE ProgressDlgStart(Percentage:REAL; LoopCount:LONGINT);
		
		Category: Utility
		Start a progress context. This defines progress percentage and loop count for ProgressDlgYield calls. LoopCount is fit in the Percentage of the progress
	'''
	pass


def ProgressDlgYield(
		count  # LONGINT -  
		):
	'''
		Python: vs.ProgressDlgYield(count)
		VectorScript: PROCEDURE ProgressDlgYield(count:LONGINT);
		
		Category: Utility
		Increases the progress. This must be called between ProgressDlgStart and ProgressDlgEnd and defines the LoopCount index.
	'''
	pass


def Projection(
		proj        , # INTEGER           - Projection mode of document.                  
		rMode       , # INTEGER           - Render mode of document.                      
		viewDistance, # REAL (Coordinate) - View length.                                  
		clip1       , # POINT             - Top left coordinate of clipping rectangle.    
		clip2         # POINT             - Bottom right coordinate of clipping rectangle.
		):
	'''
		Python: vs.Projection(proj, rMode, viewDistance, clip1, clip2)
		VectorScript: PROCEDURE Projection(proj:INTEGER; rMode:INTEGER; viewDistance:REAL (Coordinate); clip1X, clip1Y:REAL; clip2X, clip2Y:REAL);
		
		Category: View / Zoom
		Procedure Projection sets the projection mode of a Vectorworks document.
		Parameters viewDistance, clip1, and clip2 are used only in perspective projection mode.
	'''
	pass


def Prot_GetSeatsNum():
	'''
		Python: INTEGER = vs.Prot_GetSeatsNum()
		VectorScript: FUNCTION Prot_GetSeatsNum : INTEGER;
		
		Category: Protection
		Returns the number of Vectorworks seats licensed on the server.
	'''
	pass
	return 'INTEGER' # 


def Prot_GetUsedSeatsNum():
	'''
		Python: INTEGER = vs.Prot_GetUsedSeatsNum()
		VectorScript: FUNCTION Prot_GetUsedSeatsNum : INTEGER;
		
		Category: Protection
		Returns the number of running Vectorworks on the network.
	'''
	pass
	return 'INTEGER' # 


def PtDialog(
		request , # DYNARRAY[] of CHAR - Dialog user prompt string.    
		defaultX, # DYNARRAY[] of CHAR - Default value for input field.
		defaultY  # DYNARRAY[] of CHAR - Default value for input field.
		):
	'''
		Python: (x, y) = vs.PtDialog(request, defaultX, defaultY)
		VectorScript: PROCEDURE PtDialog(request:DYNARRAY of CHAR; defaultX:DYNARRAY of CHAR; defaultY:DYNARRAY of CHAR; VAR x:REAL; VAR y:REAL);
		
		Category: Dialogs - Predefined
		Procedure PtDialog displays a dialog box which requests the user to enter a coordinate (point) value.
	'''
	pass
	return ( 0.0, 
	         0.0 )


def PtDialog3D(
		displayStr, # DYNARRAY[] of CHAR - Dialog user prompt string.    
		xStr      , # DYNARRAY[] of CHAR - Default value for input field.
		yStr      , # DYNARRAY[] of CHAR - Default value for input field.
		zStr        # DYNARRAY[] of CHAR - Default value for input field.
		):
	'''
		Python: (xPt, yPt, zPt) = vs.PtDialog3D(displayStr, xStr, yStr, zStr)
		VectorScript: PROCEDURE PtDialog3D(displayStr:DYNARRAY of CHAR; xStr:DYNARRAY of CHAR; yStr:DYNARRAY of CHAR; zStr:DYNARRAY of CHAR; VAR xPt:REAL; VAR yPt:REAL; VAR zPt:REAL);
		
		Category: Dialogs - Predefined
		Procedure PtDialog3D displays a dialog box which requests the user to enter a 3D coordinate (point) value.
	'''
	pass
	return ( 0.0, 
	         0.0, 
	         0.0 )


def PtInPoly(
		p, # POINT  - X-Y coordinate point.
		h  # HANDLE - Handle to polygon.   
		):
	'''
		Python: BOOLEAN = vs.PtInPoly(p, h)
		VectorScript: FUNCTION PtInPoly(pX, pY:REAL; h:HANDLE) : BOOLEAN;
		
		Category: Graphic Calculation
		Function PtInPoly returns TRUE if the point specified point lies within, or on, the referenced polygon or polyline object.
	'''
	pass
	return 'BOOLEAN' # 


def PtInRect(
		point, # POINT - X-Y coordinate point location.              
		rect1, # POINT - Top left coordinate of rectangular area.    
		rect2  # POINT - Bottom right coordinate of rectangular area.
		):
	'''
		Python: BOOLEAN = vs.PtInRect(point, rect1, rect2)
		VectorScript: FUNCTION PtInRect(pointX, pointY:REAL; rect1X, rect1Y:REAL; rect2X, rect2Y:REAL) : BOOLEAN;
		
		Category: Graphic Calculation
		Function PtInRect returns whether the coordinate location is located within the specified rectangular boundary.
	'''
	pass
	return 'BOOLEAN' # 


def PtOnArc(
		pt       , # VECTOR -  
		cenPt    , # VECTOR -  
		radius   , # REAL   -  
		startAng , # REAL   -  
		sweepAng , # REAL   -  
		tolerance  # REAL   -  
		):
	'''
		Python: BOOLEAN = vs.PtOnArc(pt, cenPt, radius, startAng, sweepAng, tolerance)
		VectorScript: FUNCTION PtOnArc(pt:VECTOR; cenPt:VECTOR; radius:REAL; startAng:REAL; sweepAng:REAL; tolerance:REAL) : BOOLEAN;
		
		Category: Graphic Calculation
		Determines if a point is on an arc.
	'''
	pass
	return 'BOOLEAN' # 


def PtOnLine(
		pt       , # VECTOR -  
		begPt    , # VECTOR -  
		endPt    , # VECTOR -  
		tolerance  # REAL   -  
		):
	'''
		Python: BOOLEAN = vs.PtOnLine(pt, begPt, endPt, tolerance)
		VectorScript: FUNCTION PtOnLine(pt:VECTOR; begPt:VECTOR; endPt:VECTOR; tolerance:REAL) : BOOLEAN;
		
		Category: Graphic Calculation
		Determines if a point is on a line.
	'''
	pass
	return 'BOOLEAN' # 


def PtPerpCircle(
		pt    , # VECTOR -  
		cenPt , # VECTOR -  
		radius  # REAL   -  
		):
	'''
		Python: VECTOR = vs.PtPerpCircle(pt, cenPt, radius)
		VectorScript: FUNCTION PtPerpCircle(pt:VECTOR; cenPt:VECTOR; radius:REAL) : VECTOR;
		
		Category: Graphic Calculation
		Returns a point on the circle which is closest to the input point.
	'''
	pass
	return 'VECTOR' # 


def PtPerpLine(
		pt   , # VECTOR -  
		begPt, # VECTOR -  
		endPt  # VECTOR -  
		):
	'''
		Python: VECTOR = vs.PtPerpLine(pt, begPt, endPt)
		VectorScript: FUNCTION PtPerpLine(pt:VECTOR; begPt:VECTOR; endPt:VECTOR) : VECTOR;
		
		Category: Graphic Calculation
		Returns a point on the input line which is closest to the input point. Doesn't check to see that the point is ON the line.
	'''
	pass
	return 'VECTOR' # 


def PushAttrs():
	'''
		Python: vs.PushAttrs()
		VectorScript: PROCEDURE PushAttrs;
		
		Category: Command
		Stores current attribute, tool, text, and constraint settings for later retrieval as the document default settings. Document settings can be modified as needed after using this call, and the stored settings can be restored with a call to PopAttrs.  Calling this function more than once (nested) is allowed.  The settings will be placed on a stack, and will be retrieved by calls to PopAttrs in the correct sequence.
	'''
	pass


def PutFile(
		commentStr, # DYNARRAY[] of CHAR - User prompt string for dialog.
		defaultStr  # DYNARRAY[] of CHAR - Default file name string.     
		):
	'''
		Python: fileName = vs.PutFile(commentStr, defaultStr)
		VectorScript: PROCEDURE PutFile(commentStr:DYNARRAY of CHAR; defaultStr:DYNARRAY of CHAR; VAR fileName:DYNARRAY of CHAR);
		
		Category: File I/O
		Procedure PutFile displays a standard file dialog which requests the user to select or create a text file for output.
	'''
	pass
	return ( 'string' )


def PythonBeginContext():
	'''
		Python: vs.PythonBeginContext()
		VectorScript: PROCEDURE PythonBeginContext;
		
		Category: Utility
		This function creates a context in which PythonExecute scripts are run.
		This function consecutive python scripts to be executed inside the same python environment.
	'''
	pass


def PythonEndContext():
	'''
		Python: vs.PythonEndContext()
		VectorScript: PROCEDURE PythonEndContext;
		
		Category: Utility
		Closes python context previously opened with PythonBeginContext.
	'''
	pass


def PythonExecute(
		script  # DYNARRAY[] of CHAR - The script to be executed.
		):
	'''
		Python: vs.PythonExecute(script)
		VectorScript: PROCEDURE PythonExecute(script:DYNARRAY of CHAR);
		
		Category: Utility
		Execute the given python script.
		You can use 'include' in python to run additional code in python files. However, before you execute the script make sure the python file are foundable through the PythonGetSearchPath. Use PythonSetSearchPath to change it.
		Scripts executed via this function should not contain User Interactive functions like GetPt for example.
	'''
	pass


def PythonGetSearchPath():
	'''
		Python: DYNARRAY of CHAR = vs.PythonGetSearchPath()
		VectorScript: FUNCTION PythonGetSearchPath : DYNARRAY of CHAR;
		
		Category: Utility
		Return the search path for python files.
	'''
	pass
	return 'DYNARRAY[] of CHAR' # The result is a string of semicolon delimited paths. The path it similar to the 'Open' function path parameter.


def PythonSetSearchPath(
		pathList  # DYNARRAY[] of CHAR - A string of semicolon delimited paths. The path it similar to the 'Open' function path parameter.
		):
	'''
		Python: vs.PythonSetSearchPath(pathList)
		VectorScript: PROCEDURE PythonSetSearchPath(pathList:DYNARRAY of CHAR);
		
		Category: Utility
		Set the search path for python files.
	'''
	pass


def QTCloseMovieFile(
		movieRef  # INTEGER - Index of QuickTime movie stream.
		):
	'''
		Python: vs.QTCloseMovieFile(movieRef)
		VectorScript: PROCEDURE QTCloseMovieFile(movieRef:INTEGER);
		
		Category: Special - QuickTime
		Closes the specified QuickTime movie file.
	'''
	pass


def QTCloseMovieFileN(
		movieRef  # INTEGER - Index of QuickTime movie stream.
		):
	'''
		Python: vs.QTCloseMovieFileN(movieRef)
		VectorScript: PROCEDURE QTCloseMovieFileN(movieRef:INTEGER);
		
		Category: Special - QuickTime
	'''
	pass


def QTCreateMovieRefID():
	'''
		Python: INTEGER = vs.QTCreateMovieRefID()
		VectorScript: FUNCTION QTCreateMovieRefID : INTEGER;
		
		Category: Special - QuickTime
	'''
	pass
	return 'INTEGER' # 


def QTGetMovieOptions(
		movieRef  # INTEGER - Index of QuickTime movie stream.
		):
	'''
		Python: (frameRate, keyFrameRate) = vs.QTGetMovieOptions(movieRef)
		VectorScript: PROCEDURE QTGetMovieOptions(movieRef:INTEGER; VAR frameRate:REAL; VAR keyFrameRate:LONGINT);
		
		Category: Special - QuickTime
		Retrieves the QuickTime movie frame rate and key frame rate for the referenced movie stream.
	'''
	pass
	return ( 0.0, 
	         0   )


def QTGetMovieOptionsN(
		movieRef  # INTEGER - Index of QuickTime movie stream.
		):
	'''
		Python: (frameRate, keyFrameRate, frameWidth, frameHeight) = vs.QTGetMovieOptionsN(movieRef)
		VectorScript: PROCEDURE QTGetMovieOptionsN(movieRef:INTEGER; VAR frameRate:REAL; VAR keyFrameRate:LONGINT; VAR frameWidth:LONGINT; VAR frameHeight:LONGINT);
		
		Category: Special - QuickTime
	'''
	pass
	return ( 0.0, 
	         0  , 
	         0  , 
	         0   )


def QTInitialize():
	'''
		Python: INTEGER = vs.QTInitialize()
		VectorScript: FUNCTION QTInitialize : INTEGER;
		
		Category: Special - QuickTime
		Initializes QuickTime and returns the QuckTime version number.
	'''
	pass
	return 'INTEGER' # Returns the QuickTime version number. A value of 0 indicates QuickTime is not available.


def QTOpenMovieFile(
		fileName  # DYNARRAY[] of CHAR - Name of movie file.
		):
	'''
		Python: INTEGER = vs.QTOpenMovieFile(fileName)
		VectorScript: FUNCTION QTOpenMovieFile(fileName:DYNARRAY of CHAR) : INTEGER;
		
		Category: Special - QuickTime
		Creates or opens a QuickTime movie file for writing.
	'''
	pass
	return 'INTEGER' # An INTEGER index value identifying the open movie stream. A value of -1 indicates the stream could not be opened.


def QTOpenMovieFileN(
		movieRef   , # INTEGER - MovieRefID that was already created with QTCreateMovieRefID.
		fileName   , # STRING  - Name of movie file.                                         
		frameWidth , # LONGINT - Frame width of the movie file.                              
		frameHeight  # LONGINT - Frame height of the movie file.                             
		):
	'''
		Python: INTEGER = vs.QTOpenMovieFileN(movieRef, fileName, frameWidth, frameHeight)
		VectorScript: FUNCTION QTOpenMovieFileN(movieRef:INTEGER; fileName:STRING; frameWidth:LONGINT; frameHeight:LONGINT) : INTEGER;
		
		Category: Special - QuickTime
	'''
	pass
	return 'INTEGER' # 


def QTSetMovieOptions(
		movieRef     , # INTEGER - Index of QuickTime movie stream.            
		frameRate    , # REAL    - Frame rate of movie.                        
		keyFrameRate , # LONGINT - Key frame rate of movie.                    
		useDlg       , # BOOLEAN - Display QuickTime comprssion options dialog.
		useDlgPreview  # BOOLEAN - Show dialog preview.                        
		):
	'''
		Python: vs.QTSetMovieOptions(movieRef, frameRate, keyFrameRate, useDlg, useDlgPreview)
		VectorScript: PROCEDURE QTSetMovieOptions(movieRef:INTEGER; frameRate:REAL; keyFrameRate:LONGINT; useDlg:BOOLEAN; useDlgPreview:BOOLEAN);
		
		Category: Special - QuickTime
		Sets the QuickTime movie frame rate and key frame rate for the referenced movie stream. The standard QuickTime compression options dialog can also be optionally displayed.
	'''
	pass


def QTSetMovieOptionsN(
		movieRef     , # INTEGER - Index of QuickTime movie stream.        
		frameRate    , # REAL    - Frame rate of movie.                    
		keyFrameRate , # LONGINT - Key frame rate of the movie.            
		useDLG       , # BOOLEAN - Display QuickTime Video Settings dialog.
		useDlgPreview, # BOOLEAN - Show dialog preview.                    
		frameWidth   , # LONGINT - Frame width for the movie file.         
		frameHeight    # LONGINT - Frame height for the movie file.        
		):
	'''
		Python: vs.QTSetMovieOptionsN(movieRef, frameRate, keyFrameRate, useDLG, useDlgPreview, frameWidth, frameHeight)
		VectorScript: PROCEDURE QTSetMovieOptionsN(movieRef:INTEGER; frameRate:REAL; keyFrameRate:LONGINT; useDLG:BOOLEAN; useDlgPreview:BOOLEAN; frameWidth:LONGINT; frameHeight:LONGINT);
		
		Category: Special - QuickTime
	'''
	pass


def QTTerminate():
	'''
		Python: vs.QTTerminate()
		VectorScript: PROCEDURE QTTerminate;
		
		Category: Special - QuickTime
		Disables QuickTime and disposes of internal QuickTime data structures.
	'''
	pass


def QTWriteFrame(
		movieRef  # INTEGER - Index of QuickTime movie stream.
		):
	'''
		Python: vs.QTWriteFrame(movieRef)
		VectorScript: PROCEDURE QTWriteFrame(movieRef:INTEGER);
		
		Category: Special - QuickTime
		Captures the active document window and writes a frame to the specified QuickTime movie file.
	'''
	pass


def Rad2Deg(
		radianValue  # REAL - Value in radians.
		):
	'''
		Python: REAL = vs.Rad2Deg(radianValue)
		VectorScript: FUNCTION Rad2Deg(radianValue:REAL) : REAL;
		
		Category: Math - General
		Function Rad2Deg converts the specified value (in radians) to degrees.
	'''
	pass
	return 'REAL' # 


def Random():
	'''
		Python: REAL = vs.Random()
		VectorScript: FUNCTION Random : REAL;
		
		Category: Math - General
		Procedure Random returns a random number between 0.0 and 1.0.
	'''
	pass
	return 'REAL' # 


def ReadXMLFile(
		XMLHandle, # LONGINT            -  
		whichPath, # INTEGER            -  
		filename   # DYNARRAY[] of CHAR -  
		):
	'''
		Python: INTEGER = vs.ReadXMLFile(XMLHandle, whichPath, filename)
		VectorScript: FUNCTION ReadXMLFile(XMLHandle:LONGINT; whichPath:INTEGER; filename:DYNARRAY of CHAR) : INTEGER;
		
		Category: XML
		Opens and reads an XML file.
	'''
	pass
	return 'INTEGER' # 


def ReadXMLMemory(
		XMLHandle, # LONGINT            -  
		XMLData    # DYNARRAY[] of CHAR -  
		):
	'''
		Python: INTEGER = vs.ReadXMLMemory(XMLHandle, XMLData)
		VectorScript: FUNCTION ReadXMLMemory(XMLHandle:LONGINT; XMLData:DYNARRAY of CHAR) : INTEGER;
		
		Category: XML
		Parses XML data in memory.
	'''
	pass
	return 'INTEGER' # 


def RealDialog(
		request, # DYNARRAY[] of CHAR - Dialog user prompt string.    
		default  # DYNARRAY[] of CHAR - Default value for input field.
		):
	'''
		Python: REAL = vs.RealDialog(request, default)
		VectorScript: FUNCTION RealDialog(request:DYNARRAY of CHAR; default:DYNARRAY of CHAR) : REAL;
		
		Category: Dialogs - Predefined
		Function RealDialog displays a dialog box which requests the user to enter a REAL value. RealDialog automatically screens for valid numeric input.
	'''
	pass
	return 'REAL' # 


def RecalculateWS(
		worksheet  # HANDLE - Handle to worksheet.
		):
	'''
		Python: vs.RecalculateWS(worksheet)
		VectorScript: PROCEDURE RecalculateWS(worksheet:HANDLE);
		
		Category: Worksheets
		Recalculates all formulas for the referenced worksheet.
	'''
	pass


def Record(
		h, # HANDLE             - Handle to object.            
		s  # DYNARRAY[] of CHAR - Name of record to be updated.
		):
	'''
		Python: vs.Record(h, s)
		VectorScript: PROCEDURE Record(h:HANDLE; s:DYNARRAY of CHAR);
		
		Category: Database / Record
		Replaces an existing record with a new version of the same record. Parameter s specifies the record to be updated.
	'''
	pass


def Rect(
		p1, # POINT - Top left coordinate of rectangle.    
		p2  # POINT - Bottom right coordinate of rectangle.
		):
	'''
		Python: vs.Rect(p1, p2)
		VectorScript: PROCEDURE Rect(p1X, p1Y:REAL; p2X, p2Y:REAL);
		
		Category: Objects - 2D
		Procedure Rect creates a rectangle object in a Vectorworks document.
		The procedure will accept coordinate definitions by either of two methods : coordinate values or distance angle values. Coordinate values are the absolute coordinate locations(in the documents' coordinate system) and are expressed as x and y values.
		Distance-angle values are expressed as a distance and angle from the current pen position. For Rect, two distance angle pairs are required to specify the top left and bottom right of the rectangle object.
	'''
	pass


def RectangleN(
		orgin    , # POINT -  
		direction, # POINT -  
		width    , # REAL  -  
		height     # REAL  -  
		):
	'''
		Python: vs.RectangleN(orgin, direction, width, height)
		VectorScript: PROCEDURE RectangleN(orginX, orginY:REAL; directionX, directionY:REAL; width:REAL; height:REAL);
		
		Category: Objects - 2D
		Creates and returns a handle to a new rectangle object with the specified bounds.
	'''
	pass


def ReDraw():
	'''
		Python: vs.ReDraw()
		VectorScript: PROCEDURE ReDraw;
		
		Category: Utility
		Procedure ReDraw invokes a screen redraw of newly created objects in the active Vectorworks document. If new objects are to be manipulated using procedures which operate on selected objects, a call to ReDraw should precede the selected object routines to ensure that all new objects are correctly identified.
	'''
	pass


def ReDrawAll():
	'''
		Python: vs.ReDrawAll()
		VectorScript: PROCEDURE ReDrawAll;
		
		Category: Utility
		Procedure ReDrawAll invokes a full screen redraw of the active Vectorworks document. ReDrawAll is used when the document view needs to be refreshed prior to additional operation being performed in the document.
	'''
	pass


def RedrawSelection():
	'''
		Python: vs.RedrawSelection()
		VectorScript: PROCEDURE RedrawSelection;
		
		Category: Utility
		This will update selection indication without redrawing the drawing.
	'''
	pass


def RefreshItem(
		liDialogID   , # LONGINT -  
		liComponentID  # LONGINT -  
		):
	'''
		Python: vs.RefreshItem(liDialogID, liComponentID)
		VectorScript: PROCEDURE RefreshItem(liDialogID:LONGINT; liComponentID:LONGINT);
		
		Category: Dialogs - Modern
		Refreshes the specified item.
	'''
	pass


def RefreshLB(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID  # LONGINT - id of the list browser control                 
		):
	'''
		Python: BOOLEAN = vs.RefreshLB(dialogID, componentID)
		VectorScript: FUNCTION RefreshLB(dialogID:LONGINT; componentID:LONGINT) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Refreshes the contents of the specified list browser.
	'''
	pass
	return 'BOOLEAN' # 


def RegisterDialogForTimerEvents(
		dialogID                , # LONGINT - the dialog identifier given by CreateLayout or CreateResizableLayout                                                                   
		timerDelayInMilliseconds  # LONGINT - The amount of time in milliseconds between each event DialogTimerEventMessageC that is going to be sent to the dialog handler function.
		):
	'''
		Python: vs.RegisterDialogForTimerEvents(dialogID, timerDelayInMilliseconds)
		VectorScript: PROCEDURE RegisterDialogForTimerEvents(dialogID:LONGINT; timerDelayInMilliseconds:LONGINT);
		
		Category: Dialogs - Modern
		Register the dialog so that it can receive events periodically using the given time delay. Using the command will make Vectorworks send the event 'DialogTimerEventMessageC' to the dialog handler on the specified time interval.
	'''
	pass


def RegularPolygon(
		centerX , # REAL    -  
		centerY , # REAL    -  
		radius  , # REAL    -  
		numSides, # INTEGER -  
		mode      # INTEGER -  
		):
	'''
		Python: vs.RegularPolygon(centerX, centerY, radius, numSides, mode)
		VectorScript: PROCEDURE RegularPolygon(centerX:REAL; centerY:REAL; radius:REAL; numSides:INTEGER; mode:INTEGER);
		
		Category: Graphic Calculation
		Creates an n-sided polygon.
	'''
	pass


def Relative():
	'''
		Python: vs.Relative()
		VectorScript: PROCEDURE Relative;
		
		Category: Command
		Sets the point designation method for VectorScript procedure calls.
		When this mode is active, all points specified in procedure calls are assumed to be X-Y offsets from the current graphics pen location. For example, the point designation (0,2) will move the graphics pen two vertical units away from its present location.
	'''
	pass


def RelativeCoords(
		pt   , # VECTOR -  
		begPt, # VECTOR -  
		endPt  # VECTOR -  
		):
	'''
		Python: VECTOR = vs.RelativeCoords(pt, begPt, endPt)
		VectorScript: FUNCTION RelativeCoords(pt:VECTOR; begPt:VECTOR; endPt:VECTOR) : VECTOR;
		
		Category: Graphic Calculation
		Translates a point into a coordinate system defined by 2 other points.
	'''
	pass
	return 'VECTOR' # 


def ReleaseObj(
		c  # CRITERIA - Search criteria
		):
	'''
		Python: vs.ReleaseObj(c)
		VectorScript: PROCEDURE ReleaseObj(c:CRITERIA);
		
		Category: Criteria
		Releases all objects which match the search criteria.
	'''
	pass


def ReleaseXML(
		XMLHandle  # LONGINT -  
		):
	'''
		Python: INTEGER = vs.ReleaseXML(XMLHandle)
		VectorScript: FUNCTION ReleaseXML(XMLHandle:LONGINT) : INTEGER;
		
		Category: XML
		Releases XML parser internal memory.
	'''
	pass
	return 'INTEGER' # 


def RemoveAllImagePopupItems(
		dialogID   , # LONGINT - Index to the dialog layout that contains the image popup component.
		componentID  # LONGINT - Index to a specific image popup component.                         
		):
	'''
		Python: vs.RemoveAllImagePopupItems(dialogID, componentID)
		VectorScript: PROCEDURE RemoveAllImagePopupItems(dialogID:LONGINT; componentID:LONGINT);
		
		Category: Dialogs - Modern
		Removes all items from the image popup.
	'''
	pass


def RemoveAllLBColumnDataItems(
		dialogID   , # LONGINT - id of the dialog that contains the list browser
		componentID, # LONGINT - id of the list browser control                 
		columnIndex  # INTEGER - the index of the column                        
		):
	'''
		Python: vs.RemoveAllLBColumnDataItems(dialogID, componentID, columnIndex)
		VectorScript: PROCEDURE RemoveAllLBColumnDataItems(dialogID:LONGINT; componentID:LONGINT; columnIndex:INTEGER);
		
		Category: Dialogs - Modern - Browser
		Removes all column data items.
	'''
	pass


def RemoveAllWSColumnOperators(
		worksheet   , # HANDLE  - Handle to worksheet.       
		databaseRow , # INTEGER - Database row to be queried.
		operatorType  # INTEGER - Operator type.             
		):
	'''
		Python: vs.RemoveAllWSColumnOperators(worksheet, databaseRow, operatorType)
		VectorScript: PROCEDURE RemoveAllWSColumnOperators(worksheet:HANDLE; databaseRow:INTEGER; operatorType:INTEGER);
		
		Category: Worksheets
		Removes all database column operators from specified database row.
	'''
	pass


def RemoveAssociation(
		ioOwnerObj , # HANDLE  -  
		inKind     , # INTEGER -  
		ioTargetObj  # HANDLE  -  
		):
	'''
		Python: BOOLEAN = vs.RemoveAssociation(ioOwnerObj, inKind, ioTargetObj)
		VectorScript: FUNCTION RemoveAssociation(ioOwnerObj:HANDLE; inKind:INTEGER; ioTargetObj:HANDLE) : BOOLEAN;
		
		Category: Object Events
	'''
	pass
	return 'BOOLEAN' # 


def RemoveChoice(
		dialogID   , # LONGINT - The dialog identifier given by CreateLayout or CreateResizableLayout
		componentID, # LONGINT - The identifier of the control that will have its menu item removed. 
		itemIndex    # INTEGER - The zero-based index of the menu item to remove.                    
		):
	'''
		Python: vs.RemoveChoice(dialogID, componentID, itemIndex)
		VectorScript: PROCEDURE RemoveChoice(dialogID:LONGINT; componentID:LONGINT; itemIndex:INTEGER);
		
		Category: Dialogs - Modern
		Remove a menu item from a control that can display a menu.
	'''
	pass


def RemoveCustomTexParts(
		obj  # HANDLE - The object from which to remove custom texture parts.
		):
	'''
		Python: vs.RemoveCustomTexParts(obj)
		VectorScript: PROCEDURE RemoveCustomTexParts(obj:HANDLE);
		
		Category: Textures
		This routine removes all custom texture parts from the object.
	'''
	pass


def RemoveEnhancedPullDownMenuItemRange(
		dialogID               , # LONGINT -  
		componentID            , # LONGINT -  
		iStartItemIndexToRemove, # INTEGER -  
		iEndItemIndexToRemove    # INTEGER -  
		):
	'''
		Python: vs.RemoveEnhancedPullDownMenuItemRange(dialogID, componentID, iStartItemIndexToRemove, iEndItemIndexToRemove)
		VectorScript: PROCEDURE RemoveEnhancedPullDownMenuItemRange(dialogID:LONGINT; componentID:LONGINT; iStartItemIndexToRemove:INTEGER; iEndItemIndexToRemove:INTEGER);
		
		Category: Dialogs - Modern
		Removes the specified range of items from the specified Layout Manager enhanced pull down menu control.
	'''
	pass


def RemoveFrmPluginStyle(
		hSymDef , # HANDLE - Handle to symbol definition containing a plug-in style.
		itemName  # STRING - Name of the item to remove from the plug-in style.     
		):
	'''
		Python: BOOLEAN = vs.RemoveFrmPluginStyle(hSymDef, itemName)
		VectorScript: FUNCTION RemoveFrmPluginStyle(hSymDef:HANDLE; itemName:STRING) : BOOLEAN;
		
		Category: Objects - Symbols
		Removes an entry from the plug-in style map.
	'''
	pass
	return 'BOOLEAN' # TRUE if the item was removed from the plug-in style.[[BR]]FALSE if the item does not exist in the plug-in style or the symbol definition does not contain a plugin style.


def RemoveGradientSegment(
		gradient    , # HANDLE  - Gradient from which to remove a segment.                           
		segmentIndex  # INTEGER - Index of segment to be removed.[[BR]](segment indexes begin with 1)
		):
	'''
		Python: vs.RemoveGradientSegment(gradient, segmentIndex)
		VectorScript: PROCEDURE RemoveGradientSegment(gradient:HANDLE; segmentIndex:INTEGER);
		
		Category: Document Attributes
		Removes the specified segment from the specified gradient.
	'''
	pass


def RemoveGradientSliderSegment(
		dialogID    , # LONGINT - Index to the dialog layout that contains the gradient slider component.
		componentID , # LONGINT - Index to a specific gradient slider component.                         
		segmentIndex  # INTEGER - Index to segment to be removed.[[BR]](segment indexes begin with 1)    
		):
	'''
		Python: vs.RemoveGradientSliderSegment(dialogID, componentID, segmentIndex)
		VectorScript: PROCEDURE RemoveGradientSliderSegment(dialogID:LONGINT; componentID:LONGINT; segmentIndex:INTEGER);
		
		Category: Dialogs - Modern
		Removes the specified segment from the gradient slider.
		Note: a gradient slider must always have at least 2 segments.
	'''
	pass


def RemoveImagePopupItem(
		dialogID   , # LONGINT - Index to the dialog layout that contains the image popup component.
		componentID, # LONGINT - Index to a specific image popup component.                         
		itemIndex    # INTEGER - Index to item to be removed.                                       
		):
	'''
		Python: vs.RemoveImagePopupItem(dialogID, componentID, itemIndex)
		VectorScript: PROCEDURE RemoveImagePopupItem(dialogID:LONGINT; componentID:LONGINT; itemIndex:INTEGER);
		
		Category: Dialogs - Modern
		Removes the specified item from the image popup.
	'''
	pass


def RemoveLBColumnDataItem(
		dialogID           , # LONGINT - id of the dialog that contains the list browser
		componentID        , # LONGINT - id of the list browser control                 
		columnIndex        , # INTEGER - the index of the column                        
		columnDataItemIndex  # INTEGER - the column data item to remove                 
		):
	'''
		Python: BOOLEAN = vs.RemoveLBColumnDataItem(dialogID, componentID, columnIndex, columnDataItemIndex)
		VectorScript: FUNCTION RemoveLBColumnDataItem(dialogID:LONGINT; componentID:LONGINT; columnIndex:INTEGER; columnDataItemIndex:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern - Browser
		Removes the specified column data item.
	'''
	pass
	return 'BOOLEAN' # 


def RemoveListBoxTabStop(
		dialogID, # LONGINT - ID of the dialog  
		itemID    # LONGINT - ID of the list box
		):
	'''
		Python: vs.RemoveListBoxTabStop(dialogID, itemID)
		VectorScript: PROCEDURE RemoveListBoxTabStop(dialogID:LONGINT; itemID:LONGINT);
		
		Category: Dialogs - Modern
		Removes the last tab stop from a Layout Manager list box.
	'''
	pass


def RemovePIOStyleEdit(
		hObj   , # HANDLE - Handle to a plug-in object or plug-in style
		keyName  # STRING - Name of item to remove from list.          
		):
	'''
		Python: BOOLEAN = vs.RemovePIOStyleEdit(hObj, keyName)
		VectorScript: FUNCTION RemovePIOStyleEdit(hObj:HANDLE; keyName:STRING) : BOOLEAN;
		
		Category: Objects - Custom
		Removes an item from the edit style mapping list.
	'''
	pass
	return 'BOOLEAN' # TRUE if item is removed from list.[[BR]][[BR]]FALSE if hObj is NULL; if hObj is not a styled plug-in object or plug-in style[[BR]]FALSE if item does not appear in list.


def RemoveRoofEdge(
		roofObject, # HANDLE  - Handle to roof.                  
		index       # INTEGER - Index of roof edge to be removed.
		):
	'''
		Python: BOOLEAN = vs.RemoveRoofEdge(roofObject, index)
		VectorScript: FUNCTION RemoveRoofEdge(roofObject:HANDLE; index:INTEGER) : BOOLEAN;
		
		Category: Objects - Roofs
		Function RemoveRoofEdge removes the specified roof edge from the referenced roof object.
	'''
	pass
	return 'BOOLEAN' # 


def RemoveRoofElement(
		roofObject, # HANDLE  - Handle to roof.         
		id          # INTEGER - Index of dormer element.
		):
	'''
		Python: vs.RemoveRoofElement(roofObject, id)
		VectorScript: PROCEDURE RemoveRoofElement(roofObject:HANDLE; id:INTEGER);
		
		Category: Objects - Roofs
		Procedure RemoveRoofElement removes the specified roof element from the referenced roof.
	'''
	pass


def RemoveStoryLevel(
		storyHandle , # HANDLE  - The handle of the story we want to deleted a Story Level from.                                                   
		levelType   , # STRING  - The level type of the Story Level we want to remove from 'storyHandle'.                                          
		bDeleteLayer  # BOOLEAN - If this is true, and the requested Story Level has a layer associated with it, the layer will be deleted as well.
		):
	'''
		Python: BOOLEAN = vs.RemoveStoryLevel(storyHandle, levelType, bDeleteLayer)
		VectorScript: FUNCTION RemoveStoryLevel(storyHandle:HANDLE; levelType:STRING; bDeleteLayer:BOOLEAN) : BOOLEAN;
		
		Category: Layers
		Removes the Story Level matching 'levelType'  from a Story.  If 'bDeleteLayer' is true and the Story Level has an associated layer, the layer will be deleted as well.
	'''
	pass
	return 'BOOLEAN' # Whether a Story Level with 'layerType' was found in the Story and successfully removed.


def RemoveTreeControlItem(
		nDialogID   , # LONGINT -  
		nComponentID, # LONGINT -  
		nItemID       # INTEGER -  
		):
	'''
		Python: BOOLEAN = vs.RemoveTreeControlItem(nDialogID, nComponentID, nItemID)
		VectorScript: FUNCTION RemoveTreeControlItem(nDialogID:LONGINT; nComponentID:LONGINT; nItemID:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern
		Removes an item from a Layout Manager tree control.
	'''
	pass
	return 'BOOLEAN' # 


def RemoveVPClOvrd(
		viewportHandle, # HANDLE - The viewport handle.  
		clasName        # STRING - The name of the class.
		):
	'''
		Python: vs.RemoveVPClOvrd(viewportHandle, className)
		VectorScript: PROCEDURE RemoveVPClOvrd(viewportHandle:HANDLE; className:STRING);
		
		Category: Viewports
		Removes a class override from the specified viewport.
	'''
	pass


def RemoveVPLrOvrd(
		viewportHandle, # HANDLE - The viewport handle.
		layerHandle     # HANDLE - The layer handle.   
		):
	'''
		Python: vs.RemoveVPLrOvrd(viewportHandle, layerHandle)
		VectorScript: PROCEDURE RemoveVPLrOvrd(viewportHandle:HANDLE; layerHandle:HANDLE);
		
		Category: Viewports
		Removes a layer override.
	'''
	pass


def RemoveWSColumnOperator(
		worksheet   , # HANDLE  - Handle to worksheet.       
		databaseRow , # INTEGER - Database row to be queried.
		column      , # INTEGER - Column to be queried.      
		operatorType  # INTEGER - Operator type.             
		):
	'''
		Python: vs.RemoveWSColumnOperator(worksheet, databaseRow, column, operatorType)
		VectorScript: PROCEDURE RemoveWSColumnOperator(worksheet:HANDLE; databaseRow:INTEGER; column:INTEGER; operatorType:INTEGER);
		
		Category: Worksheets
		Removes database column operator from specified column.
	'''
	pass


def RenameClass(
		clasName , # STRING - Existing name of the class.
		newName    # STRING - New name for the class.    
		):
	'''
		Python: vs.RenameClass(className, newName)
		VectorScript: PROCEDURE RenameClass(className:STRING; newName:STRING);
		
		Category: Classes
		Renames the specified class.
		All objects assigned to the class being renamed are updated.
	'''
	pass


def ReplaceIFCWithMap(
		hObject     , # HANDLE -  
		inStrObjName  # STRING -  
		):
	'''
		Python: BOOLEAN = vs.ReplaceIFCWithMap(hObject, inStrObjName)
		VectorScript: FUNCTION ReplaceIFCWithMap(hObject:HANDLE; inStrObjName:STRING) : BOOLEAN;
		
		Category: IFC
		Replaces the existing IFC Data record with info from IFC Data Mapping.
	'''
	pass
	return 'BOOLEAN' # 


def ResetBBox(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: vs.ResetBBox(h)
		VectorScript: PROCEDURE ResetBBox(h:HANDLE);
		
		Category: Object Editing
		Procedure ResetBBox forces the bounding box information for the specified object to be recomputed based on the objects' current geometry.
		Call this procedure after modifying an object to force a redraw of the object.
	'''
	pass


def ResetDefStoryLevels(
		bDeleteExisting  # BOOLEAN - Whether to delete existing default story levels before reloading the original defaults.
		):
	'''
		Python: BOOLEAN = vs.ResetDefStoryLevels(bDeleteExisting)
		VectorScript: FUNCTION ResetDefStoryLevels(bDeleteExisting:BOOLEAN) : BOOLEAN;
		
		Category: Layers
		Clears default story levels and repopulates the list from XML data files on disk.
	'''
	pass
	return 'BOOLEAN' # Whether clearing the previous default story levels and loading the default list from disk succeeded.


def ResetObject(
		objectHandle  # HANDLE - Handle to the object to be reset.
		):
	'''
		Python: vs.ResetObject(objectHandle)
		VectorScript: PROCEDURE ResetObject(objectHandle:HANDLE);
		
		Category: Utility
		Update the specified object using the current settings and parameter values.  This will reset the bounding box of the object.  If the object is in a wall, then the wall is reset also.
		An object of any type may be passed to this function to have its boundary reset.  The following object types will be reset in a way that is appropriate for each type: Plug-in Object, Symbol Definition, Wall, Roof Container, Bitmap, Picture, Dimension, Extrude, Multiple Extrude, Sweep, Polygon, Polyline, Worksheet.
	'''
	pass


def ResetOrientation3D():
	'''
		Python: vs.ResetOrientation3D()
		VectorScript: PROCEDURE ResetOrientation3D;
		
		Category: General Edit
		ResetOrientation3D resets the 3D environment parameters of the active Vectorworks document.
		Call this procedure after 3D object creation to ensure correct orientation and display of the new object in 3D space.
	'''
	pass


def ResList_AddCont(
		uniqueID  , # STRING  -  
		folderSpec  # INTEGER -  
		):
	'''
		Python: vs.ResList_AddCont(uniqueID, folderSpec)
		VectorScript: PROCEDURE ResList_AddCont(uniqueID:STRING; folderSpec:INTEGER);
		
		Category: Document List Handling
		Adds a content location. The 'uniqueID' is a string identifier uniquely identifying this control.
	'''
	pass


def ResList_AddCont1(
		uniqueID      , # STRING             -  
		baseFolderSpec, # INTEGER            -  
		folderName      # DYNARRAY[] of CHAR -  
		):
	'''
		Python: vs.ResList_AddCont1(uniqueID, baseFolderSpec, folderName)
		VectorScript: PROCEDURE ResList_AddCont1(uniqueID:STRING; baseFolderSpec:INTEGER; folderName:DYNARRAY of CHAR);
		
		Category: Document List Handling
		Adds a content lcoation. The 'uniqueID' is a string identifier uniquely identifying this control.
	'''
	pass


def ResList_DlgInit(
		uniqueID, # STRING  -  
		dlgID   , # INTEGER -  
		ctrlID    # INTEGER -  
		):
	'''
		Python: vs.ResList_DlgInit(uniqueID, dlgID, ctrlID)
		VectorScript: PROCEDURE ResList_DlgInit(uniqueID:STRING; dlgID:INTEGER; ctrlID:INTEGER);
		
		Category: Tool Events
		Use this call during dialog initialization to associate a popup control or resource popup and initialized by the ResList_* calls of the uniqueID identifying the resource list data.
	'''
	pass


def ResList_GetSel(
		uniqueID  # STRING -  
		):
	'''
		Python: STRING = vs.ResList_GetSel(uniqueID)
		VectorScript: FUNCTION ResList_GetSel(uniqueID:STRING) : STRING;
		
		Category: Document List Handling
		Return the selected item from the popup. The 'uniqueID' is a string identifier uniquely identifying this control.
	'''
	pass
	return 'STRING' # 


def ResList_GetSelIsDoc(
		uniqueID  # STRING -  
		):
	'''
		Python: BOOLEAN = vs.ResList_GetSelIsDoc(uniqueID)
		VectorScript: FUNCTION ResList_GetSelIsDoc(uniqueID:STRING) : BOOLEAN;
		
		Category: Document List Handling
		Return if the selected resource is in the current document. The 'uniqueID' is a string identifier uniquely identifying this control.
	'''
	pass
	return 'BOOLEAN' # 


def ResList_ImportItem(
		uniqueID  # STRING -  
		):
	'''
		Python: HANDLE = vs.ResList_ImportItem(uniqueID)
		VectorScript: FUNCTION ResList_ImportItem(uniqueID:STRING) : HANDLE;
		
		Category: Document List Handling
		Import the currently selected item. This is the list that typically is created by call to BuildResourceList. The 'uniqueID' is a string identifier uniquely identifying this control.
	'''
	pass
	return 'HANDLE' # 


def ResList_ImportItemN(
		uniqueID  , # STRING  -  
		doConflict  # LONGINT -  
		):
	'''
		Python: HANDLE = vs.ResList_ImportItemN(uniqueID, doConflict)
		VectorScript: FUNCTION ResList_ImportItemN(uniqueID:STRING; doConflict:LONGINT) : HANDLE;
		
		Category: Document List Handling
		Import the currently selected item. doConflict: 0 - dont import; 1 - replace; 2 - rename; 3 - ask with UI. The 'uniqueID' is a string identifier uniquely identifying this control.
	'''
	pass
	return 'HANDLE' # 


def ResList_Init(
		uniqueID  , # STRING  -  
		objectType  # INTEGER -  
		):
	'''
		Python: vs.ResList_Init(uniqueID, objectType)
		VectorScript: PROCEDURE ResList_Init(uniqueID:STRING; objectType:INTEGER);
		
		Category: Document List Handling
		Initialize a categories resource with resources of the specified type. The 'uniqueID' is a string identifier uniquely identifying this control.
	'''
	pass


def ResList_InitDef(
		uniqueID, # STRING -  
		univName  # STRING -  
		):
	'''
		Python: vs.ResList_InitDef(uniqueID, univName)
		VectorScript: PROCEDURE ResList_InitDef(uniqueID:STRING; univName:STRING);
		
		Category: Document List Handling
		Initialize a categories resource with red symbol resources of the specified universal name. The 'uniqueID' is a string identifier uniquely identifying this control.
	'''
	pass


def ResList_IsSelValid(
		uniqueID  # STRING -  
		):
	'''
		Python: BOOLEAN = vs.ResList_IsSelValid(uniqueID)
		VectorScript: FUNCTION ResList_IsSelValid(uniqueID:STRING) : BOOLEAN;
		
		Category: Document List Handling
		Determine if the selection in the popup is valid. The 'uniqueID' is a string identifier uniquely identifying this control.
	'''
	pass
	return 'BOOLEAN' # 


def ResList_SetSel(
		uniqueID, # STRING -  
		itemName  # STRING -  
		):
	'''
		Python: vs.ResList_SetSel(uniqueID, itemName)
		VectorScript: PROCEDURE ResList_SetSel(uniqueID:STRING; itemName:STRING);
		
		Category: Document List Handling
		Set the selected item in the resource popup. The 'uniqueID' is a string identifier uniquely identifying this control.
	'''
	pass


def ResolveByClassTextureRef(
		obj   , # HANDLE  - Handle to object.                                         
		partID  # INTEGER - Primary, secondary, or tertiary texture ID to be returned.
		):
	'''
		Python: LONGINT = vs.ResolveByClassTextureRef(obj, partID)
		VectorScript: FUNCTION ResolveByClassTextureRef(obj:HANDLE; partID:INTEGER) : LONGINT;
		
		Category: Textures
		Function ResolveByClassTextureRef returns the internal index, or name, of the texture assigned to the referenced object.
		Primary, secondary, or tertiary texture assignments can be returned for objects that support multiple textures, such as roofs or walls. For objects that do not support multiple textures, pass 0 to the partID parameter.
	'''
	pass
	return 'LONGINT' # 


def ResourceListSize(
		listID  # LONGINT - an ID for a resouce list created by the BuildResourceList function.
		):
	'''
		Python: LONGINT = vs.ResourceListSize(listID)
		VectorScript: FUNCTION ResourceListSize(listID:LONGINT) : LONGINT;
		
		Category: Document List Handling
		Returns the number of items in the specified resource list.
	'''
	pass
	return 'LONGINT' # 


def RetrieveCustomRWPrefs(
		):
	'''
		Python: (useTextures, useTransparency, useShadows, useRayTracing, useAntiAliasing, useDithering, tessellationDetail, shadowStyle, rayTracingRecursion) = vs.RetrieveCustomRWPrefs()
		VectorScript: PROCEDURE RetrieveCustomRWPrefs(VAR useTextures:BOOLEAN; VAR useTransparency:BOOLEAN; VAR useShadows:BOOLEAN; VAR useRayTracing:BOOLEAN; VAR useAntiAliasing:BOOLEAN; VAR useDithering:BOOLEAN; VAR tessellationDetail:INTEGER; VAR shadowStyle:INTEGER; VAR rayTracingRecursion:INTEGER);
		
		Category: View / Zoom
		Retrieves the current custom RenderWorks rendering preferences from data stored in the current drawing.
	'''
	pass
	return ( False, 
	         False, 
	         False, 
	         False, 
	         False, 
	         False, 
	         0    , 
	         0    , 
	         0     )


def RetrieveHLPrefs(
		):
	'''
		Python: (smoothingAngle, lineStyle, shadeFactorIndex, doIntersections) = vs.RetrieveHLPrefs()
		VectorScript: PROCEDURE RetrieveHLPrefs(VAR smoothingAngle:REAL; VAR lineStyle:INTEGER; VAR shadeFactorIndex:INTEGER; VAR doIntersections:BOOLEAN);
		
		Category: View / Zoom
		Retrieves the current Hidden Line rendering preferences from data stored in the current drawing.
	'''
	pass
	return ( 0.0  , 
	         0    , 
	         0    , 
	         False )


def RetrieveOpenGLPrefs(
		):
	'''
		Python: (useTextures, tessellationDetail, useNURBS) = vs.RetrieveOpenGLPrefs()
		VectorScript: PROCEDURE RetrieveOpenGLPrefs(VAR useTextures:BOOLEAN; VAR tessellationDetail:INTEGER; VAR useNURBS:BOOLEAN);
		
		Category: View / Zoom
		Retrieves the current OpenGL rendering preferences from data stored in the current drawing.
	'''
	pass
	return ( False, 
	         0    , 
	         False )


def ReverseWallSides(
		theWall  # HANDLE - Handle to the wall to operate on.
		):
	'''
		Python: vs.ReverseWallSides(theWall)
		VectorScript: PROCEDURE ReverseWallSides(theWall:HANDLE);
		
		Category: Objects - Walls
		Switch the left and right side of a wall by reversing the direction of the wall.  This is an interface to the button with the same name on the Object Info palette.
	'''
	pass


def RevolveWithRail(
		profileH, # HANDLE - Handle to a NURBS curve to be used as the profile object.                    
		railH   , # HANDLE - Handle to a NURBS curve to be used as the rail guide object                  
		axisH     # HANDLE - Handle to a linear NURBS curve about which the[[BR]]profile would be revolved
		):
	'''
		Python: HANDLE = vs.RevolveWithRail(profileH, railH, axisH)
		VectorScript: FUNCTION RevolveWithRail(profileH:HANDLE; railH:HANDLE; axisH:HANDLE) : HANDLE;
		
		Category: Objects - NURBS
		Creates a NURBS surface or a group of surfaces by revolving a profile about an axis and following a rail guide curve on a plane perpendicular to the plane containing the axis and the profile.
	'''
	pass
	return 'HANDLE' # Handle to resulting NURBS surface.


def Rewrite(
		fileName  # DYNARRAY[] of CHAR - Name of file.
		):
	'''
		Python: vs.Rewrite(fileName)
		VectorScript: PROCEDURE Rewrite(fileName:DYNARRAY of CHAR);
		
		Category: File I/O
		Procedure Rewrite creates a new ASCII text file or opens an existing one prior to writing data to the file.  If the file exists, new data written to the file will overwrite any data currently within the file.
	'''
	pass


def RGBToColorIndex(
		red  , # LONGINT - RGB color component value.
		green, # LONGINT - RGB color component value.
		blue   # LONGINT - RGB color component value.
		):
	'''
		Python: color = vs.RGBToColorIndex(red, green, blue)
		VectorScript: PROCEDURE RGBToColorIndex(red:LONGINT; green:LONGINT; blue:LONGINT; VAR color:INTEGER);
		
		Category: Utility
		Procedure RGBToColorIndex converts the Vectorworks palette colors from its' red, green, and blue component values to the colors' palette position index. Parameters red, green, and blue return the color components of the swatch, and parameter color is the palette position ID of the color swatch. RGB values are in the range of 0 65535.
	'''
	pass
	return ( 0 )


def RGBToColorIndexN(
		red                  , # LONGINT - RGB color component value.                        
		green                , # LONGINT - RGB color component value.                        
		blue                 , # LONGINT - RGB color component value.                        
		ignoreBlackBackground  # BOOLEAN - Ignore black background preference setting or not.
		):
	'''
		Python: color = vs.RGBToColorIndexN(red, green, blue, ignoreBlackBackground)
		VectorScript: PROCEDURE RGBToColorIndexN(red:LONGINT; green:LONGINT; blue:LONGINT; VAR color:INTEGER; ignoreBlackBackground:BOOLEAN);
		
		Category: Utility
		Procedure RGBToColorIndexN converts the Vectorworks palette colors from its' red, green, and blue component values to the Vectorworks color index. Parameters red, green, and blue return the color components of the swatch, and parameter color is the Vectorworks color index. RGB values are in the range of 0 65535. Parameter ignoreBlackBackground specifies whether the black background preference should be ignored. If set to TRUE, black and white indexes will not be inverted in black background.
	'''
	pass
	return ( 0 )


def RightBound(
		c  # CRITERIA - Search criteria.
		):
	'''
		Python: REAL = vs.RightBound(c)
		VectorScript: FUNCTION RightBound(c:CRITERIA) : REAL;
		
		Category: Criteria
		Returns the x-coordinate of the bounding box (bottom right corner) of an object matching the search criteria If more than one object matches the search criteria, the function will return the sum of the coordinates of all the matching objects.
	'''
	pass
	return 'REAL' # 


def RightBoundN(
		c  # CRITERIA - Search criteria.
		):
	'''
		Python: REAL = vs.RightBoundN(c)
		VectorScript: FUNCTION RightBoundN(c:CRITERIA) : REAL;
		
		Category: Criteria
		Returns the x-coordinate of the bounding box (bottom right corner) of an object matching the search criteria If more than one object matches the search criteria, the function will return the value of the coordinate of the rightmost matching object found.
	'''
	pass
	return 'REAL' # 


def RiseRunFromDeg(
		fSlopeDeg  # REAL -  
		):
	'''
		Python: STRING = vs.RiseRunFromDeg(fSlopeDeg)
		VectorScript: FUNCTION RiseRunFromDeg(fSlopeDeg:REAL) : STRING;
		
		Category: SiteModel Interface Library
		Converts slope from degrees to rise-over-run string.
	'''
	pass
	return 'STRING' # 


def Road_GetStationCount(
		hRoadwayObject  # HANDLE -  
		):
	'''
		Python: LONGINT = vs.Road_GetStationCount(hRoadwayObject)
		VectorScript: FUNCTION Road_GetStationCount(hRoadwayObject:HANDLE) : LONGINT;
		
		Category: Roadway Interface Library
		Return count of stations of the Roadway (Poly) object.
	'''
	pass
	return 'LONGINT' # 


def Road_GetStationPoint(
		hRoadwayObject, # HANDLE  -  
		index           # LONGINT -  
		):
	'''
		Python: RETURN = vs.Road_GetStationPoint(hRoadwayObject, index)
		VectorScript: PROCEDURE Road_GetStationPoint(hRoadwayObject:HANDLE; index:LONGINT; VAR RETURNX, RETURNY, RETURNZ:REAL);
		
		Category: Roadway Interface Library
		Return 3D point of the station that is related with the Roadway (Poly) object.
	'''
	pass
	return ( 0,0,0 )


def Road_InsertStation(
		hRoadwayObject, # HANDLE  -  
		point           # POINT3D -  
		):
	'''
		Python: vs.Road_InsertStation(hRoadwayObject, point)
		VectorScript: PROCEDURE Road_InsertStation(hRoadwayObject:HANDLE; pointX, pointY, pointZ:REAL);
		
		Category: Roadway Interface Library
		Insert a new station to the Roadway (Poly) object.
	'''
	pass


def RoofArea_Heated(
		c  # CRITERIA -  
		):
	'''
		Python: REAL = vs.RoofArea_Heated(c)
		VectorScript: FUNCTION RoofArea_Heated(c:CRITERIA) : REAL;
		
		Category: Criteria
		Returns the heated (interior) area along the slope of roofs or roof faces  that meet the criteria.
	'''
	pass
	return 'REAL' # 


def RoofArea_HeatedProj(
		c  # CRITERIA -  
		):
	'''
		Python: REAL = vs.RoofArea_HeatedProj(c)
		VectorScript: FUNCTION RoofArea_HeatedProj(c:CRITERIA) : REAL;
		
		Category: Criteria
		Returns the heated (interior) area projected on the ground plane of roofs or roof faces that meet the criteria.
	'''
	pass
	return 'REAL' # 


def RoofArea_Total(
		c  # CRITERIA -  
		):
	'''
		Python: REAL = vs.RoofArea_Total(c)
		VectorScript: FUNCTION RoofArea_Total(c:CRITERIA) : REAL;
		
		Category: Criteria
		Returns the total area along the slope of roofs or roof faces that meet the criteria.
	'''
	pass
	return 'REAL' # 


def RoofArea_TotalProj(
		c  # CRITERIA -  
		):
	'''
		Python: REAL = vs.RoofArea_TotalProj(c)
		VectorScript: FUNCTION RoofArea_TotalProj(c:CRITERIA) : REAL;
		
		Category: Criteria
		Returns the total area projected on the ground plane of roofs or roof faces that meet the criteria.
	'''
	pass
	return 'REAL' # 


def Rotate(
		rotationAngle  # REAL - Rotation angle.
		):
	'''
		Python: vs.Rotate(rotationAngle)
		VectorScript: PROCEDURE Rotate(rotationAngle:REAL);
		
		Category: General Edit
		Procedure Rotate rotates the currently selected objects on the active layer. The rotation angle may be specified in any valid angle format. When a locus is selected with a group of objects, the objects are rotated around the locus. If two or more loci are selected, the objects are rotated around the center of the selected objects.
	'''
	pass


def Rotate3D(
		xAngle, # REAL - Rotation about X-axis.
		yAngle, # REAL - Rotation about Y-axis 
		zAngle  # REAL - Rotation about Z-axis.
		):
	'''
		Python: vs.Rotate3D(xAngle, yAngle, zAngle)
		VectorScript: PROCEDURE Rotate3D(xAngle:REAL; yAngle:REAL; zAngle:REAL);
		
		Category: General Edit
		Procedure Rotate3D rotates the most recently created three-dimensional object. Rotation values are applied about the respective axes.
	'''
	pass


def RotatePoint(
		p            , # POINT - Point of rotation.
		rotationAngle  # REAL  - Rotation angle.   
		):
	'''
		Python: vs.RotatePoint(p, rotationAngle)
		VectorScript: PROCEDURE RotatePoint(pX, pY:REAL; rotationAngle:REAL);
		
		Category: General Edit
		Procedure RotatePoint rotates selected Vectorworks objects about the specified coordinate point.
	'''
	pass


def Round(
		v  # REAL - Real value to round.
		):
	'''
		Python: LONGINT = vs.Round(v)
		VectorScript: FUNCTION Round(v:REAL) : LONGINT;
		
		Category: Math - General
		Function Round converts the specified REAL value to a LONGINT value. The LONGINT result is the value rounded to the nearest whole number.
	'''
	pass
	return 'LONGINT' # 


def RoundWall(
		centerPt, # POINT - Center point of wall arc.
		startPt , # POINT - Start point of wall arc. 
		endPt     # POINT - End point of wall arc.   
		):
	'''
		Python: vs.RoundWall(centerPt, startPt, endPt)
		VectorScript: PROCEDURE RoundWall(centerPtX, centerPtY:REAL; startPtX, startPtY:REAL; endPtX, endPtY:REAL);
		
		Category: Objects - Walls
		Procedure RoundWall creates a counter-clockwise round wall.
	'''
	pass


def Rpstr_GetValueBool(
		name        , # STRING  - The name of the value.                                                        
		defaultValue  # BOOLEAN - Default value if the name does not exist in the VectorScript value repository.
		):
	'''
		Python: BOOLEAN = vs.Rpstr_GetValueBool(name, defaultValue)
		VectorScript: FUNCTION Rpstr_GetValueBool(name:STRING; defaultValue:BOOLEAN) : BOOLEAN;
		
		Category: Utility
		Get a boolean value from the VectorScript value repository.
	'''
	pass
	return 'BOOLEAN' # 


def Rpstr_GetValueInt(
		name        , # STRING  - The name of the value.                                                        
		defaultValue  # INTEGER - Default value if the name does not exist in the VectorScript value repository.
		):
	'''
		Python: INTEGER = vs.Rpstr_GetValueInt(name, defaultValue)
		VectorScript: FUNCTION Rpstr_GetValueInt(name:STRING; defaultValue:INTEGER) : INTEGER;
		
		Category: Utility
		Get an integer value from the VectorScript value repository.
	'''
	pass
	return 'INTEGER' # 


def Rpstr_GetValueReal(
		name        , # STRING - The name of the value.                                                        
		defaultValue  # REAL   - Default value if the name does not exist in the VectorScript value repository.
		):
	'''
		Python: REAL = vs.Rpstr_GetValueReal(name, defaultValue)
		VectorScript: FUNCTION Rpstr_GetValueReal(name:STRING; defaultValue:REAL) : REAL;
		
		Category: Utility
		Get a real value from the VectorScript value repository.
	'''
	pass
	return 'REAL' # 


def Rpstr_GetValueStr(
		name        , # STRING             - The name of the value.                                                        
		defaultValue  # DYNARRAY[] of CHAR - Default value if the name does not exist in the VectorScript value repository.
		):
	'''
		Python: DYNARRAY of CHAR = vs.Rpstr_GetValueStr(name, defaultValue)
		VectorScript: FUNCTION Rpstr_GetValueStr(name:STRING; defaultValue:DYNARRAY of CHAR) : DYNARRAY of CHAR;
		
		Category: Utility
		Get a string value from the VectorScript value repository.
	'''
	pass
	return 'DYNARRAY[] of CHAR' # 


def Rpstr_RemoveValue(
		name  # STRING - The name of the value.
		):
	'''
		Python: BOOLEAN = vs.Rpstr_RemoveValue(name)
		VectorScript: FUNCTION Rpstr_RemoveValue(name:STRING) : BOOLEAN;
		
		Category: Utility
		Removes a named value from the VectorScript value repository.
	'''
	pass
	return 'BOOLEAN' # Return true if the value was found and removed.


def Rpstr_RemoveValues():
	'''
		Python: vs.Rpstr_RemoveValues()
		VectorScript: PROCEDURE Rpstr_RemoveValues;
		
		Category: Utility
		Removes all values from the VectorScript value repository.
	'''
	pass


def Rpstr_SetValueBool(
		name , # STRING  - The name of the value.                                                    
		value  # BOOLEAN - Set a value associated with the name in the VectorScript value repository.
		):
	'''
		Python: vs.Rpstr_SetValueBool(name, value)
		VectorScript: PROCEDURE Rpstr_SetValueBool(name:STRING; value:BOOLEAN);
		
		Category: Utility
		Set a boolean value from the VectorScript value repository.
	'''
	pass


def Rpstr_SetValueInt(
		name , # STRING  - The name of the value.                                                    
		value  # INTEGER - Set a value associated with the name in the VectorScript value repository.
		):
	'''
		Python: vs.Rpstr_SetValueInt(name, value)
		VectorScript: PROCEDURE Rpstr_SetValueInt(name:STRING; value:INTEGER);
		
		Category: Utility
		Set an integer value from the VectorScript value repository.
	'''
	pass


def Rpstr_SetValueReal(
		name , # STRING - The name of the value.                                                    
		value  # REAL   - Set a value associated with the name in the VectorScript value repository.
		):
	'''
		Python: vs.Rpstr_SetValueReal(name, value)
		VectorScript: PROCEDURE Rpstr_SetValueReal(name:STRING; value:REAL);
		
		Category: Utility
		Set a real value from the VectorScript value repository.
	'''
	pass


def Rpstr_SetValueStr(
		name , # STRING             - The name of the value.                                                    
		value  # DYNARRAY[] of CHAR - Set a value associated with the name in the VectorScript value repository.
		):
	'''
		Python: vs.Rpstr_SetValueStr(name, value)
		VectorScript: PROCEDURE Rpstr_SetValueStr(name:STRING; value:DYNARRAY of CHAR);
		
		Category: Utility
		Set a string value from the VectorScript value repository.
	'''
	pass


def RRect(
		p1  , # POINT - Top left coordinate of rectangle.    
		p2  , # POINT - Bottom right coordinate of rectangle.
		Diam  # POINT - X and Y diameters of corner.         
		):
	'''
		Python: vs.RRect(p1, p2, Diam)
		VectorScript: PROCEDURE RRect(p1X, p1Y:REAL; p2X, p2Y:REAL; DiamDX, DiamDY:REAL);
		
		Category: Objects - 2D
		Procedure RRect creates a rounded rectangle object in a Vectorworks document.
		Corner definition is controlled by parameter Diam, which determines the "roundness" of the rectangle corners. The X and Y components of Diam correspond to the major and minor axes of an oval defining the rectangle corner.
	'''
	pass


def RRectangleN(
		orgin    , # POINT -  
		direction, # POINT -  
		width    , # REAL  -  
		height   , # REAL  -  
		xDiam    , # REAL  -  
		yDiam      # REAL  -  
		):
	'''
		Python: vs.RRectangleN(orgin, direction, width, height, xDiam, yDiam)
		VectorScript: PROCEDURE RRectangleN(orginX, orginY:REAL; directionX, directionY:REAL; width:REAL; height:REAL; xDiam:REAL; yDiam:REAL);
		
		Category: Objects - 2D
		Creates and returns a handle to a new rotated rectangle object with the specified bounds
	'''
	pass


def RunColorPaletteMgr():
	'''
		Python: BOOLEAN = vs.RunColorPaletteMgr()
		VectorScript: FUNCTION RunColorPaletteMgr : BOOLEAN;
		
		Category: Color
		Runs the Color Palette Manager
	'''
	pass
	return 'BOOLEAN' # 


def RunLayoutDialog(
		dialogID, # LONGINT   - The index of the dialog to be displayed. 
		callback  # PROCEDURE - The event loop subroutine for the dialog.
		):
	'''
		Python: LONGINT = vs.RunLayoutDialog(dialogID, callback)
		VectorScript: FUNCTION RunLayoutDialog(dialogID:LONGINT; callback:PROCEDURE) : LONGINT;
		
		Category: Dialogs - Modern
		Displays the specified dialog and initiates the dialog event loop. The dialog event loop is specified in a procedure subroutine that is passed as a parameter to the function.
	'''
	pass
	return 'LONGINT' # Returns a LONGINT value indicating the button pressed to exit the dialog.


def RunLayoutDialogN(
		dialogID            , # LONGINT   - The index of the dialog to be displayed.               
		callback            , # PROCEDURE - The event loop subroutine for the dialog.              
		enableContextualHelp  # BOOLEAN   - Determines whether or not contextual help is accessible
		):
	'''
		Python: LONGINT = vs.RunLayoutDialogN(dialogID, callback, enableContextualHelp)
		VectorScript: FUNCTION RunLayoutDialogN(dialogID:LONGINT; callback:PROCEDURE; enableContextualHelp:BOOLEAN) : LONGINT;
		
		Category: Dialogs - Modern
		Displays the specified dialog and initiates the dialog event loop. The dialog event loop is specified in a procedure subroutine that is passed as a parameter to the function.
	'''
	pass
	return 'LONGINT' # Returns a LONGINT value indicating the button pressed to exit the dialog.


def RunNamedDialog(
		dialogID, # LONGINT   - The index of the dialog to be displayed 
		callback, # PROCEDURE - The event loop subroutine for the dialog
		univName  # STRING    - The universal name of the dialog        
		):
	'''
		Python: LONGINT = vs.RunNamedDialog(dialogID, callback, univName)
		VectorScript: FUNCTION RunNamedDialog(dialogID:LONGINT; callback:PROCEDURE; univName:STRING) : LONGINT;
		
		Category: Dialogs - Modern
		Displays the specified dialog with universal name and initiates the dialog event loop. The dialog event loop is specified in a procedure subroutine that is passed as a parameter to the function.
	'''
	pass
	return 'LONGINT' # Returns a LONGINT value indicating the button pressed to exit the dialog.


def RunNamedDialogN(
		dialogID            , # LONGINT   - The index of the dialog to be displayed                
		callback            , # PROCEDURE - The event loop subroutine for the dialog               
		univName            , # STRING    - The universal name of the dialog                       
		enableContextualHelp  # BOOLEAN   - Determines whether or not contextual help is accessible
		):
	'''
		Python: LONGINT = vs.RunNamedDialogN(dialogID, callback, univName, enableContextualHelp)
		VectorScript: FUNCTION RunNamedDialogN(dialogID:LONGINT; callback:PROCEDURE; univName:STRING; enableContextualHelp:BOOLEAN) : LONGINT;
		
		Category: Dialogs - Modern
		Displays the specified dialog with universal name and initiates the dialog event loop. The dialog event loop is specified in a procedure subroutine that is passed as a parameter to the function.
	'''
	pass
	return 'LONGINT' # Returns a LONGINT value indicating the button pressed to exit the dialog.


def RunNewColorPalette():
	'''
		Python: STRING = vs.RunNewColorPalette()
		VectorScript: FUNCTION RunNewColorPalette : STRING;
		
		Category: Color
		Runs the New Color Palette Dialog
	'''
	pass
	return 'STRING' # 


def RunPickClrFromPal(
		):
	'''
		Python: (BOOLEAN, filename, index) = vs.RunPickClrFromPal()
		VectorScript: FUNCTION RunPickClrFromPal(VAR filename:STRING; VAR index:LONGINT) : BOOLEAN;
		
		Category: Color
		Picks a color from a color palette
	'''
	pass
	return ( False   , # 
	         'string', 
	         0        )


def RunTempTool(
		toolCallback , # PROCEDURE - Procedure that will be called with the tool events.[[BR]]FUNCTION ToolCallback(action, msg1, msg2 : INTEGER) : INTEGER;                                                                                                                                        
		initialScroll  # BOOLEAN   - For experts. Pass FALSE if you want a simple temp tool. Setting it to TRUE will add one extra point (0,0) before the tool runs. This will make the tool scroll before the first click. This means that your tool handler must recognize and skip that extra fir
		):
	'''
		Python: vs.RunTempTool(toolCallback, initialScroll)
		VectorScript: PROCEDURE RunTempTool(toolCallback:PROCEDURE; initialScroll:BOOLEAN);
		
		Category: User Interactive
		Runs a temp tool. The call waits until the tool has finished. The callback function is notified for the tool events.
	'''
	pass


def SaveActiveDocument(
		filePath  # DYNARRAY[] of CHAR -  
		):
	'''
		Python: LONGINT = vs.SaveActiveDocument(filePath)
		VectorScript: FUNCTION SaveActiveDocument(filePath:DYNARRAY of CHAR) : LONGINT;
		
		Category: File I/O
		Saves a file with out presenting dialogs
	'''
	pass
	return 'LONGINT' # 


def SaveSheet(
		name     , # STRING  - Name of saved sheet. 
		saveView , # BOOLEAN - Saves view settings. 
		saveClass, # BOOLEAN - Saves class settings.
		saveLayer  # BOOLEAN - Saves layer settings.
		):
	'''
		Python: vs.SaveSheet(name, saveView, saveClass, saveLayer)
		VectorScript: PROCEDURE SaveSheet(name:STRING; saveView:BOOLEAN; saveClass:BOOLEAN; saveLayer:BOOLEAN);
		
		Category: View / Zoom
		Procedure SaveSheet saves current view, page, class, and layer settings in a new sheet with a specified name.   The saveView, saveClass and saveLayer parameters can be used to selectively not save an aspect of the view.  Also after the sheet is created, the SetObjectVariableBoolean function can be used to control whether to utilize the view, page, class or layer settings.
	'''
	pass


def Scale(
		scaleXR, # REAL - X scale factor.
		scaleYR  # REAL - Y scale factor.
		):
	'''
		Python: vs.Scale(scaleXR, scaleYR)
		VectorScript: PROCEDURE Scale(scaleXR:REAL; scaleYR:REAL);
		
		Category: General Edit
		Procedure Scale rescales selected objects. Scaling occurs about the center of the selected object(s).
	'''
	pass


def ScreenPlanePtToPlanarPt(
		refID, # LONGINT - Reference ID of the plane.       
		pt2D   # POINT   - Input the 2D point on the screen.
		):
	'''
		Python: outPt = vs.ScreenPlanePtToPlanarPt(refID, pt2D)
		VectorScript: PROCEDURE ScreenPlanePtToPlanarPt(refID:LONGINT; pt2DX, pt2DY:REAL; VAR outPtX, outPtY:REAL);
		
		Category: Utility
		Projects a 2D point from the screen plane onto the specified plane.
	'''
	pass
	return ( 0,0 )


def ScreenPtToModelPt2D(
		p  # in/out POINT - Input output parameter. Coordinates of the point to be translated.
		):
	'''
		Python: p = vs.ScreenPtToModelPt2D(p)
		VectorScript: PROCEDURE ScreenPtToModelPt2D(VAR pX, pY:REAL);
		
		Category: Objects - 2D
		Transforms a point from screen coordinate in plan rotation to the model coordinates.
	'''
	pass
	return ( 0,0 )


def ScreenVecToModelVec(
		p  # in/out POINT -  
		):
	'''
		Python: p = vs.ScreenVecToModelVec(p)
		VectorScript: PROCEDURE ScreenVecToModelVec(VAR pX, pY:REAL);
		
		Category: Objects - 2D
		Takes data from one space to another
	'''
	pass
	return ( 0,0 )


def SecondaryUnits(
		style   , # INTEGER - Active secondary unit style for document.
		dimPrec , # LONGINT - Dimension precision.                     
		format  , # INTEGER - Decimal formatting.                      
		showMark, # BOOLEAN - Unit mark display setting.               
		dispFrac  # BOOLEAN - Fractional display setting.              
		):
	'''
		Python: vs.SecondaryUnits(style, dimPrec, format, showMark, dispFrac)
		VectorScript: PROCEDURE SecondaryUnits(style:INTEGER; dimPrec:LONGINT; format:INTEGER; showMark:BOOLEAN; dispFrac:BOOLEAN);
		
		Category: Units
		Procedure SecondaryUnits sets the secondary unit parameters for the active document. The secondary units setting is used primarily for display of alternate dimensions in
		when a dual dimension standard is active.
	'''
	pass


def SelectAll():
	'''
		Python: vs.SelectAll()
		VectorScript: PROCEDURE SelectAll;
		
		Category: Selection
		Procedure SelectAll selects all visible objects on the active layer of a Vectorworks document.
		If Layer Options is set to Show-Snap-Modify Others, then SelectAll will select all visible objects within the document.
	'''
	pass


def SelectChoice(
		dialogID   , # LONGINT - the dialog identifier given by CreateLayout or CreateResizableLayout    
		componentID, # LONGINT - The identifier for the component that contains the choices.             
		itemIndex  , # INTEGER - The index of the item to set the selection state for.                   
		selectState  # BOOLEAN - True if the item at the given index should be selected. False otherwise.
		):
	'''
		Python: vs.SelectChoice(dialogID, componentID, itemIndex, selectState)
		VectorScript: PROCEDURE SelectChoice(dialogID:LONGINT; componentID:LONGINT; itemIndex:INTEGER; selectState:BOOLEAN);
		
		Category: Dialogs - Modern
		Set the selection state of the given item in a control of choices.
	'''
	pass


def SelectClassChoice(
		dialogID   , # LONGINT - Id of the dialog                                                                                                                
		componentID, # LONGINT - Id of the popup control                                                                                                         
		select       # BOOLEAN - TRUE if setting by class or FALSE if programmatically restoring the value to a non-class setting after class setting was applied
		):
	'''
		Python: vs.SelectClassChoice(dialogID, componentID, select)
		VectorScript: PROCEDURE SelectClassChoice(dialogID:LONGINT; componentID:LONGINT; select:BOOLEAN);
		
		Category: Dialogs - Modern
		Use to select the class option in a popup that ShowByClassChoice has been called on.  This function must be called with FALSE param if the popup currently has the class selection and the script wishes to change to a non-class selection.
	'''
	pass


def Selected(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: BOOLEAN = vs.Selected(h)
		VectorScript: FUNCTION Selected(h:HANDLE) : BOOLEAN;
		
		Category: Selection
		Function Selected returns the selection status of the referenced object.
	'''
	pass
	return 'BOOLEAN' # 


def SelectEditText(
		dialogID   , # LONGINT - the dialog identifier given by CreateLayout or CreateResizableLayout 
		componentID  # LONGINT - The identifier of the component that is to be activated and selected.
		):
	'''
		Python: vs.SelectEditText(dialogID, componentID)
		VectorScript: PROCEDURE SelectEditText(dialogID:LONGINT; componentID:LONGINT);
		
		Category: Dialogs - Modern
		Activates the given text component and selects its text.
	'''
	pass


def SelectObj(
		c  # CRITERIA - Search criteria.
		):
	'''
		Python: vs.SelectObj(c)
		VectorScript: PROCEDURE SelectObj(c:CRITERIA);
		
		Category: Criteria
		Selects all objects which match the search criteria.
	'''
	pass


def SelectPluginCatalog(
		hSymbol  # HANDLE - Handle to a symbol the defines a plug-in style.
		):
	'''
		Python: BOOLEAN = vs.SelectPluginCatalog(hSymbol)
		VectorScript: FUNCTION SelectPluginCatalog(hSymbol:HANDLE) : BOOLEAN;
		
		Category: Objects - Custom
		Brings up a dialog to select a catalog to attach to a plug-in style, change the attached catalog, or detach the current catalog.
	'''
	pass
	return 'BOOLEAN' # FALSE if the object is not a symbol, does not define a plug-in sytle, or does not support catalogs.


def SelectSS(
		h  # HANDLE - Handle to worksheet.
		):
	'''
		Python: vs.SelectSS(h)
		VectorScript: PROCEDURE SelectSS(h:HANDLE);
		
		Category: Worksheets
		Procedure SelectSS opens the referenced worksheet and makes it active.
	'''
	pass


def SelectTreeControlItem(
		nDialogID   , # LONGINT -  
		nComponentID, # LONGINT -  
		nItemID       # INTEGER -  
		):
	'''
		Python: vs.SelectTreeControlItem(nDialogID, nComponentID, nItemID)
		VectorScript: PROCEDURE SelectTreeControlItem(nDialogID:LONGINT; nComponentID:LONGINT; nItemID:INTEGER);
		
		Category: Dialogs - Modern
		Selects the specified tree control item.
	'''
	pass


def Set2DComponentGroup(
		objectHandle, # HANDLE  - Handle to the object.                                                                                           
		groupHandle , # HANDLE  - Handle to the graphics group. Can be a group or a single object. To delete the corresponding group provide NULL.
		component     # INTEGER - 2D component.                                                                                                   
		):
	'''
		Python: BOOLEAN = vs.Set2DComponentGroup(objectHandle, groupHandle, component)
		VectorScript: FUNCTION Set2DComponentGroup(objectHandle:HANDLE; groupHandle:HANDLE; component:INTEGER) : BOOLEAN;
		
		Category: Objects - Custom
		Sets the specified 2D component group of a symbol definition or plug-in object.   Use Top/Plan if you want to add the group into the main container of the object.                                                                                                                   Table - 2D components
		2D component		Constant
		Not Set			0
		Top			1
		Bottom			2
		Top and Bottom Cut	                3
		Front			4
		Back			5
		Front and Back Cut	                6
		Left			7
		Right			8
		Left and Right Cut	                9
		Top/Plan		               10
	'''
	pass
	return 'BOOLEAN' # Returns TRUE if the operation was successful. 


def Set3DInfo(
		h             , # HANDLE            - Handle to 3D object. 
		heightDistance, # REAL (Coordinate) - New height of object.
		widthDistance , # REAL (Coordinate) - New width of object. 
		depthDistance   # REAL (Coordinate) - New depth of object. 
		):
	'''
		Python: vs.Set3DInfo(h, heightDistance, widthDistance, depthDistance)
		VectorScript: PROCEDURE Set3DInfo(h:HANDLE; heightDistance:REAL (Coordinate); widthDistance:REAL (Coordinate); depthDistance:REAL (Coordinate));
		
		Category: Objects - 3D
		Procedure Set3DInfo sets the height, width and depth dimensions of the referenced object.
	'''
	pass


def Set3DRot(
		h        , # HANDLE            - Handle to 3D object.               
		xAngle   , # REAL              - X axis rotation angle.             
		yAngle   , # REAL              - Y axis rotation angle.             
		zAngle   , # REAL              - Z axis rotation angle.             
		xDistance, # REAL (Coordinate) - X coordinate of center of rotation.
		yDistance, # REAL (Coordinate) - Y coordinate of center of rotation.
		zDistance  # REAL (Coordinate) - Z coordinate of center of rotation.
		):
	'''
		Python: vs.Set3DRot(h, xAngle, yAngle, zAngle, xDistance, yDistance, zDistance)
		VectorScript: PROCEDURE Set3DRot(h:HANDLE; xAngle:REAL; yAngle:REAL; zAngle:REAL; xDistance:REAL (Coordinate); yDistance:REAL (Coordinate); zDistance:REAL (Coordinate));
		
		Category: Objects - 3D
		Procedure Set3DRot rotates the referenced 3D object about a specified 3D point.  It works with the following 3D objects: extrude, multiple extrude, sweep, mesh, 3D polygon, solid, CSG solid, group, symbol, plug-in object, NURBS curve, NURBS surface.
		The difference between Set3DRot and SetRot3D is that Set3DRot adds the specified rotation to the existing rotation of the object, whereas SetRot3D does not consider the existing rotation, and merely makes the object rotation match the specified values.
	'''
	pass


def SetActSymbol(
		name  # STRING - Name of symbol.
		):
	'''
		Python: vs.SetActSymbol(name)
		VectorScript: PROCEDURE SetActSymbol(name:STRING);
		
		Category: Objects - Symbols
		Procedure SetActSymbol sets the active symbol for a Vectorworks document.
	'''
	pass


def SetAllStyleParams(
		hStyle   , # HANDLE  - Handle to a symbol definition contain a plug-in style                                               
		styleType  # INTEGER - 0 = Set all parameters to be ny istance parameters 1 = Set all parameters to be by stuyle parameters
		):
	'''
		Python: vs.SetAllStyleParams(hStyle, styleType)
		VectorScript: PROCEDURE SetAllStyleParams(hStyle:HANDLE; styleType:INTEGER);
		
		Category: Objects - Custom
	'''
	pass


def SetAngle(
		h    , # HANDLE - Handle to object.                                                                            
		value  # REAL   - The new rotation angle of the object. Angle in degrees (-180;180] measured from (1,0) vector.
		):
	'''
		Python: vs.SetAngle(h, value)
		VectorScript: PROCEDURE SetAngle(h:HANDLE; value:REAL);
		
		Category: Object Info
		Set angle of the passed object.
	'''
	pass


def SetArc(
		h         , # HANDLE - Handle to arc.         
		startAngle, # REAL   - New start angle of arc.
		arcAngle    # REAL   - New sweep angle of arc.
		):
	'''
		Python: vs.SetArc(h, startAngle, arcAngle)
		VectorScript: PROCEDURE SetArc(h:HANDLE; startAngle:REAL; arcAngle:REAL);
		
		Category: Objects - 2D
		Procedure SetArc sets the start and sweep angles of the referenced arc or round wall object.   Specify the angles in degrees.
	'''
	pass


def SetAttributeValue(
		XMLHandle  , # LONGINT            -  
		elementPath, # DYNARRAY[] of CHAR -  
		attribute  , # DYNARRAY[] of CHAR -  
		value        # DYNARRAY[] of CHAR -  
		):
	'''
		Python: INTEGER = vs.SetAttributeValue(XMLHandle, elementPath, attribute, value)
		VectorScript: FUNCTION SetAttributeValue(XMLHandle:LONGINT; elementPath:DYNARRAY of CHAR; attribute:DYNARRAY of CHAR; value:DYNARRAY of CHAR) : INTEGER;
		
		Category: XML
		Sets a value of an attribute.
	'''
	pass
	return 'INTEGER' # 


def SetBatAttributes(
		roofObject              , # HANDLE            - Handle to roof.                             
		dormerID                , # INTEGER           - Index of dormer element.                    
		useHeight               , # BOOLEAN           - Use height setting to create dormer element.
		heightDepthValueDistance, # REAL (Coordinate) - Height/depth distance.                      
		bottomWidthDistance     , # REAL (Coordinate) - Bottom width.                               
		topWidthDistance        , # REAL (Coordinate) - Top width.                                  
		baseHeightDistance      , # REAL (Coordinate) - Base height of bat.                         
		controlPointDistance    , # REAL (Coordinate) - Offset distance of control point.           
		topAngle                  # REAL              - Slope of bat roof.                          
		):
	'''
		Python: vs.SetBatAttributes(roofObject, dormerID, useHeight, heightDepthValueDistance, bottomWidthDistance, topWidthDistance, baseHeightDistance, controlPointDistance, topAngle)
		VectorScript: PROCEDURE SetBatAttributes(roofObject:HANDLE; dormerID:INTEGER; useHeight:BOOLEAN; heightDepthValueDistance:REAL (Coordinate); bottomWidthDistance:REAL (Coordinate); topWidthDistance:REAL (Coordinate); baseHeightDistance:REAL (Coordinate); controlPointDistance:REAL (Coordinate); topAngle:REAL);
		
		Category: Objects - Roofs
		Procedure SetBatAttributes sets the attributes of a bat dormer in the referenced roof.
	'''
	pass


def SetBBox(
		h , # HANDLE - Handle to object.                       
		p1, # POINT  - Top left coordinate of bounding box.    
		p2  # POINT  - Bottom right coordinate of bounding box.
		):
	'''
		Python: vs.SetBBox(h, p1, p2)
		VectorScript: PROCEDURE SetBBox(h:HANDLE; p1X, p1Y:REAL; p2X, p2Y:REAL);
		
		Category: Object Editing
		Procedure SetBBox positions objects whose geometry is defined by a bounding box. These objects currently are Image, PICT, Rectangle, Oval, Rounded Rectangle, and Worksheet Container.
		Other objects will generate a warning if they are passed to SetBBox.
	'''
	pass


def SetBeamAngle(
		h         , # HANDLE - Handle to light.    
		beamAngleR  # REAL   - Beam angle of light.
		):
	'''
		Python: vs.SetBeamAngle(h, beamAngleR)
		VectorScript: PROCEDURE SetBeamAngle(h:HANDLE; beamAngleR:REAL);
		
		Category: Objects - Lights
		Procedure SetBeamAngle sets the spread angle of the referenced spot light.
	'''
	pass


def SetBelowItem(
		dialogID    , # LONGINT - The index of the dialog layout being defined.
		srcItemID   , # LONGINT - The index of the anchor control item.        
		belowtItemID, # LONGINT - The index of the control item being placed.  
		indent      , # INTEGER - Left-right (x) control offset value.         
		lineSpacing   # INTEGER - Up-down (y) control offset value.            
		):
	'''
		Python: vs.SetBelowItem(dialogID, srcItemID, belowtItemID, indent, lineSpacing)
		VectorScript: PROCEDURE SetBelowItem(dialogID:LONGINT; srcItemID:LONGINT; belowtItemID:LONGINT; indent:INTEGER; lineSpacing:INTEGER);
		
		Category: Dialogs - Modern
		Places the specified control item below a previously inserted control item. Additional positioning can be performed by specifying x- and y-offsets (in pixels) from the initial insert position. Indent is in number of characters. LineSpacing is in pixels.
	'''
	pass


def SetBinaryConstraint(
		typeOfConstraint, # INTEGER - Type of constraint to be applied.                     
		h1              , # HANDLE  - Handle to object accepting constraint.                
		h2              , # HANDLE  - Handle to object accepting constraint.                
		obj1VertA       , # INTEGER - Vertex on first object defining constraint geometry.  
		obj1VertB       , # INTEGER - Vertex on first object defining constraint geometry.  
		obj2VertA       , # INTEGER - Vertex on second object defining constraint geometry. 
		obj2VertB       , # INTEGER - Vertex on second object defining constraint geometry. 
		containedObj1   , # LONGINT - Object index, obtained from the GetClosestPt function.
		containedObj2     # LONGINT - Object index, obtained from the GetClosestPt function.
		):
	'''
		Python: BOOLEAN = vs.SetBinaryConstraint(typeOfConstraint, h1, h2, obj1VertA, obj1VertB, obj2VertA, obj2VertB, containedObj1, containedObj2)
		VectorScript: FUNCTION SetBinaryConstraint(typeOfConstraint:INTEGER; h1:HANDLE; h2:HANDLE; obj1VertA:INTEGER; obj1VertB:INTEGER; obj2VertA:INTEGER; obj2VertB:INTEGER; containedObj1:LONGINT; containedObj2:LONGINT) : BOOLEAN;
		
		Category: Parametric Constraints
		Applies a binary parametric constraint to the referenced objects. The geometry of the constraint is defined by the specified object vertices.
		To apply a constraint to an object within a symbol, use GetClosestPt to obtain an index to the object and pass the index to either obj2VertA to use it as the first object or obj2VertB to use it as the second object. In all other instances, pass 0 to both these parameters.
	'''
	pass
	return 'BOOLEAN' # Returns a BOOLEAN value indicating whether the constraint was successfully applied.


def SetBooleanItem(
		dialogID   , # LONGINT - the dialog identifier given by CreateLayout or CreateResizableLayout
		componentID, # LONGINT - The identifier for the radio or checkbox button component.          
		setState     # BOOLEAN - The selection state to set for the given component.                 
		):
	'''
		Python: vs.SetBooleanItem(dialogID, componentID, setState)
		VectorScript: PROCEDURE SetBooleanItem(dialogID:LONGINT; componentID:LONGINT; setState:BOOLEAN);
		
		Category: Dialogs - Modern
		Selects or deselects the specified check box or radio button.
	'''
	pass


def SetCallBackInval(
		turnInvalOn  # BOOLEAN -  
		):
	'''
		Python: vs.SetCallBackInval(turnInvalOn)
		VectorScript: PROCEDURE SetCallBackInval(turnInvalOn:BOOLEAN);
		
		Category: Utility
		Sets whether or not callbacks should be invalidating portions of the screen that are being changed. This should be used if you need to create temporary objects for calculation purposes and do not want the screen to be redrawn as a result
	'''
	pass


def SetCDATA(
		XMLHandle  , # LONGINT            -  
		elementPath, # DYNARRAY[] of CHAR -  
		data         # DYNARRAY[] of CHAR -  
		):
	'''
		Python: INTEGER = vs.SetCDATA(XMLHandle, elementPath, data)
		VectorScript: FUNCTION SetCDATA(XMLHandle:LONGINT; elementPath:DYNARRAY of CHAR; data:DYNARRAY of CHAR) : INTEGER;
		
		Category: XML
		Sets CDATA section.
	'''
	pass
	return 'INTEGER' # 


def SetCheckoutsComment(
		comment  # STRING - The comment to replace any currently in use.
		):
	'''
		Python: BOOLEAN = vs.SetCheckoutsComment(comment)
		VectorScript: FUNCTION SetCheckoutsComment(comment:STRING) : BOOLEAN;
		
		Category: Project Sharing
		Set the comment that will be used for checkouts and commits.
		The Enter Comment dialogs will still be shown when a checkout or commit is done; the dialog will be prepopulated with the comment set with this command.
	'''
	pass
	return 'BOOLEAN' # True on success, false on failure or not Project Sharing file.


def SetClass(
		h    , # HANDLE - Handle to object.                 
		clas   # STRING - Name of class to assign to object.
		):
	'''
		Python: vs.SetClass(h, class)
		VectorScript: PROCEDURE SetClass(h:HANDLE; class:STRING);
		
		Category: Object Attributes
		Procedure SetClass assigns a class to the referenced object.
	'''
	pass


def SetClassArrow(
		clasName , # STRING  - The indicated class.                            
		style    , # INTEGER - The arrow style.                                
		size     , # REAL    - The arrow size in inches measured in page space.
		angle      # INTEGER - The arrow angle (in degrees).                   
		):
	'''
		Python: vs.SetClassArrow(className, style, size, angle)
		VectorScript: PROCEDURE SetClassArrow(className:STRING; style:INTEGER; size:REAL; angle:INTEGER);
		
		Category: Classes
		Procedure SetClassArrow sets the arrow style parameters for the indicated class.
	'''
	pass


def SetClassBeginningMarker(
		name          , # STRING  - Name of the class                                      
		style         , # LONGINT - The marker style (see comments for details)            
		angle         , # INTEGER - The marker angle in degrees (0 to 90)                  
		size          , # REAL    - The marker size in pages inches                        
		width         , # REAL    - The marker width in page inches                        
		thicknessBasis, # INTEGER - The marker thickness basis. ( see comments for details)
		thickness       # REAL    - The marker thickness                                   
		):
	'''
		Python: BOOLEAN = vs.SetClassBeginningMarker(name, style, angle, size, width, thicknessBasis, thickness)
		VectorScript: FUNCTION SetClassBeginningMarker(name:STRING; style:LONGINT; angle:INTEGER; size:REAL; width:REAL; thicknessBasis:INTEGER; thickness:REAL) : BOOLEAN;
		
		Category: Classes
		Sets all properties for the named class' beginning marker. Return TRUE if operation was successful.
	'''
	pass
	return 'BOOLEAN' # 


def SetClassEndMarker(
		name          , # STRING  - Name of the class.                                     
		style         , # LONGINT - The marker style. (see comments for details)           
		angle         , # INTEGER - The marker angle in degrees. (0 to 90)                 
		size          , # REAL    - The marker size in page inches.                        
		width         , # REAL    - The marker width in page inches.                       
		thicknessBasis, # INTEGER - The marker thickness basis. ( see comments for details)
		thickness       # REAL    - The marker thickness.                                  
		):
	'''
		Python: BOOLEAN = vs.SetClassEndMarker(name, style, angle, size, width, thicknessBasis, thickness)
		VectorScript: FUNCTION SetClassEndMarker(name:STRING; style:LONGINT; angle:INTEGER; size:REAL; width:REAL; thicknessBasis:INTEGER; thickness:REAL) : BOOLEAN;
		
		Category: Classes
		Sets all properties for the named class's end marker. Return TRUE if operation was successful.
	'''
	pass
	return 'BOOLEAN' # 


def SetClassN(
		h            , # HANDLE  - Handle to object.                                     
		clas         , # STRING  - Name of class to assign to object.                    
		descIntoGroup  # BOOLEAN - Assign the same class to all objects inside the group.
		):
	'''
		Python: vs.SetClassN(h, class, descIntoGroup)
		VectorScript: PROCEDURE SetClassN(h:HANDLE; class:STRING; descIntoGroup:BOOLEAN);
		
		Category: Object Attributes
		Procedure SetClassN assigns a class to the referenced object.
		If the third parameter 'descIntoGroup' is set to true all objects within the group will receive the same class assignment as the group,
		otherwise only the group itself will be affected.
	'''
	pass


def SetClassOptions(
		clasOpts   # INTEGER - New class visibility setting.
		):
	'''
		Python: vs.SetClassOptions(classOpts)
		VectorScript: PROCEDURE SetClassOptions(classOpts:INTEGER);
		
		Category: Classes
		Sets class visibility setting for the active document.
	'''
	pass


def SetCLDrpShadowData(
		clasName   , # STRING  -  
		nUnits     , # INTEGER -  
		dOffset    , # REAL    -  
		dBlurRadius, # REAL    -  
		dAngle     , # REAL    -  
		nOpacity   , # INTEGER -  
		color        # COLOR   -  
		):
	'''
		Python: vs.SetCLDrpShadowData(className, nUnits, dOffset, dBlurRadius, dAngle, nOpacity, color)
		VectorScript: PROCEDURE SetCLDrpShadowData(className:STRING; nUnits:INTEGER; dOffset:REAL; dBlurRadius:REAL; dAngle:REAL; nOpacity:INTEGER; colorR, colorG, colorB:LONGINT);
		
		Category: Classes
	'''
	pass


def SetClFillBack(
		clasName , # STRING - Name of class.  
		color      # COLOR  - RGB color value.
		):
	'''
		Python: vs.SetClFillBack(className, color)
		VectorScript: PROCEDURE SetClFillBack(className:STRING; colorR, colorG, colorB:LONGINT);
		
		Category: Classes
		Sets the fill background color of the specified class. The color must be specified using the RGB components of the desired color. RGB values are in the range of 0 65535.
	'''
	pass


def SetClFillFore(
		clasName , # STRING - Name of class.  
		color      # COLOR  - RGB color value.
		):
	'''
		Python: vs.SetClFillFore(className, color)
		VectorScript: PROCEDURE SetClFillFore(className:STRING; colorR, colorG, colorB:LONGINT);
		
		Category: Classes
		Sets the fill foreground color of the specified class. The color must be specified using the RGB components of the desired color. RGB values are in the range of 0 65535.
	'''
	pass


def SetClFPat(
		clasName   , # STRING  - Name of class.           
		fillpattern  # LONGINT - Fill pattern index value.
		):
	'''
		Python: vs.SetClFPat(className, fillpattern)
		VectorScript: PROCEDURE SetClFPat(className:STRING; fillpattern:LONGINT);
		
		Category: Classes
		Sets the fill pattern of the specified class.
		To apply a bitmap fill pattern, use a positive value corresponding to the desired fill pattern index. To apply a vector fill, use the negative of the index of the vector fill (index * -1).
	'''
	pass


def SetClLS(
		clasName , # STRING  - Name of class.         
		LS         # INTEGER - Line style index value.
		):
	'''
		Python: vs.SetClLS(className, LS)
		VectorScript: PROCEDURE SetClLS(className:STRING; LS:INTEGER);
		
		Category: Classes
		Deprecated - will generate error. Use SetClLSN instead.
	'''
	pass


def SetClLSN(
		clasName , # STRING  - Name of class.         
		lineStyle  # LONGINT - Line style index value.
		):
	'''
		Python: vs.SetClLSN(className, lineStyle)
		VectorScript: PROCEDURE SetClLSN(className:STRING; lineStyle:LONGINT);
		
		Category: Classes
		Sets the line style of the specified class.
	'''
	pass


def SetClLW(
		clasName , # STRING  - Name of class.              
		LW         # INTEGER - Line weight value (in mils).
		):
	'''
		Python: vs.SetClLW(className, LW)
		VectorScript: PROCEDURE SetClLW(className:STRING; LW:INTEGER);
		
		Category: Classes
		Sets the line weight of the specified class.
	'''
	pass


def SetClOpacity(
		clasName , # STRING  - Name of class.                                         
		opacity    # INTEGER - Opacity specified by percentage value in range [0-100].
		):
	'''
		Python: vs.SetClOpacity(className, opacity)
		VectorScript: PROCEDURE SetClOpacity(className:STRING; opacity:INTEGER);
		
		Category: Classes
		Sets the opacity persentage of a class. The opacity is specified by percentage value in range [0-100].
	'''
	pass


def SetCLOpacityN(
		clasName   , # STRING  -  
		fillOpacity, # INTEGER -  
		penOpacity   # INTEGER -  
		):
	'''
		Python: vs.SetCLOpacityN(className, fillOpacity, penOpacity)
		VectorScript: PROCEDURE SetCLOpacityN(className:STRING; fillOpacity:INTEGER; penOpacity:INTEGER);
		
		Category: Classes
	'''
	pass


def SetClPenBack(
		clasName , # STRING - Name of class.  
		color      # COLOR  - RGB color value.
		):
	'''
		Python: vs.SetClPenBack(className, color)
		VectorScript: PROCEDURE SetClPenBack(className:STRING; colorR, colorG, colorB:LONGINT);
		
		Category: Classes
		Procedure SetClPenBack sets the pen background color of the specified class. The color must be specified using the RGB components of the desired color. RGB values are in the range of 0 65535.
	'''
	pass


def SetClPenFore(
		clasName , # STRING - Name of class.  
		color      # COLOR  - RGB color value.
		):
	'''
		Python: vs.SetClPenFore(className, color)
		VectorScript: PROCEDURE SetClPenFore(className:STRING; colorR, colorG, colorB:LONGINT);
		
		Category: Classes
		Sets the pen foreground color of the specified class. The color must be specified using the RGB components of the desired color. RGB values are in the range of 0 65535.
	'''
	pass


def SetClTextStyleRef(
		clasName    , # STRING  - Name of class          
		textStyleRef  # LONGINT - text style reference id
		):
	'''
		Python: vs.SetClTextStyleRef(className, textStyleRef)
		VectorScript: PROCEDURE SetClTextStyleRef(className:STRING; textStyleRef:LONGINT);
		
		Category: Classes
		Function SetClTextStyleRef sets the text style of the specified class.  The integer style is the internal index of the text style.
	'''
	pass


def SetClTextureC(
		clasName  , # STRING  - Class name.                   
		textureRef  # LONGINT - Texture reference index value.
		):
	'''
		Python: vs.SetClTextureC(className, textureRef)
		VectorScript: PROCEDURE SetClTextureC(className:STRING; textureRef:LONGINT);
		
		Category: Textures
		Procedure SetClTextureC sets the wall center texture of the specified class.
	'''
	pass


def SetClTextureD(
		clasName  , # STRING  - Class name.                   
		textureRef  # LONGINT - Texture reference index value.
		):
	'''
		Python: vs.SetClTextureD(className, textureRef)
		VectorScript: PROCEDURE SetClTextureD(className:STRING; textureRef:LONGINT);
		
		Category: Textures
		Procedure SetClTextureD sets the roof dormer texture of the specified class.
	'''
	pass


def SetClTextureG(
		clasName  , # STRING  - Class name.                   
		textureRef  # LONGINT - Texture reference index value.
		):
	'''
		Python: vs.SetClTextureG(className, textureRef)
		VectorScript: PROCEDURE SetClTextureG(className:STRING; textureRef:LONGINT);
		
		Category: Textures
		Procedure SetClTextureG sets the generic texture of the specified class.
	'''
	pass


def SetClTextureL(
		clasName  , # STRING  - Class name.                   
		textureRef  # LONGINT - Texture reference index value.
		):
	'''
		Python: vs.SetClTextureL(className, textureRef)
		VectorScript: PROCEDURE SetClTextureL(className:STRING; textureRef:LONGINT);
		
		Category: Textures
		Procedure SetClTextureL sets the left side wall texture of the specified class.
	'''
	pass


def SetClTextureR(
		clasName  , # STRING  - Class name.                   
		textureRef  # LONGINT - Texture reference index value.
		):
	'''
		Python: vs.SetClTextureR(className, textureRef)
		VectorScript: PROCEDURE SetClTextureR(className:STRING; textureRef:LONGINT);
		
		Category: Textures
		Procedure SetClTextureR sets the right side wall texture of the specified class.
	'''
	pass


def SetClTextureT(
		clasName  , # STRING  - Class name.                   
		textureRef  # LONGINT - Texture reference index value.
		):
	'''
		Python: vs.SetClTextureT(className, textureRef)
		VectorScript: PROCEDURE SetClTextureT(className:STRING; textureRef:LONGINT);
		
		Category: Textures
		Procedure SetClTextureT sets the roof top texture of the specified class.
	'''
	pass


def SetClUseGraphic(
		clasName , # STRING  - Name of class.                        
		use        # BOOLEAN - Use graphic attributes on-off setting.
		):
	'''
		Python: vs.SetClUseGraphic(className, use)
		VectorScript: PROCEDURE SetClUseGraphic(className:STRING; use:BOOLEAN);
		
		Category: Classes
		Toggles the document setting for using the graphic attributes of the specified class at object creation.
	'''
	pass


def SetClUseTextStyle(
		clasName , # STRING  - Name of class                 
		use        # BOOLEAN - Use text style on-off setting.
		):
	'''
		Python: vs.SetClUseTextStyle(className, use)
		VectorScript: PROCEDURE SetClUseTextStyle(className:STRING; use:BOOLEAN);
		
		Category: Classes
		Controls whether the text style of the specified class is used at object creation.
	'''
	pass


def SetClUseTexture(
		clasName , # STRING  - Name of class.                        
		use        # BOOLEAN - Use texture attributes on-off setting.
		):
	'''
		Python: vs.SetClUseTexture(className, use)
		VectorScript: PROCEDURE SetClUseTexture(className:STRING; use:BOOLEAN);
		
		Category: Classes
		Toggles the document setting for using the texture attributes of the specified class at object creation.
	'''
	pass


def SetClVectorFill(
		clasName , # STRING - Name of class.        
		hatchName  # STRING - Name of hatch pattern.
		):
	'''
		Python: BOOLEAN = vs.SetClVectorFill(className, hatchName)
		VectorScript: FUNCTION SetClVectorFill(className:STRING; hatchName:STRING) : BOOLEAN;
		
		Category: Classes
		Sets the class fill style to use the specified hatch pattern. The function return value will be TRUE if the operation was successful.
	'''
	pass
	return 'BOOLEAN' # 


def SetCntrlPtVis(
		inCustomObj    , # HANDLE  -  
		inContrlPtIndex, # INTEGER -  
		inIsVisible      # BOOLEAN -  
		):
	'''
		Python: vs.SetCntrlPtVis(inCustomObj, inContrlPtIndex, inIsVisible)
		VectorScript: PROCEDURE SetCntrlPtVis(inCustomObj:HANDLE; inContrlPtIndex:INTEGER; inIsVisible:BOOLEAN);
		
		Category: Object Events
	'''
	pass


def SetColorButton(
		dialogID, # LONGINT - The index of the dialog layout containing the control.
		itemID  , # LONGINT - The index of the color button.                        
		red     , # LONGINT - The red component of the color.                       
		green   , # LONGINT - The green component of the color.                     
		blue      # LONGINT - The blue component of the color.                      
		):
	'''
		Python: vs.SetColorButton(dialogID, itemID, red, green, blue)
		VectorScript: PROCEDURE SetColorButton(dialogID:LONGINT; itemID:LONGINT; red:LONGINT; green:LONGINT; blue:LONGINT);
		
		Category: Dialogs - Modern
		Sets the color of a modern dialog color button. Set all colors to 0 for black. Set all colors to 65535 for white.
	'''
	pass


def SetColorChoice(
		dialogID  , # LONGINT -  
		itemID    , # LONGINT -  
		colorIndex  # INTEGER -  
		):
	'''
		Python: vs.SetColorChoice(dialogID, itemID, colorIndex)
		VectorScript: PROCEDURE SetColorChoice(dialogID:LONGINT; itemID:LONGINT; colorIndex:INTEGER);
		
		Category: Dialogs - Modern
		Sets the choice for the color popup dialog control to the specified color index.
	'''
	pass


def SetColorName(
		ColorIndex, # INTEGER - The index of the color to be named.              
		ColorName   # STRING  - The new name of the color specified by the index.
		):
	'''
		Python: BOOLEAN = vs.SetColorName(ColorIndex, ColorName)
		VectorScript: FUNCTION SetColorName(ColorIndex:INTEGER; ColorName:STRING) : BOOLEAN;
		
		Category: Object Names
		Sets the color name of the specified color index.
	'''
	pass
	return 'BOOLEAN' # 'true' if the operation was successful.[[BR]]'false' otherwise.[[BR]]


def SetCompABoundEOffOff(
		object                   , # HANDLE            - The object. Can be a  slab, Slab Style, or the Slab Preferences.
		componentIndex           , # INTEGER           - The index of the component.                                     
		autoBoundEdgeOffsetOffset  # REAL (Coordinate) - The auto-bound edge offset offset.                              
		):
	'''
		Python: BOOLEAN = vs.SetCompABoundEOffOff(object, componentIndex, autoBoundEdgeOffsetOffset)
		VectorScript: FUNCTION SetCompABoundEOffOff(object:HANDLE; componentIndex:INTEGER; autoBoundEdgeOffsetOffset:REAL (Coordinate)) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the auto-bound edge offset offset of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetCompAltSecFill(
		object              , # HANDLE  - The object. Can be a roof face, roof, Roof Style, or the Roof Preferences.
		componentIndex      , # INTEGER - The index of the component.                                               
		alternateSectionFill  # LONGINT - The alternate section fill of the component.                              
		):
	'''
		Python: BOOLEAN = vs.SetCompAltSecFill(object, componentIndex, alternateSectionFill)
		VectorScript: FUNCTION SetCompAltSecFill(object:HANDLE; componentIndex:INTEGER; alternateSectionFill:LONGINT) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the alternate section fill of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetCompAltSecFillCl(
		object                       , # HANDLE  - The object. Can be a roof face, roof, Roof Style, or the Roof Preferences.
		componentIndex               , # INTEGER - The index of the component.                                               
		alternateSectionFillForeColor, # INTEGER - The alternate section fill fore color of the component.                   
		alternateSectionFillBackColor  # INTEGER - The alternate section fill back color of the component.                   
		):
	'''
		Python: BOOLEAN = vs.SetCompAltSecFillCl(object, componentIndex, alternateSectionFillForeColor, alternateSectionFillBackColor)
		VectorScript: FUNCTION SetCompAltSecFillCl(object:HANDLE; componentIndex:INTEGER; alternateSectionFillForeColor:INTEGER; alternateSectionFillBackColor:INTEGER) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the alternate section fill colors of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetCompAutoJoinCap(
		object                        , # HANDLE  - The object. Can be a wall, round wall, Wall Style, or the Wall Preferences.
		componentIndex                , # INTEGER - The index of the component.                                                
		alwaysAutoJoinInCappedJoinMode  # BOOLEAN - Whether or not the component always auto joins in Capped Join mode.        
		):
	'''
		Python: BOOLEAN = vs.SetCompAutoJoinCap(object, componentIndex, alwaysAutoJoinInCappedJoinMode)
		VectorScript: FUNCTION SetCompAutoJoinCap(object:HANDLE; componentIndex:INTEGER; alwaysAutoJoinInCappedJoinMode:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the always auto join in Capped Join mode flag of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetCompBotIsRelStory(
		object                 , # HANDLE  - The object. Can be a wall, round wall, Wall Style, or the Wall Preferences.
		componentIndex         , # INTEGER - The index of the component.                                                
		bottomIsRelativeToStory  # BOOLEAN - Whether or not the component bottom is relative to a story.                
		):
	'''
		Python: BOOLEAN = vs.SetCompBotIsRelStory(object, componentIndex, bottomIsRelativeToStory)
		VectorScript: FUNCTION SetCompBotIsRelStory(object:HANDLE; componentIndex:INTEGER; bottomIsRelativeToStory:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets whether or not the component bottom is relative to a story.
	'''
	pass
	return 'BOOLEAN' # 


def SetCompBoundOffset(
		object        , # HANDLE  - The object. Can be a roof face, roof, Roof Style, or the Roof Preferences.
		componentIndex, # INTEGER - The index of the component.                                               
		boundOffset     # REAL    - The bound offset of the component.                                        
		):
	'''
		Python: BOOLEAN = vs.SetCompBoundOffset(object, componentIndex, boundOffset)
		VectorScript: FUNCTION SetCompBoundOffset(object:HANDLE; componentIndex:INTEGER; boundOffset:REAL) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the bound offset of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetCompDatTopOfComp(
		object               , # HANDLE  - The object. Can be a slab, roof face, roof, Slab Style, Roof Style, the Slab Preferences, or the Roof Preferences.
		componentIndex       , # INTEGER - The index of the component.                                                                                       
		datumIsTopOfComponent  # BOOLEAN - Whether or not the datum is the top of the component.                                                             
		):
	'''
		Python: BOOLEAN = vs.SetCompDatTopOfComp(object, componentIndex, datumIsTopOfComponent)
		VectorScript: FUNCTION SetCompDatTopOfComp(object:HANDLE; componentIndex:INTEGER; datumIsTopOfComponent:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the datum is top of component flag of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetCompManualBound(
		object        , # HANDLE  - The object. Can be a roof face, roof, Roof Style, or the Roof Preferences.
		componentIndex, # INTEGER - The index of the component.                                               
		manualBound     # INTEGER - The manual bound of the component.  0 - Roof edge 1 - Roof axis line      
		):
	'''
		Python: BOOLEAN = vs.SetCompManualBound(object, componentIndex, manualBound)
		VectorScript: FUNCTION SetCompManualBound(object:HANDLE; componentIndex:INTEGER; manualBound:INTEGER) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the manual bound of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetCompMasterSnaps(
		object           , # HANDLE  - The object. Can be a wall, round wall, Wall Style, or the Wall Preferences.
		componentIndex   , # INTEGER - The index of the component.                                                
		masterSnapOnLeft , # BOOLEAN - Whether or not the component has a master snap on its left.                
		masterSnapOnRight  # BOOLEAN - Whether or not the component has a master snap on its right.               
		):
	'''
		Python: BOOLEAN = vs.SetCompMasterSnaps(object, componentIndex, masterSnapOnLeft, masterSnapOnRight)
		VectorScript: FUNCTION SetCompMasterSnaps(object:HANDLE; componentIndex:INTEGER; masterSnapOnLeft:BOOLEAN; masterSnapOnRight:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the master snaps of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetComponentAutoBoundEdgeOffset(
		object             , # HANDLE  - The object. Can be a  slab, Slab Style, or the Slab Preferences.                                                                                                                
		componentIndex     , # INTEGER - The index of the component.                                                                                                                                                     
		autoBoundEdgeOffset  # INTEGER - The auto-bound edge offset.  0 - Inner face 1 - Outer face of inner component 2 - Inner face of core 3 - Center of core 4 - Outer face of core 5 - Inner face of outer component
		):
	'''
		Python: BOOLEAN = vs.SetComponentAutoBoundEdgeOffset(object, componentIndex, autoBoundEdgeOffset)
		VectorScript: FUNCTION SetComponentAutoBoundEdgeOffset(object:HANDLE; componentIndex:INTEGER; autoBoundEdgeOffset:INTEGER) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the auto-bound edge offset of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetComponentClass(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex, # INTEGER - The index of the component.                                                                                                                                           
		componentClass  # LONGINT - The class of the component.                                                                                                                                           
		):
	'''
		Python: BOOLEAN = vs.SetComponentClass(object, componentIndex, componentClass)
		VectorScript: FUNCTION SetComponentClass(object:HANDLE; componentIndex:INTEGER; componentClass:LONGINT) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the class of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetComponentFill(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex, # INTEGER - The index of the component.                                                                                                                                           
		fill            # LONGINT - The fill of the component.  Positive values for patterns, negative object indexes for hatches.                                                                        
		):
	'''
		Python: BOOLEAN = vs.SetComponentFill(object, componentIndex, fill)
		VectorScript: FUNCTION SetComponentFill(object:HANDLE; componentIndex:INTEGER; fill:LONGINT) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the fill of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetComponentFillColors(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex, # INTEGER - The index of the component.                                                                                                                                           
		fillForeColor , # INTEGER - The fore color of the fill.                                                                                                                                           
		fillBackColor   # INTEGER - The back color of the fill.                                                                                                                                           
		):
	'''
		Python: BOOLEAN = vs.SetComponentFillColors(object, componentIndex, fillForeColor, fillBackColor)
		VectorScript: FUNCTION SetComponentFillColors(object:HANDLE; componentIndex:INTEGER; fillForeColor:INTEGER; fillBackColor:INTEGER) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the fore and back fill colors of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetComponentFollowBottomWallPeaks(
		object               , # HANDLE  - The object. Can be a wall, round wall, Wall Style, or the Wall Preferences.
		componentIndex       , # INTEGER - The index of the component.                                                
		followBottomWallPeaks  # BOOLEAN - Whether or not the component will follow bottom wall peaks.                
		):
	'''
		Python: BOOLEAN = vs.SetComponentFollowBottomWallPeaks(object, componentIndex, followBottomWallPeaks)
		VectorScript: FUNCTION SetComponentFollowBottomWallPeaks(object:HANDLE; componentIndex:INTEGER; followBottomWallPeaks:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the follow bottom wall peaks flag of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetComponentFollowTopWallPeaks(
		object            , # HANDLE  - The object. Can be a wall, round wall, Wall Style, or the Wall Preferences.
		componentIndex    , # INTEGER - The index of the component.                                                
		followTopWallPeaks  # BOOLEAN - Whether or not the component will follow top wall peaks.                   
		):
	'''
		Python: BOOLEAN = vs.SetComponentFollowTopWallPeaks(object, componentIndex, followTopWallPeaks)
		VectorScript: FUNCTION SetComponentFollowTopWallPeaks(object:HANDLE; componentIndex:INTEGER; followTopWallPeaks:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the follow top wall peaks flag of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetComponentFunction(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex, # INTEGER - The index of the component.                                                                                                                                           
		func            # INTEGER - The function of the component.  0 - Other 1 - Load-Bearing 2 - Insulation 3 - Inner Finish 4 - Outer Finish 5 - Air Gap                                               
		):
	'''
		Python: BOOLEAN = vs.SetComponentFunction(object, componentIndex, func)
		VectorScript: FUNCTION SetComponentFunction(object:HANDLE; componentIndex:INTEGER; func:INTEGER) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the function of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetComponentIndeterminate(
		nDialogID          , # LONGINT -  
		nComponentID       , # LONGINT -  
		bIndeterminateState  # BOOLEAN -  
		):
	'''
		Python: BOOLEAN = vs.SetComponentIndeterminate(nDialogID, nComponentID, bIndeterminateState)
		VectorScript: FUNCTION SetComponentIndeterminate(nDialogID:LONGINT; nComponentID:LONGINT; bIndeterminateState:BOOLEAN) : BOOLEAN;
		
		Category: Dialogs - Modern
		Determines if the specified Layout Manager attribute control (line, weight, color, etc) should be set to the third, indeterminate state.
	'''
	pass
	return 'BOOLEAN' # 


def SetComponentManualEdgeOffset(
		object          , # HANDLE            - The object. Can be a  slab, Slab Style, or the Slab Preferences.
		componentIndex  , # INTEGER           - The index of the component.                                     
		manualEdgeOffset  # REAL (Coordinate) - The manual edge offset.                                         
		):
	'''
		Python: BOOLEAN = vs.SetComponentManualEdgeOffset(object, componentIndex, manualEdgeOffset)
		VectorScript: FUNCTION SetComponentManualEdgeOffset(object:HANDLE; componentIndex:INTEGER; manualEdgeOffset:REAL (Coordinate)) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the manual edge offset of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetComponentName(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex, # INTEGER - The index of the component.                                                                                                                                           
		componentName   # STRING  - The name of the component.                                                                                                                                            
		):
	'''
		Python: BOOLEAN = vs.SetComponentName(object, componentIndex, componentName)
		VectorScript: FUNCTION SetComponentName(object:HANDLE; componentIndex:INTEGER; componentName:STRING) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the name of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetComponentPenColors(
		object           , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex   , # INTEGER - The index of the component.                                                                                                                                           
		leftPenForeColor , # INTEGER - The fore color of the left pen.                                                                                                                                       
		leftPenBackColor , # INTEGER - The back color of the left pen.                                                                                                                                       
		rightPenForeColor, # INTEGER - The fore color of the right pen.                                                                                                                                      
		rightPenBackColor  # INTEGER - The back color of the right pen.                                                                                                                                      
		):
	'''
		Python: BOOLEAN = vs.SetComponentPenColors(object, componentIndex, leftPenForeColor, leftPenBackColor, rightPenForeColor, rightPenBackColor)
		VectorScript: FUNCTION SetComponentPenColors(object:HANDLE; componentIndex:INTEGER; leftPenForeColor:INTEGER; leftPenBackColor:INTEGER; rightPenForeColor:INTEGER; rightPenBackColor:INTEGER) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the colors of the pens of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetComponentPenStyles(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex, # INTEGER - The index of the component.                                                                                                                                           
		leftPenStyle  , # INTEGER - The pen style of the component's left line.  Positive values for patterns, negative values for dash styles.                                                           
		rightPenStyle   # INTEGER - The pen style of the component's right line.  Positive values for patterns, negative values for dash styles.                                                          
		):
	'''
		Python: BOOLEAN = vs.SetComponentPenStyles(object, componentIndex, leftPenStyle, rightPenStyle)
		VectorScript: FUNCTION SetComponentPenStyles(object:HANDLE; componentIndex:INTEGER; leftPenStyle:INTEGER; rightPenStyle:INTEGER) : BOOLEAN;
		
		Category: Objects - Architectural
		Deprecated - will generate error. Use SetCompPenStylesN  instead.
	'''
	pass
	return 'BOOLEAN' # 


def SetComponentPenWeights(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex, # INTEGER - The index of the component.                                                                                                                                           
		leftPenWeight , # INTEGER - The pen weight of the component's left line.                                                                                                                          
		rightPenWeight  # INTEGER - The pen weight of the component's right line.                                                                                                                         
		):
	'''
		Python: BOOLEAN = vs.SetComponentPenWeights(object, componentIndex, leftPenWeight, rightPenWeight)
		VectorScript: FUNCTION SetComponentPenWeights(object:HANDLE; componentIndex:INTEGER; leftPenWeight:INTEGER; rightPenWeight:INTEGER) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the left and right pen weights for a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetComponentSize(
		nDialogID    , # LONGINT -  
		nComponentID , # LONGINT -  
		nWidthPixels , # INTEGER -  
		nHeightPixels  # INTEGER -  
		):
	'''
		Python: BOOLEAN = vs.SetComponentSize(nDialogID, nComponentID, nWidthPixels, nHeightPixels)
		VectorScript: FUNCTION SetComponentSize(nDialogID:LONGINT; nComponentID:LONGINT; nWidthPixels:INTEGER; nHeightPixels:INTEGER) : BOOLEAN;
		
		Category: Dialogs - Modern
		Sets the width and height of the specified Layout Manager component.
	'''
	pass
	return 'BOOLEAN' # 


def SetComponentTexture(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex, # INTEGER - The index of the component.                                                                                                                                           
		texture         # LONGINT - The ref number of the texture. 0 for no texture. -1 for class texture.                                                                                                
		):
	'''
		Python: BOOLEAN = vs.SetComponentTexture(object, componentIndex, texture)
		VectorScript: FUNCTION SetComponentTexture(object:HANDLE; componentIndex:INTEGER; texture:LONGINT) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the texture of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetComponentUseFillClassAttr(
		object                , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex        , # INTEGER - The index of the component.                                                                                                                                           
		useFillClassAttributes  # BOOLEAN - Whether or not the component will use class attributes for its fill.                                                                                                  
		):
	'''
		Python: BOOLEAN = vs.SetComponentUseFillClassAttr(object, componentIndex, useFillClassAttributes)
		VectorScript: FUNCTION SetComponentUseFillClassAttr(object:HANDLE; componentIndex:INTEGER; useFillClassAttributes:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the use fill class attributes flag of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetComponentUsePenClassAttr(
		object                    , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex            , # INTEGER - The index of the component.                                                                                                                                           
		useLeftPenClassAttributes , # BOOLEAN - Whether or not the component will use class attributes for its left pen.                                                                                              
		useRightPenClassAttributes  # BOOLEAN - Whether or not the component will use class attributes for its right pen.                                                                                             
		):
	'''
		Python: BOOLEAN = vs.SetComponentUsePenClassAttr(object, componentIndex, useLeftPenClassAttributes, useRightPenClassAttributes)
		VectorScript: FUNCTION SetComponentUsePenClassAttr(object:HANDLE; componentIndex:INTEGER; useLeftPenClassAttributes:BOOLEAN; useRightPenClassAttributes:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the use class attributes flags of the pens of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetComponentWallBottomOffset(
		object              , # HANDLE            - The object. Can be a wall, round wall, Wall Style, or the Wall Preferences.
		componentIndex      , # INTEGER           - The index of the component.                                                
		offsetFromWallBottom  # REAL (Coordinate) - The offset from wall bottom of the component.                              
		):
	'''
		Python: BOOLEAN = vs.SetComponentWallBottomOffset(object, componentIndex, offsetFromWallBottom)
		VectorScript: FUNCTION SetComponentWallBottomOffset(object:HANDLE; componentIndex:INTEGER; offsetFromWallBottom:REAL (Coordinate)) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the offset from wall bottom of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetComponentWallTopOffset(
		object           , # HANDLE            - The object. Can be a wall, round wall, Wall Style, or the Wall Preferences.
		componentIndex   , # INTEGER           - The index of the component.                                                
		offsetFromWallTop  # REAL (Coordinate) - The offset from wall top of the component.                                 
		):
	'''
		Python: BOOLEAN = vs.SetComponentWallTopOffset(object, componentIndex, offsetFromWallTop)
		VectorScript: FUNCTION SetComponentWallTopOffset(object:HANDLE; componentIndex:INTEGER; offsetFromWallTop:REAL (Coordinate)) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the offset from wall top of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetComponentWidth(
		object        , # HANDLE            - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex, # INTEGER           - The index of the component.                                                                                                                                           
		width           # REAL (Coordinate) - The width of the component.                                                                                                                                           
		):
	'''
		Python: BOOLEAN = vs.SetComponentWidth(object, componentIndex, width)
		VectorScript: FUNCTION SetComponentWidth(object:HANDLE; componentIndex:INTEGER; width:REAL (Coordinate)) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the width of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetCompPenStylesN(
		object        , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex, # INTEGER - The index of the component.                                                                                                                                           
		leftPenStyle  , # LONGINT - The left pen style of the component.                                                                                                                                  
		rightPenStyle   # LONGINT - The right pen style of the component.                                                                                                                                 
		):
	'''
		Python: BOOLEAN = vs.SetCompPenStylesN(object, componentIndex, leftPenStyle, rightPenStyle)
		VectorScript: FUNCTION SetCompPenStylesN(object:HANDLE; componentIndex:INTEGER; leftPenStyle:LONGINT; rightPenStyle:LONGINT) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the pen styles of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetCompSecFillChgPt(
		object                              , # HANDLE  - The object. Can be a roof face, roof, Roof Style, or the Roof Preferences.                                                                                                                                                   
		componentIndex                      , # INTEGER - The index of the component.                                                                                                                                                                                                  
		wallAssociatedSectionFillChangePoint  # INTEGER - The wall associated section fill change point of the component.  0 - Inner face 1 - Outer face of inner component 2 - Inner face of core 3 - Center of core 4 - Outer face of core 5 - Inner face of outer component 6 - None
		):
	'''
		Python: BOOLEAN = vs.SetCompSecFillChgPt(object, componentIndex, wallAssociatedSectionFillChangePoint)
		VectorScript: FUNCTION SetCompSecFillChgPt(object:HANDLE; componentIndex:INTEGER; wallAssociatedSectionFillChangePoint:INTEGER) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the wall associated section fill change point of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetCompTopIsRelStory(
		object              , # HANDLE  - The object. Can be a wall, round wall, Wall Style, or the Wall Preferences.
		componentIndex      , # INTEGER - The index of the component.                                                
		topIsRelativeToStory  # BOOLEAN - Whether or not the component top is relative to a story.                   
		):
	'''
		Python: BOOLEAN = vs.SetCompTopIsRelStory(object, componentIndex, topIsRelativeToStory)
		VectorScript: FUNCTION SetCompTopIsRelStory(object:HANDLE; componentIndex:INTEGER; topIsRelativeToStory:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets whether or not the component top is relative to a story.
	'''
	pass
	return 'BOOLEAN' # 


def SetCompUseClassASF(
		object                                  , # HANDLE  - The object. Can be a roof face, roof, Roof Style, or the Roof Preferences.            
		componentIndex                          , # INTEGER - The index of the component.                                                           
		useClassFillStyleForAlternateSectionFill  # BOOLEAN - Whether or not the component will use class attributes for its alternate section fill.
		):
	'''
		Python: BOOLEAN = vs.SetCompUseClassASF(object, componentIndex, useClassFillStyleForAlternateSectionFill)
		VectorScript: FUNCTION SetCompUseClassASF(object:HANDLE; componentIndex:INTEGER; useClassFillStyleForAlternateSectionFill:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the use class fill style for alternate section fill flag of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetCompUseClassASFCl(
		object                                   , # HANDLE  - The object. Can be a roof face, roof, Roof Style, or the Roof Preferences.                   
		componentIndex                           , # INTEGER - The index of the component.                                                                  
		useClassFillColorsForAlternateSectionFill  # BOOLEAN - Whether or not the component will use class attributes for its alternate section fill colors.
		):
	'''
		Python: BOOLEAN = vs.SetCompUseClassASFCl(object, componentIndex, useClassFillColorsForAlternateSectionFill)
		VectorScript: FUNCTION SetCompUseClassASFCl(object:HANDLE; componentIndex:INTEGER; useClassFillColorsForAlternateSectionFill:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the use class fill colors for alternate section fill flag of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetCompUseClassFCl(
		object                   , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex           , # INTEGER - The index of the component.                                                                                                                                           
		useClassFillColorsForFill  # BOOLEAN - Whether or not the component will use class attributes for its fill colors.                                                                                           
		):
	'''
		Python: BOOLEAN = vs.SetCompUseClassFCl(object, componentIndex, useClassFillColorsForFill)
		VectorScript: FUNCTION SetCompUseClassFCl(object:HANDLE; componentIndex:INTEGER; useClassFillColorsForFill:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the use class fill colors for fill flag of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetCompUseClassFill(
		object                  , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex          , # INTEGER - The index of the component.                                                                                                                                           
		useClassFillStyleForFill  # BOOLEAN - Whether or not the component will use class attributes for its fill.                                                                                                  
		):
	'''
		Python: BOOLEAN = vs.SetCompUseClassFill(object, componentIndex, useClassFillStyleForFill)
		VectorScript: FUNCTION SetCompUseClassFill(object:HANDLE; componentIndex:INTEGER; useClassFillStyleForFill:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the use class fill style for fill flag of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetCompUseClassLPCl(
		object                     , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex             , # INTEGER - The index of the component.                                                                                                                                           
		useClassPenColorsForLeftPen  # BOOLEAN - Whether or not the component will use class attributes for its left pen colors.                                                                                       
		):
	'''
		Python: BOOLEAN = vs.SetCompUseClassLPCl(object, componentIndex, useClassPenColorsForLeftPen)
		VectorScript: FUNCTION SetCompUseClassLPCl(object:HANDLE; componentIndex:INTEGER; useClassPenColorsForLeftPen:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the use class pen colors for left pen flag of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetCompUseClassLPS(
		object                    , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex            , # INTEGER - The index of the component.                                                                                                                                           
		useClassPenStyleForLeftPen  # BOOLEAN - Whether or not the component will use class attributes for its left pen style.                                                                                        
		):
	'''
		Python: BOOLEAN = vs.SetCompUseClassLPS(object, componentIndex, useClassPenStyleForLeftPen)
		VectorScript: FUNCTION SetCompUseClassLPS(object:HANDLE; componentIndex:INTEGER; useClassPenStyleForLeftPen:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the use class pen style for left pen flag of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetCompUseClassLPW(
		object                     , # HANDLE  - The object. Can be a wall, round wall, slab, roof face, roof, Wall Style, Slab Style, Roof Style, the Wall Preferences, the Slab Preferences, or the Roof Preferences.
		componentIndex             , # INTEGER - The index of the component.                                                                                                                                           
		useClassPenWeightForLeftPen  # BOOLEAN - Whether or not the component will use class attributes for its left pen weight.                                                                                       
		):
	'''
		Python: BOOLEAN = vs.SetCompUseClassLPW(object, componentIndex, useClassPenWeightForLeftPen)
		VectorScript: FUNCTION SetCompUseClassLPW(object:HANDLE; componentIndex:INTEGER; useClassPenWeightForLeftPen:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the use class pen weight for left pen flag of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetCompUseClassRPCl(
		object                      , # HANDLE  - The object. Can be a wall, round wall, Wall Style, or the Wall Preferences.     
		componentIndex              , # INTEGER - The index of the component.                                                     
		useClassPenColorsForRightPen  # BOOLEAN - Whether or not the component will use class attributes for its right pen colors.
		):
	'''
		Python: BOOLEAN = vs.SetCompUseClassRPCl(object, componentIndex, useClassPenColorsForRightPen)
		VectorScript: FUNCTION SetCompUseClassRPCl(object:HANDLE; componentIndex:INTEGER; useClassPenColorsForRightPen:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the use class pen colors for right pen flag of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetCompUseClassRPS(
		object                     , # HANDLE  - The object. Can be a wall, round wall, Wall Style, or the Wall Preferences.    
		componentIndex             , # INTEGER - The index of the component.                                                    
		useClassPenStyleForRightPen  # BOOLEAN - Whether or not the component will use class attributes for its right pen style.
		):
	'''
		Python: BOOLEAN = vs.SetCompUseClassRPS(object, componentIndex, useClassPenStyleForRightPen)
		VectorScript: FUNCTION SetCompUseClassRPS(object:HANDLE; componentIndex:INTEGER; useClassPenStyleForRightPen:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the use class pen style for right pen flag of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetCompUseClassRPW(
		object                      , # HANDLE  - The object. Can be a wall, round wall, Wall Style, or the Wall Preferences.     
		componentIndex              , # INTEGER - The index of the component.                                                     
		useClassPenWeightForRightPen  # BOOLEAN - Whether or not the component will use class attributes for its right pen weight.
		):
	'''
		Python: BOOLEAN = vs.SetCompUseClassRPW(object, componentIndex, useClassPenWeightForRightPen)
		VectorScript: FUNCTION SetCompUseClassRPW(object:HANDLE; componentIndex:INTEGER; useClassPenWeightForRightPen:BOOLEAN) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the use class pen weight for right pen flag of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetCompWallAssBound(
		object             , # HANDLE  - The object. Can be a roof face, roof, Roof Style, or the Roof Preferences.                                                                                                                                                       
		componentIndex     , # INTEGER - The index of the component.                                                                                                                                                                                                      
		wallAssociatedBound  # INTEGER - The wall associated bound of the component.  0 - Inner face 1 - Outer face of inner component 2 - Inner face of core 3 - Center of core 4 - Outer face of core 5 - Inner face of outer component 6 - Roof edge 7 - Roof axis line
		):
	'''
		Python: BOOLEAN = vs.SetCompWallAssBound(object, componentIndex, wallAssociatedBound)
		VectorScript: FUNCTION SetCompWallAssBound(object:HANDLE; componentIndex:INTEGER; wallAssociatedBound:INTEGER) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the wall associated bound of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetCompWallAssMod(
		object                    , # HANDLE  - The object. Can be a roof face, roof, Roof Style, or the Roof Preferences.                      
		componentIndex            , # INTEGER - The index of the component.                                                                     
		wallAssociatedModification  # INTEGER - The wall associated modification of the component.  0 - None 1 - Clip walls 2 - Clipped by walls
		):
	'''
		Python: BOOLEAN = vs.SetCompWallAssMod(object, componentIndex, wallAssociatedModification)
		VectorScript: FUNCTION SetCompWallAssMod(object:HANDLE; componentIndex:INTEGER; wallAssociatedModification:INTEGER) : BOOLEAN;
		
		Category: Objects - Architectural
		Sets the wall associated modification of a component in an object.
	'''
	pass
	return 'BOOLEAN' # 


def SetConstrain(
		str  # STRING - Constraint constant string.
		):
	'''
		Python: vs.SetConstrain(str)
		VectorScript: PROCEDURE SetConstrain(str:STRING);
		
		Category: Document Settings
		Procedure SetConstrain sets the active drawing constraints for the document. Each constraint is represented by an ASCII character identifier; these characters are assembled into a string which determines the constraints to be activated.
	'''
	pass


def SetConstraintValue(
		constraint, # HANDLE - Handle to constraint being modified.
		value       # REAL   - New value for the constraint.       
		):
	'''
		Python: vs.SetConstraintValue(constraint, value)
		VectorScript: PROCEDURE SetConstraintValue(constraint:HANDLE; value:REAL);
		
		Category: Parametric Constraints
		Sets the referenced dimensional constraint to a new value.
	'''
	pass


def SetControlData(
		dialogID, # LONGINT - The index of the dialog containing the control.
		itemID  , # LONGINT - The index of the dialog control item.          
		data      # LONGINT - New data for the control item.                 
		):
	'''
		Python: vs.SetControlData(dialogID, itemID, data)
		VectorScript: PROCEDURE SetControlData(dialogID:LONGINT; itemID:LONGINT; data:LONGINT);
		
		Category: Dialogs - Modern
		Sets the data for the specified extended control item.
		In image controls, for example, this call can be used to set the ID of the image resource being displayed.
		This function can only be called from within the dialog event handler subroutine.
	'''
	pass


def SetControlText(
		DlogID , # INTEGER - ID of the dialog 
		ItemID , # INTEGER - ID of the control
		newtext  # STRING  - Text to insert   
		):
	'''
		Python: vs.SetControlText(DlogID, ItemID, newtext)
		VectorScript: PROCEDURE SetControlText(DlogID:INTEGER; ItemID:INTEGER; newtext:STRING);
		
		Category: Dialogs - Modern
		Sets the text of radio button, check box, push button controls.
	'''
	pass


def SetCoreWallComponent(
		object           , # HANDLE  - The object. Can be a wall, round wall, Wall Style, or the Wall Preferences.            
		coreWallComponent  # INTEGER - The index of the core wall component.  0 will cause there to be no core wall component.
		):
	'''
		Python: vs.SetCoreWallComponent(object, coreWallComponent)
		VectorScript: PROCEDURE SetCoreWallComponent(object:HANDLE; coreWallComponent:INTEGER);
		
		Category: Objects - Architectural
		Sets the core wall component of an object.
	'''
	pass


def SetCurrentObject(
		h  # HANDLE - Handle to object.
		):
	'''
		Python: vs.SetCurrentObject(h)
		VectorScript: PROCEDURE SetCurrentObject(h:HANDLE);
		
		Category: Utility
		Procedure SetCurrentObject sets the referenced object to be the current object of the document. The current object is defined as the last object created, and can be referenced by LNewObj.
	'''
	pass


def SetCursor(
		cursor  # INTEGER - Cursor style setting.
		):
	'''
		Python: vs.SetCursor(cursor)
		VectorScript: PROCEDURE SetCursor(cursor:INTEGER);
		
		Category: User Interactive
		Procedure SetCursor changes the appearance of the screen cursor.
	'''
	pass


def SetCurtainWallCutPl(
		wall               , # HANDLE - The wall.                              
		curtainWallCutPlane  # REAL   - The curtain wall cut plane of the wall.
		):
	'''
		Python: vs.SetCurtainWallCutPl(wall, curtainWallCutPlane)
		VectorScript: PROCEDURE SetCurtainWallCutPl(wall:HANDLE; curtainWallCutPlane:REAL);
		
		Category: Objects - Walls
		Sets the curtain wall cut plane of the wall.
	'''
	pass


def SetCustomFeedback(
		ParametricHandle, # HANDLE - The parametric object to which the feedback group will be added.
		FeedbackGroup     # HANDLE - The feedback group which will only display on screen.           
		):
	'''
		Python: Boolean = vs.SetCustomFeedback(ParametricHandle, FeedbackGroup)
		VectorScript: FUNCTION SetCustomFeedback(ParametricHandle:HANDLE; FeedbackGroup:HANDLE) : Boolean;
		
		Category: Objects - Custom
		Attaches a group of objects to a parametric used only for display on screen, this group will not export or print.
	'''
	pass
	return 'Boolean' # True if the feedback group was successfully added to the parametric, false if the object was not a parametric or the feedback objects were not a group.


def SetCustomObjectColor(
		objectHand , # HANDLE  - Handle to object.
		inTagID    , # INTEGER -                  
		inColoIndex  # INTEGER -                  
		):
	'''
		Python: BOOLEAN = vs.SetCustomObjectColor(objectHand, inTagID, inColoIndex)
		VectorScript: FUNCTION SetCustomObjectColor(objectHand:HANDLE; inTagID:INTEGER; inColoIndex:INTEGER) : BOOLEAN;
		
		Category: Objects - Custom
		Store/Set an auxilary color  index  in 'objectHand' so GetCustomObjectColor  can access it later.  Application will preserve the color mapped to inTagID.
	'''
	pass
	return 'BOOLEAN' # Returns TRUE if the operation was successful.


def SetCustomObjectPath(
		objectHand, # HANDLE - Handle to object.          
		path        # HANDLE - Handle to new path polygon.
		):
	'''
		Python: BOOLEAN = vs.SetCustomObjectPath(objectHand, path)
		VectorScript: FUNCTION SetCustomObjectPath(objectHand:HANDLE; path:HANDLE) : BOOLEAN;
		
		Category: Objects - Custom
		Replaces the path of an existing path plug-in object.  The path is used as-is; no translation of vertices is performed.
	'''
	pass
	return 'BOOLEAN' # Returns TRUE if the operation was successful.


def SetCustomObjectProfileGroup(
		objectHand      , # HANDLE - Handle to object.       
		profileGroupHand  # HANDLE - Handle to profile group.
		):
	'''
		Python: BOOLEAN = vs.SetCustomObjectProfileGroup(objectHand, profileGroupHand)
		VectorScript: FUNCTION SetCustomObjectProfileGroup(objectHand:HANDLE; profileGroupHand:HANDLE) : BOOLEAN;
		
		Category: Objects - Custom
		Sets the profile group for a path custom object.
	'''
	pass
	return 'BOOLEAN' # Returns TRUE if the operation was successful.


def SetCustomObjectSelectionGroup(
		objectHand, # HANDLE - Handle to parametric object.                                              
		selGroup    # HANDLE - Handle to object or group that contains geometry for selection indication.
		):
	'''
		Python: BOOLEAN = vs.SetCustomObjectSelectionGroup(objectHand, selGroup)
		VectorScript: FUNCTION SetCustomObjectSelectionGroup(objectHand:HANDLE; selGroup:HANDLE) : BOOLEAN;
		
		Category: Objects - Custom
		Set selection indication geometry for a parametric object.
	'''
	pass
	return 'BOOLEAN' # Returns TRUE if the operation was successful.


def SetCustomObjectWallHoleGroup(
		objectHand, # HANDLE - Handle to parametric object.                                   
		holeGroup   # HANDLE - Handle to object or group that contains geometry for wall hole.
		):
	'''
		Python: BOOLEAN = vs.SetCustomObjectWallHoleGroup(objectHand, holeGroup)
		VectorScript: FUNCTION SetCustomObjectWallHoleGroup(objectHand:HANDLE; holeGroup:HANDLE) : BOOLEAN;
		
		Category: Objects - Custom
		Set wall hole geometry for a parametric object.
	'''
	pass
	return 'BOOLEAN' # Returns TRUE if the operation was successful.


def SetCustomRWPrefs(
		):
	'''
		Python: (useTextures, useTransparency, useShadows, useRayTracing, useAntiAliasing, useDithering, tessellationDetail, shadowStyle, rayTracingRecursion) = vs.SetCustomRWPrefs()
		VectorScript: PROCEDURE SetCustomRWPrefs(VAR useTextures:BOOLEAN; VAR useTransparency:BOOLEAN; VAR useShadows:BOOLEAN; VAR useRayTracing:BOOLEAN; VAR useAntiAliasing:BOOLEAN; VAR useDithering:BOOLEAN; VAR tessellationDetail:INTEGER; VAR shadowStyle:INTEGER; VAR rayTracingRecursion:INTEGER);
		
		Category: Textures
		Sets the current custom RenderWorks rendering preferences from data passed in.
	'''
	pass
	return ( False, 
	         False, 
	         False, 
	         False, 
	         False, 
	         False, 
	         0    , 
	         0    , 
	         0     )


def SetDashLineTypeName(
		DashStyleIndex, # LONGINT - The negated internal index of the dash style to be named.
		DashStyleName   # STRING  - The new name of the line type.                           
		):
	'''
		Python: BOOLEAN = vs.SetDashLineTypeName(DashStyleIndex, DashStyleName)
		VectorScript: FUNCTION SetDashLineTypeName(DashStyleIndex:LONGINT; DashStyleName:STRING) : BOOLEAN;
		
		Category: Object Names
		Sets the dash style name for the specified dash style using its negated internal index.
	'''
	pass
	return 'BOOLEAN' # 'true' if the operation was successful.[[BR]]'false' otherwise.


def SetDashStyle(
		swt     , # BOOLEAN -  
		numPairs, # INTEGER -  
		pair1   , # POINT   -  
		pair2   , # POINT   -  
		pair3   , # POINT   -  
		pair4   , # POINT   -  
		pair5     # POINT   -  
		):
	'''
		Python: vs.SetDashStyle(swt, numPairs, pair1, pair2, pair3, pair4, pair5)
		VectorScript: PROCEDURE SetDashStyle(swt:BOOLEAN; numPairs:INTEGER; pair1DX, pair1DY:REAL; pair2DX, pair2DY:REAL; pair3DX, pair3DY:REAL; pair4DX, pair4DY:REAL; pair5DX, pair5DY:REAL);
		
		Category: Document Attributes
		Procedure SetDashStyle creates a new linestyle in a Vectorworks document. Parameter swt defines whether the linestyle will be scaled with thickness, and parameter numPairs specifies the number of length pairs defining the linestyle.
		The linestyle is defined by up to five black/white length pairs, which are specified in parameters b1,w1 through b5,w5. The minimum length of any given black or white parameter is 1 point, or 1/72 of an inch, and the line specification must be in pairs.
	'''
	pass


def SetDashStyleN(
		name    , # STRING  -  
		swt     , # BOOLEAN -  
		numPairs, # INTEGER -  
		pair1   , # POINT   -  
		pair2   , # POINT   -  
		pair3   , # POINT   -  
		pair4   , # POINT   -  
		pair5     # POINT   -  
		):
	'''
		Python: vs.SetDashStyleN(name, swt, numPairs, pair1, pair2, pair3, pair4, pair5)
		VectorScript: PROCEDURE SetDashStyleN(name:STRING; swt:BOOLEAN; numPairs:INTEGER; pair1DX, pair1DY:REAL; pair2DX, pair2DY:REAL; pair3DX, pair3DY:REAL; pair4DX, pair4DY:REAL; pair5DX, pair5DY:REAL);
		
		Category: Document Attributes
		Procedure SetDashStyleN creates a new linestyle in a Vectorworks document. Parameter name defines the name of the linestyle, parameter swt defines whether the linestyle will be scaled with thickness, and parameter numPairs specifies the number of length pairs defining the linestyle.
		The linestyle is defined by up to five black/white length pairs, which are specified in parameters b1,w1 through b5,w5. The minimum length of any given black or white parameter is 1 point, or 1/72 of an inch, and the line specification must be in pairs.
	'''
	pass


def SetDashStyleName(
		DashStyleIndex, # INTEGER - The index of the dash style to be named.              
		DashStyleName   # STRING  - The new name of the dash style specified by the index.
		):
	'''
		Python: BOOLEAN = vs.SetDashStyleName(DashStyleIndex, DashStyleName)
		VectorScript: FUNCTION SetDashStyleName(DashStyleIndex:INTEGER; DashStyleName:STRING) : BOOLEAN;
		
		Category: Object Names
		Deprecated - will generate error. Use SetDashLineTypeName instead.
	'''
	pass
	return 'BOOLEAN' # 


def SetDatumRoofComp(
		object            , # HANDLE  - The object. Can be a roof face, roof, Roof Style, or the Roof Preferences.
		datumRoofComponent  # INTEGER - The index of the datum roof component.                                    
		):
	'''
		Python: vs.SetDatumRoofComp(object, datumRoofComponent)
		VectorScript: PROCEDURE SetDatumRoofComp(object:HANDLE; datumRoofComponent:INTEGER);
		
		Category: Objects - Architectural
		Sets the datum roof component of the object.
	'''
	pass


def SetDatumSlabComponent(
		object            , # HANDLE  - The object. Can be a slab, Slab Style, or the Slab Preferences.
		datumSlabComponent  # INTEGER - The index of the datum slab component.                         
		):
	'''
		Python: vs.SetDatumSlabComponent(object, datumSlabComponent)
		VectorScript: PROCEDURE SetDatumSlabComponent(object:HANDLE; datumSlabComponent:INTEGE